# About vSphere Cloud Provider

Project Hatchway was the first VMware container project. It offered vSphere storage infrastructure choices, such as hyper-converged infrastructure (HCI) powered by VMware vSAN and traditional SAN and NAS storage, to container environments. Initially, the project included two distinct parts – one focusing on docker container volumes and the other focusing on Kubernetes. The purpose of both was to provision block VMDK volumes on vSphere storage to provide persistent storage for containerized applications running in a Container Orchestrator on vSphere. The vSphere Cloud Provider (VCP) is a Kubernetes solution and has been included as in-tree code since Kubernetes version v1.6.5. The vSphere Cloud Provider enables both static and dynamic consumption of vSphere storage for Kubernetes. It also integrates with Storage Policy Based Management, which allows persistent volumes to inherit and select capabilities of the underlying storage infrastructure, such as RAID levels, encryption, deduplication, compression, and so on.

The in-tree vSphere Cloud Provider can connect to vCenter Server to map information about your infrastructure, such as VMs, disks, and so on, back to the Kubernetes API. With the in-tree solution, the kubelet, kube-apiserver, and kube-controller-manager are natively aware of how to connect to vCenter Server if each component is provided with a valid config file and credentials. The content of the config file and how the credentials are shared is covered in the following chapters. For now, assume that every component has access to the config file and credentials that allow access to vCenter Server. The simplified diagram below illustrates which components in your cluster should be connecting to vCenter Server.

![vSphere In-Tree Cloud Provider Architecture](https://github.com/kubernetes/cloud-provider-vsphere/raw/master/docs/images/vsphere-in-tree-architecture.png "vSphere In-Tree Cloud Provider Architecture")
