// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: targets/targetspb/rpc.proto

package targetspb

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"

	io "io"
	math "math"
	math_bits "math/bits"
	time "time"

	labelpb "github.com/thanos-io/thanos/pkg/store/labelpb"
	storepb "github.com/thanos-io/thanos/pkg/store/storepb"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type TargetHealth int32

const (
	TargetHealth_DOWN TargetHealth = 0
	TargetHealth_UP   TargetHealth = 1
)

var TargetHealth_name = map[int32]string{
	0: "DOWN",
	1: "UP",
}

var TargetHealth_value = map[string]int32{
	"DOWN": 0,
	"UP":   1,
}

func (x TargetHealth) String() string {
	return proto.EnumName(TargetHealth_name, int32(x))
}

func (TargetHealth) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5cdaee03579e907, []int{0}
}

type TargetsRequest_State int32

const (
	TargetsRequest_ANY TargetsRequest_State = 0
	/// This will make sure strings.ToLower(.String()) will match 'active' and 'dropped' values for
	/// Prometheus HTTP API.
	TargetsRequest_ACTIVE  TargetsRequest_State = 1
	TargetsRequest_DROPPED TargetsRequest_State = 2
)

var TargetsRequest_State_name = map[int32]string{
	0: "ANY",
	1: "ACTIVE",
	2: "DROPPED",
}

var TargetsRequest_State_value = map[string]int32{
	"ANY":     0,
	"ACTIVE":  1,
	"DROPPED": 2,
}

func (x TargetsRequest_State) String() string {
	return proto.EnumName(TargetsRequest_State_name, int32(x))
}

func (TargetsRequest_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b5cdaee03579e907, []int{0, 0}
}

type TargetsRequest struct {
	State                   TargetsRequest_State            `protobuf:"varint,1,opt,name=state,proto3,enum=thanos.TargetsRequest_State" json:"state,omitempty"`
	PartialResponseStrategy storepb.PartialResponseStrategy `protobuf:"varint,2,opt,name=partial_response_strategy,json=partialResponseStrategy,proto3,enum=thanos.PartialResponseStrategy" json:"partial_response_strategy,omitempty"`
}

func (m *TargetsRequest) Reset()         { *m = TargetsRequest{} }
func (m *TargetsRequest) String() string { return proto.CompactTextString(m) }
func (*TargetsRequest) ProtoMessage()    {}
func (*TargetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5cdaee03579e907, []int{0}
}
func (m *TargetsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TargetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TargetsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TargetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetsRequest.Merge(m, src)
}
func (m *TargetsRequest) XXX_Size() int {
	return m.Size()
}
func (m *TargetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TargetsRequest proto.InternalMessageInfo

type TargetsResponse struct {
	// Types that are valid to be assigned to Result:
	//	*TargetsResponse_Targets
	//	*TargetsResponse_Warning
	Result isTargetsResponse_Result `protobuf_oneof:"result"`
}

func (m *TargetsResponse) Reset()         { *m = TargetsResponse{} }
func (m *TargetsResponse) String() string { return proto.CompactTextString(m) }
func (*TargetsResponse) ProtoMessage()    {}
func (*TargetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5cdaee03579e907, []int{1}
}
func (m *TargetsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TargetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TargetsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TargetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetsResponse.Merge(m, src)
}
func (m *TargetsResponse) XXX_Size() int {
	return m.Size()
}
func (m *TargetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TargetsResponse proto.InternalMessageInfo

type isTargetsResponse_Result interface {
	isTargetsResponse_Result()
	MarshalTo([]byte) (int, error)
	Size() int
}

type TargetsResponse_Targets struct {
	Targets *TargetDiscovery `protobuf:"bytes,1,opt,name=targets,proto3,oneof" json:"targets,omitempty"`
}
type TargetsResponse_Warning struct {
	Warning string `protobuf:"bytes,2,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (*TargetsResponse_Targets) isTargetsResponse_Result() {}
func (*TargetsResponse_Warning) isTargetsResponse_Result() {}

func (m *TargetsResponse) GetResult() isTargetsResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *TargetsResponse) GetTargets() *TargetDiscovery {
	if x, ok := m.GetResult().(*TargetsResponse_Targets); ok {
		return x.Targets
	}
	return nil
}

func (m *TargetsResponse) GetWarning() string {
	if x, ok := m.GetResult().(*TargetsResponse_Warning); ok {
		return x.Warning
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TargetsResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TargetsResponse_Targets)(nil),
		(*TargetsResponse_Warning)(nil),
	}
}

type TargetDiscovery struct {
	ActiveTargets  []*ActiveTarget  `protobuf:"bytes,1,rep,name=activeTargets,proto3" json:"activeTargets"`
	DroppedTargets []*DroppedTarget `protobuf:"bytes,2,rep,name=droppedTargets,proto3" json:"droppedTargets"`
}

func (m *TargetDiscovery) Reset()         { *m = TargetDiscovery{} }
func (m *TargetDiscovery) String() string { return proto.CompactTextString(m) }
func (*TargetDiscovery) ProtoMessage()    {}
func (*TargetDiscovery) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5cdaee03579e907, []int{2}
}
func (m *TargetDiscovery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TargetDiscovery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TargetDiscovery.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TargetDiscovery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetDiscovery.Merge(m, src)
}
func (m *TargetDiscovery) XXX_Size() int {
	return m.Size()
}
func (m *TargetDiscovery) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetDiscovery.DiscardUnknown(m)
}

var xxx_messageInfo_TargetDiscovery proto.InternalMessageInfo

type ActiveTarget struct {
	DiscoveredLabels   labelpb.ZLabelSet `protobuf:"bytes,1,opt,name=discoveredLabels,proto3" json:"discoveredLabels"`
	Labels             labelpb.ZLabelSet `protobuf:"bytes,2,opt,name=labels,proto3" json:"labels"`
	ScrapePool         string            `protobuf:"bytes,3,opt,name=scrapePool,proto3" json:"scrapePool"`
	ScrapeUrl          string            `protobuf:"bytes,4,opt,name=scrapeUrl,proto3" json:"scrapeUrl"`
	GlobalUrl          string            `protobuf:"bytes,5,opt,name=globalUrl,proto3" json:"globalUrl"`
	LastError          string            `protobuf:"bytes,6,opt,name=lastError,proto3" json:"lastError"`
	LastScrape         time.Time         `protobuf:"bytes,7,opt,name=lastScrape,proto3,stdtime" json:"lastScrape"`
	LastScrapeDuration float64           `protobuf:"fixed64,8,opt,name=lastScrapeDuration,proto3" json:"lastScrapeDuration"`
	Health             TargetHealth      `protobuf:"varint,9,opt,name=health,proto3,enum=thanos.TargetHealth" json:"health"`
}

func (m *ActiveTarget) Reset()         { *m = ActiveTarget{} }
func (m *ActiveTarget) String() string { return proto.CompactTextString(m) }
func (*ActiveTarget) ProtoMessage()    {}
func (*ActiveTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5cdaee03579e907, []int{3}
}
func (m *ActiveTarget) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ActiveTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ActiveTarget.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ActiveTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActiveTarget.Merge(m, src)
}
func (m *ActiveTarget) XXX_Size() int {
	return m.Size()
}
func (m *ActiveTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_ActiveTarget.DiscardUnknown(m)
}

var xxx_messageInfo_ActiveTarget proto.InternalMessageInfo

type DroppedTarget struct {
	DiscoveredLabels labelpb.ZLabelSet `protobuf:"bytes,1,opt,name=discoveredLabels,proto3" json:"discoveredLabels"`
}

func (m *DroppedTarget) Reset()         { *m = DroppedTarget{} }
func (m *DroppedTarget) String() string { return proto.CompactTextString(m) }
func (*DroppedTarget) ProtoMessage()    {}
func (*DroppedTarget) Descriptor() ([]byte, []int) {
	return fileDescriptor_b5cdaee03579e907, []int{4}
}
func (m *DroppedTarget) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DroppedTarget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DroppedTarget.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DroppedTarget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DroppedTarget.Merge(m, src)
}
func (m *DroppedTarget) XXX_Size() int {
	return m.Size()
}
func (m *DroppedTarget) XXX_DiscardUnknown() {
	xxx_messageInfo_DroppedTarget.DiscardUnknown(m)
}

var xxx_messageInfo_DroppedTarget proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("thanos.TargetHealth", TargetHealth_name, TargetHealth_value)
	proto.RegisterEnum("thanos.TargetsRequest_State", TargetsRequest_State_name, TargetsRequest_State_value)
	proto.RegisterType((*TargetsRequest)(nil), "thanos.TargetsRequest")
	proto.RegisterType((*TargetsResponse)(nil), "thanos.TargetsResponse")
	proto.RegisterType((*TargetDiscovery)(nil), "thanos.TargetDiscovery")
	proto.RegisterType((*ActiveTarget)(nil), "thanos.ActiveTarget")
	proto.RegisterType((*DroppedTarget)(nil), "thanos.DroppedTarget")
}

func init() { proto.RegisterFile("targets/targetspb/rpc.proto", fileDescriptor_b5cdaee03579e907) }

var fileDescriptor_b5cdaee03579e907 = []byte{
	// 694 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x54, 0x41, 0x4f, 0xdb, 0x4a,
	0x10, 0xb6, 0x03, 0x38, 0x64, 0x80, 0xbc, 0xb0, 0xe2, 0x81, 0xc9, 0x7b, 0x8a, 0x51, 0x2e, 0x8f,
	0xd7, 0x4a, 0x4e, 0x15, 0x2e, 0xad, 0xd4, 0x0b, 0x6e, 0x68, 0xa9, 0xd4, 0x42, 0xba, 0x09, 0x45,
	0xa5, 0x07, 0xb4, 0x49, 0xb6, 0x4e, 0x24, 0x93, 0x75, 0x77, 0x37, 0x54, 0xfc, 0x0b, 0xfe, 0x49,
	0x0f, 0xfd, 0x13, 0x1c, 0x7a, 0xe0, 0xd8, 0x93, 0xdb, 0xc2, 0x2d, 0xbf, 0xa2, 0xf2, 0xda, 0x8e,
	0x1d, 0x48, 0x8f, 0xbd, 0x78, 0x67, 0xbe, 0xf9, 0xe6, 0x9b, 0x59, 0xef, 0xce, 0xc2, 0x3f, 0x92,
	0x70, 0x97, 0x4a, 0x51, 0x8b, 0x57, 0xbf, 0x53, 0xe3, 0x7e, 0xd7, 0xf6, 0x39, 0x93, 0x0c, 0x19,
	0xb2, 0x4f, 0x86, 0x4c, 0x94, 0x37, 0x85, 0x64, 0x9c, 0xd6, 0xd4, 0xd7, 0xef, 0xd4, 0xe4, 0x85,
	0x4f, 0x45, 0x44, 0x29, 0xaf, 0xb9, 0xcc, 0x65, 0xca, 0xac, 0x85, 0x56, 0x8c, 0xc6, 0x09, 0x1e,
	0xe9, 0x50, 0xef, 0x4e, 0x82, 0xe5, 0x32, 0xe6, 0x7a, 0xb4, 0xa6, 0xbc, 0xce, 0xe8, 0x43, 0x4d,
	0x0e, 0xce, 0xa8, 0x90, 0xe4, 0xcc, 0x8f, 0x08, 0xd5, 0xaf, 0x3a, 0x14, 0xdb, 0x51, 0x33, 0x98,
	0x7e, 0x1c, 0x51, 0x21, 0x51, 0x1d, 0x16, 0x84, 0x24, 0x92, 0x9a, 0xfa, 0x96, 0xbe, 0x5d, 0xac,
	0xff, 0x6b, 0x47, 0x7d, 0xd9, 0xd3, 0x34, 0xbb, 0x15, 0x72, 0x70, 0x44, 0x45, 0xef, 0x61, 0xd3,
	0x27, 0x5c, 0x0e, 0x88, 0x77, 0xca, 0xa9, 0xf0, 0xd9, 0x50, 0xd0, 0x53, 0x21, 0x39, 0x91, 0xd4,
	0xbd, 0x30, 0x73, 0x4a, 0xc7, 0x4a, 0x74, 0x9a, 0x11, 0x11, 0xc7, 0xbc, 0x56, 0x4c, 0xc3, 0x1b,
	0xfe, 0xec, 0x40, 0xf5, 0x7f, 0x58, 0x50, 0xc5, 0x50, 0x1e, 0xe6, 0x76, 0x0f, 0xde, 0x95, 0x34,
	0x04, 0x60, 0xec, 0x3e, 0x6b, 0xbf, 0x7c, 0xbb, 0x57, 0xd2, 0xd1, 0x12, 0xe4, 0x1b, 0xf8, 0xb0,
	0xd9, 0xdc, 0x6b, 0x94, 0x72, 0x55, 0x0f, 0xfe, 0x9a, 0xb4, 0x19, 0xa9, 0xa0, 0x1d, 0xc8, 0xc7,
	0x7f, 0x5b, 0x6d, 0x68, 0xa9, 0xbe, 0x31, 0xbd, 0xa1, 0xc6, 0x40, 0x74, 0xd9, 0x39, 0xe5, 0x17,
	0xfb, 0x1a, 0x4e, 0x98, 0xa8, 0x0c, 0xf9, 0x4f, 0x84, 0x0f, 0x07, 0x43, 0x57, 0x75, 0x5f, 0x08,
	0x63, 0x31, 0xe0, 0x2c, 0x82, 0xc1, 0xa9, 0x18, 0x79, 0xb2, 0xfa, 0x45, 0x4f, 0xca, 0x4d, 0x44,
	0xd0, 0x6b, 0x58, 0x21, 0x5d, 0x39, 0x38, 0xa7, 0xed, 0x49, 0xd1, 0xb9, 0xed, 0xa5, 0xfa, 0x5a,
	0x52, 0x74, 0x37, 0x13, 0x74, 0x56, 0xc7, 0x81, 0x35, 0x4d, 0xc7, 0xd3, 0x2e, 0x7a, 0x03, 0xc5,
	0x1e, 0x67, 0xbe, 0x4f, 0x7b, 0x89, 0x5e, 0x4e, 0xe9, 0xfd, 0x9d, 0xe8, 0x35, 0xb2, 0x51, 0x07,
	0x8d, 0x03, 0xeb, 0x4e, 0x02, 0xbe, 0xe3, 0x57, 0x3f, 0xcf, 0xc3, 0x72, 0xb6, 0x0b, 0x74, 0x0c,
	0xa5, 0x5e, 0xdc, 0x3f, 0xed, 0xbd, 0x0a, 0x6f, 0x51, 0xf2, 0xab, 0x56, 0x93, 0x2a, 0x27, 0x0a,
	0x6e, 0x51, 0xe9, 0x98, 0x57, 0x81, 0xa5, 0x8d, 0x03, 0xeb, 0x5e, 0x0a, 0xbe, 0x87, 0xa0, 0x27,
	0x60, 0x78, 0x91, 0x5c, 0xee, 0x77, 0x72, 0xc5, 0x58, 0x2e, 0x26, 0xe2, 0x78, 0x45, 0x36, 0x80,
	0xe8, 0x72, 0xe2, 0xd3, 0x26, 0x63, 0x9e, 0x39, 0x17, 0x9e, 0x81, 0x53, 0x1c, 0x07, 0x56, 0x06,
	0xc5, 0x19, 0x1b, 0x3d, 0x84, 0x42, 0xe4, 0x1d, 0x71, 0xcf, 0x9c, 0x57, 0xf4, 0x95, 0x71, 0x60,
	0xa5, 0x20, 0x4e, 0xcd, 0x90, 0xec, 0x7a, 0xac, 0x43, 0xbc, 0x90, 0xbc, 0x90, 0x92, 0x27, 0x20,
	0x4e, 0xcd, 0x90, 0xec, 0x11, 0x21, 0xf7, 0x38, 0x67, 0xdc, 0x34, 0x52, 0xf2, 0x04, 0xc4, 0xa9,
	0x89, 0x30, 0x40, 0xe8, 0xb4, 0x54, 0x29, 0x33, 0xaf, 0x76, 0x5d, 0xb6, 0xa3, 0x21, 0xb4, 0x93,
	0x21, 0xb4, 0xdb, 0xc9, 0x10, 0x3a, 0xeb, 0xf1, 0xf6, 0x33, 0x59, 0x97, 0xdf, 0x2d, 0x1d, 0x67,
	0x7c, 0xf4, 0x1c, 0x50, 0xea, 0x35, 0x46, 0x9c, 0xc8, 0x01, 0x1b, 0x9a, 0x8b, 0x5b, 0xfa, 0xb6,
	0xee, 0xac, 0x8f, 0x03, 0x6b, 0x46, 0x14, 0xcf, 0xc0, 0xd0, 0x63, 0x30, 0xfa, 0x94, 0x78, 0xb2,
	0x6f, 0x16, 0xd4, 0x40, 0xae, 0x4d, 0xcf, 0xc1, 0xbe, 0x8a, 0x39, 0x10, 0x1e, 0x46, 0xc4, 0xc3,
	0xf1, 0x5a, 0xed, 0xc3, 0xca, 0xd4, 0x35, 0xfb, 0x63, 0x37, 0xe6, 0xc1, 0x16, 0x2c, 0x67, 0xbb,
	0x41, 0x8b, 0x30, 0xdf, 0x38, 0x3c, 0x3e, 0x28, 0x69, 0xc8, 0x80, 0xdc, 0x51, 0xb3, 0xa4, 0xd7,
	0x5f, 0x40, 0x3e, 0x99, 0x8d, 0xa7, 0xa9, 0xb9, 0x3e, 0xfb, 0x91, 0x2a, 0x6f, 0xdc, 0xc3, 0xa3,
	0x57, 0xe1, 0x91, 0xee, 0xfc, 0x77, 0xf5, 0xb3, 0xa2, 0x5d, 0xdd, 0x54, 0xf4, 0xeb, 0x9b, 0x8a,
	0xfe, 0xe3, 0xa6, 0xa2, 0x5f, 0xde, 0x56, 0xb4, 0xeb, 0xdb, 0x8a, 0xf6, 0xed, 0xb6, 0xa2, 0x9d,
	0x14, 0x26, 0x2f, 0x74, 0xc7, 0x50, 0xe7, 0xb6, 0xf3, 0x2b, 0x00, 0x00, 0xff, 0xff, 0xf2, 0x61,
	0x2b, 0xab, 0xbd, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// TargetsClient is the client API for Targets service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TargetsClient interface {
	/// Targets has info for all targets.
	/// Returned targets are expected to include external labels.
	Targets(ctx context.Context, in *TargetsRequest, opts ...grpc.CallOption) (Targets_TargetsClient, error)
}

type targetsClient struct {
	cc *grpc.ClientConn
}

func NewTargetsClient(cc *grpc.ClientConn) TargetsClient {
	return &targetsClient{cc}
}

func (c *targetsClient) Targets(ctx context.Context, in *TargetsRequest, opts ...grpc.CallOption) (Targets_TargetsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Targets_serviceDesc.Streams[0], "/thanos.Targets/Targets", opts...)
	if err != nil {
		return nil, err
	}
	x := &targetsTargetsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Targets_TargetsClient interface {
	Recv() (*TargetsResponse, error)
	grpc.ClientStream
}

type targetsTargetsClient struct {
	grpc.ClientStream
}

func (x *targetsTargetsClient) Recv() (*TargetsResponse, error) {
	m := new(TargetsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TargetsServer is the server API for Targets service.
type TargetsServer interface {
	/// Targets has info for all targets.
	/// Returned targets are expected to include external labels.
	Targets(*TargetsRequest, Targets_TargetsServer) error
}

// UnimplementedTargetsServer can be embedded to have forward compatible implementations.
type UnimplementedTargetsServer struct {
}

func (*UnimplementedTargetsServer) Targets(req *TargetsRequest, srv Targets_TargetsServer) error {
	return status.Errorf(codes.Unimplemented, "method Targets not implemented")
}

func RegisterTargetsServer(s *grpc.Server, srv TargetsServer) {
	s.RegisterService(&_Targets_serviceDesc, srv)
}

func _Targets_Targets_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TargetsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TargetsServer).Targets(m, &targetsTargetsServer{stream})
}

type Targets_TargetsServer interface {
	Send(*TargetsResponse) error
	grpc.ServerStream
}

type targetsTargetsServer struct {
	grpc.ServerStream
}

func (x *targetsTargetsServer) Send(m *TargetsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _Targets_serviceDesc = grpc.ServiceDesc{
	ServiceName: "thanos.Targets",
	HandlerType: (*TargetsServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Targets",
			Handler:       _Targets_Targets_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "targets/targetspb/rpc.proto",
}

func (m *TargetsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TargetsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TargetsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.PartialResponseStrategy != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.PartialResponseStrategy))
		i--
		dAtA[i] = 0x10
	}
	if m.State != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TargetsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TargetsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TargetsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size := m.Result.Size()
			i -= size
			if _, err := m.Result.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *TargetsResponse_Targets) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TargetsResponse_Targets) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Targets != nil {
		{
			size, err := m.Targets.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *TargetsResponse_Warning) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TargetsResponse_Warning) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Warning)
	copy(dAtA[i:], m.Warning)
	i = encodeVarintRpc(dAtA, i, uint64(len(m.Warning)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *TargetDiscovery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TargetDiscovery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TargetDiscovery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DroppedTargets) > 0 {
		for iNdEx := len(m.DroppedTargets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DroppedTargets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ActiveTargets) > 0 {
		for iNdEx := len(m.ActiveTargets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ActiveTargets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ActiveTarget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ActiveTarget) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ActiveTarget) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Health != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Health))
		i--
		dAtA[i] = 0x48
	}
	if m.LastScrapeDuration != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.LastScrapeDuration))))
		i--
		dAtA[i] = 0x41
	}
	n2, err2 := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.LastScrape, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdTime(m.LastScrape):])
	if err2 != nil {
		return 0, err2
	}
	i -= n2
	i = encodeVarintRpc(dAtA, i, uint64(n2))
	i--
	dAtA[i] = 0x3a
	if len(m.LastError) > 0 {
		i -= len(m.LastError)
		copy(dAtA[i:], m.LastError)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.LastError)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.GlobalUrl) > 0 {
		i -= len(m.GlobalUrl)
		copy(dAtA[i:], m.GlobalUrl)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.GlobalUrl)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ScrapeUrl) > 0 {
		i -= len(m.ScrapeUrl)
		copy(dAtA[i:], m.ScrapeUrl)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ScrapeUrl)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ScrapePool) > 0 {
		i -= len(m.ScrapePool)
		copy(dAtA[i:], m.ScrapePool)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.ScrapePool)))
		i--
		dAtA[i] = 0x1a
	}
	{
		size, err := m.Labels.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintRpc(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.DiscoveredLabels.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintRpc(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *DroppedTarget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DroppedTarget) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DroppedTarget) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.DiscoveredLabels.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintRpc(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintRpc(dAtA []byte, offset int, v uint64) int {
	offset -= sovRpc(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *TargetsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovRpc(uint64(m.State))
	}
	if m.PartialResponseStrategy != 0 {
		n += 1 + sovRpc(uint64(m.PartialResponseStrategy))
	}
	return n
}

func (m *TargetsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *TargetsResponse_Targets) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Targets != nil {
		l = m.Targets.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *TargetsResponse_Warning) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Warning)
	n += 1 + l + sovRpc(uint64(l))
	return n
}
func (m *TargetDiscovery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ActiveTargets) > 0 {
		for _, e := range m.ActiveTargets {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if len(m.DroppedTargets) > 0 {
		for _, e := range m.DroppedTargets {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	return n
}

func (m *ActiveTarget) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.DiscoveredLabels.Size()
	n += 1 + l + sovRpc(uint64(l))
	l = m.Labels.Size()
	n += 1 + l + sovRpc(uint64(l))
	l = len(m.ScrapePool)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.ScrapeUrl)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.GlobalUrl)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = len(m.LastError)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.LastScrape)
	n += 1 + l + sovRpc(uint64(l))
	if m.LastScrapeDuration != 0 {
		n += 9
	}
	if m.Health != 0 {
		n += 1 + sovRpc(uint64(m.Health))
	}
	return n
}

func (m *DroppedTarget) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.DiscoveredLabels.Size()
	n += 1 + l + sovRpc(uint64(l))
	return n
}

func sovRpc(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRpc(x uint64) (n int) {
	return sovRpc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *TargetsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TargetsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TargetsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= TargetsRequest_State(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseStrategy", wireType)
			}
			m.PartialResponseStrategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PartialResponseStrategy |= storepb.PartialResponseStrategy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TargetsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TargetsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TargetsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Targets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TargetDiscovery{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &TargetsResponse_Targets{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warning", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = &TargetsResponse_Warning{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TargetDiscovery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TargetDiscovery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TargetDiscovery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveTargets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveTargets = append(m.ActiveTargets, &ActiveTarget{})
			if err := m.ActiveTargets[len(m.ActiveTargets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedTargets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DroppedTargets = append(m.DroppedTargets, &DroppedTarget{})
			if err := m.DroppedTargets[len(m.DroppedTargets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ActiveTarget) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ActiveTarget: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ActiveTarget: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscoveredLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DiscoveredLabels.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Labels.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScrapePool", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScrapePool = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScrapeUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ScrapeUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GlobalUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GlobalUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastError", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastError = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastScrape", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.LastScrape, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastScrapeDuration", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.LastScrapeDuration = float64(math.Float64frombits(v))
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Health", wireType)
			}
			m.Health = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Health |= TargetHealth(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DroppedTarget) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DroppedTarget: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DroppedTarget: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscoveredLabels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DiscoveredLabels.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRpc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRpc
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRpc
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRpc
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRpc        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRpc          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRpc = fmt.Errorf("proto: unexpected end of group")
)
