// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/networkmanagement/v1/connectivity_test.proto

package networkmanagement

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type definition of an endpoint's network. Use one of the
// following choices:
type Endpoint_NetworkType int32

const (
	// Default type if unspecified.
	Endpoint_NETWORK_TYPE_UNSPECIFIED Endpoint_NetworkType = 0
	// A network hosted within Google Cloud Platform.
	// To receive more detailed output, specify the URI for the source or
	// destination network.
	Endpoint_GCP_NETWORK Endpoint_NetworkType = 1
	// A network hosted outside of Google Cloud Platform.
	// This can be an on-premises network, or a network hosted by another cloud
	// provider.
	Endpoint_NON_GCP_NETWORK Endpoint_NetworkType = 2
)

// Enum value maps for Endpoint_NetworkType.
var (
	Endpoint_NetworkType_name = map[int32]string{
		0: "NETWORK_TYPE_UNSPECIFIED",
		1: "GCP_NETWORK",
		2: "NON_GCP_NETWORK",
	}
	Endpoint_NetworkType_value = map[string]int32{
		"NETWORK_TYPE_UNSPECIFIED": 0,
		"GCP_NETWORK":              1,
		"NON_GCP_NETWORK":          2,
	}
)

func (x Endpoint_NetworkType) Enum() *Endpoint_NetworkType {
	p := new(Endpoint_NetworkType)
	*p = x
	return p
}

func (x Endpoint_NetworkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Endpoint_NetworkType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_connectivity_test_proto_enumTypes[0].Descriptor()
}

func (Endpoint_NetworkType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_connectivity_test_proto_enumTypes[0]
}

func (x Endpoint_NetworkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Endpoint_NetworkType.Descriptor instead.
func (Endpoint_NetworkType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescGZIP(), []int{1, 0}
}

// The overall result of the test's configuration analysis.
type ReachabilityDetails_Result int32

const (
	// No result was specified.
	ReachabilityDetails_RESULT_UNSPECIFIED ReachabilityDetails_Result = 0
	// Possible scenarios are:
	//
	// * The configuration analysis determined that a packet originating from
	//   the source is expected to reach the destination.
	// * The analysis didn't complete because the user lacks permission for
	//   some of the resources in the trace. However, at the time the user's
	//   permission became insufficient, the trace had been successful so far.
	ReachabilityDetails_REACHABLE ReachabilityDetails_Result = 1
	// A packet originating from the source is expected to be dropped before
	// reaching the destination.
	ReachabilityDetails_UNREACHABLE ReachabilityDetails_Result = 2
	// The source and destination endpoints do not uniquely identify
	// the test location in the network, and the reachability result contains
	// multiple traces. For some traces, a packet could be delivered, and for
	// others, it would not be.
	ReachabilityDetails_AMBIGUOUS ReachabilityDetails_Result = 4
	// The configuration analysis did not complete. Possible reasons are:
	//
	// * A permissions error occurred--for example, the user might not have
	//   read permission for all of the resources named in the test.
	// * An internal error occurred.
	// * The analyzer received an invalid or unsupported argument or was unable
	//   to identify a known endpoint.
	ReachabilityDetails_UNDETERMINED ReachabilityDetails_Result = 5
)

// Enum value maps for ReachabilityDetails_Result.
var (
	ReachabilityDetails_Result_name = map[int32]string{
		0: "RESULT_UNSPECIFIED",
		1: "REACHABLE",
		2: "UNREACHABLE",
		4: "AMBIGUOUS",
		5: "UNDETERMINED",
	}
	ReachabilityDetails_Result_value = map[string]int32{
		"RESULT_UNSPECIFIED": 0,
		"REACHABLE":          1,
		"UNREACHABLE":        2,
		"AMBIGUOUS":          4,
		"UNDETERMINED":       5,
	}
)

func (x ReachabilityDetails_Result) Enum() *ReachabilityDetails_Result {
	p := new(ReachabilityDetails_Result)
	*p = x
	return p
}

func (x ReachabilityDetails_Result) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReachabilityDetails_Result) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_connectivity_test_proto_enumTypes[1].Descriptor()
}

func (ReachabilityDetails_Result) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_connectivity_test_proto_enumTypes[1]
}

func (x ReachabilityDetails_Result) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReachabilityDetails_Result.Descriptor instead.
func (ReachabilityDetails_Result) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescGZIP(), []int{2, 0}
}

// A Connectivity Test for a network reachability analysis.
type ConnectivityTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Unique name of the resource using the form:
	//     `projects/{project_id}/locations/global/connectivityTests/{test_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The user-supplied description of the Connectivity Test.
	// Maximum of 512 characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Source specification of the Connectivity Test.
	//
	// You can use a combination of source IP address, virtual machine
	// (VM) instance, or Compute Engine network to uniquely identify
	// the source location.
	//
	// Examples:
	// If the source IP address is an internal IP address within a Google Cloud
	// Virtual Private Cloud (VPC) network, then you must also specify the VPC
	// network. Otherwise, specify the VM instance, which already contains its
	// internal IP address and VPC network information.
	//
	// If the source of the test is within an on-premises network, then you must
	// provide the destination VPC network.
	//
	// If the source endpoint is a Compute Engine VM instance with multiple
	// network interfaces, the instance itself is not sufficient to identify the
	// endpoint. So, you must also specify the source IP address or VPC network.
	//
	// A reachability analysis proceeds even if the source location is
	// ambiguous. However, the test result may include endpoints that you don't
	// intend to test.
	Source *Endpoint `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	// Required. Destination specification of the Connectivity Test.
	//
	// You can use a combination of destination IP address, Compute Engine
	// VM instance, or VPC network to uniquely identify the destination
	// location.
	//
	// Even if the destination IP address is not unique, the source IP
	// location is unique. Usually, the analysis can infer the destination
	// endpoint from route information.
	//
	// If the destination you specify is a VM instance and the instance has
	// multiple network interfaces, then you must also specify either
	// a destination IP address  or VPC network to identify the destination
	// interface.
	//
	// A reachability analysis proceeds even if the destination location is
	// ambiguous. However, the result can include endpoints that you don't
	// intend to test.
	Destination *Endpoint `protobuf:"bytes,4,opt,name=destination,proto3" json:"destination,omitempty"`
	// IP Protocol of the test. When not provided, "TCP" is assumed.
	Protocol string `protobuf:"bytes,5,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Other projects that may be relevant for reachability analysis.
	// This is applicable to scenarios where a test can cross project boundaries.
	RelatedProjects []string `protobuf:"bytes,6,rep,name=related_projects,json=relatedProjects,proto3" json:"related_projects,omitempty"`
	// Output only. The display name of a Connectivity Test.
	DisplayName string `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Resource labels to represent user-provided metadata.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The time the test was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the test's configuration was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The reachability details of this test from the latest run.
	// The details are updated when creating a new test, updating an
	// existing test, or triggering a one-time rerun of an existing test.
	ReachabilityDetails *ReachabilityDetails `protobuf:"bytes,12,opt,name=reachability_details,json=reachabilityDetails,proto3" json:"reachability_details,omitempty"`
}

func (x *ConnectivityTest) Reset() {
	*x = ConnectivityTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_connectivity_test_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectivityTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectivityTest) ProtoMessage() {}

func (x *ConnectivityTest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_connectivity_test_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectivityTest.ProtoReflect.Descriptor instead.
func (*ConnectivityTest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescGZIP(), []int{0}
}

func (x *ConnectivityTest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConnectivityTest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ConnectivityTest) GetSource() *Endpoint {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *ConnectivityTest) GetDestination() *Endpoint {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *ConnectivityTest) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *ConnectivityTest) GetRelatedProjects() []string {
	if x != nil {
		return x.RelatedProjects
	}
	return nil
}

func (x *ConnectivityTest) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ConnectivityTest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ConnectivityTest) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ConnectivityTest) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ConnectivityTest) GetReachabilityDetails() *ReachabilityDetails {
	if x != nil {
		return x.ReachabilityDetails
	}
	return nil
}

// Source or destination of the Connectivity Test.
type Endpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IP address of the endpoint, which can be an external or internal IP.
	// An IPv6 address is only allowed when the test's destination is a
	// [global load balancer VIP](/load-balancing/docs/load-balancing-overview).
	IpAddress string `protobuf:"bytes,1,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// The IP protocol port of the endpoint.
	// Only applicable when protocol is TCP or UDP.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// A Compute Engine instance URI.
	Instance string `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	// A cluster URI for [Google Kubernetes Engine
	// master](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
	GkeMasterCluster string `protobuf:"bytes,7,opt,name=gke_master_cluster,json=gkeMasterCluster,proto3" json:"gke_master_cluster,omitempty"`
	// A [Cloud SQL](https://cloud.google.com/sql) instance URI.
	CloudSqlInstance string `protobuf:"bytes,8,opt,name=cloud_sql_instance,json=cloudSqlInstance,proto3" json:"cloud_sql_instance,omitempty"`
	// A Compute Engine network URI.
	Network string `protobuf:"bytes,4,opt,name=network,proto3" json:"network,omitempty"`
	// Type of the network where the endpoint is located.
	// Applicable only to source endpoint, as destination network type can be
	// inferred from the source.
	NetworkType Endpoint_NetworkType `protobuf:"varint,5,opt,name=network_type,json=networkType,proto3,enum=google.cloud.networkmanagement.v1.Endpoint_NetworkType" json:"network_type,omitempty"`
	// Project ID where the endpoint is located.
	// The Project ID can be derived from the URI if you provide a VM instance or
	// network URI.
	// The following are two cases where you must provide the project ID:
	// 1. Only the IP address is specified, and the IP address is within a GCP
	// project.
	// 2. When you are using Shared VPC and the IP address that you provide is
	// from the service project. In this case, the network that the IP address
	// resides in is defined in the host project.
	ProjectId string `protobuf:"bytes,6,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *Endpoint) Reset() {
	*x = Endpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_connectivity_test_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Endpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Endpoint) ProtoMessage() {}

func (x *Endpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_connectivity_test_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Endpoint.ProtoReflect.Descriptor instead.
func (*Endpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescGZIP(), []int{1}
}

func (x *Endpoint) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *Endpoint) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *Endpoint) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *Endpoint) GetGkeMasterCluster() string {
	if x != nil {
		return x.GkeMasterCluster
	}
	return ""
}

func (x *Endpoint) GetCloudSqlInstance() string {
	if x != nil {
		return x.CloudSqlInstance
	}
	return ""
}

func (x *Endpoint) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Endpoint) GetNetworkType() Endpoint_NetworkType {
	if x != nil {
		return x.NetworkType
	}
	return Endpoint_NETWORK_TYPE_UNSPECIFIED
}

func (x *Endpoint) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Results of the configuration analysis from the last run of the test.
type ReachabilityDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overall result of the test's configuration analysis.
	Result ReachabilityDetails_Result `protobuf:"varint,1,opt,name=result,proto3,enum=google.cloud.networkmanagement.v1.ReachabilityDetails_Result" json:"result,omitempty"`
	// The time of the configuration analysis.
	VerifyTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=verify_time,json=verifyTime,proto3" json:"verify_time,omitempty"`
	// The details of a failure or a cancellation of reachability analysis.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	// Result may contain a list of traces if a test has multiple possible
	// paths in the network, such as when destination endpoint is a load balancer
	// with multiple backends.
	Traces []*Trace `protobuf:"bytes,5,rep,name=traces,proto3" json:"traces,omitempty"`
}

func (x *ReachabilityDetails) Reset() {
	*x = ReachabilityDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_connectivity_test_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReachabilityDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReachabilityDetails) ProtoMessage() {}

func (x *ReachabilityDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_connectivity_test_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReachabilityDetails.ProtoReflect.Descriptor instead.
func (*ReachabilityDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescGZIP(), []int{2}
}

func (x *ReachabilityDetails) GetResult() ReachabilityDetails_Result {
	if x != nil {
		return x.Result
	}
	return ReachabilityDetails_RESULT_UNSPECIFIED
}

func (x *ReachabilityDetails) GetVerifyTime() *timestamppb.Timestamp {
	if x != nil {
		return x.VerifyTime
	}
	return nil
}

func (x *ReachabilityDetails) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ReachabilityDetails) GetTraces() []*Trace {
	if x != nil {
		return x.Traces
	}
	return nil
}

var File_google_cloud_networkmanagement_v1_connectivity_test_proto protoreflect.FileDescriptor

var file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x5f, 0x74, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xd8, 0x06, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69,
	0x74, 0x79, 0x54, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x48, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x52, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x29, 0x0a, 0x10, 0x72,
	0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x57,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x54,
	0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6e, 0x0a, 0x14, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a, 0x31, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x54, 0x65, 0x73, 0x74, 0x12, 0x3c,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f,
	0x62, 0x61, 0x6c, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x54, 0x65, 0x73, 0x74, 0x73, 0x2f, 0x7b, 0x74, 0x65, 0x73, 0x74, 0x7d, 0x22, 0x9d, 0x03, 0x0a,
	0x08, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69,
	0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x67, 0x6b, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x67, 0x6b, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2c, 0x0a, 0x12, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f,
	0x73, 0x71, 0x6c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5a,
	0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0x51, 0x0a, 0x0b, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4e, 0x45, 0x54, 0x57,
	0x4f, 0x52, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x43, 0x50, 0x5f, 0x4e, 0x45,
	0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x4f, 0x4e, 0x5f, 0x47,
	0x43, 0x50, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x02, 0x22, 0xf8, 0x02, 0x0a,
	0x13, 0x52, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x55, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x76,
	0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x76, 0x65,
	0x72, 0x69, 0x66, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x40, 0x0a, 0x06, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x52, 0x06, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x73, 0x22, 0x61, 0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x16,
	0x0a, 0x12, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x41, 0x43, 0x48, 0x41,
	0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x52, 0x45, 0x41, 0x43, 0x48,
	0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x4d, 0x42, 0x49, 0x47, 0x55,
	0x4f, 0x55, 0x53, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x4e, 0x44, 0x45, 0x54, 0x45, 0x52,
	0x4d, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x05, 0x42, 0xfc, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x42, 0x0e, 0x54, 0x65, 0x73, 0x74, 0x4f, 0x75, 0x74, 0x65, 0x72, 0x43, 0x6c, 0x61, 0x73,
	0x73, 0x50, 0x01, 0x5a, 0x52, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2f, 0x76, 0x31, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x21, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescOnce sync.Once
	file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescData = file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDesc
)

func file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescGZIP() []byte {
	file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescData)
	})
	return file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDescData
}

var file_google_cloud_networkmanagement_v1_connectivity_test_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_networkmanagement_v1_connectivity_test_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_networkmanagement_v1_connectivity_test_proto_goTypes = []interface{}{
	(Endpoint_NetworkType)(0),       // 0: google.cloud.networkmanagement.v1.Endpoint.NetworkType
	(ReachabilityDetails_Result)(0), // 1: google.cloud.networkmanagement.v1.ReachabilityDetails.Result
	(*ConnectivityTest)(nil),        // 2: google.cloud.networkmanagement.v1.ConnectivityTest
	(*Endpoint)(nil),                // 3: google.cloud.networkmanagement.v1.Endpoint
	(*ReachabilityDetails)(nil),     // 4: google.cloud.networkmanagement.v1.ReachabilityDetails
	nil,                             // 5: google.cloud.networkmanagement.v1.ConnectivityTest.LabelsEntry
	(*timestamppb.Timestamp)(nil),   // 6: google.protobuf.Timestamp
	(*status.Status)(nil),           // 7: google.rpc.Status
	(*Trace)(nil),                   // 8: google.cloud.networkmanagement.v1.Trace
}
var file_google_cloud_networkmanagement_v1_connectivity_test_proto_depIdxs = []int32{
	3,  // 0: google.cloud.networkmanagement.v1.ConnectivityTest.source:type_name -> google.cloud.networkmanagement.v1.Endpoint
	3,  // 1: google.cloud.networkmanagement.v1.ConnectivityTest.destination:type_name -> google.cloud.networkmanagement.v1.Endpoint
	5,  // 2: google.cloud.networkmanagement.v1.ConnectivityTest.labels:type_name -> google.cloud.networkmanagement.v1.ConnectivityTest.LabelsEntry
	6,  // 3: google.cloud.networkmanagement.v1.ConnectivityTest.create_time:type_name -> google.protobuf.Timestamp
	6,  // 4: google.cloud.networkmanagement.v1.ConnectivityTest.update_time:type_name -> google.protobuf.Timestamp
	4,  // 5: google.cloud.networkmanagement.v1.ConnectivityTest.reachability_details:type_name -> google.cloud.networkmanagement.v1.ReachabilityDetails
	0,  // 6: google.cloud.networkmanagement.v1.Endpoint.network_type:type_name -> google.cloud.networkmanagement.v1.Endpoint.NetworkType
	1,  // 7: google.cloud.networkmanagement.v1.ReachabilityDetails.result:type_name -> google.cloud.networkmanagement.v1.ReachabilityDetails.Result
	6,  // 8: google.cloud.networkmanagement.v1.ReachabilityDetails.verify_time:type_name -> google.protobuf.Timestamp
	7,  // 9: google.cloud.networkmanagement.v1.ReachabilityDetails.error:type_name -> google.rpc.Status
	8,  // 10: google.cloud.networkmanagement.v1.ReachabilityDetails.traces:type_name -> google.cloud.networkmanagement.v1.Trace
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_networkmanagement_v1_connectivity_test_proto_init() }
func file_google_cloud_networkmanagement_v1_connectivity_test_proto_init() {
	if File_google_cloud_networkmanagement_v1_connectivity_test_proto != nil {
		return
	}
	file_google_cloud_networkmanagement_v1_trace_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_networkmanagement_v1_connectivity_test_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectivityTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_connectivity_test_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Endpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_connectivity_test_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReachabilityDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_networkmanagement_v1_connectivity_test_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkmanagement_v1_connectivity_test_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkmanagement_v1_connectivity_test_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkmanagement_v1_connectivity_test_proto_msgTypes,
	}.Build()
	File_google_cloud_networkmanagement_v1_connectivity_test_proto = out.File
	file_google_cloud_networkmanagement_v1_connectivity_test_proto_rawDesc = nil
	file_google_cloud_networkmanagement_v1_connectivity_test_proto_goTypes = nil
	file_google_cloud_networkmanagement_v1_connectivity_test_proto_depIdxs = nil
}
