// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package synapse

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/synapse/mgmt/2019-06-01-preview/synapse"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ActualState = original.ActualState

const (
	Disabled  ActualState = original.Disabled
	Disabling ActualState = original.Disabling
	Enabled   ActualState = original.Enabled
	Enabling  ActualState = original.Enabling
	Unknown   ActualState = original.Unknown
)

type AuthorizationType = original.AuthorizationType

const (
	AuthorizationTypeKey                          AuthorizationType = original.AuthorizationTypeKey
	AuthorizationTypeLinkedIntegrationRuntimeType AuthorizationType = original.AuthorizationTypeLinkedIntegrationRuntimeType
	AuthorizationTypeRBAC                         AuthorizationType = original.AuthorizationTypeRBAC
)

type BlobAuditingPolicyState = original.BlobAuditingPolicyState

const (
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = original.BlobAuditingPolicyStateDisabled
	BlobAuditingPolicyStateEnabled  BlobAuditingPolicyState = original.BlobAuditingPolicyStateEnabled
)

type ColumnDataType = original.ColumnDataType

const (
	Bigint           ColumnDataType = original.Bigint
	Binary           ColumnDataType = original.Binary
	Bit              ColumnDataType = original.Bit
	Char             ColumnDataType = original.Char
	Date             ColumnDataType = original.Date
	Datetime         ColumnDataType = original.Datetime
	Datetime2        ColumnDataType = original.Datetime2
	Datetimeoffset   ColumnDataType = original.Datetimeoffset
	Decimal          ColumnDataType = original.Decimal
	Float            ColumnDataType = original.Float
	Geography        ColumnDataType = original.Geography
	Geometry         ColumnDataType = original.Geometry
	Hierarchyid      ColumnDataType = original.Hierarchyid
	Image            ColumnDataType = original.Image
	Int              ColumnDataType = original.Int
	Money            ColumnDataType = original.Money
	Nchar            ColumnDataType = original.Nchar
	Ntext            ColumnDataType = original.Ntext
	Numeric          ColumnDataType = original.Numeric
	Nvarchar         ColumnDataType = original.Nvarchar
	Real             ColumnDataType = original.Real
	Smalldatetime    ColumnDataType = original.Smalldatetime
	Smallint         ColumnDataType = original.Smallint
	Smallmoney       ColumnDataType = original.Smallmoney
	SQLVariant       ColumnDataType = original.SQLVariant
	Sysname          ColumnDataType = original.Sysname
	Text             ColumnDataType = original.Text
	Time             ColumnDataType = original.Time
	Timestamp        ColumnDataType = original.Timestamp
	Tinyint          ColumnDataType = original.Tinyint
	Uniqueidentifier ColumnDataType = original.Uniqueidentifier
	Varbinary        ColumnDataType = original.Varbinary
	Varchar          ColumnDataType = original.Varchar
	XML              ColumnDataType = original.XML
)

type DataFlowComputeType = original.DataFlowComputeType

const (
	ComputeOptimized DataFlowComputeType = original.ComputeOptimized
	General          DataFlowComputeType = original.General
	MemoryOptimized  DataFlowComputeType = original.MemoryOptimized
)

type DataMaskingFunction = original.DataMaskingFunction

const (
	DataMaskingFunctionCCN     DataMaskingFunction = original.DataMaskingFunctionCCN
	DataMaskingFunctionDefault DataMaskingFunction = original.DataMaskingFunctionDefault
	DataMaskingFunctionEmail   DataMaskingFunction = original.DataMaskingFunctionEmail
	DataMaskingFunctionNumber  DataMaskingFunction = original.DataMaskingFunctionNumber
	DataMaskingFunctionSSN     DataMaskingFunction = original.DataMaskingFunctionSSN
	DataMaskingFunctionText    DataMaskingFunction = original.DataMaskingFunctionText
)

type DataMaskingRuleState = original.DataMaskingRuleState

const (
	DataMaskingRuleStateDisabled DataMaskingRuleState = original.DataMaskingRuleStateDisabled
	DataMaskingRuleStateEnabled  DataMaskingRuleState = original.DataMaskingRuleStateEnabled
)

type DataMaskingState = original.DataMaskingState

const (
	DataMaskingStateDisabled DataMaskingState = original.DataMaskingStateDisabled
	DataMaskingStateEnabled  DataMaskingState = original.DataMaskingStateEnabled
)

type DesiredState = original.DesiredState

const (
	DesiredStateDisabled DesiredState = original.DesiredStateDisabled
	DesiredStateEnabled  DesiredState = original.DesiredStateEnabled
)

type GeoBackupPolicyState = original.GeoBackupPolicyState

const (
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = original.GeoBackupPolicyStateDisabled
	GeoBackupPolicyStateEnabled  GeoBackupPolicyState = original.GeoBackupPolicyStateEnabled
)

type IntegrationRuntimeAuthKeyName = original.IntegrationRuntimeAuthKeyName

const (
	AuthKey1 IntegrationRuntimeAuthKeyName = original.AuthKey1
	AuthKey2 IntegrationRuntimeAuthKeyName = original.AuthKey2
)

type IntegrationRuntimeAutoUpdate = original.IntegrationRuntimeAutoUpdate

const (
	Off IntegrationRuntimeAutoUpdate = original.Off
	On  IntegrationRuntimeAutoUpdate = original.On
)

type IntegrationRuntimeEdition = original.IntegrationRuntimeEdition

const (
	Enterprise IntegrationRuntimeEdition = original.Enterprise
	Standard   IntegrationRuntimeEdition = original.Standard
)

type IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeEntityReferenceType

const (
	IntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = original.IntegrationRuntimeReference
	LinkedServiceReference      IntegrationRuntimeEntityReferenceType = original.LinkedServiceReference
)

type IntegrationRuntimeInternalChannelEncryptionMode = original.IntegrationRuntimeInternalChannelEncryptionMode

const (
	NotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = original.NotEncrypted
	NotSet       IntegrationRuntimeInternalChannelEncryptionMode = original.NotSet
	SslEncrypted IntegrationRuntimeInternalChannelEncryptionMode = original.SslEncrypted
)

type IntegrationRuntimeLicenseType = original.IntegrationRuntimeLicenseType

const (
	BasePrice       IntegrationRuntimeLicenseType = original.BasePrice
	LicenseIncluded IntegrationRuntimeLicenseType = original.LicenseIncluded
)

type IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTier

const (
	IntegrationRuntimeSsisCatalogPricingTierBasic     IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierBasic
	IntegrationRuntimeSsisCatalogPricingTierPremium   IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierPremium
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierPremiumRS
	IntegrationRuntimeSsisCatalogPricingTierStandard  IntegrationRuntimeSsisCatalogPricingTier = original.IntegrationRuntimeSsisCatalogPricingTierStandard
)

type IntegrationRuntimeState = original.IntegrationRuntimeState

const (
	AccessDenied     IntegrationRuntimeState = original.AccessDenied
	Initial          IntegrationRuntimeState = original.Initial
	Limited          IntegrationRuntimeState = original.Limited
	NeedRegistration IntegrationRuntimeState = original.NeedRegistration
	Offline          IntegrationRuntimeState = original.Offline
	Online           IntegrationRuntimeState = original.Online
	Started          IntegrationRuntimeState = original.Started
	Starting         IntegrationRuntimeState = original.Starting
	Stopped          IntegrationRuntimeState = original.Stopped
	Stopping         IntegrationRuntimeState = original.Stopping
)

type IntegrationRuntimeType = original.IntegrationRuntimeType

const (
	Managed    IntegrationRuntimeType = original.Managed
	SelfHosted IntegrationRuntimeType = original.SelfHosted
)

type IntegrationRuntimeUpdateResult = original.IntegrationRuntimeUpdateResult

const (
	Fail    IntegrationRuntimeUpdateResult = original.Fail
	None    IntegrationRuntimeUpdateResult = original.None
	Succeed IntegrationRuntimeUpdateResult = original.Succeed
)

type ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatus

const (
	ManagedIntegrationRuntimeNodeStatusAvailable   ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusAvailable
	ManagedIntegrationRuntimeNodeStatusRecycling   ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusRecycling
	ManagedIntegrationRuntimeNodeStatusStarting    ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusStarting
	ManagedIntegrationRuntimeNodeStatusUnavailable ManagedIntegrationRuntimeNodeStatus = original.ManagedIntegrationRuntimeNodeStatusUnavailable
)

type ManagementOperationState = original.ManagementOperationState

const (
	CancelInProgress ManagementOperationState = original.CancelInProgress
	Cancelled        ManagementOperationState = original.Cancelled
	Failed           ManagementOperationState = original.Failed
	InProgress       ManagementOperationState = original.InProgress
	Pending          ManagementOperationState = original.Pending
	Succeeded        ManagementOperationState = original.Succeeded
)

type NodeSize = original.NodeSize

const (
	NodeSizeLarge    NodeSize = original.NodeSizeLarge
	NodeSizeMedium   NodeSize = original.NodeSizeMedium
	NodeSizeNone     NodeSize = original.NodeSizeNone
	NodeSizeSmall    NodeSize = original.NodeSizeSmall
	NodeSizeXLarge   NodeSize = original.NodeSizeXLarge
	NodeSizeXXLarge  NodeSize = original.NodeSizeXXLarge
	NodeSizeXXXLarge NodeSize = original.NodeSizeXXXLarge
)

type NodeSizeFamily = original.NodeSizeFamily

const (
	NodeSizeFamilyMemoryOptimized NodeSizeFamily = original.NodeSizeFamilyMemoryOptimized
	NodeSizeFamilyNone            NodeSizeFamily = original.NodeSizeFamilyNone
)

type OperationStatus = original.OperationStatus

const (
	OperationStatusCanceled   OperationStatus = original.OperationStatusCanceled
	OperationStatusFailed     OperationStatus = original.OperationStatusFailed
	OperationStatusInProgress OperationStatus = original.OperationStatusInProgress
	OperationStatusSucceeded  OperationStatus = original.OperationStatusSucceeded
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateDeleteError  ProvisioningState = original.ProvisioningStateDeleteError
	ProvisioningStateDeleting     ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed       ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateProvisioning ProvisioningState = original.ProvisioningStateProvisioning
	ProvisioningStateSucceeded    ProvisioningState = original.ProvisioningStateSucceeded
)

type QueryAggregationFunction = original.QueryAggregationFunction

const (
	Avg QueryAggregationFunction = original.Avg
	Max QueryAggregationFunction = original.Max
	Min QueryAggregationFunction = original.Min
	Sum QueryAggregationFunction = original.Sum
)

type QueryExecutionType = original.QueryExecutionType

const (
	Aborted   QueryExecutionType = original.Aborted
	Any       QueryExecutionType = original.Any
	Exception QueryExecutionType = original.Exception
	Irregular QueryExecutionType = original.Irregular
	Regular   QueryExecutionType = original.Regular
)

type QueryMetricUnit = original.QueryMetricUnit

const (
	KB           QueryMetricUnit = original.KB
	Microseconds QueryMetricUnit = original.Microseconds
	Percentage   QueryMetricUnit = original.Percentage
)

type QueryObservedMetricType = original.QueryObservedMetricType

const (
	CPU            QueryObservedMetricType = original.CPU
	Duration       QueryObservedMetricType = original.Duration
	ExecutionCount QueryObservedMetricType = original.ExecutionCount
	Io             QueryObservedMetricType = original.Io
	Logio          QueryObservedMetricType = original.Logio
)

type ReplicationRole = original.ReplicationRole

const (
	Copy                 ReplicationRole = original.Copy
	NonReadableSecondary ReplicationRole = original.NonReadableSecondary
	Primary              ReplicationRole = original.Primary
	Secondary            ReplicationRole = original.Secondary
	Source               ReplicationRole = original.Source
)

type ReplicationState = original.ReplicationState

const (
	CATCHUP   ReplicationState = original.CATCHUP
	PENDING   ReplicationState = original.PENDING
	SEEDING   ReplicationState = original.SEEDING
	SUSPENDED ReplicationState = original.SUSPENDED
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	ResourceIdentityTypeNone           ResourceIdentityType = original.ResourceIdentityTypeNone
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = original.ResourceIdentityTypeSystemAssigned
)

type RestorePointType = original.RestorePointType

const (
	CONTINUOUS RestorePointType = original.CONTINUOUS
	DISCRETE   RestorePointType = original.DISCRETE
)

type SecurityAlertPolicyState = original.SecurityAlertPolicyState

const (
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = original.SecurityAlertPolicyStateDisabled
	SecurityAlertPolicyStateEnabled  SecurityAlertPolicyState = original.SecurityAlertPolicyStateEnabled
	SecurityAlertPolicyStateNew      SecurityAlertPolicyState = original.SecurityAlertPolicyStateNew
)

type SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatus

const (
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusInitializeFailed
	SelfHostedIntegrationRuntimeNodeStatusInitializing     SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusInitializing
	SelfHostedIntegrationRuntimeNodeStatusLimited          SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusLimited
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusNeedRegistration
	SelfHostedIntegrationRuntimeNodeStatusOffline          SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusOffline
	SelfHostedIntegrationRuntimeNodeStatusOnline           SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusOnline
	SelfHostedIntegrationRuntimeNodeStatusUpgrading        SelfHostedIntegrationRuntimeNodeStatus = original.SelfHostedIntegrationRuntimeNodeStatusUpgrading
)

type SensitivityLabelSource = original.SensitivityLabelSource

const (
	Current     SensitivityLabelSource = original.Current
	Recommended SensitivityLabelSource = original.Recommended
)

type SsisObjectMetadataType = original.SsisObjectMetadataType

const (
	Environment SsisObjectMetadataType = original.Environment
	Folder      SsisObjectMetadataType = original.Folder
	Package     SsisObjectMetadataType = original.Package
	Project     SsisObjectMetadataType = original.Project
)

type TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatus

const (
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatusDisabled
	TransparentDataEncryptionStatusEnabled  TransparentDataEncryptionStatus = original.TransparentDataEncryptionStatusEnabled
)

type Type = original.Type

const (
	TypeIntegrationRuntime Type = original.TypeIntegrationRuntime
	TypeManaged            Type = original.TypeManaged
	TypeSelfHosted         Type = original.TypeSelfHosted
)

type TypeBasicCustomSetupBase = original.TypeBasicCustomSetupBase

const (
	TypeCmdkeySetup              TypeBasicCustomSetupBase = original.TypeCmdkeySetup
	TypeComponentSetup           TypeBasicCustomSetupBase = original.TypeComponentSetup
	TypeCustomSetupBase          TypeBasicCustomSetupBase = original.TypeCustomSetupBase
	TypeEnvironmentVariableSetup TypeBasicCustomSetupBase = original.TypeEnvironmentVariableSetup
)

type TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatus

const (
	TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus
	TypeBasicIntegrationRuntimeStatusTypeManaged                  TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeManaged
	TypeBasicIntegrationRuntimeStatusTypeSelfHosted               TypeBasicIntegrationRuntimeStatus = original.TypeBasicIntegrationRuntimeStatusTypeSelfHosted
)

type TypeBasicSecretBase = original.TypeBasicSecretBase

const (
	TypeSecretBase   TypeBasicSecretBase = original.TypeSecretBase
	TypeSecureString TypeBasicSecretBase = original.TypeSecureString
)

type TypeBasicSsisObjectMetadata = original.TypeBasicSsisObjectMetadata

const (
	TypeEnvironment        TypeBasicSsisObjectMetadata = original.TypeEnvironment
	TypeFolder             TypeBasicSsisObjectMetadata = original.TypeFolder
	TypePackage            TypeBasicSsisObjectMetadata = original.TypePackage
	TypeProject            TypeBasicSsisObjectMetadata = original.TypeProject
	TypeSsisObjectMetadata TypeBasicSsisObjectMetadata = original.TypeSsisObjectMetadata
)

type VulnerabilityAssessmentPolicyBaselineName = original.VulnerabilityAssessmentPolicyBaselineName

const (
	Default VulnerabilityAssessmentPolicyBaselineName = original.Default
	Master  VulnerabilityAssessmentPolicyBaselineName = original.Master
)

type VulnerabilityAssessmentScanState = original.VulnerabilityAssessmentScanState

const (
	VulnerabilityAssessmentScanStateFailed      VulnerabilityAssessmentScanState = original.VulnerabilityAssessmentScanStateFailed
	VulnerabilityAssessmentScanStateFailedToRun VulnerabilityAssessmentScanState = original.VulnerabilityAssessmentScanStateFailedToRun
	VulnerabilityAssessmentScanStateInProgress  VulnerabilityAssessmentScanState = original.VulnerabilityAssessmentScanStateInProgress
	VulnerabilityAssessmentScanStatePassed      VulnerabilityAssessmentScanState = original.VulnerabilityAssessmentScanStatePassed
)

type VulnerabilityAssessmentScanTriggerType = original.VulnerabilityAssessmentScanTriggerType

const (
	OnDemand  VulnerabilityAssessmentScanTriggerType = original.OnDemand
	Recurring VulnerabilityAssessmentScanTriggerType = original.Recurring
)

type AadAdminProperties = original.AadAdminProperties
type AutoPauseProperties = original.AutoPauseProperties
type AutoScaleProperties = original.AutoScaleProperties
type AvailableRpOperation = original.AvailableRpOperation
type AvailableRpOperationDisplayInfo = original.AvailableRpOperationDisplayInfo
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type BasicCustomSetupBase = original.BasicCustomSetupBase
type BasicIntegrationRuntime = original.BasicIntegrationRuntime
type BasicIntegrationRuntimeStatus = original.BasicIntegrationRuntimeStatus
type BasicLinkedIntegrationRuntimeType = original.BasicLinkedIntegrationRuntimeType
type BasicSecretBase = original.BasicSecretBase
type BasicSsisObjectMetadata = original.BasicSsisObjectMetadata
type BigDataPoolPatchInfo = original.BigDataPoolPatchInfo
type BigDataPoolResourceInfo = original.BigDataPoolResourceInfo
type BigDataPoolResourceInfoListResult = original.BigDataPoolResourceInfoListResult
type BigDataPoolResourceInfoListResultIterator = original.BigDataPoolResourceInfoListResultIterator
type BigDataPoolResourceInfoListResultPage = original.BigDataPoolResourceInfoListResultPage
type BigDataPoolResourceProperties = original.BigDataPoolResourceProperties
type BigDataPoolsClient = original.BigDataPoolsClient
type BigDataPoolsCreateOrUpdateFuture = original.BigDataPoolsCreateOrUpdateFuture
type BigDataPoolsDeleteFuture = original.BigDataPoolsDeleteFuture
type CheckNameAvailabilityRequest = original.CheckNameAvailabilityRequest
type CheckNameAvailabilityResponse = original.CheckNameAvailabilityResponse
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type CmdkeySetup = original.CmdkeySetup
type CmdkeySetupTypeProperties = original.CmdkeySetupTypeProperties
type ComponentSetup = original.ComponentSetup
type CreateSQLPoolRestorePointDefinition = original.CreateSQLPoolRestorePointDefinition
type CustomSetupBase = original.CustomSetupBase
type CustomerManagedKeyDetails = original.CustomerManagedKeyDetails
type DataLakeStorageAccountDetails = original.DataLakeStorageAccountDetails
type DataMaskingPoliciesClient = original.DataMaskingPoliciesClient
type DataMaskingPolicy = original.DataMaskingPolicy
type DataMaskingPolicyProperties = original.DataMaskingPolicyProperties
type DataMaskingRule = original.DataMaskingRule
type DataMaskingRuleListResult = original.DataMaskingRuleListResult
type DataMaskingRuleProperties = original.DataMaskingRuleProperties
type DataMaskingRulesClient = original.DataMaskingRulesClient
type DataWarehouseUserActivities = original.DataWarehouseUserActivities
type DataWarehouseUserActivitiesProperties = original.DataWarehouseUserActivitiesProperties
type EncryptionDetails = original.EncryptionDetails
type EntityReference = original.EntityReference
type EnvironmentVariableSetup = original.EnvironmentVariableSetup
type EnvironmentVariableSetupTypeProperties = original.EnvironmentVariableSetupTypeProperties
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorContract = original.ErrorContract
type ErrorDetail = original.ErrorDetail
type ErrorResponse = original.ErrorResponse
type ExtendedSQLPoolBlobAuditingPoliciesClient = original.ExtendedSQLPoolBlobAuditingPoliciesClient
type ExtendedSQLPoolBlobAuditingPolicy = original.ExtendedSQLPoolBlobAuditingPolicy
type ExtendedSQLPoolBlobAuditingPolicyListResult = original.ExtendedSQLPoolBlobAuditingPolicyListResult
type ExtendedSQLPoolBlobAuditingPolicyListResultIterator = original.ExtendedSQLPoolBlobAuditingPolicyListResultIterator
type ExtendedSQLPoolBlobAuditingPolicyListResultPage = original.ExtendedSQLPoolBlobAuditingPolicyListResultPage
type ExtendedSQLPoolBlobAuditingPolicyProperties = original.ExtendedSQLPoolBlobAuditingPolicyProperties
type ExtendedServerBlobAuditingPolicy = original.ExtendedServerBlobAuditingPolicy
type ExtendedServerBlobAuditingPolicyListResult = original.ExtendedServerBlobAuditingPolicyListResult
type ExtendedServerBlobAuditingPolicyListResultIterator = original.ExtendedServerBlobAuditingPolicyListResultIterator
type ExtendedServerBlobAuditingPolicyListResultPage = original.ExtendedServerBlobAuditingPolicyListResultPage
type ExtendedServerBlobAuditingPolicyProperties = original.ExtendedServerBlobAuditingPolicyProperties
type GeoBackupPolicy = original.GeoBackupPolicy
type GeoBackupPolicyListResult = original.GeoBackupPolicyListResult
type GeoBackupPolicyProperties = original.GeoBackupPolicyProperties
type GetSsisObjectMetadataRequest = original.GetSsisObjectMetadataRequest
type IPFirewallRuleInfo = original.IPFirewallRuleInfo
type IPFirewallRuleInfoListResult = original.IPFirewallRuleInfoListResult
type IPFirewallRuleInfoListResultIterator = original.IPFirewallRuleInfoListResultIterator
type IPFirewallRuleInfoListResultPage = original.IPFirewallRuleInfoListResultPage
type IPFirewallRuleProperties = original.IPFirewallRuleProperties
type IPFirewallRulesClient = original.IPFirewallRulesClient
type IPFirewallRulesCreateOrUpdateFuture = original.IPFirewallRulesCreateOrUpdateFuture
type IPFirewallRulesDeleteFuture = original.IPFirewallRulesDeleteFuture
type IPFirewallRulesReplaceAllFuture = original.IPFirewallRulesReplaceAllFuture
type IntegrationRuntime = original.IntegrationRuntime
type IntegrationRuntimeAuthKeys = original.IntegrationRuntimeAuthKeys
type IntegrationRuntimeAuthKeysClient = original.IntegrationRuntimeAuthKeysClient
type IntegrationRuntimeComputeProperties = original.IntegrationRuntimeComputeProperties
type IntegrationRuntimeConnectionInfo = original.IntegrationRuntimeConnectionInfo
type IntegrationRuntimeConnectionInfosClient = original.IntegrationRuntimeConnectionInfosClient
type IntegrationRuntimeCredentialsClient = original.IntegrationRuntimeCredentialsClient
type IntegrationRuntimeCustomSetupScriptProperties = original.IntegrationRuntimeCustomSetupScriptProperties
type IntegrationRuntimeDataFlowProperties = original.IntegrationRuntimeDataFlowProperties
type IntegrationRuntimeDataProxyProperties = original.IntegrationRuntimeDataProxyProperties
type IntegrationRuntimeListResponse = original.IntegrationRuntimeListResponse
type IntegrationRuntimeListResponseIterator = original.IntegrationRuntimeListResponseIterator
type IntegrationRuntimeListResponsePage = original.IntegrationRuntimeListResponsePage
type IntegrationRuntimeMonitoringData = original.IntegrationRuntimeMonitoringData
type IntegrationRuntimeMonitoringDataClient = original.IntegrationRuntimeMonitoringDataClient
type IntegrationRuntimeNodeIPAddress = original.IntegrationRuntimeNodeIPAddress
type IntegrationRuntimeNodeIPAddressClient = original.IntegrationRuntimeNodeIPAddressClient
type IntegrationRuntimeNodeMonitoringData = original.IntegrationRuntimeNodeMonitoringData
type IntegrationRuntimeNodesClient = original.IntegrationRuntimeNodesClient
type IntegrationRuntimeObjectMetadataClient = original.IntegrationRuntimeObjectMetadataClient
type IntegrationRuntimeObjectMetadataRefreshFuture = original.IntegrationRuntimeObjectMetadataRefreshFuture
type IntegrationRuntimeRegenerateKeyParameters = original.IntegrationRuntimeRegenerateKeyParameters
type IntegrationRuntimeResource = original.IntegrationRuntimeResource
type IntegrationRuntimeSsisCatalogInfo = original.IntegrationRuntimeSsisCatalogInfo
type IntegrationRuntimeSsisProperties = original.IntegrationRuntimeSsisProperties
type IntegrationRuntimeStatus = original.IntegrationRuntimeStatus
type IntegrationRuntimeStatusClient = original.IntegrationRuntimeStatusClient
type IntegrationRuntimeStatusResponse = original.IntegrationRuntimeStatusResponse
type IntegrationRuntimeVNetProperties = original.IntegrationRuntimeVNetProperties
type IntegrationRuntimesClient = original.IntegrationRuntimesClient
type IntegrationRuntimesCreateFuture = original.IntegrationRuntimesCreateFuture
type IntegrationRuntimesDeleteFuture = original.IntegrationRuntimesDeleteFuture
type IntegrationRuntimesDisableInteractiveQueryFuture = original.IntegrationRuntimesDisableInteractiveQueryFuture
type IntegrationRuntimesEnableInteractiveQueryFuture = original.IntegrationRuntimesEnableInteractiveQueryFuture
type IntegrationRuntimesStartFuture = original.IntegrationRuntimesStartFuture
type IntegrationRuntimesStopFuture = original.IntegrationRuntimesStopFuture
type Key = original.Key
type KeyInfoListResult = original.KeyInfoListResult
type KeyInfoListResultIterator = original.KeyInfoListResultIterator
type KeyInfoListResultPage = original.KeyInfoListResultPage
type KeyProperties = original.KeyProperties
type KeysClient = original.KeysClient
type LibraryRequirements = original.LibraryRequirements
type LicensedComponentSetupTypeProperties = original.LicensedComponentSetupTypeProperties
type LinkedIntegrationRuntime = original.LinkedIntegrationRuntime
type LinkedIntegrationRuntimeKeyAuthorization = original.LinkedIntegrationRuntimeKeyAuthorization
type LinkedIntegrationRuntimeRbacAuthorization = original.LinkedIntegrationRuntimeRbacAuthorization
type LinkedIntegrationRuntimeType = original.LinkedIntegrationRuntimeType
type ListAvailableRpOperation = original.ListAvailableRpOperation
type ListSQLPoolSecurityAlertPolicies = original.ListSQLPoolSecurityAlertPolicies
type ListSQLPoolSecurityAlertPoliciesIterator = original.ListSQLPoolSecurityAlertPoliciesIterator
type ListSQLPoolSecurityAlertPoliciesPage = original.ListSQLPoolSecurityAlertPoliciesPage
type ManagedIdentity = original.ManagedIdentity
type ManagedIdentitySQLControlSettingsModel = original.ManagedIdentitySQLControlSettingsModel
type ManagedIdentitySQLControlSettingsModelProperties = original.ManagedIdentitySQLControlSettingsModelProperties
type ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity = original.ManagedIdentitySQLControlSettingsModelPropertiesGrantSQLControlToManagedIdentity
type ManagedIntegrationRuntime = original.ManagedIntegrationRuntime
type ManagedIntegrationRuntimeError = original.ManagedIntegrationRuntimeError
type ManagedIntegrationRuntimeNode = original.ManagedIntegrationRuntimeNode
type ManagedIntegrationRuntimeOperationResult = original.ManagedIntegrationRuntimeOperationResult
type ManagedIntegrationRuntimeStatus = original.ManagedIntegrationRuntimeStatus
type ManagedIntegrationRuntimeStatusTypeProperties = original.ManagedIntegrationRuntimeStatusTypeProperties
type ManagedIntegrationRuntimeTypeProperties = original.ManagedIntegrationRuntimeTypeProperties
type ManagedVirtualNetworkSettings = original.ManagedVirtualNetworkSettings
type MetadataSyncConfig = original.MetadataSyncConfig
type MetadataSyncConfigProperties = original.MetadataSyncConfigProperties
type OperationMetaLogSpecification = original.OperationMetaLogSpecification
type OperationMetaMetricDimensionSpecification = original.OperationMetaMetricDimensionSpecification
type OperationMetaMetricSpecification = original.OperationMetaMetricSpecification
type OperationMetaPropertyInfo = original.OperationMetaPropertyInfo
type OperationMetaServiceSpecification = original.OperationMetaServiceSpecification
type OperationResource = original.OperationResource
type OperationsClient = original.OperationsClient
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionForPrivateLinkHub = original.PrivateEndpointConnectionForPrivateLinkHub
type PrivateEndpointConnectionForPrivateLinkHubBasic = original.PrivateEndpointConnectionForPrivateLinkHubBasic
type PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse = original.PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse
type PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator = original.PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator
type PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage = original.PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage
type PrivateEndpointConnectionList = original.PrivateEndpointConnectionList
type PrivateEndpointConnectionListIterator = original.PrivateEndpointConnectionListIterator
type PrivateEndpointConnectionListPage = original.PrivateEndpointConnectionListPage
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointConnectionsClient = original.PrivateEndpointConnectionsClient
type PrivateEndpointConnectionsCreateFuture = original.PrivateEndpointConnectionsCreateFuture
type PrivateEndpointConnectionsDeleteFuture = original.PrivateEndpointConnectionsDeleteFuture
type PrivateEndpointConnectionsPrivateLinkHubClient = original.PrivateEndpointConnectionsPrivateLinkHubClient
type PrivateLinkHub = original.PrivateLinkHub
type PrivateLinkHubInfoListResult = original.PrivateLinkHubInfoListResult
type PrivateLinkHubInfoListResultIterator = original.PrivateLinkHubInfoListResultIterator
type PrivateLinkHubInfoListResultPage = original.PrivateLinkHubInfoListResultPage
type PrivateLinkHubPatchInfo = original.PrivateLinkHubPatchInfo
type PrivateLinkHubProperties = original.PrivateLinkHubProperties
type PrivateLinkHubsClient = original.PrivateLinkHubsClient
type PrivateLinkHubsDeleteFuture = original.PrivateLinkHubsDeleteFuture
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceListResult = original.PrivateLinkResourceListResult
type PrivateLinkResourceListResultIterator = original.PrivateLinkResourceListResultIterator
type PrivateLinkResourceListResultPage = original.PrivateLinkResourceListResultPage
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type PrivateLinkServiceConnectionState = original.PrivateLinkServiceConnectionState
type ProxyResource = original.ProxyResource
type PurviewConfiguration = original.PurviewConfiguration
type QueryInterval = original.QueryInterval
type QueryMetric = original.QueryMetric
type QueryStatistic = original.QueryStatistic
type RecoverableSQLPool = original.RecoverableSQLPool
type RecoverableSQLPoolListResult = original.RecoverableSQLPoolListResult
type RecoverableSQLPoolListResultIterator = original.RecoverableSQLPoolListResultIterator
type RecoverableSQLPoolListResultPage = original.RecoverableSQLPoolListResultPage
type RecoverableSQLPoolProperties = original.RecoverableSQLPoolProperties
type ReplaceAllFirewallRulesOperationResponse = original.ReplaceAllFirewallRulesOperationResponse
type ReplaceAllIPFirewallRulesRequest = original.ReplaceAllIPFirewallRulesRequest
type ReplicationLink = original.ReplicationLink
type ReplicationLinkListResult = original.ReplicationLinkListResult
type ReplicationLinkListResultIterator = original.ReplicationLinkListResultIterator
type ReplicationLinkListResultPage = original.ReplicationLinkListResultPage
type ReplicationLinkProperties = original.ReplicationLinkProperties
type Resource = original.Resource
type RestorableDroppedSQLPool = original.RestorableDroppedSQLPool
type RestorableDroppedSQLPoolListResult = original.RestorableDroppedSQLPoolListResult
type RestorableDroppedSQLPoolProperties = original.RestorableDroppedSQLPoolProperties
type RestorableDroppedSQLPoolsClient = original.RestorableDroppedSQLPoolsClient
type RestorePoint = original.RestorePoint
type RestorePointListResult = original.RestorePointListResult
type RestorePointListResultIterator = original.RestorePointListResultIterator
type RestorePointListResultPage = original.RestorePointListResultPage
type RestorePointProperties = original.RestorePointProperties
type SQLPool = original.SQLPool
type SQLPoolBlobAuditingPoliciesClient = original.SQLPoolBlobAuditingPoliciesClient
type SQLPoolBlobAuditingPolicy = original.SQLPoolBlobAuditingPolicy
type SQLPoolBlobAuditingPolicyListResult = original.SQLPoolBlobAuditingPolicyListResult
type SQLPoolBlobAuditingPolicyListResultIterator = original.SQLPoolBlobAuditingPolicyListResultIterator
type SQLPoolBlobAuditingPolicyListResultPage = original.SQLPoolBlobAuditingPolicyListResultPage
type SQLPoolBlobAuditingPolicyProperties = original.SQLPoolBlobAuditingPolicyProperties
type SQLPoolBlobAuditingPolicySQLPoolOperationListResult = original.SQLPoolBlobAuditingPolicySQLPoolOperationListResult
type SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator = original.SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator
type SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage = original.SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage
type SQLPoolColumn = original.SQLPoolColumn
type SQLPoolColumnListResult = original.SQLPoolColumnListResult
type SQLPoolColumnListResultIterator = original.SQLPoolColumnListResultIterator
type SQLPoolColumnListResultPage = original.SQLPoolColumnListResultPage
type SQLPoolColumnProperties = original.SQLPoolColumnProperties
type SQLPoolColumnsClient = original.SQLPoolColumnsClient
type SQLPoolConnectionPoliciesClient = original.SQLPoolConnectionPoliciesClient
type SQLPoolConnectionPolicy = original.SQLPoolConnectionPolicy
type SQLPoolConnectionPolicyProperties = original.SQLPoolConnectionPolicyProperties
type SQLPoolDataWarehouseUserActivitiesClient = original.SQLPoolDataWarehouseUserActivitiesClient
type SQLPoolGeoBackupPoliciesClient = original.SQLPoolGeoBackupPoliciesClient
type SQLPoolInfoListResult = original.SQLPoolInfoListResult
type SQLPoolInfoListResultIterator = original.SQLPoolInfoListResultIterator
type SQLPoolInfoListResultPage = original.SQLPoolInfoListResultPage
type SQLPoolMetadataSyncConfigsClient = original.SQLPoolMetadataSyncConfigsClient
type SQLPoolOperation = original.SQLPoolOperation
type SQLPoolOperationProperties = original.SQLPoolOperationProperties
type SQLPoolOperationResultsClient = original.SQLPoolOperationResultsClient
type SQLPoolOperationsClient = original.SQLPoolOperationsClient
type SQLPoolPatchInfo = original.SQLPoolPatchInfo
type SQLPoolReplicationLinksClient = original.SQLPoolReplicationLinksClient
type SQLPoolResourceProperties = original.SQLPoolResourceProperties
type SQLPoolRestorePointsClient = original.SQLPoolRestorePointsClient
type SQLPoolRestorePointsCreateFuture = original.SQLPoolRestorePointsCreateFuture
type SQLPoolSchema = original.SQLPoolSchema
type SQLPoolSchemaListResult = original.SQLPoolSchemaListResult
type SQLPoolSchemaListResultIterator = original.SQLPoolSchemaListResultIterator
type SQLPoolSchemaListResultPage = original.SQLPoolSchemaListResultPage
type SQLPoolSchemasClient = original.SQLPoolSchemasClient
type SQLPoolSecurityAlertPoliciesClient = original.SQLPoolSecurityAlertPoliciesClient
type SQLPoolSecurityAlertPolicy = original.SQLPoolSecurityAlertPolicy
type SQLPoolSensitivityLabelsClient = original.SQLPoolSensitivityLabelsClient
type SQLPoolTable = original.SQLPoolTable
type SQLPoolTableColumnsClient = original.SQLPoolTableColumnsClient
type SQLPoolTableListResult = original.SQLPoolTableListResult
type SQLPoolTableListResultIterator = original.SQLPoolTableListResultIterator
type SQLPoolTableListResultPage = original.SQLPoolTableListResultPage
type SQLPoolTablesClient = original.SQLPoolTablesClient
type SQLPoolTransparentDataEncryptionsClient = original.SQLPoolTransparentDataEncryptionsClient
type SQLPoolUsage = original.SQLPoolUsage
type SQLPoolUsageListResult = original.SQLPoolUsageListResult
type SQLPoolUsageListResultIterator = original.SQLPoolUsageListResultIterator
type SQLPoolUsageListResultPage = original.SQLPoolUsageListResultPage
type SQLPoolUsagesClient = original.SQLPoolUsagesClient
type SQLPoolVulnerabilityAssessment = original.SQLPoolVulnerabilityAssessment
type SQLPoolVulnerabilityAssessmentListResult = original.SQLPoolVulnerabilityAssessmentListResult
type SQLPoolVulnerabilityAssessmentListResultIterator = original.SQLPoolVulnerabilityAssessmentListResultIterator
type SQLPoolVulnerabilityAssessmentListResultPage = original.SQLPoolVulnerabilityAssessmentListResultPage
type SQLPoolVulnerabilityAssessmentProperties = original.SQLPoolVulnerabilityAssessmentProperties
type SQLPoolVulnerabilityAssessmentRuleBaseline = original.SQLPoolVulnerabilityAssessmentRuleBaseline
type SQLPoolVulnerabilityAssessmentRuleBaselineItem = original.SQLPoolVulnerabilityAssessmentRuleBaselineItem
type SQLPoolVulnerabilityAssessmentRuleBaselineProperties = original.SQLPoolVulnerabilityAssessmentRuleBaselineProperties
type SQLPoolVulnerabilityAssessmentRuleBaselinesClient = original.SQLPoolVulnerabilityAssessmentRuleBaselinesClient
type SQLPoolVulnerabilityAssessmentScanExportProperties = original.SQLPoolVulnerabilityAssessmentScanExportProperties
type SQLPoolVulnerabilityAssessmentScansClient = original.SQLPoolVulnerabilityAssessmentScansClient
type SQLPoolVulnerabilityAssessmentScansExport = original.SQLPoolVulnerabilityAssessmentScansExport
type SQLPoolVulnerabilityAssessmentScansInitiateScanFuture = original.SQLPoolVulnerabilityAssessmentScansInitiateScanFuture
type SQLPoolVulnerabilityAssessmentsClient = original.SQLPoolVulnerabilityAssessmentsClient
type SQLPoolWorkloadClassifierClient = original.SQLPoolWorkloadClassifierClient
type SQLPoolWorkloadClassifierCreateOrUpdateFuture = original.SQLPoolWorkloadClassifierCreateOrUpdateFuture
type SQLPoolWorkloadClassifierDeleteFuture = original.SQLPoolWorkloadClassifierDeleteFuture
type SQLPoolWorkloadGroupClient = original.SQLPoolWorkloadGroupClient
type SQLPoolWorkloadGroupCreateOrUpdateFuture = original.SQLPoolWorkloadGroupCreateOrUpdateFuture
type SQLPoolWorkloadGroupDeleteFuture = original.SQLPoolWorkloadGroupDeleteFuture
type SQLPoolsClient = original.SQLPoolsClient
type SQLPoolsCreateFuture = original.SQLPoolsCreateFuture
type SQLPoolsDeleteFuture = original.SQLPoolsDeleteFuture
type SQLPoolsPauseFuture = original.SQLPoolsPauseFuture
type SQLPoolsResumeFuture = original.SQLPoolsResumeFuture
type SecretBase = original.SecretBase
type SecureString = original.SecureString
type SecurityAlertPolicyProperties = original.SecurityAlertPolicyProperties
type SelfHostedIntegrationRuntime = original.SelfHostedIntegrationRuntime
type SelfHostedIntegrationRuntimeNode = original.SelfHostedIntegrationRuntimeNode
type SelfHostedIntegrationRuntimeStatus = original.SelfHostedIntegrationRuntimeStatus
type SelfHostedIntegrationRuntimeStatusTypeProperties = original.SelfHostedIntegrationRuntimeStatusTypeProperties
type SelfHostedIntegrationRuntimeTypeProperties = original.SelfHostedIntegrationRuntimeTypeProperties
type SensitivityLabel = original.SensitivityLabel
type SensitivityLabelListResult = original.SensitivityLabelListResult
type SensitivityLabelListResultIterator = original.SensitivityLabelListResultIterator
type SensitivityLabelListResultPage = original.SensitivityLabelListResultPage
type SensitivityLabelProperties = original.SensitivityLabelProperties
type ServerBlobAuditingPolicy = original.ServerBlobAuditingPolicy
type ServerBlobAuditingPolicyListResult = original.ServerBlobAuditingPolicyListResult
type ServerBlobAuditingPolicyListResultIterator = original.ServerBlobAuditingPolicyListResultIterator
type ServerBlobAuditingPolicyListResultPage = original.ServerBlobAuditingPolicyListResultPage
type ServerBlobAuditingPolicyProperties = original.ServerBlobAuditingPolicyProperties
type ServerSecurityAlertPolicy = original.ServerSecurityAlertPolicy
type ServerSecurityAlertPolicyListResult = original.ServerSecurityAlertPolicyListResult
type ServerSecurityAlertPolicyListResultIterator = original.ServerSecurityAlertPolicyListResultIterator
type ServerSecurityAlertPolicyListResultPage = original.ServerSecurityAlertPolicyListResultPage
type ServerSecurityAlertPolicyProperties = original.ServerSecurityAlertPolicyProperties
type ServerUsage = original.ServerUsage
type ServerUsageListResult = original.ServerUsageListResult
type ServerUsageListResultIterator = original.ServerUsageListResultIterator
type ServerUsageListResultPage = original.ServerUsageListResultPage
type ServerVulnerabilityAssessment = original.ServerVulnerabilityAssessment
type ServerVulnerabilityAssessmentListResult = original.ServerVulnerabilityAssessmentListResult
type ServerVulnerabilityAssessmentListResultIterator = original.ServerVulnerabilityAssessmentListResultIterator
type ServerVulnerabilityAssessmentListResultPage = original.ServerVulnerabilityAssessmentListResultPage
type ServerVulnerabilityAssessmentProperties = original.ServerVulnerabilityAssessmentProperties
type SetObject = original.SetObject
type Sku = original.Sku
type SsisEnvironment = original.SsisEnvironment
type SsisEnvironmentReference = original.SsisEnvironmentReference
type SsisFolder = original.SsisFolder
type SsisObjectMetadata = original.SsisObjectMetadata
type SsisObjectMetadataListResponse = original.SsisObjectMetadataListResponse
type SsisObjectMetadataStatusResponse = original.SsisObjectMetadataStatusResponse
type SsisPackage = original.SsisPackage
type SsisParameter = original.SsisParameter
type SsisProject = original.SsisProject
type SsisVariable = original.SsisVariable
type SubResource = original.SubResource
type TopQueries = original.TopQueries
type TopQueriesListResult = original.TopQueriesListResult
type TrackedResource = original.TrackedResource
type TransparentDataEncryption = original.TransparentDataEncryption
type TransparentDataEncryptionListResult = original.TransparentDataEncryptionListResult
type TransparentDataEncryptionListResultIterator = original.TransparentDataEncryptionListResultIterator
type TransparentDataEncryptionListResultPage = original.TransparentDataEncryptionListResultPage
type TransparentDataEncryptionProperties = original.TransparentDataEncryptionProperties
type UpdateIntegrationRuntimeNodeRequest = original.UpdateIntegrationRuntimeNodeRequest
type UpdateIntegrationRuntimeRequest = original.UpdateIntegrationRuntimeRequest
type VirtualNetworkProfile = original.VirtualNetworkProfile
type VulnerabilityAssessmentRecurringScansProperties = original.VulnerabilityAssessmentRecurringScansProperties
type VulnerabilityAssessmentScanError = original.VulnerabilityAssessmentScanError
type VulnerabilityAssessmentScanRecord = original.VulnerabilityAssessmentScanRecord
type VulnerabilityAssessmentScanRecordListResult = original.VulnerabilityAssessmentScanRecordListResult
type VulnerabilityAssessmentScanRecordListResultIterator = original.VulnerabilityAssessmentScanRecordListResultIterator
type VulnerabilityAssessmentScanRecordListResultPage = original.VulnerabilityAssessmentScanRecordListResultPage
type VulnerabilityAssessmentScanRecordProperties = original.VulnerabilityAssessmentScanRecordProperties
type WorkloadClassifier = original.WorkloadClassifier
type WorkloadClassifierListResult = original.WorkloadClassifierListResult
type WorkloadClassifierListResultIterator = original.WorkloadClassifierListResultIterator
type WorkloadClassifierListResultPage = original.WorkloadClassifierListResultPage
type WorkloadClassifierProperties = original.WorkloadClassifierProperties
type WorkloadGroup = original.WorkloadGroup
type WorkloadGroupListResult = original.WorkloadGroupListResult
type WorkloadGroupListResultIterator = original.WorkloadGroupListResultIterator
type WorkloadGroupListResultPage = original.WorkloadGroupListResultPage
type WorkloadGroupProperties = original.WorkloadGroupProperties
type Workspace = original.Workspace
type WorkspaceAadAdminInfo = original.WorkspaceAadAdminInfo
type WorkspaceAadAdminsClient = original.WorkspaceAadAdminsClient
type WorkspaceAadAdminsCreateOrUpdateFuture = original.WorkspaceAadAdminsCreateOrUpdateFuture
type WorkspaceAadAdminsDeleteFuture = original.WorkspaceAadAdminsDeleteFuture
type WorkspaceInfoListResult = original.WorkspaceInfoListResult
type WorkspaceInfoListResultIterator = original.WorkspaceInfoListResultIterator
type WorkspaceInfoListResultPage = original.WorkspaceInfoListResultPage
type WorkspaceKeyDetails = original.WorkspaceKeyDetails
type WorkspaceManagedIdentitySQLControlSettingsClient = original.WorkspaceManagedIdentitySQLControlSettingsClient
type WorkspaceManagedIdentitySQLControlSettingsCreateOrUpdateFuture = original.WorkspaceManagedIdentitySQLControlSettingsCreateOrUpdateFuture
type WorkspaceManagedSQLServerBlobAuditingPoliciesClient = original.WorkspaceManagedSQLServerBlobAuditingPoliciesClient
type WorkspaceManagedSQLServerBlobAuditingPoliciesCreateOrUpdateFuture = original.WorkspaceManagedSQLServerBlobAuditingPoliciesCreateOrUpdateFuture
type WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient = original.WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient
type WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesCreateOrUpdateFuture = original.WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesCreateOrUpdateFuture
type WorkspaceManagedSQLServerRecoverableSqlpoolsClient = original.WorkspaceManagedSQLServerRecoverableSqlpoolsClient
type WorkspaceManagedSQLServerSecurityAlertPolicyClient = original.WorkspaceManagedSQLServerSecurityAlertPolicyClient
type WorkspaceManagedSQLServerSecurityAlertPolicyCreateOrUpdateFuture = original.WorkspaceManagedSQLServerSecurityAlertPolicyCreateOrUpdateFuture
type WorkspaceManagedSQLServerUsagesClient = original.WorkspaceManagedSQLServerUsagesClient
type WorkspaceManagedSQLServerVulnerabilityAssessmentsClient = original.WorkspaceManagedSQLServerVulnerabilityAssessmentsClient
type WorkspacePatchInfo = original.WorkspacePatchInfo
type WorkspacePatchProperties = original.WorkspacePatchProperties
type WorkspaceProperties = original.WorkspaceProperties
type WorkspaceRepositoryConfiguration = original.WorkspaceRepositoryConfiguration
type WorkspaceSQLAadAdminsClient = original.WorkspaceSQLAadAdminsClient
type WorkspaceSQLAadAdminsCreateOrUpdateFuture = original.WorkspaceSQLAadAdminsCreateOrUpdateFuture
type WorkspaceSQLAadAdminsDeleteFuture = original.WorkspaceSQLAadAdminsDeleteFuture
type WorkspacesClient = original.WorkspacesClient
type WorkspacesCreateOrUpdateFuture = original.WorkspacesCreateOrUpdateFuture
type WorkspacesDeleteFuture = original.WorkspacesDeleteFuture
type WorkspacesUpdateFuture = original.WorkspacesUpdateFuture

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewBigDataPoolResourceInfoListResultIterator(page BigDataPoolResourceInfoListResultPage) BigDataPoolResourceInfoListResultIterator {
	return original.NewBigDataPoolResourceInfoListResultIterator(page)
}
func NewBigDataPoolResourceInfoListResultPage(cur BigDataPoolResourceInfoListResult, getNextPage func(context.Context, BigDataPoolResourceInfoListResult) (BigDataPoolResourceInfoListResult, error)) BigDataPoolResourceInfoListResultPage {
	return original.NewBigDataPoolResourceInfoListResultPage(cur, getNextPage)
}
func NewBigDataPoolsClient(subscriptionID string) BigDataPoolsClient {
	return original.NewBigDataPoolsClient(subscriptionID)
}
func NewBigDataPoolsClientWithBaseURI(baseURI string, subscriptionID string) BigDataPoolsClient {
	return original.NewBigDataPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataMaskingPoliciesClient(subscriptionID string) DataMaskingPoliciesClient {
	return original.NewDataMaskingPoliciesClient(subscriptionID)
}
func NewDataMaskingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) DataMaskingPoliciesClient {
	return original.NewDataMaskingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataMaskingRulesClient(subscriptionID string) DataMaskingRulesClient {
	return original.NewDataMaskingRulesClient(subscriptionID)
}
func NewDataMaskingRulesClientWithBaseURI(baseURI string, subscriptionID string) DataMaskingRulesClient {
	return original.NewDataMaskingRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewExtendedSQLPoolBlobAuditingPoliciesClient(subscriptionID string) ExtendedSQLPoolBlobAuditingPoliciesClient {
	return original.NewExtendedSQLPoolBlobAuditingPoliciesClient(subscriptionID)
}
func NewExtendedSQLPoolBlobAuditingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) ExtendedSQLPoolBlobAuditingPoliciesClient {
	return original.NewExtendedSQLPoolBlobAuditingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewExtendedSQLPoolBlobAuditingPolicyListResultIterator(page ExtendedSQLPoolBlobAuditingPolicyListResultPage) ExtendedSQLPoolBlobAuditingPolicyListResultIterator {
	return original.NewExtendedSQLPoolBlobAuditingPolicyListResultIterator(page)
}
func NewExtendedSQLPoolBlobAuditingPolicyListResultPage(cur ExtendedSQLPoolBlobAuditingPolicyListResult, getNextPage func(context.Context, ExtendedSQLPoolBlobAuditingPolicyListResult) (ExtendedSQLPoolBlobAuditingPolicyListResult, error)) ExtendedSQLPoolBlobAuditingPolicyListResultPage {
	return original.NewExtendedSQLPoolBlobAuditingPolicyListResultPage(cur, getNextPage)
}
func NewExtendedServerBlobAuditingPolicyListResultIterator(page ExtendedServerBlobAuditingPolicyListResultPage) ExtendedServerBlobAuditingPolicyListResultIterator {
	return original.NewExtendedServerBlobAuditingPolicyListResultIterator(page)
}
func NewExtendedServerBlobAuditingPolicyListResultPage(cur ExtendedServerBlobAuditingPolicyListResult, getNextPage func(context.Context, ExtendedServerBlobAuditingPolicyListResult) (ExtendedServerBlobAuditingPolicyListResult, error)) ExtendedServerBlobAuditingPolicyListResultPage {
	return original.NewExtendedServerBlobAuditingPolicyListResultPage(cur, getNextPage)
}
func NewIPFirewallRuleInfoListResultIterator(page IPFirewallRuleInfoListResultPage) IPFirewallRuleInfoListResultIterator {
	return original.NewIPFirewallRuleInfoListResultIterator(page)
}
func NewIPFirewallRuleInfoListResultPage(cur IPFirewallRuleInfoListResult, getNextPage func(context.Context, IPFirewallRuleInfoListResult) (IPFirewallRuleInfoListResult, error)) IPFirewallRuleInfoListResultPage {
	return original.NewIPFirewallRuleInfoListResultPage(cur, getNextPage)
}
func NewIPFirewallRulesClient(subscriptionID string) IPFirewallRulesClient {
	return original.NewIPFirewallRulesClient(subscriptionID)
}
func NewIPFirewallRulesClientWithBaseURI(baseURI string, subscriptionID string) IPFirewallRulesClient {
	return original.NewIPFirewallRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimeAuthKeysClient(subscriptionID string) IntegrationRuntimeAuthKeysClient {
	return original.NewIntegrationRuntimeAuthKeysClient(subscriptionID)
}
func NewIntegrationRuntimeAuthKeysClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeAuthKeysClient {
	return original.NewIntegrationRuntimeAuthKeysClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimeConnectionInfosClient(subscriptionID string) IntegrationRuntimeConnectionInfosClient {
	return original.NewIntegrationRuntimeConnectionInfosClient(subscriptionID)
}
func NewIntegrationRuntimeConnectionInfosClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeConnectionInfosClient {
	return original.NewIntegrationRuntimeConnectionInfosClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimeCredentialsClient(subscriptionID string) IntegrationRuntimeCredentialsClient {
	return original.NewIntegrationRuntimeCredentialsClient(subscriptionID)
}
func NewIntegrationRuntimeCredentialsClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeCredentialsClient {
	return original.NewIntegrationRuntimeCredentialsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimeListResponseIterator(page IntegrationRuntimeListResponsePage) IntegrationRuntimeListResponseIterator {
	return original.NewIntegrationRuntimeListResponseIterator(page)
}
func NewIntegrationRuntimeListResponsePage(cur IntegrationRuntimeListResponse, getNextPage func(context.Context, IntegrationRuntimeListResponse) (IntegrationRuntimeListResponse, error)) IntegrationRuntimeListResponsePage {
	return original.NewIntegrationRuntimeListResponsePage(cur, getNextPage)
}
func NewIntegrationRuntimeMonitoringDataClient(subscriptionID string) IntegrationRuntimeMonitoringDataClient {
	return original.NewIntegrationRuntimeMonitoringDataClient(subscriptionID)
}
func NewIntegrationRuntimeMonitoringDataClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeMonitoringDataClient {
	return original.NewIntegrationRuntimeMonitoringDataClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimeNodeIPAddressClient(subscriptionID string) IntegrationRuntimeNodeIPAddressClient {
	return original.NewIntegrationRuntimeNodeIPAddressClient(subscriptionID)
}
func NewIntegrationRuntimeNodeIPAddressClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeNodeIPAddressClient {
	return original.NewIntegrationRuntimeNodeIPAddressClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimeNodesClient(subscriptionID string) IntegrationRuntimeNodesClient {
	return original.NewIntegrationRuntimeNodesClient(subscriptionID)
}
func NewIntegrationRuntimeNodesClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeNodesClient {
	return original.NewIntegrationRuntimeNodesClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimeObjectMetadataClient(subscriptionID string) IntegrationRuntimeObjectMetadataClient {
	return original.NewIntegrationRuntimeObjectMetadataClient(subscriptionID)
}
func NewIntegrationRuntimeObjectMetadataClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeObjectMetadataClient {
	return original.NewIntegrationRuntimeObjectMetadataClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimeStatusClient(subscriptionID string) IntegrationRuntimeStatusClient {
	return original.NewIntegrationRuntimeStatusClient(subscriptionID)
}
func NewIntegrationRuntimeStatusClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimeStatusClient {
	return original.NewIntegrationRuntimeStatusClientWithBaseURI(baseURI, subscriptionID)
}
func NewIntegrationRuntimesClient(subscriptionID string) IntegrationRuntimesClient {
	return original.NewIntegrationRuntimesClient(subscriptionID)
}
func NewIntegrationRuntimesClientWithBaseURI(baseURI string, subscriptionID string) IntegrationRuntimesClient {
	return original.NewIntegrationRuntimesClientWithBaseURI(baseURI, subscriptionID)
}
func NewKeyInfoListResultIterator(page KeyInfoListResultPage) KeyInfoListResultIterator {
	return original.NewKeyInfoListResultIterator(page)
}
func NewKeyInfoListResultPage(cur KeyInfoListResult, getNextPage func(context.Context, KeyInfoListResult) (KeyInfoListResult, error)) KeyInfoListResultPage {
	return original.NewKeyInfoListResultPage(cur, getNextPage)
}
func NewKeysClient(subscriptionID string) KeysClient {
	return original.NewKeysClient(subscriptionID)
}
func NewKeysClientWithBaseURI(baseURI string, subscriptionID string) KeysClient {
	return original.NewKeysClientWithBaseURI(baseURI, subscriptionID)
}
func NewListSQLPoolSecurityAlertPoliciesIterator(page ListSQLPoolSecurityAlertPoliciesPage) ListSQLPoolSecurityAlertPoliciesIterator {
	return original.NewListSQLPoolSecurityAlertPoliciesIterator(page)
}
func NewListSQLPoolSecurityAlertPoliciesPage(cur ListSQLPoolSecurityAlertPolicies, getNextPage func(context.Context, ListSQLPoolSecurityAlertPolicies) (ListSQLPoolSecurityAlertPolicies, error)) ListSQLPoolSecurityAlertPoliciesPage {
	return original.NewListSQLPoolSecurityAlertPoliciesPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator(page PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage) PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator {
	return original.NewPrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponseIterator(page)
}
func NewPrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage(cur PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse, getNextPage func(context.Context, PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse) (PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse, error)) PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage {
	return original.NewPrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponsePage(cur, getNextPage)
}
func NewPrivateEndpointConnectionListIterator(page PrivateEndpointConnectionListPage) PrivateEndpointConnectionListIterator {
	return original.NewPrivateEndpointConnectionListIterator(page)
}
func NewPrivateEndpointConnectionListPage(cur PrivateEndpointConnectionList, getNextPage func(context.Context, PrivateEndpointConnectionList) (PrivateEndpointConnectionList, error)) PrivateEndpointConnectionListPage {
	return original.NewPrivateEndpointConnectionListPage(cur, getNextPage)
}
func NewPrivateEndpointConnectionsClient(subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClient(subscriptionID)
}
func NewPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionsPrivateLinkHubClient(subscriptionID string) PrivateEndpointConnectionsPrivateLinkHubClient {
	return original.NewPrivateEndpointConnectionsPrivateLinkHubClient(subscriptionID)
}
func NewPrivateEndpointConnectionsPrivateLinkHubClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionsPrivateLinkHubClient {
	return original.NewPrivateEndpointConnectionsPrivateLinkHubClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkHubInfoListResultIterator(page PrivateLinkHubInfoListResultPage) PrivateLinkHubInfoListResultIterator {
	return original.NewPrivateLinkHubInfoListResultIterator(page)
}
func NewPrivateLinkHubInfoListResultPage(cur PrivateLinkHubInfoListResult, getNextPage func(context.Context, PrivateLinkHubInfoListResult) (PrivateLinkHubInfoListResult, error)) PrivateLinkHubInfoListResultPage {
	return original.NewPrivateLinkHubInfoListResultPage(cur, getNextPage)
}
func NewPrivateLinkHubsClient(subscriptionID string) PrivateLinkHubsClient {
	return original.NewPrivateLinkHubsClient(subscriptionID)
}
func NewPrivateLinkHubsClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkHubsClient {
	return original.NewPrivateLinkHubsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkResourceListResultIterator(page PrivateLinkResourceListResultPage) PrivateLinkResourceListResultIterator {
	return original.NewPrivateLinkResourceListResultIterator(page)
}
func NewPrivateLinkResourceListResultPage(cur PrivateLinkResourceListResult, getNextPage func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)) PrivateLinkResourceListResultPage {
	return original.NewPrivateLinkResourceListResultPage(cur, getNextPage)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRecoverableSQLPoolListResultIterator(page RecoverableSQLPoolListResultPage) RecoverableSQLPoolListResultIterator {
	return original.NewRecoverableSQLPoolListResultIterator(page)
}
func NewRecoverableSQLPoolListResultPage(cur RecoverableSQLPoolListResult, getNextPage func(context.Context, RecoverableSQLPoolListResult) (RecoverableSQLPoolListResult, error)) RecoverableSQLPoolListResultPage {
	return original.NewRecoverableSQLPoolListResultPage(cur, getNextPage)
}
func NewReplicationLinkListResultIterator(page ReplicationLinkListResultPage) ReplicationLinkListResultIterator {
	return original.NewReplicationLinkListResultIterator(page)
}
func NewReplicationLinkListResultPage(cur ReplicationLinkListResult, getNextPage func(context.Context, ReplicationLinkListResult) (ReplicationLinkListResult, error)) ReplicationLinkListResultPage {
	return original.NewReplicationLinkListResultPage(cur, getNextPage)
}
func NewRestorableDroppedSQLPoolsClient(subscriptionID string) RestorableDroppedSQLPoolsClient {
	return original.NewRestorableDroppedSQLPoolsClient(subscriptionID)
}
func NewRestorableDroppedSQLPoolsClientWithBaseURI(baseURI string, subscriptionID string) RestorableDroppedSQLPoolsClient {
	return original.NewRestorableDroppedSQLPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorePointListResultIterator(page RestorePointListResultPage) RestorePointListResultIterator {
	return original.NewRestorePointListResultIterator(page)
}
func NewRestorePointListResultPage(cur RestorePointListResult, getNextPage func(context.Context, RestorePointListResult) (RestorePointListResult, error)) RestorePointListResultPage {
	return original.NewRestorePointListResultPage(cur, getNextPage)
}
func NewSQLPoolBlobAuditingPoliciesClient(subscriptionID string) SQLPoolBlobAuditingPoliciesClient {
	return original.NewSQLPoolBlobAuditingPoliciesClient(subscriptionID)
}
func NewSQLPoolBlobAuditingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolBlobAuditingPoliciesClient {
	return original.NewSQLPoolBlobAuditingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolBlobAuditingPolicyListResultIterator(page SQLPoolBlobAuditingPolicyListResultPage) SQLPoolBlobAuditingPolicyListResultIterator {
	return original.NewSQLPoolBlobAuditingPolicyListResultIterator(page)
}
func NewSQLPoolBlobAuditingPolicyListResultPage(cur SQLPoolBlobAuditingPolicyListResult, getNextPage func(context.Context, SQLPoolBlobAuditingPolicyListResult) (SQLPoolBlobAuditingPolicyListResult, error)) SQLPoolBlobAuditingPolicyListResultPage {
	return original.NewSQLPoolBlobAuditingPolicyListResultPage(cur, getNextPage)
}
func NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator(page SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage) SQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator {
	return original.NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultIterator(page)
}
func NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultPage(cur SQLPoolBlobAuditingPolicySQLPoolOperationListResult, getNextPage func(context.Context, SQLPoolBlobAuditingPolicySQLPoolOperationListResult) (SQLPoolBlobAuditingPolicySQLPoolOperationListResult, error)) SQLPoolBlobAuditingPolicySQLPoolOperationListResultPage {
	return original.NewSQLPoolBlobAuditingPolicySQLPoolOperationListResultPage(cur, getNextPage)
}
func NewSQLPoolColumnListResultIterator(page SQLPoolColumnListResultPage) SQLPoolColumnListResultIterator {
	return original.NewSQLPoolColumnListResultIterator(page)
}
func NewSQLPoolColumnListResultPage(cur SQLPoolColumnListResult, getNextPage func(context.Context, SQLPoolColumnListResult) (SQLPoolColumnListResult, error)) SQLPoolColumnListResultPage {
	return original.NewSQLPoolColumnListResultPage(cur, getNextPage)
}
func NewSQLPoolColumnsClient(subscriptionID string) SQLPoolColumnsClient {
	return original.NewSQLPoolColumnsClient(subscriptionID)
}
func NewSQLPoolColumnsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolColumnsClient {
	return original.NewSQLPoolColumnsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolConnectionPoliciesClient(subscriptionID string) SQLPoolConnectionPoliciesClient {
	return original.NewSQLPoolConnectionPoliciesClient(subscriptionID)
}
func NewSQLPoolConnectionPoliciesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolConnectionPoliciesClient {
	return original.NewSQLPoolConnectionPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolDataWarehouseUserActivitiesClient(subscriptionID string) SQLPoolDataWarehouseUserActivitiesClient {
	return original.NewSQLPoolDataWarehouseUserActivitiesClient(subscriptionID)
}
func NewSQLPoolDataWarehouseUserActivitiesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolDataWarehouseUserActivitiesClient {
	return original.NewSQLPoolDataWarehouseUserActivitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolGeoBackupPoliciesClient(subscriptionID string) SQLPoolGeoBackupPoliciesClient {
	return original.NewSQLPoolGeoBackupPoliciesClient(subscriptionID)
}
func NewSQLPoolGeoBackupPoliciesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolGeoBackupPoliciesClient {
	return original.NewSQLPoolGeoBackupPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolInfoListResultIterator(page SQLPoolInfoListResultPage) SQLPoolInfoListResultIterator {
	return original.NewSQLPoolInfoListResultIterator(page)
}
func NewSQLPoolInfoListResultPage(cur SQLPoolInfoListResult, getNextPage func(context.Context, SQLPoolInfoListResult) (SQLPoolInfoListResult, error)) SQLPoolInfoListResultPage {
	return original.NewSQLPoolInfoListResultPage(cur, getNextPage)
}
func NewSQLPoolMetadataSyncConfigsClient(subscriptionID string) SQLPoolMetadataSyncConfigsClient {
	return original.NewSQLPoolMetadataSyncConfigsClient(subscriptionID)
}
func NewSQLPoolMetadataSyncConfigsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolMetadataSyncConfigsClient {
	return original.NewSQLPoolMetadataSyncConfigsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolOperationResultsClient(subscriptionID string) SQLPoolOperationResultsClient {
	return original.NewSQLPoolOperationResultsClient(subscriptionID)
}
func NewSQLPoolOperationResultsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolOperationResultsClient {
	return original.NewSQLPoolOperationResultsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolOperationsClient(subscriptionID string) SQLPoolOperationsClient {
	return original.NewSQLPoolOperationsClient(subscriptionID)
}
func NewSQLPoolOperationsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolOperationsClient {
	return original.NewSQLPoolOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolReplicationLinksClient(subscriptionID string) SQLPoolReplicationLinksClient {
	return original.NewSQLPoolReplicationLinksClient(subscriptionID)
}
func NewSQLPoolReplicationLinksClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolReplicationLinksClient {
	return original.NewSQLPoolReplicationLinksClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolRestorePointsClient(subscriptionID string) SQLPoolRestorePointsClient {
	return original.NewSQLPoolRestorePointsClient(subscriptionID)
}
func NewSQLPoolRestorePointsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolRestorePointsClient {
	return original.NewSQLPoolRestorePointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolSchemaListResultIterator(page SQLPoolSchemaListResultPage) SQLPoolSchemaListResultIterator {
	return original.NewSQLPoolSchemaListResultIterator(page)
}
func NewSQLPoolSchemaListResultPage(cur SQLPoolSchemaListResult, getNextPage func(context.Context, SQLPoolSchemaListResult) (SQLPoolSchemaListResult, error)) SQLPoolSchemaListResultPage {
	return original.NewSQLPoolSchemaListResultPage(cur, getNextPage)
}
func NewSQLPoolSchemasClient(subscriptionID string) SQLPoolSchemasClient {
	return original.NewSQLPoolSchemasClient(subscriptionID)
}
func NewSQLPoolSchemasClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolSchemasClient {
	return original.NewSQLPoolSchemasClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolSecurityAlertPoliciesClient(subscriptionID string) SQLPoolSecurityAlertPoliciesClient {
	return original.NewSQLPoolSecurityAlertPoliciesClient(subscriptionID)
}
func NewSQLPoolSecurityAlertPoliciesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolSecurityAlertPoliciesClient {
	return original.NewSQLPoolSecurityAlertPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolSensitivityLabelsClient(subscriptionID string) SQLPoolSensitivityLabelsClient {
	return original.NewSQLPoolSensitivityLabelsClient(subscriptionID)
}
func NewSQLPoolSensitivityLabelsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolSensitivityLabelsClient {
	return original.NewSQLPoolSensitivityLabelsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolTableColumnsClient(subscriptionID string) SQLPoolTableColumnsClient {
	return original.NewSQLPoolTableColumnsClient(subscriptionID)
}
func NewSQLPoolTableColumnsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolTableColumnsClient {
	return original.NewSQLPoolTableColumnsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolTableListResultIterator(page SQLPoolTableListResultPage) SQLPoolTableListResultIterator {
	return original.NewSQLPoolTableListResultIterator(page)
}
func NewSQLPoolTableListResultPage(cur SQLPoolTableListResult, getNextPage func(context.Context, SQLPoolTableListResult) (SQLPoolTableListResult, error)) SQLPoolTableListResultPage {
	return original.NewSQLPoolTableListResultPage(cur, getNextPage)
}
func NewSQLPoolTablesClient(subscriptionID string) SQLPoolTablesClient {
	return original.NewSQLPoolTablesClient(subscriptionID)
}
func NewSQLPoolTablesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolTablesClient {
	return original.NewSQLPoolTablesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolTransparentDataEncryptionsClient(subscriptionID string) SQLPoolTransparentDataEncryptionsClient {
	return original.NewSQLPoolTransparentDataEncryptionsClient(subscriptionID)
}
func NewSQLPoolTransparentDataEncryptionsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolTransparentDataEncryptionsClient {
	return original.NewSQLPoolTransparentDataEncryptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolUsageListResultIterator(page SQLPoolUsageListResultPage) SQLPoolUsageListResultIterator {
	return original.NewSQLPoolUsageListResultIterator(page)
}
func NewSQLPoolUsageListResultPage(cur SQLPoolUsageListResult, getNextPage func(context.Context, SQLPoolUsageListResult) (SQLPoolUsageListResult, error)) SQLPoolUsageListResultPage {
	return original.NewSQLPoolUsageListResultPage(cur, getNextPage)
}
func NewSQLPoolUsagesClient(subscriptionID string) SQLPoolUsagesClient {
	return original.NewSQLPoolUsagesClient(subscriptionID)
}
func NewSQLPoolUsagesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolUsagesClient {
	return original.NewSQLPoolUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentListResultIterator(page SQLPoolVulnerabilityAssessmentListResultPage) SQLPoolVulnerabilityAssessmentListResultIterator {
	return original.NewSQLPoolVulnerabilityAssessmentListResultIterator(page)
}
func NewSQLPoolVulnerabilityAssessmentListResultPage(cur SQLPoolVulnerabilityAssessmentListResult, getNextPage func(context.Context, SQLPoolVulnerabilityAssessmentListResult) (SQLPoolVulnerabilityAssessmentListResult, error)) SQLPoolVulnerabilityAssessmentListResultPage {
	return original.NewSQLPoolVulnerabilityAssessmentListResultPage(cur, getNextPage)
}
func NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient(subscriptionID string) SQLPoolVulnerabilityAssessmentRuleBaselinesClient {
	return original.NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient(subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentRuleBaselinesClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolVulnerabilityAssessmentRuleBaselinesClient {
	return original.NewSQLPoolVulnerabilityAssessmentRuleBaselinesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentScansClient(subscriptionID string) SQLPoolVulnerabilityAssessmentScansClient {
	return original.NewSQLPoolVulnerabilityAssessmentScansClient(subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentScansClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolVulnerabilityAssessmentScansClient {
	return original.NewSQLPoolVulnerabilityAssessmentScansClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentsClient(subscriptionID string) SQLPoolVulnerabilityAssessmentsClient {
	return original.NewSQLPoolVulnerabilityAssessmentsClient(subscriptionID)
}
func NewSQLPoolVulnerabilityAssessmentsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolVulnerabilityAssessmentsClient {
	return original.NewSQLPoolVulnerabilityAssessmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolWorkloadClassifierClient(subscriptionID string) SQLPoolWorkloadClassifierClient {
	return original.NewSQLPoolWorkloadClassifierClient(subscriptionID)
}
func NewSQLPoolWorkloadClassifierClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolWorkloadClassifierClient {
	return original.NewSQLPoolWorkloadClassifierClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolWorkloadGroupClient(subscriptionID string) SQLPoolWorkloadGroupClient {
	return original.NewSQLPoolWorkloadGroupClient(subscriptionID)
}
func NewSQLPoolWorkloadGroupClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolWorkloadGroupClient {
	return original.NewSQLPoolWorkloadGroupClientWithBaseURI(baseURI, subscriptionID)
}
func NewSQLPoolsClient(subscriptionID string) SQLPoolsClient {
	return original.NewSQLPoolsClient(subscriptionID)
}
func NewSQLPoolsClientWithBaseURI(baseURI string, subscriptionID string) SQLPoolsClient {
	return original.NewSQLPoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSensitivityLabelListResultIterator(page SensitivityLabelListResultPage) SensitivityLabelListResultIterator {
	return original.NewSensitivityLabelListResultIterator(page)
}
func NewSensitivityLabelListResultPage(cur SensitivityLabelListResult, getNextPage func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)) SensitivityLabelListResultPage {
	return original.NewSensitivityLabelListResultPage(cur, getNextPage)
}
func NewServerBlobAuditingPolicyListResultIterator(page ServerBlobAuditingPolicyListResultPage) ServerBlobAuditingPolicyListResultIterator {
	return original.NewServerBlobAuditingPolicyListResultIterator(page)
}
func NewServerBlobAuditingPolicyListResultPage(cur ServerBlobAuditingPolicyListResult, getNextPage func(context.Context, ServerBlobAuditingPolicyListResult) (ServerBlobAuditingPolicyListResult, error)) ServerBlobAuditingPolicyListResultPage {
	return original.NewServerBlobAuditingPolicyListResultPage(cur, getNextPage)
}
func NewServerSecurityAlertPolicyListResultIterator(page ServerSecurityAlertPolicyListResultPage) ServerSecurityAlertPolicyListResultIterator {
	return original.NewServerSecurityAlertPolicyListResultIterator(page)
}
func NewServerSecurityAlertPolicyListResultPage(cur ServerSecurityAlertPolicyListResult, getNextPage func(context.Context, ServerSecurityAlertPolicyListResult) (ServerSecurityAlertPolicyListResult, error)) ServerSecurityAlertPolicyListResultPage {
	return original.NewServerSecurityAlertPolicyListResultPage(cur, getNextPage)
}
func NewServerUsageListResultIterator(page ServerUsageListResultPage) ServerUsageListResultIterator {
	return original.NewServerUsageListResultIterator(page)
}
func NewServerUsageListResultPage(cur ServerUsageListResult, getNextPage func(context.Context, ServerUsageListResult) (ServerUsageListResult, error)) ServerUsageListResultPage {
	return original.NewServerUsageListResultPage(cur, getNextPage)
}
func NewServerVulnerabilityAssessmentListResultIterator(page ServerVulnerabilityAssessmentListResultPage) ServerVulnerabilityAssessmentListResultIterator {
	return original.NewServerVulnerabilityAssessmentListResultIterator(page)
}
func NewServerVulnerabilityAssessmentListResultPage(cur ServerVulnerabilityAssessmentListResult, getNextPage func(context.Context, ServerVulnerabilityAssessmentListResult) (ServerVulnerabilityAssessmentListResult, error)) ServerVulnerabilityAssessmentListResultPage {
	return original.NewServerVulnerabilityAssessmentListResultPage(cur, getNextPage)
}
func NewTransparentDataEncryptionListResultIterator(page TransparentDataEncryptionListResultPage) TransparentDataEncryptionListResultIterator {
	return original.NewTransparentDataEncryptionListResultIterator(page)
}
func NewTransparentDataEncryptionListResultPage(cur TransparentDataEncryptionListResult, getNextPage func(context.Context, TransparentDataEncryptionListResult) (TransparentDataEncryptionListResult, error)) TransparentDataEncryptionListResultPage {
	return original.NewTransparentDataEncryptionListResultPage(cur, getNextPage)
}
func NewVulnerabilityAssessmentScanRecordListResultIterator(page VulnerabilityAssessmentScanRecordListResultPage) VulnerabilityAssessmentScanRecordListResultIterator {
	return original.NewVulnerabilityAssessmentScanRecordListResultIterator(page)
}
func NewVulnerabilityAssessmentScanRecordListResultPage(cur VulnerabilityAssessmentScanRecordListResult, getNextPage func(context.Context, VulnerabilityAssessmentScanRecordListResult) (VulnerabilityAssessmentScanRecordListResult, error)) VulnerabilityAssessmentScanRecordListResultPage {
	return original.NewVulnerabilityAssessmentScanRecordListResultPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewWorkloadClassifierListResultIterator(page WorkloadClassifierListResultPage) WorkloadClassifierListResultIterator {
	return original.NewWorkloadClassifierListResultIterator(page)
}
func NewWorkloadClassifierListResultPage(cur WorkloadClassifierListResult, getNextPage func(context.Context, WorkloadClassifierListResult) (WorkloadClassifierListResult, error)) WorkloadClassifierListResultPage {
	return original.NewWorkloadClassifierListResultPage(cur, getNextPage)
}
func NewWorkloadGroupListResultIterator(page WorkloadGroupListResultPage) WorkloadGroupListResultIterator {
	return original.NewWorkloadGroupListResultIterator(page)
}
func NewWorkloadGroupListResultPage(cur WorkloadGroupListResult, getNextPage func(context.Context, WorkloadGroupListResult) (WorkloadGroupListResult, error)) WorkloadGroupListResultPage {
	return original.NewWorkloadGroupListResultPage(cur, getNextPage)
}
func NewWorkspaceAadAdminsClient(subscriptionID string) WorkspaceAadAdminsClient {
	return original.NewWorkspaceAadAdminsClient(subscriptionID)
}
func NewWorkspaceAadAdminsClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceAadAdminsClient {
	return original.NewWorkspaceAadAdminsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceInfoListResultIterator(page WorkspaceInfoListResultPage) WorkspaceInfoListResultIterator {
	return original.NewWorkspaceInfoListResultIterator(page)
}
func NewWorkspaceInfoListResultPage(cur WorkspaceInfoListResult, getNextPage func(context.Context, WorkspaceInfoListResult) (WorkspaceInfoListResult, error)) WorkspaceInfoListResultPage {
	return original.NewWorkspaceInfoListResultPage(cur, getNextPage)
}
func NewWorkspaceManagedIdentitySQLControlSettingsClient(subscriptionID string) WorkspaceManagedIdentitySQLControlSettingsClient {
	return original.NewWorkspaceManagedIdentitySQLControlSettingsClient(subscriptionID)
}
func NewWorkspaceManagedIdentitySQLControlSettingsClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceManagedIdentitySQLControlSettingsClient {
	return original.NewWorkspaceManagedIdentitySQLControlSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceManagedSQLServerBlobAuditingPoliciesClient(subscriptionID string) WorkspaceManagedSQLServerBlobAuditingPoliciesClient {
	return original.NewWorkspaceManagedSQLServerBlobAuditingPoliciesClient(subscriptionID)
}
func NewWorkspaceManagedSQLServerBlobAuditingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceManagedSQLServerBlobAuditingPoliciesClient {
	return original.NewWorkspaceManagedSQLServerBlobAuditingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient(subscriptionID string) WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient {
	return original.NewWorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient(subscriptionID)
}
func NewWorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient {
	return original.NewWorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceManagedSQLServerRecoverableSqlpoolsClient(subscriptionID string) WorkspaceManagedSQLServerRecoverableSqlpoolsClient {
	return original.NewWorkspaceManagedSQLServerRecoverableSqlpoolsClient(subscriptionID)
}
func NewWorkspaceManagedSQLServerRecoverableSqlpoolsClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceManagedSQLServerRecoverableSqlpoolsClient {
	return original.NewWorkspaceManagedSQLServerRecoverableSqlpoolsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceManagedSQLServerSecurityAlertPolicyClient(subscriptionID string) WorkspaceManagedSQLServerSecurityAlertPolicyClient {
	return original.NewWorkspaceManagedSQLServerSecurityAlertPolicyClient(subscriptionID)
}
func NewWorkspaceManagedSQLServerSecurityAlertPolicyClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceManagedSQLServerSecurityAlertPolicyClient {
	return original.NewWorkspaceManagedSQLServerSecurityAlertPolicyClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceManagedSQLServerUsagesClient(subscriptionID string) WorkspaceManagedSQLServerUsagesClient {
	return original.NewWorkspaceManagedSQLServerUsagesClient(subscriptionID)
}
func NewWorkspaceManagedSQLServerUsagesClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceManagedSQLServerUsagesClient {
	return original.NewWorkspaceManagedSQLServerUsagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient(subscriptionID string) WorkspaceManagedSQLServerVulnerabilityAssessmentsClient {
	return original.NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient(subscriptionID)
}
func NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceManagedSQLServerVulnerabilityAssessmentsClient {
	return original.NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceSQLAadAdminsClient(subscriptionID string) WorkspaceSQLAadAdminsClient {
	return original.NewWorkspaceSQLAadAdminsClient(subscriptionID)
}
func NewWorkspaceSQLAadAdminsClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceSQLAadAdminsClient {
	return original.NewWorkspaceSQLAadAdminsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspacesClient(subscriptionID string) WorkspacesClient {
	return original.NewWorkspacesClient(subscriptionID)
}
func NewWorkspacesClientWithBaseURI(baseURI string, subscriptionID string) WorkspacesClient {
	return original.NewWorkspacesClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleActualStateValues() []ActualState {
	return original.PossibleActualStateValues()
}
func PossibleAuthorizationTypeValues() []AuthorizationType {
	return original.PossibleAuthorizationTypeValues()
}
func PossibleBlobAuditingPolicyStateValues() []BlobAuditingPolicyState {
	return original.PossibleBlobAuditingPolicyStateValues()
}
func PossibleColumnDataTypeValues() []ColumnDataType {
	return original.PossibleColumnDataTypeValues()
}
func PossibleDataFlowComputeTypeValues() []DataFlowComputeType {
	return original.PossibleDataFlowComputeTypeValues()
}
func PossibleDataMaskingFunctionValues() []DataMaskingFunction {
	return original.PossibleDataMaskingFunctionValues()
}
func PossibleDataMaskingRuleStateValues() []DataMaskingRuleState {
	return original.PossibleDataMaskingRuleStateValues()
}
func PossibleDataMaskingStateValues() []DataMaskingState {
	return original.PossibleDataMaskingStateValues()
}
func PossibleDesiredStateValues() []DesiredState {
	return original.PossibleDesiredStateValues()
}
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return original.PossibleGeoBackupPolicyStateValues()
}
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return original.PossibleIntegrationRuntimeAuthKeyNameValues()
}
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return original.PossibleIntegrationRuntimeAutoUpdateValues()
}
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return original.PossibleIntegrationRuntimeEditionValues()
}
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return original.PossibleIntegrationRuntimeEntityReferenceTypeValues()
}
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return original.PossibleIntegrationRuntimeInternalChannelEncryptionModeValues()
}
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return original.PossibleIntegrationRuntimeLicenseTypeValues()
}
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return original.PossibleIntegrationRuntimeSsisCatalogPricingTierValues()
}
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return original.PossibleIntegrationRuntimeStateValues()
}
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return original.PossibleIntegrationRuntimeTypeValues()
}
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return original.PossibleIntegrationRuntimeUpdateResultValues()
}
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return original.PossibleManagedIntegrationRuntimeNodeStatusValues()
}
func PossibleManagementOperationStateValues() []ManagementOperationState {
	return original.PossibleManagementOperationStateValues()
}
func PossibleNodeSizeFamilyValues() []NodeSizeFamily {
	return original.PossibleNodeSizeFamilyValues()
}
func PossibleNodeSizeValues() []NodeSize {
	return original.PossibleNodeSizeValues()
}
func PossibleOperationStatusValues() []OperationStatus {
	return original.PossibleOperationStatusValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleQueryAggregationFunctionValues() []QueryAggregationFunction {
	return original.PossibleQueryAggregationFunctionValues()
}
func PossibleQueryExecutionTypeValues() []QueryExecutionType {
	return original.PossibleQueryExecutionTypeValues()
}
func PossibleQueryMetricUnitValues() []QueryMetricUnit {
	return original.PossibleQueryMetricUnitValues()
}
func PossibleQueryObservedMetricTypeValues() []QueryObservedMetricType {
	return original.PossibleQueryObservedMetricTypeValues()
}
func PossibleReplicationRoleValues() []ReplicationRole {
	return original.PossibleReplicationRoleValues()
}
func PossibleReplicationStateValues() []ReplicationState {
	return original.PossibleReplicationStateValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleRestorePointTypeValues() []RestorePointType {
	return original.PossibleRestorePointTypeValues()
}
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return original.PossibleSecurityAlertPolicyStateValues()
}
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return original.PossibleSelfHostedIntegrationRuntimeNodeStatusValues()
}
func PossibleSensitivityLabelSourceValues() []SensitivityLabelSource {
	return original.PossibleSensitivityLabelSourceValues()
}
func PossibleSsisObjectMetadataTypeValues() []SsisObjectMetadataType {
	return original.PossibleSsisObjectMetadataTypeValues()
}
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return original.PossibleTransparentDataEncryptionStatusValues()
}
func PossibleTypeBasicCustomSetupBaseValues() []TypeBasicCustomSetupBase {
	return original.PossibleTypeBasicCustomSetupBaseValues()
}
func PossibleTypeBasicIntegrationRuntimeStatusValues() []TypeBasicIntegrationRuntimeStatus {
	return original.PossibleTypeBasicIntegrationRuntimeStatusValues()
}
func PossibleTypeBasicSecretBaseValues() []TypeBasicSecretBase {
	return original.PossibleTypeBasicSecretBaseValues()
}
func PossibleTypeBasicSsisObjectMetadataValues() []TypeBasicSsisObjectMetadata {
	return original.PossibleTypeBasicSsisObjectMetadataValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleVulnerabilityAssessmentPolicyBaselineNameValues() []VulnerabilityAssessmentPolicyBaselineName {
	return original.PossibleVulnerabilityAssessmentPolicyBaselineNameValues()
}
func PossibleVulnerabilityAssessmentScanStateValues() []VulnerabilityAssessmentScanState {
	return original.PossibleVulnerabilityAssessmentScanStateValues()
}
func PossibleVulnerabilityAssessmentScanTriggerTypeValues() []VulnerabilityAssessmentScanTriggerType {
	return original.PossibleVulnerabilityAssessmentScanTriggerTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
