package customprovidersapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/customproviders/mgmt/2018-09-01-preview/customproviders"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result customproviders.ResourceProviderOperationListPage, err error)
	ListComplete(ctx context.Context) (result customproviders.ResourceProviderOperationListIterator, err error)
}

var _ OperationsClientAPI = (*customproviders.OperationsClient)(nil)

// CustomResourceProviderClientAPI contains the set of methods on the CustomResourceProviderClient type.
type CustomResourceProviderClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, resourceProviderName string, resourceProvider customproviders.CustomRPManifest) (result customproviders.CustomResourceProviderCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, resourceProviderName string) (result customproviders.CustomResourceProviderDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, resourceProviderName string) (result customproviders.CustomRPManifest, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result customproviders.ListByCustomRPManifestPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result customproviders.ListByCustomRPManifestIterator, err error)
	ListBySubscription(ctx context.Context) (result customproviders.ListByCustomRPManifestPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result customproviders.ListByCustomRPManifestIterator, err error)
	Update(ctx context.Context, resourceGroupName string, resourceProviderName string, patchableResource customproviders.ResourceProvidersUpdate) (result customproviders.CustomRPManifest, err error)
}

var _ CustomResourceProviderClientAPI = (*customproviders.CustomResourceProviderClient)(nil)

// AssociationsClientAPI contains the set of methods on the AssociationsClient type.
type AssociationsClientAPI interface {
	CreateOrUpdate(ctx context.Context, scope string, associationName string, association customproviders.Association) (result customproviders.AssociationsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, scope string, associationName string) (result customproviders.AssociationsDeleteFuture, err error)
	Get(ctx context.Context, scope string, associationName string) (result customproviders.Association, err error)
	ListAll(ctx context.Context, scope string) (result customproviders.AssociationsListPage, err error)
	ListAllComplete(ctx context.Context, scope string) (result customproviders.AssociationsListIterator, err error)
}

var _ AssociationsClientAPI = (*customproviders.AssociationsClient)(nil)
