package cdn

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// Allow ...
	Allow ActionType = "Allow"
	// Block ...
	Block ActionType = "Block"
	// Log ...
	Log ActionType = "Log"
	// Redirect ...
	Redirect ActionType = "Redirect"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{Allow, Block, Log, Redirect}
}

// AfdCertificateType enumerates the values for afd certificate type.
type AfdCertificateType string

const (
	// AfdCertificateTypeCustomerCertificate ...
	AfdCertificateTypeCustomerCertificate AfdCertificateType = "CustomerCertificate"
	// AfdCertificateTypeManagedCertificate ...
	AfdCertificateTypeManagedCertificate AfdCertificateType = "ManagedCertificate"
)

// PossibleAfdCertificateTypeValues returns an array of possible values for the AfdCertificateType const type.
func PossibleAfdCertificateTypeValues() []AfdCertificateType {
	return []AfdCertificateType{AfdCertificateTypeCustomerCertificate, AfdCertificateTypeManagedCertificate}
}

// AFDEndpointProtocols enumerates the values for afd endpoint protocols.
type AFDEndpointProtocols string

const (
	// HTTP ...
	HTTP AFDEndpointProtocols = "Http"
	// HTTPS ...
	HTTPS AFDEndpointProtocols = "Https"
)

// PossibleAFDEndpointProtocolsValues returns an array of possible values for the AFDEndpointProtocols const type.
func PossibleAFDEndpointProtocolsValues() []AFDEndpointProtocols {
	return []AFDEndpointProtocols{HTTP, HTTPS}
}

// AfdMinimumTLSVersion enumerates the values for afd minimum tls version.
type AfdMinimumTLSVersion string

const (
	// TLS10 ...
	TLS10 AfdMinimumTLSVersion = "TLS10"
	// TLS12 ...
	TLS12 AfdMinimumTLSVersion = "TLS12"
)

// PossibleAfdMinimumTLSVersionValues returns an array of possible values for the AfdMinimumTLSVersion const type.
func PossibleAfdMinimumTLSVersionValues() []AfdMinimumTLSVersion {
	return []AfdMinimumTLSVersion{TLS10, TLS12}
}

// AfdProvisioningState enumerates the values for afd provisioning state.
type AfdProvisioningState string

const (
	// Creating ...
	Creating AfdProvisioningState = "Creating"
	// Deleting ...
	Deleting AfdProvisioningState = "Deleting"
	// Failed ...
	Failed AfdProvisioningState = "Failed"
	// Succeeded ...
	Succeeded AfdProvisioningState = "Succeeded"
	// Updating ...
	Updating AfdProvisioningState = "Updating"
)

// PossibleAfdProvisioningStateValues returns an array of possible values for the AfdProvisioningState const type.
func PossibleAfdProvisioningStateValues() []AfdProvisioningState {
	return []AfdProvisioningState{Creating, Deleting, Failed, Succeeded, Updating}
}

// AfdQueryStringCachingBehavior enumerates the values for afd query string caching behavior.
type AfdQueryStringCachingBehavior string

const (
	// IgnoreQueryString ...
	IgnoreQueryString AfdQueryStringCachingBehavior = "IgnoreQueryString"
	// NotSet ...
	NotSet AfdQueryStringCachingBehavior = "NotSet"
	// UseQueryString ...
	UseQueryString AfdQueryStringCachingBehavior = "UseQueryString"
)

// PossibleAfdQueryStringCachingBehaviorValues returns an array of possible values for the AfdQueryStringCachingBehavior const type.
func PossibleAfdQueryStringCachingBehaviorValues() []AfdQueryStringCachingBehavior {
	return []AfdQueryStringCachingBehavior{IgnoreQueryString, NotSet, UseQueryString}
}

// Algorithm enumerates the values for algorithm.
type Algorithm string

const (
	// SHA256 ...
	SHA256 Algorithm = "SHA256"
)

// PossibleAlgorithmValues returns an array of possible values for the Algorithm const type.
func PossibleAlgorithmValues() []Algorithm {
	return []Algorithm{SHA256}
}

// CacheBehavior enumerates the values for cache behavior.
type CacheBehavior string

const (
	// BypassCache ...
	BypassCache CacheBehavior = "BypassCache"
	// Override ...
	Override CacheBehavior = "Override"
	// SetIfMissing ...
	SetIfMissing CacheBehavior = "SetIfMissing"
)

// PossibleCacheBehaviorValues returns an array of possible values for the CacheBehavior const type.
func PossibleCacheBehaviorValues() []CacheBehavior {
	return []CacheBehavior{BypassCache, Override, SetIfMissing}
}

// CertificateSource enumerates the values for certificate source.
type CertificateSource string

const (
	// CertificateSourceAzureKeyVault ...
	CertificateSourceAzureKeyVault CertificateSource = "AzureKeyVault"
	// CertificateSourceCdn ...
	CertificateSourceCdn CertificateSource = "Cdn"
	// CertificateSourceCustomDomainHTTPSParameters ...
	CertificateSourceCustomDomainHTTPSParameters CertificateSource = "CustomDomainHttpsParameters"
)

// PossibleCertificateSourceValues returns an array of possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{CertificateSourceAzureKeyVault, CertificateSourceCdn, CertificateSourceCustomDomainHTTPSParameters}
}

// CertificateType enumerates the values for certificate type.
type CertificateType string

const (
	// Dedicated ...
	Dedicated CertificateType = "Dedicated"
	// Shared ...
	Shared CertificateType = "Shared"
)

// PossibleCertificateTypeValues returns an array of possible values for the CertificateType const type.
func PossibleCertificateTypeValues() []CertificateType {
	return []CertificateType{Dedicated, Shared}
}

// CookiesOperator enumerates the values for cookies operator.
type CookiesOperator string

const (
	// Any ...
	Any CookiesOperator = "Any"
	// BeginsWith ...
	BeginsWith CookiesOperator = "BeginsWith"
	// Contains ...
	Contains CookiesOperator = "Contains"
	// EndsWith ...
	EndsWith CookiesOperator = "EndsWith"
	// Equal ...
	Equal CookiesOperator = "Equal"
	// GreaterThan ...
	GreaterThan CookiesOperator = "GreaterThan"
	// GreaterThanOrEqual ...
	GreaterThanOrEqual CookiesOperator = "GreaterThanOrEqual"
	// LessThan ...
	LessThan CookiesOperator = "LessThan"
	// LessThanOrEqual ...
	LessThanOrEqual CookiesOperator = "LessThanOrEqual"
	// RegEx ...
	RegEx CookiesOperator = "RegEx"
)

// PossibleCookiesOperatorValues returns an array of possible values for the CookiesOperator const type.
func PossibleCookiesOperatorValues() []CookiesOperator {
	return []CookiesOperator{Any, BeginsWith, Contains, EndsWith, Equal, GreaterThan, GreaterThanOrEqual, LessThan, LessThanOrEqual, RegEx}
}

// CustomDomainResourceState enumerates the values for custom domain resource state.
type CustomDomainResourceState string

const (
	// CustomDomainResourceStateActive ...
	CustomDomainResourceStateActive CustomDomainResourceState = "Active"
	// CustomDomainResourceStateCreating ...
	CustomDomainResourceStateCreating CustomDomainResourceState = "Creating"
	// CustomDomainResourceStateDeleting ...
	CustomDomainResourceStateDeleting CustomDomainResourceState = "Deleting"
)

// PossibleCustomDomainResourceStateValues returns an array of possible values for the CustomDomainResourceState const type.
func PossibleCustomDomainResourceStateValues() []CustomDomainResourceState {
	return []CustomDomainResourceState{CustomDomainResourceStateActive, CustomDomainResourceStateCreating, CustomDomainResourceStateDeleting}
}

// CustomHTTPSProvisioningState enumerates the values for custom https provisioning state.
type CustomHTTPSProvisioningState string

const (
	// CustomHTTPSProvisioningStateDisabled ...
	CustomHTTPSProvisioningStateDisabled CustomHTTPSProvisioningState = "Disabled"
	// CustomHTTPSProvisioningStateDisabling ...
	CustomHTTPSProvisioningStateDisabling CustomHTTPSProvisioningState = "Disabling"
	// CustomHTTPSProvisioningStateEnabled ...
	CustomHTTPSProvisioningStateEnabled CustomHTTPSProvisioningState = "Enabled"
	// CustomHTTPSProvisioningStateEnabling ...
	CustomHTTPSProvisioningStateEnabling CustomHTTPSProvisioningState = "Enabling"
	// CustomHTTPSProvisioningStateFailed ...
	CustomHTTPSProvisioningStateFailed CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns an array of possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{CustomHTTPSProvisioningStateDisabled, CustomHTTPSProvisioningStateDisabling, CustomHTTPSProvisioningStateEnabled, CustomHTTPSProvisioningStateEnabling, CustomHTTPSProvisioningStateFailed}
}

// CustomHTTPSProvisioningSubstate enumerates the values for custom https provisioning substate.
type CustomHTTPSProvisioningSubstate string

const (
	// CertificateDeleted ...
	CertificateDeleted CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	// CertificateDeployed ...
	CertificateDeployed CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	// DeletingCertificate ...
	DeletingCertificate CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	// DeployingCertificate ...
	DeployingCertificate CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	// DomainControlValidationRequestApproved ...
	DomainControlValidationRequestApproved CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	// DomainControlValidationRequestRejected ...
	DomainControlValidationRequestRejected CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	// DomainControlValidationRequestTimedOut ...
	DomainControlValidationRequestTimedOut CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	// IssuingCertificate ...
	IssuingCertificate CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	// PendingDomainControlValidationREquestApproval ...
	PendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	// SubmittingDomainControlValidationRequest ...
	SubmittingDomainControlValidationRequest CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns an array of possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{CertificateDeleted, CertificateDeployed, DeletingCertificate, DeployingCertificate, DomainControlValidationRequestApproved, DomainControlValidationRequestRejected, DomainControlValidationRequestTimedOut, IssuingCertificate, PendingDomainControlValidationREquestApproval, SubmittingDomainControlValidationRequest}
}

// CustomRuleEnabledState enumerates the values for custom rule enabled state.
type CustomRuleEnabledState string

const (
	// Disabled ...
	Disabled CustomRuleEnabledState = "Disabled"
	// Enabled ...
	Enabled CustomRuleEnabledState = "Enabled"
)

// PossibleCustomRuleEnabledStateValues returns an array of possible values for the CustomRuleEnabledState const type.
func PossibleCustomRuleEnabledStateValues() []CustomRuleEnabledState {
	return []CustomRuleEnabledState{Disabled, Enabled}
}

// DeploymentStatus enumerates the values for deployment status.
type DeploymentStatus string

const (
	// DeploymentStatusFailed ...
	DeploymentStatusFailed DeploymentStatus = "Failed"
	// DeploymentStatusInProgress ...
	DeploymentStatusInProgress DeploymentStatus = "InProgress"
	// DeploymentStatusNotStarted ...
	DeploymentStatusNotStarted DeploymentStatus = "NotStarted"
	// DeploymentStatusSucceeded ...
	DeploymentStatusSucceeded DeploymentStatus = "Succeeded"
)

// PossibleDeploymentStatusValues returns an array of possible values for the DeploymentStatus const type.
func PossibleDeploymentStatusValues() []DeploymentStatus {
	return []DeploymentStatus{DeploymentStatusFailed, DeploymentStatusInProgress, DeploymentStatusNotStarted, DeploymentStatusSucceeded}
}

// DestinationProtocol enumerates the values for destination protocol.
type DestinationProtocol string

const (
	// DestinationProtocolHTTP ...
	DestinationProtocolHTTP DestinationProtocol = "Http"
	// DestinationProtocolHTTPS ...
	DestinationProtocolHTTPS DestinationProtocol = "Https"
	// DestinationProtocolMatchRequest ...
	DestinationProtocolMatchRequest DestinationProtocol = "MatchRequest"
)

// PossibleDestinationProtocolValues returns an array of possible values for the DestinationProtocol const type.
func PossibleDestinationProtocolValues() []DestinationProtocol {
	return []DestinationProtocol{DestinationProtocolHTTP, DestinationProtocolHTTPS, DestinationProtocolMatchRequest}
}

// DomainValidationState enumerates the values for domain validation state.
type DomainValidationState string

const (
	// Approved ...
	Approved DomainValidationState = "Approved"
	// Pending ...
	Pending DomainValidationState = "Pending"
	// PendingRevalidation ...
	PendingRevalidation DomainValidationState = "PendingRevalidation"
	// Submitting ...
	Submitting DomainValidationState = "Submitting"
	// TimedOut ...
	TimedOut DomainValidationState = "TimedOut"
	// Unknown ...
	Unknown DomainValidationState = "Unknown"
)

// PossibleDomainValidationStateValues returns an array of possible values for the DomainValidationState const type.
func PossibleDomainValidationStateValues() []DomainValidationState {
	return []DomainValidationState{Approved, Pending, PendingRevalidation, Submitting, TimedOut, Unknown}
}

// EnabledState enumerates the values for enabled state.
type EnabledState string

const (
	// EnabledStateDisabled ...
	EnabledStateDisabled EnabledState = "Disabled"
	// EnabledStateEnabled ...
	EnabledStateEnabled EnabledState = "Enabled"
)

// PossibleEnabledStateValues returns an array of possible values for the EnabledState const type.
func PossibleEnabledStateValues() []EnabledState {
	return []EnabledState{EnabledStateDisabled, EnabledStateEnabled}
}

// EndpointResourceState enumerates the values for endpoint resource state.
type EndpointResourceState string

const (
	// EndpointResourceStateCreating ...
	EndpointResourceStateCreating EndpointResourceState = "Creating"
	// EndpointResourceStateDeleting ...
	EndpointResourceStateDeleting EndpointResourceState = "Deleting"
	// EndpointResourceStateRunning ...
	EndpointResourceStateRunning EndpointResourceState = "Running"
	// EndpointResourceStateStarting ...
	EndpointResourceStateStarting EndpointResourceState = "Starting"
	// EndpointResourceStateStopped ...
	EndpointResourceStateStopped EndpointResourceState = "Stopped"
	// EndpointResourceStateStopping ...
	EndpointResourceStateStopping EndpointResourceState = "Stopping"
)

// PossibleEndpointResourceStateValues returns an array of possible values for the EndpointResourceState const type.
func PossibleEndpointResourceStateValues() []EndpointResourceState {
	return []EndpointResourceState{EndpointResourceStateCreating, EndpointResourceStateDeleting, EndpointResourceStateRunning, EndpointResourceStateStarting, EndpointResourceStateStopped, EndpointResourceStateStopping}
}

// ForwardingProtocol enumerates the values for forwarding protocol.
type ForwardingProtocol string

const (
	// HTTPOnly ...
	HTTPOnly ForwardingProtocol = "HttpOnly"
	// HTTPSOnly ...
	HTTPSOnly ForwardingProtocol = "HttpsOnly"
	// MatchRequest ...
	MatchRequest ForwardingProtocol = "MatchRequest"
)

// PossibleForwardingProtocolValues returns an array of possible values for the ForwardingProtocol const type.
func PossibleForwardingProtocolValues() []ForwardingProtocol {
	return []ForwardingProtocol{HTTPOnly, HTTPSOnly, MatchRequest}
}

// GeoFilterActions enumerates the values for geo filter actions.
type GeoFilterActions string

const (
	// GeoFilterActionsAllow ...
	GeoFilterActionsAllow GeoFilterActions = "Allow"
	// GeoFilterActionsBlock ...
	GeoFilterActionsBlock GeoFilterActions = "Block"
)

// PossibleGeoFilterActionsValues returns an array of possible values for the GeoFilterActions const type.
func PossibleGeoFilterActionsValues() []GeoFilterActions {
	return []GeoFilterActions{GeoFilterActionsAllow, GeoFilterActionsBlock}
}

// Granularity enumerates the values for granularity.
type Granularity string

const (
	// P1D ...
	P1D Granularity = "P1D"
	// PT1H ...
	PT1H Granularity = "PT1H"
	// PT5M ...
	PT5M Granularity = "PT5M"
)

// PossibleGranularityValues returns an array of possible values for the Granularity const type.
func PossibleGranularityValues() []Granularity {
	return []Granularity{P1D, PT1H, PT5M}
}

// Granularity1 enumerates the values for granularity 1.
type Granularity1 string

const (
	// Granularity1P1D ...
	Granularity1P1D Granularity1 = "P1D"
	// Granularity1PT1H ...
	Granularity1PT1H Granularity1 = "PT1H"
	// Granularity1PT5M ...
	Granularity1PT5M Granularity1 = "PT5M"
)

// PossibleGranularity1Values returns an array of possible values for the Granularity1 const type.
func PossibleGranularity1Values() []Granularity1 {
	return []Granularity1{Granularity1P1D, Granularity1PT1H, Granularity1PT5M}
}

// HeaderAction enumerates the values for header action.
type HeaderAction string

const (
	// Append ...
	Append HeaderAction = "Append"
	// Delete ...
	Delete HeaderAction = "Delete"
	// Overwrite ...
	Overwrite HeaderAction = "Overwrite"
)

// PossibleHeaderActionValues returns an array of possible values for the HeaderAction const type.
func PossibleHeaderActionValues() []HeaderAction {
	return []HeaderAction{Append, Delete, Overwrite}
}

// HealthProbeRequestType enumerates the values for health probe request type.
type HealthProbeRequestType string

const (
	// HealthProbeRequestTypeGET ...
	HealthProbeRequestTypeGET HealthProbeRequestType = "GET"
	// HealthProbeRequestTypeHEAD ...
	HealthProbeRequestTypeHEAD HealthProbeRequestType = "HEAD"
	// HealthProbeRequestTypeNotSet ...
	HealthProbeRequestTypeNotSet HealthProbeRequestType = "NotSet"
)

// PossibleHealthProbeRequestTypeValues returns an array of possible values for the HealthProbeRequestType const type.
func PossibleHealthProbeRequestTypeValues() []HealthProbeRequestType {
	return []HealthProbeRequestType{HealthProbeRequestTypeGET, HealthProbeRequestTypeHEAD, HealthProbeRequestTypeNotSet}
}

// HTTPSRedirect enumerates the values for https redirect.
type HTTPSRedirect string

const (
	// HTTPSRedirectDisabled ...
	HTTPSRedirectDisabled HTTPSRedirect = "Disabled"
	// HTTPSRedirectEnabled ...
	HTTPSRedirectEnabled HTTPSRedirect = "Enabled"
)

// PossibleHTTPSRedirectValues returns an array of possible values for the HTTPSRedirect const type.
func PossibleHTTPSRedirectValues() []HTTPSRedirect {
	return []HTTPSRedirect{HTTPSRedirectDisabled, HTTPSRedirectEnabled}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// Application ...
	Application IdentityType = "application"
	// Key ...
	Key IdentityType = "key"
	// ManagedIdentity ...
	ManagedIdentity IdentityType = "managedIdentity"
	// User ...
	User IdentityType = "user"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{Application, Key, ManagedIdentity, User}
}

// LinkToDefaultDomain enumerates the values for link to default domain.
type LinkToDefaultDomain string

const (
	// LinkToDefaultDomainDisabled ...
	LinkToDefaultDomainDisabled LinkToDefaultDomain = "Disabled"
	// LinkToDefaultDomainEnabled ...
	LinkToDefaultDomainEnabled LinkToDefaultDomain = "Enabled"
)

// PossibleLinkToDefaultDomainValues returns an array of possible values for the LinkToDefaultDomain const type.
func PossibleLinkToDefaultDomainValues() []LinkToDefaultDomain {
	return []LinkToDefaultDomain{LinkToDefaultDomainDisabled, LinkToDefaultDomainEnabled}
}

// ManagedRuleEnabledState enumerates the values for managed rule enabled state.
type ManagedRuleEnabledState string

const (
	// ManagedRuleEnabledStateDisabled ...
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = "Disabled"
	// ManagedRuleEnabledStateEnabled ...
	ManagedRuleEnabledStateEnabled ManagedRuleEnabledState = "Enabled"
)

// PossibleManagedRuleEnabledStateValues returns an array of possible values for the ManagedRuleEnabledState const type.
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return []ManagedRuleEnabledState{ManagedRuleEnabledStateDisabled, ManagedRuleEnabledStateEnabled}
}

// MatchProcessingBehavior enumerates the values for match processing behavior.
type MatchProcessingBehavior string

const (
	// Continue ...
	Continue MatchProcessingBehavior = "Continue"
	// Stop ...
	Stop MatchProcessingBehavior = "Stop"
)

// PossibleMatchProcessingBehaviorValues returns an array of possible values for the MatchProcessingBehavior const type.
func PossibleMatchProcessingBehaviorValues() []MatchProcessingBehavior {
	return []MatchProcessingBehavior{Continue, Stop}
}

// MatchVariable enumerates the values for match variable.
type MatchVariable string

const (
	// Cookies ...
	Cookies MatchVariable = "Cookies"
	// PostArgs ...
	PostArgs MatchVariable = "PostArgs"
	// QueryString ...
	QueryString MatchVariable = "QueryString"
	// RemoteAddr ...
	RemoteAddr MatchVariable = "RemoteAddr"
	// RequestBody ...
	RequestBody MatchVariable = "RequestBody"
	// RequestHeader ...
	RequestHeader MatchVariable = "RequestHeader"
	// RequestMethod ...
	RequestMethod MatchVariable = "RequestMethod"
	// RequestURI ...
	RequestURI MatchVariable = "RequestUri"
	// SocketAddr ...
	SocketAddr MatchVariable = "SocketAddr"
)

// PossibleMatchVariableValues returns an array of possible values for the MatchVariable const type.
func PossibleMatchVariableValues() []MatchVariable {
	return []MatchVariable{Cookies, PostArgs, QueryString, RemoteAddr, RequestBody, RequestHeader, RequestMethod, RequestURI, SocketAddr}
}

// MinimumTLSVersion enumerates the values for minimum tls version.
type MinimumTLSVersion string

const (
	// MinimumTLSVersionNone ...
	MinimumTLSVersionNone MinimumTLSVersion = "None"
	// MinimumTLSVersionTLS10 ...
	MinimumTLSVersionTLS10 MinimumTLSVersion = "TLS10"
	// MinimumTLSVersionTLS12 ...
	MinimumTLSVersionTLS12 MinimumTLSVersion = "TLS12"
)

// PossibleMinimumTLSVersionValues returns an array of possible values for the MinimumTLSVersion const type.
func PossibleMinimumTLSVersionValues() []MinimumTLSVersion {
	return []MinimumTLSVersion{MinimumTLSVersionNone, MinimumTLSVersionTLS10, MinimumTLSVersionTLS12}
}

// Name enumerates the values for name.
type Name string

const (
	// NameCookies ...
	NameCookies Name = "Cookies"
	// NameDeliveryRuleCondition ...
	NameDeliveryRuleCondition Name = "DeliveryRuleCondition"
	// NameHTTPVersion ...
	NameHTTPVersion Name = "HttpVersion"
	// NameIsDevice ...
	NameIsDevice Name = "IsDevice"
	// NamePostArgs ...
	NamePostArgs Name = "PostArgs"
	// NameQueryString ...
	NameQueryString Name = "QueryString"
	// NameRemoteAddress ...
	NameRemoteAddress Name = "RemoteAddress"
	// NameRequestBody ...
	NameRequestBody Name = "RequestBody"
	// NameRequestHeader ...
	NameRequestHeader Name = "RequestHeader"
	// NameRequestMethod ...
	NameRequestMethod Name = "RequestMethod"
	// NameRequestScheme ...
	NameRequestScheme Name = "RequestScheme"
	// NameRequestURI ...
	NameRequestURI Name = "RequestUri"
	// NameURLFileExtension ...
	NameURLFileExtension Name = "UrlFileExtension"
	// NameURLFileName ...
	NameURLFileName Name = "UrlFileName"
	// NameURLPath ...
	NameURLPath Name = "UrlPath"
)

// PossibleNameValues returns an array of possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{NameCookies, NameDeliveryRuleCondition, NameHTTPVersion, NameIsDevice, NamePostArgs, NameQueryString, NameRemoteAddress, NameRequestBody, NameRequestHeader, NameRequestMethod, NameRequestScheme, NameRequestURI, NameURLFileExtension, NameURLFileName, NameURLPath}
}

// NameBasicDeliveryRuleAction enumerates the values for name basic delivery rule action.
type NameBasicDeliveryRuleAction string

const (
	// NameCacheExpiration ...
	NameCacheExpiration NameBasicDeliveryRuleAction = "CacheExpiration"
	// NameCacheKeyQueryString ...
	NameCacheKeyQueryString NameBasicDeliveryRuleAction = "CacheKeyQueryString"
	// NameDeliveryRuleAction ...
	NameDeliveryRuleAction NameBasicDeliveryRuleAction = "DeliveryRuleAction"
	// NameModifyRequestHeader ...
	NameModifyRequestHeader NameBasicDeliveryRuleAction = "ModifyRequestHeader"
	// NameModifyResponseHeader ...
	NameModifyResponseHeader NameBasicDeliveryRuleAction = "ModifyResponseHeader"
	// NameOriginGroupOverride ...
	NameOriginGroupOverride NameBasicDeliveryRuleAction = "OriginGroupOverride"
	// NameURLRedirect ...
	NameURLRedirect NameBasicDeliveryRuleAction = "UrlRedirect"
	// NameURLRewrite ...
	NameURLRewrite NameBasicDeliveryRuleAction = "UrlRewrite"
	// NameURLSigning ...
	NameURLSigning NameBasicDeliveryRuleAction = "UrlSigning"
)

// PossibleNameBasicDeliveryRuleActionValues returns an array of possible values for the NameBasicDeliveryRuleAction const type.
func PossibleNameBasicDeliveryRuleActionValues() []NameBasicDeliveryRuleAction {
	return []NameBasicDeliveryRuleAction{NameCacheExpiration, NameCacheKeyQueryString, NameDeliveryRuleAction, NameModifyRequestHeader, NameModifyResponseHeader, NameOriginGroupOverride, NameURLRedirect, NameURLRewrite, NameURLSigning}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// OperatorAny ...
	OperatorAny Operator = "Any"
	// OperatorBeginsWith ...
	OperatorBeginsWith Operator = "BeginsWith"
	// OperatorContains ...
	OperatorContains Operator = "Contains"
	// OperatorEndsWith ...
	OperatorEndsWith Operator = "EndsWith"
	// OperatorEqual ...
	OperatorEqual Operator = "Equal"
	// OperatorGeoMatch ...
	OperatorGeoMatch Operator = "GeoMatch"
	// OperatorGreaterThan ...
	OperatorGreaterThan Operator = "GreaterThan"
	// OperatorGreaterThanOrEqual ...
	OperatorGreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// OperatorIPMatch ...
	OperatorIPMatch Operator = "IPMatch"
	// OperatorLessThan ...
	OperatorLessThan Operator = "LessThan"
	// OperatorLessThanOrEqual ...
	OperatorLessThanOrEqual Operator = "LessThanOrEqual"
	// OperatorRegEx ...
	OperatorRegEx Operator = "RegEx"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{OperatorAny, OperatorBeginsWith, OperatorContains, OperatorEndsWith, OperatorEqual, OperatorGeoMatch, OperatorGreaterThan, OperatorGreaterThanOrEqual, OperatorIPMatch, OperatorLessThan, OperatorLessThanOrEqual, OperatorRegEx}
}

// OptimizationType enumerates the values for optimization type.
type OptimizationType string

const (
	// DynamicSiteAcceleration ...
	DynamicSiteAcceleration OptimizationType = "DynamicSiteAcceleration"
	// GeneralMediaStreaming ...
	GeneralMediaStreaming OptimizationType = "GeneralMediaStreaming"
	// GeneralWebDelivery ...
	GeneralWebDelivery OptimizationType = "GeneralWebDelivery"
	// LargeFileDownload ...
	LargeFileDownload OptimizationType = "LargeFileDownload"
	// VideoOnDemandMediaStreaming ...
	VideoOnDemandMediaStreaming OptimizationType = "VideoOnDemandMediaStreaming"
)

// PossibleOptimizationTypeValues returns an array of possible values for the OptimizationType const type.
func PossibleOptimizationTypeValues() []OptimizationType {
	return []OptimizationType{DynamicSiteAcceleration, GeneralMediaStreaming, GeneralWebDelivery, LargeFileDownload, VideoOnDemandMediaStreaming}
}

// OriginGroupResourceState enumerates the values for origin group resource state.
type OriginGroupResourceState string

const (
	// OriginGroupResourceStateActive ...
	OriginGroupResourceStateActive OriginGroupResourceState = "Active"
	// OriginGroupResourceStateCreating ...
	OriginGroupResourceStateCreating OriginGroupResourceState = "Creating"
	// OriginGroupResourceStateDeleting ...
	OriginGroupResourceStateDeleting OriginGroupResourceState = "Deleting"
)

// PossibleOriginGroupResourceStateValues returns an array of possible values for the OriginGroupResourceState const type.
func PossibleOriginGroupResourceStateValues() []OriginGroupResourceState {
	return []OriginGroupResourceState{OriginGroupResourceStateActive, OriginGroupResourceStateCreating, OriginGroupResourceStateDeleting}
}

// OriginResourceState enumerates the values for origin resource state.
type OriginResourceState string

const (
	// OriginResourceStateActive ...
	OriginResourceStateActive OriginResourceState = "Active"
	// OriginResourceStateCreating ...
	OriginResourceStateCreating OriginResourceState = "Creating"
	// OriginResourceStateDeleting ...
	OriginResourceStateDeleting OriginResourceState = "Deleting"
)

// PossibleOriginResourceStateValues returns an array of possible values for the OriginResourceState const type.
func PossibleOriginResourceStateValues() []OriginResourceState {
	return []OriginResourceState{OriginResourceStateActive, OriginResourceStateCreating, OriginResourceStateDeleting}
}

// ParamIndicator enumerates the values for param indicator.
type ParamIndicator string

const (
	// Expires ...
	Expires ParamIndicator = "Expires"
	// KeyID ...
	KeyID ParamIndicator = "KeyId"
	// Signature ...
	Signature ParamIndicator = "Signature"
)

// PossibleParamIndicatorValues returns an array of possible values for the ParamIndicator const type.
func PossibleParamIndicatorValues() []ParamIndicator {
	return []ParamIndicator{Expires, KeyID, Signature}
}

// PolicyEnabledState enumerates the values for policy enabled state.
type PolicyEnabledState string

const (
	// PolicyEnabledStateDisabled ...
	PolicyEnabledStateDisabled PolicyEnabledState = "Disabled"
	// PolicyEnabledStateEnabled ...
	PolicyEnabledStateEnabled PolicyEnabledState = "Enabled"
)

// PossiblePolicyEnabledStateValues returns an array of possible values for the PolicyEnabledState const type.
func PossiblePolicyEnabledStateValues() []PolicyEnabledState {
	return []PolicyEnabledState{PolicyEnabledStateDisabled, PolicyEnabledStateEnabled}
}

// PolicyMode enumerates the values for policy mode.
type PolicyMode string

const (
	// Detection ...
	Detection PolicyMode = "Detection"
	// Prevention ...
	Prevention PolicyMode = "Prevention"
)

// PossiblePolicyModeValues returns an array of possible values for the PolicyMode const type.
func PossiblePolicyModeValues() []PolicyMode {
	return []PolicyMode{Detection, Prevention}
}

// PolicyResourceState enumerates the values for policy resource state.
type PolicyResourceState string

const (
	// PolicyResourceStateCreating ...
	PolicyResourceStateCreating PolicyResourceState = "Creating"
	// PolicyResourceStateDeleting ...
	PolicyResourceStateDeleting PolicyResourceState = "Deleting"
	// PolicyResourceStateDisabled ...
	PolicyResourceStateDisabled PolicyResourceState = "Disabled"
	// PolicyResourceStateDisabling ...
	PolicyResourceStateDisabling PolicyResourceState = "Disabling"
	// PolicyResourceStateEnabled ...
	PolicyResourceStateEnabled PolicyResourceState = "Enabled"
	// PolicyResourceStateEnabling ...
	PolicyResourceStateEnabling PolicyResourceState = "Enabling"
)

// PossiblePolicyResourceStateValues returns an array of possible values for the PolicyResourceState const type.
func PossiblePolicyResourceStateValues() []PolicyResourceState {
	return []PolicyResourceState{PolicyResourceStateCreating, PolicyResourceStateDeleting, PolicyResourceStateDisabled, PolicyResourceStateDisabling, PolicyResourceStateEnabled, PolicyResourceStateEnabling}
}

// PostArgsOperator enumerates the values for post args operator.
type PostArgsOperator string

const (
	// PostArgsOperatorAny ...
	PostArgsOperatorAny PostArgsOperator = "Any"
	// PostArgsOperatorBeginsWith ...
	PostArgsOperatorBeginsWith PostArgsOperator = "BeginsWith"
	// PostArgsOperatorContains ...
	PostArgsOperatorContains PostArgsOperator = "Contains"
	// PostArgsOperatorEndsWith ...
	PostArgsOperatorEndsWith PostArgsOperator = "EndsWith"
	// PostArgsOperatorEqual ...
	PostArgsOperatorEqual PostArgsOperator = "Equal"
	// PostArgsOperatorGreaterThan ...
	PostArgsOperatorGreaterThan PostArgsOperator = "GreaterThan"
	// PostArgsOperatorGreaterThanOrEqual ...
	PostArgsOperatorGreaterThanOrEqual PostArgsOperator = "GreaterThanOrEqual"
	// PostArgsOperatorLessThan ...
	PostArgsOperatorLessThan PostArgsOperator = "LessThan"
	// PostArgsOperatorLessThanOrEqual ...
	PostArgsOperatorLessThanOrEqual PostArgsOperator = "LessThanOrEqual"
	// PostArgsOperatorRegEx ...
	PostArgsOperatorRegEx PostArgsOperator = "RegEx"
)

// PossiblePostArgsOperatorValues returns an array of possible values for the PostArgsOperator const type.
func PossiblePostArgsOperatorValues() []PostArgsOperator {
	return []PostArgsOperator{PostArgsOperatorAny, PostArgsOperatorBeginsWith, PostArgsOperatorContains, PostArgsOperatorEndsWith, PostArgsOperatorEqual, PostArgsOperatorGreaterThan, PostArgsOperatorGreaterThanOrEqual, PostArgsOperatorLessThan, PostArgsOperatorLessThanOrEqual, PostArgsOperatorRegEx}
}

// PrivateEndpointStatus enumerates the values for private endpoint status.
type PrivateEndpointStatus string

const (
	// PrivateEndpointStatusApproved ...
	PrivateEndpointStatusApproved PrivateEndpointStatus = "Approved"
	// PrivateEndpointStatusDisconnected ...
	PrivateEndpointStatusDisconnected PrivateEndpointStatus = "Disconnected"
	// PrivateEndpointStatusPending ...
	PrivateEndpointStatusPending PrivateEndpointStatus = "Pending"
	// PrivateEndpointStatusRejected ...
	PrivateEndpointStatusRejected PrivateEndpointStatus = "Rejected"
	// PrivateEndpointStatusTimeout ...
	PrivateEndpointStatusTimeout PrivateEndpointStatus = "Timeout"
)

// PossiblePrivateEndpointStatusValues returns an array of possible values for the PrivateEndpointStatus const type.
func PossiblePrivateEndpointStatusValues() []PrivateEndpointStatus {
	return []PrivateEndpointStatus{PrivateEndpointStatusApproved, PrivateEndpointStatusDisconnected, PrivateEndpointStatusPending, PrivateEndpointStatusRejected, PrivateEndpointStatusTimeout}
}

// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP ...
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolHTTPS ...
	ProbeProtocolHTTPS ProbeProtocol = "Https"
	// ProbeProtocolNotSet ...
	ProbeProtocolNotSet ProbeProtocol = "NotSet"
)

// PossibleProbeProtocolValues returns an array of possible values for the ProbeProtocol const type.
func PossibleProbeProtocolValues() []ProbeProtocol {
	return []ProbeProtocol{ProbeProtocolHTTP, ProbeProtocolHTTPS, ProbeProtocolNotSet}
}

// ProfileResourceState enumerates the values for profile resource state.
type ProfileResourceState string

const (
	// ProfileResourceStateActive ...
	ProfileResourceStateActive ProfileResourceState = "Active"
	// ProfileResourceStateCreating ...
	ProfileResourceStateCreating ProfileResourceState = "Creating"
	// ProfileResourceStateDeleting ...
	ProfileResourceStateDeleting ProfileResourceState = "Deleting"
	// ProfileResourceStateDisabled ...
	ProfileResourceStateDisabled ProfileResourceState = "Disabled"
)

// PossibleProfileResourceStateValues returns an array of possible values for the ProfileResourceState const type.
func PossibleProfileResourceStateValues() []ProfileResourceState {
	return []ProfileResourceState{ProfileResourceStateActive, ProfileResourceStateCreating, ProfileResourceStateDeleting, ProfileResourceStateDisabled}
}

// ProtocolType enumerates the values for protocol type.
type ProtocolType string

const (
	// IPBased ...
	IPBased ProtocolType = "IPBased"
	// ServerNameIndication ...
	ServerNameIndication ProtocolType = "ServerNameIndication"
)

// PossibleProtocolTypeValues returns an array of possible values for the ProtocolType const type.
func PossibleProtocolTypeValues() []ProtocolType {
	return []ProtocolType{IPBased, ServerNameIndication}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateFailed, ProvisioningStateSucceeded}
}

// QueryStringBehavior enumerates the values for query string behavior.
type QueryStringBehavior string

const (
	// Exclude ...
	Exclude QueryStringBehavior = "Exclude"
	// ExcludeAll ...
	ExcludeAll QueryStringBehavior = "ExcludeAll"
	// Include ...
	Include QueryStringBehavior = "Include"
	// IncludeAll ...
	IncludeAll QueryStringBehavior = "IncludeAll"
)

// PossibleQueryStringBehaviorValues returns an array of possible values for the QueryStringBehavior const type.
func PossibleQueryStringBehaviorValues() []QueryStringBehavior {
	return []QueryStringBehavior{Exclude, ExcludeAll, Include, IncludeAll}
}

// QueryStringCachingBehavior enumerates the values for query string caching behavior.
type QueryStringCachingBehavior string

const (
	// QueryStringCachingBehaviorBypassCaching ...
	QueryStringCachingBehaviorBypassCaching QueryStringCachingBehavior = "BypassCaching"
	// QueryStringCachingBehaviorIgnoreQueryString ...
	QueryStringCachingBehaviorIgnoreQueryString QueryStringCachingBehavior = "IgnoreQueryString"
	// QueryStringCachingBehaviorNotSet ...
	QueryStringCachingBehaviorNotSet QueryStringCachingBehavior = "NotSet"
	// QueryStringCachingBehaviorUseQueryString ...
	QueryStringCachingBehaviorUseQueryString QueryStringCachingBehavior = "UseQueryString"
)

// PossibleQueryStringCachingBehaviorValues returns an array of possible values for the QueryStringCachingBehavior const type.
func PossibleQueryStringCachingBehaviorValues() []QueryStringCachingBehavior {
	return []QueryStringCachingBehavior{QueryStringCachingBehaviorBypassCaching, QueryStringCachingBehaviorIgnoreQueryString, QueryStringCachingBehaviorNotSet, QueryStringCachingBehaviorUseQueryString}
}

// QueryStringOperator enumerates the values for query string operator.
type QueryStringOperator string

const (
	// QueryStringOperatorAny ...
	QueryStringOperatorAny QueryStringOperator = "Any"
	// QueryStringOperatorBeginsWith ...
	QueryStringOperatorBeginsWith QueryStringOperator = "BeginsWith"
	// QueryStringOperatorContains ...
	QueryStringOperatorContains QueryStringOperator = "Contains"
	// QueryStringOperatorEndsWith ...
	QueryStringOperatorEndsWith QueryStringOperator = "EndsWith"
	// QueryStringOperatorEqual ...
	QueryStringOperatorEqual QueryStringOperator = "Equal"
	// QueryStringOperatorGreaterThan ...
	QueryStringOperatorGreaterThan QueryStringOperator = "GreaterThan"
	// QueryStringOperatorGreaterThanOrEqual ...
	QueryStringOperatorGreaterThanOrEqual QueryStringOperator = "GreaterThanOrEqual"
	// QueryStringOperatorLessThan ...
	QueryStringOperatorLessThan QueryStringOperator = "LessThan"
	// QueryStringOperatorLessThanOrEqual ...
	QueryStringOperatorLessThanOrEqual QueryStringOperator = "LessThanOrEqual"
	// QueryStringOperatorRegEx ...
	QueryStringOperatorRegEx QueryStringOperator = "RegEx"
)

// PossibleQueryStringOperatorValues returns an array of possible values for the QueryStringOperator const type.
func PossibleQueryStringOperatorValues() []QueryStringOperator {
	return []QueryStringOperator{QueryStringOperatorAny, QueryStringOperatorBeginsWith, QueryStringOperatorContains, QueryStringOperatorEndsWith, QueryStringOperatorEqual, QueryStringOperatorGreaterThan, QueryStringOperatorGreaterThanOrEqual, QueryStringOperatorLessThan, QueryStringOperatorLessThanOrEqual, QueryStringOperatorRegEx}
}

// RedirectType enumerates the values for redirect type.
type RedirectType string

const (
	// Found ...
	Found RedirectType = "Found"
	// Moved ...
	Moved RedirectType = "Moved"
	// PermanentRedirect ...
	PermanentRedirect RedirectType = "PermanentRedirect"
	// TemporaryRedirect ...
	TemporaryRedirect RedirectType = "TemporaryRedirect"
)

// PossibleRedirectTypeValues returns an array of possible values for the RedirectType const type.
func PossibleRedirectTypeValues() []RedirectType {
	return []RedirectType{Found, Moved, PermanentRedirect, TemporaryRedirect}
}

// RemoteAddressOperator enumerates the values for remote address operator.
type RemoteAddressOperator string

const (
	// RemoteAddressOperatorAny ...
	RemoteAddressOperatorAny RemoteAddressOperator = "Any"
	// RemoteAddressOperatorGeoMatch ...
	RemoteAddressOperatorGeoMatch RemoteAddressOperator = "GeoMatch"
	// RemoteAddressOperatorIPMatch ...
	RemoteAddressOperatorIPMatch RemoteAddressOperator = "IPMatch"
)

// PossibleRemoteAddressOperatorValues returns an array of possible values for the RemoteAddressOperator const type.
func PossibleRemoteAddressOperatorValues() []RemoteAddressOperator {
	return []RemoteAddressOperator{RemoteAddressOperatorAny, RemoteAddressOperatorGeoMatch, RemoteAddressOperatorIPMatch}
}

// RequestBodyOperator enumerates the values for request body operator.
type RequestBodyOperator string

const (
	// RequestBodyOperatorAny ...
	RequestBodyOperatorAny RequestBodyOperator = "Any"
	// RequestBodyOperatorBeginsWith ...
	RequestBodyOperatorBeginsWith RequestBodyOperator = "BeginsWith"
	// RequestBodyOperatorContains ...
	RequestBodyOperatorContains RequestBodyOperator = "Contains"
	// RequestBodyOperatorEndsWith ...
	RequestBodyOperatorEndsWith RequestBodyOperator = "EndsWith"
	// RequestBodyOperatorEqual ...
	RequestBodyOperatorEqual RequestBodyOperator = "Equal"
	// RequestBodyOperatorGreaterThan ...
	RequestBodyOperatorGreaterThan RequestBodyOperator = "GreaterThan"
	// RequestBodyOperatorGreaterThanOrEqual ...
	RequestBodyOperatorGreaterThanOrEqual RequestBodyOperator = "GreaterThanOrEqual"
	// RequestBodyOperatorLessThan ...
	RequestBodyOperatorLessThan RequestBodyOperator = "LessThan"
	// RequestBodyOperatorLessThanOrEqual ...
	RequestBodyOperatorLessThanOrEqual RequestBodyOperator = "LessThanOrEqual"
	// RequestBodyOperatorRegEx ...
	RequestBodyOperatorRegEx RequestBodyOperator = "RegEx"
)

// PossibleRequestBodyOperatorValues returns an array of possible values for the RequestBodyOperator const type.
func PossibleRequestBodyOperatorValues() []RequestBodyOperator {
	return []RequestBodyOperator{RequestBodyOperatorAny, RequestBodyOperatorBeginsWith, RequestBodyOperatorContains, RequestBodyOperatorEndsWith, RequestBodyOperatorEqual, RequestBodyOperatorGreaterThan, RequestBodyOperatorGreaterThanOrEqual, RequestBodyOperatorLessThan, RequestBodyOperatorLessThanOrEqual, RequestBodyOperatorRegEx}
}

// RequestHeaderOperator enumerates the values for request header operator.
type RequestHeaderOperator string

const (
	// RequestHeaderOperatorAny ...
	RequestHeaderOperatorAny RequestHeaderOperator = "Any"
	// RequestHeaderOperatorBeginsWith ...
	RequestHeaderOperatorBeginsWith RequestHeaderOperator = "BeginsWith"
	// RequestHeaderOperatorContains ...
	RequestHeaderOperatorContains RequestHeaderOperator = "Contains"
	// RequestHeaderOperatorEndsWith ...
	RequestHeaderOperatorEndsWith RequestHeaderOperator = "EndsWith"
	// RequestHeaderOperatorEqual ...
	RequestHeaderOperatorEqual RequestHeaderOperator = "Equal"
	// RequestHeaderOperatorGreaterThan ...
	RequestHeaderOperatorGreaterThan RequestHeaderOperator = "GreaterThan"
	// RequestHeaderOperatorGreaterThanOrEqual ...
	RequestHeaderOperatorGreaterThanOrEqual RequestHeaderOperator = "GreaterThanOrEqual"
	// RequestHeaderOperatorLessThan ...
	RequestHeaderOperatorLessThan RequestHeaderOperator = "LessThan"
	// RequestHeaderOperatorLessThanOrEqual ...
	RequestHeaderOperatorLessThanOrEqual RequestHeaderOperator = "LessThanOrEqual"
	// RequestHeaderOperatorRegEx ...
	RequestHeaderOperatorRegEx RequestHeaderOperator = "RegEx"
)

// PossibleRequestHeaderOperatorValues returns an array of possible values for the RequestHeaderOperator const type.
func PossibleRequestHeaderOperatorValues() []RequestHeaderOperator {
	return []RequestHeaderOperator{RequestHeaderOperatorAny, RequestHeaderOperatorBeginsWith, RequestHeaderOperatorContains, RequestHeaderOperatorEndsWith, RequestHeaderOperatorEqual, RequestHeaderOperatorGreaterThan, RequestHeaderOperatorGreaterThanOrEqual, RequestHeaderOperatorLessThan, RequestHeaderOperatorLessThanOrEqual, RequestHeaderOperatorRegEx}
}

// RequestURIOperator enumerates the values for request uri operator.
type RequestURIOperator string

const (
	// RequestURIOperatorAny ...
	RequestURIOperatorAny RequestURIOperator = "Any"
	// RequestURIOperatorBeginsWith ...
	RequestURIOperatorBeginsWith RequestURIOperator = "BeginsWith"
	// RequestURIOperatorContains ...
	RequestURIOperatorContains RequestURIOperator = "Contains"
	// RequestURIOperatorEndsWith ...
	RequestURIOperatorEndsWith RequestURIOperator = "EndsWith"
	// RequestURIOperatorEqual ...
	RequestURIOperatorEqual RequestURIOperator = "Equal"
	// RequestURIOperatorGreaterThan ...
	RequestURIOperatorGreaterThan RequestURIOperator = "GreaterThan"
	// RequestURIOperatorGreaterThanOrEqual ...
	RequestURIOperatorGreaterThanOrEqual RequestURIOperator = "GreaterThanOrEqual"
	// RequestURIOperatorLessThan ...
	RequestURIOperatorLessThan RequestURIOperator = "LessThan"
	// RequestURIOperatorLessThanOrEqual ...
	RequestURIOperatorLessThanOrEqual RequestURIOperator = "LessThanOrEqual"
	// RequestURIOperatorRegEx ...
	RequestURIOperatorRegEx RequestURIOperator = "RegEx"
)

// PossibleRequestURIOperatorValues returns an array of possible values for the RequestURIOperator const type.
func PossibleRequestURIOperatorValues() []RequestURIOperator {
	return []RequestURIOperator{RequestURIOperatorAny, RequestURIOperatorBeginsWith, RequestURIOperatorContains, RequestURIOperatorEndsWith, RequestURIOperatorEqual, RequestURIOperatorGreaterThan, RequestURIOperatorGreaterThanOrEqual, RequestURIOperatorLessThan, RequestURIOperatorLessThanOrEqual, RequestURIOperatorRegEx}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// MicrosoftCdnProfilesEndpoints ...
	MicrosoftCdnProfilesEndpoints ResourceType = "Microsoft.Cdn/Profiles/Endpoints"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{MicrosoftCdnProfilesEndpoints}
}

// ResponseBasedDetectedErrorTypes enumerates the values for response based detected error types.
type ResponseBasedDetectedErrorTypes string

const (
	// None ...
	None ResponseBasedDetectedErrorTypes = "None"
	// TCPAndHTTPErrors ...
	TCPAndHTTPErrors ResponseBasedDetectedErrorTypes = "TcpAndHttpErrors"
	// TCPErrorsOnly ...
	TCPErrorsOnly ResponseBasedDetectedErrorTypes = "TcpErrorsOnly"
)

// PossibleResponseBasedDetectedErrorTypesValues returns an array of possible values for the ResponseBasedDetectedErrorTypes const type.
func PossibleResponseBasedDetectedErrorTypesValues() []ResponseBasedDetectedErrorTypes {
	return []ResponseBasedDetectedErrorTypes{None, TCPAndHTTPErrors, TCPErrorsOnly}
}

// SharedPrivateLinkResourceStatus enumerates the values for shared private link resource status.
type SharedPrivateLinkResourceStatus string

const (
	// SharedPrivateLinkResourceStatusApproved ...
	SharedPrivateLinkResourceStatusApproved SharedPrivateLinkResourceStatus = "Approved"
	// SharedPrivateLinkResourceStatusDisconnected ...
	SharedPrivateLinkResourceStatusDisconnected SharedPrivateLinkResourceStatus = "Disconnected"
	// SharedPrivateLinkResourceStatusPending ...
	SharedPrivateLinkResourceStatusPending SharedPrivateLinkResourceStatus = "Pending"
	// SharedPrivateLinkResourceStatusRejected ...
	SharedPrivateLinkResourceStatusRejected SharedPrivateLinkResourceStatus = "Rejected"
	// SharedPrivateLinkResourceStatusTimeout ...
	SharedPrivateLinkResourceStatusTimeout SharedPrivateLinkResourceStatus = "Timeout"
)

// PossibleSharedPrivateLinkResourceStatusValues returns an array of possible values for the SharedPrivateLinkResourceStatus const type.
func PossibleSharedPrivateLinkResourceStatusValues() []SharedPrivateLinkResourceStatus {
	return []SharedPrivateLinkResourceStatus{SharedPrivateLinkResourceStatusApproved, SharedPrivateLinkResourceStatusDisconnected, SharedPrivateLinkResourceStatusPending, SharedPrivateLinkResourceStatusRejected, SharedPrivateLinkResourceStatusTimeout}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// CustomVerizon ...
	CustomVerizon SkuName = "Custom_Verizon"
	// PremiumAzureFrontDoor ...
	PremiumAzureFrontDoor SkuName = "Premium_AzureFrontDoor"
	// PremiumChinaCdn ...
	PremiumChinaCdn SkuName = "Premium_ChinaCdn"
	// PremiumVerizon ...
	PremiumVerizon SkuName = "Premium_Verizon"
	// Standard955BandWidthChinaCdn ...
	Standard955BandWidthChinaCdn SkuName = "Standard_955BandWidth_ChinaCdn"
	// StandardAkamai ...
	StandardAkamai SkuName = "Standard_Akamai"
	// StandardAvgBandWidthChinaCdn ...
	StandardAvgBandWidthChinaCdn SkuName = "Standard_AvgBandWidth_ChinaCdn"
	// StandardAzureFrontDoor ...
	StandardAzureFrontDoor SkuName = "Standard_AzureFrontDoor"
	// StandardChinaCdn ...
	StandardChinaCdn SkuName = "Standard_ChinaCdn"
	// StandardMicrosoft ...
	StandardMicrosoft SkuName = "Standard_Microsoft"
	// StandardPlus955BandWidthChinaCdn ...
	StandardPlus955BandWidthChinaCdn SkuName = "StandardPlus_955BandWidth_ChinaCdn"
	// StandardPlusAvgBandWidthChinaCdn ...
	StandardPlusAvgBandWidthChinaCdn SkuName = "StandardPlus_AvgBandWidth_ChinaCdn"
	// StandardPlusChinaCdn ...
	StandardPlusChinaCdn SkuName = "StandardPlus_ChinaCdn"
	// StandardVerizon ...
	StandardVerizon SkuName = "Standard_Verizon"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{CustomVerizon, PremiumAzureFrontDoor, PremiumChinaCdn, PremiumVerizon, Standard955BandWidthChinaCdn, StandardAkamai, StandardAvgBandWidthChinaCdn, StandardAzureFrontDoor, StandardChinaCdn, StandardMicrosoft, StandardPlus955BandWidthChinaCdn, StandardPlusAvgBandWidthChinaCdn, StandardPlusChinaCdn, StandardVerizon}
}

// Status enumerates the values for status.
type Status string

const (
	// AccessDenied ...
	AccessDenied Status = "AccessDenied"
	// CertificateExpired ...
	CertificateExpired Status = "CertificateExpired"
	// Invalid ...
	Invalid Status = "Invalid"
	// Valid ...
	Valid Status = "Valid"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{AccessDenied, CertificateExpired, Invalid, Valid}
}

// Transform enumerates the values for transform.
type Transform string

const (
	// Lowercase ...
	Lowercase Transform = "Lowercase"
	// Uppercase ...
	Uppercase Transform = "Uppercase"
)

// PossibleTransformValues returns an array of possible values for the Transform const type.
func PossibleTransformValues() []Transform {
	return []Transform{Lowercase, Uppercase}
}

// TransformType enumerates the values for transform type.
type TransformType string

const (
	// TransformTypeLowercase ...
	TransformTypeLowercase TransformType = "Lowercase"
	// TransformTypeRemoveNulls ...
	TransformTypeRemoveNulls TransformType = "RemoveNulls"
	// TransformTypeTrim ...
	TransformTypeTrim TransformType = "Trim"
	// TransformTypeUppercase ...
	TransformTypeUppercase TransformType = "Uppercase"
	// TransformTypeURLDecode ...
	TransformTypeURLDecode TransformType = "UrlDecode"
	// TransformTypeURLEncode ...
	TransformTypeURLEncode TransformType = "UrlEncode"
)

// PossibleTransformTypeValues returns an array of possible values for the TransformType const type.
func PossibleTransformTypeValues() []TransformType {
	return []TransformType{TransformTypeLowercase, TransformTypeRemoveNulls, TransformTypeTrim, TransformTypeUppercase, TransformTypeURLDecode, TransformTypeURLEncode}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeSecurityPolicyParameters ...
	TypeSecurityPolicyParameters Type = "SecurityPolicyParameters"
	// TypeWebApplicationFirewall ...
	TypeWebApplicationFirewall Type = "WebApplicationFirewall"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeSecurityPolicyParameters, TypeWebApplicationFirewall}
}

// TypeBasicSecretParameters enumerates the values for type basic secret parameters.
type TypeBasicSecretParameters string

const (
	// TypeCustomerCertificate ...
	TypeCustomerCertificate TypeBasicSecretParameters = "CustomerCertificate"
	// TypeManagedCertificate ...
	TypeManagedCertificate TypeBasicSecretParameters = "ManagedCertificate"
	// TypeSecretParameters ...
	TypeSecretParameters TypeBasicSecretParameters = "SecretParameters"
	// TypeURLSigningKey ...
	TypeURLSigningKey TypeBasicSecretParameters = "UrlSigningKey"
)

// PossibleTypeBasicSecretParametersValues returns an array of possible values for the TypeBasicSecretParameters const type.
func PossibleTypeBasicSecretParametersValues() []TypeBasicSecretParameters {
	return []TypeBasicSecretParameters{TypeCustomerCertificate, TypeManagedCertificate, TypeSecretParameters, TypeURLSigningKey}
}

// Unit enumerates the values for unit.
type Unit string

const (
	// BitsPerSecond ...
	BitsPerSecond Unit = "bitsPerSecond"
	// Bytes ...
	Bytes Unit = "bytes"
	// Count ...
	Count Unit = "count"
)

// PossibleUnitValues returns an array of possible values for the Unit const type.
func PossibleUnitValues() []Unit {
	return []Unit{BitsPerSecond, Bytes, Count}
}

// Unit1 enumerates the values for unit 1.
type Unit1 string

const (
	// Unit1Count ...
	Unit1Count Unit1 = "count"
)

// PossibleUnit1Values returns an array of possible values for the Unit1 const type.
func PossibleUnit1Values() []Unit1 {
	return []Unit1{Unit1Count}
}

// URLFileExtensionOperator enumerates the values for url file extension operator.
type URLFileExtensionOperator string

const (
	// URLFileExtensionOperatorAny ...
	URLFileExtensionOperatorAny URLFileExtensionOperator = "Any"
	// URLFileExtensionOperatorBeginsWith ...
	URLFileExtensionOperatorBeginsWith URLFileExtensionOperator = "BeginsWith"
	// URLFileExtensionOperatorContains ...
	URLFileExtensionOperatorContains URLFileExtensionOperator = "Contains"
	// URLFileExtensionOperatorEndsWith ...
	URLFileExtensionOperatorEndsWith URLFileExtensionOperator = "EndsWith"
	// URLFileExtensionOperatorEqual ...
	URLFileExtensionOperatorEqual URLFileExtensionOperator = "Equal"
	// URLFileExtensionOperatorGreaterThan ...
	URLFileExtensionOperatorGreaterThan URLFileExtensionOperator = "GreaterThan"
	// URLFileExtensionOperatorGreaterThanOrEqual ...
	URLFileExtensionOperatorGreaterThanOrEqual URLFileExtensionOperator = "GreaterThanOrEqual"
	// URLFileExtensionOperatorLessThan ...
	URLFileExtensionOperatorLessThan URLFileExtensionOperator = "LessThan"
	// URLFileExtensionOperatorLessThanOrEqual ...
	URLFileExtensionOperatorLessThanOrEqual URLFileExtensionOperator = "LessThanOrEqual"
	// URLFileExtensionOperatorRegEx ...
	URLFileExtensionOperatorRegEx URLFileExtensionOperator = "RegEx"
)

// PossibleURLFileExtensionOperatorValues returns an array of possible values for the URLFileExtensionOperator const type.
func PossibleURLFileExtensionOperatorValues() []URLFileExtensionOperator {
	return []URLFileExtensionOperator{URLFileExtensionOperatorAny, URLFileExtensionOperatorBeginsWith, URLFileExtensionOperatorContains, URLFileExtensionOperatorEndsWith, URLFileExtensionOperatorEqual, URLFileExtensionOperatorGreaterThan, URLFileExtensionOperatorGreaterThanOrEqual, URLFileExtensionOperatorLessThan, URLFileExtensionOperatorLessThanOrEqual, URLFileExtensionOperatorRegEx}
}

// URLFileNameOperator enumerates the values for url file name operator.
type URLFileNameOperator string

const (
	// URLFileNameOperatorAny ...
	URLFileNameOperatorAny URLFileNameOperator = "Any"
	// URLFileNameOperatorBeginsWith ...
	URLFileNameOperatorBeginsWith URLFileNameOperator = "BeginsWith"
	// URLFileNameOperatorContains ...
	URLFileNameOperatorContains URLFileNameOperator = "Contains"
	// URLFileNameOperatorEndsWith ...
	URLFileNameOperatorEndsWith URLFileNameOperator = "EndsWith"
	// URLFileNameOperatorEqual ...
	URLFileNameOperatorEqual URLFileNameOperator = "Equal"
	// URLFileNameOperatorGreaterThan ...
	URLFileNameOperatorGreaterThan URLFileNameOperator = "GreaterThan"
	// URLFileNameOperatorGreaterThanOrEqual ...
	URLFileNameOperatorGreaterThanOrEqual URLFileNameOperator = "GreaterThanOrEqual"
	// URLFileNameOperatorLessThan ...
	URLFileNameOperatorLessThan URLFileNameOperator = "LessThan"
	// URLFileNameOperatorLessThanOrEqual ...
	URLFileNameOperatorLessThanOrEqual URLFileNameOperator = "LessThanOrEqual"
	// URLFileNameOperatorRegEx ...
	URLFileNameOperatorRegEx URLFileNameOperator = "RegEx"
)

// PossibleURLFileNameOperatorValues returns an array of possible values for the URLFileNameOperator const type.
func PossibleURLFileNameOperatorValues() []URLFileNameOperator {
	return []URLFileNameOperator{URLFileNameOperatorAny, URLFileNameOperatorBeginsWith, URLFileNameOperatorContains, URLFileNameOperatorEndsWith, URLFileNameOperatorEqual, URLFileNameOperatorGreaterThan, URLFileNameOperatorGreaterThanOrEqual, URLFileNameOperatorLessThan, URLFileNameOperatorLessThanOrEqual, URLFileNameOperatorRegEx}
}

// URLPathOperator enumerates the values for url path operator.
type URLPathOperator string

const (
	// URLPathOperatorAny ...
	URLPathOperatorAny URLPathOperator = "Any"
	// URLPathOperatorBeginsWith ...
	URLPathOperatorBeginsWith URLPathOperator = "BeginsWith"
	// URLPathOperatorContains ...
	URLPathOperatorContains URLPathOperator = "Contains"
	// URLPathOperatorEndsWith ...
	URLPathOperatorEndsWith URLPathOperator = "EndsWith"
	// URLPathOperatorEqual ...
	URLPathOperatorEqual URLPathOperator = "Equal"
	// URLPathOperatorGreaterThan ...
	URLPathOperatorGreaterThan URLPathOperator = "GreaterThan"
	// URLPathOperatorGreaterThanOrEqual ...
	URLPathOperatorGreaterThanOrEqual URLPathOperator = "GreaterThanOrEqual"
	// URLPathOperatorLessThan ...
	URLPathOperatorLessThan URLPathOperator = "LessThan"
	// URLPathOperatorLessThanOrEqual ...
	URLPathOperatorLessThanOrEqual URLPathOperator = "LessThanOrEqual"
	// URLPathOperatorRegEx ...
	URLPathOperatorRegEx URLPathOperator = "RegEx"
	// URLPathOperatorWildcard ...
	URLPathOperatorWildcard URLPathOperator = "Wildcard"
)

// PossibleURLPathOperatorValues returns an array of possible values for the URLPathOperator const type.
func PossibleURLPathOperatorValues() []URLPathOperator {
	return []URLPathOperator{URLPathOperatorAny, URLPathOperatorBeginsWith, URLPathOperatorContains, URLPathOperatorEndsWith, URLPathOperatorEqual, URLPathOperatorGreaterThan, URLPathOperatorGreaterThanOrEqual, URLPathOperatorLessThan, URLPathOperatorLessThanOrEqual, URLPathOperatorRegEx, URLPathOperatorWildcard}
}

// ValidateSecretType enumerates the values for validate secret type.
type ValidateSecretType string

const (
	// ValidateSecretTypeCustomerCertificate ...
	ValidateSecretTypeCustomerCertificate ValidateSecretType = "CustomerCertificate"
	// ValidateSecretTypeManagedCertificate ...
	ValidateSecretTypeManagedCertificate ValidateSecretType = "ManagedCertificate"
	// ValidateSecretTypeURLSigningKey ...
	ValidateSecretTypeURLSigningKey ValidateSecretType = "UrlSigningKey"
)

// PossibleValidateSecretTypeValues returns an array of possible values for the ValidateSecretType const type.
func PossibleValidateSecretTypeValues() []ValidateSecretType {
	return []ValidateSecretType{ValidateSecretTypeCustomerCertificate, ValidateSecretTypeManagedCertificate, ValidateSecretTypeURLSigningKey}
}
