/*
Copyright 2020 The Kubernetes Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1beta1 "github.com/k8snetworkplumbingwg/multi-networkpolicy/pkg/apis/k8s.cni.cncf.io/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeMultiNetworkPolicies implements MultiNetworkPolicyInterface
type FakeMultiNetworkPolicies struct {
	Fake *FakeK8sCniCncfIoV1beta1
	ns   string
}

var multinetworkpoliciesResource = schema.GroupVersionResource{Group: "k8s.cni.cncf.io", Version: "v1beta1", Resource: "multi-networkpolicies"}

var multinetworkpoliciesKind = schema.GroupVersionKind{Group: "k8s.cni.cncf.io", Version: "v1beta1", Kind: "MultiNetworkPolicy"}

// Get takes name of the multiNetworkPolicy, and returns the corresponding multiNetworkPolicy object, and an error if there is any.
func (c *FakeMultiNetworkPolicies) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.MultiNetworkPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(multinetworkpoliciesResource, c.ns, name), &v1beta1.MultiNetworkPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.MultiNetworkPolicy), err
}

// List takes label and field selectors, and returns the list of MultiNetworkPolicies that match those selectors.
func (c *FakeMultiNetworkPolicies) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.MultiNetworkPolicyList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(multinetworkpoliciesResource, multinetworkpoliciesKind, c.ns, opts), &v1beta1.MultiNetworkPolicyList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.MultiNetworkPolicyList{ListMeta: obj.(*v1beta1.MultiNetworkPolicyList).ListMeta}
	for _, item := range obj.(*v1beta1.MultiNetworkPolicyList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested multiNetworkPolicies.
func (c *FakeMultiNetworkPolicies) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(multinetworkpoliciesResource, c.ns, opts))

}

// Create takes the representation of a multiNetworkPolicy and creates it.  Returns the server's representation of the multiNetworkPolicy, and an error, if there is any.
func (c *FakeMultiNetworkPolicies) Create(ctx context.Context, multiNetworkPolicy *v1beta1.MultiNetworkPolicy, opts v1.CreateOptions) (result *v1beta1.MultiNetworkPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(multinetworkpoliciesResource, c.ns, multiNetworkPolicy), &v1beta1.MultiNetworkPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.MultiNetworkPolicy), err
}

// Update takes the representation of a multiNetworkPolicy and updates it. Returns the server's representation of the multiNetworkPolicy, and an error, if there is any.
func (c *FakeMultiNetworkPolicies) Update(ctx context.Context, multiNetworkPolicy *v1beta1.MultiNetworkPolicy, opts v1.UpdateOptions) (result *v1beta1.MultiNetworkPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(multinetworkpoliciesResource, c.ns, multiNetworkPolicy), &v1beta1.MultiNetworkPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.MultiNetworkPolicy), err
}

// Delete takes name of the multiNetworkPolicy and deletes it. Returns an error if one occurs.
func (c *FakeMultiNetworkPolicies) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(multinetworkpoliciesResource, c.ns, name), &v1beta1.MultiNetworkPolicy{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeMultiNetworkPolicies) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(multinetworkpoliciesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.MultiNetworkPolicyList{})
	return err
}

// Patch applies the patch and returns the patched multiNetworkPolicy.
func (c *FakeMultiNetworkPolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.MultiNetworkPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(multinetworkpoliciesResource, c.ns, name, pt, data, subresources...), &v1beta1.MultiNetworkPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.MultiNetworkPolicy), err
}
