/*
Copyright 2020 The Kubernetes Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	time "time"

	k8scnicncfiov1beta1 "github.com/k8snetworkplumbingwg/multi-networkpolicy/pkg/apis/k8s.cni.cncf.io/v1beta1"
	versioned "github.com/k8snetworkplumbingwg/multi-networkpolicy/pkg/client/clientset/versioned"
	internalinterfaces "github.com/k8snetworkplumbingwg/multi-networkpolicy/pkg/client/informers/externalversions/internalinterfaces"
	v1beta1 "github.com/k8snetworkplumbingwg/multi-networkpolicy/pkg/client/listers/k8s.cni.cncf.io/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// MultiNetworkPolicyInformer provides access to a shared informer and lister for
// MultiNetworkPolicies.
type MultiNetworkPolicyInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1beta1.MultiNetworkPolicyLister
}

type multiNetworkPolicyInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewMultiNetworkPolicyInformer constructs a new informer for MultiNetworkPolicy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewMultiNetworkPolicyInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredMultiNetworkPolicyInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredMultiNetworkPolicyInformer constructs a new informer for MultiNetworkPolicy type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredMultiNetworkPolicyInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.K8sCniCncfIoV1beta1().MultiNetworkPolicies(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.K8sCniCncfIoV1beta1().MultiNetworkPolicies(namespace).Watch(context.TODO(), options)
			},
		},
		&k8scnicncfiov1beta1.MultiNetworkPolicy{},
		resyncPeriod,
		indexers,
	)
}

func (f *multiNetworkPolicyInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredMultiNetworkPolicyInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *multiNetworkPolicyInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&k8scnicncfiov1beta1.MultiNetworkPolicy{}, f.defaultInformer)
}

func (f *multiNetworkPolicyInformer) Lister() v1beta1.MultiNetworkPolicyLister {
	return v1beta1.NewMultiNetworkPolicyLister(f.Informer().GetIndexer())
}
