# Manual Installation

If you want to install metering without OLM, using what's currently in master, first start by cloning the repo.
Next, decide which namespace you want to install Metering into, and set the `METERING_NAMESPACE` environment variable to the namespace you want to use.
By default, if it's unset, it will use the `metering` namespace.

## Versioning

By default, a manual install will deploy the latest build of master.
If you want to use a specific version, checkout a git tag for the version you want to use before installing, or follow the instructions for [installing with a custom metering operator image](#install-with-a-custom-metering-operator-image).

## Requirements

Our installation scripts are written in bash, and utilize a few non-standard tools to interact with yaml and json files.
Please ensure you have the following tools installed before running the install scripts:

- bash
- [faq](https://github.com/jzelinskie/faq) 0.0.5 or newer
  - For Fedora 29, Rawhide, and CentOS 7 you can use the following copr repo: <https://copr.fedorainfracloud.org/coprs/ecnahc515/faq/>
  - For mac: `brew tap jzelinskie/faq && brew install faq`
  - Or you can download the release binaries directly from Github: <https://github.com/jzelinskie/faq/releases>

## Install

**Note**: Before installing Metering, you need to configure long-term storage for the stack. Follow the instructions for [configuring storage](configuring-storage.md) before proceeding.

Depending on your Kubernetes platform (regular Kubernetes, or Openshift)

For a standard Kubernetes cluster:

```bash
export METERING_NAMESPACE=metering-$USER
./hack/install.sh
```

If you're using Openshift, use openshift-install.sh:

```bash
export METERING_NAMESPACE=metering-$USER
./hack/openshift-install.sh
```

## Uninstall

To uninstall the process is the same, pick the right uninstall script for your platform, and run it.

For a standard Kubernetes cluster:

```bash
export METERING_NAMESPACE=metering-$USER
./hack/uninstall.sh
```

If you're using Openshift, use openshift-uninstall.sh:

```bash
export METERING_NAMESPACE=metering-$USER
./hack/openshift-uninstall.sh
```

## Customizing the installation

If you wish to further customize the installation, such as modifying the default reporting-operator image tag or repository,
then you can use a custom `metering` resource. To start, copy the default metering resource to a
separate file that we can modify:

```bash
cp manifests/metering-config/default.yaml metering-custom.yaml
```

For developers, the most common change is modifying the image tag, config, and resource limits.
Take a look at the [common configuration docs](common-configuration.md) to get an
idea of what you can modify that relates to configuration and resource limits, and
`manifests/metering-config/latest-versions.yaml` to see how to change the
image tag of each component.

```bash
export METERING_NAMESPACE=metering-$USER
export METERING_CR_FILE=metering-custom.yaml
```

Then run the installation script for your platform:

- `./hack/install.sh`
- `./hack/openshift-install.sh`

For more details on configuration options, most are documented in the [configuring metering document][configuring-metering].

## Install with a custom metering operator image

You can override the metering-operator image using a combination of 3 environment variables:

Set `METERING_OPERATOR_IMAGE_REPO` to the image repository you wish to use, and set `METERING_OPERATOR_IMAGE_TAG` to the image tag you want.
If you only want to change the image tag, then leave `METERING_OPERATOR_IMAGE_REPO` unset.

For example:

```bash
export METERING_OPERATOR_IMAGE_REPO=internal-registry.example.org:6443/someorg/metering-helm-operator
export METERING_OPERATOR_IMAGE_TAG=0.13.0
./hack/openshift-install.sh
```

You can also it in a single line:

```bash
METERING_OPERATOR_IMAGE_TAG=pr-123 ./hack/openshift-install.sh
```

## Run reporting operator locally

It's also possible to run the operator locally.
To simplify this, we have a few `Makefile` targets to handle the process of building and running the operator.

First, we still need to ensure that Presto and Hive are running in the cluster, and then set reporting-operator replicas to zero so that our local operator can obtain the leader election lease when we start it.

To do this, update your `metering-custom.yaml` to set `spec.reporting-operator.replicas` to `0` like so:

```yaml
spec:
  reporting-operator:
    replicas: 0
```

Next, run the install script for your platform (see above).

After running the install script, figure out where your Prometheus pod is running.
By default the `run-reporting-operator-local` Makefile target assumes that the pod is in the `openshift-monitoring` namespace and can be queried using the label selector `app=prometheus`.

If your Prometheus is located somewhere else, you can override the defaults using the environment variables `METERING_PROMETHEUS_NAMESPACE` and `METERING_PROMTHEUS_LABEL_SELECTOR` to the namespace your Prometheus pod is in, and the label selector for querying Prometheus. Alternatively, if you wish to specify your Prometheus with a host, set `METERING_PROMETHEUS_PORT_FORWARD` to false and `METERING_PROMETHEUS_HOST` to the host/port of your instance.

Ex (these are the defaults):

```bash
export METERING_PROMETHEUS_NAMESPACE=openshift-monitoring
export METERING_PROMTHEUS_LABEL_SELECTOR=app=prometheus
```

Finally, use the following command to build & run the operator:

```bash
make run-reporting-operator-local
```

The above command builds the operator for your local OS (by default it only builds for Linux), uses `kubectl port-forward` to make Prometheus, Presto, and Hive available locally for your operator to communicate with, and then starts the operator with the configuration set to use these local port-forwards.
Lastly, the operator automatically uses your `$KUBECONFIG` to connect and authenticate to your cluster and perform Kubernetes API calls.

## Run metering operator locally

The metering operator is the top-level operator which deploys other components using Ansible and helm charts.
It's possible to also run this locally so you can iterate on changes made to the Ansible role or charts and test them with the metering-operator before they're built and pushed to Quay for CI.

To run it locally you need to have the following:

- A connection to a docker daemon.
- Your `$KUBECONFIG` environment variable must be set and accessible to your Docker daemon.
- Your `$METERING_NAMESPACE` environment variable must be set, and unless `$LOCAL_METERING_OPERATOR_RUN_INSTALL` to `true`, the namespace must already exist.

The following command will build and run the metering-operator container image, which will watch for Metering resources in the namespace specified by `$METERING_NAMESPACE`, using your `$KUBECONFIG` to communicate with the API server.

```bash
make run-metering-operator-local
```

## Install the most recent version available in OLM

There is a set of scripts for install/uninstall that automates using the latest version of the `metering` package in OLM: `hack/olm-install.sh` and `hack/olm-uninstall.sh`.
These scripts work similarly to the `hack/install.sh` and `hack/uninstall.sh` scripts, except they install using OLM.

Set your `METERING_NAMESPACE` and `METERING_CR_FILE` then run the script:

```bash
./hack/olm-install.sh
```

To uninstall:

```bash
./hack/olm-uninstall.sh
```

**Note**: You must run the olm-uninstall.sh script to uninstall. Not doing so may result in inability to re-install Metering correctly.

For more details on what this is doing, see the [OLM install guide][olm-install]

[configuring-metering]: metering-config.md
[olm-install]: olm-install.md
