/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/ptp-operator/pkg/apis/ptp/v1"
	scheme "github.com/openshift/ptp-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// NodePtpDevicesGetter has a method to return a NodePtpDeviceInterface.
// A group's client should implement this interface.
type NodePtpDevicesGetter interface {
	NodePtpDevices(namespace string) NodePtpDeviceInterface
}

// NodePtpDeviceInterface has methods to work with NodePtpDevice resources.
type NodePtpDeviceInterface interface {
	Create(*v1.NodePtpDevice) (*v1.NodePtpDevice, error)
	Update(*v1.NodePtpDevice) (*v1.NodePtpDevice, error)
	UpdateStatus(*v1.NodePtpDevice) (*v1.NodePtpDevice, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.NodePtpDevice, error)
	List(opts metav1.ListOptions) (*v1.NodePtpDeviceList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.NodePtpDevice, err error)
	NodePtpDeviceExpansion
}

// nodePtpDevices implements NodePtpDeviceInterface
type nodePtpDevices struct {
	client rest.Interface
	ns     string
}

// newNodePtpDevices returns a NodePtpDevices
func newNodePtpDevices(c *PtpV1Client, namespace string) *nodePtpDevices {
	return &nodePtpDevices{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the nodePtpDevice, and returns the corresponding nodePtpDevice object, and an error if there is any.
func (c *nodePtpDevices) Get(name string, options metav1.GetOptions) (result *v1.NodePtpDevice, err error) {
	result = &v1.NodePtpDevice{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of NodePtpDevices that match those selectors.
func (c *nodePtpDevices) List(opts metav1.ListOptions) (result *v1.NodePtpDeviceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.NodePtpDeviceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested nodePtpDevices.
func (c *nodePtpDevices) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a nodePtpDevice and creates it.  Returns the server's representation of the nodePtpDevice, and an error, if there is any.
func (c *nodePtpDevices) Create(nodePtpDevice *v1.NodePtpDevice) (result *v1.NodePtpDevice, err error) {
	result = &v1.NodePtpDevice{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		Body(nodePtpDevice).
		Do().
		Into(result)
	return
}

// Update takes the representation of a nodePtpDevice and updates it. Returns the server's representation of the nodePtpDevice, and an error, if there is any.
func (c *nodePtpDevices) Update(nodePtpDevice *v1.NodePtpDevice) (result *v1.NodePtpDevice, err error) {
	result = &v1.NodePtpDevice{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		Name(nodePtpDevice.Name).
		Body(nodePtpDevice).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *nodePtpDevices) UpdateStatus(nodePtpDevice *v1.NodePtpDevice) (result *v1.NodePtpDevice, err error) {
	result = &v1.NodePtpDevice{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		Name(nodePtpDevice.Name).
		SubResource("status").
		Body(nodePtpDevice).
		Do().
		Into(result)
	return
}

// Delete takes name of the nodePtpDevice and deletes it. Returns an error if one occurs.
func (c *nodePtpDevices) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *nodePtpDevices) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("nodeptpdevices").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched nodePtpDevice.
func (c *nodePtpDevices) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.NodePtpDevice, err error) {
	result = &v1.NodePtpDevice{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("nodeptpdevices").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
