// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package worklink

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateDomain = "AssociateDomain"

// AssociateDomainRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDomain for more information on using the AssociateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateDomainRequest method.
//    req, resp := client.AssociateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateDomain
func (c *WorkLink) AssociateDomainRequest(input *AssociateDomainInput) (req *request.Request, output *AssociateDomainOutput) {
	op := &request.Operation{
		Name:       opAssociateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/associateDomain",
	}

	if input == nil {
		input = &AssociateDomainInput{}
	}

	output = &AssociateDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateDomain API operation for Amazon WorkLink.
//
// Specifies a domain to be associated to Amazon WorkLink.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation AssociateDomain for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateDomain
func (c *WorkLink) AssociateDomain(input *AssociateDomainInput) (*AssociateDomainOutput, error) {
	req, out := c.AssociateDomainRequest(input)
	return out, req.Send()
}

// AssociateDomainWithContext is the same as AssociateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) AssociateDomainWithContext(ctx aws.Context, input *AssociateDomainInput, opts ...request.Option) (*AssociateDomainOutput, error) {
	req, out := c.AssociateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateWebsiteAuthorizationProvider = "AssociateWebsiteAuthorizationProvider"

// AssociateWebsiteAuthorizationProviderRequest generates a "aws/request.Request" representing the
// client's request for the AssociateWebsiteAuthorizationProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateWebsiteAuthorizationProvider for more information on using the AssociateWebsiteAuthorizationProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateWebsiteAuthorizationProviderRequest method.
//    req, resp := client.AssociateWebsiteAuthorizationProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteAuthorizationProvider
func (c *WorkLink) AssociateWebsiteAuthorizationProviderRequest(input *AssociateWebsiteAuthorizationProviderInput) (req *request.Request, output *AssociateWebsiteAuthorizationProviderOutput) {
	op := &request.Operation{
		Name:       opAssociateWebsiteAuthorizationProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/associateWebsiteAuthorizationProvider",
	}

	if input == nil {
		input = &AssociateWebsiteAuthorizationProviderInput{}
	}

	output = &AssociateWebsiteAuthorizationProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateWebsiteAuthorizationProvider API operation for Amazon WorkLink.
//
// Associates a website authorization provider with a specified fleet. This
// is used to authorize users against associated websites in the company network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation AssociateWebsiteAuthorizationProvider for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteAuthorizationProvider
func (c *WorkLink) AssociateWebsiteAuthorizationProvider(input *AssociateWebsiteAuthorizationProviderInput) (*AssociateWebsiteAuthorizationProviderOutput, error) {
	req, out := c.AssociateWebsiteAuthorizationProviderRequest(input)
	return out, req.Send()
}

// AssociateWebsiteAuthorizationProviderWithContext is the same as AssociateWebsiteAuthorizationProvider with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateWebsiteAuthorizationProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) AssociateWebsiteAuthorizationProviderWithContext(ctx aws.Context, input *AssociateWebsiteAuthorizationProviderInput, opts ...request.Option) (*AssociateWebsiteAuthorizationProviderOutput, error) {
	req, out := c.AssociateWebsiteAuthorizationProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateWebsiteCertificateAuthority = "AssociateWebsiteCertificateAuthority"

// AssociateWebsiteCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the AssociateWebsiteCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateWebsiteCertificateAuthority for more information on using the AssociateWebsiteCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateWebsiteCertificateAuthorityRequest method.
//    req, resp := client.AssociateWebsiteCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteCertificateAuthority
func (c *WorkLink) AssociateWebsiteCertificateAuthorityRequest(input *AssociateWebsiteCertificateAuthorityInput) (req *request.Request, output *AssociateWebsiteCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opAssociateWebsiteCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/associateWebsiteCertificateAuthority",
	}

	if input == nil {
		input = &AssociateWebsiteCertificateAuthorityInput{}
	}

	output = &AssociateWebsiteCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateWebsiteCertificateAuthority API operation for Amazon WorkLink.
//
// Imports the root certificate of a certificate authority (CA) used to obtain
// TLS certificates used by associated websites within the company network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation AssociateWebsiteCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteCertificateAuthority
func (c *WorkLink) AssociateWebsiteCertificateAuthority(input *AssociateWebsiteCertificateAuthorityInput) (*AssociateWebsiteCertificateAuthorityOutput, error) {
	req, out := c.AssociateWebsiteCertificateAuthorityRequest(input)
	return out, req.Send()
}

// AssociateWebsiteCertificateAuthorityWithContext is the same as AssociateWebsiteCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateWebsiteCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) AssociateWebsiteCertificateAuthorityWithContext(ctx aws.Context, input *AssociateWebsiteCertificateAuthorityInput, opts ...request.Option) (*AssociateWebsiteCertificateAuthorityOutput, error) {
	req, out := c.AssociateWebsiteCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleet for more information on using the CreateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFleetRequest method.
//    req, resp := client.CreateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/CreateFleet
func (c *WorkLink) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/createFleet",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleet API operation for Amazon WorkLink.
//
// Creates a fleet. A fleet consists of resources and the configuration that
// delivers associated websites to authorized users who download and set up
// the Amazon WorkLink app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation CreateFleet for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/CreateFleet
func (c *WorkLink) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	return out, req.Send()
}

// CreateFleetWithContext is the same as CreateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) CreateFleetWithContext(ctx aws.Context, input *CreateFleetInput, opts ...request.Option) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleet for more information on using the DeleteFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFleetRequest method.
//    req, resp := client.DeleteFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DeleteFleet
func (c *WorkLink) DeleteFleetRequest(input *DeleteFleetInput) (req *request.Request, output *DeleteFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteFleet",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	output = &DeleteFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFleet API operation for Amazon WorkLink.
//
// Deletes a fleet. Prevents users from accessing previously associated websites.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DeleteFleet for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DeleteFleet
func (c *WorkLink) DeleteFleet(input *DeleteFleetInput) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	return out, req.Send()
}

// DeleteFleetWithContext is the same as DeleteFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DeleteFleetWithContext(ctx aws.Context, input *DeleteFleetInput, opts ...request.Option) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAuditStreamConfiguration = "DescribeAuditStreamConfiguration"

// DescribeAuditStreamConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAuditStreamConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAuditStreamConfiguration for more information on using the DescribeAuditStreamConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAuditStreamConfigurationRequest method.
//    req, resp := client.DescribeAuditStreamConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeAuditStreamConfiguration
func (c *WorkLink) DescribeAuditStreamConfigurationRequest(input *DescribeAuditStreamConfigurationInput) (req *request.Request, output *DescribeAuditStreamConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeAuditStreamConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/describeAuditStreamConfiguration",
	}

	if input == nil {
		input = &DescribeAuditStreamConfigurationInput{}
	}

	output = &DescribeAuditStreamConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAuditStreamConfiguration API operation for Amazon WorkLink.
//
// Describes the configuration for delivering audit streams to the customer
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DescribeAuditStreamConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeAuditStreamConfiguration
func (c *WorkLink) DescribeAuditStreamConfiguration(input *DescribeAuditStreamConfigurationInput) (*DescribeAuditStreamConfigurationOutput, error) {
	req, out := c.DescribeAuditStreamConfigurationRequest(input)
	return out, req.Send()
}

// DescribeAuditStreamConfigurationWithContext is the same as DescribeAuditStreamConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAuditStreamConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DescribeAuditStreamConfigurationWithContext(ctx aws.Context, input *DescribeAuditStreamConfigurationInput, opts ...request.Option) (*DescribeAuditStreamConfigurationOutput, error) {
	req, out := c.DescribeAuditStreamConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCompanyNetworkConfiguration = "DescribeCompanyNetworkConfiguration"

// DescribeCompanyNetworkConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCompanyNetworkConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCompanyNetworkConfiguration for more information on using the DescribeCompanyNetworkConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCompanyNetworkConfigurationRequest method.
//    req, resp := client.DescribeCompanyNetworkConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeCompanyNetworkConfiguration
func (c *WorkLink) DescribeCompanyNetworkConfigurationRequest(input *DescribeCompanyNetworkConfigurationInput) (req *request.Request, output *DescribeCompanyNetworkConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeCompanyNetworkConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/describeCompanyNetworkConfiguration",
	}

	if input == nil {
		input = &DescribeCompanyNetworkConfigurationInput{}
	}

	output = &DescribeCompanyNetworkConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCompanyNetworkConfiguration API operation for Amazon WorkLink.
//
// Describes the networking configuration to access the internal websites associated
// with the specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DescribeCompanyNetworkConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeCompanyNetworkConfiguration
func (c *WorkLink) DescribeCompanyNetworkConfiguration(input *DescribeCompanyNetworkConfigurationInput) (*DescribeCompanyNetworkConfigurationOutput, error) {
	req, out := c.DescribeCompanyNetworkConfigurationRequest(input)
	return out, req.Send()
}

// DescribeCompanyNetworkConfigurationWithContext is the same as DescribeCompanyNetworkConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCompanyNetworkConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DescribeCompanyNetworkConfigurationWithContext(ctx aws.Context, input *DescribeCompanyNetworkConfigurationInput, opts ...request.Option) (*DescribeCompanyNetworkConfigurationOutput, error) {
	req, out := c.DescribeCompanyNetworkConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDevice = "DescribeDevice"

// DescribeDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDevice for more information on using the DescribeDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeviceRequest method.
//    req, resp := client.DescribeDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevice
func (c *WorkLink) DescribeDeviceRequest(input *DescribeDeviceInput) (req *request.Request, output *DescribeDeviceOutput) {
	op := &request.Operation{
		Name:       opDescribeDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/describeDevice",
	}

	if input == nil {
		input = &DescribeDeviceInput{}
	}

	output = &DescribeDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDevice API operation for Amazon WorkLink.
//
// Provides information about a user's device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DescribeDevice for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevice
func (c *WorkLink) DescribeDevice(input *DescribeDeviceInput) (*DescribeDeviceOutput, error) {
	req, out := c.DescribeDeviceRequest(input)
	return out, req.Send()
}

// DescribeDeviceWithContext is the same as DescribeDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DescribeDeviceWithContext(ctx aws.Context, input *DescribeDeviceInput, opts ...request.Option) (*DescribeDeviceOutput, error) {
	req, out := c.DescribeDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDevicePolicyConfiguration = "DescribeDevicePolicyConfiguration"

// DescribeDevicePolicyConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDevicePolicyConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDevicePolicyConfiguration for more information on using the DescribeDevicePolicyConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDevicePolicyConfigurationRequest method.
//    req, resp := client.DescribeDevicePolicyConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevicePolicyConfiguration
func (c *WorkLink) DescribeDevicePolicyConfigurationRequest(input *DescribeDevicePolicyConfigurationInput) (req *request.Request, output *DescribeDevicePolicyConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeDevicePolicyConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/describeDevicePolicyConfiguration",
	}

	if input == nil {
		input = &DescribeDevicePolicyConfigurationInput{}
	}

	output = &DescribeDevicePolicyConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDevicePolicyConfiguration API operation for Amazon WorkLink.
//
// Describes the device policy configuration for the specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DescribeDevicePolicyConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevicePolicyConfiguration
func (c *WorkLink) DescribeDevicePolicyConfiguration(input *DescribeDevicePolicyConfigurationInput) (*DescribeDevicePolicyConfigurationOutput, error) {
	req, out := c.DescribeDevicePolicyConfigurationRequest(input)
	return out, req.Send()
}

// DescribeDevicePolicyConfigurationWithContext is the same as DescribeDevicePolicyConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDevicePolicyConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DescribeDevicePolicyConfigurationWithContext(ctx aws.Context, input *DescribeDevicePolicyConfigurationInput, opts ...request.Option) (*DescribeDevicePolicyConfigurationOutput, error) {
	req, out := c.DescribeDevicePolicyConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomain = "DescribeDomain"

// DescribeDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomain for more information on using the DescribeDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDomainRequest method.
//    req, resp := client.DescribeDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDomain
func (c *WorkLink) DescribeDomainRequest(input *DescribeDomainInput) (req *request.Request, output *DescribeDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/describeDomain",
	}

	if input == nil {
		input = &DescribeDomainInput{}
	}

	output = &DescribeDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomain API operation for Amazon WorkLink.
//
// Provides information about the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DescribeDomain for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDomain
func (c *WorkLink) DescribeDomain(input *DescribeDomainInput) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	return out, req.Send()
}

// DescribeDomainWithContext is the same as DescribeDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DescribeDomainWithContext(ctx aws.Context, input *DescribeDomainInput, opts ...request.Option) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetMetadata = "DescribeFleetMetadata"

// DescribeFleetMetadataRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetMetadata for more information on using the DescribeFleetMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetMetadataRequest method.
//    req, resp := client.DescribeFleetMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeFleetMetadata
func (c *WorkLink) DescribeFleetMetadataRequest(input *DescribeFleetMetadataInput) (req *request.Request, output *DescribeFleetMetadataOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/describeFleetMetadata",
	}

	if input == nil {
		input = &DescribeFleetMetadataInput{}
	}

	output = &DescribeFleetMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetMetadata API operation for Amazon WorkLink.
//
// Provides basic information for the specified fleet, excluding identity provider,
// networking, and device configuration details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DescribeFleetMetadata for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeFleetMetadata
func (c *WorkLink) DescribeFleetMetadata(input *DescribeFleetMetadataInput) (*DescribeFleetMetadataOutput, error) {
	req, out := c.DescribeFleetMetadataRequest(input)
	return out, req.Send()
}

// DescribeFleetMetadataWithContext is the same as DescribeFleetMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DescribeFleetMetadataWithContext(ctx aws.Context, input *DescribeFleetMetadataInput, opts ...request.Option) (*DescribeFleetMetadataOutput, error) {
	req, out := c.DescribeFleetMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIdentityProviderConfiguration = "DescribeIdentityProviderConfiguration"

// DescribeIdentityProviderConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityProviderConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdentityProviderConfiguration for more information on using the DescribeIdentityProviderConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIdentityProviderConfigurationRequest method.
//    req, resp := client.DescribeIdentityProviderConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeIdentityProviderConfiguration
func (c *WorkLink) DescribeIdentityProviderConfigurationRequest(input *DescribeIdentityProviderConfigurationInput) (req *request.Request, output *DescribeIdentityProviderConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityProviderConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/describeIdentityProviderConfiguration",
	}

	if input == nil {
		input = &DescribeIdentityProviderConfigurationInput{}
	}

	output = &DescribeIdentityProviderConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentityProviderConfiguration API operation for Amazon WorkLink.
//
// Describes the identity provider configuration of the specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DescribeIdentityProviderConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeIdentityProviderConfiguration
func (c *WorkLink) DescribeIdentityProviderConfiguration(input *DescribeIdentityProviderConfigurationInput) (*DescribeIdentityProviderConfigurationOutput, error) {
	req, out := c.DescribeIdentityProviderConfigurationRequest(input)
	return out, req.Send()
}

// DescribeIdentityProviderConfigurationWithContext is the same as DescribeIdentityProviderConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdentityProviderConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DescribeIdentityProviderConfigurationWithContext(ctx aws.Context, input *DescribeIdentityProviderConfigurationInput, opts ...request.Option) (*DescribeIdentityProviderConfigurationOutput, error) {
	req, out := c.DescribeIdentityProviderConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWebsiteCertificateAuthority = "DescribeWebsiteCertificateAuthority"

// DescribeWebsiteCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWebsiteCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWebsiteCertificateAuthority for more information on using the DescribeWebsiteCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWebsiteCertificateAuthorityRequest method.
//    req, resp := client.DescribeWebsiteCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeWebsiteCertificateAuthority
func (c *WorkLink) DescribeWebsiteCertificateAuthorityRequest(input *DescribeWebsiteCertificateAuthorityInput) (req *request.Request, output *DescribeWebsiteCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opDescribeWebsiteCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/describeWebsiteCertificateAuthority",
	}

	if input == nil {
		input = &DescribeWebsiteCertificateAuthorityInput{}
	}

	output = &DescribeWebsiteCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWebsiteCertificateAuthority API operation for Amazon WorkLink.
//
// Provides information about the certificate authority.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DescribeWebsiteCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeWebsiteCertificateAuthority
func (c *WorkLink) DescribeWebsiteCertificateAuthority(input *DescribeWebsiteCertificateAuthorityInput) (*DescribeWebsiteCertificateAuthorityOutput, error) {
	req, out := c.DescribeWebsiteCertificateAuthorityRequest(input)
	return out, req.Send()
}

// DescribeWebsiteCertificateAuthorityWithContext is the same as DescribeWebsiteCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWebsiteCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DescribeWebsiteCertificateAuthorityWithContext(ctx aws.Context, input *DescribeWebsiteCertificateAuthorityInput, opts ...request.Option) (*DescribeWebsiteCertificateAuthorityOutput, error) {
	req, out := c.DescribeWebsiteCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateDomain = "DisassociateDomain"

// DisassociateDomainRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateDomain for more information on using the DisassociateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateDomainRequest method.
//    req, resp := client.DisassociateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateDomain
func (c *WorkLink) DisassociateDomainRequest(input *DisassociateDomainInput) (req *request.Request, output *DisassociateDomainOutput) {
	op := &request.Operation{
		Name:       opDisassociateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/disassociateDomain",
	}

	if input == nil {
		input = &DisassociateDomainInput{}
	}

	output = &DisassociateDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateDomain API operation for Amazon WorkLink.
//
// Disassociates a domain from Amazon WorkLink. End users lose the ability to
// access the domain with Amazon WorkLink.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DisassociateDomain for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateDomain
func (c *WorkLink) DisassociateDomain(input *DisassociateDomainInput) (*DisassociateDomainOutput, error) {
	req, out := c.DisassociateDomainRequest(input)
	return out, req.Send()
}

// DisassociateDomainWithContext is the same as DisassociateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DisassociateDomainWithContext(ctx aws.Context, input *DisassociateDomainInput, opts ...request.Option) (*DisassociateDomainOutput, error) {
	req, out := c.DisassociateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateWebsiteAuthorizationProvider = "DisassociateWebsiteAuthorizationProvider"

// DisassociateWebsiteAuthorizationProviderRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateWebsiteAuthorizationProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateWebsiteAuthorizationProvider for more information on using the DisassociateWebsiteAuthorizationProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateWebsiteAuthorizationProviderRequest method.
//    req, resp := client.DisassociateWebsiteAuthorizationProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteAuthorizationProvider
func (c *WorkLink) DisassociateWebsiteAuthorizationProviderRequest(input *DisassociateWebsiteAuthorizationProviderInput) (req *request.Request, output *DisassociateWebsiteAuthorizationProviderOutput) {
	op := &request.Operation{
		Name:       opDisassociateWebsiteAuthorizationProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/disassociateWebsiteAuthorizationProvider",
	}

	if input == nil {
		input = &DisassociateWebsiteAuthorizationProviderInput{}
	}

	output = &DisassociateWebsiteAuthorizationProviderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateWebsiteAuthorizationProvider API operation for Amazon WorkLink.
//
// Disassociates a website authorization provider from a specified fleet. After
// the disassociation, users can't load any associated websites that require
// this authorization provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DisassociateWebsiteAuthorizationProvider for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * ResourceAlreadyExistsException
//   The resource already exists.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteAuthorizationProvider
func (c *WorkLink) DisassociateWebsiteAuthorizationProvider(input *DisassociateWebsiteAuthorizationProviderInput) (*DisassociateWebsiteAuthorizationProviderOutput, error) {
	req, out := c.DisassociateWebsiteAuthorizationProviderRequest(input)
	return out, req.Send()
}

// DisassociateWebsiteAuthorizationProviderWithContext is the same as DisassociateWebsiteAuthorizationProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateWebsiteAuthorizationProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DisassociateWebsiteAuthorizationProviderWithContext(ctx aws.Context, input *DisassociateWebsiteAuthorizationProviderInput, opts ...request.Option) (*DisassociateWebsiteAuthorizationProviderOutput, error) {
	req, out := c.DisassociateWebsiteAuthorizationProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateWebsiteCertificateAuthority = "DisassociateWebsiteCertificateAuthority"

// DisassociateWebsiteCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateWebsiteCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateWebsiteCertificateAuthority for more information on using the DisassociateWebsiteCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateWebsiteCertificateAuthorityRequest method.
//    req, resp := client.DisassociateWebsiteCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteCertificateAuthority
func (c *WorkLink) DisassociateWebsiteCertificateAuthorityRequest(input *DisassociateWebsiteCertificateAuthorityInput) (req *request.Request, output *DisassociateWebsiteCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opDisassociateWebsiteCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/disassociateWebsiteCertificateAuthority",
	}

	if input == nil {
		input = &DisassociateWebsiteCertificateAuthorityInput{}
	}

	output = &DisassociateWebsiteCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateWebsiteCertificateAuthority API operation for Amazon WorkLink.
//
// Removes a certificate authority (CA).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation DisassociateWebsiteCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteCertificateAuthority
func (c *WorkLink) DisassociateWebsiteCertificateAuthority(input *DisassociateWebsiteCertificateAuthorityInput) (*DisassociateWebsiteCertificateAuthorityOutput, error) {
	req, out := c.DisassociateWebsiteCertificateAuthorityRequest(input)
	return out, req.Send()
}

// DisassociateWebsiteCertificateAuthorityWithContext is the same as DisassociateWebsiteCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateWebsiteCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) DisassociateWebsiteCertificateAuthorityWithContext(ctx aws.Context, input *DisassociateWebsiteCertificateAuthorityInput, opts ...request.Option) (*DisassociateWebsiteCertificateAuthorityOutput, error) {
	req, out := c.DisassociateWebsiteCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDevices for more information on using the ListDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDevicesRequest method.
//    req, resp := client.ListDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDevices
func (c *WorkLink) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/listDevices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	output = &ListDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevices API operation for Amazon WorkLink.
//
// Retrieves a list of devices registered with the specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation ListDevices for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDevices
func (c *WorkLink) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	return out, req.Send()
}

// ListDevicesWithContext is the same as ListDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) ListDevicesWithContext(ctx aws.Context, input *ListDevicesInput, opts ...request.Option) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDevicesPages iterates over the pages of a ListDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDevices operation.
//    pageNum := 0
//    err := client.ListDevicesPages(params,
//        func(page *worklink.ListDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkLink) ListDevicesPages(input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool) error {
	return c.ListDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDevicesPagesWithContext same as ListDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) ListDevicesPagesWithContext(ctx aws.Context, input *ListDevicesInput, fn func(*ListDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomains for more information on using the ListDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainsRequest method.
//    req, resp := client.ListDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDomains
func (c *WorkLink) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/listDomains",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for Amazon WorkLink.
//
// Retrieves a list of domains associated to a specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation ListDomains for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDomains
func (c *WorkLink) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsPages iterates over the pages of a ListDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDomains operation.
//    pageNum := 0
//    err := client.ListDomainsPages(params,
//        func(page *worklink.ListDomainsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkLink) ListDomainsPages(input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool) error {
	return c.ListDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsPagesWithContext same as ListDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) ListDomainsPagesWithContext(ctx aws.Context, input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFleets = "ListFleets"

// ListFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFleets for more information on using the ListFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFleetsRequest method.
//    req, resp := client.ListFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets
func (c *WorkLink) ListFleetsRequest(input *ListFleetsInput) (req *request.Request, output *ListFleetsOutput) {
	op := &request.Operation{
		Name:       opListFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/listFleets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFleetsInput{}
	}

	output = &ListFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFleets API operation for Amazon WorkLink.
//
// Retrieves a list of fleets for the current account and Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation ListFleets for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets
func (c *WorkLink) ListFleets(input *ListFleetsInput) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	return out, req.Send()
}

// ListFleetsWithContext is the same as ListFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) ListFleetsWithContext(ctx aws.Context, input *ListFleetsInput, opts ...request.Option) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFleetsPages iterates over the pages of a ListFleets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFleets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFleets operation.
//    pageNum := 0
//    err := client.ListFleetsPages(params,
//        func(page *worklink.ListFleetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkLink) ListFleetsPages(input *ListFleetsInput, fn func(*ListFleetsOutput, bool) bool) error {
	return c.ListFleetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFleetsPagesWithContext same as ListFleetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) ListFleetsPagesWithContext(ctx aws.Context, input *ListFleetsInput, fn func(*ListFleetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFleetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFleetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFleetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListTagsForResource
func (c *WorkLink) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon WorkLink.
//
// Retrieves a list of tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListTagsForResource
func (c *WorkLink) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWebsiteAuthorizationProviders = "ListWebsiteAuthorizationProviders"

// ListWebsiteAuthorizationProvidersRequest generates a "aws/request.Request" representing the
// client's request for the ListWebsiteAuthorizationProviders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWebsiteAuthorizationProviders for more information on using the ListWebsiteAuthorizationProviders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWebsiteAuthorizationProvidersRequest method.
//    req, resp := client.ListWebsiteAuthorizationProvidersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteAuthorizationProviders
func (c *WorkLink) ListWebsiteAuthorizationProvidersRequest(input *ListWebsiteAuthorizationProvidersInput) (req *request.Request, output *ListWebsiteAuthorizationProvidersOutput) {
	op := &request.Operation{
		Name:       opListWebsiteAuthorizationProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/listWebsiteAuthorizationProviders",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWebsiteAuthorizationProvidersInput{}
	}

	output = &ListWebsiteAuthorizationProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWebsiteAuthorizationProviders API operation for Amazon WorkLink.
//
// Retrieves a list of website authorization providers associated with a specified
// fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation ListWebsiteAuthorizationProviders for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteAuthorizationProviders
func (c *WorkLink) ListWebsiteAuthorizationProviders(input *ListWebsiteAuthorizationProvidersInput) (*ListWebsiteAuthorizationProvidersOutput, error) {
	req, out := c.ListWebsiteAuthorizationProvidersRequest(input)
	return out, req.Send()
}

// ListWebsiteAuthorizationProvidersWithContext is the same as ListWebsiteAuthorizationProviders with the addition of
// the ability to pass a context and additional request options.
//
// See ListWebsiteAuthorizationProviders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) ListWebsiteAuthorizationProvidersWithContext(ctx aws.Context, input *ListWebsiteAuthorizationProvidersInput, opts ...request.Option) (*ListWebsiteAuthorizationProvidersOutput, error) {
	req, out := c.ListWebsiteAuthorizationProvidersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWebsiteAuthorizationProvidersPages iterates over the pages of a ListWebsiteAuthorizationProviders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWebsiteAuthorizationProviders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWebsiteAuthorizationProviders operation.
//    pageNum := 0
//    err := client.ListWebsiteAuthorizationProvidersPages(params,
//        func(page *worklink.ListWebsiteAuthorizationProvidersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkLink) ListWebsiteAuthorizationProvidersPages(input *ListWebsiteAuthorizationProvidersInput, fn func(*ListWebsiteAuthorizationProvidersOutput, bool) bool) error {
	return c.ListWebsiteAuthorizationProvidersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWebsiteAuthorizationProvidersPagesWithContext same as ListWebsiteAuthorizationProvidersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) ListWebsiteAuthorizationProvidersPagesWithContext(ctx aws.Context, input *ListWebsiteAuthorizationProvidersInput, fn func(*ListWebsiteAuthorizationProvidersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWebsiteAuthorizationProvidersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWebsiteAuthorizationProvidersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWebsiteAuthorizationProvidersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWebsiteCertificateAuthorities = "ListWebsiteCertificateAuthorities"

// ListWebsiteCertificateAuthoritiesRequest generates a "aws/request.Request" representing the
// client's request for the ListWebsiteCertificateAuthorities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWebsiteCertificateAuthorities for more information on using the ListWebsiteCertificateAuthorities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWebsiteCertificateAuthoritiesRequest method.
//    req, resp := client.ListWebsiteCertificateAuthoritiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteCertificateAuthorities
func (c *WorkLink) ListWebsiteCertificateAuthoritiesRequest(input *ListWebsiteCertificateAuthoritiesInput) (req *request.Request, output *ListWebsiteCertificateAuthoritiesOutput) {
	op := &request.Operation{
		Name:       opListWebsiteCertificateAuthorities,
		HTTPMethod: "POST",
		HTTPPath:   "/listWebsiteCertificateAuthorities",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWebsiteCertificateAuthoritiesInput{}
	}

	output = &ListWebsiteCertificateAuthoritiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWebsiteCertificateAuthorities API operation for Amazon WorkLink.
//
// Retrieves a list of certificate authorities added for the current account
// and Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation ListWebsiteCertificateAuthorities for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteCertificateAuthorities
func (c *WorkLink) ListWebsiteCertificateAuthorities(input *ListWebsiteCertificateAuthoritiesInput) (*ListWebsiteCertificateAuthoritiesOutput, error) {
	req, out := c.ListWebsiteCertificateAuthoritiesRequest(input)
	return out, req.Send()
}

// ListWebsiteCertificateAuthoritiesWithContext is the same as ListWebsiteCertificateAuthorities with the addition of
// the ability to pass a context and additional request options.
//
// See ListWebsiteCertificateAuthorities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) ListWebsiteCertificateAuthoritiesWithContext(ctx aws.Context, input *ListWebsiteCertificateAuthoritiesInput, opts ...request.Option) (*ListWebsiteCertificateAuthoritiesOutput, error) {
	req, out := c.ListWebsiteCertificateAuthoritiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWebsiteCertificateAuthoritiesPages iterates over the pages of a ListWebsiteCertificateAuthorities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWebsiteCertificateAuthorities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWebsiteCertificateAuthorities operation.
//    pageNum := 0
//    err := client.ListWebsiteCertificateAuthoritiesPages(params,
//        func(page *worklink.ListWebsiteCertificateAuthoritiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkLink) ListWebsiteCertificateAuthoritiesPages(input *ListWebsiteCertificateAuthoritiesInput, fn func(*ListWebsiteCertificateAuthoritiesOutput, bool) bool) error {
	return c.ListWebsiteCertificateAuthoritiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWebsiteCertificateAuthoritiesPagesWithContext same as ListWebsiteCertificateAuthoritiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) ListWebsiteCertificateAuthoritiesPagesWithContext(ctx aws.Context, input *ListWebsiteCertificateAuthoritiesInput, fn func(*ListWebsiteCertificateAuthoritiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWebsiteCertificateAuthoritiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWebsiteCertificateAuthoritiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWebsiteCertificateAuthoritiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRestoreDomainAccess = "RestoreDomainAccess"

// RestoreDomainAccessRequest generates a "aws/request.Request" representing the
// client's request for the RestoreDomainAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreDomainAccess for more information on using the RestoreDomainAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreDomainAccessRequest method.
//    req, resp := client.RestoreDomainAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RestoreDomainAccess
func (c *WorkLink) RestoreDomainAccessRequest(input *RestoreDomainAccessInput) (req *request.Request, output *RestoreDomainAccessOutput) {
	op := &request.Operation{
		Name:       opRestoreDomainAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/restoreDomainAccess",
	}

	if input == nil {
		input = &RestoreDomainAccessInput{}
	}

	output = &RestoreDomainAccessOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RestoreDomainAccess API operation for Amazon WorkLink.
//
// Moves a domain to ACTIVE status if it was in the INACTIVE status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation RestoreDomainAccess for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RestoreDomainAccess
func (c *WorkLink) RestoreDomainAccess(input *RestoreDomainAccessInput) (*RestoreDomainAccessOutput, error) {
	req, out := c.RestoreDomainAccessRequest(input)
	return out, req.Send()
}

// RestoreDomainAccessWithContext is the same as RestoreDomainAccess with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreDomainAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) RestoreDomainAccessWithContext(ctx aws.Context, input *RestoreDomainAccessInput, opts ...request.Option) (*RestoreDomainAccessOutput, error) {
	req, out := c.RestoreDomainAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeDomainAccess = "RevokeDomainAccess"

// RevokeDomainAccessRequest generates a "aws/request.Request" representing the
// client's request for the RevokeDomainAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeDomainAccess for more information on using the RevokeDomainAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeDomainAccessRequest method.
//    req, resp := client.RevokeDomainAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RevokeDomainAccess
func (c *WorkLink) RevokeDomainAccessRequest(input *RevokeDomainAccessInput) (req *request.Request, output *RevokeDomainAccessOutput) {
	op := &request.Operation{
		Name:       opRevokeDomainAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/revokeDomainAccess",
	}

	if input == nil {
		input = &RevokeDomainAccessInput{}
	}

	output = &RevokeDomainAccessOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeDomainAccess API operation for Amazon WorkLink.
//
// Moves a domain to INACTIVE status if it was in the ACTIVE status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation RevokeDomainAccess for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RevokeDomainAccess
func (c *WorkLink) RevokeDomainAccess(input *RevokeDomainAccessInput) (*RevokeDomainAccessOutput, error) {
	req, out := c.RevokeDomainAccessRequest(input)
	return out, req.Send()
}

// RevokeDomainAccessWithContext is the same as RevokeDomainAccess with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeDomainAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) RevokeDomainAccessWithContext(ctx aws.Context, input *RevokeDomainAccessInput, opts ...request.Option) (*RevokeDomainAccessOutput, error) {
	req, out := c.RevokeDomainAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSignOutUser = "SignOutUser"

// SignOutUserRequest generates a "aws/request.Request" representing the
// client's request for the SignOutUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SignOutUser for more information on using the SignOutUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SignOutUserRequest method.
//    req, resp := client.SignOutUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/SignOutUser
func (c *WorkLink) SignOutUserRequest(input *SignOutUserInput) (req *request.Request, output *SignOutUserOutput) {
	op := &request.Operation{
		Name:       opSignOutUser,
		HTTPMethod: "POST",
		HTTPPath:   "/signOutUser",
	}

	if input == nil {
		input = &SignOutUserInput{}
	}

	output = &SignOutUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SignOutUser API operation for Amazon WorkLink.
//
// Signs the user out from all of their devices. The user can sign in again
// if they have valid credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation SignOutUser for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/SignOutUser
func (c *WorkLink) SignOutUser(input *SignOutUserInput) (*SignOutUserOutput, error) {
	req, out := c.SignOutUserRequest(input)
	return out, req.Send()
}

// SignOutUserWithContext is the same as SignOutUser with the addition of
// the ability to pass a context and additional request options.
//
// See SignOutUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) SignOutUserWithContext(ctx aws.Context, input *SignOutUserInput, opts ...request.Option) (*SignOutUserOutput, error) {
	req, out := c.SignOutUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/TagResource
func (c *WorkLink) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon WorkLink.
//
// Adds or overwrites one or more tags for the specified resource, such as a
// fleet. Each tag consists of a key and an optional value. If a resource already
// has a tag with the same key, this operation updates its value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/TagResource
func (c *WorkLink) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UntagResource
func (c *WorkLink) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon WorkLink.
//
// Removes one or more tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UntagResource
func (c *WorkLink) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAuditStreamConfiguration = "UpdateAuditStreamConfiguration"

// UpdateAuditStreamConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAuditStreamConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAuditStreamConfiguration for more information on using the UpdateAuditStreamConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAuditStreamConfigurationRequest method.
//    req, resp := client.UpdateAuditStreamConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateAuditStreamConfiguration
func (c *WorkLink) UpdateAuditStreamConfigurationRequest(input *UpdateAuditStreamConfigurationInput) (req *request.Request, output *UpdateAuditStreamConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateAuditStreamConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/updateAuditStreamConfiguration",
	}

	if input == nil {
		input = &UpdateAuditStreamConfigurationInput{}
	}

	output = &UpdateAuditStreamConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAuditStreamConfiguration API operation for Amazon WorkLink.
//
// Updates the audit stream configuration for the fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation UpdateAuditStreamConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateAuditStreamConfiguration
func (c *WorkLink) UpdateAuditStreamConfiguration(input *UpdateAuditStreamConfigurationInput) (*UpdateAuditStreamConfigurationOutput, error) {
	req, out := c.UpdateAuditStreamConfigurationRequest(input)
	return out, req.Send()
}

// UpdateAuditStreamConfigurationWithContext is the same as UpdateAuditStreamConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAuditStreamConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) UpdateAuditStreamConfigurationWithContext(ctx aws.Context, input *UpdateAuditStreamConfigurationInput, opts ...request.Option) (*UpdateAuditStreamConfigurationOutput, error) {
	req, out := c.UpdateAuditStreamConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCompanyNetworkConfiguration = "UpdateCompanyNetworkConfiguration"

// UpdateCompanyNetworkConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCompanyNetworkConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCompanyNetworkConfiguration for more information on using the UpdateCompanyNetworkConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCompanyNetworkConfigurationRequest method.
//    req, resp := client.UpdateCompanyNetworkConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateCompanyNetworkConfiguration
func (c *WorkLink) UpdateCompanyNetworkConfigurationRequest(input *UpdateCompanyNetworkConfigurationInput) (req *request.Request, output *UpdateCompanyNetworkConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateCompanyNetworkConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/updateCompanyNetworkConfiguration",
	}

	if input == nil {
		input = &UpdateCompanyNetworkConfigurationInput{}
	}

	output = &UpdateCompanyNetworkConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCompanyNetworkConfiguration API operation for Amazon WorkLink.
//
// Updates the company network configuration for the fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation UpdateCompanyNetworkConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateCompanyNetworkConfiguration
func (c *WorkLink) UpdateCompanyNetworkConfiguration(input *UpdateCompanyNetworkConfigurationInput) (*UpdateCompanyNetworkConfigurationOutput, error) {
	req, out := c.UpdateCompanyNetworkConfigurationRequest(input)
	return out, req.Send()
}

// UpdateCompanyNetworkConfigurationWithContext is the same as UpdateCompanyNetworkConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCompanyNetworkConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) UpdateCompanyNetworkConfigurationWithContext(ctx aws.Context, input *UpdateCompanyNetworkConfigurationInput, opts ...request.Option) (*UpdateCompanyNetworkConfigurationOutput, error) {
	req, out := c.UpdateCompanyNetworkConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDevicePolicyConfiguration = "UpdateDevicePolicyConfiguration"

// UpdateDevicePolicyConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDevicePolicyConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDevicePolicyConfiguration for more information on using the UpdateDevicePolicyConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDevicePolicyConfigurationRequest method.
//    req, resp := client.UpdateDevicePolicyConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDevicePolicyConfiguration
func (c *WorkLink) UpdateDevicePolicyConfigurationRequest(input *UpdateDevicePolicyConfigurationInput) (req *request.Request, output *UpdateDevicePolicyConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateDevicePolicyConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/updateDevicePolicyConfiguration",
	}

	if input == nil {
		input = &UpdateDevicePolicyConfigurationInput{}
	}

	output = &UpdateDevicePolicyConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDevicePolicyConfiguration API operation for Amazon WorkLink.
//
// Updates the device policy configuration for the fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation UpdateDevicePolicyConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDevicePolicyConfiguration
func (c *WorkLink) UpdateDevicePolicyConfiguration(input *UpdateDevicePolicyConfigurationInput) (*UpdateDevicePolicyConfigurationOutput, error) {
	req, out := c.UpdateDevicePolicyConfigurationRequest(input)
	return out, req.Send()
}

// UpdateDevicePolicyConfigurationWithContext is the same as UpdateDevicePolicyConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDevicePolicyConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) UpdateDevicePolicyConfigurationWithContext(ctx aws.Context, input *UpdateDevicePolicyConfigurationInput, opts ...request.Option) (*UpdateDevicePolicyConfigurationOutput, error) {
	req, out := c.UpdateDevicePolicyConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomainMetadata = "UpdateDomainMetadata"

// UpdateDomainMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomainMetadata for more information on using the UpdateDomainMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainMetadataRequest method.
//    req, resp := client.UpdateDomainMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDomainMetadata
func (c *WorkLink) UpdateDomainMetadataRequest(input *UpdateDomainMetadataInput) (req *request.Request, output *UpdateDomainMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/updateDomainMetadata",
	}

	if input == nil {
		input = &UpdateDomainMetadataInput{}
	}

	output = &UpdateDomainMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDomainMetadata API operation for Amazon WorkLink.
//
// Updates domain metadata, such as DisplayName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation UpdateDomainMetadata for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDomainMetadata
func (c *WorkLink) UpdateDomainMetadata(input *UpdateDomainMetadataInput) (*UpdateDomainMetadataOutput, error) {
	req, out := c.UpdateDomainMetadataRequest(input)
	return out, req.Send()
}

// UpdateDomainMetadataWithContext is the same as UpdateDomainMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomainMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) UpdateDomainMetadataWithContext(ctx aws.Context, input *UpdateDomainMetadataInput, opts ...request.Option) (*UpdateDomainMetadataOutput, error) {
	req, out := c.UpdateDomainMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleetMetadata = "UpdateFleetMetadata"

// UpdateFleetMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleetMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleetMetadata for more information on using the UpdateFleetMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFleetMetadataRequest method.
//    req, resp := client.UpdateFleetMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateFleetMetadata
func (c *WorkLink) UpdateFleetMetadataRequest(input *UpdateFleetMetadataInput) (req *request.Request, output *UpdateFleetMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateFleetMetadata",
	}

	if input == nil {
		input = &UpdateFleetMetadataInput{}
	}

	output = &UpdateFleetMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateFleetMetadata API operation for Amazon WorkLink.
//
// Updates fleet metadata, such as DisplayName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation UpdateFleetMetadata for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateFleetMetadata
func (c *WorkLink) UpdateFleetMetadata(input *UpdateFleetMetadataInput) (*UpdateFleetMetadataOutput, error) {
	req, out := c.UpdateFleetMetadataRequest(input)
	return out, req.Send()
}

// UpdateFleetMetadataWithContext is the same as UpdateFleetMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleetMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) UpdateFleetMetadataWithContext(ctx aws.Context, input *UpdateFleetMetadataInput, opts ...request.Option) (*UpdateFleetMetadataOutput, error) {
	req, out := c.UpdateFleetMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIdentityProviderConfiguration = "UpdateIdentityProviderConfiguration"

// UpdateIdentityProviderConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIdentityProviderConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIdentityProviderConfiguration for more information on using the UpdateIdentityProviderConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIdentityProviderConfigurationRequest method.
//    req, resp := client.UpdateIdentityProviderConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateIdentityProviderConfiguration
func (c *WorkLink) UpdateIdentityProviderConfigurationRequest(input *UpdateIdentityProviderConfigurationInput) (req *request.Request, output *UpdateIdentityProviderConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateIdentityProviderConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/updateIdentityProviderConfiguration",
	}

	if input == nil {
		input = &UpdateIdentityProviderConfigurationInput{}
	}

	output = &UpdateIdentityProviderConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateIdentityProviderConfiguration API operation for Amazon WorkLink.
//
// Updates the identity provider configuration for the fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkLink's
// API operation UpdateIdentityProviderConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   You are not authorized to perform this action.
//
//   * InternalServerErrorException
//   The service is temporarily unavailable.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * ResourceNotFoundException
//   The requested resource was not found.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateIdentityProviderConfiguration
func (c *WorkLink) UpdateIdentityProviderConfiguration(input *UpdateIdentityProviderConfigurationInput) (*UpdateIdentityProviderConfigurationOutput, error) {
	req, out := c.UpdateIdentityProviderConfigurationRequest(input)
	return out, req.Send()
}

// UpdateIdentityProviderConfigurationWithContext is the same as UpdateIdentityProviderConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIdentityProviderConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkLink) UpdateIdentityProviderConfigurationWithContext(ctx aws.Context, input *UpdateIdentityProviderConfigurationInput, opts ...request.Option) (*UpdateIdentityProviderConfigurationOutput, error) {
	req, out := c.UpdateIdentityProviderConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateDomainInput struct {
	_ struct{} `type:"structure"`

	// The ARN of an issued ACM certificate that is valid for the domain being associated.
	//
	// AcmCertificateArn is a required field
	AcmCertificateArn *string `type:"string" required:"true"`

	// The name to display.
	DisplayName *string `type:"string"`

	// The fully qualified domain name (FQDN).
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateDomainInput"}
	if s.AcmCertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AcmCertificateArn"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcmCertificateArn sets the AcmCertificateArn field's value.
func (s *AssociateDomainInput) SetAcmCertificateArn(v string) *AssociateDomainInput {
	s.AcmCertificateArn = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *AssociateDomainInput) SetDisplayName(v string) *AssociateDomainInput {
	s.DisplayName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AssociateDomainInput) SetDomainName(v string) *AssociateDomainInput {
	s.DomainName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *AssociateDomainInput) SetFleetArn(v string) *AssociateDomainInput {
	s.FleetArn = &v
	return s
}

type AssociateDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDomainOutput) GoString() string {
	return s.String()
}

type AssociateWebsiteAuthorizationProviderInput struct {
	_ struct{} `type:"structure"`

	// The authorization provider type.
	//
	// AuthorizationProviderType is a required field
	AuthorizationProviderType *string `type:"string" required:"true" enum:"AuthorizationProviderType"`

	// The domain name of the authorization provider. This applies only to SAML-based
	// authorization providers.
	DomainName *string `min:"1" type:"string"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateWebsiteAuthorizationProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWebsiteAuthorizationProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateWebsiteAuthorizationProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateWebsiteAuthorizationProviderInput"}
	if s.AuthorizationProviderType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizationProviderType"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationProviderType sets the AuthorizationProviderType field's value.
func (s *AssociateWebsiteAuthorizationProviderInput) SetAuthorizationProviderType(v string) *AssociateWebsiteAuthorizationProviderInput {
	s.AuthorizationProviderType = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *AssociateWebsiteAuthorizationProviderInput) SetDomainName(v string) *AssociateWebsiteAuthorizationProviderInput {
	s.DomainName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *AssociateWebsiteAuthorizationProviderInput) SetFleetArn(v string) *AssociateWebsiteAuthorizationProviderInput {
	s.FleetArn = &v
	return s
}

type AssociateWebsiteAuthorizationProviderOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the authorization provider.
	AuthorizationProviderId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AssociateWebsiteAuthorizationProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWebsiteAuthorizationProviderOutput) GoString() string {
	return s.String()
}

// SetAuthorizationProviderId sets the AuthorizationProviderId field's value.
func (s *AssociateWebsiteAuthorizationProviderOutput) SetAuthorizationProviderId(v string) *AssociateWebsiteAuthorizationProviderOutput {
	s.AuthorizationProviderId = &v
	return s
}

type AssociateWebsiteCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The root certificate of the CA.
	//
	// Certificate is a required field
	Certificate *string `min:"1" type:"string" required:"true"`

	// The certificate name to display.
	DisplayName *string `type:"string"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateWebsiteCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWebsiteCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateWebsiteCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateWebsiteCertificateAuthorityInput"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.Certificate != nil && len(*s.Certificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Certificate", 1))
	}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *AssociateWebsiteCertificateAuthorityInput) SetCertificate(v string) *AssociateWebsiteCertificateAuthorityInput {
	s.Certificate = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *AssociateWebsiteCertificateAuthorityInput) SetDisplayName(v string) *AssociateWebsiteCertificateAuthorityInput {
	s.DisplayName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *AssociateWebsiteCertificateAuthorityInput) SetFleetArn(v string) *AssociateWebsiteCertificateAuthorityInput {
	s.FleetArn = &v
	return s
}

type AssociateWebsiteCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the CA.
	WebsiteCaId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AssociateWebsiteCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWebsiteCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// SetWebsiteCaId sets the WebsiteCaId field's value.
func (s *AssociateWebsiteCertificateAuthorityOutput) SetWebsiteCaId(v string) *AssociateWebsiteCertificateAuthorityOutput {
	s.WebsiteCaId = &v
	return s
}

type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// The fleet name to display.
	DisplayName *string `type:"string"`

	// A unique name for the fleet.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The option to optimize for better performance by routing traffic through
	// the closest AWS Region to users, which may be outside of your home Region.
	OptimizeForEndUserLocation *bool `type:"boolean"`

	// The tags to add to the resource. A tag is a key-value pair.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateFleetInput) SetDisplayName(v string) *CreateFleetInput {
	s.DisplayName = &v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *CreateFleetInput) SetFleetName(v string) *CreateFleetInput {
	s.FleetName = &v
	return s
}

// SetOptimizeForEndUserLocation sets the OptimizeForEndUserLocation field's value.
func (s *CreateFleetInput) SetOptimizeForEndUserLocation(v bool) *CreateFleetInput {
	s.OptimizeForEndUserLocation = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFleetInput) SetTags(v map[string]*string) *CreateFleetInput {
	s.Tags = v
	return s
}

type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	FleetArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetOutput) GoString() string {
	return s.String()
}

// SetFleetArn sets the FleetArn field's value.
func (s *CreateFleetOutput) SetFleetArn(v string) *CreateFleetOutput {
	s.FleetArn = &v
	return s
}

type DeleteFleetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *DeleteFleetInput) SetFleetArn(v string) *DeleteFleetInput {
	s.FleetArn = &v
	return s
}

type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetOutput) GoString() string {
	return s.String()
}

type DescribeAuditStreamConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAuditStreamConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuditStreamConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAuditStreamConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAuditStreamConfigurationInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *DescribeAuditStreamConfigurationInput) SetFleetArn(v string) *DescribeAuditStreamConfigurationInput {
	s.FleetArn = &v
	return s
}

type DescribeAuditStreamConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Kinesis data stream that will receive the audit events.
	AuditStreamArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeAuditStreamConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAuditStreamConfigurationOutput) GoString() string {
	return s.String()
}

// SetAuditStreamArn sets the AuditStreamArn field's value.
func (s *DescribeAuditStreamConfigurationOutput) SetAuditStreamArn(v string) *DescribeAuditStreamConfigurationOutput {
	s.AuditStreamArn = &v
	return s
}

type DescribeCompanyNetworkConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCompanyNetworkConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCompanyNetworkConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCompanyNetworkConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCompanyNetworkConfigurationInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *DescribeCompanyNetworkConfigurationInput) SetFleetArn(v string) *DescribeCompanyNetworkConfigurationInput {
	s.FleetArn = &v
	return s
}

type DescribeCompanyNetworkConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The security groups associated with access to the provided subnets.
	SecurityGroupIds []*string `type:"list"`

	// The subnets used for X-ENI connections from Amazon WorkLink rendering containers.
	SubnetIds []*string `type:"list"`

	// The VPC with connectivity to associated websites.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DescribeCompanyNetworkConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCompanyNetworkConfigurationOutput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *DescribeCompanyNetworkConfigurationOutput) SetSecurityGroupIds(v []*string) *DescribeCompanyNetworkConfigurationOutput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *DescribeCompanyNetworkConfigurationOutput) SetSubnetIds(v []*string) *DescribeCompanyNetworkConfigurationOutput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DescribeCompanyNetworkConfigurationOutput) SetVpcId(v string) *DescribeCompanyNetworkConfigurationOutput {
	s.VpcId = &v
	return s
}

type DescribeDeviceInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a registered user's device.
	//
	// DeviceId is a required field
	DeviceId *string `min:"1" type:"string" required:"true"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDeviceInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *DescribeDeviceInput) SetDeviceId(v string) *DescribeDeviceInput {
	s.DeviceId = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *DescribeDeviceInput) SetFleetArn(v string) *DescribeDeviceInput {
	s.FleetArn = &v
	return s
}

type DescribeDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The date that the device first signed in to Amazon WorkLink.
	FirstAccessedTime *time.Time `type:"timestamp"`

	// The date that the device last accessed Amazon WorkLink.
	LastAccessedTime *time.Time `type:"timestamp"`

	// The manufacturer of the device.
	Manufacturer *string `min:"1" type:"string"`

	// The model of the device.
	Model *string `min:"1" type:"string"`

	// The operating system of the device.
	OperatingSystem *string `min:"1" type:"string"`

	// The operating system version of the device.
	OperatingSystemVersion *string `min:"1" type:"string"`

	// The operating system patch level of the device.
	PatchLevel *string `min:"1" type:"string"`

	// The current state of the device.
	Status *string `type:"string" enum:"DeviceStatus"`

	// The user name associated with the device.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeviceOutput) GoString() string {
	return s.String()
}

// SetFirstAccessedTime sets the FirstAccessedTime field's value.
func (s *DescribeDeviceOutput) SetFirstAccessedTime(v time.Time) *DescribeDeviceOutput {
	s.FirstAccessedTime = &v
	return s
}

// SetLastAccessedTime sets the LastAccessedTime field's value.
func (s *DescribeDeviceOutput) SetLastAccessedTime(v time.Time) *DescribeDeviceOutput {
	s.LastAccessedTime = &v
	return s
}

// SetManufacturer sets the Manufacturer field's value.
func (s *DescribeDeviceOutput) SetManufacturer(v string) *DescribeDeviceOutput {
	s.Manufacturer = &v
	return s
}

// SetModel sets the Model field's value.
func (s *DescribeDeviceOutput) SetModel(v string) *DescribeDeviceOutput {
	s.Model = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *DescribeDeviceOutput) SetOperatingSystem(v string) *DescribeDeviceOutput {
	s.OperatingSystem = &v
	return s
}

// SetOperatingSystemVersion sets the OperatingSystemVersion field's value.
func (s *DescribeDeviceOutput) SetOperatingSystemVersion(v string) *DescribeDeviceOutput {
	s.OperatingSystemVersion = &v
	return s
}

// SetPatchLevel sets the PatchLevel field's value.
func (s *DescribeDeviceOutput) SetPatchLevel(v string) *DescribeDeviceOutput {
	s.PatchLevel = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDeviceOutput) SetStatus(v string) *DescribeDeviceOutput {
	s.Status = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *DescribeDeviceOutput) SetUsername(v string) *DescribeDeviceOutput {
	s.Username = &v
	return s
}

type DescribeDevicePolicyConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDevicePolicyConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDevicePolicyConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDevicePolicyConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDevicePolicyConfigurationInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *DescribeDevicePolicyConfigurationInput) SetFleetArn(v string) *DescribeDevicePolicyConfigurationInput {
	s.FleetArn = &v
	return s
}

type DescribeDevicePolicyConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The certificate chain, including intermediate certificates and the root certificate
	// authority certificate used to issue device certificates.
	DeviceCaCertificate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDevicePolicyConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDevicePolicyConfigurationOutput) GoString() string {
	return s.String()
}

// SetDeviceCaCertificate sets the DeviceCaCertificate field's value.
func (s *DescribeDevicePolicyConfigurationOutput) SetDeviceCaCertificate(v string) *DescribeDevicePolicyConfigurationOutput {
	s.DeviceCaCertificate = &v
	return s
}

type DescribeDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainInput) SetDomainName(v string) *DescribeDomainInput {
	s.DomainName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *DescribeDomainInput) SetFleetArn(v string) *DescribeDomainInput {
	s.FleetArn = &v
	return s
}

type DescribeDomainOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of an issued ACM certificate that is valid for the domain being associated.
	AcmCertificateArn *string `type:"string"`

	// The time that the domain was added.
	CreatedTime *time.Time `type:"timestamp"`

	// The name to display.
	DisplayName *string `type:"string"`

	// The name of the domain.
	DomainName *string `min:"1" type:"string"`

	// The current state for the domain.
	DomainStatus *string `type:"string" enum:"DomainStatus"`
}

// String returns the string representation
func (s DescribeDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainOutput) GoString() string {
	return s.String()
}

// SetAcmCertificateArn sets the AcmCertificateArn field's value.
func (s *DescribeDomainOutput) SetAcmCertificateArn(v string) *DescribeDomainOutput {
	s.AcmCertificateArn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DescribeDomainOutput) SetCreatedTime(v time.Time) *DescribeDomainOutput {
	s.CreatedTime = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeDomainOutput) SetDisplayName(v string) *DescribeDomainOutput {
	s.DisplayName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeDomainOutput) SetDomainName(v string) *DescribeDomainOutput {
	s.DomainName = &v
	return s
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DescribeDomainOutput) SetDomainStatus(v string) *DescribeDomainOutput {
	s.DomainStatus = &v
	return s
}

type DescribeFleetMetadataInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFleetMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetMetadataInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *DescribeFleetMetadataInput) SetFleetArn(v string) *DescribeFleetMetadataInput {
	s.FleetArn = &v
	return s
}

type DescribeFleetMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The identifier used by users to sign in to the Amazon WorkLink app.
	CompanyCode *string `min:"1" type:"string"`

	// The time that the fleet was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The name to display.
	DisplayName *string `type:"string"`

	// The name of the fleet.
	FleetName *string `min:"1" type:"string"`

	// The current state of the fleet.
	FleetStatus *string `type:"string" enum:"FleetStatus"`

	// The time that the fleet was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The option to optimize for better performance by routing traffic through
	// the closest AWS Region to users, which may be outside of your home Region.
	OptimizeForEndUserLocation *bool `type:"boolean"`

	// The tags attached to the resource. A tag is a key-value pair.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s DescribeFleetMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetMetadataOutput) GoString() string {
	return s.String()
}

// SetCompanyCode sets the CompanyCode field's value.
func (s *DescribeFleetMetadataOutput) SetCompanyCode(v string) *DescribeFleetMetadataOutput {
	s.CompanyCode = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DescribeFleetMetadataOutput) SetCreatedTime(v time.Time) *DescribeFleetMetadataOutput {
	s.CreatedTime = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeFleetMetadataOutput) SetDisplayName(v string) *DescribeFleetMetadataOutput {
	s.DisplayName = &v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *DescribeFleetMetadataOutput) SetFleetName(v string) *DescribeFleetMetadataOutput {
	s.FleetName = &v
	return s
}

// SetFleetStatus sets the FleetStatus field's value.
func (s *DescribeFleetMetadataOutput) SetFleetStatus(v string) *DescribeFleetMetadataOutput {
	s.FleetStatus = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DescribeFleetMetadataOutput) SetLastUpdatedTime(v time.Time) *DescribeFleetMetadataOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetOptimizeForEndUserLocation sets the OptimizeForEndUserLocation field's value.
func (s *DescribeFleetMetadataOutput) SetOptimizeForEndUserLocation(v bool) *DescribeFleetMetadataOutput {
	s.OptimizeForEndUserLocation = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeFleetMetadataOutput) SetTags(v map[string]*string) *DescribeFleetMetadataOutput {
	s.Tags = v
	return s
}

type DescribeIdentityProviderConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityProviderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityProviderConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityProviderConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityProviderConfigurationInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *DescribeIdentityProviderConfigurationInput) SetFleetArn(v string) *DescribeIdentityProviderConfigurationInput {
	s.FleetArn = &v
	return s
}

type DescribeIdentityProviderConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The SAML metadata document provided by the user’s identity provider.
	IdentityProviderSamlMetadata *string `min:"1" type:"string"`

	// The type of identity provider.
	IdentityProviderType *string `type:"string" enum:"IdentityProviderType"`

	// The SAML metadata document uploaded to the user’s identity provider.
	ServiceProviderSamlMetadata *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeIdentityProviderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityProviderConfigurationOutput) GoString() string {
	return s.String()
}

// SetIdentityProviderSamlMetadata sets the IdentityProviderSamlMetadata field's value.
func (s *DescribeIdentityProviderConfigurationOutput) SetIdentityProviderSamlMetadata(v string) *DescribeIdentityProviderConfigurationOutput {
	s.IdentityProviderSamlMetadata = &v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *DescribeIdentityProviderConfigurationOutput) SetIdentityProviderType(v string) *DescribeIdentityProviderConfigurationOutput {
	s.IdentityProviderType = &v
	return s
}

// SetServiceProviderSamlMetadata sets the ServiceProviderSamlMetadata field's value.
func (s *DescribeIdentityProviderConfigurationOutput) SetServiceProviderSamlMetadata(v string) *DescribeIdentityProviderConfigurationOutput {
	s.ServiceProviderSamlMetadata = &v
	return s
}

type DescribeWebsiteCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// A unique identifier for the certificate authority.
	//
	// WebsiteCaId is a required field
	WebsiteCaId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeWebsiteCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWebsiteCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWebsiteCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWebsiteCertificateAuthorityInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}
	if s.WebsiteCaId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebsiteCaId"))
	}
	if s.WebsiteCaId != nil && len(*s.WebsiteCaId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebsiteCaId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *DescribeWebsiteCertificateAuthorityInput) SetFleetArn(v string) *DescribeWebsiteCertificateAuthorityInput {
	s.FleetArn = &v
	return s
}

// SetWebsiteCaId sets the WebsiteCaId field's value.
func (s *DescribeWebsiteCertificateAuthorityInput) SetWebsiteCaId(v string) *DescribeWebsiteCertificateAuthorityInput {
	s.WebsiteCaId = &v
	return s
}

type DescribeWebsiteCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`

	// The root certificate of the certificate authority.
	Certificate *string `min:"1" type:"string"`

	// The time that the certificate authority was added.
	CreatedTime *time.Time `type:"timestamp"`

	// The certificate name to display.
	DisplayName *string `type:"string"`
}

// String returns the string representation
func (s DescribeWebsiteCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWebsiteCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *DescribeWebsiteCertificateAuthorityOutput) SetCertificate(v string) *DescribeWebsiteCertificateAuthorityOutput {
	s.Certificate = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DescribeWebsiteCertificateAuthorityOutput) SetCreatedTime(v time.Time) *DescribeWebsiteCertificateAuthorityOutput {
	s.CreatedTime = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeWebsiteCertificateAuthorityOutput) SetDisplayName(v string) *DescribeWebsiteCertificateAuthorityOutput {
	s.DisplayName = &v
	return s
}

// The summary of devices.
type DeviceSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the device.
	DeviceId *string `min:"1" type:"string"`

	// The status of the device.
	DeviceStatus *string `type:"string" enum:"DeviceStatus"`
}

// String returns the string representation
func (s DeviceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceSummary) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *DeviceSummary) SetDeviceId(v string) *DeviceSummary {
	s.DeviceId = &v
	return s
}

// SetDeviceStatus sets the DeviceStatus field's value.
func (s *DeviceSummary) SetDeviceStatus(v string) *DeviceSummary {
	s.DeviceStatus = &v
	return s
}

type DisassociateDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DisassociateDomainInput) SetDomainName(v string) *DisassociateDomainInput {
	s.DomainName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *DisassociateDomainInput) SetFleetArn(v string) *DisassociateDomainInput {
	s.FleetArn = &v
	return s
}

type DisassociateDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDomainOutput) GoString() string {
	return s.String()
}

type DisassociateWebsiteAuthorizationProviderInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the authorization provider.
	//
	// AuthorizationProviderId is a required field
	AuthorizationProviderId *string `min:"1" type:"string" required:"true"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateWebsiteAuthorizationProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWebsiteAuthorizationProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateWebsiteAuthorizationProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateWebsiteAuthorizationProviderInput"}
	if s.AuthorizationProviderId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizationProviderId"))
	}
	if s.AuthorizationProviderId != nil && len(*s.AuthorizationProviderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizationProviderId", 1))
	}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationProviderId sets the AuthorizationProviderId field's value.
func (s *DisassociateWebsiteAuthorizationProviderInput) SetAuthorizationProviderId(v string) *DisassociateWebsiteAuthorizationProviderInput {
	s.AuthorizationProviderId = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *DisassociateWebsiteAuthorizationProviderInput) SetFleetArn(v string) *DisassociateWebsiteAuthorizationProviderInput {
	s.FleetArn = &v
	return s
}

type DisassociateWebsiteAuthorizationProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateWebsiteAuthorizationProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWebsiteAuthorizationProviderOutput) GoString() string {
	return s.String()
}

type DisassociateWebsiteCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// A unique identifier for the CA.
	//
	// WebsiteCaId is a required field
	WebsiteCaId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateWebsiteCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWebsiteCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateWebsiteCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateWebsiteCertificateAuthorityInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}
	if s.WebsiteCaId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebsiteCaId"))
	}
	if s.WebsiteCaId != nil && len(*s.WebsiteCaId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebsiteCaId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *DisassociateWebsiteCertificateAuthorityInput) SetFleetArn(v string) *DisassociateWebsiteCertificateAuthorityInput {
	s.FleetArn = &v
	return s
}

// SetWebsiteCaId sets the WebsiteCaId field's value.
func (s *DisassociateWebsiteCertificateAuthorityInput) SetWebsiteCaId(v string) *DisassociateWebsiteCertificateAuthorityInput {
	s.WebsiteCaId = &v
	return s
}

type DisassociateWebsiteCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateWebsiteCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWebsiteCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// The summary of the domain.
type DomainSummary struct {
	_ struct{} `type:"structure"`

	// The time that the domain was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// The name to display.
	DisplayName *string `type:"string"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The status of the domain.
	//
	// DomainStatus is a required field
	DomainStatus *string `type:"string" required:"true" enum:"DomainStatus"`
}

// String returns the string representation
func (s DomainSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainSummary) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DomainSummary) SetCreatedTime(v time.Time) *DomainSummary {
	s.CreatedTime = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DomainSummary) SetDisplayName(v string) *DomainSummary {
	s.DisplayName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DomainSummary) SetDomainName(v string) *DomainSummary {
	s.DomainName = &v
	return s
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DomainSummary) SetDomainStatus(v string) *DomainSummary {
	s.DomainStatus = &v
	return s
}

// The summary of the fleet.
type FleetSummary struct {
	_ struct{} `type:"structure"`

	// The identifier used by users to sign into the Amazon WorkLink app.
	CompanyCode *string `min:"1" type:"string"`

	// The time when the fleet was created.
	CreatedTime *time.Time `type:"timestamp"`

	// The name of the fleet to display.
	DisplayName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the fleet.
	FleetArn *string `min:"20" type:"string"`

	// The name of the fleet.
	FleetName *string `min:"1" type:"string"`

	// The status of the fleet.
	FleetStatus *string `type:"string" enum:"FleetStatus"`

	// The time when the fleet was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The tags attached to the resource. A tag is a key-value pair.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s FleetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetSummary) GoString() string {
	return s.String()
}

// SetCompanyCode sets the CompanyCode field's value.
func (s *FleetSummary) SetCompanyCode(v string) *FleetSummary {
	s.CompanyCode = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *FleetSummary) SetCreatedTime(v time.Time) *FleetSummary {
	s.CreatedTime = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *FleetSummary) SetDisplayName(v string) *FleetSummary {
	s.DisplayName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *FleetSummary) SetFleetArn(v string) *FleetSummary {
	s.FleetArn = &v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *FleetSummary) SetFleetName(v string) *FleetSummary {
	s.FleetName = &v
	return s
}

// SetFleetStatus sets the FleetStatus field's value.
func (s *FleetSummary) SetFleetStatus(v string) *FleetSummary {
	s.FleetStatus = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *FleetSummary) SetLastUpdatedTime(v time.Time) *FleetSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *FleetSummary) SetTags(v map[string]*string) *FleetSummary {
	s.Tags = v
	return s
}

// The service is temporarily unavailable.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is not valid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDevicesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	// If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicesInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *ListDevicesInput) SetFleetArn(v string) *ListDevicesInput {
	s.FleetArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDevicesInput) SetMaxResults(v int64) *ListDevicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesInput) SetNextToken(v string) *ListDevicesInput {
	s.NextToken = &v
	return s
}

type ListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the devices.
	Devices []*DeviceSummary `type:"list"`

	// The pagination token used to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *ListDevicesOutput) SetDevices(v []*DeviceSummary) *ListDevicesOutput {
	s.Devices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesOutput) SetNextToken(v string) *ListDevicesOutput {
	s.NextToken = &v
	return s
}

type ListDomainsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	// If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainsInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *ListDomainsInput) SetFleetArn(v string) *ListDomainsInput {
	s.FleetArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainsInput) SetMaxResults(v int64) *ListDomainsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsInput) SetNextToken(v string) *ListDomainsInput {
	s.NextToken = &v
	return s
}

type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the domains.
	Domains []*DomainSummary `type:"list"`

	// The pagination token used to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

// SetDomains sets the Domains field's value.
func (s *ListDomainsOutput) SetDomains(v []*DomainSummary) *ListDomainsOutput {
	s.Domains = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsOutput) SetNextToken(v string) *ListDomainsOutput {
	s.NextToken = &v
	return s
}

type ListFleetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	// If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFleetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFleetsInput) SetMaxResults(v int64) *ListFleetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsInput) SetNextToken(v string) *ListFleetsInput {
	s.NextToken = &v
	return s
}

type ListFleetsOutput struct {
	_ struct{} `type:"structure"`

	// The summary list of the fleets.
	FleetSummaryList []*FleetSummary `type:"list"`

	// The pagination token used to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFleetsOutput) GoString() string {
	return s.String()
}

// SetFleetSummaryList sets the FleetSummaryList field's value.
func (s *ListFleetsOutput) SetFleetSummaryList(v []*FleetSummary) *ListFleetsOutput {
	s.FleetSummaryList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsOutput) SetNextToken(v string) *ListFleetsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags attached to the resource. A tag is a key-value pair.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListWebsiteAuthorizationProvidersInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListWebsiteAuthorizationProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWebsiteAuthorizationProvidersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWebsiteAuthorizationProvidersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWebsiteAuthorizationProvidersInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *ListWebsiteAuthorizationProvidersInput) SetFleetArn(v string) *ListWebsiteAuthorizationProvidersInput {
	s.FleetArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWebsiteAuthorizationProvidersInput) SetMaxResults(v int64) *ListWebsiteAuthorizationProvidersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWebsiteAuthorizationProvidersInput) SetNextToken(v string) *ListWebsiteAuthorizationProvidersInput {
	s.NextToken = &v
	return s
}

type ListWebsiteAuthorizationProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The website authorization providers.
	WebsiteAuthorizationProviders []*WebsiteAuthorizationProviderSummary `type:"list"`
}

// String returns the string representation
func (s ListWebsiteAuthorizationProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWebsiteAuthorizationProvidersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWebsiteAuthorizationProvidersOutput) SetNextToken(v string) *ListWebsiteAuthorizationProvidersOutput {
	s.NextToken = &v
	return s
}

// SetWebsiteAuthorizationProviders sets the WebsiteAuthorizationProviders field's value.
func (s *ListWebsiteAuthorizationProvidersOutput) SetWebsiteAuthorizationProviders(v []*WebsiteAuthorizationProviderSummary) *ListWebsiteAuthorizationProvidersOutput {
	s.WebsiteAuthorizationProviders = v
	return s
}

type ListWebsiteCertificateAuthoritiesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// The maximum number of results to be included in the next page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token used to retrieve the next page of results for this operation.
	// If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListWebsiteCertificateAuthoritiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWebsiteCertificateAuthoritiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWebsiteCertificateAuthoritiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWebsiteCertificateAuthoritiesInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *ListWebsiteCertificateAuthoritiesInput) SetFleetArn(v string) *ListWebsiteCertificateAuthoritiesInput {
	s.FleetArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWebsiteCertificateAuthoritiesInput) SetMaxResults(v int64) *ListWebsiteCertificateAuthoritiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWebsiteCertificateAuthoritiesInput) SetNextToken(v string) *ListWebsiteCertificateAuthoritiesInput {
	s.NextToken = &v
	return s
}

type ListWebsiteCertificateAuthoritiesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token used to retrieve the next page of results for this operation.
	// If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// Information about the certificates.
	WebsiteCertificateAuthorities []*WebsiteCaSummary `type:"list"`
}

// String returns the string representation
func (s ListWebsiteCertificateAuthoritiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWebsiteCertificateAuthoritiesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWebsiteCertificateAuthoritiesOutput) SetNextToken(v string) *ListWebsiteCertificateAuthoritiesOutput {
	s.NextToken = &v
	return s
}

// SetWebsiteCertificateAuthorities sets the WebsiteCertificateAuthorities field's value.
func (s *ListWebsiteCertificateAuthoritiesOutput) SetWebsiteCertificateAuthorities(v []*WebsiteCaSummary) *ListWebsiteCertificateAuthoritiesOutput {
	s.WebsiteCertificateAuthorities = v
	return s
}

// The resource already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RestoreDomainAccessInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreDomainAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDomainAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreDomainAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreDomainAccessInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *RestoreDomainAccessInput) SetDomainName(v string) *RestoreDomainAccessInput {
	s.DomainName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *RestoreDomainAccessInput) SetFleetArn(v string) *RestoreDomainAccessInput {
	s.FleetArn = &v
	return s
}

type RestoreDomainAccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestoreDomainAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreDomainAccessOutput) GoString() string {
	return s.String()
}

type RevokeDomainAccessInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeDomainAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeDomainAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeDomainAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeDomainAccessInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *RevokeDomainAccessInput) SetDomainName(v string) *RevokeDomainAccessInput {
	s.DomainName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *RevokeDomainAccessInput) SetFleetArn(v string) *RevokeDomainAccessInput {
	s.FleetArn = &v
	return s
}

type RevokeDomainAccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeDomainAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeDomainAccessOutput) GoString() string {
	return s.String()
}

type SignOutUserInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// The name of the user.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignOutUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignOutUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignOutUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignOutUserInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *SignOutUserInput) SetFleetArn(v string) *SignOutUserInput {
	s.FleetArn = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *SignOutUserInput) SetUsername(v string) *SignOutUserInput {
	s.Username = &v
	return s
}

type SignOutUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SignOutUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignOutUserOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`

	// The tags to add to the resource. A tag is a key-value pair.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The number of requests exceeds the limit.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You are not authorized to perform this action.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"20" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAuditStreamConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Kinesis data stream that receives the audit events.
	AuditStreamArn *string `type:"string"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAuditStreamConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAuditStreamConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAuditStreamConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAuditStreamConfigurationInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuditStreamArn sets the AuditStreamArn field's value.
func (s *UpdateAuditStreamConfigurationInput) SetAuditStreamArn(v string) *UpdateAuditStreamConfigurationInput {
	s.AuditStreamArn = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *UpdateAuditStreamConfigurationInput) SetFleetArn(v string) *UpdateAuditStreamConfigurationInput {
	s.FleetArn = &v
	return s
}

type UpdateAuditStreamConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAuditStreamConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAuditStreamConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateCompanyNetworkConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// The security groups associated with access to the provided subnets.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `type:"list" required:"true"`

	// The subnets used for X-ENI connections from Amazon WorkLink rendering containers.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// The VPC with connectivity to associated websites.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateCompanyNetworkConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCompanyNetworkConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCompanyNetworkConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCompanyNetworkConfigurationInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *UpdateCompanyNetworkConfigurationInput) SetFleetArn(v string) *UpdateCompanyNetworkConfigurationInput {
	s.FleetArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *UpdateCompanyNetworkConfigurationInput) SetSecurityGroupIds(v []*string) *UpdateCompanyNetworkConfigurationInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *UpdateCompanyNetworkConfigurationInput) SetSubnetIds(v []*string) *UpdateCompanyNetworkConfigurationInput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *UpdateCompanyNetworkConfigurationInput) SetVpcId(v string) *UpdateCompanyNetworkConfigurationInput {
	s.VpcId = &v
	return s
}

type UpdateCompanyNetworkConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCompanyNetworkConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCompanyNetworkConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateDevicePolicyConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The certificate chain, including intermediate certificates and the root certificate
	// authority certificate used to issue device certificates.
	DeviceCaCertificate *string `min:"1" type:"string"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDevicePolicyConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDevicePolicyConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDevicePolicyConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDevicePolicyConfigurationInput"}
	if s.DeviceCaCertificate != nil && len(*s.DeviceCaCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceCaCertificate", 1))
	}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceCaCertificate sets the DeviceCaCertificate field's value.
func (s *UpdateDevicePolicyConfigurationInput) SetDeviceCaCertificate(v string) *UpdateDevicePolicyConfigurationInput {
	s.DeviceCaCertificate = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *UpdateDevicePolicyConfigurationInput) SetFleetArn(v string) *UpdateDevicePolicyConfigurationInput {
	s.FleetArn = &v
	return s
}

type UpdateDevicePolicyConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDevicePolicyConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDevicePolicyConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateDomainMetadataInput struct {
	_ struct{} `type:"structure"`

	// The name to display.
	DisplayName *string `type:"string"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainMetadataInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateDomainMetadataInput) SetDisplayName(v string) *UpdateDomainMetadataInput {
	s.DisplayName = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainMetadataInput) SetDomainName(v string) *UpdateDomainMetadataInput {
	s.DomainName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *UpdateDomainMetadataInput) SetFleetArn(v string) *UpdateDomainMetadataInput {
	s.FleetArn = &v
	return s
}

type UpdateDomainMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDomainMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainMetadataOutput) GoString() string {
	return s.String()
}

type UpdateFleetMetadataInput struct {
	_ struct{} `type:"structure"`

	// The fleet name to display. The existing DisplayName is unset if null is passed.
	DisplayName *string `type:"string"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// The option to optimize for better performance by routing traffic through
	// the closest AWS Region to users, which may be outside of your home Region.
	OptimizeForEndUserLocation *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateFleetMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFleetMetadataInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateFleetMetadataInput) SetDisplayName(v string) *UpdateFleetMetadataInput {
	s.DisplayName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *UpdateFleetMetadataInput) SetFleetArn(v string) *UpdateFleetMetadataInput {
	s.FleetArn = &v
	return s
}

// SetOptimizeForEndUserLocation sets the OptimizeForEndUserLocation field's value.
func (s *UpdateFleetMetadataInput) SetOptimizeForEndUserLocation(v bool) *UpdateFleetMetadataInput {
	s.OptimizeForEndUserLocation = &v
	return s
}

type UpdateFleetMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFleetMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetMetadataOutput) GoString() string {
	return s.String()
}

type UpdateIdentityProviderConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// The SAML metadata document provided by the customer’s identity provider.
	// The existing IdentityProviderSamlMetadata is unset if null is passed.
	IdentityProviderSamlMetadata *string `min:"1" type:"string"`

	// The type of identity provider.
	//
	// IdentityProviderType is a required field
	IdentityProviderType *string `type:"string" required:"true" enum:"IdentityProviderType"`
}

// String returns the string representation
func (s UpdateIdentityProviderConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIdentityProviderConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIdentityProviderConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIdentityProviderConfigurationInput"}
	if s.FleetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FleetArn", 20))
	}
	if s.IdentityProviderSamlMetadata != nil && len(*s.IdentityProviderSamlMetadata) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityProviderSamlMetadata", 1))
	}
	if s.IdentityProviderType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetArn sets the FleetArn field's value.
func (s *UpdateIdentityProviderConfigurationInput) SetFleetArn(v string) *UpdateIdentityProviderConfigurationInput {
	s.FleetArn = &v
	return s
}

// SetIdentityProviderSamlMetadata sets the IdentityProviderSamlMetadata field's value.
func (s *UpdateIdentityProviderConfigurationInput) SetIdentityProviderSamlMetadata(v string) *UpdateIdentityProviderConfigurationInput {
	s.IdentityProviderSamlMetadata = &v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *UpdateIdentityProviderConfigurationInput) SetIdentityProviderType(v string) *UpdateIdentityProviderConfigurationInput {
	s.IdentityProviderType = &v
	return s
}

type UpdateIdentityProviderConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateIdentityProviderConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIdentityProviderConfigurationOutput) GoString() string {
	return s.String()
}

// The summary of the website authorization provider.
type WebsiteAuthorizationProviderSummary struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the authorization provider.
	AuthorizationProviderId *string `min:"1" type:"string"`

	// The authorization provider type.
	//
	// AuthorizationProviderType is a required field
	AuthorizationProviderType *string `type:"string" required:"true" enum:"AuthorizationProviderType"`

	// The time of creation.
	CreatedTime *time.Time `type:"timestamp"`

	// The domain name of the authorization provider. This applies only to SAML-based
	// authorization providers.
	DomainName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s WebsiteAuthorizationProviderSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebsiteAuthorizationProviderSummary) GoString() string {
	return s.String()
}

// SetAuthorizationProviderId sets the AuthorizationProviderId field's value.
func (s *WebsiteAuthorizationProviderSummary) SetAuthorizationProviderId(v string) *WebsiteAuthorizationProviderSummary {
	s.AuthorizationProviderId = &v
	return s
}

// SetAuthorizationProviderType sets the AuthorizationProviderType field's value.
func (s *WebsiteAuthorizationProviderSummary) SetAuthorizationProviderType(v string) *WebsiteAuthorizationProviderSummary {
	s.AuthorizationProviderType = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *WebsiteAuthorizationProviderSummary) SetCreatedTime(v time.Time) *WebsiteAuthorizationProviderSummary {
	s.CreatedTime = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *WebsiteAuthorizationProviderSummary) SetDomainName(v string) *WebsiteAuthorizationProviderSummary {
	s.DomainName = &v
	return s
}

// The summary of the certificate authority (CA).
type WebsiteCaSummary struct {
	_ struct{} `type:"structure"`

	// The time when the CA was added.
	CreatedTime *time.Time `type:"timestamp"`

	// The name to display.
	DisplayName *string `type:"string"`

	// A unique identifier for the CA.
	WebsiteCaId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s WebsiteCaSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebsiteCaSummary) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *WebsiteCaSummary) SetCreatedTime(v time.Time) *WebsiteCaSummary {
	s.CreatedTime = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *WebsiteCaSummary) SetDisplayName(v string) *WebsiteCaSummary {
	s.DisplayName = &v
	return s
}

// SetWebsiteCaId sets the WebsiteCaId field's value.
func (s *WebsiteCaSummary) SetWebsiteCaId(v string) *WebsiteCaSummary {
	s.WebsiteCaId = &v
	return s
}

const (
	// AuthorizationProviderTypeSaml is a AuthorizationProviderType enum value
	AuthorizationProviderTypeSaml = "SAML"
)

const (
	// DeviceStatusActive is a DeviceStatus enum value
	DeviceStatusActive = "ACTIVE"

	// DeviceStatusSignedOut is a DeviceStatus enum value
	DeviceStatusSignedOut = "SIGNED_OUT"
)

const (
	// DomainStatusPendingValidation is a DomainStatus enum value
	DomainStatusPendingValidation = "PENDING_VALIDATION"

	// DomainStatusAssociating is a DomainStatus enum value
	DomainStatusAssociating = "ASSOCIATING"

	// DomainStatusActive is a DomainStatus enum value
	DomainStatusActive = "ACTIVE"

	// DomainStatusInactive is a DomainStatus enum value
	DomainStatusInactive = "INACTIVE"

	// DomainStatusDisassociating is a DomainStatus enum value
	DomainStatusDisassociating = "DISASSOCIATING"

	// DomainStatusDisassociated is a DomainStatus enum value
	DomainStatusDisassociated = "DISASSOCIATED"

	// DomainStatusFailedToAssociate is a DomainStatus enum value
	DomainStatusFailedToAssociate = "FAILED_TO_ASSOCIATE"

	// DomainStatusFailedToDisassociate is a DomainStatus enum value
	DomainStatusFailedToDisassociate = "FAILED_TO_DISASSOCIATE"
)

const (
	// FleetStatusCreating is a FleetStatus enum value
	FleetStatusCreating = "CREATING"

	// FleetStatusActive is a FleetStatus enum value
	FleetStatusActive = "ACTIVE"

	// FleetStatusDeleting is a FleetStatus enum value
	FleetStatusDeleting = "DELETING"

	// FleetStatusDeleted is a FleetStatus enum value
	FleetStatusDeleted = "DELETED"

	// FleetStatusFailedToCreate is a FleetStatus enum value
	FleetStatusFailedToCreate = "FAILED_TO_CREATE"

	// FleetStatusFailedToDelete is a FleetStatus enum value
	FleetStatusFailedToDelete = "FAILED_TO_DELETE"
)

const (
	// IdentityProviderTypeSaml is a IdentityProviderType enum value
	IdentityProviderTypeSaml = "SAML"
)
