// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"fmt"
	"io"
	"time"

	"github.com/IBM/ibm-cos-sdk-go/aws"
	"github.com/IBM/ibm-cos-sdk-go/aws/awsutil"
	"github.com/IBM/ibm-cos-sdk-go/aws/request"
	"github.com/IBM/ibm-cos-sdk-go/private/checksum"
	"github.com/IBM/ibm-cos-sdk-go/private/protocol"
	"github.com/IBM/ibm-cos-sdk-go/private/protocol/restxml"
)

const opAbortMultipartUpload = "AbortMultipartUpload"

// AbortMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the AbortMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AbortMultipartUpload for more information on using the AbortMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AbortMultipartUploadRequest method.
//    req, resp := client.AbortMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUpload
func (c *S3) AbortMultipartUploadRequest(input *AbortMultipartUploadInput) (req *request.Request, output *AbortMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opAbortMultipartUpload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &AbortMultipartUploadInput{}
	}

	output = &AbortMultipartUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AbortMultipartUpload API operation for Amazon Simple Storage Service.
//
// This action aborts a multipart upload. After a multipart upload is aborted,
// no additional parts can be uploaded using that upload ID. The storage consumed
// by any previously uploaded parts will be freed. However, if any part uploads
// are currently in progress, those part uploads might or might not succeed.
// As a result, it might be necessary to abort a given multipart upload multiple
// times in order to completely free all storage consumed by all parts.
//
// To verify that all parts have been removed, so you don't get charged for
// the part storage, you should call the ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
// action and ensure that the parts list is empty.
//
// For information about permissions required to use the multipart upload, see
// Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html).
//
// The following operations are related to AbortMultipartUpload:
//
//    * CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//    * UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//    * CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//    * ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//    * ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation AbortMultipartUpload for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchUpload "NoSuchUpload"
//   The specified multipart upload does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUpload
func (c *S3) AbortMultipartUpload(input *AbortMultipartUploadInput) (*AbortMultipartUploadOutput, error) {
	req, out := c.AbortMultipartUploadRequest(input)
	return out, req.Send()
}

// AbortMultipartUploadWithContext is the same as AbortMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See AbortMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) AbortMultipartUploadWithContext(ctx aws.Context, input *AbortMultipartUploadInput, opts ...request.Option) (*AbortMultipartUploadOutput, error) {
	req, out := c.AbortMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddLegalHold = "AddLegalHold"

// AddLegalHoldRequest generates a "aws/request.Request" representing the
// client's request for the AddLegalHold operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddLegalHold for more information on using the AddLegalHold
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddLegalHoldRequest method.
//    req, resp := client.AddLegalHoldRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AddLegalHold
func (c *S3) AddLegalHoldRequest(input *AddLegalHoldInput) (req *request.Request, output *AddLegalHoldOutput) {
	op := &request.Operation{
		Name:       opAddLegalHold,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?legalHold",
	}

	if input == nil {
		input = &AddLegalHoldInput{}
	}

	output = &AddLegalHoldOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddLegalHold API operation for Amazon Simple Storage Service.
//
// Add a legal hold on an object. The legal hold identifiers are stored in the
// object metadata along with the timestamp of when they are POSTed to the object.
// The presence of any legal hold identifiers prevents the modification or deletion
// of the object data, even if the retention period has expired. Legal Holds
// can only be added to objects in a bucket with a protection policy. Otherwise
// a 400 error will be returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation AddLegalHold for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AddLegalHold
func (c *S3) AddLegalHold(input *AddLegalHoldInput) (*AddLegalHoldOutput, error) {
	req, out := c.AddLegalHoldRequest(input)
	return out, req.Send()
}

// AddLegalHoldWithContext is the same as AddLegalHold with the addition of
// the ability to pass a context and additional request options.
//
// See AddLegalHold for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) AddLegalHoldWithContext(ctx aws.Context, input *AddLegalHoldInput, opts ...request.Option) (*AddLegalHoldOutput, error) {
	req, out := c.AddLegalHoldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCompleteMultipartUpload = "CompleteMultipartUpload"

// CompleteMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the CompleteMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompleteMultipartUpload for more information on using the CompleteMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CompleteMultipartUploadRequest method.
//    req, resp := client.CompleteMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUpload
func (c *S3) CompleteMultipartUploadRequest(input *CompleteMultipartUploadInput) (req *request.Request, output *CompleteMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opCompleteMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CompleteMultipartUploadInput{}
	}

	output = &CompleteMultipartUploadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// CompleteMultipartUpload API operation for Amazon Simple Storage Service.
//
// Completes a multipart upload by assembling previously uploaded parts.
//
// You first initiate the multipart upload and then upload all parts using the
// UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
// operation. After successfully uploading all relevant parts of an upload,
// you call this action to complete the upload. Upon receiving this request,
// Amazon S3 concatenates all the parts in ascending order by part number to
// create a new object. In the Complete Multipart Upload request, you must provide
// the parts list. You must ensure that the parts list is complete. This action
// concatenates the parts that you provide in the list. For each part in the
// list, you must provide the part number and the ETag value, returned after
// that part was uploaded.
//
// Processing of a Complete Multipart Upload request could take several minutes
// to complete. After Amazon S3 begins processing the request, it sends an HTTP
// response header that specifies a 200 OK response. While processing is in
// progress, Amazon S3 periodically sends white space characters to keep the
// connection from timing out. Because a request could fail after the initial
// 200 OK response has been sent, it is important that you check the response
// body to determine whether the request succeeded.
//
// Note that if CompleteMultipartUpload fails, applications should be prepared
// to retry the failed requests. For more information, see Amazon S3 Error Best
// Practices (https://docs.aws.amazon.com/AmazonS3/latest/dev/ErrorBestPractices.html).
//
// For more information about multipart uploads, see Uploading Objects Using
// Multipart Upload (https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html).
//
// For information about permissions required to use the multipart upload API,
// see Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html).
//
// CompleteMultipartUpload has the following special errors:
//
//    * Error code: EntityTooSmall Description: Your proposed upload is smaller
//    than the minimum allowed object size. Each part must be at least 5 MB
//    in size, except the last part. 400 Bad Request
//
//    * Error code: InvalidPart Description: One or more of the specified parts
//    could not be found. The part might not have been uploaded, or the specified
//    entity tag might not have matched the part's entity tag. 400 Bad Request
//
//    * Error code: InvalidPartOrder Description: The list of parts was not
//    in ascending order. The parts list must be specified in order by part
//    number. 400 Bad Request
//
//    * Error code: NoSuchUpload Description: The specified multipart upload
//    does not exist. The upload ID might be invalid, or the multipart upload
//    might have been aborted or completed. 404 Not Found
//
// The following operations are related to CompleteMultipartUpload:
//
//    * CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//    * UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//    * AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
//    * ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//    * ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CompleteMultipartUpload for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUpload
func (c *S3) CompleteMultipartUpload(input *CompleteMultipartUploadInput) (*CompleteMultipartUploadOutput, error) {
	req, out := c.CompleteMultipartUploadRequest(input)
	return out, req.Send()
}

// CompleteMultipartUploadWithContext is the same as CompleteMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CompleteMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CompleteMultipartUploadWithContext(ctx aws.Context, input *CompleteMultipartUploadInput, opts ...request.Option) (*CompleteMultipartUploadOutput, error) {
	req, out := c.CompleteMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyObject = "CopyObject"

// CopyObjectRequest generates a "aws/request.Request" representing the
// client's request for the CopyObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyObject for more information on using the CopyObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyObjectRequest method.
//    req, resp := client.CopyObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObject
func (c *S3) CopyObjectRequest(input *CopyObjectInput) (req *request.Request, output *CopyObjectOutput) {
	op := &request.Operation{
		Name:       opCopyObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CopyObjectInput{}
	}

	output = &CopyObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyObject API operation for Amazon Simple Storage Service.
//
// Creates a copy of an object that is already stored in Amazon S3.
//
// You can store individual objects of up to 5 TB in Amazon S3. You create a
// copy of your object up to 5 GB in size in a single atomic action using this
// API. However, to copy an object greater than 5 GB, you must use the multipart
// upload Upload Part - Copy API. For more information, see Copy Object Using
// the REST Multipart Upload API (https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjctsUsingRESTMPUapi.html).
//
// All copy requests must be authenticated. Additionally, you must have read
// access to the source object and write access to the destination bucket. For
// more information, see REST Authentication (https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html).
// Both the Region that you want to copy the object from and the Region that
// you want to copy the object to must be enabled for your account.
//
// A copy request might return an error when Amazon S3 receives the copy request
// or while Amazon S3 is copying the files. If the error occurs before the copy
// action starts, you receive a standard Amazon S3 error. If the error occurs
// during the copy operation, the error response is embedded in the 200 OK response.
// This means that a 200 OK response can contain either a success or an error.
// Design your application to parse the contents of the response and handle
// it appropriately.
//
// If the copy is successful, you receive a response with information about
// the copied object.
//
// If the request is an HTTP 1.1 request, the response is chunk encoded. If
// it were not, it would not contain the content-length, and you would need
// to read the entire body.
//
// The copy request charge is based on the storage class and Region that you
// specify for the destination object. For pricing information, see Amazon S3
// pricing (http://aws.amazon.com/s3/pricing/).
//
// Amazon S3 transfer acceleration does not support cross-Region copies. If
// you request a cross-Region copy using a transfer acceleration endpoint, you
// get a 400 Bad Request error. For more information, see Transfer Acceleration
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html).
//
// Metadata
//
// When copying an object, you can preserve all metadata (default) or specify
// new metadata. However, the ACL is not preserved and is set to private for
// the user making the request. To override the default ACL setting, specify
// a new ACL when generating a copy request. For more information, see Using
// ACLs (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html).
//
// To specify whether you want the object metadata copied from the source object
// or replaced with metadata provided in the request, you can optionally add
// the x-amz-metadata-directive header. When you grant permissions, you can
// use the s3:x-amz-metadata-directive condition key to enforce certain metadata
// behavior when objects are uploaded. For more information, see Specifying
// Conditions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html)
// in the Amazon S3 Developer Guide. For a complete list of Amazon S3-specific
// condition keys, see Actions, Resources, and Condition Keys for Amazon S3
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html).
//
//  x-amz-copy-source-if Headers
//
// To only copy an object under certain conditions, such as whether the Etag
// matches or whether the object was modified before or after a specified date,
// use the following request parameters:
//
//    * x-amz-copy-source-if-match
//
//    * x-amz-copy-source-if-none-match
//
//    * x-amz-copy-source-if-unmodified-since
//
//    * x-amz-copy-source-if-modified-since
//
// If both the x-amz-copy-source-if-match and x-amz-copy-source-if-unmodified-since
// headers are present in the request and evaluate as follows, Amazon S3 returns
// 200 OK and copies the data:
//
//    * x-amz-copy-source-if-match condition evaluates to true
//
//    * x-amz-copy-source-if-unmodified-since condition evaluates to false
//
// If both the x-amz-copy-source-if-none-match and x-amz-copy-source-if-modified-since
// headers are present in the request and evaluate as follows, Amazon S3 returns
// the 412 Precondition Failed response code:
//
//    * x-amz-copy-source-if-none-match condition evaluates to false
//
//    * x-amz-copy-source-if-modified-since condition evaluates to true
//
// All headers with the x-amz- prefix, including x-amz-copy-source, must be
// signed.
//
// Server-side encryption
//
// When you perform a CopyObject operation, you can optionally use the appropriate
// encryption-related headers to encrypt the object using server-side encryption
// with AWS managed encryption keys (SSE-S3 or SSE-KMS) or a customer-provided
// encryption key. With server-side encryption, Amazon S3 encrypts your data
// as it writes it to disks in its data centers and decrypts the data when you
// access it. For more information about server-side encryption, see Using Server-Side
// Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html).
//
// If a target object uses SSE-KMS, you can enable an S3 Bucket Key for the
// object. For more information, see Amazon S3 Bucket Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html)
// in the Amazon S3 User Guide.
//
// Access Control List (ACL)-Specific Request Headers
//
// When copying an object, you can optionally use headers to grant ACL-based
// permissions. By default, all objects are private. Only the owner has full
// access control. When adding a new object, you can grant permissions to individual
// AWS accounts or to predefined groups defined by Amazon S3. These permissions
// are then added to the ACL on the object. For more information, see Access
// Control List (ACL) Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html)
// and Managing ACLs Using the REST API (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-using-rest-api.html).
//
// Storage Class Options
//
// You can use the CopyObject action to change the storage class of an object
// that is already stored in Amazon S3 using the StorageClass parameter. For
// more information, see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html)
// in the Amazon S3 Service Developer Guide.
//
// Versioning
//
// By default, x-amz-copy-source identifies the current version of an object
// to copy. If the current version is a delete marker, Amazon S3 behaves as
// if the object was deleted. To copy a different version, use the versionId
// subresource.
//
// If you enable versioning on the target bucket, Amazon S3 generates a unique
// version ID for the object being copied. This version ID is different from
// the version ID of the source object. Amazon S3 returns the version ID of
// the copied object in the x-amz-version-id response header in the response.
//
// If you do not enable versioning or suspend it on the target bucket, the version
// ID that Amazon S3 generates is always null.
//
// If the source object's storage class is GLACIER, you must restore a copy
// of this object before you can use it as a source object for the copy operation.
// For more information, see RestoreObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html).
//
// The following operations are related to CopyObject:
//
//    * PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//    * GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
// For more information, see Copying Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/CopyingObjectsExamples.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CopyObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeObjectNotInActiveTierError "ObjectNotInActiveTierError"
//   The source object of the COPY action is not in the active tier and is only
//   stored in Amazon S3 Glacier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObject
func (c *S3) CopyObject(input *CopyObjectInput) (*CopyObjectOutput, error) {
	req, out := c.CopyObjectRequest(input)
	return out, req.Send()
}

// CopyObjectWithContext is the same as CopyObject with the addition of
// the ability to pass a context and additional request options.
//
// See CopyObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CopyObjectWithContext(ctx aws.Context, input *CopyObjectInput, opts ...request.Option) (*CopyObjectOutput, error) {
	req, out := c.CopyObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBucket = "CreateBucket"

// CreateBucketRequest generates a "aws/request.Request" representing the
// client's request for the CreateBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBucket for more information on using the CreateBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBucketRequest method.
//    req, resp := client.CreateBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucket
func (c *S3) CreateBucketRequest(input *CreateBucketInput) (req *request.Request, output *CreateBucketOutput) {
	op := &request.Operation{
		Name:       opCreateBucket,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &CreateBucketInput{}
	}

	output = &CreateBucketOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBucket API operation for Amazon Simple Storage Service.
//
// Creates a new S3 bucket. To create a bucket, you must register with Amazon
// S3 and have a valid AWS Access Key ID to authenticate requests. Anonymous
// requests are never allowed to create buckets. By creating the bucket, you
// become the bucket owner.
//
// Not every string is an acceptable bucket name. For information about bucket
// naming restrictions, see Working with Amazon S3 buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html).
//
// If you want to create an Amazon S3 on Outposts bucket, see Create Bucket
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html).
//
// By default, the bucket is created in the US East (N. Virginia) Region. You
// can optionally specify a Region in the request body. You might choose a Region
// to optimize latency, minimize costs, or address regulatory requirements.
// For example, if you reside in Europe, you will probably find it advantageous
// to create buckets in the Europe (Ireland) Region. For more information, see
// Accessing a bucket (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro).
//
// If you send your create bucket request to the s3.amazonaws.com endpoint,
// the request goes to the us-east-1 Region. Accordingly, the signature calculations
// in Signature Version 4 must use us-east-1 as the Region, even if the location
// constraint in the request specifies another Region where the bucket is to
// be created. If you create a bucket in a Region other than US East (N. Virginia),
// your application must be able to handle 307 redirect. For more information,
// see Virtual hosting of buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html).
//
// When creating a bucket using this operation, you can optionally specify the
// accounts or groups that should be granted specific permissions on the bucket.
// There are two ways to grant the appropriate permissions using the request
// headers.
//
//    * Specify a canned ACL using the x-amz-acl request header. Amazon S3 supports
//    a set of predefined ACLs, known as canned ACLs. Each canned ACL has a
//    predefined set of grantees and permissions. For more information, see
//    Canned ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
//
//    * Specify access permissions explicitly using the x-amz-grant-read, x-amz-grant-write,
//    x-amz-grant-read-acp, x-amz-grant-write-acp, and x-amz-grant-full-control
//    headers. These headers map to the set of permissions Amazon S3 supports
//    in an ACL. For more information, see Access control list (ACL) overview
//    (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html). You
//    specify each grantee as a type=value pair, where the type is one of the
//    following: id – if the value specified is the canonical user ID of an
//    AWS account uri – if you are granting permissions to a predefined group
//    emailAddress – if the value specified is the email address of an AWS
//    account Using email addresses to specify a grantee is only supported in
//    the following AWS Regions: US East (N. Virginia) US West (N. California)
//    US West (Oregon) Asia Pacific (Singapore) Asia Pacific (Sydney) Asia Pacific
//    (Tokyo) Europe (Ireland) South America (São Paulo) For a list of all
//    the Amazon S3 supported Regions and endpoints, see Regions and Endpoints
//    (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) in
//    the AWS General Reference. For example, the following x-amz-grant-read
//    header grants the AWS accounts identified by account IDs permissions to
//    read object data and its metadata: x-amz-grant-read: id="11112222333",
//    id="444455556666"
//
// You can use either a canned ACL or specify access permissions explicitly.
// You cannot do both.
//
// The following operations are related to CreateBucket:
//
//    * PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//    * DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CreateBucket for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBucketAlreadyExists "BucketAlreadyExists"
//   The requested bucket name is not available. The bucket namespace is shared
//   by all users of the system. Select a different name and try again.
//
//   * ErrCodeBucketAlreadyOwnedByYou "BucketAlreadyOwnedByYou"
//   The bucket you tried to create already exists, and you own it. Amazon S3
//   returns this error in all AWS Regions except in the North Virginia Region.
//   For legacy compatibility, if you re-create an existing bucket that you already
//   own in the North Virginia Region, Amazon S3 returns 200 OK and resets the
//   bucket access control lists (ACLs).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucket
func (c *S3) CreateBucket(input *CreateBucketInput) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	return out, req.Send()
}

// CreateBucketWithContext is the same as CreateBucket with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CreateBucketWithContext(ctx aws.Context, input *CreateBucketInput, opts ...request.Option) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMultipartUpload = "CreateMultipartUpload"

// CreateMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the CreateMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMultipartUpload for more information on using the CreateMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMultipartUploadRequest method.
//    req, resp := client.CreateMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUpload
func (c *S3) CreateMultipartUploadRequest(input *CreateMultipartUploadInput) (req *request.Request, output *CreateMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opCreateMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?uploads",
	}

	if input == nil {
		input = &CreateMultipartUploadInput{}
	}

	output = &CreateMultipartUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMultipartUpload API operation for Amazon Simple Storage Service.
//
// This action initiates a multipart upload and returns an upload ID. This upload
// ID is used to associate all of the parts in the specific multipart upload.
// You specify this upload ID in each of your subsequent upload part requests
// (see UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)).
// You also include this upload ID in the final request to either complete or
// abort the multipart upload request.
//
// For more information about multipart uploads, see Multipart Upload Overview
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html).
//
// If you have configured a lifecycle rule to abort incomplete multipart uploads,
// the upload must complete within the number of days specified in the bucket
// lifecycle configuration. Otherwise, the incomplete multipart upload becomes
// eligible for an abort action and Amazon S3 aborts the multipart upload. For
// more information, see Aborting Incomplete Multipart Uploads Using a Bucket
// Lifecycle Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config).
//
// For information about the permissions required to use the multipart upload
// API, see Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html).
//
// For request signing, multipart upload is just a series of regular requests.
// You initiate a multipart upload, send one or more requests to upload parts,
// and then complete the multipart upload process. You sign each request individually.
// There is nothing special about signing multipart upload requests. For more
// information about signing, see Authenticating Requests (AWS Signature Version
// 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html).
//
// After you initiate a multipart upload and upload one or more parts, to stop
// being charged for storing the uploaded parts, you must either complete or
// abort the multipart upload. Amazon S3 frees up the space used to store the
// parts and stop charging you for storing them only after you either complete
// or abort a multipart upload.
//
// You can optionally request server-side encryption. For server-side encryption,
// Amazon S3 encrypts your data as it writes it to disks in its data centers
// and decrypts it when you access it. You can provide your own encryption key,
// or use AWS Key Management Service (AWS KMS) customer master keys (CMKs) or
// Amazon S3-managed encryption keys. If you choose to provide your own encryption
// key, the request headers you provide in UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
// and UploadPartCopy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html)
// requests must match the headers you used in the request to initiate the upload
// by using CreateMultipartUpload.
//
// To perform a multipart upload with encryption using an AWS KMS CMK, the requester
// must have permission to the kms:Encrypt, kms:Decrypt, kms:ReEncrypt*, kms:GenerateDataKey*,
// and kms:DescribeKey actions on the key. These permissions are required because
// Amazon S3 must decrypt and read data from the encrypted file parts before
// it completes the multipart upload.
//
// If your AWS Identity and Access Management (IAM) user or role is in the same
// AWS account as the AWS KMS CMK, then you must have these permissions on the
// key policy. If your IAM user or role belongs to a different account than
// the key, then you must have the permissions on both the key policy and your
// IAM user or role.
//
// For more information, see Protecting Data Using Server-Side Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html).
//
// Access Permissions
//
// When copying an object, you can optionally specify the accounts or groups
// that should be granted specific permissions on the new object. There are
// two ways to grant the permissions using the request headers:
//
//    * Specify a canned ACL with the x-amz-acl request header. For more information,
//    see Canned ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
//
//    * Specify access permissions explicitly with the x-amz-grant-read, x-amz-grant-read-acp,
//    x-amz-grant-write-acp, and x-amz-grant-full-control headers. These parameters
//    map to the set of permissions that Amazon S3 supports in an ACL. For more
//    information, see Access Control List (ACL) Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html).
//
// You can use either a canned ACL or specify access permissions explicitly.
// You cannot do both.
//
// Server-Side- Encryption-Specific Request Headers
//
// You can optionally tell Amazon S3 to encrypt data at rest using server-side
// encryption. Server-side encryption is for data encryption at rest. Amazon
// S3 encrypts your data as it writes it to disks in its data centers and decrypts
// it when you access it. The option you use depends on whether you want to
// use AWS managed encryption keys or provide your own encryption key.
//
//    * Use encryption keys managed by Amazon S3 or customer master keys (CMKs)
//    stored in AWS Key Management Service (AWS KMS) – If you want AWS to
//    manage the keys used to encrypt data, specify the following headers in
//    the request. x-amz-server-side-encryption x-amz-server-side-encryption-aws-kms-key-id
//    x-amz-server-side-encryption-context If you specify x-amz-server-side-encryption:aws:kms,
//    but don't provide x-amz-server-side-encryption-aws-kms-key-id, Amazon
//    S3 uses the AWS managed CMK in AWS KMS to protect the data. All GET and
//    PUT requests for an object protected by AWS KMS fail if you don't make
//    them with SSL or by using SigV4. For more information about server-side
//    encryption with CMKs stored in AWS KMS (SSE-KMS), see Protecting Data
//    Using Server-Side Encryption with CMKs stored in AWS KMS (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html).
//
//    * Use customer-provided encryption keys – If you want to manage your
//    own encryption keys, provide all the following headers in the request.
//    x-amz-server-side-encryption-customer-algorithm x-amz-server-side-encryption-customer-key
//    x-amz-server-side-encryption-customer-key-MD5 For more information about
//    server-side encryption with CMKs stored in AWS KMS (SSE-KMS), see Protecting
//    Data Using Server-Side Encryption with CMKs stored in AWS KMS (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html).
//
// Access-Control-List (ACL)-Specific Request Headers
//
// You also can use the following access control–related headers with this
// operation. By default, all objects are private. Only the owner has full access
// control. When adding a new object, you can grant permissions to individual
// AWS accounts or to predefined groups defined by Amazon S3. These permissions
// are then added to the access control list (ACL) on the object. For more information,
// see Using ACLs (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html).
// With this operation, you can grant access permissions using one of the following
// two methods:
//
//    * Specify a canned ACL (x-amz-acl) — Amazon S3 supports a set of predefined
//    ACLs, known as canned ACLs. Each canned ACL has a predefined set of grantees
//    and permissions. For more information, see Canned ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
//
//    * Specify access permissions explicitly — To explicitly grant access
//    permissions to specific AWS accounts or groups, use the following headers.
//    Each header maps to specific permissions that Amazon S3 supports in an
//    ACL. For more information, see Access Control List (ACL) Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html).
//    In the header, you specify a list of grantees who get the specific permission.
//    To grant permissions explicitly, use: x-amz-grant-read x-amz-grant-write
//    x-amz-grant-read-acp x-amz-grant-write-acp x-amz-grant-full-control You
//    specify each grantee as a type=value pair, where the type is one of the
//    following: id – if the value specified is the canonical user ID of an
//    AWS account uri – if you are granting permissions to a predefined group
//    emailAddress – if the value specified is the email address of an AWS
//    account Using email addresses to specify a grantee is only supported in
//    the following AWS Regions: US East (N. Virginia) US West (N. California)
//    US West (Oregon) Asia Pacific (Singapore) Asia Pacific (Sydney) Asia Pacific
//    (Tokyo) Europe (Ireland) South America (São Paulo) For a list of all
//    the Amazon S3 supported Regions and endpoints, see Regions and Endpoints
//    (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) in
//    the AWS General Reference. For example, the following x-amz-grant-read
//    header grants the AWS accounts identified by account IDs permissions to
//    read object data and its metadata: x-amz-grant-read: id="11112222333",
//    id="444455556666"
//
// The following operations are related to CreateMultipartUpload:
//
//    * UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//    * CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//    * AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
//    * ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//    * ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CreateMultipartUpload for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUpload
func (c *S3) CreateMultipartUpload(input *CreateMultipartUploadInput) (*CreateMultipartUploadOutput, error) {
	req, out := c.CreateMultipartUploadRequest(input)
	return out, req.Send()
}

// CreateMultipartUploadWithContext is the same as CreateMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CreateMultipartUploadWithContext(ctx aws.Context, input *CreateMultipartUploadInput, opts ...request.Option) (*CreateMultipartUploadOutput, error) {
	req, out := c.CreateMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucket = "DeleteBucket"

// DeleteBucketRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucket for more information on using the DeleteBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketRequest method.
//    req, resp := client.DeleteBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucket
func (c *S3) DeleteBucketRequest(input *DeleteBucketInput) (req *request.Request, output *DeleteBucketOutput) {
	op := &request.Operation{
		Name:       opDeleteBucket,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &DeleteBucketInput{}
	}

	output = &DeleteBucketOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucket API operation for Amazon Simple Storage Service.
//
// Deletes the S3 bucket. All objects (including all object versions and delete
// markers) in the bucket must be deleted before the bucket itself can be deleted.
//
// Related Resources
//
//    * CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//    * DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucket for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucket
func (c *S3) DeleteBucket(input *DeleteBucketInput) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	return out, req.Send()
}

// DeleteBucketWithContext is the same as DeleteBucket with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketWithContext(ctx aws.Context, input *DeleteBucketInput, opts ...request.Option) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketCors = "DeleteBucketCors"

// DeleteBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketCors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketCors for more information on using the DeleteBucketCors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketCorsRequest method.
//    req, resp := client.DeleteBucketCorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCors
func (c *S3) DeleteBucketCorsRequest(input *DeleteBucketCorsInput) (req *request.Request, output *DeleteBucketCorsOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketCors,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &DeleteBucketCorsInput{}
	}

	output = &DeleteBucketCorsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketCors API operation for Amazon Simple Storage Service.
//
// Deletes the cors configuration information set for the bucket.
//
// To use this operation, you must have permission to perform the s3:PutBucketCORS
// action. The bucket owner has this permission by default and can grant this
// permission to others.
//
// For information about cors, see Enabling Cross-Origin Resource Sharing (https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html)
// in the Amazon S3 User Guide.
//
// Related Resources:
//
//    * PutBucketCors (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html)
//
//    * RESTOPTIONSobject (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketCors for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCors
func (c *S3) DeleteBucketCors(input *DeleteBucketCorsInput) (*DeleteBucketCorsOutput, error) {
	req, out := c.DeleteBucketCorsRequest(input)
	return out, req.Send()
}

// DeleteBucketCorsWithContext is the same as DeleteBucketCors with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketCors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketCorsWithContext(ctx aws.Context, input *DeleteBucketCorsInput, opts ...request.Option) (*DeleteBucketCorsOutput, error) {
	req, out := c.DeleteBucketCorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketLifecycle = "DeleteBucketLifecycle"

// DeleteBucketLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketLifecycle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketLifecycle for more information on using the DeleteBucketLifecycle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketLifecycleRequest method.
//    req, resp := client.DeleteBucketLifecycleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycle
func (c *S3) DeleteBucketLifecycleRequest(input *DeleteBucketLifecycleInput) (req *request.Request, output *DeleteBucketLifecycleOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketLifecycle,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &DeleteBucketLifecycleInput{}
	}

	output = &DeleteBucketLifecycleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketLifecycle API operation for Amazon Simple Storage Service.
//
// Deletes the lifecycle configuration from the specified bucket. Amazon S3
// removes all the lifecycle configuration rules in the lifecycle subresource
// associated with the bucket. Your objects never expire, and Amazon S3 no longer
// automatically deletes any objects on the basis of rules contained in the
// deleted lifecycle configuration.
//
// To use this operation, you must have permission to perform the s3:PutLifecycleConfiguration
// action. By default, the bucket owner has this permission and the bucket owner
// can grant this permission to others.
//
// There is usually some time lag before lifecycle configuration deletion is
// fully propagated to all the Amazon S3 systems.
//
// For more information about the object expiration, see Elements to Describe
// Lifecycle Actions (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#intro-lifecycle-rules-actions).
//
// Related actions include:
//
//    * PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)
//
//    * GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketLifecycle for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycle
func (c *S3) DeleteBucketLifecycle(input *DeleteBucketLifecycleInput) (*DeleteBucketLifecycleOutput, error) {
	req, out := c.DeleteBucketLifecycleRequest(input)
	return out, req.Send()
}

// DeleteBucketLifecycleWithContext is the same as DeleteBucketLifecycle with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketLifecycle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketLifecycleWithContext(ctx aws.Context, input *DeleteBucketLifecycleInput, opts ...request.Option) (*DeleteBucketLifecycleOutput, error) {
	req, out := c.DeleteBucketLifecycleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketWebsite = "DeleteBucketWebsite"

// DeleteBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketWebsite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketWebsite for more information on using the DeleteBucketWebsite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketWebsiteRequest method.
//    req, resp := client.DeleteBucketWebsiteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsite
func (c *S3) DeleteBucketWebsiteRequest(input *DeleteBucketWebsiteInput) (req *request.Request, output *DeleteBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketWebsite,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &DeleteBucketWebsiteInput{}
	}

	output = &DeleteBucketWebsiteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketWebsite API operation for Amazon Simple Storage Service.
//
// This action removes the website configuration for a bucket. Amazon S3 returns
// a 200 OK response upon successfully deleting a website configuration on the
// specified bucket. You will get a 200 OK response if the website configuration
// you are trying to delete does not exist on the bucket. Amazon S3 returns
// a 404 response if the bucket specified in the request does not exist.
//
// This DELETE action requires the S3:DeleteBucketWebsite permission. By default,
// only the bucket owner can delete the website configuration attached to a
// bucket. However, bucket owners can grant other users permission to delete
// the website configuration by writing a bucket policy granting them the S3:DeleteBucketWebsite
// permission.
//
// For more information about hosting websites, see Hosting Websites on Amazon
// S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
//
// The following operations are related to DeleteBucketWebsite:
//
//    * GetBucketWebsite (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketWebsite.html)
//
//    * PutBucketWebsite (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketWebsite for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsite
func (c *S3) DeleteBucketWebsite(input *DeleteBucketWebsiteInput) (*DeleteBucketWebsiteOutput, error) {
	req, out := c.DeleteBucketWebsiteRequest(input)
	return out, req.Send()
}

// DeleteBucketWebsiteWithContext is the same as DeleteBucketWebsite with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketWebsite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketWebsiteWithContext(ctx aws.Context, input *DeleteBucketWebsiteInput, opts ...request.Option) (*DeleteBucketWebsiteOutput, error) {
	req, out := c.DeleteBucketWebsiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLegalHold = "DeleteLegalHold"

// DeleteLegalHoldRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLegalHold operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLegalHold for more information on using the DeleteLegalHold
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLegalHoldRequest method.
//    req, resp := client.DeleteLegalHoldRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteLegalHold
func (c *S3) DeleteLegalHoldRequest(input *DeleteLegalHoldInput) (req *request.Request, output *DeleteLegalHoldOutput) {
	op := &request.Operation{
		Name:       opDeleteLegalHold,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?legalHold",
	}

	if input == nil {
		input = &DeleteLegalHoldInput{}
	}

	output = &DeleteLegalHoldOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLegalHold API operation for Amazon Simple Storage Service.
//
// Remove Legal hold on an object. The legal hold identifiers are stored in
// the object metadata along with the timestamp of when they are POSTed to the
// object. The presence of any legal hold identifiers prevents the modification
// or deletion of the object data, even if the retention period has expired.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteLegalHold for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteLegalHold
func (c *S3) DeleteLegalHold(input *DeleteLegalHoldInput) (*DeleteLegalHoldOutput, error) {
	req, out := c.DeleteLegalHoldRequest(input)
	return out, req.Send()
}

// DeleteLegalHoldWithContext is the same as DeleteLegalHold with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLegalHold for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteLegalHoldWithContext(ctx aws.Context, input *DeleteLegalHoldInput, opts ...request.Option) (*DeleteLegalHoldOutput, error) {
	req, out := c.DeleteLegalHoldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteObject = "DeleteObject"

// DeleteObjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObject for more information on using the DeleteObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteObjectRequest method.
//    req, resp := client.DeleteObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObject
func (c *S3) DeleteObjectRequest(input *DeleteObjectInput) (req *request.Request, output *DeleteObjectOutput) {
	op := &request.Operation{
		Name:       opDeleteObject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &DeleteObjectInput{}
	}

	output = &DeleteObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteObject API operation for Amazon Simple Storage Service.
//
// Removes the null version (if there is one) of an object and inserts a delete
// marker, which becomes the latest version of the object. If there isn't a
// null version, Amazon S3 does not remove any objects but will still respond
// that the command was successful.
//
// To remove a specific version, you must be the bucket owner and you must use
// the version Id subresource. Using this subresource permanently deletes the
// version. If the object deleted is a delete marker, Amazon S3 sets the response
// header, x-amz-delete-marker, to true.
//
// If the object you want to delete is in a bucket where the bucket versioning
// configuration is MFA Delete enabled, you must include the x-amz-mfa request
// header in the DELETE versionId request. Requests that include x-amz-mfa must
// use HTTPS.
//
// For more information about MFA Delete, see Using MFA Delete (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMFADelete.html).
// To see sample requests that use versioning, see Sample Request (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectDELETE.html#ExampleVersionObjectDelete).
//
// You can delete objects by explicitly calling DELETE Object or configure its
// lifecycle (PutBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html))
// to enable Amazon S3 to remove them for you. If you want to block users or
// accounts from removing or deleting objects from your bucket, you must deny
// them the s3:DeleteObject, s3:DeleteObjectVersion, and s3:PutLifeCycleConfiguration
// actions.
//
// The following action is related to DeleteObject:
//
//    * PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteObject for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObject
func (c *S3) DeleteObject(input *DeleteObjectInput) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	return out, req.Send()
}

// DeleteObjectWithContext is the same as DeleteObject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteObjectWithContext(ctx aws.Context, input *DeleteObjectInput, opts ...request.Option) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteObjectTagging = "DeleteObjectTagging"

// DeleteObjectTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObjectTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObjectTagging for more information on using the DeleteObjectTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteObjectTaggingRequest method.
//    req, resp := client.DeleteObjectTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTagging
func (c *S3) DeleteObjectTaggingRequest(input *DeleteObjectTaggingInput) (req *request.Request, output *DeleteObjectTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteObjectTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &DeleteObjectTaggingInput{}
	}

	output = &DeleteObjectTaggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteObjectTagging API operation for Amazon Simple Storage Service.
//
// Removes the entire tag set from the specified object. For more information
// about managing object tags, see Object Tagging (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html).
//
// To use this operation, you must have permission to perform the s3:DeleteObjectTagging
// action.
//
// To delete tags of a specific object version, add the versionId query parameter
// in the request. You will need permission for the s3:DeleteObjectVersionTagging
// action.
//
// The following operations are related to DeleteBucketMetricsConfiguration:
//
//    * PutObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html)
//
//    * GetObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteObjectTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTagging
func (c *S3) DeleteObjectTagging(input *DeleteObjectTaggingInput) (*DeleteObjectTaggingOutput, error) {
	req, out := c.DeleteObjectTaggingRequest(input)
	return out, req.Send()
}

// DeleteObjectTaggingWithContext is the same as DeleteObjectTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObjectTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteObjectTaggingWithContext(ctx aws.Context, input *DeleteObjectTaggingInput, opts ...request.Option) (*DeleteObjectTaggingOutput, error) {
	req, out := c.DeleteObjectTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteObjects = "DeleteObjects"

// DeleteObjectsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObjects for more information on using the DeleteObjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteObjectsRequest method.
//    req, resp := client.DeleteObjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjects
func (c *S3) DeleteObjectsRequest(input *DeleteObjectsInput) (req *request.Request, output *DeleteObjectsOutput) {
	op := &request.Operation{
		Name:       opDeleteObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}?delete",
	}

	if input == nil {
		input = &DeleteObjectsInput{}
	}

	output = &DeleteObjectsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// DeleteObjects API operation for Amazon Simple Storage Service.
//
// This action enables you to delete multiple objects from a bucket using a
// single HTTP request. If you know the object keys that you want to delete,
// then this action provides a suitable alternative to sending individual delete
// requests, reducing per-request overhead.
//
// The request contains a list of up to 1000 keys that you want to delete. In
// the XML, you provide the object key names, and optionally, version IDs if
// you want to delete a specific version of the object from a versioning-enabled
// bucket. For each key, Amazon S3 performs a delete action and returns the
// result of that delete, success, or failure, in the response. Note that if
// the object specified in the request is not found, Amazon S3 returns the result
// as deleted.
//
// The action supports two modes for the response: verbose and quiet. By default,
// the action uses verbose mode in which the response includes the result of
// deletion of each key in your request. In quiet mode the response includes
// only keys where the delete action encountered an error. For a successful
// deletion, the action does not return any information about the delete in
// the response body.
//
// When performing this action on an MFA Delete enabled bucket, that attempts
// to delete any versioned objects, you must include an MFA token. If you do
// not provide one, the entire request will fail, even if there are non-versioned
// objects you are trying to delete. If you provide an invalid token, whether
// there are versioned keys in the request or not, the entire Multi-Object Delete
// request will fail. For information about MFA Delete, see MFA Delete (https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html#MultiFactorAuthenticationDelete).
//
// Finally, the Content-MD5 header is required for all Multi-Object Delete requests.
// Amazon S3 uses the header value to ensure that your request body has not
// been altered in transit.
//
// The following operations are related to DeleteObjects:
//
//    * CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//    * UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//    * CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//    * ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//    * AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteObjects for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjects
func (c *S3) DeleteObjects(input *DeleteObjectsInput) (*DeleteObjectsOutput, error) {
	req, out := c.DeleteObjectsRequest(input)
	return out, req.Send()
}

// DeleteObjectsWithContext is the same as DeleteObjects with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteObjectsWithContext(ctx aws.Context, input *DeleteObjectsInput, opts ...request.Option) (*DeleteObjectsOutput, error) {
	req, out := c.DeleteObjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePublicAccessBlock = "DeletePublicAccessBlock"

// DeletePublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the DeletePublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePublicAccessBlock for more information on using the DeletePublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePublicAccessBlockRequest method.
//    req, resp := client.DeletePublicAccessBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeletePublicAccessBlock
func (c *S3) DeletePublicAccessBlockRequest(input *DeletePublicAccessBlockInput) (req *request.Request, output *DeletePublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opDeletePublicAccessBlock,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?publicAccessBlock",
	}

	if input == nil {
		input = &DeletePublicAccessBlockInput{}
	}

	output = &DeletePublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePublicAccessBlock API operation for Amazon Simple Storage Service.
//
// Removes the PublicAccessBlock configuration for an Amazon S3 bucket. To use
// this operation, you must have the s3:PutBucketPublicAccessBlock permission.
// For more information about permissions, see Permissions Related to Bucket
// Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// The following operations are related to DeletePublicAccessBlock:
//
//    * Using Amazon S3 Block Public Access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
//
//    * GetPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html)
//
//    * PutPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html)
//
//    * GetBucketPolicyStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicyStatus.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeletePublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeletePublicAccessBlock
func (c *S3) DeletePublicAccessBlock(input *DeletePublicAccessBlockInput) (*DeletePublicAccessBlockOutput, error) {
	req, out := c.DeletePublicAccessBlockRequest(input)
	return out, req.Send()
}

// DeletePublicAccessBlockWithContext is the same as DeletePublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeletePublicAccessBlockWithContext(ctx aws.Context, input *DeletePublicAccessBlockInput, opts ...request.Option) (*DeletePublicAccessBlockOutput, error) {
	req, out := c.DeletePublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExtendObjectRetention = "ExtendObjectRetention"

// ExtendObjectRetentionRequest generates a "aws/request.Request" representing the
// client's request for the ExtendObjectRetention operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExtendObjectRetention for more information on using the ExtendObjectRetention
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExtendObjectRetentionRequest method.
//    req, resp := client.ExtendObjectRetentionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ExtendObjectRetention
func (c *S3) ExtendObjectRetentionRequest(input *ExtendObjectRetentionInput) (req *request.Request, output *ExtendObjectRetentionOutput) {
	op := &request.Operation{
		Name:       opExtendObjectRetention,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?extendRetention",
	}

	if input == nil {
		input = &ExtendObjectRetentionInput{}
	}

	output = &ExtendObjectRetentionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ExtendObjectRetention API operation for Amazon Simple Storage Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ExtendObjectRetention for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ExtendObjectRetention
func (c *S3) ExtendObjectRetention(input *ExtendObjectRetentionInput) (*ExtendObjectRetentionOutput, error) {
	req, out := c.ExtendObjectRetentionRequest(input)
	return out, req.Send()
}

// ExtendObjectRetentionWithContext is the same as ExtendObjectRetention with the addition of
// the ability to pass a context and additional request options.
//
// See ExtendObjectRetention for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ExtendObjectRetentionWithContext(ctx aws.Context, input *ExtendObjectRetentionInput, opts ...request.Option) (*ExtendObjectRetentionOutput, error) {
	req, out := c.ExtendObjectRetentionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketAcl = "GetBucketAcl"

// GetBucketAclRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketAcl for more information on using the GetBucketAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketAclRequest method.
//    req, resp := client.GetBucketAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAcl
func (c *S3) GetBucketAclRequest(input *GetBucketAclInput) (req *request.Request, output *GetBucketAclOutput) {
	op := &request.Operation{
		Name:       opGetBucketAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &GetBucketAclInput{}
	}

	output = &GetBucketAclOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketAcl API operation for Amazon Simple Storage Service.
//
// This implementation of the GET action uses the acl subresource to return
// the access control list (ACL) of a bucket. To use GET to return the ACL of
// the bucket, you must have READ_ACP access to the bucket. If READ_ACP permission
// is granted to the anonymous user, you can return the ACL of the bucket without
// using an authorization header.
//
// Related Resources
//
//    * ListObjects (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketAcl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAcl
func (c *S3) GetBucketAcl(input *GetBucketAclInput) (*GetBucketAclOutput, error) {
	req, out := c.GetBucketAclRequest(input)
	return out, req.Send()
}

// GetBucketAclWithContext is the same as GetBucketAcl with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketAclWithContext(ctx aws.Context, input *GetBucketAclInput, opts ...request.Option) (*GetBucketAclOutput, error) {
	req, out := c.GetBucketAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketCors = "GetBucketCors"

// GetBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketCors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketCors for more information on using the GetBucketCors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketCorsRequest method.
//    req, resp := client.GetBucketCorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCors
func (c *S3) GetBucketCorsRequest(input *GetBucketCorsInput) (req *request.Request, output *GetBucketCorsOutput) {
	op := &request.Operation{
		Name:       opGetBucketCors,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &GetBucketCorsInput{}
	}

	output = &GetBucketCorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketCors API operation for Amazon Simple Storage Service.
//
// Returns the cors configuration information set for the bucket.
//
// To use this operation, you must have permission to perform the s3:GetBucketCORS
// action. By default, the bucket owner has this permission and can grant it
// to others.
//
// For more information about cors, see Enabling Cross-Origin Resource Sharing
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html).
//
// The following operations are related to GetBucketCors:
//
//    * PutBucketCors (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html)
//
//    * DeleteBucketCors (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketCors for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCors
func (c *S3) GetBucketCors(input *GetBucketCorsInput) (*GetBucketCorsOutput, error) {
	req, out := c.GetBucketCorsRequest(input)
	return out, req.Send()
}

// GetBucketCorsWithContext is the same as GetBucketCors with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketCors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketCorsWithContext(ctx aws.Context, input *GetBucketCorsInput, opts ...request.Option) (*GetBucketCorsOutput, error) {
	req, out := c.GetBucketCorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLifecycleConfiguration = "GetBucketLifecycleConfiguration"

// GetBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLifecycleConfiguration for more information on using the GetBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketLifecycleConfigurationRequest method.
//    req, resp := client.GetBucketLifecycleConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfiguration
func (c *S3) GetBucketLifecycleConfigurationRequest(input *GetBucketLifecycleConfigurationInput) (req *request.Request, output *GetBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLifecycleConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &GetBucketLifecycleConfigurationInput{}
	}

	output = &GetBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketLifecycleConfiguration API operation for Amazon Simple Storage Service.
//
//
// Bucket lifecycle configuration now supports specifying a lifecycle rule using
// an object key name prefix, one or more object tags, or a combination of both.
// Accordingly, this section describes the latest API. The response describes
// the new filter element that you can use to specify a filter to select a subset
// of objects to which the rule applies. If you are using a previous version
// of the lifecycle configuration, it still works. For the earlier action, see
// GetBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html).
//
// Returns the lifecycle configuration information set on the bucket. For information
// about lifecycle configuration, see Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html).
//
// To use this operation, you must have permission to perform the s3:GetLifecycleConfiguration
// action. The bucket owner has this permission, by default. The bucket owner
// can grant this permission to others. For more information about permissions,
// see Permissions Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// GetBucketLifecycleConfiguration has the following special error:
//
//    * Error code: NoSuchLifecycleConfiguration Description: The lifecycle
//    configuration does not exist. HTTP Status Code: 404 Not Found SOAP Fault
//    Code Prefix: Client
//
// The following operations are related to GetBucketLifecycleConfiguration:
//
//    * GetBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycle.html)
//
//    * PutBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html)
//
//    * DeleteBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfiguration
func (c *S3) GetBucketLifecycleConfiguration(input *GetBucketLifecycleConfigurationInput) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketLifecycleConfigurationWithContext is the same as GetBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketLifecycleConfigurationWithContext(ctx aws.Context, input *GetBucketLifecycleConfigurationInput, opts ...request.Option) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLocation = "GetBucketLocation"

// GetBucketLocationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLocation for more information on using the GetBucketLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketLocationRequest method.
//    req, resp := client.GetBucketLocationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocation
func (c *S3) GetBucketLocationRequest(input *GetBucketLocationInput) (req *request.Request, output *GetBucketLocationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?location",
	}

	if input == nil {
		input = &GetBucketLocationInput{}
	}

	output = &GetBucketLocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketLocation API operation for Amazon Simple Storage Service.
//
// Returns the Region the bucket resides in. You set the bucket's Region using
// the LocationConstraint request parameter in a CreateBucket request. For more
// information, see CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html).
//
// To use this implementation of the operation, you must be the bucket owner.
//
// The following operations are related to GetBucketLocation:
//
//    * GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//    * CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLocation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocation
func (c *S3) GetBucketLocation(input *GetBucketLocationInput) (*GetBucketLocationOutput, error) {
	req, out := c.GetBucketLocationRequest(input)
	return out, req.Send()
}

// GetBucketLocationWithContext is the same as GetBucketLocation with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketLocationWithContext(ctx aws.Context, input *GetBucketLocationInput, opts ...request.Option) (*GetBucketLocationOutput, error) {
	req, out := c.GetBucketLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLogging = "GetBucketLogging"

// GetBucketLoggingRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLogging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLogging for more information on using the GetBucketLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketLoggingRequest method.
//    req, resp := client.GetBucketLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLogging
func (c *S3) GetBucketLoggingRequest(input *GetBucketLoggingInput) (req *request.Request, output *GetBucketLoggingOutput) {
	op := &request.Operation{
		Name:       opGetBucketLogging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &GetBucketLoggingInput{}
	}

	output = &GetBucketLoggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketLogging API operation for Amazon Simple Storage Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLogging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLogging
func (c *S3) GetBucketLogging(input *GetBucketLoggingInput) (*GetBucketLoggingOutput, error) {
	req, out := c.GetBucketLoggingRequest(input)
	return out, req.Send()
}

// GetBucketLoggingWithContext is the same as GetBucketLogging with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketLoggingWithContext(ctx aws.Context, input *GetBucketLoggingInput, opts ...request.Option) (*GetBucketLoggingOutput, error) {
	req, out := c.GetBucketLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketProtectionConfiguration = "GetBucketProtectionConfiguration"

// GetBucketProtectionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketProtectionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketProtectionConfiguration for more information on using the GetBucketProtectionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketProtectionConfigurationRequest method.
//    req, resp := client.GetBucketProtectionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketProtectionConfiguration
func (c *S3) GetBucketProtectionConfigurationRequest(input *GetBucketProtectionConfigurationInput) (req *request.Request, output *GetBucketProtectionConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketProtectionConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?protection",
	}

	if input == nil {
		input = &GetBucketProtectionConfigurationInput{}
	}

	output = &GetBucketProtectionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketProtectionConfiguration API operation for Amazon Simple Storage Service.
//
// Returns the protection configuration of a bucket.EnablePermanentRetention
// flag will only be returned if the flag is set to true for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketProtectionConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketProtectionConfiguration
func (c *S3) GetBucketProtectionConfiguration(input *GetBucketProtectionConfigurationInput) (*GetBucketProtectionConfigurationOutput, error) {
	req, out := c.GetBucketProtectionConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketProtectionConfigurationWithContext is the same as GetBucketProtectionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketProtectionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketProtectionConfigurationWithContext(ctx aws.Context, input *GetBucketProtectionConfigurationInput, opts ...request.Option) (*GetBucketProtectionConfigurationOutput, error) {
	req, out := c.GetBucketProtectionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketVersioning = "GetBucketVersioning"

// GetBucketVersioningRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketVersioning operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketVersioning for more information on using the GetBucketVersioning
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketVersioningRequest method.
//    req, resp := client.GetBucketVersioningRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioning
func (c *S3) GetBucketVersioningRequest(input *GetBucketVersioningInput) (req *request.Request, output *GetBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opGetBucketVersioning,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &GetBucketVersioningInput{}
	}

	output = &GetBucketVersioningOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketVersioning API operation for Amazon Simple Storage Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketVersioning for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioning
func (c *S3) GetBucketVersioning(input *GetBucketVersioningInput) (*GetBucketVersioningOutput, error) {
	req, out := c.GetBucketVersioningRequest(input)
	return out, req.Send()
}

// GetBucketVersioningWithContext is the same as GetBucketVersioning with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketVersioning for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketVersioningWithContext(ctx aws.Context, input *GetBucketVersioningInput, opts ...request.Option) (*GetBucketVersioningOutput, error) {
	req, out := c.GetBucketVersioningRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketWebsite = "GetBucketWebsite"

// GetBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketWebsite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketWebsite for more information on using the GetBucketWebsite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketWebsiteRequest method.
//    req, resp := client.GetBucketWebsiteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsite
func (c *S3) GetBucketWebsiteRequest(input *GetBucketWebsiteInput) (req *request.Request, output *GetBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opGetBucketWebsite,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &GetBucketWebsiteInput{}
	}

	output = &GetBucketWebsiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketWebsite API operation for Amazon Simple Storage Service.
//
// Returns the website configuration for a bucket. To host website on Amazon
// S3, you can configure a bucket as website by adding a website configuration.
// For more information about hosting websites, see Hosting Websites on Amazon
// S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
//
// This GET action requires the S3:GetBucketWebsite permission. By default,
// only the bucket owner can read the bucket website configuration. However,
// bucket owners can allow other users to read the website configuration by
// writing a bucket policy granting them the S3:GetBucketWebsite permission.
//
// The following operations are related to DeleteBucketWebsite:
//
//    * DeleteBucketWebsite (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketWebsite.html)
//
//    * PutBucketWebsite (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketWebsite.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketWebsite for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsite
func (c *S3) GetBucketWebsite(input *GetBucketWebsiteInput) (*GetBucketWebsiteOutput, error) {
	req, out := c.GetBucketWebsiteRequest(input)
	return out, req.Send()
}

// GetBucketWebsiteWithContext is the same as GetBucketWebsite with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketWebsite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketWebsiteWithContext(ctx aws.Context, input *GetBucketWebsiteInput, opts ...request.Option) (*GetBucketWebsiteOutput, error) {
	req, out := c.GetBucketWebsiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObject = "GetObject"

// GetObjectRequest generates a "aws/request.Request" representing the
// client's request for the GetObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObject for more information on using the GetObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetObjectRequest method.
//    req, resp := client.GetObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObject
func (c *S3) GetObjectRequest(input *GetObjectInput) (req *request.Request, output *GetObjectOutput) {
	op := &request.Operation{
		Name:       opGetObject,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &GetObjectInput{}
	}

	output = &GetObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObject API operation for Amazon Simple Storage Service.
//
// Retrieves objects from Amazon S3. To use GET, you must have READ access to
// the object. If you grant READ access to the anonymous user, you can return
// the object without using an authorization header.
//
// An Amazon S3 bucket has no directory hierarchy such as you would find in
// a typical computer file system. You can, however, create a logical hierarchy
// by using object key names that imply a folder structure. For example, instead
// of naming an object sample.jpg, you can name it photos/2006/February/sample.jpg.
//
// To get an object from such a logical hierarchy, specify the full key name
// for the object in the GET operation. For a virtual hosted-style request example,
// if you have the object photos/2006/February/sample.jpg, specify the resource
// as /photos/2006/February/sample.jpg. For a path-style request example, if
// you have the object photos/2006/February/sample.jpg in the bucket named examplebucket,
// specify the resource as /examplebucket/photos/2006/February/sample.jpg. For
// more information about request types, see HTTP Host Header Bucket Specification
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html#VirtualHostingSpecifyBucket).
//
// To distribute large files to many people, you can save bandwidth costs by
// using BitTorrent. For more information, see Amazon S3 Torrent (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3Torrent.html).
// For more information about returning the ACL of an object, see GetObjectAcl
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html).
//
// If the object you are retrieving is stored in the S3 Glacier or S3 Glacier
// Deep Archive storage class, or S3 Intelligent-Tiering Archive or S3 Intelligent-Tiering
// Deep Archive tiers, before you can retrieve the object you must first restore
// a copy using RestoreObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html).
// Otherwise, this action returns an InvalidObjectStateError error. For information
// about restoring archived objects, see Restoring Archived Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html).
//
// Encryption request headers, like x-amz-server-side-encryption, should not
// be sent for GET requests if your object uses server-side encryption with
// CMKs stored in AWS KMS (SSE-KMS) or server-side encryption with Amazon S3–managed
// encryption keys (SSE-S3). If your object does use these types of keys, you’ll
// get an HTTP 400 BadRequest error.
//
// If you encrypt an object by using server-side encryption with customer-provided
// encryption keys (SSE-C) when you store the object in Amazon S3, then when
// you GET the object, you must use the following headers:
//
//    * x-amz-server-side-encryption-customer-algorithm
//
//    * x-amz-server-side-encryption-customer-key
//
//    * x-amz-server-side-encryption-customer-key-MD5
//
// For more information about SSE-C, see Server-Side Encryption (Using Customer-Provided
// Encryption Keys) (https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html).
//
// Assuming you have permission to read object tags (permission for the s3:GetObjectVersionTagging
// action), the response also returns the x-amz-tagging-count header that provides
// the count of number of tags associated with the object. You can use GetObjectTagging
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html)
// to retrieve the tag set associated with an object.
//
// Permissions
//
// You need the s3:GetObject permission for this operation. For more information,
// see Specifying Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html).
// If the object you request does not exist, the error Amazon S3 returns depends
// on whether you also have the s3:ListBucket permission.
//
//    * If you have the s3:ListBucket permission on the bucket, Amazon S3 will
//    return an HTTP status code 404 ("no such key") error.
//
//    * If you don’t have the s3:ListBucket permission, Amazon S3 will return
//    an HTTP status code 403 ("access denied") error.
//
// Versioning
//
// By default, the GET action returns the current version of an object. To return
// a different version, use the versionId subresource.
//
// If the current version of the object is a delete marker, Amazon S3 behaves
// as if the object was deleted and includes x-amz-delete-marker: true in the
// response.
//
// For more information about versioning, see PutBucketVersioning (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketVersioning.html).
//
// Overriding Response Header Values
//
// There are times when you want to override certain response header values
// in a GET response. For example, you might override the Content-Disposition
// response header value in your GET request.
//
// You can override values for a set of response headers using the following
// query parameters. These response header values are sent only on a successful
// request, that is, when status code 200 OK is returned. The set of headers
// you can override using these parameters is a subset of the headers that Amazon
// S3 accepts when you create an object. The response headers that you can override
// for the GET response are Content-Type, Content-Language, Expires, Cache-Control,
// Content-Disposition, and Content-Encoding. To override these header values
// in the GET response, you use the following request parameters.
//
// You must sign the request, either using an Authorization header or a presigned
// URL, when using these parameters. They cannot be used with an unsigned (anonymous)
// request.
//
//    * response-content-type
//
//    * response-content-language
//
//    * response-expires
//
//    * response-cache-control
//
//    * response-content-disposition
//
//    * response-content-encoding
//
// Additional Considerations about Request Headers
//
// If both of the If-Match and If-Unmodified-Since headers are present in the
// request as follows: If-Match condition evaluates to true, and; If-Unmodified-Since
// condition evaluates to false; then, S3 returns 200 OK and the data requested.
//
// If both of the If-None-Match and If-Modified-Since headers are present in
// the request as follows:If-None-Match condition evaluates to false, and; If-Modified-Since
// condition evaluates to true; then, S3 returns 304 Not Modified response code.
//
// For more information about conditional requests, see RFC 7232 (https://tools.ietf.org/html/rfc7232).
//
// The following operations are related to GetObject:
//
//    * ListBuckets (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html)
//
//    * GetObjectAcl (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchKey "NoSuchKey"
//   The specified key does not exist.
//
//   * ErrCodeInvalidObjectState "InvalidObjectState"
//   Object is archived and inaccessible until restored.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObject
func (c *S3) GetObject(input *GetObjectInput) (*GetObjectOutput, error) {
	req, out := c.GetObjectRequest(input)
	return out, req.Send()
}

// GetObjectWithContext is the same as GetObject with the addition of
// the ability to pass a context and additional request options.
//
// See GetObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectWithContext(ctx aws.Context, input *GetObjectInput, opts ...request.Option) (*GetObjectOutput, error) {
	req, out := c.GetObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectAcl = "GetObjectAcl"

// GetObjectAclRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectAcl for more information on using the GetObjectAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetObjectAclRequest method.
//    req, resp := client.GetObjectAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAcl
func (c *S3) GetObjectAclRequest(input *GetObjectAclInput) (req *request.Request, output *GetObjectAclOutput) {
	op := &request.Operation{
		Name:       opGetObjectAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &GetObjectAclInput{}
	}

	output = &GetObjectAclOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectAcl API operation for Amazon Simple Storage Service.
//
// Returns the access control list (ACL) of an object. To use this operation,
// you must have READ_ACP access to the object.
//
// This action is not supported by Amazon S3 on Outposts.
//
// Versioning
//
// By default, GET returns ACL information about the current version of an object.
// To return ACL information about a different version, use the versionId subresource.
//
// The following operations are related to GetObjectAcl:
//
//    * GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//    * DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
//    * PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectAcl for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchKey "NoSuchKey"
//   The specified key does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAcl
func (c *S3) GetObjectAcl(input *GetObjectAclInput) (*GetObjectAclOutput, error) {
	req, out := c.GetObjectAclRequest(input)
	return out, req.Send()
}

// GetObjectAclWithContext is the same as GetObjectAcl with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectAclWithContext(ctx aws.Context, input *GetObjectAclInput, opts ...request.Option) (*GetObjectAclOutput, error) {
	req, out := c.GetObjectAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectTagging = "GetObjectTagging"

// GetObjectTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectTagging for more information on using the GetObjectTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetObjectTaggingRequest method.
//    req, resp := client.GetObjectTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTagging
func (c *S3) GetObjectTaggingRequest(input *GetObjectTaggingInput) (req *request.Request, output *GetObjectTaggingOutput) {
	op := &request.Operation{
		Name:       opGetObjectTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &GetObjectTaggingInput{}
	}

	output = &GetObjectTaggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectTagging API operation for Amazon Simple Storage Service.
//
// Returns the tag-set of an object. You send the GET request against the tagging
// subresource associated with the object.
//
// To use this operation, you must have permission to perform the s3:GetObjectTagging
// action. By default, the GET action returns information about current version
// of an object. For a versioned bucket, you can have multiple versions of an
// object in your bucket. To retrieve tags of any other version, use the versionId
// query parameter. You also need permission for the s3:GetObjectVersionTagging
// action.
//
// By default, the bucket owner has this permission and can grant this permission
// to others.
//
// For information about the Amazon S3 object tagging feature, see Object Tagging
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html).
//
// The following action is related to GetObjectTagging:
//
//    * PutObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html)
//
//    * DeleteObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTagging
func (c *S3) GetObjectTagging(input *GetObjectTaggingInput) (*GetObjectTaggingOutput, error) {
	req, out := c.GetObjectTaggingRequest(input)
	return out, req.Send()
}

// GetObjectTaggingWithContext is the same as GetObjectTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectTaggingWithContext(ctx aws.Context, input *GetObjectTaggingInput, opts ...request.Option) (*GetObjectTaggingOutput, error) {
	req, out := c.GetObjectTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicAccessBlock = "GetPublicAccessBlock"

// GetPublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicAccessBlock for more information on using the GetPublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPublicAccessBlockRequest method.
//    req, resp := client.GetPublicAccessBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetPublicAccessBlock
func (c *S3) GetPublicAccessBlockRequest(input *GetPublicAccessBlockInput) (req *request.Request, output *GetPublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opGetPublicAccessBlock,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?publicAccessBlock",
	}

	if input == nil {
		input = &GetPublicAccessBlockInput{}
	}

	output = &GetPublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPublicAccessBlock API operation for Amazon Simple Storage Service.
//
// Retrieves the PublicAccessBlock configuration for an Amazon S3 bucket. To
// use this operation, you must have the s3:GetBucketPublicAccessBlock permission.
// For more information about Amazon S3 permissions, see Specifying Permissions
// in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html).
//
// When Amazon S3 evaluates the PublicAccessBlock configuration for a bucket
// or an object, it checks the PublicAccessBlock configuration for both the
// bucket (or the bucket that contains the object) and the bucket owner's account.
// If the PublicAccessBlock settings are different between the bucket and the
// account, Amazon S3 uses the most restrictive combination of the bucket-level
// and account-level settings.
//
// For more information about when Amazon S3 considers a bucket or an object
// public, see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status).
//
// The following operations are related to GetPublicAccessBlock:
//
//    * Using Amazon S3 Block Public Access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
//
//    * PutPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutPublicAccessBlock.html)
//
//    * GetPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html)
//
//    * DeletePublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetPublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetPublicAccessBlock
func (c *S3) GetPublicAccessBlock(input *GetPublicAccessBlockInput) (*GetPublicAccessBlockOutput, error) {
	req, out := c.GetPublicAccessBlockRequest(input)
	return out, req.Send()
}

// GetPublicAccessBlockWithContext is the same as GetPublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetPublicAccessBlockWithContext(ctx aws.Context, input *GetPublicAccessBlockInput, opts ...request.Option) (*GetPublicAccessBlockOutput, error) {
	req, out := c.GetPublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opHeadBucket = "HeadBucket"

// HeadBucketRequest generates a "aws/request.Request" representing the
// client's request for the HeadBucket operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See HeadBucket for more information on using the HeadBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the HeadBucketRequest method.
//    req, resp := client.HeadBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucket
func (c *S3) HeadBucketRequest(input *HeadBucketInput) (req *request.Request, output *HeadBucketOutput) {
	op := &request.Operation{
		Name:       opHeadBucket,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &HeadBucketInput{}
	}

	output = &HeadBucketOutput{}
	req = c.newRequest(op, input, output)
	return
}

// HeadBucket API operation for Amazon Simple Storage Service.
//
// This action is useful to determine if a bucket exists and you have permission
// to access it. The action returns a 200 OK if the bucket exists and you have
// permission to access it.
//
// If the bucket does not exist or you do not have permission to access it,
// the HEAD request returns a generic 404 Not Found or 403 Forbidden code. A
// message body is not included, so you cannot determine the exception beyond
// these error codes.
//
// To use this operation, you must have permissions to perform the s3:ListBucket
// action. The bucket owner has this permission by default and can grant this
// permission to others. For more information about permissions, see Permissions
// Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation HeadBucket for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchBucket "NoSuchBucket"
//   The specified bucket does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucket
func (c *S3) HeadBucket(input *HeadBucketInput) (*HeadBucketOutput, error) {
	req, out := c.HeadBucketRequest(input)
	return out, req.Send()
}

// HeadBucketWithContext is the same as HeadBucket with the addition of
// the ability to pass a context and additional request options.
//
// See HeadBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) HeadBucketWithContext(ctx aws.Context, input *HeadBucketInput, opts ...request.Option) (*HeadBucketOutput, error) {
	req, out := c.HeadBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opHeadObject = "HeadObject"

// HeadObjectRequest generates a "aws/request.Request" representing the
// client's request for the HeadObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See HeadObject for more information on using the HeadObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the HeadObjectRequest method.
//    req, resp := client.HeadObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObject
func (c *S3) HeadObjectRequest(input *HeadObjectInput) (req *request.Request, output *HeadObjectOutput) {
	op := &request.Operation{
		Name:       opHeadObject,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &HeadObjectInput{}
	}

	output = &HeadObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// HeadObject API operation for Amazon Simple Storage Service.
//
// The HEAD action retrieves metadata from an object without returning the object
// itself. This action is useful if you're only interested in an object's metadata.
// To use HEAD, you must have READ access to the object.
//
// A HEAD request has the same options as a GET action on an object. The response
// is identical to the GET response except that there is no response body. Because
// of this, if the HEAD request generates an error, it returns a generic 404
// Not Found or 403 Forbidden code. It is not possible to retrieve the exact
// exception beyond these error codes.
//
// If you encrypt an object by using server-side encryption with customer-provided
// encryption keys (SSE-C) when you store the object in Amazon S3, then when
// you retrieve the metadata from the object, you must use the following headers:
//
//    * x-amz-server-side-encryption-customer-algorithm
//
//    * x-amz-server-side-encryption-customer-key
//
//    * x-amz-server-side-encryption-customer-key-MD5
//
// For more information about SSE-C, see Server-Side Encryption (Using Customer-Provided
// Encryption Keys) (https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html).
//
//    * Encryption request headers, like x-amz-server-side-encryption, should
//    not be sent for GET requests if your object uses server-side encryption
//    with CMKs stored in AWS KMS (SSE-KMS) or server-side encryption with Amazon
//    S3–managed encryption keys (SSE-S3). If your object does use these types
//    of keys, you’ll get an HTTP 400 BadRequest error.
//
//    * The last modified property in this case is the creation date of the
//    object.
//
// Request headers are limited to 8 KB in size. For more information, see Common
// Request Headers (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonRequestHeaders.html).
//
// Consider the following when using request headers:
//
//    * Consideration 1 – If both of the If-Match and If-Unmodified-Since
//    headers are present in the request as follows: If-Match condition evaluates
//    to true, and; If-Unmodified-Since condition evaluates to false; Then Amazon
//    S3 returns 200 OK and the data requested.
//
//    * Consideration 2 – If both of the If-None-Match and If-Modified-Since
//    headers are present in the request as follows: If-None-Match condition
//    evaluates to false, and; If-Modified-Since condition evaluates to true;
//    Then Amazon S3 returns the 304 Not Modified response code.
//
// For more information about conditional requests, see RFC 7232 (https://tools.ietf.org/html/rfc7232).
//
// Permissions
//
// You need the s3:GetObject permission for this operation. For more information,
// see Specifying Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html).
// If the object you request does not exist, the error Amazon S3 returns depends
// on whether you also have the s3:ListBucket permission.
//
//    * If you have the s3:ListBucket permission on the bucket, Amazon S3 returns
//    an HTTP status code 404 ("no such key") error.
//
//    * If you don’t have the s3:ListBucket permission, Amazon S3 returns
//    an HTTP status code 403 ("access denied") error.
//
// The following action is related to HeadObject:
//
//    * GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
// See http://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#RESTErrorResponses
// for more information on returned errors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation HeadObject for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObject
func (c *S3) HeadObject(input *HeadObjectInput) (*HeadObjectOutput, error) {
	req, out := c.HeadObjectRequest(input)
	return out, req.Send()
}

// HeadObjectWithContext is the same as HeadObject with the addition of
// the ability to pass a context and additional request options.
//
// See HeadObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) HeadObjectWithContext(ctx aws.Context, input *HeadObjectInput, opts ...request.Option) (*HeadObjectOutput, error) {
	req, out := c.HeadObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBuckets = "ListBuckets"

// ListBucketsRequest generates a "aws/request.Request" representing the
// client's request for the ListBuckets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuckets for more information on using the ListBuckets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBucketsRequest method.
//    req, resp := client.ListBucketsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBuckets
func (c *S3) ListBucketsRequest(input *ListBucketsInput) (req *request.Request, output *ListBucketsOutput) {
	op := &request.Operation{
		Name:       opListBuckets,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBucketsInput{}
	}

	output = &ListBucketsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuckets API operation for Amazon Simple Storage Service.
//
// Returns a list of all buckets owned by the authenticated sender of the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBuckets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBuckets
func (c *S3) ListBuckets(input *ListBucketsInput) (*ListBucketsOutput, error) {
	req, out := c.ListBucketsRequest(input)
	return out, req.Send()
}

// ListBucketsWithContext is the same as ListBuckets with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuckets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketsWithContext(ctx aws.Context, input *ListBucketsInput, opts ...request.Option) (*ListBucketsOutput, error) {
	req, out := c.ListBucketsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBucketsExtended = "ListBucketsExtended"

// ListBucketsExtendedRequest generates a "aws/request.Request" representing the
// client's request for the ListBucketsExtended operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBucketsExtended for more information on using the ListBucketsExtended
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBucketsExtendedRequest method.
//    req, resp := client.ListBucketsExtendedRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketsExtended
func (c *S3) ListBucketsExtendedRequest(input *ListBucketsExtendedInput) (req *request.Request, output *ListBucketsExtendedOutput) {
	op := &request.Operation{
		Name:       opListBucketsExtended,
		HTTPMethod: "GET",
		HTTPPath:   "/?extended",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Buckets[-1].Name"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListBucketsExtendedInput{}
	}

	output = &ListBucketsExtendedOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBucketsExtended API operation for Amazon Simple Storage Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBucketsExtended for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketsExtended
func (c *S3) ListBucketsExtended(input *ListBucketsExtendedInput) (*ListBucketsExtendedOutput, error) {
	req, out := c.ListBucketsExtendedRequest(input)
	return out, req.Send()
}

// ListBucketsExtendedWithContext is the same as ListBucketsExtended with the addition of
// the ability to pass a context and additional request options.
//
// See ListBucketsExtended for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketsExtendedWithContext(ctx aws.Context, input *ListBucketsExtendedInput, opts ...request.Option) (*ListBucketsExtendedOutput, error) {
	req, out := c.ListBucketsExtendedRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBucketsExtendedPages iterates over the pages of a ListBucketsExtended operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBucketsExtended method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBucketsExtended operation.
//    pageNum := 0
//    err := client.ListBucketsExtendedPages(params,
//        func(page *s3.ListBucketsExtendedOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListBucketsExtendedPages(input *ListBucketsExtendedInput, fn func(*ListBucketsExtendedOutput, bool) bool) error {
	return c.ListBucketsExtendedPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBucketsExtendedPagesWithContext same as ListBucketsExtendedPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketsExtendedPagesWithContext(ctx aws.Context, input *ListBucketsExtendedInput, fn func(*ListBucketsExtendedOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBucketsExtendedInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBucketsExtendedRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBucketsExtendedOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLegalHolds = "ListLegalHolds"

// ListLegalHoldsRequest generates a "aws/request.Request" representing the
// client's request for the ListLegalHolds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLegalHolds for more information on using the ListLegalHolds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLegalHoldsRequest method.
//    req, resp := client.ListLegalHoldsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListLegalHolds
func (c *S3) ListLegalHoldsRequest(input *ListLegalHoldsInput) (req *request.Request, output *ListLegalHoldsOutput) {
	op := &request.Operation{
		Name:       opListLegalHolds,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?legalHold",
	}

	if input == nil {
		input = &ListLegalHoldsInput{}
	}

	output = &ListLegalHoldsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLegalHolds API operation for Amazon Simple Storage Service.
//
// Returns a list of legal holds on an object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListLegalHolds for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListLegalHolds
func (c *S3) ListLegalHolds(input *ListLegalHoldsInput) (*ListLegalHoldsOutput, error) {
	req, out := c.ListLegalHoldsRequest(input)
	return out, req.Send()
}

// ListLegalHoldsWithContext is the same as ListLegalHolds with the addition of
// the ability to pass a context and additional request options.
//
// See ListLegalHolds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListLegalHoldsWithContext(ctx aws.Context, input *ListLegalHoldsInput, opts ...request.Option) (*ListLegalHoldsOutput, error) {
	req, out := c.ListLegalHoldsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMultipartUploads = "ListMultipartUploads"

// ListMultipartUploadsRequest generates a "aws/request.Request" representing the
// client's request for the ListMultipartUploads operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMultipartUploads for more information on using the ListMultipartUploads
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMultipartUploadsRequest method.
//    req, resp := client.ListMultipartUploadsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploads
func (c *S3) ListMultipartUploadsRequest(input *ListMultipartUploadsInput) (req *request.Request, output *ListMultipartUploadsOutput) {
	op := &request.Operation{
		Name:       opListMultipartUploads,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?uploads",
		Paginator: &request.Paginator{
			InputTokens:     []string{"KeyMarker", "UploadIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextUploadIdMarker"},
			LimitToken:      "MaxUploads",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListMultipartUploadsInput{}
	}

	output = &ListMultipartUploadsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMultipartUploads API operation for Amazon Simple Storage Service.
//
// This action lists in-progress multipart uploads. An in-progress multipart
// upload is a multipart upload that has been initiated using the Initiate Multipart
// Upload request, but has not yet been completed or aborted.
//
// This action returns at most 1,000 multipart uploads in the response. 1,000
// multipart uploads is the maximum number of uploads a response can include,
// which is also the default value. You can further limit the number of uploads
// in a response by specifying the max-uploads parameter in the response. If
// additional multipart uploads satisfy the list criteria, the response will
// contain an IsTruncated element with the value true. To list the additional
// multipart uploads, use the key-marker and upload-id-marker request parameters.
//
// In the response, the uploads are sorted by key. If your application has initiated
// more than one multipart upload using the same object key, then uploads in
// the response are first sorted by key. Additionally, uploads are sorted in
// ascending order within each key by the upload initiation time.
//
// For more information on multipart uploads, see Uploading Objects Using Multipart
// Upload (https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html).
//
// For information on permissions required to use the multipart upload API,
// see Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html).
//
// The following operations are related to ListMultipartUploads:
//
//    * CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//    * UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//    * CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//    * ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//    * AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListMultipartUploads for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploads
func (c *S3) ListMultipartUploads(input *ListMultipartUploadsInput) (*ListMultipartUploadsOutput, error) {
	req, out := c.ListMultipartUploadsRequest(input)
	return out, req.Send()
}

// ListMultipartUploadsWithContext is the same as ListMultipartUploads with the addition of
// the ability to pass a context and additional request options.
//
// See ListMultipartUploads for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListMultipartUploadsWithContext(ctx aws.Context, input *ListMultipartUploadsInput, opts ...request.Option) (*ListMultipartUploadsOutput, error) {
	req, out := c.ListMultipartUploadsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMultipartUploadsPages iterates over the pages of a ListMultipartUploads operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMultipartUploads method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMultipartUploads operation.
//    pageNum := 0
//    err := client.ListMultipartUploadsPages(params,
//        func(page *s3.ListMultipartUploadsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListMultipartUploadsPages(input *ListMultipartUploadsInput, fn func(*ListMultipartUploadsOutput, bool) bool) error {
	return c.ListMultipartUploadsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMultipartUploadsPagesWithContext same as ListMultipartUploadsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListMultipartUploadsPagesWithContext(ctx aws.Context, input *ListMultipartUploadsInput, fn func(*ListMultipartUploadsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMultipartUploadsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMultipartUploadsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMultipartUploadsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListObjectVersions = "ListObjectVersions"

// ListObjectVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListObjectVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectVersions for more information on using the ListObjectVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListObjectVersionsRequest method.
//    req, resp := client.ListObjectVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersions
func (c *S3) ListObjectVersionsRequest(input *ListObjectVersionsInput) (req *request.Request, output *ListObjectVersionsOutput) {
	op := &request.Operation{
		Name:       opListObjectVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"KeyMarker", "VersionIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextVersionIdMarker"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectVersionsInput{}
	}

	output = &ListObjectVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectVersions API operation for Amazon Simple Storage Service.
//
// Returns metadata about all versions of the objects in a bucket. You can also
// use request parameters as selection criteria to return metadata about a subset
// of all the object versions.
//
// To use this operation, you must have permissions to perform the s3:ListBucketVersions
// action. Be aware of the name difference.
//
// A 200 OK response can contain valid or invalid XML. Make sure to design your
// application to parse the contents of the response and handle it appropriately.
//
// To use this operation, you must have READ access to the bucket.
//
// This action is not supported by Amazon S3 on Outposts.
//
// The following operations are related to ListObjectVersions:
//
//    * ListObjectsV2 (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html)
//
//    * GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//    * PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//    * DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjectVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersions
func (c *S3) ListObjectVersions(input *ListObjectVersionsInput) (*ListObjectVersionsOutput, error) {
	req, out := c.ListObjectVersionsRequest(input)
	return out, req.Send()
}

// ListObjectVersionsWithContext is the same as ListObjectVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectVersionsWithContext(ctx aws.Context, input *ListObjectVersionsInput, opts ...request.Option) (*ListObjectVersionsOutput, error) {
	req, out := c.ListObjectVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectVersionsPages iterates over the pages of a ListObjectVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectVersions operation.
//    pageNum := 0
//    err := client.ListObjectVersionsPages(params,
//        func(page *s3.ListObjectVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListObjectVersionsPages(input *ListObjectVersionsInput, fn func(*ListObjectVersionsOutput, bool) bool) error {
	return c.ListObjectVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectVersionsPagesWithContext same as ListObjectVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectVersionsPagesWithContext(ctx aws.Context, input *ListObjectVersionsInput, fn func(*ListObjectVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListObjectVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListObjects = "ListObjects"

// ListObjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListObjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjects for more information on using the ListObjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListObjectsRequest method.
//    req, resp := client.ListObjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjects
func (c *S3) ListObjectsRequest(input *ListObjectsInput) (req *request.Request, output *ListObjectsOutput) {
	op := &request.Operation{
		Name:       opListObjects,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker || Contents[-1].Key"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectsInput{}
	}

	output = &ListObjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjects API operation for Amazon Simple Storage Service.
//
// Returns some or all (up to 1,000) of the objects in a bucket. You can use
// the request parameters as selection criteria to return a subset of the objects
// in a bucket. A 200 OK response can contain valid or invalid XML. Be sure
// to design your application to parse the contents of the response and handle
// it appropriately.
//
// This action has been revised. We recommend that you use the newer version,
// ListObjectsV2 (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html),
// when developing applications. For backward compatibility, Amazon S3 continues
// to support ListObjects.
//
// The following operations are related to ListObjects:
//
//    * ListObjectsV2 (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html)
//
//    * GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//    * PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//    * CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//    * ListBuckets (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchBucket "NoSuchBucket"
//   The specified bucket does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjects
func (c *S3) ListObjects(input *ListObjectsInput) (*ListObjectsOutput, error) {
	req, out := c.ListObjectsRequest(input)
	return out, req.Send()
}

// ListObjectsWithContext is the same as ListObjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsWithContext(ctx aws.Context, input *ListObjectsInput, opts ...request.Option) (*ListObjectsOutput, error) {
	req, out := c.ListObjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectsPages iterates over the pages of a ListObjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjects operation.
//    pageNum := 0
//    err := client.ListObjectsPages(params,
//        func(page *s3.ListObjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListObjectsPages(input *ListObjectsInput, fn func(*ListObjectsOutput, bool) bool) error {
	return c.ListObjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectsPagesWithContext same as ListObjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsPagesWithContext(ctx aws.Context, input *ListObjectsInput, fn func(*ListObjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListObjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListObjectsV2 = "ListObjectsV2"

// ListObjectsV2Request generates a "aws/request.Request" representing the
// client's request for the ListObjectsV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectsV2 for more information on using the ListObjectsV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListObjectsV2Request method.
//    req, resp := client.ListObjectsV2Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2
func (c *S3) ListObjectsV2Request(input *ListObjectsV2Input) (req *request.Request, output *ListObjectsV2Output) {
	op := &request.Operation{
		Name:       opListObjectsV2,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?list-type=2",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ContinuationToken"},
			OutputTokens:    []string{"NextContinuationToken"},
			LimitToken:      "MaxKeys",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectsV2Input{}
	}

	output = &ListObjectsV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectsV2 API operation for Amazon Simple Storage Service.
//
// Returns some or all (up to 1,000) of the objects in a bucket. You can use
// the request parameters as selection criteria to return a subset of the objects
// in a bucket. A 200 OK response can contain valid or invalid XML. Make sure
// to design your application to parse the contents of the response and handle
// it appropriately. Objects are returned sorted in an ascending order of the
// respective key names in the list.
//
// To use this operation, you must have READ access to the bucket.
//
// To use this action in an AWS Identity and Access Management (IAM) policy,
// you must have permissions to perform the s3:ListBucket action. The bucket
// owner has this permission by default and can grant this permission to others.
// For more information about permissions, see Permissions Related to Bucket
// Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// This section describes the latest revision of this action. We recommend that
// you use this revised API for application development. For backward compatibility,
// Amazon S3 continues to support the prior version of this API, ListObjects
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjects.html).
//
// To get a list of your buckets, see ListBuckets (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListBuckets.html).
//
// The following operations are related to ListObjectsV2:
//
//    * GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
//    * PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//
//    * CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjectsV2 for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchBucket "NoSuchBucket"
//   The specified bucket does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2
func (c *S3) ListObjectsV2(input *ListObjectsV2Input) (*ListObjectsV2Output, error) {
	req, out := c.ListObjectsV2Request(input)
	return out, req.Send()
}

// ListObjectsV2WithContext is the same as ListObjectsV2 with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectsV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsV2WithContext(ctx aws.Context, input *ListObjectsV2Input, opts ...request.Option) (*ListObjectsV2Output, error) {
	req, out := c.ListObjectsV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectsV2Pages iterates over the pages of a ListObjectsV2 operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectsV2 method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectsV2 operation.
//    pageNum := 0
//    err := client.ListObjectsV2Pages(params,
//        func(page *s3.ListObjectsV2Output, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListObjectsV2Pages(input *ListObjectsV2Input, fn func(*ListObjectsV2Output, bool) bool) error {
	return c.ListObjectsV2PagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectsV2PagesWithContext same as ListObjectsV2Pages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsV2PagesWithContext(ctx aws.Context, input *ListObjectsV2Input, fn func(*ListObjectsV2Output, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectsV2Input
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectsV2Request(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListObjectsV2Output), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListParts = "ListParts"

// ListPartsRequest generates a "aws/request.Request" representing the
// client's request for the ListParts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListParts for more information on using the ListParts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPartsRequest method.
//    req, resp := client.ListPartsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListParts
func (c *S3) ListPartsRequest(input *ListPartsInput) (req *request.Request, output *ListPartsOutput) {
	op := &request.Operation{
		Name:       opListParts,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PartNumberMarker"},
			OutputTokens:    []string{"NextPartNumberMarker"},
			LimitToken:      "MaxParts",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListPartsInput{}
	}

	output = &ListPartsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListParts API operation for Amazon Simple Storage Service.
//
// Lists the parts that have been uploaded for a specific multipart upload.
// This operation must include the upload ID, which you obtain by sending the
// initiate multipart upload request (see CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)).
// This request returns a maximum of 1,000 uploaded parts. The default number
// of parts returned is 1,000 parts. You can restrict the number of parts returned
// by specifying the max-parts request parameter. If your multipart upload consists
// of more than 1,000 parts, the response returns an IsTruncated field with
// the value of true, and a NextPartNumberMarker element. In subsequent ListParts
// requests you can include the part-number-marker query string parameter and
// set its value to the NextPartNumberMarker field value from the previous response.
//
// For more information on multipart uploads, see Uploading Objects Using Multipart
// Upload (https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html).
//
// For information on permissions required to use the multipart upload API,
// see Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html).
//
// The following operations are related to ListParts:
//
//    * CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//    * UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//    * CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//    * AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
//    * ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListParts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListParts
func (c *S3) ListParts(input *ListPartsInput) (*ListPartsOutput, error) {
	req, out := c.ListPartsRequest(input)
	return out, req.Send()
}

// ListPartsWithContext is the same as ListParts with the addition of
// the ability to pass a context and additional request options.
//
// See ListParts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListPartsWithContext(ctx aws.Context, input *ListPartsInput, opts ...request.Option) (*ListPartsOutput, error) {
	req, out := c.ListPartsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPartsPages iterates over the pages of a ListParts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListParts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListParts operation.
//    pageNum := 0
//    err := client.ListPartsPages(params,
//        func(page *s3.ListPartsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListPartsPages(input *ListPartsInput, fn func(*ListPartsOutput, bool) bool) error {
	return c.ListPartsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPartsPagesWithContext same as ListPartsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListPartsPagesWithContext(ctx aws.Context, input *ListPartsInput, fn func(*ListPartsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPartsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPartsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPartsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutBucketAcl = "PutBucketAcl"

// PutBucketAclRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketAcl for more information on using the PutBucketAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketAclRequest method.
//    req, resp := client.PutBucketAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAcl
func (c *S3) PutBucketAclRequest(input *PutBucketAclInput) (req *request.Request, output *PutBucketAclOutput) {
	op := &request.Operation{
		Name:       opPutBucketAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &PutBucketAclInput{}
	}

	output = &PutBucketAclOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketAcl API operation for Amazon Simple Storage Service.
//
// Sets the permissions on an existing bucket using access control lists (ACL).
// For more information, see Using ACLs (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html).
// To set the ACL of a bucket, you must have WRITE_ACP permission.
//
// You can use one of the following two ways to set a bucket's permissions:
//
//    * Specify the ACL in the request body
//
//    * Specify permissions using request headers
//
// You cannot specify access permission using both the body and the request
// headers.
//
// Depending on your application needs, you may choose to set the ACL on a bucket
// using either the request body or the headers. For example, if you have an
// existing application that updates a bucket ACL using the request body, then
// you can continue to use that approach.
//
// Access Permissions
//
// You can set access permissions using one of the following methods:
//
//    * Specify a canned ACL with the x-amz-acl request header. Amazon S3 supports
//    a set of predefined ACLs, known as canned ACLs. Each canned ACL has a
//    predefined set of grantees and permissions. Specify the canned ACL name
//    as the value of x-amz-acl. If you use this header, you cannot use other
//    access control-specific headers in your request. For more information,
//    see Canned ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
//
//    * Specify access permissions explicitly with the x-amz-grant-read, x-amz-grant-read-acp,
//    x-amz-grant-write-acp, and x-amz-grant-full-control headers. When using
//    these headers, you specify explicit access permissions and grantees (AWS
//    accounts or Amazon S3 groups) who will receive the permission. If you
//    use these ACL-specific headers, you cannot use the x-amz-acl header to
//    set a canned ACL. These parameters map to the set of permissions that
//    Amazon S3 supports in an ACL. For more information, see Access Control
//    List (ACL) Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html).
//    You specify each grantee as a type=value pair, where the type is one of
//    the following: id – if the value specified is the canonical user ID
//    of an AWS account uri – if you are granting permissions to a predefined
//    group emailAddress – if the value specified is the email address of
//    an AWS account Using email addresses to specify a grantee is only supported
//    in the following AWS Regions: US East (N. Virginia) US West (N. California)
//    US West (Oregon) Asia Pacific (Singapore) Asia Pacific (Sydney) Asia Pacific
//    (Tokyo) Europe (Ireland) South America (São Paulo) For a list of all
//    the Amazon S3 supported Regions and endpoints, see Regions and Endpoints
//    (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) in
//    the AWS General Reference. For example, the following x-amz-grant-write
//    header grants create, overwrite, and delete objects permission to LogDelivery
//    group predefined by Amazon S3 and two AWS accounts identified by their
//    email addresses. x-amz-grant-write: uri="http://acs.amazonaws.com/groups/s3/LogDelivery",
//    id="111122223333", id="555566667777"
//
// You can use either a canned ACL or specify access permissions explicitly.
// You cannot do both.
//
// Grantee Values
//
// You can specify the person (grantee) to whom you're assigning access rights
// (using request elements) in the following ways:
//
//    * By the person's ID: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//    xsi:type="CanonicalUser"><ID><>ID<></ID><DisplayName><>GranteesEmail<></DisplayName>
//    </Grantee> DisplayName is optional and ignored in the request
//
//    * By URI: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//    xsi:type="Group"><URI><>http://acs.amazonaws.com/groups/global/AuthenticatedUsers<></URI></Grantee>
//
//    * By Email address: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//    xsi:type="AmazonCustomerByEmail"><EmailAddress><>Grantees@email.com<></EmailAddress>lt;/Grantee>
//    The grantee is resolved to the CanonicalUser and, in a response to a GET
//    Object acl request, appears as the CanonicalUser. Using email addresses
//    to specify a grantee is only supported in the following AWS Regions: US
//    East (N. Virginia) US West (N. California) US West (Oregon) Asia Pacific
//    (Singapore) Asia Pacific (Sydney) Asia Pacific (Tokyo) Europe (Ireland)
//    South America (São Paulo) For a list of all the Amazon S3 supported Regions
//    and endpoints, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
//    in the AWS General Reference.
//
// Related Resources
//
//    * CreateBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html)
//
//    * DeleteBucket (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucket.html)
//
//    * GetObjectAcl (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketAcl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAcl
func (c *S3) PutBucketAcl(input *PutBucketAclInput) (*PutBucketAclOutput, error) {
	req, out := c.PutBucketAclRequest(input)
	return out, req.Send()
}

// PutBucketAclWithContext is the same as PutBucketAcl with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketAclWithContext(ctx aws.Context, input *PutBucketAclInput, opts ...request.Option) (*PutBucketAclOutput, error) {
	req, out := c.PutBucketAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketCors = "PutBucketCors"

// PutBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketCors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketCors for more information on using the PutBucketCors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketCorsRequest method.
//    req, resp := client.PutBucketCorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCors
func (c *S3) PutBucketCorsRequest(input *PutBucketCorsInput) (req *request.Request, output *PutBucketCorsOutput) {
	op := &request.Operation{
		Name:       opPutBucketCors,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &PutBucketCorsInput{}
	}

	output = &PutBucketCorsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketCors API operation for Amazon Simple Storage Service.
//
// Sets the cors configuration for your bucket. If the configuration exists,
// Amazon S3 replaces it.
//
// To use this operation, you must be allowed to perform the s3:PutBucketCORS
// action. By default, the bucket owner has this permission and can grant it
// to others.
//
// You set this configuration on a bucket so that the bucket can service cross-origin
// requests. For example, you might want to enable a request whose origin is
// http://www.example.com to access your Amazon S3 bucket at my.example.bucket.com
// by using the browser's XMLHttpRequest capability.
//
// To enable cross-origin resource sharing (CORS) on a bucket, you add the cors
// subresource to the bucket. The cors subresource is an XML document in which
// you configure rules that identify origins and the HTTP methods that can be
// executed on your bucket. The document is limited to 64 KB in size.
//
// When Amazon S3 receives a cross-origin request (or a pre-flight OPTIONS request)
// against a bucket, it evaluates the cors configuration on the bucket and uses
// the first CORSRule rule that matches the incoming browser request to enable
// a cross-origin request. For a rule to match, the following conditions must
// be met:
//
//    * The request's Origin header must match AllowedOrigin elements.
//
//    * The request method (for example, GET, PUT, HEAD, and so on) or the Access-Control-Request-Method
//    header in case of a pre-flight OPTIONS request must be one of the AllowedMethod
//    elements.
//
//    * Every header specified in the Access-Control-Request-Headers request
//    header of a pre-flight request must match an AllowedHeader element.
//
// For more information about CORS, go to Enabling Cross-Origin Resource Sharing
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the Amazon
// S3 User Guide.
//
// Related Resources
//
//    * GetBucketCors (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketCors.html)
//
//    * DeleteBucketCors (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html)
//
//    * RESTOPTIONSobject (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTOPTIONSobject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketCors for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCors
func (c *S3) PutBucketCors(input *PutBucketCorsInput) (*PutBucketCorsOutput, error) {
	req, out := c.PutBucketCorsRequest(input)
	return out, req.Send()
}

// PutBucketCorsWithContext is the same as PutBucketCors with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketCors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketCorsWithContext(ctx aws.Context, input *PutBucketCorsInput, opts ...request.Option) (*PutBucketCorsOutput, error) {
	req, out := c.PutBucketCorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketLifecycleConfiguration = "PutBucketLifecycleConfiguration"

// PutBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketLifecycleConfiguration for more information on using the PutBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketLifecycleConfigurationRequest method.
//    req, resp := client.PutBucketLifecycleConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfiguration
func (c *S3) PutBucketLifecycleConfigurationRequest(input *PutBucketLifecycleConfigurationInput) (req *request.Request, output *PutBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketLifecycleConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleConfigurationInput{}
	}

	output = &PutBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketLifecycleConfiguration API operation for Amazon Simple Storage Service.
//
// Creates a new lifecycle configuration for the bucket or replaces an existing
// lifecycle configuration. For information about lifecycle configuration, see
// Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// Bucket lifecycle configuration now supports specifying a lifecycle rule using
// an object key name prefix, one or more object tags, or a combination of both.
// Accordingly, this section describes the latest API. The previous version
// of the API supported filtering based only on an object key name prefix, which
// is supported for backward compatibility. For the related API description,
// see PutBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycle.html).
//
// Rules
//
// You specify the lifecycle configuration in your request body. The lifecycle
// configuration is specified as XML consisting of one or more rules. Each rule
// consists of the following:
//
//    * Filter identifying a subset of objects to which the rule applies. The
//    filter can be based on a key name prefix, object tags, or a combination
//    of both.
//
//    * Status whether the rule is in effect.
//
//    * One or more lifecycle transition and expiration actions that you want
//    Amazon S3 to perform on the objects identified by the filter. If the state
//    of your bucket is versioning-enabled or versioning-suspended, you can
//    have many versions of the same object (one current version and zero or
//    more noncurrent versions). Amazon S3 provides predefined actions that
//    you can specify for current and noncurrent object versions.
//
// For more information, see Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)
// and Lifecycle Configuration Elements (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html).
//
// Permissions
//
// By default, all Amazon S3 resources are private, including buckets, objects,
// and related subresources (for example, lifecycle configuration and website
// configuration). Only the resource owner (that is, the AWS account that created
// it) can access the resource. The resource owner can optionally grant access
// permissions to others by writing an access policy. For this operation, a
// user must get the s3:PutLifecycleConfiguration permission.
//
// You can also explicitly deny permissions. Explicit deny also supersedes any
// other permissions. If you want to block users or accounts from removing or
// deleting objects from your bucket, you must deny them permissions for the
// following actions:
//
//    * s3:DeleteObject
//
//    * s3:DeleteObjectVersion
//
//    * s3:PutLifecycleConfiguration
//
// For more information about permissions, see Managing Access Permissions to
// Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
//
// The following are related to PutBucketLifecycleConfiguration:
//
//    * Examples of Lifecycle Configuration (https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-configuration-examples.html)
//
//    * GetBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketLifecycleConfiguration.html)
//
//    * DeleteBucketLifecycle (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfiguration
func (c *S3) PutBucketLifecycleConfiguration(input *PutBucketLifecycleConfigurationInput) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketLifecycleConfigurationWithContext is the same as PutBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketLifecycleConfigurationWithContext(ctx aws.Context, input *PutBucketLifecycleConfigurationInput, opts ...request.Option) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketLogging = "PutBucketLogging"

// PutBucketLoggingRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLogging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketLogging for more information on using the PutBucketLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketLoggingRequest method.
//    req, resp := client.PutBucketLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLogging
func (c *S3) PutBucketLoggingRequest(input *PutBucketLoggingInput) (req *request.Request, output *PutBucketLoggingOutput) {
	op := &request.Operation{
		Name:       opPutBucketLogging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &PutBucketLoggingInput{}
	}

	output = &PutBucketLoggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketLogging API operation for Amazon Simple Storage Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketLogging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLogging
func (c *S3) PutBucketLogging(input *PutBucketLoggingInput) (*PutBucketLoggingOutput, error) {
	req, out := c.PutBucketLoggingRequest(input)
	return out, req.Send()
}

// PutBucketLoggingWithContext is the same as PutBucketLogging with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketLoggingWithContext(ctx aws.Context, input *PutBucketLoggingInput, opts ...request.Option) (*PutBucketLoggingOutput, error) {
	req, out := c.PutBucketLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketProtectionConfiguration = "PutBucketProtectionConfiguration"

// PutBucketProtectionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketProtectionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketProtectionConfiguration for more information on using the PutBucketProtectionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketProtectionConfigurationRequest method.
//    req, resp := client.PutBucketProtectionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketProtectionConfiguration
func (c *S3) PutBucketProtectionConfigurationRequest(input *PutBucketProtectionConfigurationInput) (req *request.Request, output *PutBucketProtectionConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketProtectionConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?protection",
	}

	if input == nil {
		input = &PutBucketProtectionConfigurationInput{}
	}

	output = &PutBucketProtectionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketProtectionConfiguration API operation for Amazon Simple Storage Service.
//
// Sets the protection configuration of an existing bucket. EnablePermanentRetention
// is optional and if not included is considered to be false. Once set to true,
// must be included in any subsequent PUT Bucket?protection requests for that
// bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketProtectionConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketProtectionConfiguration
func (c *S3) PutBucketProtectionConfiguration(input *PutBucketProtectionConfigurationInput) (*PutBucketProtectionConfigurationOutput, error) {
	req, out := c.PutBucketProtectionConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketProtectionConfigurationWithContext is the same as PutBucketProtectionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketProtectionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketProtectionConfigurationWithContext(ctx aws.Context, input *PutBucketProtectionConfigurationInput, opts ...request.Option) (*PutBucketProtectionConfigurationOutput, error) {
	req, out := c.PutBucketProtectionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketVersioning = "PutBucketVersioning"

// PutBucketVersioningRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketVersioning operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketVersioning for more information on using the PutBucketVersioning
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketVersioningRequest method.
//    req, resp := client.PutBucketVersioningRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioning
func (c *S3) PutBucketVersioningRequest(input *PutBucketVersioningInput) (req *request.Request, output *PutBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opPutBucketVersioning,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &PutBucketVersioningInput{}
	}

	output = &PutBucketVersioningOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketVersioning API operation for Amazon Simple Storage Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketVersioning for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioning
func (c *S3) PutBucketVersioning(input *PutBucketVersioningInput) (*PutBucketVersioningOutput, error) {
	req, out := c.PutBucketVersioningRequest(input)
	return out, req.Send()
}

// PutBucketVersioningWithContext is the same as PutBucketVersioning with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketVersioning for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketVersioningWithContext(ctx aws.Context, input *PutBucketVersioningInput, opts ...request.Option) (*PutBucketVersioningOutput, error) {
	req, out := c.PutBucketVersioningRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketWebsite = "PutBucketWebsite"

// PutBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketWebsite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketWebsite for more information on using the PutBucketWebsite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketWebsiteRequest method.
//    req, resp := client.PutBucketWebsiteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsite
func (c *S3) PutBucketWebsiteRequest(input *PutBucketWebsiteInput) (req *request.Request, output *PutBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opPutBucketWebsite,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &PutBucketWebsiteInput{}
	}

	output = &PutBucketWebsiteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutBucketWebsite API operation for Amazon Simple Storage Service.
//
// Sets the configuration of the website that is specified in the website subresource.
// To configure a bucket as a website, you can add this subresource on the bucket
// with website configuration information such as the file name of the index
// document and any redirect rules. For more information, see Hosting Websites
// on Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html).
//
// This PUT action requires the S3:PutBucketWebsite permission. By default,
// only the bucket owner can configure the website attached to a bucket; however,
// bucket owners can allow other users to set the website configuration by writing
// a bucket policy that grants them the S3:PutBucketWebsite permission.
//
// To redirect all website requests sent to the bucket's website endpoint, you
// add a website configuration with the following elements. Because all requests
// are sent to another website, you don't need to provide index document name
// for the bucket.
//
//    * WebsiteConfiguration
//
//    * RedirectAllRequestsTo
//
//    * HostName
//
//    * Protocol
//
// If you want granular control over redirects, you can use the following elements
// to add routing rules that describe conditions for redirecting requests and
// information about the redirect destination. In this case, the website configuration
// must provide an index document for the bucket, because some requests might
// not be redirected.
//
//    * WebsiteConfiguration
//
//    * IndexDocument
//
//    * Suffix
//
//    * ErrorDocument
//
//    * Key
//
//    * RoutingRules
//
//    * RoutingRule
//
//    * Condition
//
//    * HttpErrorCodeReturnedEquals
//
//    * KeyPrefixEquals
//
//    * Redirect
//
//    * Protocol
//
//    * HostName
//
//    * ReplaceKeyPrefixWith
//
//    * ReplaceKeyWith
//
//    * HttpRedirectCode
//
// Amazon S3 has a limitation of 50 routing rules per website configuration.
// If you require more than 50 routing rules, you can use object redirect. For
// more information, see Configuring an Object Redirect (https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html)
// in the Amazon S3 User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketWebsite for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsite
func (c *S3) PutBucketWebsite(input *PutBucketWebsiteInput) (*PutBucketWebsiteOutput, error) {
	req, out := c.PutBucketWebsiteRequest(input)
	return out, req.Send()
}

// PutBucketWebsiteWithContext is the same as PutBucketWebsite with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketWebsite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketWebsiteWithContext(ctx aws.Context, input *PutBucketWebsiteInput, opts ...request.Option) (*PutBucketWebsiteOutput, error) {
	req, out := c.PutBucketWebsiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObject = "PutObject"

// PutObjectRequest generates a "aws/request.Request" representing the
// client's request for the PutObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObject for more information on using the PutObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutObjectRequest method.
//    req, resp := client.PutObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObject
func (c *S3) PutObjectRequest(input *PutObjectInput) (req *request.Request, output *PutObjectOutput) {
	op := &request.Operation{
		Name:       opPutObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &PutObjectInput{}
	}

	output = &PutObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutObject API operation for Amazon Simple Storage Service.
//
// Adds an object to a bucket. You must have WRITE permissions on a bucket to
// add an object to it.
//
// Amazon S3 never adds partial objects; if you receive a success response,
// Amazon S3 added the entire object to the bucket.
//
// Amazon S3 is a distributed system. If it receives multiple write requests
// for the same object simultaneously, it overwrites all but the last object
// written. Amazon S3 does not provide object locking; if you need this, make
// sure to build it into your application layer or use versioning instead.
//
// To ensure that data is not corrupted traversing the network, use the Content-MD5
// header. When you use this header, Amazon S3 checks the object against the
// provided MD5 value and, if they do not match, returns an error. Additionally,
// you can calculate the MD5 while putting an object to Amazon S3 and compare
// the returned ETag to the calculated MD5 value.
//
// The Content-MD5 header is required for any request to upload an object with
// a retention period configured using Amazon S3 Object Lock. For more information
// about Amazon S3 Object Lock, see Amazon S3 Object Lock Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)
// in the Amazon S3 User Guide.
//
// Server-side Encryption
//
// You can optionally request server-side encryption. With server-side encryption,
// Amazon S3 encrypts your data as it writes it to disks in its data centers
// and decrypts the data when you access it. You have the option to provide
// your own encryption key or use AWS managed encryption keys (SSE-S3 or SSE-KMS).
// For more information, see Using Server-Side Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html).
//
// If you request server-side encryption using AWS Key Management Service (SSE-KMS),
// you can enable an S3 Bucket Key at the object-level. For more information,
// see Amazon S3 Bucket Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html)
// in the Amazon S3 User Guide.
//
// Access Control List (ACL)-Specific Request Headers
//
// You can use headers to grant ACL- based permissions. By default, all objects
// are private. Only the owner has full access control. When adding a new object,
// you can grant permissions to individual AWS accounts or to predefined groups
// defined by Amazon S3. These permissions are then added to the ACL on the
// object. For more information, see Access Control List (ACL) Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html)
// and Managing ACLs Using the REST API (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-using-rest-api.html).
//
// Storage Class Options
//
// By default, Amazon S3 uses the STANDARD Storage Class to store newly created
// objects. The STANDARD storage class provides high durability and high availability.
// Depending on performance needs, you can specify a different Storage Class.
// Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information,
// see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html)
// in the Amazon S3 Service Developer Guide.
//
// Versioning
//
// If you enable versioning for a bucket, Amazon S3 automatically generates
// a unique version ID for the object being stored. Amazon S3 returns this ID
// in the response. When you enable versioning for a bucket, if Amazon S3 receives
// multiple write requests for the same object simultaneously, it stores all
// of the objects.
//
// For more information about versioning, see Adding Objects to Versioning Enabled
// Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/AddingObjectstoVersioningEnabledBuckets.html).
// For information about returning the versioning state of a bucket, see GetBucketVersioning
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketVersioning.html).
//
// Related Resources
//
//    * CopyObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html)
//
//    * DeleteObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObject for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObject
func (c *S3) PutObject(input *PutObjectInput) (*PutObjectOutput, error) {
	req, out := c.PutObjectRequest(input)
	return out, req.Send()
}

// PutObjectWithContext is the same as PutObject with the addition of
// the ability to pass a context and additional request options.
//
// See PutObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectWithContext(ctx aws.Context, input *PutObjectInput, opts ...request.Option) (*PutObjectOutput, error) {
	req, out := c.PutObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObjectAcl = "PutObjectAcl"

// PutObjectAclRequest generates a "aws/request.Request" representing the
// client's request for the PutObjectAcl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObjectAcl for more information on using the PutObjectAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutObjectAclRequest method.
//    req, resp := client.PutObjectAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAcl
func (c *S3) PutObjectAclRequest(input *PutObjectAclInput) (req *request.Request, output *PutObjectAclOutput) {
	op := &request.Operation{
		Name:       opPutObjectAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &PutObjectAclInput{}
	}

	output = &PutObjectAclOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutObjectAcl API operation for Amazon Simple Storage Service.
//
// Uses the acl subresource to set the access control list (ACL) permissions
// for a new or existing object in an S3 bucket. You must have WRITE_ACP permission
// to set the ACL of an object. For more information, see What permissions can
// I grant? (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#permissions)
// in the Amazon S3 User Guide.
//
// This action is not supported by Amazon S3 on Outposts.
//
// Depending on your application needs, you can choose to set the ACL on an
// object using either the request body or the headers. For example, if you
// have an existing application that updates a bucket ACL using the request
// body, you can continue to use that approach. For more information, see Access
// Control List (ACL) Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html)
// in the Amazon S3 Developer Guide.
//
// Access Permissions
//
// You can set access permissions using one of the following methods:
//
//    * Specify a canned ACL with the x-amz-acl request header. Amazon S3 supports
//    a set of predefined ACLs, known as canned ACLs. Each canned ACL has a
//    predefined set of grantees and permissions. Specify the canned ACL name
//    as the value of x-amz-acl. If you use this header, you cannot use other
//    access control-specific headers in your request. For more information,
//    see Canned ACL (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
//
//    * Specify access permissions explicitly with the x-amz-grant-read, x-amz-grant-read-acp,
//    x-amz-grant-write-acp, and x-amz-grant-full-control headers. When using
//    these headers, you specify explicit access permissions and grantees (AWS
//    accounts or Amazon S3 groups) who will receive the permission. If you
//    use these ACL-specific headers, you cannot use x-amz-acl header to set
//    a canned ACL. These parameters map to the set of permissions that Amazon
//    S3 supports in an ACL. For more information, see Access Control List (ACL)
//    Overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html).
//    You specify each grantee as a type=value pair, where the type is one of
//    the following: id – if the value specified is the canonical user ID
//    of an AWS account uri – if you are granting permissions to a predefined
//    group emailAddress – if the value specified is the email address of
//    an AWS account Using email addresses to specify a grantee is only supported
//    in the following AWS Regions: US East (N. Virginia) US West (N. California)
//    US West (Oregon) Asia Pacific (Singapore) Asia Pacific (Sydney) Asia Pacific
//    (Tokyo) Europe (Ireland) South America (São Paulo) For a list of all
//    the Amazon S3 supported Regions and endpoints, see Regions and Endpoints
//    (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) in
//    the AWS General Reference. For example, the following x-amz-grant-read
//    header grants list objects permission to the two AWS accounts identified
//    by their email addresses. x-amz-grant-read: emailAddress="xyz@amazon.com",
//    emailAddress="abc@amazon.com"
//
// You can use either a canned ACL or specify access permissions explicitly.
// You cannot do both.
//
// Grantee Values
//
// You can specify the person (grantee) to whom you're assigning access rights
// (using request elements) in the following ways:
//
//    * By the person's ID: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//    xsi:type="CanonicalUser"><ID><>ID<></ID><DisplayName><>GranteesEmail<></DisplayName>
//    </Grantee> DisplayName is optional and ignored in the request.
//
//    * By URI: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//    xsi:type="Group"><URI><>http://acs.amazonaws.com/groups/global/AuthenticatedUsers<></URI></Grantee>
//
//    * By Email address: <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//    xsi:type="AmazonCustomerByEmail"><EmailAddress><>Grantees@email.com<></EmailAddress>lt;/Grantee>
//    The grantee is resolved to the CanonicalUser and, in a response to a GET
//    Object acl request, appears as the CanonicalUser. Using email addresses
//    to specify a grantee is only supported in the following AWS Regions: US
//    East (N. Virginia) US West (N. California) US West (Oregon) Asia Pacific
//    (Singapore) Asia Pacific (Sydney) Asia Pacific (Tokyo) Europe (Ireland)
//    South America (São Paulo) For a list of all the Amazon S3 supported Regions
//    and endpoints, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
//    in the AWS General Reference.
//
// Versioning
//
// The ACL of an object is set at the object version level. By default, PUT
// sets the ACL of the current version of an object. To set the ACL of a different
// version, use the versionId subresource.
//
// Related Resources
//
//    * CopyObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html)
//
//    * GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObjectAcl for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchKey "NoSuchKey"
//   The specified key does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAcl
func (c *S3) PutObjectAcl(input *PutObjectAclInput) (*PutObjectAclOutput, error) {
	req, out := c.PutObjectAclRequest(input)
	return out, req.Send()
}

// PutObjectAclWithContext is the same as PutObjectAcl with the addition of
// the ability to pass a context and additional request options.
//
// See PutObjectAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectAclWithContext(ctx aws.Context, input *PutObjectAclInput, opts ...request.Option) (*PutObjectAclOutput, error) {
	req, out := c.PutObjectAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObjectTagging = "PutObjectTagging"

// PutObjectTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutObjectTagging operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObjectTagging for more information on using the PutObjectTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutObjectTaggingRequest method.
//    req, resp := client.PutObjectTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTagging
func (c *S3) PutObjectTaggingRequest(input *PutObjectTaggingInput) (req *request.Request, output *PutObjectTaggingOutput) {
	op := &request.Operation{
		Name:       opPutObjectTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &PutObjectTaggingInput{}
	}

	output = &PutObjectTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutObjectTagging API operation for Amazon Simple Storage Service.
//
// Sets the supplied tag-set to an object that already exists in a bucket.
//
// A tag is a key-value pair. You can associate tags with an object by sending
// a PUT request against the tagging subresource that is associated with the
// object. You can retrieve tags by sending a GET request. For more information,
// see GetObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html).
//
// For tagging-related restrictions related to characters and encodings, see
// Tag Restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html).
// Note that Amazon S3 limits the maximum number of tags to 10 tags per object.
//
// To use this operation, you must have permission to perform the s3:PutObjectTagging
// action. By default, the bucket owner has this permission and can grant this
// permission to others.
//
// To put tags of any other version, use the versionId query parameter. You
// also need permission for the s3:PutObjectVersionTagging action.
//
// For information about the Amazon S3 object tagging feature, see Object Tagging
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html).
//
// Special Errors
//
//    * Code: InvalidTagError Cause: The tag provided was not a valid tag. This
//    error can occur if the tag did not pass input validation. For more information,
//    see Object Tagging (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-tagging.html).
//
//    * Code: MalformedXMLError Cause: The XML provided does not match the schema.
//
//    * Code: OperationAbortedError Cause: A conflicting conditional action
//    is currently in progress against this resource. Please try again.
//
//    * Code: InternalError Cause: The service was unable to apply the provided
//    tag to the object.
//
// Related Resources
//
//    * GetObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html)
//
//    * DeleteObjectTagging (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObjectTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTagging
func (c *S3) PutObjectTagging(input *PutObjectTaggingInput) (*PutObjectTaggingOutput, error) {
	req, out := c.PutObjectTaggingRequest(input)
	return out, req.Send()
}

// PutObjectTaggingWithContext is the same as PutObjectTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutObjectTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectTaggingWithContext(ctx aws.Context, input *PutObjectTaggingInput, opts ...request.Option) (*PutObjectTaggingOutput, error) {
	req, out := c.PutObjectTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPublicAccessBlock = "PutPublicAccessBlock"

// PutPublicAccessBlockRequest generates a "aws/request.Request" representing the
// client's request for the PutPublicAccessBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPublicAccessBlock for more information on using the PutPublicAccessBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutPublicAccessBlockRequest method.
//    req, resp := client.PutPublicAccessBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutPublicAccessBlock
func (c *S3) PutPublicAccessBlockRequest(input *PutPublicAccessBlockInput) (req *request.Request, output *PutPublicAccessBlockOutput) {
	op := &request.Operation{
		Name:       opPutPublicAccessBlock,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?publicAccessBlock",
	}

	if input == nil {
		input = &PutPublicAccessBlockInput{}
	}

	output = &PutPublicAccessBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(request.NamedHandler{
		Name: "contentMd5Handler",
		Fn:   checksum.AddBodyContentMD5Handler,
	})
	return
}

// PutPublicAccessBlock API operation for Amazon Simple Storage Service.
//
// Creates or modifies the PublicAccessBlock configuration for an Amazon S3
// bucket. To use this operation, you must have the s3:PutBucketPublicAccessBlock
// permission. For more information about Amazon S3 permissions, see Specifying
// Permissions in a Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html).
//
// When Amazon S3 evaluates the PublicAccessBlock configuration for a bucket
// or an object, it checks the PublicAccessBlock configuration for both the
// bucket (or the bucket that contains the object) and the bucket owner's account.
// If the PublicAccessBlock configurations are different between the bucket
// and the account, Amazon S3 uses the most restrictive combination of the bucket-level
// and account-level settings.
//
// For more information about when Amazon S3 considers a bucket or an object
// public, see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status).
//
// Related Resources
//
//    * GetPublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetPublicAccessBlock.html)
//
//    * DeletePublicAccessBlock (https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeletePublicAccessBlock.html)
//
//    * GetBucketPolicyStatus (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketPolicyStatus.html)
//
//    * Using Amazon S3 Block Public Access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutPublicAccessBlock for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutPublicAccessBlock
func (c *S3) PutPublicAccessBlock(input *PutPublicAccessBlockInput) (*PutPublicAccessBlockOutput, error) {
	req, out := c.PutPublicAccessBlockRequest(input)
	return out, req.Send()
}

// PutPublicAccessBlockWithContext is the same as PutPublicAccessBlock with the addition of
// the ability to pass a context and additional request options.
//
// See PutPublicAccessBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutPublicAccessBlockWithContext(ctx aws.Context, input *PutPublicAccessBlockInput, opts ...request.Option) (*PutPublicAccessBlockOutput, error) {
	req, out := c.PutPublicAccessBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreObject = "RestoreObject"

// RestoreObjectRequest generates a "aws/request.Request" representing the
// client's request for the RestoreObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreObject for more information on using the RestoreObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreObjectRequest method.
//    req, resp := client.RestoreObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObject
func (c *S3) RestoreObjectRequest(input *RestoreObjectInput) (req *request.Request, output *RestoreObjectOutput) {
	op := &request.Operation{
		Name:       opRestoreObject,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?restore",
	}

	if input == nil {
		input = &RestoreObjectInput{}
	}

	output = &RestoreObjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RestoreObject API operation for Amazon Simple Storage Service.
//
// Restores an archived copy of an object back into Amazon S3
//
// This action is not supported by Amazon S3 on Outposts.
//
// This action performs the following types of requests:
//
//    * select - Perform a select query on an archived object
//
//    * restore an archive - Restore an archived object
//
// To use this operation, you must have permissions to perform the s3:RestoreObject
// action. The bucket owner has this permission by default and can grant this
// permission to others. For more information about permissions, see Permissions
// Related to Bucket Subresource Operations (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources)
// and Managing Access Permissions to Your Amazon S3 Resources (https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html)
// in the Amazon S3 User Guide.
//
// Querying Archives with Select Requests
//
// You use a select type of request to perform SQL queries on archived objects.
// The archived objects that are being queried by the select request must be
// formatted as uncompressed comma-separated values (CSV) files. You can run
// queries and custom analytics on your archived data without having to restore
// your data to a hotter Amazon S3 tier. For an overview about select requests,
// see Querying Archived Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/querying-glacier-archives.html)
// in the Amazon S3 User Guide.
//
// When making a select request, do the following:
//
//    * Define an output location for the select query's output. This must be
//    an Amazon S3 bucket in the same AWS Region as the bucket that contains
//    the archive object that is being queried. The AWS account that initiates
//    the job must have permissions to write to the S3 bucket. You can specify
//    the storage class and encryption for the output objects stored in the
//    bucket. For more information about output, see Querying Archived Objects
//    (https://docs.aws.amazon.com/AmazonS3/latest/dev/querying-glacier-archives.html)
//    in the Amazon S3 User Guide. For more information about the S3 structure
//    in the request body, see the following: PutObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html)
//    Managing Access with ACLs (https://docs.aws.amazon.com/AmazonS3/latest/dev/S3_ACLs_UsingACLs.html)
//    in the Amazon S3 User Guide Protecting Data Using Server-Side Encryption
//    (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html)
//    in the Amazon S3 User Guide
//
//    * Define the SQL expression for the SELECT type of restoration for your
//    query in the request body's SelectParameters structure. You can use expressions
//    like the following examples. The following expression returns all records
//    from the specified object. SELECT * FROM Object Assuming that you are
//    not using any headers for data stored in the object, you can specify columns
//    with positional headers. SELECT s._1, s._2 FROM Object s WHERE s._3 >
//    100 If you have headers and you set the fileHeaderInfo in the CSV structure
//    in the request body to USE, you can specify headers in the query. (If
//    you set the fileHeaderInfo field to IGNORE, the first row is skipped for
//    the query.) You cannot mix ordinal positions with header column names.
//    SELECT s.Id, s.FirstName, s.SSN FROM S3Object s
//
// For more information about using SQL with S3 Glacier Select restore, see
// SQL Reference for Amazon S3 Select and S3 Glacier Select (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html)
// in the Amazon S3 User Guide.
//
// When making a select request, you can also do the following:
//
//    * To expedite your queries, specify the Expedited tier. For more information
//    about tiers, see "Restoring Archives," later in this topic.
//
//    * Specify details about the data serialization format of both the input
//    object that is being queried and the serialization of the CSV-encoded
//    query results.
//
// The following are additional important facts about the select feature:
//
//    * The output results are new Amazon S3 objects. Unlike archive retrievals,
//    they are stored until explicitly deleted-manually or through a lifecycle
//    policy.
//
//    * You can issue more than one select request on the same Amazon S3 object.
//    Amazon S3 doesn't deduplicate requests, so avoid issuing duplicate requests.
//
//    * Amazon S3 accepts a select request even if the object has already been
//    restored. A select request doesn’t return error response 409.
//
// Restoring objects
//
// Objects that you archive to the S3 Glacier or S3 Glacier Deep Archive storage
// class, and S3 Intelligent-Tiering Archive or S3 Intelligent-Tiering Deep
// Archive tiers are not accessible in real time. For objects in Archive Access
// or Deep Archive Access tiers you must first initiate a restore request, and
// then wait until the object is moved into the Frequent Access tier. For objects
// in S3 Glacier or S3 Glacier Deep Archive storage classes you must first initiate
// a restore request, and then wait until a temporary copy of the object is
// available. To access an archived object, you must restore the object for
// the duration (number of days) that you specify.
//
// To restore a specific object version, you can provide a version ID. If you
// don't provide a version ID, Amazon S3 restores the current version.
//
// When restoring an archived object (or using a select request), you can specify
// one of the following data access tier options in the Tier element of the
// request body:
//
//    * Expedited - Expedited retrievals allow you to quickly access your data
//    stored in the S3 Glacier storage class or S3 Intelligent-Tiering Archive
//    tier when occasional urgent requests for a subset of archives are required.
//    For all but the largest archived objects (250 MB+), data accessed using
//    Expedited retrievals is typically made available within 1–5 minutes.
//    Provisioned capacity ensures that retrieval capacity for Expedited retrievals
//    is available when you need it. Expedited retrievals and provisioned capacity
//    are not available for objects stored in the S3 Glacier Deep Archive storage
//    class or S3 Intelligent-Tiering Deep Archive tier.
//
//    * Standard - Standard retrievals allow you to access any of your archived
//    objects within several hours. This is the default option for retrieval
//    requests that do not specify the retrieval option. Standard retrievals
//    typically finish within 3–5 hours for objects stored in the S3 Glacier
//    storage class or S3 Intelligent-Tiering Archive tier. They typically finish
//    within 12 hours for objects stored in the S3 Glacier Deep Archive storage
//    class or S3 Intelligent-Tiering Deep Archive tier. Standard retrievals
//    are free for objects stored in S3 Intelligent-Tiering.
//
//    * Bulk - Bulk retrievals are the lowest-cost retrieval option in S3 Glacier,
//    enabling you to retrieve large amounts, even petabytes, of data inexpensively.
//    Bulk retrievals typically finish within 5–12 hours for objects stored
//    in the S3 Glacier storage class or S3 Intelligent-Tiering Archive tier.
//    They typically finish within 48 hours for objects stored in the S3 Glacier
//    Deep Archive storage class or S3 Intelligent-Tiering Deep Archive tier.
//    Bulk retrievals are free for objects stored in S3 Intelligent-Tiering.
//
// For more information about archive retrieval options and provisioned capacity
// for Expedited data access, see Restoring Archived Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html)
// in the Amazon S3 User Guide.
//
// You can use Amazon S3 restore speed upgrade to change the restore speed to
// a faster speed while it is in progress. For more information, see Upgrading
// the speed of an in-progress restore (https://docs.aws.amazon.com/AmazonS3/latest/dev/restoring-objects.html#restoring-objects-upgrade-tier.title.html)
// in the Amazon S3 User Guide.
//
// To get the status of object restoration, you can send a HEAD request. Operations
// return the x-amz-restore header, which provides information about the restoration
// status, in the response. You can use Amazon S3 event notifications to notify
// you when a restore is initiated or completed. For more information, see Configuring
// Amazon S3 Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
// in the Amazon S3 User Guide.
//
// After restoring an archived object, you can update the restoration period
// by reissuing the request with a new period. Amazon S3 updates the restoration
// period relative to the current time and charges only for the request-there
// are no data transfer charges. You cannot update the restoration period when
// Amazon S3 is actively processing your current restore request for the object.
//
// If your bucket has a lifecycle configuration with a rule that includes an
// expiration action, the object expiration overrides the life span that you
// specify in a restore request. For example, if you restore an object copy
// for 10 days, but the object is scheduled to expire in 3 days, Amazon S3 deletes
// the object in 3 days. For more information about lifecycle configuration,
// see PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)
// and Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)
// in Amazon S3 User Guide.
//
// Responses
//
// A successful action returns either the 200 OK or 202 Accepted status code.
//
//    * If the object is not previously restored, then Amazon S3 returns 202
//    Accepted in the response.
//
//    * If the object is previously restored, Amazon S3 returns 200 OK in the
//    response.
//
// Special Errors
//
//    * Code: RestoreAlreadyInProgress Cause: Object restore is already in progress.
//    (This error does not apply to SELECT type requests.) HTTP Status Code:
//    409 Conflict SOAP Fault Code Prefix: Client
//
//    * Code: GlacierExpeditedRetrievalNotAvailable Cause: expedited retrievals
//    are currently not available. Try again later. (Returned if there is insufficient
//    capacity to process the Expedited request. This error applies only to
//    Expedited retrievals and not to S3 Standard or Bulk retrievals.) HTTP
//    Status Code: 503 SOAP Fault Code Prefix: N/A
//
// Related Resources
//
//    * PutBucketLifecycleConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)
//
//    * GetBucketNotificationConfiguration (https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketNotificationConfiguration.html)
//
//    * SQL Reference for Amazon S3 Select and S3 Glacier Select (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-glacier-select-sql-reference.html)
//    in the Amazon S3 User Guide
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation RestoreObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeObjectAlreadyInActiveTierError "ObjectAlreadyInActiveTierError"
//   This action is not allowed against this storage tier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObject
func (c *S3) RestoreObject(input *RestoreObjectInput) (*RestoreObjectOutput, error) {
	req, out := c.RestoreObjectRequest(input)
	return out, req.Send()
}

// RestoreObjectWithContext is the same as RestoreObject with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) RestoreObjectWithContext(ctx aws.Context, input *RestoreObjectInput, opts ...request.Option) (*RestoreObjectOutput, error) {
	req, out := c.RestoreObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUploadPart = "UploadPart"

// UploadPartRequest generates a "aws/request.Request" representing the
// client's request for the UploadPart operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UploadPart for more information on using the UploadPart
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UploadPartRequest method.
//    req, resp := client.UploadPartRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPart
func (c *S3) UploadPartRequest(input *UploadPartInput) (req *request.Request, output *UploadPartOutput) {
	op := &request.Operation{
		Name:       opUploadPart,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartInput{}
	}

	output = &UploadPartOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadPart API operation for Amazon Simple Storage Service.
//
// Uploads a part in a multipart upload.
//
// In this operation, you provide part data in your request. However, you have
// an option to specify your existing Amazon S3 object as a data source for
// the part you are uploading. To upload a part from an existing object, you
// use the UploadPartCopy (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPartCopy.html)
// operation.
//
// You must initiate a multipart upload (see CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html))
// before you can upload any part. In response to your initiate request, Amazon
// S3 returns an upload ID, a unique identifier, that you must include in your
// upload part request.
//
// Part numbers can be any number from 1 to 10,000, inclusive. A part number
// uniquely identifies a part and also defines its position within the object
// being created. If you upload a new part using the same part number that was
// used with a previous part, the previously uploaded part is overwritten. Each
// part must be at least 5 MB in size, except the last part. There is no size
// limit on the last part of your multipart upload.
//
// To ensure that data is not corrupted when traversing the network, specify
// the Content-MD5 header in the upload part request. Amazon S3 checks the part
// data against the provided MD5 value. If they do not match, Amazon S3 returns
// an error.
//
// If the upload request is signed with Signature Version 4, then AWS S3 uses
// the x-amz-content-sha256 header as a checksum instead of Content-MD5. For
// more information see Authenticating Requests: Using the Authorization Header
// (AWS Signature Version 4) (https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-auth-using-authorization-header.html).
//
// Note: After you initiate multipart upload and upload one or more parts, you
// must either complete or abort multipart upload in order to stop getting charged
// for storage of the uploaded parts. Only after you either complete or abort
// multipart upload, Amazon S3 frees up the parts storage and stops charging
// you for the parts storage.
//
// For more information on multipart uploads, go to Multipart Upload Overview
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html) in the
// Amazon S3 User Guide .
//
// For information on the permissions required to use the multipart upload API,
// go to Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html)
// in the Amazon S3 User Guide.
//
// You can optionally request server-side encryption where Amazon S3 encrypts
// your data as it writes it to disks in its data centers and decrypts it for
// you when you access it. You have the option of providing your own encryption
// key, or you can use the AWS managed encryption keys. If you choose to provide
// your own encryption key, the request headers you provide in the request must
// match the headers you used in the request to initiate the upload by using
// CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html).
// For more information, go to Using Server-Side Encryption (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html)
// in the Amazon S3 User Guide.
//
// Server-side encryption is supported by the S3 Multipart Upload actions. Unless
// you are using a customer-provided encryption key, you don't need to specify
// the encryption parameters in each UploadPart request. Instead, you only need
// to specify the server-side encryption parameters in the initial Initiate
// Multipart request. For more information, see CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html).
//
// If you requested server-side encryption using a customer-provided encryption
// key in your initiate multipart upload request, you must provide identical
// encryption information in each part upload using the following headers.
//
//    * x-amz-server-side-encryption-customer-algorithm
//
//    * x-amz-server-side-encryption-customer-key
//
//    * x-amz-server-side-encryption-customer-key-MD5
//
// Special Errors
//
//    * Code: NoSuchUpload Cause: The specified multipart upload does not exist.
//    The upload ID might be invalid, or the multipart upload might have been
//    aborted or completed. HTTP Status Code: 404 Not Found SOAP Fault Code
//    Prefix: Client
//
// Related Resources
//
//    * CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//    * CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//    * AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
//    * ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//    * ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation UploadPart for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPart
func (c *S3) UploadPart(input *UploadPartInput) (*UploadPartOutput, error) {
	req, out := c.UploadPartRequest(input)
	return out, req.Send()
}

// UploadPartWithContext is the same as UploadPart with the addition of
// the ability to pass a context and additional request options.
//
// See UploadPart for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) UploadPartWithContext(ctx aws.Context, input *UploadPartInput, opts ...request.Option) (*UploadPartOutput, error) {
	req, out := c.UploadPartRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUploadPartCopy = "UploadPartCopy"

// UploadPartCopyRequest generates a "aws/request.Request" representing the
// client's request for the UploadPartCopy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UploadPartCopy for more information on using the UploadPartCopy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UploadPartCopyRequest method.
//    req, resp := client.UploadPartCopyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopy
func (c *S3) UploadPartCopyRequest(input *UploadPartCopyInput) (req *request.Request, output *UploadPartCopyOutput) {
	op := &request.Operation{
		Name:       opUploadPartCopy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartCopyInput{}
	}

	output = &UploadPartCopyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadPartCopy API operation for Amazon Simple Storage Service.
//
// Uploads a part by copying data from an existing object as data source. You
// specify the data source by adding the request header x-amz-copy-source in
// your request and a byte range by adding the request header x-amz-copy-source-range
// in your request.
//
// The minimum allowable part size for a multipart upload is 5 MB. For more
// information about multipart upload limits, go to Quick Facts (https://docs.aws.amazon.com/AmazonS3/latest/dev/qfacts.html)
// in the Amazon S3 User Guide.
//
// Instead of using an existing object as part data, you might use the UploadPart
// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html) action
// and provide data in your request.
//
// You must initiate a multipart upload before you can upload any part. In response
// to your initiate request. Amazon S3 returns a unique identifier, the upload
// ID, that you must include in your upload part request.
//
// For more information about using the UploadPartCopy operation, see the following:
//
//    * For conceptual information about multipart uploads, see Uploading Objects
//    Using Multipart Upload (https://docs.aws.amazon.com/AmazonS3/latest/dev/uploadobjusingmpu.html)
//    in the Amazon S3 User Guide.
//
//    * For information about permissions required to use the multipart upload
//    API, see Multipart Upload and Permissions (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuAndPermissions.html)
//    in the Amazon S3 User Guide.
//
//    * For information about copying objects using a single atomic action vs.
//    the multipart upload, see Operations on Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectOperations.html)
//    in the Amazon S3 User Guide.
//
//    * For information about using server-side encryption with customer-provided
//    encryption keys with the UploadPartCopy operation, see CopyObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CopyObject.html)
//    and UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html).
//
// Note the following additional considerations about the request headers x-amz-copy-source-if-match,
// x-amz-copy-source-if-none-match, x-amz-copy-source-if-unmodified-since, and
// x-amz-copy-source-if-modified-since:
//
//    * Consideration 1 - If both of the x-amz-copy-source-if-match and x-amz-copy-source-if-unmodified-since
//    headers are present in the request as follows: x-amz-copy-source-if-match
//    condition evaluates to true, and; x-amz-copy-source-if-unmodified-since
//    condition evaluates to false; Amazon S3 returns 200 OK and copies the
//    data.
//
//    * Consideration 2 - If both of the x-amz-copy-source-if-none-match and
//    x-amz-copy-source-if-modified-since headers are present in the request
//    as follows: x-amz-copy-source-if-none-match condition evaluates to false,
//    and; x-amz-copy-source-if-modified-since condition evaluates to true;
//    Amazon S3 returns 412 Precondition Failed response code.
//
// Versioning
//
// If your bucket has versioning enabled, you could have multiple versions of
// the same object. By default, x-amz-copy-source identifies the current version
// of the object to copy. If the current version is a delete marker and you
// don't specify a versionId in the x-amz-copy-source, Amazon S3 returns a 404
// error, because the object does not exist. If you specify versionId in the
// x-amz-copy-source and the versionId is a delete marker, Amazon S3 returns
// an HTTP 400 error, because you are not allowed to specify a delete marker
// as a version for the x-amz-copy-source.
//
// You can optionally specify a specific version of the source object to copy
// by adding the versionId subresource as shown in the following example:
//
// x-amz-copy-source: /bucket/object?versionId=version id
//
// Special Errors
//
//    * Code: NoSuchUpload Cause: The specified multipart upload does not exist.
//    The upload ID might be invalid, or the multipart upload might have been
//    aborted or completed. HTTP Status Code: 404 Not Found
//
//    * Code: InvalidRequest Cause: The specified copy source is not supported
//    as a byte-range copy source. HTTP Status Code: 400 Bad Request
//
// Related Resources
//
//    * CreateMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateMultipartUpload.html)
//
//    * UploadPart (https://docs.aws.amazon.com/AmazonS3/latest/API/API_UploadPart.html)
//
//    * CompleteMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_CompleteMultipartUpload.html)
//
//    * AbortMultipartUpload (https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html)
//
//    * ListParts (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html)
//
//    * ListMultipartUploads (https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation UploadPartCopy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopy
func (c *S3) UploadPartCopy(input *UploadPartCopyInput) (*UploadPartCopyOutput, error) {
	req, out := c.UploadPartCopyRequest(input)
	return out, req.Send()
}

// UploadPartCopyWithContext is the same as UploadPartCopy with the addition of
// the ability to pass a context and additional request options.
//
// See UploadPartCopy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) UploadPartCopyWithContext(ctx aws.Context, input *UploadPartCopyInput, opts ...request.Option) (*UploadPartCopyOutput, error) {
	req, out := c.UploadPartCopyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AbortMultipartUploadInput struct {
	_ struct{} `locationName:"AbortMultipartUploadRequest" type:"structure"`

	// The bucket name to which the upload was taking place.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Key of the object for which the multipart upload was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Upload ID that identifies the multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s AbortMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *AbortMultipartUploadInput) SetBucket(v string) *AbortMultipartUploadInput {
	s.Bucket = &v
	return s
}

func (s *AbortMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *AbortMultipartUploadInput) SetExpectedBucketOwner(v string) *AbortMultipartUploadInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *AbortMultipartUploadInput) SetKey(v string) *AbortMultipartUploadInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *AbortMultipartUploadInput) SetRequestPayer(v string) *AbortMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *AbortMultipartUploadInput) SetUploadId(v string) *AbortMultipartUploadInput {
	s.UploadId = &v
	return s
}

type AbortMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s AbortMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *AbortMultipartUploadOutput) SetRequestCharged(v string) *AbortMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

// Contains the elements that set the ACL permissions for an object per grantee.
type AccessControlPolicy struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	// Container for the bucket owner's display name and ID.
	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s AccessControlPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlPolicy"}
	if s.Grants != nil {
		for i, v := range s.Grants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Grants", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrants sets the Grants field's value.
func (s *AccessControlPolicy) SetGrants(v []*Grant) *AccessControlPolicy {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *AccessControlPolicy) SetOwner(v *Owner) *AccessControlPolicy {
	s.Owner = v
	return s
}

type AddLegalHoldInput struct {
	_ struct{} `locationName:"AddLegalHoldRequest" type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// RetentionLegalHoldId is a required field
	RetentionLegalHoldId *string `location:"querystring" locationName:"add" type:"string" required:"true"`
}

// String returns the string representation
func (s AddLegalHoldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddLegalHoldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddLegalHoldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddLegalHoldInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.RetentionLegalHoldId == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionLegalHoldId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *AddLegalHoldInput) SetBucket(v string) *AddLegalHoldInput {
	s.Bucket = &v
	return s
}

func (s *AddLegalHoldInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *AddLegalHoldInput) SetKey(v string) *AddLegalHoldInput {
	s.Key = &v
	return s
}

// SetRetentionLegalHoldId sets the RetentionLegalHoldId field's value.
func (s *AddLegalHoldInput) SetRetentionLegalHoldId(v string) *AddLegalHoldInput {
	s.RetentionLegalHoldId = &v
	return s
}

type AddLegalHoldOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddLegalHoldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddLegalHoldOutput) GoString() string {
	return s.String()
}

// In terms of implementation, a Bucket is a resource. An Amazon S3 bucket name
// is globally unique, and the namespace is shared by all AWS accounts.
type Bucket struct {
	_ struct{} `type:"structure"`

	// Date the bucket was created. This date can change when making changes to
	// your bucket, such as editing its bucket policy.
	CreationDate *time.Time `type:"timestamp"`

	// The name of the bucket.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Bucket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Bucket) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *Bucket) SetCreationDate(v time.Time) *Bucket {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *Bucket) SetName(v string) *Bucket {
	s.Name = &v
	return s
}

type BucketExtended struct {
	_ struct{} `type:"structure"`

	CreationDate *time.Time `type:"timestamp"`

	CreationTemplateId *string `type:"string"`

	// Specifies the region where the bucket was created.
	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`

	// The name of the bucket.
	Name *string `type:"string"`
}

// String returns the string representation
func (s BucketExtended) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketExtended) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *BucketExtended) SetCreationDate(v time.Time) *BucketExtended {
	s.CreationDate = &v
	return s
}

// SetCreationTemplateId sets the CreationTemplateId field's value.
func (s *BucketExtended) SetCreationTemplateId(v string) *BucketExtended {
	s.CreationTemplateId = &v
	return s
}

// SetLocationConstraint sets the LocationConstraint field's value.
func (s *BucketExtended) SetLocationConstraint(v string) *BucketExtended {
	s.LocationConstraint = &v
	return s
}

// SetName sets the Name field's value.
func (s *BucketExtended) SetName(v string) *BucketExtended {
	s.Name = &v
	return s
}

// Container for logging status information.
type BucketLoggingStatus struct {
	_ struct{} `type:"structure"`

	// Describes where logs are stored and the prefix that Amazon S3 assigns to
	// all log object keys for a bucket. For more information, see PUT Bucket logging
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html)
	// in the Amazon Simple Storage Service API Reference.
	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s BucketLoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLoggingStatus) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLoggingStatus) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketLoggingStatus"}
	if s.LoggingEnabled != nil {
		if err := s.LoggingEnabled.Validate(); err != nil {
			invalidParams.AddNested("LoggingEnabled", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingEnabled sets the LoggingEnabled field's value.
func (s *BucketLoggingStatus) SetLoggingEnabled(v *LoggingEnabled) *BucketLoggingStatus {
	s.LoggingEnabled = v
	return s
}

type BucketProtectionDefaultRetention struct {
	_ struct{} `type:"structure"`

	// Days is a required field
	Days *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s BucketProtectionDefaultRetention) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketProtectionDefaultRetention) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketProtectionDefaultRetention) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketProtectionDefaultRetention"}
	if s.Days == nil {
		invalidParams.Add(request.NewErrParamRequired("Days"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDays sets the Days field's value.
func (s *BucketProtectionDefaultRetention) SetDays(v int64) *BucketProtectionDefaultRetention {
	s.Days = &v
	return s
}

type BucketProtectionMaximumRetention struct {
	_ struct{} `type:"structure"`

	// Days is a required field
	Days *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s BucketProtectionMaximumRetention) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketProtectionMaximumRetention) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketProtectionMaximumRetention) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketProtectionMaximumRetention"}
	if s.Days == nil {
		invalidParams.Add(request.NewErrParamRequired("Days"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDays sets the Days field's value.
func (s *BucketProtectionMaximumRetention) SetDays(v int64) *BucketProtectionMaximumRetention {
	s.Days = &v
	return s
}

type BucketProtectionMinimumRetention struct {
	_ struct{} `type:"structure"`

	// Days is a required field
	Days *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s BucketProtectionMinimumRetention) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketProtectionMinimumRetention) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketProtectionMinimumRetention) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketProtectionMinimumRetention"}
	if s.Days == nil {
		invalidParams.Add(request.NewErrParamRequired("Days"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDays sets the Days field's value.
func (s *BucketProtectionMinimumRetention) SetDays(v int64) *BucketProtectionMinimumRetention {
	s.Days = &v
	return s
}

// Describes the cross-origin access configuration for objects in an Amazon
// S3 bucket. For more information, see Enabling Cross-Origin Resource Sharing
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the Amazon
// S3 User Guide.
type CORSConfiguration struct {
	_ struct{} `type:"structure"`

	// A set of origins and methods (cross-origin access that you want to allow).
	// You can add up to 100 rules to the configuration.
	//
	// CORSRules is a required field
	CORSRules []*CORSRule `locationName:"CORSRule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s CORSConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CORSConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CORSConfiguration"}
	if s.CORSRules == nil {
		invalidParams.Add(request.NewErrParamRequired("CORSRules"))
	}
	if s.CORSRules != nil {
		for i, v := range s.CORSRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CORSRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCORSRules sets the CORSRules field's value.
func (s *CORSConfiguration) SetCORSRules(v []*CORSRule) *CORSConfiguration {
	s.CORSRules = v
	return s
}

// Specifies a cross-origin access rule for an Amazon S3 bucket.
type CORSRule struct {
	_ struct{} `type:"structure"`

	// Headers that are specified in the Access-Control-Request-Headers header.
	// These headers are allowed in a preflight OPTIONS request. In response to
	// any preflight OPTIONS request, Amazon S3 returns any requested headers that
	// are allowed.
	AllowedHeaders []*string `locationName:"AllowedHeader" type:"list" flattened:"true"`

	// An HTTP method that you allow the origin to execute. Valid values are GET,
	// PUT, HEAD, POST, and DELETE.
	//
	// AllowedMethods is a required field
	AllowedMethods []*string `locationName:"AllowedMethod" type:"list" flattened:"true" required:"true"`

	// One or more origins you want customers to be able to access the bucket from.
	//
	// AllowedOrigins is a required field
	AllowedOrigins []*string `locationName:"AllowedOrigin" type:"list" flattened:"true" required:"true"`

	// One or more headers in the response that you want customers to be able to
	// access from their applications (for example, from a JavaScript XMLHttpRequest
	// object).
	ExposeHeaders []*string `locationName:"ExposeHeader" type:"list" flattened:"true"`

	// The time in seconds that your browser is to cache the preflight response
	// for the specified resource.
	MaxAgeSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s CORSRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CORSRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CORSRule"}
	if s.AllowedMethods == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedMethods"))
	}
	if s.AllowedOrigins == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedOrigins"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedHeaders sets the AllowedHeaders field's value.
func (s *CORSRule) SetAllowedHeaders(v []*string) *CORSRule {
	s.AllowedHeaders = v
	return s
}

// SetAllowedMethods sets the AllowedMethods field's value.
func (s *CORSRule) SetAllowedMethods(v []*string) *CORSRule {
	s.AllowedMethods = v
	return s
}

// SetAllowedOrigins sets the AllowedOrigins field's value.
func (s *CORSRule) SetAllowedOrigins(v []*string) *CORSRule {
	s.AllowedOrigins = v
	return s
}

// SetExposeHeaders sets the ExposeHeaders field's value.
func (s *CORSRule) SetExposeHeaders(v []*string) *CORSRule {
	s.ExposeHeaders = v
	return s
}

// SetMaxAgeSeconds sets the MaxAgeSeconds field's value.
func (s *CORSRule) SetMaxAgeSeconds(v int64) *CORSRule {
	s.MaxAgeSeconds = &v
	return s
}

// Container for all (if there are any) keys between Prefix and the next occurrence
// of the string specified by a delimiter. CommonPrefixes lists keys that act
// like subdirectories in the directory specified by Prefix. For example, if
// the prefix is notes/ and the delimiter is a slash (/) as in notes/summer/july,
// the common prefix is notes/summer/.
type CommonPrefix struct {
	_ struct{} `type:"structure"`

	// Container for the specified common prefix.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s CommonPrefix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommonPrefix) GoString() string {
	return s.String()
}

// SetPrefix sets the Prefix field's value.
func (s *CommonPrefix) SetPrefix(v string) *CommonPrefix {
	s.Prefix = &v
	return s
}

type CompleteMultipartUploadInput struct {
	_ struct{} `locationName:"CompleteMultipartUploadRequest" type:"structure" payload:"MultipartUpload"`

	// Name of the bucket to which the multipart upload was initiated.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Object key for which the multipart upload was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The container for the multipart upload request information.
	MultipartUpload *CompletedMultipartUpload `locationName:"CompleteMultipartUpload" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Date on which it will be legal to delete or modify the object. This field
	// can only be specified if Retention-Directive is REPLACE. You can only specify
	// this or the Retention-Period header. If both are specified a 400 error will
	// be returned. If neither is specified the bucket's DefaultRetention period
	// will be used.
	RetentionExpirationDate *time.Time `location:"header" locationName:"Retention-Expiration-Date" type:"timestamp"`

	// A single legal hold to apply to the object. This field can only be specified
	// if Retention-Directive is REPLACE. A legal hold is a character long string
	// of max length 64. The object cannot be overwritten or deleted until all legal
	// holds associated with the object are removed.
	RetentionLegalHoldId *string `location:"header" locationName:"Retention-Legal-Hold-ID" type:"string"`

	// Retention period to store on the object in seconds. If this field and Retention-Expiration-Date
	// are specified a 400 error is returned. If neither is specified the bucket's
	// DefaultRetention period will be used. 0 is a legal value assuming the bucket's
	// minimum retention period is also 0.
	RetentionPeriod *int64 `location:"header" locationName:"Retention-Period" type:"integer"`

	// ID for the initiated multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *CompleteMultipartUploadInput) SetBucket(v string) *CompleteMultipartUploadInput {
	s.Bucket = &v
	return s
}

func (s *CompleteMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *CompleteMultipartUploadInput) SetExpectedBucketOwner(v string) *CompleteMultipartUploadInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CompleteMultipartUploadInput) SetKey(v string) *CompleteMultipartUploadInput {
	s.Key = &v
	return s
}

// SetMultipartUpload sets the MultipartUpload field's value.
func (s *CompleteMultipartUploadInput) SetMultipartUpload(v *CompletedMultipartUpload) *CompleteMultipartUploadInput {
	s.MultipartUpload = v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CompleteMultipartUploadInput) SetRequestPayer(v string) *CompleteMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetRetentionExpirationDate sets the RetentionExpirationDate field's value.
func (s *CompleteMultipartUploadInput) SetRetentionExpirationDate(v time.Time) *CompleteMultipartUploadInput {
	s.RetentionExpirationDate = &v
	return s
}

// SetRetentionLegalHoldId sets the RetentionLegalHoldId field's value.
func (s *CompleteMultipartUploadInput) SetRetentionLegalHoldId(v string) *CompleteMultipartUploadInput {
	s.RetentionLegalHoldId = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CompleteMultipartUploadInput) SetRetentionPeriod(v int64) *CompleteMultipartUploadInput {
	s.RetentionPeriod = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CompleteMultipartUploadInput) SetUploadId(v string) *CompleteMultipartUploadInput {
	s.UploadId = &v
	return s
}

type CompleteMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket that contains the newly created object.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	Bucket *string `type:"string"`

	// Entity tag that identifies the newly created object's data. Objects with
	// different object data will have different entity tags. The entity tag is
	// an opaque string. The entity tag may or may not be an MD5 digest of the object
	// data. If the entity tag is not an MD5 digest of the object data, it will
	// contain one or more nonhexadecimal characters and/or will consist of less
	// than 32 or more than 32 hexadecimal digits.
	ETag *string `type:"string"`

	// If the object expiration is configured, this will contain the expiration
	// date (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The object key of the newly created object.
	Key *string `min:"1" type:"string"`

	// The URI that identifies the newly created object.
	Location *string `type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If present, specifies the ID of the AWS Key Management Service (AWS KMS)
	// symmetric customer managed customer master key (CMK) that was used for the
	// object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// If you specified server-side encryption either with an Amazon S3-managed
	// encryption key or an AWS KMS customer master key (CMK) in your initiate multipart
	// upload request, the response includes this header. It confirms the encryption
	// algorithm that Amazon S3 used to encrypt the object.
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version ID of the newly created object, in case the bucket has versioning
	// turned on.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s CompleteMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *CompleteMultipartUploadOutput) SetBucket(v string) *CompleteMultipartUploadOutput {
	s.Bucket = &v
	return s
}

func (s *CompleteMultipartUploadOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetETag sets the ETag field's value.
func (s *CompleteMultipartUploadOutput) SetETag(v string) *CompleteMultipartUploadOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *CompleteMultipartUploadOutput) SetExpiration(v string) *CompleteMultipartUploadOutput {
	s.Expiration = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CompleteMultipartUploadOutput) SetKey(v string) *CompleteMultipartUploadOutput {
	s.Key = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CompleteMultipartUploadOutput) SetLocation(v string) *CompleteMultipartUploadOutput {
	s.Location = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CompleteMultipartUploadOutput) SetRequestCharged(v string) *CompleteMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CompleteMultipartUploadOutput) SetSSEKMSKeyId(v string) *CompleteMultipartUploadOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CompleteMultipartUploadOutput) SetServerSideEncryption(v string) *CompleteMultipartUploadOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CompleteMultipartUploadOutput) SetVersionId(v string) *CompleteMultipartUploadOutput {
	s.VersionId = &v
	return s
}

// The container for the completed multipart upload details.
type CompletedMultipartUpload struct {
	_ struct{} `type:"structure"`

	// Array of CompletedPart data types.
	Parts []*CompletedPart `locationName:"Part" type:"list" flattened:"true"`
}

// String returns the string representation
func (s CompletedMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompletedMultipartUpload) GoString() string {
	return s.String()
}

// SetParts sets the Parts field's value.
func (s *CompletedMultipartUpload) SetParts(v []*CompletedPart) *CompletedMultipartUpload {
	s.Parts = v
	return s
}

// Details of the parts that were uploaded.
type CompletedPart struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Part number that identifies the part. This is a positive integer between
	// 1 and 10,000.
	PartNumber *int64 `type:"integer"`
}

// String returns the string representation
func (s CompletedPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompletedPart) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CompletedPart) SetETag(v string) *CompletedPart {
	s.ETag = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *CompletedPart) SetPartNumber(v int64) *CompletedPart {
	s.PartNumber = &v
	return s
}

// A container for describing a condition that must be met for the specified
// redirect to apply. For example, 1. If request is for pages in the /docs folder,
// redirect to the /documents folder. 2. If request results in HTTP error 4xx,
// redirect request to another host where you might process the error.
type Condition struct {
	_ struct{} `type:"structure"`

	// The HTTP error code when the redirect is applied. In the event of an error,
	// if the error code equals this value, then the specified redirect is applied.
	// Required when parent element Condition is specified and sibling KeyPrefixEquals
	// is not specified. If both are specified, then both must be true for the redirect
	// to be applied.
	HttpErrorCodeReturnedEquals *string `type:"string"`

	// The object key name prefix when the redirect is applied. For example, to
	// redirect requests for ExamplePage.html, the key prefix will be ExamplePage.html.
	// To redirect request for all pages with the prefix docs/, the key prefix will
	// be /docs, which identifies all objects in the docs/ folder. Required when
	// the parent element Condition is specified and sibling HttpErrorCodeReturnedEquals
	// is not specified. If both conditions are specified, both must be true for
	// the redirect to be applied.
	//
	// Replacement must be made for object keys containing special characters (such
	// as carriage returns) when using XML requests. For more information, see XML
	// related object key constraints (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
	KeyPrefixEquals *string `type:"string"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// SetHttpErrorCodeReturnedEquals sets the HttpErrorCodeReturnedEquals field's value.
func (s *Condition) SetHttpErrorCodeReturnedEquals(v string) *Condition {
	s.HttpErrorCodeReturnedEquals = &v
	return s
}

// SetKeyPrefixEquals sets the KeyPrefixEquals field's value.
func (s *Condition) SetKeyPrefixEquals(v string) *Condition {
	s.KeyPrefixEquals = &v
	return s
}

type CopyObjectInput struct {
	_ struct{} `locationName:"CopyObjectRequest" type:"structure"`

	// The canned ACL to apply to the object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// The name of the destination bucket.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies the source object for the copy operation. You specify the value
	// in one of two formats, depending on whether you want to access the source
	// object through an access point (https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html):
	//
	//    * For objects not accessed through an access point, specify the name of
	//    the source bucket and the key of the source object, separated by a slash
	//    (/). For example, to copy the object reports/january.pdf from the bucket
	//    awsexamplebucket, use awsexamplebucket/reports/january.pdf. The value
	//    must be URL encoded.
	//
	//    * For objects accessed through access points, specify the Amazon Resource
	//    Name (ARN) of the object as accessed through the access point, in the
	//    format arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>.
	//    For example, to copy the object reports/january.pdf through access point
	//    my-access-point owned by account 123456789012 in Region us-west-2, use
	//    the URL encoding of arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf.
	//    The value must be URL encoded. Amazon S3 supports copy operations using
	//    access points only when the source and destination buckets are in the
	//    same AWS Region. Alternatively, for objects accessed through Amazon S3
	//    on Outposts, specify the ARN of the object as accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>.
	//    For example, to copy the object reports/january.pdf through outpost my-outpost
	//    owned by account 123456789012 in Region us-west-2, use the URL encoding
	//    of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf.
	//    The value must be URL encoded.
	//
	// To copy a specific version of an object, append ?versionId=<version-id> to
	// the value (for example, awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893).
	// If you don't specify a version ID, Amazon S3 copies the latest version of
	// the source object.
	//
	// CopySource is a required field
	CopySource *string `location:"header" locationName:"x-amz-copy-source" type:"string" required:"true"`

	// Copies the object if its entity tag (ETag) matches the specified tag.
	CopySourceIfMatch *string `location:"header" locationName:"x-amz-copy-source-if-match" type:"string"`

	// Copies the object if it has been modified since the specified time.
	CopySourceIfModifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-modified-since" type:"timestamp"`

	// Copies the object if its entity tag (ETag) is different than the specified
	// ETag.
	CopySourceIfNoneMatch *string `location:"header" locationName:"x-amz-copy-source-if-none-match" type:"string"`

	// Copies the object if it hasn't been modified since the specified time.
	CopySourceIfUnmodifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-unmodified-since" type:"timestamp"`

	// Specifies the algorithm to use when decrypting the source object (for example,
	// AES256).
	CopySourceSSECustomerAlgorithm *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use to decrypt
	// the source object. The encryption key provided in this header must be one
	// that was used when the source object was created.
	CopySourceSSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	CopySourceSSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key-MD5" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// The key of the destination object.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Specifies whether the metadata is copied from the source object or replaced
	// with metadata provided in the request.
	MetadataDirective *string `location:"header" locationName:"x-amz-metadata-directive" type:"string" enum:"MetadataDirective"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// This header controls how the Protection state of the source object is copied
	// to the destination object.If copied, the retention period and all legal holds
	// are copied onto the new object. The legal hold date's is set to the date
	// of the copy.
	RetentionDirective *string `location:"header" locationName:"Retention-Directive" type:"string" enum:"RetentionDirective"`

	// Date on which it will be legal to delete or modify the object. This field
	// can only be specified if Retention-Directive is REPLACE. You can only specify
	// this or the Retention-Period header. If both are specified a 400 error will
	// be returned. If neither is specified the bucket's DefaultRetention period
	// will be used.
	RetentionExpirationDate *time.Time `location:"header" locationName:"Retention-Expiration-Date" type:"timestamp"`

	// A single legal hold to apply to the object. This field can only be specified
	// if Retention-Directive is REPLACE. A legal hold is a character long string
	// of max length 64. The object cannot be overwritten or deleted until all legal
	// holds associated with the object are removed.
	RetentionLegalHoldId *string `location:"header" locationName:"Retention-Legal-Hold-ID" type:"string"`

	// Retention period to store on the object in seconds. The object can be neither
	// overwritten nor deleted until the amount of time specified in the retention
	// period has elapsed. If this field and Retention-Expiration-Date are specified
	// a 400 error is returned. If neither is specified the bucket's DefaultRetention
	// period will be used. 0 is a legal value assuming the bucket's minimum retention
	// period is also 0.
	RetentionPeriod *int64 `location:"header" locationName:"Retention-Period" type:"integer"`

	// Specifies the algorithm to use to when encrypting the object (for example,
	// AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// S3 does not store the encryption key. The key must be appropriate for use
	// with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. For information about configuring using any of the officially
	// supported AWS SDKs and AWS CLI, see Specifying the Signature Version in Request
	// Authentication (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version)
	// in the Amazon S3 Developer Guide.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// By default, Amazon S3 uses the STANDARD Storage Class to store newly created
	// objects. The STANDARD storage class provides high durability and high availability.
	// Depending on performance needs, you can specify a different Storage Class.
	// Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information,
	// see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html)
	// in the Amazon S3 Service Developer Guide.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// The tag-set for the object destination object this value must be used in
	// conjunction with the TaggingDirective. The tag-set must be encoded as URL
	// Query parameters.
	Tagging *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// Specifies whether the object tag-set are copied from the source object or
	// replaced with tag-set provided in the request.
	TaggingDirective *string `location:"header" locationName:"x-amz-tagging-directive" type:"string" enum:"TaggingDirective"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s CopyObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.CopySource == nil {
		invalidParams.Add(request.NewErrParamRequired("CopySource"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CopyObjectInput) SetACL(v string) *CopyObjectInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CopyObjectInput) SetBucket(v string) *CopyObjectInput {
	s.Bucket = &v
	return s
}

func (s *CopyObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCacheControl sets the CacheControl field's value.
func (s *CopyObjectInput) SetCacheControl(v string) *CopyObjectInput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *CopyObjectInput) SetContentDisposition(v string) *CopyObjectInput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *CopyObjectInput) SetContentEncoding(v string) *CopyObjectInput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *CopyObjectInput) SetContentLanguage(v string) *CopyObjectInput {
	s.ContentLanguage = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CopyObjectInput) SetContentType(v string) *CopyObjectInput {
	s.ContentType = &v
	return s
}

// SetCopySource sets the CopySource field's value.
func (s *CopyObjectInput) SetCopySource(v string) *CopyObjectInput {
	s.CopySource = &v
	return s
}

// SetCopySourceIfMatch sets the CopySourceIfMatch field's value.
func (s *CopyObjectInput) SetCopySourceIfMatch(v string) *CopyObjectInput {
	s.CopySourceIfMatch = &v
	return s
}

// SetCopySourceIfModifiedSince sets the CopySourceIfModifiedSince field's value.
func (s *CopyObjectInput) SetCopySourceIfModifiedSince(v time.Time) *CopyObjectInput {
	s.CopySourceIfModifiedSince = &v
	return s
}

// SetCopySourceIfNoneMatch sets the CopySourceIfNoneMatch field's value.
func (s *CopyObjectInput) SetCopySourceIfNoneMatch(v string) *CopyObjectInput {
	s.CopySourceIfNoneMatch = &v
	return s
}

// SetCopySourceIfUnmodifiedSince sets the CopySourceIfUnmodifiedSince field's value.
func (s *CopyObjectInput) SetCopySourceIfUnmodifiedSince(v time.Time) *CopyObjectInput {
	s.CopySourceIfUnmodifiedSince = &v
	return s
}

// SetCopySourceSSECustomerAlgorithm sets the CopySourceSSECustomerAlgorithm field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerAlgorithm(v string) *CopyObjectInput {
	s.CopySourceSSECustomerAlgorithm = &v
	return s
}

// SetCopySourceSSECustomerKey sets the CopySourceSSECustomerKey field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerKey(v string) *CopyObjectInput {
	s.CopySourceSSECustomerKey = &v
	return s
}

func (s *CopyObjectInput) getCopySourceSSECustomerKey() (v string) {
	if s.CopySourceSSECustomerKey == nil {
		return v
	}
	return *s.CopySourceSSECustomerKey
}

// SetCopySourceSSECustomerKeyMD5 sets the CopySourceSSECustomerKeyMD5 field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerKeyMD5(v string) *CopyObjectInput {
	s.CopySourceSSECustomerKeyMD5 = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *CopyObjectInput) SetExpires(v time.Time) *CopyObjectInput {
	s.Expires = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CopyObjectInput) SetGrantFullControl(v string) *CopyObjectInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CopyObjectInput) SetGrantRead(v string) *CopyObjectInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CopyObjectInput) SetGrantReadACP(v string) *CopyObjectInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CopyObjectInput) SetGrantWriteACP(v string) *CopyObjectInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CopyObjectInput) SetKey(v string) *CopyObjectInput {
	s.Key = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CopyObjectInput) SetMetadata(v map[string]*string) *CopyObjectInput {
	s.Metadata = v
	return s
}

// SetMetadataDirective sets the MetadataDirective field's value.
func (s *CopyObjectInput) SetMetadataDirective(v string) *CopyObjectInput {
	s.MetadataDirective = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CopyObjectInput) SetRequestPayer(v string) *CopyObjectInput {
	s.RequestPayer = &v
	return s
}

// SetRetentionDirective sets the RetentionDirective field's value.
func (s *CopyObjectInput) SetRetentionDirective(v string) *CopyObjectInput {
	s.RetentionDirective = &v
	return s
}

// SetRetentionExpirationDate sets the RetentionExpirationDate field's value.
func (s *CopyObjectInput) SetRetentionExpirationDate(v time.Time) *CopyObjectInput {
	s.RetentionExpirationDate = &v
	return s
}

// SetRetentionLegalHoldId sets the RetentionLegalHoldId field's value.
func (s *CopyObjectInput) SetRetentionLegalHoldId(v string) *CopyObjectInput {
	s.RetentionLegalHoldId = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CopyObjectInput) SetRetentionPeriod(v int64) *CopyObjectInput {
	s.RetentionPeriod = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CopyObjectInput) SetSSECustomerAlgorithm(v string) *CopyObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *CopyObjectInput) SetSSECustomerKey(v string) *CopyObjectInput {
	s.SSECustomerKey = &v
	return s
}

func (s *CopyObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CopyObjectInput) SetSSECustomerKeyMD5(v string) *CopyObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CopyObjectInput) SetSSEKMSKeyId(v string) *CopyObjectInput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CopyObjectInput) SetServerSideEncryption(v string) *CopyObjectInput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *CopyObjectInput) SetStorageClass(v string) *CopyObjectInput {
	s.StorageClass = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *CopyObjectInput) SetTagging(v string) *CopyObjectInput {
	s.Tagging = &v
	return s
}

// SetTaggingDirective sets the TaggingDirective field's value.
func (s *CopyObjectInput) SetTaggingDirective(v string) *CopyObjectInput {
	s.TaggingDirective = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *CopyObjectInput) SetWebsiteRedirectLocation(v string) *CopyObjectInput {
	s.WebsiteRedirectLocation = &v
	return s
}

type CopyObjectOutput struct {
	_ struct{} `type:"structure" payload:"CopyObjectResult"`

	// Container for all response elements.
	CopyObjectResult *CopyObjectResult `type:"structure"`

	// Version of the copied object in the destination bucket.
	CopySourceVersionId *string `location:"header" locationName:"x-amz-copy-source-version-id" type:"string"`

	// If the object expiration is configured, the response includes this header.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round-trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (AWS KMS)
	// symmetric customer managed customer master key (CMK) that was used for the
	// object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version ID of the newly created copy.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s CopyObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectOutput) GoString() string {
	return s.String()
}

// SetCopyObjectResult sets the CopyObjectResult field's value.
func (s *CopyObjectOutput) SetCopyObjectResult(v *CopyObjectResult) *CopyObjectOutput {
	s.CopyObjectResult = v
	return s
}

// SetCopySourceVersionId sets the CopySourceVersionId field's value.
func (s *CopyObjectOutput) SetCopySourceVersionId(v string) *CopyObjectOutput {
	s.CopySourceVersionId = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *CopyObjectOutput) SetExpiration(v string) *CopyObjectOutput {
	s.Expiration = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CopyObjectOutput) SetRequestCharged(v string) *CopyObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CopyObjectOutput) SetSSECustomerAlgorithm(v string) *CopyObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CopyObjectOutput) SetSSECustomerKeyMD5(v string) *CopyObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CopyObjectOutput) SetSSEKMSKeyId(v string) *CopyObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CopyObjectOutput) SetServerSideEncryption(v string) *CopyObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CopyObjectOutput) SetVersionId(v string) *CopyObjectOutput {
	s.VersionId = &v
	return s
}

// Container for all response elements.
type CopyObjectResult struct {
	_ struct{} `type:"structure"`

	// Returns the ETag of the new object. The ETag reflects only changes to the
	// contents of an object, not its metadata. The source and destination ETag
	// is identical for a successfully copied non-multipart object.
	ETag *string `type:"string"`

	// Creation date of the object.
	LastModified *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CopyObjectResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectResult) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CopyObjectResult) SetETag(v string) *CopyObjectResult {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *CopyObjectResult) SetLastModified(v time.Time) *CopyObjectResult {
	s.LastModified = &v
	return s
}

// Container for all response elements.
type CopyPartResult struct {
	_ struct{} `type:"structure"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// Date and time at which the object was uploaded.
	LastModified *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CopyPartResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyPartResult) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CopyPartResult) SetETag(v string) *CopyPartResult {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *CopyPartResult) SetLastModified(v time.Time) *CopyPartResult {
	s.LastModified = &v
	return s
}

// The configuration information for the bucket.
type CreateBucketConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the Region where the bucket will be created. If you don't specify
	// a Region, the bucket is created in the US East (N. Virginia) Region (us-east-1).
	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation
func (s CreateBucketConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketConfiguration) GoString() string {
	return s.String()
}

// SetLocationConstraint sets the LocationConstraint field's value.
func (s *CreateBucketConfiguration) SetLocationConstraint(v string) *CreateBucketConfiguration {
	s.LocationConstraint = &v
	return s
}

type CreateBucketInput struct {
	_ struct{} `locationName:"CreateBucketRequest" type:"structure" payload:"CreateBucketConfiguration"`

	// The canned ACL to apply to the bucket.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"BucketCannedACL"`

	// The name of the bucket to create.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The configuration information for the bucket.
	CreateBucketConfiguration *CreateBucketConfiguration `locationName:"CreateBucketConfiguration" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// The root key used by Key Protect to encrypt this bucket. This value must
	// be the full CRN of the root key.
	IBMSSEKPCustomerRootKeyCrn *string `location:"header" locationName:"ibm-sse-kp-customer-root-key-crn" type:"string"`

	// The algorithm and key size to use with the encryption key stored by using
	// Key Protect. This value must be set to the string "AES256".
	IBMSSEKPEncryptionAlgorithm *string `location:"header" locationName:"ibm-sse-kp-encryption-algorithm" type:"string"`

	// Sets the IBM Service Instance Id in the request.
	//
	// Only Valid for IBM IAM Authentication
	IBMServiceInstanceId *string `location:"header" locationName:"ibm-service-instance-id" type:"string"`
}

// String returns the string representation
func (s CreateBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CreateBucketInput) SetACL(v string) *CreateBucketInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateBucketInput) SetBucket(v string) *CreateBucketInput {
	s.Bucket = &v
	return s
}

func (s *CreateBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCreateBucketConfiguration sets the CreateBucketConfiguration field's value.
func (s *CreateBucketInput) SetCreateBucketConfiguration(v *CreateBucketConfiguration) *CreateBucketInput {
	s.CreateBucketConfiguration = v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CreateBucketInput) SetGrantFullControl(v string) *CreateBucketInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CreateBucketInput) SetGrantRead(v string) *CreateBucketInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CreateBucketInput) SetGrantReadACP(v string) *CreateBucketInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *CreateBucketInput) SetGrantWrite(v string) *CreateBucketInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CreateBucketInput) SetGrantWriteACP(v string) *CreateBucketInput {
	s.GrantWriteACP = &v
	return s
}

// SetIBMSSEKPCustomerRootKeyCrn sets the IBMSSEKPCustomerRootKeyCrn field's value.
func (s *CreateBucketInput) SetIBMSSEKPCustomerRootKeyCrn(v string) *CreateBucketInput {
	s.IBMSSEKPCustomerRootKeyCrn = &v
	return s
}

// SetIBMSSEKPEncryptionAlgorithm sets the IBMSSEKPEncryptionAlgorithm field's value.
func (s *CreateBucketInput) SetIBMSSEKPEncryptionAlgorithm(v string) *CreateBucketInput {
	s.IBMSSEKPEncryptionAlgorithm = &v
	return s
}

// SetIBMServiceInstanceId sets the IBMServiceInstanceId field's value.
func (s *CreateBucketInput) SetIBMServiceInstanceId(v string) *CreateBucketInput {
	s.IBMServiceInstanceId = &v
	return s
}

type CreateBucketOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the Region where the bucket will be created. If you are creating
	// a bucket on the US East (N. Virginia) Region (us-east-1), you do not need
	// to specify the location.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketOutput) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *CreateBucketOutput) SetLocation(v string) *CreateBucketOutput {
	s.Location = &v
	return s
}

type CreateMultipartUploadInput struct {
	_ struct{} `locationName:"CreateMultipartUploadRequest" type:"structure"`

	// The canned ACL to apply to the object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// The name of the bucket to which to initiate the upload
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Object key for which the multipart upload is to be initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (for example,
	// AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// S3 does not store the encryption key. The key must be appropriate for use
	// with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the ID of the symmetric customer managed AWS KMS CMK to use for
	// object encryption. All GET and PUT requests for an object protected by AWS
	// KMS will fail if not made via SSL or using SigV4. For information about configuring
	// using any of the officially supported AWS SDKs and AWS CLI, see Specifying
	// the Signature Version in Request Authentication (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version)
	// in the Amazon S3 Developer Guide.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// By default, Amazon S3 uses the STANDARD Storage Class to store newly created
	// objects. The STANDARD storage class provides high durability and high availability.
	// Depending on performance needs, you can specify a different Storage Class.
	// Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information,
	// see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html)
	// in the Amazon S3 Service Developer Guide.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// The tag-set for the object. The tag-set must be encoded as URL Query parameters.
	Tagging *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s CreateMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CreateMultipartUploadInput) SetACL(v string) *CreateMultipartUploadInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateMultipartUploadInput) SetBucket(v string) *CreateMultipartUploadInput {
	s.Bucket = &v
	return s
}

func (s *CreateMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCacheControl sets the CacheControl field's value.
func (s *CreateMultipartUploadInput) SetCacheControl(v string) *CreateMultipartUploadInput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *CreateMultipartUploadInput) SetContentDisposition(v string) *CreateMultipartUploadInput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *CreateMultipartUploadInput) SetContentEncoding(v string) *CreateMultipartUploadInput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *CreateMultipartUploadInput) SetContentLanguage(v string) *CreateMultipartUploadInput {
	s.ContentLanguage = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CreateMultipartUploadInput) SetContentType(v string) *CreateMultipartUploadInput {
	s.ContentType = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *CreateMultipartUploadInput) SetExpires(v time.Time) *CreateMultipartUploadInput {
	s.Expires = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CreateMultipartUploadInput) SetGrantFullControl(v string) *CreateMultipartUploadInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CreateMultipartUploadInput) SetGrantRead(v string) *CreateMultipartUploadInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CreateMultipartUploadInput) SetGrantReadACP(v string) *CreateMultipartUploadInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CreateMultipartUploadInput) SetGrantWriteACP(v string) *CreateMultipartUploadInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CreateMultipartUploadInput) SetKey(v string) *CreateMultipartUploadInput {
	s.Key = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateMultipartUploadInput) SetMetadata(v map[string]*string) *CreateMultipartUploadInput {
	s.Metadata = v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CreateMultipartUploadInput) SetRequestPayer(v string) *CreateMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerAlgorithm(v string) *CreateMultipartUploadInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerKey(v string) *CreateMultipartUploadInput {
	s.SSECustomerKey = &v
	return s
}

func (s *CreateMultipartUploadInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerKeyMD5(v string) *CreateMultipartUploadInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CreateMultipartUploadInput) SetSSEKMSKeyId(v string) *CreateMultipartUploadInput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CreateMultipartUploadInput) SetServerSideEncryption(v string) *CreateMultipartUploadInput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *CreateMultipartUploadInput) SetStorageClass(v string) *CreateMultipartUploadInput {
	s.StorageClass = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *CreateMultipartUploadInput) SetTagging(v string) *CreateMultipartUploadInput {
	s.Tagging = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *CreateMultipartUploadInput) SetWebsiteRedirectLocation(v string) *CreateMultipartUploadInput {
	s.WebsiteRedirectLocation = &v
	return s
}

type CreateMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// If the bucket has a lifecycle rule configured with an action to abort incomplete
	// multipart uploads and the prefix in the lifecycle rule matches the object
	// name in the request, the response includes this header. The header indicates
	// when the initiated multipart upload becomes eligible for an abort operation.
	// For more information, see Aborting Incomplete Multipart Uploads Using a Bucket
	// Lifecycle Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config).
	//
	// The response also includes the x-amz-abort-rule-id header that provides the
	// ID of the lifecycle configuration rule that defines this action.
	AbortDate *time.Time `location:"header" locationName:"x-amz-abort-date" type:"timestamp"`

	// This header is returned along with the x-amz-abort-date header. It identifies
	// the applicable lifecycle configuration rule that defines the action to abort
	// incomplete multipart uploads.
	AbortRuleId *string `location:"header" locationName:"x-amz-abort-rule-id" type:"string"`

	// The name of the bucket to which the multipart upload was initiated.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	Bucket *string `locationName:"Bucket" type:"string"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round-trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (AWS KMS)
	// symmetric customer managed customer master key (CMK) that was used for the
	// object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// ID for the initiated multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s CreateMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetAbortDate sets the AbortDate field's value.
func (s *CreateMultipartUploadOutput) SetAbortDate(v time.Time) *CreateMultipartUploadOutput {
	s.AbortDate = &v
	return s
}

// SetAbortRuleId sets the AbortRuleId field's value.
func (s *CreateMultipartUploadOutput) SetAbortRuleId(v string) *CreateMultipartUploadOutput {
	s.AbortRuleId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateMultipartUploadOutput) SetBucket(v string) *CreateMultipartUploadOutput {
	s.Bucket = &v
	return s
}

func (s *CreateMultipartUploadOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *CreateMultipartUploadOutput) SetKey(v string) *CreateMultipartUploadOutput {
	s.Key = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CreateMultipartUploadOutput) SetRequestCharged(v string) *CreateMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CreateMultipartUploadOutput) SetSSECustomerAlgorithm(v string) *CreateMultipartUploadOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CreateMultipartUploadOutput) SetSSECustomerKeyMD5(v string) *CreateMultipartUploadOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CreateMultipartUploadOutput) SetSSEKMSKeyId(v string) *CreateMultipartUploadOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CreateMultipartUploadOutput) SetServerSideEncryption(v string) *CreateMultipartUploadOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CreateMultipartUploadOutput) SetUploadId(v string) *CreateMultipartUploadOutput {
	s.UploadId = &v
	return s
}

// Container for the objects to delete.
type Delete struct {
	_ struct{} `type:"structure"`

	// The objects to delete.
	//
	// Objects is a required field
	Objects []*ObjectIdentifier `locationName:"Object" type:"list" flattened:"true" required:"true"`

	// Element to enable quiet mode for the request. When you add this element,
	// you must set its value to true.
	Quiet *bool `type:"boolean"`
}

// String returns the string representation
func (s Delete) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Delete) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Delete) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Delete"}
	if s.Objects == nil {
		invalidParams.Add(request.NewErrParamRequired("Objects"))
	}
	if s.Objects != nil {
		for i, v := range s.Objects {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Objects", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjects sets the Objects field's value.
func (s *Delete) SetObjects(v []*ObjectIdentifier) *Delete {
	s.Objects = v
	return s
}

// SetQuiet sets the Quiet field's value.
func (s *Delete) SetQuiet(v bool) *Delete {
	s.Quiet = &v
	return s
}

type DeleteBucketCorsInput struct {
	_ struct{} `locationName:"DeleteBucketCorsRequest" type:"structure"`

	// Specifies the bucket whose cors configuration is being deleted.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s DeleteBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketCorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketCorsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketCorsInput) SetBucket(v string) *DeleteBucketCorsInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketCorsInput) SetExpectedBucketOwner(v string) *DeleteBucketCorsInput {
	s.ExpectedBucketOwner = &v
	return s
}

type DeleteBucketCorsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketCorsOutput) GoString() string {
	return s.String()
}

type DeleteBucketInput struct {
	_ struct{} `locationName:"DeleteBucketRequest" type:"structure"`

	// Specifies the bucket being deleted.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s DeleteBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketInput) SetBucket(v string) *DeleteBucketInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketInput) SetExpectedBucketOwner(v string) *DeleteBucketInput {
	s.ExpectedBucketOwner = &v
	return s
}

type DeleteBucketLifecycleInput struct {
	_ struct{} `locationName:"DeleteBucketLifecycleRequest" type:"structure"`

	// The bucket name of the lifecycle to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s DeleteBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketLifecycleInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketLifecycleInput) SetBucket(v string) *DeleteBucketLifecycleInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketLifecycleInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketLifecycleInput) SetExpectedBucketOwner(v string) *DeleteBucketLifecycleInput {
	s.ExpectedBucketOwner = &v
	return s
}

type DeleteBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleOutput) GoString() string {
	return s.String()
}

type DeleteBucketOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketOutput) GoString() string {
	return s.String()
}

type DeleteBucketWebsiteInput struct {
	_ struct{} `locationName:"DeleteBucketWebsiteRequest" type:"structure"`

	// The bucket name for which you want to remove the website configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s DeleteBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketWebsiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketWebsiteInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketWebsiteInput) SetBucket(v string) *DeleteBucketWebsiteInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteBucketWebsiteInput) SetExpectedBucketOwner(v string) *DeleteBucketWebsiteInput {
	s.ExpectedBucketOwner = &v
	return s
}

type DeleteBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketWebsiteOutput) GoString() string {
	return s.String()
}

type DeleteLegalHoldInput struct {
	_ struct{} `locationName:"DeleteLegalHoldRequest" type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// RetentionLegalHoldId is a required field
	RetentionLegalHoldId *string `location:"querystring" locationName:"remove" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLegalHoldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLegalHoldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLegalHoldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLegalHoldInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.RetentionLegalHoldId == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionLegalHoldId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteLegalHoldInput) SetBucket(v string) *DeleteLegalHoldInput {
	s.Bucket = &v
	return s
}

func (s *DeleteLegalHoldInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *DeleteLegalHoldInput) SetKey(v string) *DeleteLegalHoldInput {
	s.Key = &v
	return s
}

// SetRetentionLegalHoldId sets the RetentionLegalHoldId field's value.
func (s *DeleteLegalHoldInput) SetRetentionLegalHoldId(v string) *DeleteLegalHoldInput {
	s.RetentionLegalHoldId = &v
	return s
}

type DeleteLegalHoldOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLegalHoldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLegalHoldOutput) GoString() string {
	return s.String()
}

// Information about the delete marker.
type DeleteMarkerEntry struct {
	_ struct{} `type:"structure"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp"`

	// The account that created the delete marker.>
	Owner *Owner `type:"structure"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeleteMarkerEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMarkerEntry) GoString() string {
	return s.String()
}

// SetIsLatest sets the IsLatest field's value.
func (s *DeleteMarkerEntry) SetIsLatest(v bool) *DeleteMarkerEntry {
	s.IsLatest = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteMarkerEntry) SetKey(v string) *DeleteMarkerEntry {
	s.Key = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *DeleteMarkerEntry) SetLastModified(v time.Time) *DeleteMarkerEntry {
	s.LastModified = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DeleteMarkerEntry) SetOwner(v *Owner) *DeleteMarkerEntry {
	s.Owner = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteMarkerEntry) SetVersionId(v string) *DeleteMarkerEntry {
	s.VersionId = &v
	return s
}

type DeleteObjectInput struct {
	_ struct{} `locationName:"DeleteObjectRequest" type:"structure"`

	// The bucket name of the bucket containing the object.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Key name of the object to delete.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device. Required to
	// permanently delete a versioned object if versioning is configured with MFA
	// delete enabled.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s DeleteObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteObjectInput) SetBucket(v string) *DeleteObjectInput {
	s.Bucket = &v
	return s
}

func (s *DeleteObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteObjectInput) SetExpectedBucketOwner(v string) *DeleteObjectInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteObjectInput) SetKey(v string) *DeleteObjectInput {
	s.Key = &v
	return s
}

// SetMFA sets the MFA field's value.
func (s *DeleteObjectInput) SetMFA(v string) *DeleteObjectInput {
	s.MFA = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *DeleteObjectInput) SetRequestPayer(v string) *DeleteObjectInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectInput) SetVersionId(v string) *DeleteObjectInput {
	s.VersionId = &v
	return s
}

type DeleteObjectOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the versioned object that was permanently deleted was (true)
	// or was not (false) a delete marker.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Returns the version ID of the delete marker created as a result of the DELETE
	// operation.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s DeleteObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectOutput) GoString() string {
	return s.String()
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *DeleteObjectOutput) SetDeleteMarker(v bool) *DeleteObjectOutput {
	s.DeleteMarker = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *DeleteObjectOutput) SetRequestCharged(v string) *DeleteObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectOutput) SetVersionId(v string) *DeleteObjectOutput {
	s.VersionId = &v
	return s
}

type DeleteObjectTaggingInput struct {
	_ struct{} `locationName:"DeleteObjectTaggingRequest" type:"structure"`

	// The bucket name containing the objects from which to remove the tags.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The key that identifies the object in the bucket from which to remove all
	// tags.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The versionId of the object that the tag-set will be removed from.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s DeleteObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteObjectTaggingInput) SetBucket(v string) *DeleteObjectTaggingInput {
	s.Bucket = &v
	return s
}

func (s *DeleteObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteObjectTaggingInput) SetExpectedBucketOwner(v string) *DeleteObjectTaggingInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteObjectTaggingInput) SetKey(v string) *DeleteObjectTaggingInput {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectTaggingInput) SetVersionId(v string) *DeleteObjectTaggingInput {
	s.VersionId = &v
	return s
}

type DeleteObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	// The versionId of the object the tag-set was removed from.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s DeleteObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectTaggingOutput) GoString() string {
	return s.String()
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectTaggingOutput) SetVersionId(v string) *DeleteObjectTaggingOutput {
	s.VersionId = &v
	return s
}

type DeleteObjectsInput struct {
	_ struct{} `locationName:"DeleteObjectsRequest" type:"structure" payload:"Delete"`

	// The bucket name containing the objects to delete.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for the request.
	//
	// Delete is a required field
	Delete *Delete `locationName:"Delete" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device. Required to
	// permanently delete a versioned object if versioning is configured with MFA
	// delete enabled.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation
func (s DeleteObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Delete == nil {
		invalidParams.Add(request.NewErrParamRequired("Delete"))
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteObjectsInput) SetBucket(v string) *DeleteObjectsInput {
	s.Bucket = &v
	return s
}

func (s *DeleteObjectsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetDelete sets the Delete field's value.
func (s *DeleteObjectsInput) SetDelete(v *Delete) *DeleteObjectsInput {
	s.Delete = v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeleteObjectsInput) SetExpectedBucketOwner(v string) *DeleteObjectsInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetMFA sets the MFA field's value.
func (s *DeleteObjectsInput) SetMFA(v string) *DeleteObjectsInput {
	s.MFA = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *DeleteObjectsInput) SetRequestPayer(v string) *DeleteObjectsInput {
	s.RequestPayer = &v
	return s
}

type DeleteObjectsOutput struct {
	_ struct{} `type:"structure"`

	// Container element for a successful delete. It identifies the object that
	// was successfully deleted.
	Deleted []*DeletedObject `type:"list" flattened:"true"`

	// Container for a failed delete action that describes the object that Amazon
	// S3 attempted to delete and the error it encountered.
	Errors []*Error `locationName:"Error" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s DeleteObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectsOutput) GoString() string {
	return s.String()
}

// SetDeleted sets the Deleted field's value.
func (s *DeleteObjectsOutput) SetDeleted(v []*DeletedObject) *DeleteObjectsOutput {
	s.Deleted = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *DeleteObjectsOutput) SetErrors(v []*Error) *DeleteObjectsOutput {
	s.Errors = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *DeleteObjectsOutput) SetRequestCharged(v string) *DeleteObjectsOutput {
	s.RequestCharged = &v
	return s
}

type DeletePublicAccessBlockInput struct {
	_ struct{} `locationName:"DeletePublicAccessBlockRequest" type:"structure"`

	// The Amazon S3 bucket whose PublicAccessBlock configuration you want to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s DeletePublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePublicAccessBlockInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeletePublicAccessBlockInput) SetBucket(v string) *DeletePublicAccessBlockInput {
	s.Bucket = &v
	return s
}

func (s *DeletePublicAccessBlockInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *DeletePublicAccessBlockInput) SetExpectedBucketOwner(v string) *DeletePublicAccessBlockInput {
	s.ExpectedBucketOwner = &v
	return s
}

type DeletePublicAccessBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublicAccessBlockOutput) GoString() string {
	return s.String()
}

// Information about the deleted object.
type DeletedObject struct {
	_ struct{} `type:"structure"`

	// Specifies whether the versioned object that was permanently deleted was (true)
	// or was not (false) a delete marker. In a simple DELETE, this header indicates
	// whether (true) or not (false) a delete marker was created.
	DeleteMarker *bool `type:"boolean"`

	// The version ID of the delete marker created as a result of the DELETE operation.
	// If you delete a specific object version, the value returned by this header
	// is the version ID of the object version deleted.
	DeleteMarkerVersionId *string `type:"string"`

	// The name of the deleted object.
	Key *string `min:"1" type:"string"`

	// The version ID of the deleted object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeletedObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletedObject) GoString() string {
	return s.String()
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *DeletedObject) SetDeleteMarker(v bool) *DeletedObject {
	s.DeleteMarker = &v
	return s
}

// SetDeleteMarkerVersionId sets the DeleteMarkerVersionId field's value.
func (s *DeletedObject) SetDeleteMarkerVersionId(v string) *DeletedObject {
	s.DeleteMarkerVersionId = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeletedObject) SetKey(v string) *DeletedObject {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeletedObject) SetVersionId(v string) *DeletedObject {
	s.VersionId = &v
	return s
}

// Container for all error elements.
type Error struct {
	_ struct{} `type:"structure"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// Amazon S3 error codes
	//
	//    * Code: AccessDenied Description: Access Denied HTTP Status Code: 403
	//    Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: AccountProblem Description: There is a problem with your AWS account
	//    that prevents the action from completing successfully. Contact AWS Support
	//    for further assistance. HTTP Status Code: 403 Forbidden SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: AllAccessDisabled Description: All access to this Amazon S3 resource
	//    has been disabled. Contact AWS Support for further assistance. HTTP Status
	//    Code: 403 Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: AmbiguousGrantByEmailAddress Description: The email address you
	//    provided is associated with more than one account. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: AuthorizationHeaderMalformed Description: The authorization header
	//    you provided is invalid. HTTP Status Code: 400 Bad Request HTTP Status
	//    Code: N/A
	//
	//    * Code: BadDigest Description: The Content-MD5 you specified did not match
	//    what we received. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: BucketAlreadyExists Description: The requested bucket name is
	//    not available. The bucket namespace is shared by all users of the system.
	//    Please select a different name and try again. HTTP Status Code: 409 Conflict
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: BucketAlreadyOwnedByYou Description: The bucket you tried to create
	//    already exists, and you own it. Amazon S3 returns this error in all AWS
	//    Regions except in the North Virginia Region. For legacy compatibility,
	//    if you re-create an existing bucket that you already own in the North
	//    Virginia Region, Amazon S3 returns 200 OK and resets the bucket access
	//    control lists (ACLs). Code: 409 Conflict (in all Regions except the North
	//    Virginia Region) SOAP Fault Code Prefix: Client
	//
	//    * Code: BucketNotEmpty Description: The bucket you tried to delete is
	//    not empty. HTTP Status Code: 409 Conflict SOAP Fault Code Prefix: Client
	//
	//    * Code: CredentialsNotSupported Description: This request does not support
	//    credentials. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: CrossLocationLoggingProhibited Description: Cross-location logging
	//    not allowed. Buckets in one geographic location cannot log information
	//    to a bucket in another location. HTTP Status Code: 403 Forbidden SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: EntityTooSmall Description: Your proposed upload is smaller than
	//    the minimum allowed object size. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: EntityTooLarge Description: Your proposed upload exceeds the maximum
	//    allowed object size. HTTP Status Code: 400 Bad Request SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: ExpiredToken Description: The provided token has expired. HTTP
	//    Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: IllegalVersioningConfigurationException Description: Indicates
	//    that the versioning configuration specified in the request is invalid.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: IncompleteBody Description: You did not provide the number of
	//    bytes specified by the Content-Length HTTP header HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: IncorrectNumberOfFilesInPostRequest Description: POST requires
	//    exactly one file upload per request. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: InlineDataTooLarge Description: Inline data exceeds the maximum
	//    allowed size. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InternalError Description: We encountered an internal error. Please
	//    try again. HTTP Status Code: 500 Internal Server Error SOAP Fault Code
	//    Prefix: Server
	//
	//    * Code: InvalidAccessKeyId Description: The AWS access key ID you provided
	//    does not exist in our records. HTTP Status Code: 403 Forbidden SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: InvalidAddressingHeader Description: You must specify the Anonymous
	//    role. HTTP Status Code: N/A SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidArgument Description: Invalid Argument HTTP Status Code:
	//    400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidBucketName Description: The specified bucket is not valid.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidBucketState Description: The request is not valid with
	//    the current state of the bucket. HTTP Status Code: 409 Conflict SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: InvalidDigest Description: The Content-MD5 you specified is not
	//    valid. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidEncryptionAlgorithmError Description: The encryption request
	//    you specified is not valid. The valid value is AES256. HTTP Status Code:
	//    400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidLocationConstraint Description: The specified location
	//    constraint is not valid. For more information about Regions, see How to
	//    Select a Region for Your Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro).
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidObjectState Description: The action is not valid for the
	//    current state of the object. HTTP Status Code: 403 Forbidden SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: InvalidPart Description: One or more of the specified parts could
	//    not be found. The part might not have been uploaded, or the specified
	//    entity tag might not have matched the part's entity tag. HTTP Status Code:
	//    400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidPartOrder Description: The list of parts was not in ascending
	//    order. Parts list must be specified in order by part number. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidPayer Description: All access to this object has been disabled.
	//    Please contact AWS Support for further assistance. HTTP Status Code: 403
	//    Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidPolicyDocument Description: The content of the form does
	//    not meet the conditions specified in the policy document. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidRange Description: The requested range cannot be satisfied.
	//    HTTP Status Code: 416 Requested Range Not Satisfiable SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: InvalidRequest Description: Please use AWS4-HMAC-SHA256. HTTP
	//    Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: SOAP requests must be made over an
	//    HTTPS connection. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration is
	//    not supported for buckets with non-DNS compliant names. HTTP Status Code:
	//    400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration is
	//    not supported for buckets with periods (.) in their names. HTTP Status
	//    Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Accelerate endpoint
	//    only supports virtual style requests. HTTP Status Code: 400 Bad Request
	//    Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Accelerate is not
	//    configured on this bucket. HTTP Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Accelerate is disabled
	//    on this bucket. HTTP Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration is
	//    not supported on this bucket. Contact AWS Support for more information.
	//    HTTP Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration cannot
	//    be enabled on this bucket. Contact AWS Support for more information. HTTP
	//    Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidSecurity Description: The provided security credentials
	//    are not valid. HTTP Status Code: 403 Forbidden SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InvalidSOAPRequest Description: The SOAP request body is invalid.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidStorageClass Description: The storage class you specified
	//    is not valid. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InvalidTargetBucketForLogging Description: The target bucket for
	//    logging does not exist, is not owned by you, or does not have the appropriate
	//    grants for the log-delivery group. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: InvalidToken Description: The provided token is malformed or otherwise
	//    invalid. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidURI Description: Couldn't parse the specified URI. HTTP
	//    Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: KeyTooLongError Description: Your key is too long. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MalformedACLError Description: The XML you provided was not well-formed
	//    or did not validate against our published schema. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MalformedPOSTRequest Description: The body of your POST request
	//    is not well-formed multipart/form-data. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: MalformedXML Description: This happens when the user sends malformed
	//    XML (XML that doesn't conform to the published XSD) for the configuration.
	//    The error message is, "The XML you provided was not well-formed or did
	//    not validate against our published schema." HTTP Status Code: 400 Bad
	//    Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MaxMessageLengthExceeded Description: Your request was too big.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MaxPostPreDataLengthExceededError Description: Your POST request
	//    fields preceding the upload file were too large. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MetadataTooLarge Description: Your metadata headers exceed the
	//    maximum allowed metadata size. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: MethodNotAllowed Description: The specified method is not allowed
	//    against this resource. HTTP Status Code: 405 Method Not Allowed SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: MissingAttachment Description: A SOAP attachment was expected,
	//    but none were found. HTTP Status Code: N/A SOAP Fault Code Prefix: Client
	//
	//    * Code: MissingContentLength Description: You must provide the Content-Length
	//    HTTP header. HTTP Status Code: 411 Length Required SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: MissingRequestBodyError Description: This happens when the user
	//    sends an empty XML document as a request. The error message is, "Request
	//    body is empty." HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: MissingSecurityElement Description: The SOAP 1.1 request is missing
	//    a security element. HTTP Status Code: 400 Bad Request SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: MissingSecurityHeader Description: Your request is missing a required
	//    header. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: NoLoggingStatusForKey Description: There is no such thing as a
	//    logging status subresource for a key. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: NoSuchBucket Description: The specified bucket does not exist.
	//    HTTP Status Code: 404 Not Found SOAP Fault Code Prefix: Client
	//
	//    * Code: NoSuchBucketPolicy Description: The specified bucket does not
	//    have a bucket policy. HTTP Status Code: 404 Not Found SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: NoSuchKey Description: The specified key does not exist. HTTP
	//    Status Code: 404 Not Found SOAP Fault Code Prefix: Client
	//
	//    * Code: NoSuchLifecycleConfiguration Description: The lifecycle configuration
	//    does not exist. HTTP Status Code: 404 Not Found SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: NoSuchUpload Description: The specified multipart upload does
	//    not exist. The upload ID might be invalid, or the multipart upload might
	//    have been aborted or completed. HTTP Status Code: 404 Not Found SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: NoSuchVersion Description: Indicates that the version ID specified
	//    in the request does not match an existing version. HTTP Status Code: 404
	//    Not Found SOAP Fault Code Prefix: Client
	//
	//    * Code: NotImplemented Description: A header you provided implies functionality
	//    that is not implemented. HTTP Status Code: 501 Not Implemented SOAP Fault
	//    Code Prefix: Server
	//
	//    * Code: NotSignedUp Description: Your account is not signed up for the
	//    Amazon S3 service. You must sign up before you can use Amazon S3. You
	//    can sign up at the following URL: https://aws.amazon.com/s3 HTTP Status
	//    Code: 403 Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: OperationAborted Description: A conflicting conditional action
	//    is currently in progress against this resource. Try again. HTTP Status
	//    Code: 409 Conflict SOAP Fault Code Prefix: Client
	//
	//    * Code: PermanentRedirect Description: The bucket you are attempting to
	//    access must be addressed using the specified endpoint. Send all future
	//    requests to this endpoint. HTTP Status Code: 301 Moved Permanently SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: PreconditionFailed Description: At least one of the preconditions
	//    you specified did not hold. HTTP Status Code: 412 Precondition Failed
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: Redirect Description: Temporary redirect. HTTP Status Code: 307
	//    Moved Temporarily SOAP Fault Code Prefix: Client
	//
	//    * Code: RestoreAlreadyInProgress Description: Object restore is already
	//    in progress. HTTP Status Code: 409 Conflict SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestIsNotMultiPartContent Description: Bucket POST must be
	//    of the enclosure-type multipart/form-data. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestTimeout Description: Your socket connection to the server
	//    was not read from or written to within the timeout period. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestTimeTooSkewed Description: The difference between the request
	//    time and the server's time is too large. HTTP Status Code: 403 Forbidden
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestTorrentOfBucketError Description: Requesting the torrent
	//    file of a bucket is not permitted. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: SignatureDoesNotMatch Description: The request signature we calculated
	//    does not match the signature you provided. Check your AWS secret access
	//    key and signing method. For more information, see REST Authentication
	//    (https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html)
	//    and SOAP Authentication (https://docs.aws.amazon.com/AmazonS3/latest/dev/SOAPAuthentication.html)
	//    for details. HTTP Status Code: 403 Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: ServiceUnavailable Description: Reduce your request rate. HTTP
	//    Status Code: 503 Service Unavailable SOAP Fault Code Prefix: Server
	//
	//    * Code: SlowDown Description: Reduce your request rate. HTTP Status Code:
	//    503 Slow Down SOAP Fault Code Prefix: Server
	//
	//    * Code: TemporaryRedirect Description: You are being redirected to the
	//    bucket while DNS updates. HTTP Status Code: 307 Moved Temporarily SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: TokenRefreshRequired Description: The provided token must be refreshed.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: TooManyBuckets Description: You have attempted to create more
	//    buckets than allowed. HTTP Status Code: 400 Bad Request SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: UnexpectedContent Description: This request does not support content.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: UnresolvableGrantByEmailAddress Description: The email address
	//    you provided does not match any account on record. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: UserKeyMustBeSpecified Description: The bucket POST must contain
	//    the specified field name. If it is specified, check the order of the fields.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	Code *string `type:"string"`

	// The error key.
	Key *string `min:"1" type:"string"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message *string `type:"string"`

	// The version ID of the error.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Error) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *Error) SetCode(v string) *Error {
	s.Code = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Error) SetKey(v string) *Error {
	s.Key = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Error) SetMessage(v string) *Error {
	s.Message = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *Error) SetVersionId(v string) *Error {
	s.VersionId = &v
	return s
}

// The error information.
type ErrorDocument struct {
	_ struct{} `type:"structure"`

	// The object key name to use when a 4XX class error occurs.
	//
	// Replacement must be made for object keys containing special characters (such
	// as carriage returns) when using XML requests. For more information, see XML
	// related object key constraints (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ErrorDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ErrorDocument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ErrorDocument"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ErrorDocument) SetKey(v string) *ErrorDocument {
	s.Key = &v
	return s
}

type ExtendObjectRetentionInput struct {
	_ struct{} `locationName:"ExtendObjectRetentionRequest" type:"structure"`

	// Additional time, in seconds, to add to the existing retention period for
	// the object. If this field and New-Retention-Time and/or New-Retention-Expiration-Date
	// are specified, a 400 error will be returned. If none of the Request Headers
	// are specified, a 400 error will be returned to the user. The retention period
	// of an object may be extended up to bucket maximum retention period from the
	// time of the request.
	AdditionalRetentionPeriod *int64 `location:"header" locationName:"Additional-Retention-Period" type:"integer"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Retention Period in seconds for the object. The Retention will be enforced
	// from the current time until current time + the value in this header. This
	// value has to be within the ranges defined for the bucket.
	ExtendRetentionFromCurrentTime *int64 `location:"header" locationName:"Extend-Retention-From-Current-Time" type:"integer"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	NewRetentionExpirationDate *time.Time `location:"header" locationName:"New-Retention-Expiration-Date" type:"timestamp" timestampFormat:"iso8601"`

	NewRetentionPeriod *int64 `location:"header" locationName:"New-Retention-Period" type:"integer"`
}

// String returns the string representation
func (s ExtendObjectRetentionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtendObjectRetentionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtendObjectRetentionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtendObjectRetentionInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalRetentionPeriod sets the AdditionalRetentionPeriod field's value.
func (s *ExtendObjectRetentionInput) SetAdditionalRetentionPeriod(v int64) *ExtendObjectRetentionInput {
	s.AdditionalRetentionPeriod = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *ExtendObjectRetentionInput) SetBucket(v string) *ExtendObjectRetentionInput {
	s.Bucket = &v
	return s
}

func (s *ExtendObjectRetentionInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExtendRetentionFromCurrentTime sets the ExtendRetentionFromCurrentTime field's value.
func (s *ExtendObjectRetentionInput) SetExtendRetentionFromCurrentTime(v int64) *ExtendObjectRetentionInput {
	s.ExtendRetentionFromCurrentTime = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ExtendObjectRetentionInput) SetKey(v string) *ExtendObjectRetentionInput {
	s.Key = &v
	return s
}

// SetNewRetentionExpirationDate sets the NewRetentionExpirationDate field's value.
func (s *ExtendObjectRetentionInput) SetNewRetentionExpirationDate(v time.Time) *ExtendObjectRetentionInput {
	s.NewRetentionExpirationDate = &v
	return s
}

// SetNewRetentionPeriod sets the NewRetentionPeriod field's value.
func (s *ExtendObjectRetentionInput) SetNewRetentionPeriod(v int64) *ExtendObjectRetentionInput {
	s.NewRetentionPeriod = &v
	return s
}

type ExtendObjectRetentionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExtendObjectRetentionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtendObjectRetentionOutput) GoString() string {
	return s.String()
}

type GetBucketAclInput struct {
	_ struct{} `locationName:"GetBucketAclRequest" type:"structure"`

	// Specifies the S3 bucket whose ACL is being requested.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s GetBucketAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketAclInput) SetBucket(v string) *GetBucketAclInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketAclInput) SetExpectedBucketOwner(v string) *GetBucketAclInput {
	s.ExpectedBucketOwner = &v
	return s
}

type GetBucketAclOutput struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	// Container for the bucket owner's display name and ID.
	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s GetBucketAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAclOutput) GoString() string {
	return s.String()
}

// SetGrants sets the Grants field's value.
func (s *GetBucketAclOutput) SetGrants(v []*Grant) *GetBucketAclOutput {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetBucketAclOutput) SetOwner(v *Owner) *GetBucketAclOutput {
	s.Owner = v
	return s
}

type GetBucketCorsInput struct {
	_ struct{} `locationName:"GetBucketCorsRequest" type:"structure"`

	// The bucket name for which to get the cors configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s GetBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketCorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketCorsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketCorsInput) SetBucket(v string) *GetBucketCorsInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketCorsInput) SetExpectedBucketOwner(v string) *GetBucketCorsInput {
	s.ExpectedBucketOwner = &v
	return s
}

type GetBucketCorsOutput struct {
	_ struct{} `type:"structure"`

	// A set of origins and methods (cross-origin access that you want to allow).
	// You can add up to 100 rules to the configuration.
	CORSRules []*CORSRule `locationName:"CORSRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketCorsOutput) GoString() string {
	return s.String()
}

// SetCORSRules sets the CORSRules field's value.
func (s *GetBucketCorsOutput) SetCORSRules(v []*CORSRule) *GetBucketCorsOutput {
	s.CORSRules = v
	return s
}

type GetBucketLifecycleConfigurationInput struct {
	_ struct{} `locationName:"GetBucketLifecycleConfigurationRequest" type:"structure"`

	// The name of the bucket for which to get the lifecycle information.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLifecycleConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLifecycleConfigurationInput) SetBucket(v string) *GetBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLifecycleConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketLifecycleConfigurationInput) SetExpectedBucketOwner(v string) *GetBucketLifecycleConfigurationInput {
	s.ExpectedBucketOwner = &v
	return s
}

type GetBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// COS allows only one Rule.
	Rules []*LifecycleRule `locationName:"Rule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *GetBucketLifecycleConfigurationOutput) SetRules(v []*LifecycleRule) *GetBucketLifecycleConfigurationOutput {
	s.Rules = v
	return s
}

type GetBucketLocationInput struct {
	_ struct{} `locationName:"GetBucketLocationRequest" type:"structure"`

	// The name of the bucket for which to get the location.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s GetBucketLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLocationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLocationInput) SetBucket(v string) *GetBucketLocationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLocationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketLocationInput) SetExpectedBucketOwner(v string) *GetBucketLocationInput {
	s.ExpectedBucketOwner = &v
	return s
}

type GetBucketLocationOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the Region where the bucket resides. For a list of all the Amazon
	// S3 supported location constraints by Region, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region).
	// Buckets in Region us-east-1 have a LocationConstraint of null.
	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation
func (s GetBucketLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLocationOutput) GoString() string {
	return s.String()
}

// SetLocationConstraint sets the LocationConstraint field's value.
func (s *GetBucketLocationOutput) SetLocationConstraint(v string) *GetBucketLocationOutput {
	s.LocationConstraint = &v
	return s
}

type GetBucketLoggingInput struct {
	_ struct{} `locationName:"GetBucketLoggingRequest" type:"structure"`

	// The bucket name for which to get the logging information.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s GetBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLoggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLoggingInput) SetBucket(v string) *GetBucketLoggingInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLoggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketLoggingInput) SetExpectedBucketOwner(v string) *GetBucketLoggingInput {
	s.ExpectedBucketOwner = &v
	return s
}

type GetBucketLoggingOutput struct {
	_ struct{} `type:"structure"`

	// Describes where logs are stored and the prefix that Amazon S3 assigns to
	// all log object keys for a bucket. For more information, see PUT Bucket logging
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html)
	// in the Amazon Simple Storage Service API Reference.
	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s GetBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLoggingOutput) GoString() string {
	return s.String()
}

// SetLoggingEnabled sets the LoggingEnabled field's value.
func (s *GetBucketLoggingOutput) SetLoggingEnabled(v *LoggingEnabled) *GetBucketLoggingOutput {
	s.LoggingEnabled = v
	return s
}

type GetBucketProtectionConfigurationInput struct {
	_ struct{} `locationName:"GetBucketProtectionConfigurationRequest" type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketProtectionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketProtectionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketProtectionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketProtectionConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketProtectionConfigurationInput) SetBucket(v string) *GetBucketProtectionConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketProtectionConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

type GetBucketProtectionConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"ProtectionConfiguration"`

	// Bucket protection configuration
	ProtectionConfiguration *ProtectionConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketProtectionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketProtectionConfigurationOutput) GoString() string {
	return s.String()
}

// SetProtectionConfiguration sets the ProtectionConfiguration field's value.
func (s *GetBucketProtectionConfigurationOutput) SetProtectionConfiguration(v *ProtectionConfiguration) *GetBucketProtectionConfigurationOutput {
	s.ProtectionConfiguration = v
	return s
}

type GetBucketVersioningInput struct {
	_ struct{} `locationName:"GetBucketVersioningRequest" type:"structure"`

	// The name of the bucket for which to get the versioning information.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s GetBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketVersioningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketVersioningInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketVersioningInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketVersioningInput) SetBucket(v string) *GetBucketVersioningInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketVersioningInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketVersioningInput) SetExpectedBucketOwner(v string) *GetBucketVersioningInput {
	s.ExpectedBucketOwner = &v
	return s
}

type GetBucketVersioningOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete *string `locationName:"MfaDelete" type:"string" enum:"MFADeleteStatus"`

	// The versioning state of the bucket.
	Status *string `type:"string" enum:"BucketVersioningStatus"`
}

// String returns the string representation
func (s GetBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketVersioningOutput) GoString() string {
	return s.String()
}

// SetMFADelete sets the MFADelete field's value.
func (s *GetBucketVersioningOutput) SetMFADelete(v string) *GetBucketVersioningOutput {
	s.MFADelete = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBucketVersioningOutput) SetStatus(v string) *GetBucketVersioningOutput {
	s.Status = &v
	return s
}

type GetBucketWebsiteInput struct {
	_ struct{} `locationName:"GetBucketWebsiteRequest" type:"structure"`

	// The bucket name for which to get the website configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s GetBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketWebsiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketWebsiteInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketWebsiteInput) SetBucket(v string) *GetBucketWebsiteInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetBucketWebsiteInput) SetExpectedBucketOwner(v string) *GetBucketWebsiteInput {
	s.ExpectedBucketOwner = &v
	return s
}

type GetBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`

	// The object key name of the website error document to use for 4XX class errors.
	ErrorDocument *ErrorDocument `type:"structure"`

	// The name of the index document for the website (for example index.html).
	IndexDocument *IndexDocument `type:"structure"`

	// Specifies the redirect behavior of all requests to a website endpoint of
	// an Amazon S3 bucket.
	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	// Rules that define when a redirect is applied and the redirect behavior.
	RoutingRules []*RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s GetBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketWebsiteOutput) GoString() string {
	return s.String()
}

// SetErrorDocument sets the ErrorDocument field's value.
func (s *GetBucketWebsiteOutput) SetErrorDocument(v *ErrorDocument) *GetBucketWebsiteOutput {
	s.ErrorDocument = v
	return s
}

// SetIndexDocument sets the IndexDocument field's value.
func (s *GetBucketWebsiteOutput) SetIndexDocument(v *IndexDocument) *GetBucketWebsiteOutput {
	s.IndexDocument = v
	return s
}

// SetRedirectAllRequestsTo sets the RedirectAllRequestsTo field's value.
func (s *GetBucketWebsiteOutput) SetRedirectAllRequestsTo(v *RedirectAllRequestsTo) *GetBucketWebsiteOutput {
	s.RedirectAllRequestsTo = v
	return s
}

// SetRoutingRules sets the RoutingRules field's value.
func (s *GetBucketWebsiteOutput) SetRoutingRules(v []*RoutingRule) *GetBucketWebsiteOutput {
	s.RoutingRules = v
	return s
}

type GetObjectAclInput struct {
	_ struct{} `locationName:"GetObjectAclRequest" type:"structure"`

	// The bucket name that contains the object for which to get the ACL information.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The key of the object for which to get the ACL information.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectAclInput) SetBucket(v string) *GetObjectAclInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetObjectAclInput) SetExpectedBucketOwner(v string) *GetObjectAclInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectAclInput) SetKey(v string) *GetObjectAclInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectAclInput) SetRequestPayer(v string) *GetObjectAclInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectAclInput) SetVersionId(v string) *GetObjectAclInput {
	s.VersionId = &v
	return s
}

type GetObjectAclOutput struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	// Container for the bucket owner's display name and ID.
	Owner *Owner `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s GetObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAclOutput) GoString() string {
	return s.String()
}

// SetGrants sets the Grants field's value.
func (s *GetObjectAclOutput) SetGrants(v []*Grant) *GetObjectAclOutput {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetObjectAclOutput) SetOwner(v *Owner) *GetObjectAclOutput {
	s.Owner = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectAclOutput) SetRequestCharged(v string) *GetObjectAclOutput {
	s.RequestCharged = &v
	return s
}

type GetObjectInput struct {
	_ struct{} `locationName:"GetObjectRequest" type:"structure"`

	// The bucket name containing the object.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Return the object only if its entity tag (ETag) is the same as the one specified,
	// otherwise return a 412 (precondition failed).
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time,
	// otherwise return a 304 (not modified).
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified, otherwise return a 304 (not modified).
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time,
	// otherwise return a 412 (precondition failed).
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp"`

	// Key of the object to get.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of the object being read. This is a positive integer between
	// 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified.
	// Useful for downloading just a part of an object.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer"`

	// Downloads the specified range bytes of an object. For more information about
	// the HTTP Range header, see https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35
	// (https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35).
	//
	// Amazon S3 doesn't support retrieving multiple ranges of data per GET request.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Sets the Cache-Control header of the response.
	ResponseCacheControl *string `location:"querystring" locationName:"response-cache-control" type:"string"`

	// Sets the Content-Disposition header of the response
	ResponseContentDisposition *string `location:"querystring" locationName:"response-content-disposition" type:"string"`

	// Sets the Content-Encoding header of the response.
	ResponseContentEncoding *string `location:"querystring" locationName:"response-content-encoding" type:"string"`

	// Sets the Content-Language header of the response.
	ResponseContentLanguage *string `location:"querystring" locationName:"response-content-language" type:"string"`

	// Sets the Content-Type header of the response.
	ResponseContentType *string `location:"querystring" locationName:"response-content-type" type:"string"`

	// Sets the Expires header of the response.
	ResponseExpires *time.Time `location:"querystring" locationName:"response-expires" type:"timestamp"`

	// Specifies the algorithm to use to when decrypting the object (for example,
	// AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 used to encrypt
	// the data. This value is used to decrypt the object when recovering it and
	// must match the one used when storing the data. The key must be appropriate
	// for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectInput) SetBucket(v string) *GetObjectInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetObjectInput) SetExpectedBucketOwner(v string) *GetObjectInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *GetObjectInput) SetIfMatch(v string) *GetObjectInput {
	s.IfMatch = &v
	return s
}

// SetIfModifiedSince sets the IfModifiedSince field's value.
func (s *GetObjectInput) SetIfModifiedSince(v time.Time) *GetObjectInput {
	s.IfModifiedSince = &v
	return s
}

// SetIfNoneMatch sets the IfNoneMatch field's value.
func (s *GetObjectInput) SetIfNoneMatch(v string) *GetObjectInput {
	s.IfNoneMatch = &v
	return s
}

// SetIfUnmodifiedSince sets the IfUnmodifiedSince field's value.
func (s *GetObjectInput) SetIfUnmodifiedSince(v time.Time) *GetObjectInput {
	s.IfUnmodifiedSince = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectInput) SetKey(v string) *GetObjectInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *GetObjectInput) SetPartNumber(v int64) *GetObjectInput {
	s.PartNumber = &v
	return s
}

// SetRange sets the Range field's value.
func (s *GetObjectInput) SetRange(v string) *GetObjectInput {
	s.Range = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectInput) SetRequestPayer(v string) *GetObjectInput {
	s.RequestPayer = &v
	return s
}

// SetResponseCacheControl sets the ResponseCacheControl field's value.
func (s *GetObjectInput) SetResponseCacheControl(v string) *GetObjectInput {
	s.ResponseCacheControl = &v
	return s
}

// SetResponseContentDisposition sets the ResponseContentDisposition field's value.
func (s *GetObjectInput) SetResponseContentDisposition(v string) *GetObjectInput {
	s.ResponseContentDisposition = &v
	return s
}

// SetResponseContentEncoding sets the ResponseContentEncoding field's value.
func (s *GetObjectInput) SetResponseContentEncoding(v string) *GetObjectInput {
	s.ResponseContentEncoding = &v
	return s
}

// SetResponseContentLanguage sets the ResponseContentLanguage field's value.
func (s *GetObjectInput) SetResponseContentLanguage(v string) *GetObjectInput {
	s.ResponseContentLanguage = &v
	return s
}

// SetResponseContentType sets the ResponseContentType field's value.
func (s *GetObjectInput) SetResponseContentType(v string) *GetObjectInput {
	s.ResponseContentType = &v
	return s
}

// SetResponseExpires sets the ResponseExpires field's value.
func (s *GetObjectInput) SetResponseExpires(v time.Time) *GetObjectInput {
	s.ResponseExpires = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *GetObjectInput) SetSSECustomerAlgorithm(v string) *GetObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *GetObjectInput) SetSSECustomerKey(v string) *GetObjectInput {
	s.SSECustomerKey = &v
	return s
}

func (s *GetObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *GetObjectInput) SetSSECustomerKeyMD5(v string) *GetObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectInput) SetVersionId(v string) *GetObjectInput {
	s.VersionId = &v
	return s
}

type GetObjectOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// Indicates that a range of bytes was specified.
	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// Object data.
	Body io.ReadCloser `type:"blob"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// The portion of the object returned in the response.
	ContentRange *string `location:"header" locationName:"Content-Range" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies whether the object retrieved was (true) or was not (false) a Delete
	// Marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An ETag is an opaque identifier assigned by a web server to a specific version
	// of a resource found at a URL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured (see PUT Bucket lifecycle), the response
	// includes this header. It includes the expiry-date and rule-id key-value pairs
	// providing object expiration information. The value of the rule-id is URL
	// encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *string `location:"header" locationName:"Expires" type:"string"`

	IBMRestoredCopyStorageClass *string `location:"header" locationName:"x-ibm-restored-copy-storage-class" type:"string" enum:"StorageClass"`

	// This header is only included if an object has transition metadata. This header
	// will indicate the transition storage class and time of transition. If this
	// header and the x-amz-restore header are both included, this header will indicate
	// the time at which the object was originally archived.
	IBMTransition *string `location:"header" locationName:"x-ibm-transition" type:"string"`

	// Creation date of the object.
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp"`

	// A map of metadata to store with the object in S3.
	//
	// By default unmarshaled keys are written as a map keys in following canonicalized format:
	// the first letter and any letter following a hyphen will be capitalized, and the rest as lowercase.
	// Set `aws.Config.LowerCaseHeaderMaps` to `true` to write unmarshaled keys to the map as lowercase.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// This is set to the number of metadata entries not returned in x-amz-meta
	// headers. This can happen if you create metadata using an API like SOAP that
	// supports more flexible metadata than the REST API. For example, using SOAP,
	// you can create metadata whose values are not legal HTTP headers.
	MissingMeta *int64 `location:"header" locationName:"x-amz-missing-meta" type:"integer"`

	// The count of parts this object has.
	PartsCount *int64 `location:"header" locationName:"x-amz-mp-parts-count" type:"integer"`

	// Amazon S3 can return this if your request involves a bucket that is either
	// a source or destination in a replication rule.
	ReplicationStatus *string `location:"header" locationName:"x-amz-replication-status" type:"string" enum:"ReplicationStatus"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Provides information about object restoration action and expiration time
	// of the restored object copy.
	Restore *string `location:"header" locationName:"x-amz-restore" type:"string"`

	// Date on which it will be legal to delete or modify the object. You can only
	// specify this or the Retention-Period header. If both are specified a 400
	// error will be returned. If neither is specified the bucket's DefaultRetention
	// period will be used.
	RetentionExpirationDate *time.Time `location:"header" locationName:"Retention-Expiration-Date" type:"timestamp"`

	RetentionLegalHoldCount *int64 `location:"header" locationName:"Retention-Legal-Hold-Count" type:"integer"`

	// Retention period to store on the object in seconds. If this field and Retention-Expiration-Date
	// are specified a 400 error is returned. If neither is specified the bucket's
	// DefaultRetention period will be used. 0 is a legal value assuming the bucket's
	// minimum retention period is also 0.
	RetentionPeriod *int64 `location:"header" locationName:"Retention-Period" type:"integer"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round-trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (AWS KMS)
	// symmetric customer managed customer master key (CMK) that was used for the
	// object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Provides storage class information of the object. Amazon S3 returns this
	// header for all objects except for S3 Standard storage class objects.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// The number of tags, if any, on the object.
	TagCount *int64 `location:"header" locationName:"x-amz-tagging-count" type:"integer"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s GetObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectOutput) GoString() string {
	return s.String()
}

// SetAcceptRanges sets the AcceptRanges field's value.
func (s *GetObjectOutput) SetAcceptRanges(v string) *GetObjectOutput {
	s.AcceptRanges = &v
	return s
}

// SetBody sets the Body field's value.
func (s *GetObjectOutput) SetBody(v io.ReadCloser) *GetObjectOutput {
	s.Body = v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *GetObjectOutput) SetCacheControl(v string) *GetObjectOutput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *GetObjectOutput) SetContentDisposition(v string) *GetObjectOutput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *GetObjectOutput) SetContentEncoding(v string) *GetObjectOutput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *GetObjectOutput) SetContentLanguage(v string) *GetObjectOutput {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *GetObjectOutput) SetContentLength(v int64) *GetObjectOutput {
	s.ContentLength = &v
	return s
}

// SetContentRange sets the ContentRange field's value.
func (s *GetObjectOutput) SetContentRange(v string) *GetObjectOutput {
	s.ContentRange = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetObjectOutput) SetContentType(v string) *GetObjectOutput {
	s.ContentType = &v
	return s
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *GetObjectOutput) SetDeleteMarker(v bool) *GetObjectOutput {
	s.DeleteMarker = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetObjectOutput) SetETag(v string) *GetObjectOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *GetObjectOutput) SetExpiration(v string) *GetObjectOutput {
	s.Expiration = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *GetObjectOutput) SetExpires(v string) *GetObjectOutput {
	s.Expires = &v
	return s
}

// SetIBMRestoredCopyStorageClass sets the IBMRestoredCopyStorageClass field's value.
func (s *GetObjectOutput) SetIBMRestoredCopyStorageClass(v string) *GetObjectOutput {
	s.IBMRestoredCopyStorageClass = &v
	return s
}

// SetIBMTransition sets the IBMTransition field's value.
func (s *GetObjectOutput) SetIBMTransition(v string) *GetObjectOutput {
	s.IBMTransition = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetObjectOutput) SetLastModified(v time.Time) *GetObjectOutput {
	s.LastModified = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetObjectOutput) SetMetadata(v map[string]*string) *GetObjectOutput {
	s.Metadata = v
	return s
}

// SetMissingMeta sets the MissingMeta field's value.
func (s *GetObjectOutput) SetMissingMeta(v int64) *GetObjectOutput {
	s.MissingMeta = &v
	return s
}

// SetPartsCount sets the PartsCount field's value.
func (s *GetObjectOutput) SetPartsCount(v int64) *GetObjectOutput {
	s.PartsCount = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *GetObjectOutput) SetReplicationStatus(v string) *GetObjectOutput {
	s.ReplicationStatus = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectOutput) SetRequestCharged(v string) *GetObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetRestore sets the Restore field's value.
func (s *GetObjectOutput) SetRestore(v string) *GetObjectOutput {
	s.Restore = &v
	return s
}

// SetRetentionExpirationDate sets the RetentionExpirationDate field's value.
func (s *GetObjectOutput) SetRetentionExpirationDate(v time.Time) *GetObjectOutput {
	s.RetentionExpirationDate = &v
	return s
}

// SetRetentionLegalHoldCount sets the RetentionLegalHoldCount field's value.
func (s *GetObjectOutput) SetRetentionLegalHoldCount(v int64) *GetObjectOutput {
	s.RetentionLegalHoldCount = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *GetObjectOutput) SetRetentionPeriod(v int64) *GetObjectOutput {
	s.RetentionPeriod = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *GetObjectOutput) SetSSECustomerAlgorithm(v string) *GetObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *GetObjectOutput) SetSSECustomerKeyMD5(v string) *GetObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *GetObjectOutput) SetSSEKMSKeyId(v string) *GetObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *GetObjectOutput) SetServerSideEncryption(v string) *GetObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *GetObjectOutput) SetStorageClass(v string) *GetObjectOutput {
	s.StorageClass = &v
	return s
}

// SetTagCount sets the TagCount field's value.
func (s *GetObjectOutput) SetTagCount(v int64) *GetObjectOutput {
	s.TagCount = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectOutput) SetVersionId(v string) *GetObjectOutput {
	s.VersionId = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *GetObjectOutput) SetWebsiteRedirectLocation(v string) *GetObjectOutput {
	s.WebsiteRedirectLocation = &v
	return s
}

type GetObjectTaggingInput struct {
	_ struct{} `locationName:"GetObjectTaggingRequest" type:"structure"`

	// The bucket name containing the object for which to get the tagging information.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Object key for which to get the tagging information.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// The versionId of the object for which to get the tagging information.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectTaggingInput) SetBucket(v string) *GetObjectTaggingInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetObjectTaggingInput) SetExpectedBucketOwner(v string) *GetObjectTaggingInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectTaggingInput) SetKey(v string) *GetObjectTaggingInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectTaggingInput) SetRequestPayer(v string) *GetObjectTaggingInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectTaggingInput) SetVersionId(v string) *GetObjectTaggingInput {
	s.VersionId = &v
	return s
}

type GetObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	// Contains the tag set.
	//
	// TagSet is a required field
	TagSet []*Tag `locationNameList:"Tag" type:"list" required:"true"`

	// The versionId of the object for which you got the tagging information.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s GetObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTaggingOutput) GoString() string {
	return s.String()
}

// SetTagSet sets the TagSet field's value.
func (s *GetObjectTaggingOutput) SetTagSet(v []*Tag) *GetObjectTaggingOutput {
	s.TagSet = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectTaggingOutput) SetVersionId(v string) *GetObjectTaggingOutput {
	s.VersionId = &v
	return s
}

type GetPublicAccessBlockInput struct {
	_ struct{} `locationName:"GetPublicAccessBlockRequest" type:"structure"`

	// The name of the Amazon S3 bucket whose PublicAccessBlock configuration you
	// want to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s GetPublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicAccessBlockInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetPublicAccessBlockInput) SetBucket(v string) *GetPublicAccessBlockInput {
	s.Bucket = &v
	return s
}

func (s *GetPublicAccessBlockInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *GetPublicAccessBlockInput) SetExpectedBucketOwner(v string) *GetPublicAccessBlockInput {
	s.ExpectedBucketOwner = &v
	return s
}

type GetPublicAccessBlockOutput struct {
	_ struct{} `type:"structure" payload:"PublicAccessBlockConfiguration"`

	// The PublicAccessBlock configuration currently in effect for this Amazon S3
	// bucket.
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetPublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicAccessBlockOutput) GoString() string {
	return s.String()
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *GetPublicAccessBlockOutput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *GetPublicAccessBlockOutput {
	s.PublicAccessBlockConfiguration = v
	return s
}

// Container for S3 Glacier job parameters.
type GlacierJobParameters struct {
	_ struct{} `type:"structure"`

	// Retrieval tier at which the restore will be processed.
	//
	// Tier is a required field
	Tier *string `type:"string" required:"true" enum:"Tier"`
}

// String returns the string representation
func (s GlacierJobParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlacierJobParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlacierJobParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlacierJobParameters"}
	if s.Tier == nil {
		invalidParams.Add(request.NewErrParamRequired("Tier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTier sets the Tier field's value.
func (s *GlacierJobParameters) SetTier(v string) *GlacierJobParameters {
	s.Tier = &v
	return s
}

// Container for grant information.
type Grant struct {
	_ struct{} `type:"structure"`

	// The person being granted permissions.
	Grantee *Grantee `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Specifies the permission given to the grantee.
	Permission *string `type:"string" enum:"Permission"`
}

// String returns the string representation
func (s Grant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantee sets the Grantee field's value.
func (s *Grant) SetGrantee(v *Grantee) *Grant {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *Grant) SetPermission(v string) *Grant {
	s.Permission = &v
	return s
}

// Container for the person being granted permissions.
type Grantee struct {
	_ struct{} `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Screen name of the grantee.
	DisplayName *string `type:"string"`

	// Email address of the grantee.
	//
	// Using email addresses to specify a grantee is only supported in the following
	// AWS Regions:
	//
	//    * US East (N. Virginia)
	//
	//    * US West (N. California)
	//
	//    * US West (Oregon)
	//
	//    * Asia Pacific (Singapore)
	//
	//    * Asia Pacific (Sydney)
	//
	//    * Asia Pacific (Tokyo)
	//
	//    * Europe (Ireland)
	//
	//    * South America (São Paulo)
	//
	// For a list of all the Amazon S3 supported Regions and endpoints, see Regions
	// and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
	// in the AWS General Reference.
	EmailAddress *string `type:"string"`

	// The canonical user ID of the grantee.
	ID *string `type:"string"`

	// Type of grantee
	//
	// Type is a required field
	Type *string `locationName:"xsi:type" type:"string" xmlAttribute:"true" required:"true" enum:"Type"`

	// URI of the grantee group.
	URI *string `type:"string"`
}

// String returns the string representation
func (s Grantee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grantee) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grantee) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Grantee"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *Grantee) SetDisplayName(v string) *Grantee {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *Grantee) SetEmailAddress(v string) *Grantee {
	s.EmailAddress = &v
	return s
}

// SetID sets the ID field's value.
func (s *Grantee) SetID(v string) *Grantee {
	s.ID = &v
	return s
}

// SetType sets the Type field's value.
func (s *Grantee) SetType(v string) *Grantee {
	s.Type = &v
	return s
}

// SetURI sets the URI field's value.
func (s *Grantee) SetURI(v string) *Grantee {
	s.URI = &v
	return s
}

type HeadBucketInput struct {
	_ struct{} `locationName:"HeadBucketRequest" type:"structure"`

	// The bucket name.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s HeadBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeadBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HeadBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *HeadBucketInput) SetBucket(v string) *HeadBucketInput {
	s.Bucket = &v
	return s
}

func (s *HeadBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *HeadBucketInput) SetExpectedBucketOwner(v string) *HeadBucketInput {
	s.ExpectedBucketOwner = &v
	return s
}

type HeadBucketOutput struct {
	_ struct{} `type:"structure"`

	// The root key used by Key Protect to encrypt this bucket. This value must
	// be the full CRN of the root key.
	IBMSSEKPCrkId *string `location:"header" locationName:"ibm-sse-kp-customer-root-key-crn" type:"string"`

	// Specifies whether the Bucket has Key Protect enabled.
	IBMSSEKPEnabled *bool `location:"header" locationName:"ibm-sse-kp-enabled" type:"boolean"`
}

// String returns the string representation
func (s HeadBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadBucketOutput) GoString() string {
	return s.String()
}

// SetIBMSSEKPCrkId sets the IBMSSEKPCrkId field's value.
func (s *HeadBucketOutput) SetIBMSSEKPCrkId(v string) *HeadBucketOutput {
	s.IBMSSEKPCrkId = &v
	return s
}

// SetIBMSSEKPEnabled sets the IBMSSEKPEnabled field's value.
func (s *HeadBucketOutput) SetIBMSSEKPEnabled(v bool) *HeadBucketOutput {
	s.IBMSSEKPEnabled = &v
	return s
}

type HeadObjectInput struct {
	_ struct{} `locationName:"HeadObjectRequest" type:"structure"`

	// The name of the bucket containing the object.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Return the object only if its entity tag (ETag) is the same as the one specified,
	// otherwise return a 412 (precondition failed).
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time,
	// otherwise return a 304 (not modified).
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified, otherwise return a 304 (not modified).
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time,
	// otherwise return a 412 (precondition failed).
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp"`

	// The object key.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of the object being read. This is a positive integer between
	// 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified.
	// Useful querying about the size of the part and the number of parts in this
	// object.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer"`

	// Downloads the specified range bytes of an object. For more information about
	// the HTTP Range header, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35
	// (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35).
	//
	// Amazon S3 doesn't support retrieving multiple ranges of data per GET request.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (for example,
	// AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// S3 does not store the encryption key. The key must be appropriate for use
	// with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s HeadObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeadObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HeadObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *HeadObjectInput) SetBucket(v string) *HeadObjectInput {
	s.Bucket = &v
	return s
}

func (s *HeadObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *HeadObjectInput) SetExpectedBucketOwner(v string) *HeadObjectInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *HeadObjectInput) SetIfMatch(v string) *HeadObjectInput {
	s.IfMatch = &v
	return s
}

// SetIfModifiedSince sets the IfModifiedSince field's value.
func (s *HeadObjectInput) SetIfModifiedSince(v time.Time) *HeadObjectInput {
	s.IfModifiedSince = &v
	return s
}

// SetIfNoneMatch sets the IfNoneMatch field's value.
func (s *HeadObjectInput) SetIfNoneMatch(v string) *HeadObjectInput {
	s.IfNoneMatch = &v
	return s
}

// SetIfUnmodifiedSince sets the IfUnmodifiedSince field's value.
func (s *HeadObjectInput) SetIfUnmodifiedSince(v time.Time) *HeadObjectInput {
	s.IfUnmodifiedSince = &v
	return s
}

// SetKey sets the Key field's value.
func (s *HeadObjectInput) SetKey(v string) *HeadObjectInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *HeadObjectInput) SetPartNumber(v int64) *HeadObjectInput {
	s.PartNumber = &v
	return s
}

// SetRange sets the Range field's value.
func (s *HeadObjectInput) SetRange(v string) *HeadObjectInput {
	s.Range = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *HeadObjectInput) SetRequestPayer(v string) *HeadObjectInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *HeadObjectInput) SetSSECustomerAlgorithm(v string) *HeadObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *HeadObjectInput) SetSSECustomerKey(v string) *HeadObjectInput {
	s.SSECustomerKey = &v
	return s
}

func (s *HeadObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *HeadObjectInput) SetSSECustomerKeyMD5(v string) *HeadObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *HeadObjectInput) SetVersionId(v string) *HeadObjectInput {
	s.VersionId = &v
	return s
}

type HeadObjectOutput struct {
	_ struct{} `type:"structure"`

	// Indicates that a range of bytes was specified.
	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies whether the object retrieved was (true) or was not (false) a Delete
	// Marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An ETag is an opaque identifier assigned by a web server to a specific version
	// of a resource found at a URL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured (see PUT Bucket lifecycle), the response
	// includes this header. It includes the expiry-date and rule-id key-value pairs
	// providing object expiration information. The value of the rule-id is URL
	// encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *string `location:"header" locationName:"Expires" type:"string"`

	IBMRestoredCopyStorageClass *string `location:"header" locationName:"x-ibm-restored-copy-storage-class" type:"string" enum:"StorageClass"`

	// This header is only included if an object has transition metadata. This header
	// will indicate the transition storage class and time of transition. If this
	// header and the x-amz-restore header are both included, this header will indicate
	// the time at which the object was originally archived.
	IBMTransition *string `location:"header" locationName:"x-ibm-transition" type:"string"`

	// Creation date of the object.
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp"`

	// A map of metadata to store with the object in S3.
	//
	// By default unmarshaled keys are written as a map keys in following canonicalized format:
	// the first letter and any letter following a hyphen will be capitalized, and the rest as lowercase.
	// Set `aws.Config.LowerCaseHeaderMaps` to `true` to write unmarshaled keys to the map as lowercase.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// This is set to the number of metadata entries not returned in x-amz-meta
	// headers. This can happen if you create metadata using an API like SOAP that
	// supports more flexible metadata than the REST API. For example, using SOAP,
	// you can create metadata whose values are not legal HTTP headers.
	MissingMeta *int64 `location:"header" locationName:"x-amz-missing-meta" type:"integer"`

	// The count of parts this object has.
	PartsCount *int64 `location:"header" locationName:"x-amz-mp-parts-count" type:"integer"`

	// Amazon S3 can return this header if your request involves a bucket that is
	// either a source or a destination in a replication rule.
	//
	// In replication, you have a source bucket on which you configure replication
	// and destination bucket or buckets where Amazon S3 stores object replicas.
	// When you request an object (GetObject) or object metadata (HeadObject) from
	// these buckets, Amazon S3 will return the x-amz-replication-status header
	// in the response as follows:
	//
	//    * If requesting an object from the source bucket — Amazon S3 will return
	//    the x-amz-replication-status header if the object in your request is eligible
	//    for replication. For example, suppose that in your replication configuration,
	//    you specify object prefix TaxDocs requesting Amazon S3 to replicate objects
	//    with key prefix TaxDocs. Any objects you upload with this key name prefix,
	//    for example TaxDocs/document1.pdf, are eligible for replication. For any
	//    object request with this key name prefix, Amazon S3 will return the x-amz-replication-status
	//    header with value PENDING, COMPLETED or FAILED indicating object replication
	//    status.
	//
	//    * If requesting an object from a destination bucket — Amazon S3 will
	//    return the x-amz-replication-status header with value REPLICA if the object
	//    in your request is a replica that Amazon S3 created and there is no replica
	//    modification replication in progress.
	//
	//    * When replicating objects to multiple destination buckets the x-amz-replication-status
	//    header acts differently. The header of the source object will only return
	//    a value of COMPLETED when replication is successful to all destinations.
	//    The header will remain at value PENDING until replication has completed
	//    for all destinations. If one or more destinations fails replication the
	//    header will return FAILED.
	//
	// For more information, see Replication (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html).
	ReplicationStatus *string `location:"header" locationName:"x-amz-replication-status" type:"string" enum:"ReplicationStatus"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If the object is an archived object (an object whose storage class is GLACIER),
	// the response includes this header if either the archive restoration is in
	// progress (see RestoreObject (https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html)
	// or an archive copy is already restored.
	//
	// If an archive copy is already restored, the header value indicates when Amazon
	// S3 is scheduled to delete the object copy. For example:
	//
	// x-amz-restore: ongoing-request="false", expiry-date="Fri, 21 Dec 2012 00:00:00
	// GMT"
	//
	// If the object restoration is in progress, the header returns the value ongoing-request="true".
	//
	// For more information about archiving objects, see Transitioning Objects:
	// General Considerations (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-transition-general-considerations).
	Restore *string `location:"header" locationName:"x-amz-restore" type:"string"`

	// Date on which it will be legal to delete or modify the object. You can only
	// specify this or the Retention-Period header. If both are specified a 400
	// error will be returned. If neither is specified the bucket's DefaultRetention
	// period will be used.
	RetentionExpirationDate *time.Time `location:"header" locationName:"Retention-Expiration-Date" type:"timestamp"`

	RetentionLegalHoldCount *int64 `location:"header" locationName:"Retention-Legal-Hold-Count" type:"integer"`

	// Retention period to store on the object in seconds. If this field and Retention-Expiration-Date
	// are specified a 400 error is returned. If neither is specified the bucket's
	// DefaultRetention period will be used. 0 is a legal value assuming the bucket's
	// minimum retention period is also 0.
	RetentionPeriod *int64 `location:"header" locationName:"Retention-Period" type:"integer"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round-trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (AWS KMS)
	// symmetric customer managed customer master key (CMK) that was used for the
	// object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// If the object is stored using server-side encryption either with an AWS KMS
	// customer master key (CMK) or an Amazon S3-managed encryption key, the response
	// includes this header with the value of the server-side encryption algorithm
	// used when storing this object in Amazon S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Provides storage class information of the object. Amazon S3 returns this
	// header for all objects except for S3 Standard storage class objects.
	//
	// For more information, see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html).
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s HeadObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadObjectOutput) GoString() string {
	return s.String()
}

// SetAcceptRanges sets the AcceptRanges field's value.
func (s *HeadObjectOutput) SetAcceptRanges(v string) *HeadObjectOutput {
	s.AcceptRanges = &v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *HeadObjectOutput) SetCacheControl(v string) *HeadObjectOutput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *HeadObjectOutput) SetContentDisposition(v string) *HeadObjectOutput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *HeadObjectOutput) SetContentEncoding(v string) *HeadObjectOutput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *HeadObjectOutput) SetContentLanguage(v string) *HeadObjectOutput {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *HeadObjectOutput) SetContentLength(v int64) *HeadObjectOutput {
	s.ContentLength = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *HeadObjectOutput) SetContentType(v string) *HeadObjectOutput {
	s.ContentType = &v
	return s
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *HeadObjectOutput) SetDeleteMarker(v bool) *HeadObjectOutput {
	s.DeleteMarker = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *HeadObjectOutput) SetETag(v string) *HeadObjectOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *HeadObjectOutput) SetExpiration(v string) *HeadObjectOutput {
	s.Expiration = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *HeadObjectOutput) SetExpires(v string) *HeadObjectOutput {
	s.Expires = &v
	return s
}

// SetIBMRestoredCopyStorageClass sets the IBMRestoredCopyStorageClass field's value.
func (s *HeadObjectOutput) SetIBMRestoredCopyStorageClass(v string) *HeadObjectOutput {
	s.IBMRestoredCopyStorageClass = &v
	return s
}

// SetIBMTransition sets the IBMTransition field's value.
func (s *HeadObjectOutput) SetIBMTransition(v string) *HeadObjectOutput {
	s.IBMTransition = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *HeadObjectOutput) SetLastModified(v time.Time) *HeadObjectOutput {
	s.LastModified = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *HeadObjectOutput) SetMetadata(v map[string]*string) *HeadObjectOutput {
	s.Metadata = v
	return s
}

// SetMissingMeta sets the MissingMeta field's value.
func (s *HeadObjectOutput) SetMissingMeta(v int64) *HeadObjectOutput {
	s.MissingMeta = &v
	return s
}

// SetPartsCount sets the PartsCount field's value.
func (s *HeadObjectOutput) SetPartsCount(v int64) *HeadObjectOutput {
	s.PartsCount = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *HeadObjectOutput) SetReplicationStatus(v string) *HeadObjectOutput {
	s.ReplicationStatus = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *HeadObjectOutput) SetRequestCharged(v string) *HeadObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetRestore sets the Restore field's value.
func (s *HeadObjectOutput) SetRestore(v string) *HeadObjectOutput {
	s.Restore = &v
	return s
}

// SetRetentionExpirationDate sets the RetentionExpirationDate field's value.
func (s *HeadObjectOutput) SetRetentionExpirationDate(v time.Time) *HeadObjectOutput {
	s.RetentionExpirationDate = &v
	return s
}

// SetRetentionLegalHoldCount sets the RetentionLegalHoldCount field's value.
func (s *HeadObjectOutput) SetRetentionLegalHoldCount(v int64) *HeadObjectOutput {
	s.RetentionLegalHoldCount = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *HeadObjectOutput) SetRetentionPeriod(v int64) *HeadObjectOutput {
	s.RetentionPeriod = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *HeadObjectOutput) SetSSECustomerAlgorithm(v string) *HeadObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *HeadObjectOutput) SetSSECustomerKeyMD5(v string) *HeadObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *HeadObjectOutput) SetSSEKMSKeyId(v string) *HeadObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *HeadObjectOutput) SetServerSideEncryption(v string) *HeadObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *HeadObjectOutput) SetStorageClass(v string) *HeadObjectOutput {
	s.StorageClass = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *HeadObjectOutput) SetVersionId(v string) *HeadObjectOutput {
	s.VersionId = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *HeadObjectOutput) SetWebsiteRedirectLocation(v string) *HeadObjectOutput {
	s.WebsiteRedirectLocation = &v
	return s
}

// Container for the Suffix element.
type IndexDocument struct {
	_ struct{} `type:"structure"`

	// A suffix that is appended to a request that is for a directory on the website
	// endpoint (for example,if the suffix is index.html and you make a request
	// to samplebucket/images/ the data that is returned will be for the object
	// with the key name images/index.html) The suffix must not be empty and must
	// not include a slash character.
	//
	// Replacement must be made for object keys containing special characters (such
	// as carriage returns) when using XML requests. For more information, see XML
	// related object key constraints (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
	//
	// Suffix is a required field
	Suffix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IndexDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexDocument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IndexDocument"}
	if s.Suffix == nil {
		invalidParams.Add(request.NewErrParamRequired("Suffix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuffix sets the Suffix field's value.
func (s *IndexDocument) SetSuffix(v string) *IndexDocument {
	s.Suffix = &v
	return s
}

// Container element that identifies who initiated the multipart upload.
type Initiator struct {
	_ struct{} `type:"structure"`

	// Name of the Principal.
	DisplayName *string `type:"string"`

	// If the principal is an AWS account, it provides the Canonical User ID. If
	// the principal is an IAM User, it provides a user ARN value.
	ID *string `type:"string"`
}

// String returns the string representation
func (s Initiator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Initiator) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *Initiator) SetDisplayName(v string) *Initiator {
	s.DisplayName = &v
	return s
}

// SetID sets the ID field's value.
func (s *Initiator) SetID(v string) *Initiator {
	s.ID = &v
	return s
}

type LegalHold struct {
	_ struct{} `type:"structure"`

	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	ID *string `type:"string"`
}

// String returns the string representation
func (s LegalHold) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LegalHold) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *LegalHold) SetDate(v time.Time) *LegalHold {
	s.Date = &v
	return s
}

// SetID sets the ID field's value.
func (s *LegalHold) SetID(v string) *LegalHold {
	s.ID = &v
	return s
}

// Container for lifecycle rules. You can add as many as 1000 rules.
type LifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// Rules is a required field
	Rules []*LifecycleRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s LifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleConfiguration"}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRules sets the Rules field's value.
func (s *LifecycleConfiguration) SetRules(v []*LifecycleRule) *LifecycleConfiguration {
	s.Rules = v
	return s
}

// Container for the expiration for the lifecycle of the object.
type LifecycleExpiration struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`
}

// String returns the string representation
func (s LifecycleExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleExpiration) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *LifecycleExpiration) SetDate(v time.Time) *LifecycleExpiration {
	s.Date = &v
	return s
}

// SetDays sets the Days field's value.
func (s *LifecycleExpiration) SetDays(v int64) *LifecycleExpiration {
	s.Days = &v
	return s
}

// A lifecycle rule for individual objects in an Amazon S3 bucket.
type LifecycleRule struct {
	_ struct{} `type:"structure"`

	// Specifies the expiration for the lifecycle of the object in the form of date,
	// days and, whether the object has a delete marker.
	Expiration *LifecycleExpiration `type:"structure"`

	// The Filter is used to identify objects that a Lifecycle Rule applies to.
	// A Filter must have exactly one of Prefix, Tag, or And specified. Filter is
	// required if the LifecycleRule does not containt a Prefix element.
	//
	// Filter is a required field
	Filter *LifecycleRuleFilter `type:"structure" required:"true"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ExpirationStatus"`

	// Specifies when an Amazon S3 object transitions to a specified storage class.
	Transitions []*Transition `locationName:"Transition" type:"list" flattened:"true"`
}

// String returns the string representation
func (s LifecycleRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleRule"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpiration sets the Expiration field's value.
func (s *LifecycleRule) SetExpiration(v *LifecycleExpiration) *LifecycleRule {
	s.Expiration = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *LifecycleRule) SetFilter(v *LifecycleRuleFilter) *LifecycleRule {
	s.Filter = v
	return s
}

// SetID sets the ID field's value.
func (s *LifecycleRule) SetID(v string) *LifecycleRule {
	s.ID = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LifecycleRule) SetStatus(v string) *LifecycleRule {
	s.Status = &v
	return s
}

// SetTransitions sets the Transitions field's value.
func (s *LifecycleRule) SetTransitions(v []*Transition) *LifecycleRule {
	s.Transitions = v
	return s
}

// The Filter is used to identify objects that a Lifecycle Rule applies to.
// A Filter must have exactly one of Prefix, Tag, or And specified.
type LifecycleRuleFilter struct {
	_ struct{} `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	//
	// Replacement must be made for object keys containing special characters (such
	// as carriage returns) when using XML requests. For more information, see XML
	// related object key constraints (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s LifecycleRuleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRuleFilter) GoString() string {
	return s.String()
}

// SetPrefix sets the Prefix field's value.
func (s *LifecycleRuleFilter) SetPrefix(v string) *LifecycleRuleFilter {
	s.Prefix = &v
	return s
}

type ListBucketsExtendedInput struct {
	_ struct{} `locationName:"ListBucketsExtendedRequest" type:"structure"`

	// Sets the IBM Service Instance Id in the request.
	//
	// Only Valid for IBM IAM Authentication
	IBMServiceInstanceId *string `location:"header" locationName:"ibm-service-instance-id" type:"string"`

	// Specifies the bucket to start with when listing all buckets.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to buckets that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`
}

// String returns the string representation
func (s ListBucketsExtendedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsExtendedInput) GoString() string {
	return s.String()
}

// SetIBMServiceInstanceId sets the IBMServiceInstanceId field's value.
func (s *ListBucketsExtendedInput) SetIBMServiceInstanceId(v string) *ListBucketsExtendedInput {
	s.IBMServiceInstanceId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListBucketsExtendedInput) SetMarker(v string) *ListBucketsExtendedInput {
	s.Marker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListBucketsExtendedInput) SetMaxKeys(v int64) *ListBucketsExtendedInput {
	s.MaxKeys = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListBucketsExtendedInput) SetPrefix(v string) *ListBucketsExtendedInput {
	s.Prefix = &v
	return s
}

type ListBucketsExtendedOutput struct {
	_ struct{} `type:"structure"`

	Buckets []*BucketExtended `locationNameList:"Bucket" type:"list"`

	// Indicates whether the returned list of buckets is truncated.
	IsTruncated *bool `type:"boolean"`

	// The bucket at or after which the listing began.
	Marker *string `type:"string"`

	MaxKeys *int64 `type:"integer"`

	// Container for the owner's display name and ID.
	Owner *Owner `type:"structure"`

	// When a prefix is provided in the request, this field contains the specified
	// prefix. The result contains only buckets starting with the specified prefix.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s ListBucketsExtendedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsExtendedOutput) GoString() string {
	return s.String()
}

// SetBuckets sets the Buckets field's value.
func (s *ListBucketsExtendedOutput) SetBuckets(v []*BucketExtended) *ListBucketsExtendedOutput {
	s.Buckets = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListBucketsExtendedOutput) SetIsTruncated(v bool) *ListBucketsExtendedOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListBucketsExtendedOutput) SetMarker(v string) *ListBucketsExtendedOutput {
	s.Marker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListBucketsExtendedOutput) SetMaxKeys(v int64) *ListBucketsExtendedOutput {
	s.MaxKeys = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListBucketsExtendedOutput) SetOwner(v *Owner) *ListBucketsExtendedOutput {
	s.Owner = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListBucketsExtendedOutput) SetPrefix(v string) *ListBucketsExtendedOutput {
	s.Prefix = &v
	return s
}

type ListBucketsInput struct {
	_ struct{} `locationName:"ListBucketsRequest" type:"structure"`

	// Sets the IBM Service Instance Id in the request.
	//
	// Only Valid for IBM IAM Authentication
	IBMServiceInstanceId *string `location:"header" locationName:"ibm-service-instance-id" type:"string"`
}

// String returns the string representation
func (s ListBucketsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsInput) GoString() string {
	return s.String()
}

// SetIBMServiceInstanceId sets the IBMServiceInstanceId field's value.
func (s *ListBucketsInput) SetIBMServiceInstanceId(v string) *ListBucketsInput {
	s.IBMServiceInstanceId = &v
	return s
}

type ListBucketsOutput struct {
	_ struct{} `type:"structure"`

	// The list of buckets owned by the requestor.
	Buckets []*Bucket `locationNameList:"Bucket" type:"list"`

	// The owner of the buckets listed.
	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s ListBucketsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsOutput) GoString() string {
	return s.String()
}

// SetBuckets sets the Buckets field's value.
func (s *ListBucketsOutput) SetBuckets(v []*Bucket) *ListBucketsOutput {
	s.Buckets = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListBucketsOutput) SetOwner(v *Owner) *ListBucketsOutput {
	s.Owner = v
	return s
}

type ListLegalHoldsInput struct {
	_ struct{} `locationName:"ListLegalHoldsRequest" type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLegalHoldsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLegalHoldsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLegalHoldsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLegalHoldsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListLegalHoldsInput) SetBucket(v string) *ListLegalHoldsInput {
	s.Bucket = &v
	return s
}

func (s *ListLegalHoldsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *ListLegalHoldsInput) SetKey(v string) *ListLegalHoldsInput {
	s.Key = &v
	return s
}

type ListLegalHoldsOutput struct {
	_ struct{} `type:"structure"`

	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	LegalHolds []*LegalHold `type:"list"`

	// Retention period to store on the object in seconds. The object can be neither
	// overwritten nor deleted until the amount of time specified in the retention
	// period has elapsed. If this field and Retention-Expiration-Date are specified
	// a 400 error is returned. If neither is specified the bucket's DefaultRetention
	// period will be used. 0 is a legal value assuming the bucket's minimum retention
	// period is also 0.
	RetentionPeriod *int64 `type:"integer"`

	RetentionPeriodExpirationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ListLegalHoldsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLegalHoldsOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListLegalHoldsOutput) SetCreateTime(v time.Time) *ListLegalHoldsOutput {
	s.CreateTime = &v
	return s
}

// SetLegalHolds sets the LegalHolds field's value.
func (s *ListLegalHoldsOutput) SetLegalHolds(v []*LegalHold) *ListLegalHoldsOutput {
	s.LegalHolds = v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *ListLegalHoldsOutput) SetRetentionPeriod(v int64) *ListLegalHoldsOutput {
	s.RetentionPeriod = &v
	return s
}

// SetRetentionPeriodExpirationDate sets the RetentionPeriodExpirationDate field's value.
func (s *ListLegalHoldsOutput) SetRetentionPeriodExpirationDate(v time.Time) *ListLegalHoldsOutput {
	s.RetentionPeriodExpirationDate = &v
	return s
}

type ListMultipartUploadsInput struct {
	_ struct{} `locationName:"ListMultipartUploadsRequest" type:"structure"`

	// The name of the bucket to which the multipart upload was initiated.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Character you use to group keys.
	//
	// All keys that contain the same string between the prefix, if specified, and
	// the first occurrence of the delimiter after the prefix are grouped under
	// a single result element, CommonPrefixes. If you don't specify the prefix
	// parameter, then the substring starts at the beginning of the key. The keys
	// that are grouped under CommonPrefixes result element are not returned elsewhere
	// in the response.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Together with upload-id-marker, this parameter specifies the multipart upload
	// after which listing should begin.
	//
	// If upload-id-marker is not specified, only the keys lexicographically greater
	// than the specified key-marker will be included in the list.
	//
	// If upload-id-marker is specified, any multipart uploads for a key equal to
	// the key-marker might also be included, provided those multipart uploads have
	// upload IDs lexicographically greater than the specified upload-id-marker.
	KeyMarker *string `location:"querystring" locationName:"key-marker" type:"string"`

	// Sets the maximum number of multipart uploads, from 1 to 1,000, to return
	// in the response body. 1,000 is the maximum number of uploads that can be
	// returned in a response.
	MaxUploads *int64 `location:"querystring" locationName:"max-uploads" type:"integer"`

	// Lists in-progress uploads only for those keys that begin with the specified
	// prefix. You can use prefixes to separate a bucket into different grouping
	// of keys. (You can think of using prefix to make groups in the same way you'd
	// use a folder in a file system.)
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Together with key-marker, specifies the multipart upload after which listing
	// should begin. If key-marker is not specified, the upload-id-marker parameter
	// is ignored. Otherwise, any multipart uploads for a key equal to the key-marker
	// might be included in the list only if they have an upload ID lexicographically
	// greater than the specified upload-id-marker.
	UploadIdMarker *string `location:"querystring" locationName:"upload-id-marker" type:"string"`
}

// String returns the string representation
func (s ListMultipartUploadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMultipartUploadsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMultipartUploadsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListMultipartUploadsInput) SetBucket(v string) *ListMultipartUploadsInput {
	s.Bucket = &v
	return s
}

func (s *ListMultipartUploadsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListMultipartUploadsInput) SetDelimiter(v string) *ListMultipartUploadsInput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListMultipartUploadsInput) SetEncodingType(v string) *ListMultipartUploadsInput {
	s.EncodingType = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *ListMultipartUploadsInput) SetExpectedBucketOwner(v string) *ListMultipartUploadsInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListMultipartUploadsInput) SetKeyMarker(v string) *ListMultipartUploadsInput {
	s.KeyMarker = &v
	return s
}

// SetMaxUploads sets the MaxUploads field's value.
func (s *ListMultipartUploadsInput) SetMaxUploads(v int64) *ListMultipartUploadsInput {
	s.MaxUploads = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListMultipartUploadsInput) SetPrefix(v string) *ListMultipartUploadsInput {
	s.Prefix = &v
	return s
}

// SetUploadIdMarker sets the UploadIdMarker field's value.
func (s *ListMultipartUploadsInput) SetUploadIdMarker(v string) *ListMultipartUploadsInput {
	s.UploadIdMarker = &v
	return s
}

type ListMultipartUploadsOutput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	// If you specify a delimiter in the request, then the result returns each distinct
	// key prefix containing the delimiter in a CommonPrefixes element. The distinct
	// key prefixes are returned in the Prefix child element.
	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	// Contains the delimiter you specified in the request. If you don't specify
	// a delimiter in your request, this element is absent from the response.
	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	//
	// If you specify encoding-type request parameter, Amazon S3 includes this element
	// in the response, and returns encoded key name values in the following response
	// elements:
	//
	// Delimiter, KeyMarker, Prefix, NextKeyMarker, Key.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// Indicates whether the returned list of multipart uploads is truncated. A
	// value of true indicates that the list was truncated. The list can be truncated
	// if the number of multipart uploads exceeds the limit allowed or specified
	// by max uploads.
	IsTruncated *bool `type:"boolean"`

	// The key at or after which the listing began.
	KeyMarker *string `type:"string"`

	// Maximum number of multipart uploads that could have been included in the
	// response.
	MaxUploads *int64 `type:"integer"`

	// When a list is truncated, this element specifies the value that should be
	// used for the key-marker request parameter in a subsequent request.
	NextKeyMarker *string `type:"string"`

	// When a list is truncated, this element specifies the value that should be
	// used for the upload-id-marker request parameter in a subsequent request.
	NextUploadIdMarker *string `type:"string"`

	// When a prefix is provided in the request, this field contains the specified
	// prefix. The result contains only keys starting with the specified prefix.
	Prefix *string `type:"string"`

	// Upload ID after which listing began.
	UploadIdMarker *string `type:"string"`

	// Container for elements related to a particular multipart upload. A response
	// can contain zero or more Upload elements.
	Uploads []*MultipartUpload `locationName:"Upload" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListMultipartUploadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *ListMultipartUploadsOutput) SetBucket(v string) *ListMultipartUploadsOutput {
	s.Bucket = &v
	return s
}

func (s *ListMultipartUploadsOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListMultipartUploadsOutput) SetCommonPrefixes(v []*CommonPrefix) *ListMultipartUploadsOutput {
	s.CommonPrefixes = v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListMultipartUploadsOutput) SetDelimiter(v string) *ListMultipartUploadsOutput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListMultipartUploadsOutput) SetEncodingType(v string) *ListMultipartUploadsOutput {
	s.EncodingType = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListMultipartUploadsOutput) SetIsTruncated(v bool) *ListMultipartUploadsOutput {
	s.IsTruncated = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListMultipartUploadsOutput) SetKeyMarker(v string) *ListMultipartUploadsOutput {
	s.KeyMarker = &v
	return s
}

// SetMaxUploads sets the MaxUploads field's value.
func (s *ListMultipartUploadsOutput) SetMaxUploads(v int64) *ListMultipartUploadsOutput {
	s.MaxUploads = &v
	return s
}

// SetNextKeyMarker sets the NextKeyMarker field's value.
func (s *ListMultipartUploadsOutput) SetNextKeyMarker(v string) *ListMultipartUploadsOutput {
	s.NextKeyMarker = &v
	return s
}

// SetNextUploadIdMarker sets the NextUploadIdMarker field's value.
func (s *ListMultipartUploadsOutput) SetNextUploadIdMarker(v string) *ListMultipartUploadsOutput {
	s.NextUploadIdMarker = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListMultipartUploadsOutput) SetPrefix(v string) *ListMultipartUploadsOutput {
	s.Prefix = &v
	return s
}

// SetUploadIdMarker sets the UploadIdMarker field's value.
func (s *ListMultipartUploadsOutput) SetUploadIdMarker(v string) *ListMultipartUploadsOutput {
	s.UploadIdMarker = &v
	return s
}

// SetUploads sets the Uploads field's value.
func (s *ListMultipartUploadsOutput) SetUploads(v []*MultipartUpload) *ListMultipartUploadsOutput {
	s.Uploads = v
	return s
}

type ListObjectVersionsInput struct {
	_ struct{} `locationName:"ListObjectVersionsRequest" type:"structure"`

	// The bucket name that contains the objects.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// A delimiter is a character that you specify to group keys. All keys that
	// contain the same string between the prefix and the first occurrence of the
	// delimiter are grouped under a single result element in CommonPrefixes. These
	// groups are counted as one result against the max-keys limitation. These keys
	// are not returned elsewhere in the response.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Specifies the key to start with when listing objects in a bucket.
	KeyMarker *string `location:"querystring" locationName:"key-marker" type:"string"`

	// Sets the maximum number of keys returned in the response. By default the
	// action returns up to 1,000 key names. The response might contain fewer keys
	// but will never contain more. If additional keys satisfy the search criteria,
	// but were not returned because max-keys was exceeded, the response contains
	// <isTruncated>true</isTruncated>. To return the additional keys, see key-marker
	// and version-id-marker.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Use this parameter to select only those keys that begin with the specified
	// prefix. You can use prefixes to separate a bucket into different groupings
	// of keys. (You can think of using prefix to make groups in the same way you'd
	// use a folder in a file system.) You can use prefix with delimiter to roll
	// up numerous objects into a single result under CommonPrefixes.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Specifies the object version you want to start listing from.
	VersionIdMarker *string `location:"querystring" locationName:"version-id-marker" type:"string"`
}

// String returns the string representation
func (s ListObjectVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectVersionsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListObjectVersionsInput) SetBucket(v string) *ListObjectVersionsInput {
	s.Bucket = &v
	return s
}

func (s *ListObjectVersionsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectVersionsInput) SetDelimiter(v string) *ListObjectVersionsInput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectVersionsInput) SetEncodingType(v string) *ListObjectVersionsInput {
	s.EncodingType = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *ListObjectVersionsInput) SetExpectedBucketOwner(v string) *ListObjectVersionsInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListObjectVersionsInput) SetKeyMarker(v string) *ListObjectVersionsInput {
	s.KeyMarker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectVersionsInput) SetMaxKeys(v int64) *ListObjectVersionsInput {
	s.MaxKeys = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectVersionsInput) SetPrefix(v string) *ListObjectVersionsInput {
	s.Prefix = &v
	return s
}

// SetVersionIdMarker sets the VersionIdMarker field's value.
func (s *ListObjectVersionsInput) SetVersionIdMarker(v string) *ListObjectVersionsInput {
	s.VersionIdMarker = &v
	return s
}

type ListObjectVersionsOutput struct {
	_ struct{} `type:"structure"`

	// All of the keys rolled up into a common prefix count as a single return when
	// calculating the number of returns.
	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	// Container for an object that is a delete marker.
	DeleteMarkers []*DeleteMarkerEntry `locationName:"DeleteMarker" type:"list" flattened:"true"`

	// The delimiter grouping the included keys. A delimiter is a character that
	// you specify to group keys. All keys that contain the same string between
	// the prefix and the first occurrence of the delimiter are grouped under a
	// single result element in CommonPrefixes. These groups are counted as one
	// result against the max-keys limitation. These keys are not returned elsewhere
	// in the response.
	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object key names in the XML response.
	//
	// If you specify encoding-type request parameter, Amazon S3 includes this element
	// in the response, and returns encoded key name values in the following response
	// elements:
	//
	// KeyMarker, NextKeyMarker, Prefix, Key, and Delimiter.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// A flag that indicates whether Amazon S3 returned all of the results that
	// satisfied the search criteria. If your results were truncated, you can make
	// a follow-up paginated request using the NextKeyMarker and NextVersionIdMarker
	// response parameters as a starting place in another request to return the
	// rest of the results.
	IsTruncated *bool `type:"boolean"`

	// Marks the last key returned in a truncated response.
	KeyMarker *string `type:"string"`

	// Specifies the maximum number of objects to return.
	MaxKeys *int64 `type:"integer"`

	// The bucket name.
	Name *string `type:"string"`

	// When the number of responses exceeds the value of MaxKeys, NextKeyMarker
	// specifies the first key not returned that satisfies the search criteria.
	// Use this value for the key-marker request parameter in a subsequent request.
	NextKeyMarker *string `type:"string"`

	// When the number of responses exceeds the value of MaxKeys, NextVersionIdMarker
	// specifies the first object version not returned that satisfies the search
	// criteria. Use this value for the version-id-marker request parameter in a
	// subsequent request.
	NextVersionIdMarker *string `type:"string"`

	// Selects objects that start with the value supplied by this parameter.
	Prefix *string `type:"string"`

	// Marks the last version of the key returned in a truncated response.
	VersionIdMarker *string `type:"string"`

	// Container for version information.
	Versions []*ObjectVersion `locationName:"Version" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListObjectVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectVersionsOutput) GoString() string {
	return s.String()
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListObjectVersionsOutput) SetCommonPrefixes(v []*CommonPrefix) *ListObjectVersionsOutput {
	s.CommonPrefixes = v
	return s
}

// SetDeleteMarkers sets the DeleteMarkers field's value.
func (s *ListObjectVersionsOutput) SetDeleteMarkers(v []*DeleteMarkerEntry) *ListObjectVersionsOutput {
	s.DeleteMarkers = v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectVersionsOutput) SetDelimiter(v string) *ListObjectVersionsOutput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectVersionsOutput) SetEncodingType(v string) *ListObjectVersionsOutput {
	s.EncodingType = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListObjectVersionsOutput) SetIsTruncated(v bool) *ListObjectVersionsOutput {
	s.IsTruncated = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListObjectVersionsOutput) SetKeyMarker(v string) *ListObjectVersionsOutput {
	s.KeyMarker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectVersionsOutput) SetMaxKeys(v int64) *ListObjectVersionsOutput {
	s.MaxKeys = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListObjectVersionsOutput) SetName(v string) *ListObjectVersionsOutput {
	s.Name = &v
	return s
}

// SetNextKeyMarker sets the NextKeyMarker field's value.
func (s *ListObjectVersionsOutput) SetNextKeyMarker(v string) *ListObjectVersionsOutput {
	s.NextKeyMarker = &v
	return s
}

// SetNextVersionIdMarker sets the NextVersionIdMarker field's value.
func (s *ListObjectVersionsOutput) SetNextVersionIdMarker(v string) *ListObjectVersionsOutput {
	s.NextVersionIdMarker = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectVersionsOutput) SetPrefix(v string) *ListObjectVersionsOutput {
	s.Prefix = &v
	return s
}

// SetVersionIdMarker sets the VersionIdMarker field's value.
func (s *ListObjectVersionsOutput) SetVersionIdMarker(v string) *ListObjectVersionsOutput {
	s.VersionIdMarker = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListObjectVersionsOutput) SetVersions(v []*ObjectVersion) *ListObjectVersionsOutput {
	s.Versions = v
	return s
}

type ListObjectsInput struct {
	_ struct{} `locationName:"ListObjectsRequest" type:"structure"`

	// The name of the bucket containing the objects.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Specifies the key to start with when listing objects in a bucket.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Sets the maximum number of keys returned in the response. By default the
	// action returns up to 1,000 key names. The response might contain fewer keys
	// but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// list objects request. Bucket owners need not specify this parameter in their
	// requests.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation
func (s ListObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListObjectsInput) SetBucket(v string) *ListObjectsInput {
	s.Bucket = &v
	return s
}

func (s *ListObjectsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsInput) SetDelimiter(v string) *ListObjectsInput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsInput) SetEncodingType(v string) *ListObjectsInput {
	s.EncodingType = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *ListObjectsInput) SetExpectedBucketOwner(v string) *ListObjectsInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListObjectsInput) SetMarker(v string) *ListObjectsInput {
	s.Marker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsInput) SetMaxKeys(v int64) *ListObjectsInput {
	s.MaxKeys = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsInput) SetPrefix(v string) *ListObjectsInput {
	s.Prefix = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *ListObjectsInput) SetRequestPayer(v string) *ListObjectsInput {
	s.RequestPayer = &v
	return s
}

type ListObjectsOutput struct {
	_ struct{} `type:"structure"`

	// All of the keys (up to 1,000) rolled up in a common prefix count as a single
	// return when calculating the number of returns.
	//
	// A response can contain CommonPrefixes only if you specify a delimiter.
	//
	// CommonPrefixes contains all (if there are any) keys between Prefix and the
	// next occurrence of the string specified by the delimiter.
	//
	// CommonPrefixes lists keys that act like subdirectories in the directory specified
	// by Prefix.
	//
	// For example, if the prefix is notes/ and the delimiter is a slash (/) as
	// in notes/summer/july, the common prefix is notes/summer/. All of the keys
	// that roll up into a common prefix count as a single return when calculating
	// the number of returns.
	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	// Metadata about each object returned.
	Contents []*Object `type:"list" flattened:"true"`

	// Causes keys that contain the same string between the prefix and the first
	// occurrence of the delimiter to be rolled up into a single result element
	// in the CommonPrefixes collection. These rolled-up keys are not returned elsewhere
	// in the response. Each rolled-up result counts as only one return against
	// the MaxKeys value.
	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// The root key used by Key Protect to encrypt this bucket. This value must
	// be the full CRN of the root key.
	IBMSSEKPCrkId *string `location:"header" locationName:"ibm-sse-kp-customer-root-key-crn" type:"string"`

	// Specifies whether the Bucket has Key Protect enabled.
	IBMSSEKPEnabled *bool `location:"header" locationName:"ibm-sse-kp-enabled" type:"boolean"`

	// A flag that indicates whether Amazon S3 returned all of the results that
	// satisfied the search criteria.
	IsTruncated *bool `type:"boolean"`

	// Indicates where in the bucket listing begins. Marker is included in the response
	// if it was sent with the request.
	Marker *string `type:"string"`

	// The maximum number of keys returned in the response body.
	MaxKeys *int64 `type:"integer"`

	// The bucket name.
	Name *string `type:"string"`

	// When response is truncated (the IsTruncated element value in the response
	// is true), you can use the key name in this field as marker in the subsequent
	// request to get next set of objects. Amazon S3 lists objects in alphabetical
	// order Note: This element is returned only if you have delimiter request parameter
	// specified. If response does not include the NextMarker and it is truncated,
	// you can use the value of the last Key in the response as the marker in the
	// subsequent request to get the next set of object keys.
	NextMarker *string `type:"string"`

	// Keys that begin with the indicated prefix.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s ListObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsOutput) GoString() string {
	return s.String()
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListObjectsOutput) SetCommonPrefixes(v []*CommonPrefix) *ListObjectsOutput {
	s.CommonPrefixes = v
	return s
}

// SetContents sets the Contents field's value.
func (s *ListObjectsOutput) SetContents(v []*Object) *ListObjectsOutput {
	s.Contents = v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsOutput) SetDelimiter(v string) *ListObjectsOutput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsOutput) SetEncodingType(v string) *ListObjectsOutput {
	s.EncodingType = &v
	return s
}

// SetIBMSSEKPCrkId sets the IBMSSEKPCrkId field's value.
func (s *ListObjectsOutput) SetIBMSSEKPCrkId(v string) *ListObjectsOutput {
	s.IBMSSEKPCrkId = &v
	return s
}

// SetIBMSSEKPEnabled sets the IBMSSEKPEnabled field's value.
func (s *ListObjectsOutput) SetIBMSSEKPEnabled(v bool) *ListObjectsOutput {
	s.IBMSSEKPEnabled = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListObjectsOutput) SetIsTruncated(v bool) *ListObjectsOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListObjectsOutput) SetMarker(v string) *ListObjectsOutput {
	s.Marker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsOutput) SetMaxKeys(v int64) *ListObjectsOutput {
	s.MaxKeys = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListObjectsOutput) SetName(v string) *ListObjectsOutput {
	s.Name = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListObjectsOutput) SetNextMarker(v string) *ListObjectsOutput {
	s.NextMarker = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsOutput) SetPrefix(v string) *ListObjectsOutput {
	s.Prefix = &v
	return s
}

type ListObjectsV2Input struct {
	_ struct{} `locationName:"ListObjectsV2Request" type:"structure"`

	// Bucket name to list.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// ContinuationToken indicates Amazon S3 that the list is being continued on
	// this bucket with a token. ContinuationToken is obfuscated and is not a real
	// key.
	ContinuationToken *string `location:"querystring" locationName:"continuation-token" type:"string"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The owner field is not present in listV2 by default, if you want to return
	// owner field with each key in the result then set the fetch owner field to
	// true.
	FetchOwner *bool `location:"querystring" locationName:"fetch-owner" type:"boolean"`

	// Sets the maximum number of keys returned in the response. By default the
	// action returns up to 1,000 key names. The response might contain fewer keys
	// but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// list objects request in V2 style. Bucket owners need not specify this parameter
	// in their requests.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts
	// listing after this specified key. StartAfter can be any key in the bucket.
	StartAfter *string `location:"querystring" locationName:"start-after" type:"string"`
}

// String returns the string representation
func (s ListObjectsV2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectsV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectsV2Input"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListObjectsV2Input) SetBucket(v string) *ListObjectsV2Input {
	s.Bucket = &v
	return s
}

func (s *ListObjectsV2Input) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListObjectsV2Input) SetContinuationToken(v string) *ListObjectsV2Input {
	s.ContinuationToken = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsV2Input) SetDelimiter(v string) *ListObjectsV2Input {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsV2Input) SetEncodingType(v string) *ListObjectsV2Input {
	s.EncodingType = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *ListObjectsV2Input) SetExpectedBucketOwner(v string) *ListObjectsV2Input {
	s.ExpectedBucketOwner = &v
	return s
}

// SetFetchOwner sets the FetchOwner field's value.
func (s *ListObjectsV2Input) SetFetchOwner(v bool) *ListObjectsV2Input {
	s.FetchOwner = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsV2Input) SetMaxKeys(v int64) *ListObjectsV2Input {
	s.MaxKeys = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsV2Input) SetPrefix(v string) *ListObjectsV2Input {
	s.Prefix = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *ListObjectsV2Input) SetRequestPayer(v string) *ListObjectsV2Input {
	s.RequestPayer = &v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *ListObjectsV2Input) SetStartAfter(v string) *ListObjectsV2Input {
	s.StartAfter = &v
	return s
}

type ListObjectsV2Output struct {
	_ struct{} `type:"structure"`

	// All of the keys (up to 1,000) rolled up into a common prefix count as a single
	// return when calculating the number of returns.
	//
	// A response can contain CommonPrefixes only if you specify a delimiter.
	//
	// CommonPrefixes contains all (if there are any) keys between Prefix and the
	// next occurrence of the string specified by a delimiter.
	//
	// CommonPrefixes lists keys that act like subdirectories in the directory specified
	// by Prefix.
	//
	// For example, if the prefix is notes/ and the delimiter is a slash (/) as
	// in notes/summer/july, the common prefix is notes/summer/. All of the keys
	// that roll up into a common prefix count as a single return when calculating
	// the number of returns.
	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	// Metadata about each object returned.
	Contents []*Object `type:"list" flattened:"true"`

	// If ContinuationToken was sent with the request, it is included in the response.
	ContinuationToken *string `type:"string"`

	// Causes keys that contain the same string between the prefix and the first
	// occurrence of the delimiter to be rolled up into a single result element
	// in the CommonPrefixes collection. These rolled-up keys are not returned elsewhere
	// in the response. Each rolled-up result counts as only one return against
	// the MaxKeys value.
	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object key names in the XML response.
	//
	// If you specify the encoding-type request parameter, Amazon S3 includes this
	// element in the response, and returns encoded key name values in the following
	// response elements:
	//
	// Delimiter, Prefix, Key, and StartAfter.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// Set to false if all of the results were returned. Set to true if more keys
	// are available to return. If the number of results exceeds that specified
	// by MaxKeys, all of the results might not be returned.
	IsTruncated *bool `type:"boolean"`

	// KeyCount is the number of keys returned with this request. KeyCount will
	// always be less than or equals to MaxKeys field. Say you ask for 50 keys,
	// your result will include less than equals 50 keys
	KeyCount *int64 `type:"integer"`

	// Sets the maximum number of keys returned in the response. By default the
	// action returns up to 1,000 key names. The response might contain fewer keys
	// but will never contain more.
	MaxKeys *int64 `type:"integer"`

	// The bucket name.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	Name *string `type:"string"`

	// NextContinuationToken is sent when isTruncated is true, which means there
	// are more keys in the bucket that can be listed. The next list requests to
	// Amazon S3 can be continued with this NextContinuationToken. NextContinuationToken
	// is obfuscated and is not a real key
	NextContinuationToken *string `type:"string"`

	// Keys that begin with the indicated prefix.
	Prefix *string `type:"string"`

	// If StartAfter was sent with the request, it is included in the response.
	StartAfter *string `type:"string"`
}

// String returns the string representation
func (s ListObjectsV2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsV2Output) GoString() string {
	return s.String()
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListObjectsV2Output) SetCommonPrefixes(v []*CommonPrefix) *ListObjectsV2Output {
	s.CommonPrefixes = v
	return s
}

// SetContents sets the Contents field's value.
func (s *ListObjectsV2Output) SetContents(v []*Object) *ListObjectsV2Output {
	s.Contents = v
	return s
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListObjectsV2Output) SetContinuationToken(v string) *ListObjectsV2Output {
	s.ContinuationToken = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsV2Output) SetDelimiter(v string) *ListObjectsV2Output {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsV2Output) SetEncodingType(v string) *ListObjectsV2Output {
	s.EncodingType = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListObjectsV2Output) SetIsTruncated(v bool) *ListObjectsV2Output {
	s.IsTruncated = &v
	return s
}

// SetKeyCount sets the KeyCount field's value.
func (s *ListObjectsV2Output) SetKeyCount(v int64) *ListObjectsV2Output {
	s.KeyCount = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsV2Output) SetMaxKeys(v int64) *ListObjectsV2Output {
	s.MaxKeys = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListObjectsV2Output) SetName(v string) *ListObjectsV2Output {
	s.Name = &v
	return s
}

// SetNextContinuationToken sets the NextContinuationToken field's value.
func (s *ListObjectsV2Output) SetNextContinuationToken(v string) *ListObjectsV2Output {
	s.NextContinuationToken = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsV2Output) SetPrefix(v string) *ListObjectsV2Output {
	s.Prefix = &v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *ListObjectsV2Output) SetStartAfter(v string) *ListObjectsV2Output {
	s.StartAfter = &v
	return s
}

type ListPartsInput struct {
	_ struct{} `locationName:"ListPartsRequest" type:"structure"`

	// The name of the bucket to which the parts are being uploaded.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Object key for which the multipart upload was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Sets the maximum number of parts to return.
	MaxParts *int64 `location:"querystring" locationName:"max-parts" type:"integer"`

	// Specifies the part after which listing should begin. Only parts with higher
	// part numbers will be listed.
	PartNumberMarker *int64 `location:"querystring" locationName:"part-number-marker" type:"integer"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPartsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPartsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPartsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListPartsInput) SetBucket(v string) *ListPartsInput {
	s.Bucket = &v
	return s
}

func (s *ListPartsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *ListPartsInput) SetExpectedBucketOwner(v string) *ListPartsInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ListPartsInput) SetKey(v string) *ListPartsInput {
	s.Key = &v
	return s
}

// SetMaxParts sets the MaxParts field's value.
func (s *ListPartsInput) SetMaxParts(v int64) *ListPartsInput {
	s.MaxParts = &v
	return s
}

// SetPartNumberMarker sets the PartNumberMarker field's value.
func (s *ListPartsInput) SetPartNumberMarker(v int64) *ListPartsInput {
	s.PartNumberMarker = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *ListPartsInput) SetRequestPayer(v string) *ListPartsInput {
	s.RequestPayer = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *ListPartsInput) SetUploadId(v string) *ListPartsInput {
	s.UploadId = &v
	return s
}

type ListPartsOutput struct {
	_ struct{} `type:"structure"`

	// If the bucket has a lifecycle rule configured with an action to abort incomplete
	// multipart uploads and the prefix in the lifecycle rule matches the object
	// name in the request, then the response includes this header indicating when
	// the initiated multipart upload will become eligible for abort operation.
	// For more information, see Aborting Incomplete Multipart Uploads Using a Bucket
	// Lifecycle Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config).
	//
	// The response will also include the x-amz-abort-rule-id header that will provide
	// the ID of the lifecycle configuration rule that defines this action.
	AbortDate *time.Time `location:"header" locationName:"x-amz-abort-date" type:"timestamp"`

	// This header is returned along with the x-amz-abort-date header. It identifies
	// applicable lifecycle configuration rule that defines the action to abort
	// incomplete multipart uploads.
	AbortRuleId *string `location:"header" locationName:"x-amz-abort-rule-id" type:"string"`

	// The name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	// Container element that identifies who initiated the multipart upload. If
	// the initiator is an AWS account, this element provides the same information
	// as the Owner element. If the initiator is an IAM User, this element provides
	// the user ARN and display name.
	Initiator *Initiator `type:"structure"`

	// Indicates whether the returned list of parts is truncated. A true value indicates
	// that the list was truncated. A list can be truncated if the number of parts
	// exceeds the limit returned in the MaxParts element.
	IsTruncated *bool `type:"boolean"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// Maximum number of parts that were allowed in the response.
	MaxParts *int64 `type:"integer"`

	// When a list is truncated, this element specifies the last part in the list,
	// as well as the value to use for the part-number-marker request parameter
	// in a subsequent request.
	NextPartNumberMarker *int64 `type:"integer"`

	// Container element that identifies the object owner, after the object is created.
	// If multipart upload is initiated by an IAM user, this element provides the
	// parent account ID and display name.
	Owner *Owner `type:"structure"`

	// When a list is truncated, this element specifies the last part in the list,
	// as well as the value to use for the part-number-marker request parameter
	// in a subsequent request.
	PartNumberMarker *int64 `type:"integer"`

	// Container for elements related to a particular part. A response can contain
	// zero or more Part elements.
	Parts []*Part `locationName:"Part" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Class of storage (STANDARD or REDUCED_REDUNDANCY) used to store the uploaded
	// object.
	StorageClass *string `type:"string" enum:"StorageClass"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s ListPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsOutput) GoString() string {
	return s.String()
}

// SetAbortDate sets the AbortDate field's value.
func (s *ListPartsOutput) SetAbortDate(v time.Time) *ListPartsOutput {
	s.AbortDate = &v
	return s
}

// SetAbortRuleId sets the AbortRuleId field's value.
func (s *ListPartsOutput) SetAbortRuleId(v string) *ListPartsOutput {
	s.AbortRuleId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *ListPartsOutput) SetBucket(v string) *ListPartsOutput {
	s.Bucket = &v
	return s
}

func (s *ListPartsOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetInitiator sets the Initiator field's value.
func (s *ListPartsOutput) SetInitiator(v *Initiator) *ListPartsOutput {
	s.Initiator = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListPartsOutput) SetIsTruncated(v bool) *ListPartsOutput {
	s.IsTruncated = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ListPartsOutput) SetKey(v string) *ListPartsOutput {
	s.Key = &v
	return s
}

// SetMaxParts sets the MaxParts field's value.
func (s *ListPartsOutput) SetMaxParts(v int64) *ListPartsOutput {
	s.MaxParts = &v
	return s
}

// SetNextPartNumberMarker sets the NextPartNumberMarker field's value.
func (s *ListPartsOutput) SetNextPartNumberMarker(v int64) *ListPartsOutput {
	s.NextPartNumberMarker = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListPartsOutput) SetOwner(v *Owner) *ListPartsOutput {
	s.Owner = v
	return s
}

// SetPartNumberMarker sets the PartNumberMarker field's value.
func (s *ListPartsOutput) SetPartNumberMarker(v int64) *ListPartsOutput {
	s.PartNumberMarker = &v
	return s
}

// SetParts sets the Parts field's value.
func (s *ListPartsOutput) SetParts(v []*Part) *ListPartsOutput {
	s.Parts = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *ListPartsOutput) SetRequestCharged(v string) *ListPartsOutput {
	s.RequestCharged = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *ListPartsOutput) SetStorageClass(v string) *ListPartsOutput {
	s.StorageClass = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *ListPartsOutput) SetUploadId(v string) *ListPartsOutput {
	s.UploadId = &v
	return s
}

// Describes where logs are stored and the prefix that Amazon S3 assigns to
// all log object keys for a bucket. For more information, see PUT Bucket logging
// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html)
// in the Amazon Simple Storage Service API Reference.
type LoggingEnabled struct {
	_ struct{} `type:"structure"`

	// Specifies the bucket where you want Amazon S3 to store server access logs.
	// You can have your logs delivered to any bucket that you own, including the
	// same bucket that is being logged. You can also configure multiple buckets
	// to deliver their logs to the same target bucket. In this case, you should
	// choose a different TargetPrefix for each source bucket so that the delivered
	// log files can be distinguished by key.
	//
	// TargetBucket is a required field
	TargetBucket *string `type:"string" required:"true"`

	// Container for granting information.
	TargetGrants []*TargetGrant `locationNameList:"Grant" type:"list"`

	// A prefix for all log object keys. If you store log files from multiple Amazon
	// S3 buckets in a single bucket, you can use a prefix to distinguish which
	// log files came from which bucket.
	//
	// TargetPrefix is a required field
	TargetPrefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingEnabled) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingEnabled) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingEnabled) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingEnabled"}
	if s.TargetBucket == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetBucket"))
	}
	if s.TargetPrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetPrefix"))
	}
	if s.TargetGrants != nil {
		for i, v := range s.TargetGrants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetGrants", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetBucket sets the TargetBucket field's value.
func (s *LoggingEnabled) SetTargetBucket(v string) *LoggingEnabled {
	s.TargetBucket = &v
	return s
}

// SetTargetGrants sets the TargetGrants field's value.
func (s *LoggingEnabled) SetTargetGrants(v []*TargetGrant) *LoggingEnabled {
	s.TargetGrants = v
	return s
}

// SetTargetPrefix sets the TargetPrefix field's value.
func (s *LoggingEnabled) SetTargetPrefix(v string) *LoggingEnabled {
	s.TargetPrefix = &v
	return s
}

// Container for the MultipartUpload for the Amazon S3 object.
type MultipartUpload struct {
	_ struct{} `type:"structure"`

	// Date and time at which the multipart upload was initiated.
	Initiated *time.Time `type:"timestamp"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Key of the object for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// Specifies the owner of the object that is part of the multipart upload.
	Owner *Owner `type:"structure"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"StorageClass"`

	// Upload ID that identifies the multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s MultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultipartUpload) GoString() string {
	return s.String()
}

// SetInitiated sets the Initiated field's value.
func (s *MultipartUpload) SetInitiated(v time.Time) *MultipartUpload {
	s.Initiated = &v
	return s
}

// SetInitiator sets the Initiator field's value.
func (s *MultipartUpload) SetInitiator(v *Initiator) *MultipartUpload {
	s.Initiator = v
	return s
}

// SetKey sets the Key field's value.
func (s *MultipartUpload) SetKey(v string) *MultipartUpload {
	s.Key = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *MultipartUpload) SetOwner(v *Owner) *MultipartUpload {
	s.Owner = v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *MultipartUpload) SetStorageClass(v string) *MultipartUpload {
	s.StorageClass = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *MultipartUpload) SetUploadId(v string) *MultipartUpload {
	s.UploadId = &v
	return s
}

// An object consists of data and its descriptive metadata.
type Object struct {
	_ struct{} `type:"structure"`

	// The entity tag is a hash of the object. The ETag reflects changes only to
	// the contents of an object, not its metadata. The ETag may or may not be an
	// MD5 digest of the object data. Whether or not it is depends on how the object
	// was created and how it is encrypted as described below:
	//
	//    * Objects created by the PUT Object, POST Object, or Copy operation, or
	//    through the AWS Management Console, and are encrypted by SSE-S3 or plaintext,
	//    have ETags that are an MD5 digest of their object data.
	//
	//    * Objects created by the PUT Object, POST Object, or Copy operation, or
	//    through the AWS Management Console, and are encrypted by SSE-C or SSE-KMS,
	//    have ETags that are not an MD5 digest of their object data.
	//
	//    * If an object is created by either the Multipart Upload or Part Copy
	//    operation, the ETag is not an MD5 digest, regardless of the method of
	//    encryption.
	ETag *string `type:"string"`

	// The name that you assign to an object. You use the object key to retrieve
	// the object.
	Key *string `min:"1" type:"string"`

	// Creation date of the object.
	LastModified *time.Time `type:"timestamp"`

	// The owner of the object
	Owner *Owner `type:"structure"`

	// Size in bytes of the object
	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"ObjectStorageClass"`
}

// String returns the string representation
func (s Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Object) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *Object) SetETag(v string) *Object {
	s.ETag = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Object) SetKey(v string) *Object {
	s.Key = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *Object) SetLastModified(v time.Time) *Object {
	s.LastModified = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *Object) SetOwner(v *Owner) *Object {
	s.Owner = v
	return s
}

// SetSize sets the Size field's value.
func (s *Object) SetSize(v int64) *Object {
	s.Size = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Object) SetStorageClass(v string) *Object {
	s.StorageClass = &v
	return s
}

// Object Identifier is unique value to identify objects.
type ObjectIdentifier struct {
	_ struct{} `type:"structure"`

	// Key name of the object.
	//
	// Replacement must be made for object keys containing special characters (such
	// as carriage returns) when using XML requests. For more information, see XML
	// related object key constraints (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// VersionId for the specific version of the object to delete.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectIdentifier"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ObjectIdentifier) SetKey(v string) *ObjectIdentifier {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *ObjectIdentifier) SetVersionId(v string) *ObjectIdentifier {
	s.VersionId = &v
	return s
}

// The version of an object.
type ObjectVersion struct {
	_ struct{} `type:"structure"`

	// The entity tag is an MD5 hash of that version of the object.
	ETag *string `type:"string"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp"`

	// Specifies the owner of the object.
	Owner *Owner `type:"structure"`

	// Size in bytes of the object.
	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"ObjectVersionStorageClass"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectVersion) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *ObjectVersion) SetETag(v string) *ObjectVersion {
	s.ETag = &v
	return s
}

// SetIsLatest sets the IsLatest field's value.
func (s *ObjectVersion) SetIsLatest(v bool) *ObjectVersion {
	s.IsLatest = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ObjectVersion) SetKey(v string) *ObjectVersion {
	s.Key = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *ObjectVersion) SetLastModified(v time.Time) *ObjectVersion {
	s.LastModified = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ObjectVersion) SetOwner(v *Owner) *ObjectVersion {
	s.Owner = v
	return s
}

// SetSize sets the Size field's value.
func (s *ObjectVersion) SetSize(v int64) *ObjectVersion {
	s.Size = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *ObjectVersion) SetStorageClass(v string) *ObjectVersion {
	s.StorageClass = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *ObjectVersion) SetVersionId(v string) *ObjectVersion {
	s.VersionId = &v
	return s
}

// Container for the owner's display name and ID.
type Owner struct {
	_ struct{} `type:"structure"`

	// Container for the display name of the owner.
	DisplayName *string `type:"string"`

	// Container for the ID of the owner.
	ID *string `type:"string"`
}

// String returns the string representation
func (s Owner) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Owner) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *Owner) SetDisplayName(v string) *Owner {
	s.DisplayName = &v
	return s
}

// SetID sets the ID field's value.
func (s *Owner) SetID(v string) *Owner {
	s.ID = &v
	return s
}

// Container for elements related to a part.
type Part struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Date and time at which the part was uploaded.
	LastModified *time.Time `type:"timestamp"`

	// Part number identifying the part. This is a positive integer between 1 and
	// 10,000.
	PartNumber *int64 `type:"integer"`

	// Size in bytes of the uploaded part data.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s Part) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Part) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *Part) SetETag(v string) *Part {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *Part) SetLastModified(v time.Time) *Part {
	s.LastModified = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *Part) SetPartNumber(v int64) *Part {
	s.PartNumber = &v
	return s
}

// SetSize sets the Size field's value.
func (s *Part) SetSize(v int64) *Part {
	s.Size = &v
	return s
}

type ProtectionConfiguration struct {
	_ struct{} `type:"structure"`

	// Default retention period for an object, if a PUT of an object does not specify
	// a retention period this value will be converted to seconds and used.
	//
	// DefaultRetention is a required field
	DefaultRetention *BucketProtectionDefaultRetention `type:"structure" required:"true"`

	// Enable permanent retention for an object.
	EnablePermanentRetention *bool `type:"boolean"`

	// Maximum retention period for an object, if a PUT of an object specifies a
	// longer retention period the PUT object will fail.
	//
	// MaximumRetention is a required field
	MaximumRetention *BucketProtectionMaximumRetention `type:"structure" required:"true"`

	// Minimum retention period for an object, if a PUT of an object specifies a
	// shorter retention period the PUT object will fail.
	//
	// MinimumRetention is a required field
	MinimumRetention *BucketProtectionMinimumRetention `type:"structure" required:"true"`

	// Retention status of a bucket.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"BucketProtectionStatus"`
}

// String returns the string representation
func (s ProtectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProtectionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProtectionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProtectionConfiguration"}
	if s.DefaultRetention == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultRetention"))
	}
	if s.MaximumRetention == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumRetention"))
	}
	if s.MinimumRetention == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimumRetention"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.DefaultRetention != nil {
		if err := s.DefaultRetention.Validate(); err != nil {
			invalidParams.AddNested("DefaultRetention", err.(request.ErrInvalidParams))
		}
	}
	if s.MaximumRetention != nil {
		if err := s.MaximumRetention.Validate(); err != nil {
			invalidParams.AddNested("MaximumRetention", err.(request.ErrInvalidParams))
		}
	}
	if s.MinimumRetention != nil {
		if err := s.MinimumRetention.Validate(); err != nil {
			invalidParams.AddNested("MinimumRetention", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultRetention sets the DefaultRetention field's value.
func (s *ProtectionConfiguration) SetDefaultRetention(v *BucketProtectionDefaultRetention) *ProtectionConfiguration {
	s.DefaultRetention = v
	return s
}

// SetEnablePermanentRetention sets the EnablePermanentRetention field's value.
func (s *ProtectionConfiguration) SetEnablePermanentRetention(v bool) *ProtectionConfiguration {
	s.EnablePermanentRetention = &v
	return s
}

// SetMaximumRetention sets the MaximumRetention field's value.
func (s *ProtectionConfiguration) SetMaximumRetention(v *BucketProtectionMaximumRetention) *ProtectionConfiguration {
	s.MaximumRetention = v
	return s
}

// SetMinimumRetention sets the MinimumRetention field's value.
func (s *ProtectionConfiguration) SetMinimumRetention(v *BucketProtectionMinimumRetention) *ProtectionConfiguration {
	s.MinimumRetention = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProtectionConfiguration) SetStatus(v string) *ProtectionConfiguration {
	s.Status = &v
	return s
}

// The PublicAccessBlock configuration that you want to apply to this Amazon
// S3 bucket. You can enable the configuration options in any combination. For
// more information about when Amazon S3 considers a bucket or object public,
// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon S3 User Guide.
type PublicAccessBlockConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 should block public access control lists (ACLs)
	// for this bucket and objects in this bucket. Setting this element to TRUE
	// causes the following behavior:
	//
	//    * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is
	//    public.
	//
	//    * PUT Object calls fail if the request includes a public ACL.
	//
	//    * PUT Bucket calls fail if the request includes a public ACL.
	//
	// Enabling this setting doesn't affect existing policies or ACLs.
	BlockPublicAcls *bool `locationName:"BlockPublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should ignore public ACLs for this bucket and
	// objects in this bucket. Setting this element to TRUE causes Amazon S3 to
	// ignore all public ACLs on this bucket and objects in this bucket.
	//
	// Enabling this setting doesn't affect the persistence of any existing ACLs
	// and doesn't prevent new public ACLs from being set.
	IgnorePublicAcls *bool `locationName:"IgnorePublicAcls" type:"boolean"`
}

// String returns the string representation
func (s PublicAccessBlockConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicAccessBlockConfiguration) GoString() string {
	return s.String()
}

// SetBlockPublicAcls sets the BlockPublicAcls field's value.
func (s *PublicAccessBlockConfiguration) SetBlockPublicAcls(v bool) *PublicAccessBlockConfiguration {
	s.BlockPublicAcls = &v
	return s
}

// SetIgnorePublicAcls sets the IgnorePublicAcls field's value.
func (s *PublicAccessBlockConfiguration) SetIgnorePublicAcls(v bool) *PublicAccessBlockConfiguration {
	s.IgnorePublicAcls = &v
	return s
}

type PutBucketAclInput struct {
	_ struct{} `locationName:"PutBucketAclRequest" type:"structure" payload:"AccessControlPolicy"`

	// The canned ACL to apply to the bucket.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"BucketCannedACL"`

	// Contains the elements that set the ACL permissions for an object per grantee.
	AccessControlPolicy *AccessControlPolicy `locationName:"AccessControlPolicy" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The bucket to which to apply the ACL.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`
}

// String returns the string representation
func (s PutBucketAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *PutBucketAclInput) SetACL(v string) *PutBucketAclInput {
	s.ACL = &v
	return s
}

// SetAccessControlPolicy sets the AccessControlPolicy field's value.
func (s *PutBucketAclInput) SetAccessControlPolicy(v *AccessControlPolicy) *PutBucketAclInput {
	s.AccessControlPolicy = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketAclInput) SetBucket(v string) *PutBucketAclInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *PutBucketAclInput) SetExpectedBucketOwner(v string) *PutBucketAclInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *PutBucketAclInput) SetGrantFullControl(v string) *PutBucketAclInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *PutBucketAclInput) SetGrantRead(v string) *PutBucketAclInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *PutBucketAclInput) SetGrantReadACP(v string) *PutBucketAclInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *PutBucketAclInput) SetGrantWrite(v string) *PutBucketAclInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *PutBucketAclInput) SetGrantWriteACP(v string) *PutBucketAclInput {
	s.GrantWriteACP = &v
	return s
}

type PutBucketAclOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAclOutput) GoString() string {
	return s.String()
}

type PutBucketCorsInput struct {
	_ struct{} `locationName:"PutBucketCorsRequest" type:"structure" payload:"CORSConfiguration"`

	// Specifies the bucket impacted by the corsconfiguration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Describes the cross-origin access configuration for objects in an Amazon
	// S3 bucket. For more information, see Enabling Cross-Origin Resource Sharing
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the Amazon
	// S3 User Guide.
	//
	// CORSConfiguration is a required field
	CORSConfiguration *CORSConfiguration `locationName:"CORSConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s PutBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketCorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketCorsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.CORSConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("CORSConfiguration"))
	}
	if s.CORSConfiguration != nil {
		if err := s.CORSConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CORSConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketCorsInput) SetBucket(v string) *PutBucketCorsInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCORSConfiguration sets the CORSConfiguration field's value.
func (s *PutBucketCorsInput) SetCORSConfiguration(v *CORSConfiguration) *PutBucketCorsInput {
	s.CORSConfiguration = v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *PutBucketCorsInput) SetExpectedBucketOwner(v string) *PutBucketCorsInput {
	s.ExpectedBucketOwner = &v
	return s
}

type PutBucketCorsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketCorsOutput) GoString() string {
	return s.String()
}

type PutBucketLifecycleConfigurationInput struct {
	_ struct{} `locationName:"PutBucketLifecycleConfigurationRequest" type:"structure" payload:"LifecycleConfiguration"`

	// The name of the bucket for which to set the configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Container for lifecycle rules. You can add as many as 1000 rules.
	LifecycleConfiguration *LifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketLifecycleConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketLifecycleConfigurationInput) SetBucket(v string) *PutBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketLifecycleConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *PutBucketLifecycleConfigurationInput) SetExpectedBucketOwner(v string) *PutBucketLifecycleConfigurationInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetLifecycleConfiguration sets the LifecycleConfiguration field's value.
func (s *PutBucketLifecycleConfigurationInput) SetLifecycleConfiguration(v *LifecycleConfiguration) *PutBucketLifecycleConfigurationInput {
	s.LifecycleConfiguration = v
	return s
}

type PutBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

type PutBucketLoggingInput struct {
	_ struct{} `locationName:"PutBucketLoggingRequest" type:"structure" payload:"BucketLoggingStatus"`

	// The name of the bucket for which to set the logging parameters.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for logging status information.
	//
	// BucketLoggingStatus is a required field
	BucketLoggingStatus *BucketLoggingStatus `locationName:"BucketLoggingStatus" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`
}

// String returns the string representation
func (s PutBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketLoggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.BucketLoggingStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketLoggingStatus"))
	}
	if s.BucketLoggingStatus != nil {
		if err := s.BucketLoggingStatus.Validate(); err != nil {
			invalidParams.AddNested("BucketLoggingStatus", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketLoggingInput) SetBucket(v string) *PutBucketLoggingInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketLoggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetBucketLoggingStatus sets the BucketLoggingStatus field's value.
func (s *PutBucketLoggingInput) SetBucketLoggingStatus(v *BucketLoggingStatus) *PutBucketLoggingInput {
	s.BucketLoggingStatus = v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *PutBucketLoggingInput) SetExpectedBucketOwner(v string) *PutBucketLoggingInput {
	s.ExpectedBucketOwner = &v
	return s
}

type PutBucketLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLoggingOutput) GoString() string {
	return s.String()
}

type PutBucketProtectionConfigurationInput struct {
	_ struct{} `locationName:"PutBucketProtectionConfigurationRequest" type:"structure" payload:"ProtectionConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// ProtectionConfiguration is a required field
	ProtectionConfiguration *ProtectionConfiguration `locationName:"ProtectionConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketProtectionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketProtectionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketProtectionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketProtectionConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.ProtectionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtectionConfiguration"))
	}
	if s.ProtectionConfiguration != nil {
		if err := s.ProtectionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProtectionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketProtectionConfigurationInput) SetBucket(v string) *PutBucketProtectionConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketProtectionConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetProtectionConfiguration sets the ProtectionConfiguration field's value.
func (s *PutBucketProtectionConfigurationInput) SetProtectionConfiguration(v *ProtectionConfiguration) *PutBucketProtectionConfigurationInput {
	s.ProtectionConfiguration = v
	return s
}

type PutBucketProtectionConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketProtectionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketProtectionConfigurationOutput) GoString() string {
	return s.String()
}

type PutBucketVersioningInput struct {
	_ struct{} `locationName:"PutBucketVersioningRequest" type:"structure" payload:"VersioningConfiguration"`

	// The bucket name.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Container for setting the versioning state.
	//
	// VersioningConfiguration is a required field
	VersioningConfiguration *VersioningConfiguration `locationName:"VersioningConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketVersioningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketVersioningInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketVersioningInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.VersioningConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("VersioningConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketVersioningInput) SetBucket(v string) *PutBucketVersioningInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketVersioningInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *PutBucketVersioningInput) SetExpectedBucketOwner(v string) *PutBucketVersioningInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetMFA sets the MFA field's value.
func (s *PutBucketVersioningInput) SetMFA(v string) *PutBucketVersioningInput {
	s.MFA = &v
	return s
}

// SetVersioningConfiguration sets the VersioningConfiguration field's value.
func (s *PutBucketVersioningInput) SetVersioningConfiguration(v *VersioningConfiguration) *PutBucketVersioningInput {
	s.VersioningConfiguration = v
	return s
}

type PutBucketVersioningOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketVersioningOutput) GoString() string {
	return s.String()
}

type PutBucketWebsiteInput struct {
	_ struct{} `locationName:"PutBucketWebsiteRequest" type:"structure" payload:"WebsiteConfiguration"`

	// The bucket name.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Container for the request.
	//
	// WebsiteConfiguration is a required field
	WebsiteConfiguration *WebsiteConfiguration `locationName:"WebsiteConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketWebsiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketWebsiteInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.WebsiteConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("WebsiteConfiguration"))
	}
	if s.WebsiteConfiguration != nil {
		if err := s.WebsiteConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WebsiteConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketWebsiteInput) SetBucket(v string) *PutBucketWebsiteInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *PutBucketWebsiteInput) SetExpectedBucketOwner(v string) *PutBucketWebsiteInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetWebsiteConfiguration sets the WebsiteConfiguration field's value.
func (s *PutBucketWebsiteInput) SetWebsiteConfiguration(v *WebsiteConfiguration) *PutBucketWebsiteInput {
	s.WebsiteConfiguration = v
	return s
}

type PutBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketWebsiteOutput) GoString() string {
	return s.String()
}

type PutObjectAclInput struct {
	_ struct{} `locationName:"PutObjectAclRequest" type:"structure" payload:"AccessControlPolicy"`

	// The canned ACL to apply to the object. For more information, see Canned ACL
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// Contains the elements that set the ACL permissions for an object per grantee.
	AccessControlPolicy *AccessControlPolicy `locationName:"AccessControlPolicy" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The bucket name that contains the object to which you want to attach the
	// ACL.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Key for which the PUT action was initiated.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PutObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutObjectAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *PutObjectAclInput) SetACL(v string) *PutObjectAclInput {
	s.ACL = &v
	return s
}

// SetAccessControlPolicy sets the AccessControlPolicy field's value.
func (s *PutObjectAclInput) SetAccessControlPolicy(v *AccessControlPolicy) *PutObjectAclInput {
	s.AccessControlPolicy = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutObjectAclInput) SetBucket(v string) *PutObjectAclInput {
	s.Bucket = &v
	return s
}

func (s *PutObjectAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *PutObjectAclInput) SetExpectedBucketOwner(v string) *PutObjectAclInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *PutObjectAclInput) SetGrantFullControl(v string) *PutObjectAclInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *PutObjectAclInput) SetGrantRead(v string) *PutObjectAclInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *PutObjectAclInput) SetGrantReadACP(v string) *PutObjectAclInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *PutObjectAclInput) SetGrantWrite(v string) *PutObjectAclInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *PutObjectAclInput) SetGrantWriteACP(v string) *PutObjectAclInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *PutObjectAclInput) SetKey(v string) *PutObjectAclInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *PutObjectAclInput) SetRequestPayer(v string) *PutObjectAclInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PutObjectAclInput) SetVersionId(v string) *PutObjectAclInput {
	s.VersionId = &v
	return s
}

type PutObjectAclOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s PutObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectAclOutput) GoString() string {
	return s.String()
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *PutObjectAclOutput) SetRequestCharged(v string) *PutObjectAclOutput {
	s.RequestCharged = &v
	return s
}

type PutObjectInput struct {
	_ struct{} `locationName:"PutObjectRequest" type:"structure" payload:"Body"`

	// The canned ACL to apply to the object. For more information, see Canned ACL
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL).
	//
	// This action is not supported by Amazon S3 on Outposts.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// Object data.
	Body io.ReadSeeker `type:"blob"`

	// The bucket name to which the PUT action was initiated.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Can be used to specify caching behavior along the request/reply chain. For
	// more information, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9
	// (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9).
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object. For more information,
	// see http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1 (http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1).
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field. For more information, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11
	// (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11).
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes. This parameter is useful when the size of the
	// body cannot be determined automatically. For more information, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13
	// (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13).
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// The base64-encoded 128-bit MD5 digest of the message (without the headers)
	// according to RFC 1864. This header can be used as a message integrity check
	// to verify that the data is the same data that was originally sent. Although
	// it is optional, we recommend using the Content-MD5 mechanism as an end-to-end
	// integrity check. For more information about REST request authentication,
	// see REST Authentication (https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html).
	ContentMD5 *string `location:"header" locationName:"Content-MD5" type:"string"`

	// A standard MIME type describing the format of the contents. For more information,
	// see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17 (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The date and time at which the object is no longer cacheable. For more information,
	// see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21 (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21).
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	//
	// This action is not supported by Amazon S3 on Outposts.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Object key for which the PUT action was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Date on which it will be legal to delete or modify the object. This field
	// can only be specified if Retention-Directive is REPLACE. You can only specify
	// this or the Retention-Period header. If both are specified a 400 error will
	// be returned. If neither is specified the bucket's DefaultRetention period
	// will be used.
	RetentionExpirationDate *time.Time `location:"header" locationName:"Retention-Expiration-Date" type:"timestamp"`

	// A single legal hold to apply to the object. This field can only be specified
	// if Retention-Directive is REPLACE. A legal hold is a character long string
	// of max length 64. The object cannot be overwritten or deleted until all legal
	// holds associated with the object are removed.
	RetentionLegalHoldId *string `location:"header" locationName:"Retention-Legal-Hold-ID" type:"string"`

	// Retention period to store on the object in seconds. If this field and Retention-Expiration-Date
	// are specified a 400 error is returned. If neither is specified the bucket's
	// DefaultRetention period will be used. 0 is a legal value assuming the bucket's
	// minimum retention period is also 0.
	RetentionPeriod *int64 `location:"header" locationName:"Retention-Period" type:"integer"`

	// Specifies the algorithm to use to when encrypting the object (for example,
	// AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// S3 does not store the encryption key. The key must be appropriate for use
	// with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If x-amz-server-side-encryption is present and has the value of aws:kms,
	// this header specifies the ID of the AWS Key Management Service (AWS KMS)
	// symmetrical customer managed customer master key (CMK) that was used for
	// the object.
	//
	// If the value of x-amz-server-side-encryption is aws:kms, this header specifies
	// the ID of the symmetric customer managed AWS KMS CMK that will be used for
	// the object. If you specify x-amz-server-side-encryption:aws:kms, but do not
	// providex-amz-server-side-encryption-aws-kms-key-id, Amazon S3 uses the AWS
	// managed CMK in AWS to protect the data.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// By default, Amazon S3 uses the STANDARD Storage Class to store newly created
	// objects. The STANDARD storage class provides high durability and high availability.
	// Depending on performance needs, you can specify a different Storage Class.
	// Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information,
	// see Storage Classes (https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html)
	// in the Amazon S3 Service Developer Guide.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// The tag-set for the object. The tag-set must be encoded as URL Query parameters.
	// (For example, "Key1=Value1")
	Tagging *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata. For information about object
	// metadata, see Object Key and Metadata (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html).
	//
	// In the following example, the request header sets the redirect to an object
	// (anotherPage.html) in the same bucket:
	//
	// x-amz-website-redirect-location: /anotherPage.html
	//
	// In the following example, the request header sets the object redirect to
	// another website:
	//
	// x-amz-website-redirect-location: http://www.example.com/
	//
	// For more information about website hosting in Amazon S3, see Hosting Websites
	// on Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)
	// and How to Configure Website Page Redirects (https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html).
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s PutObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *PutObjectInput) SetACL(v string) *PutObjectInput {
	s.ACL = &v
	return s
}

// SetBody sets the Body field's value.
func (s *PutObjectInput) SetBody(v io.ReadSeeker) *PutObjectInput {
	s.Body = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutObjectInput) SetBucket(v string) *PutObjectInput {
	s.Bucket = &v
	return s
}

func (s *PutObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCacheControl sets the CacheControl field's value.
func (s *PutObjectInput) SetCacheControl(v string) *PutObjectInput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *PutObjectInput) SetContentDisposition(v string) *PutObjectInput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *PutObjectInput) SetContentEncoding(v string) *PutObjectInput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *PutObjectInput) SetContentLanguage(v string) *PutObjectInput {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *PutObjectInput) SetContentLength(v int64) *PutObjectInput {
	s.ContentLength = &v
	return s
}

// SetContentMD5 sets the ContentMD5 field's value.
func (s *PutObjectInput) SetContentMD5(v string) *PutObjectInput {
	s.ContentMD5 = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *PutObjectInput) SetContentType(v string) *PutObjectInput {
	s.ContentType = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *PutObjectInput) SetExpires(v time.Time) *PutObjectInput {
	s.Expires = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *PutObjectInput) SetGrantFullControl(v string) *PutObjectInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *PutObjectInput) SetGrantRead(v string) *PutObjectInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *PutObjectInput) SetGrantReadACP(v string) *PutObjectInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *PutObjectInput) SetGrantWriteACP(v string) *PutObjectInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *PutObjectInput) SetKey(v string) *PutObjectInput {
	s.Key = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *PutObjectInput) SetMetadata(v map[string]*string) *PutObjectInput {
	s.Metadata = v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *PutObjectInput) SetRequestPayer(v string) *PutObjectInput {
	s.RequestPayer = &v
	return s
}

// SetRetentionExpirationDate sets the RetentionExpirationDate field's value.
func (s *PutObjectInput) SetRetentionExpirationDate(v time.Time) *PutObjectInput {
	s.RetentionExpirationDate = &v
	return s
}

// SetRetentionLegalHoldId sets the RetentionLegalHoldId field's value.
func (s *PutObjectInput) SetRetentionLegalHoldId(v string) *PutObjectInput {
	s.RetentionLegalHoldId = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *PutObjectInput) SetRetentionPeriod(v int64) *PutObjectInput {
	s.RetentionPeriod = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *PutObjectInput) SetSSECustomerAlgorithm(v string) *PutObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *PutObjectInput) SetSSECustomerKey(v string) *PutObjectInput {
	s.SSECustomerKey = &v
	return s
}

func (s *PutObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *PutObjectInput) SetSSECustomerKeyMD5(v string) *PutObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *PutObjectInput) SetSSEKMSKeyId(v string) *PutObjectInput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *PutObjectInput) SetServerSideEncryption(v string) *PutObjectInput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *PutObjectInput) SetStorageClass(v string) *PutObjectInput {
	s.StorageClass = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *PutObjectInput) SetTagging(v string) *PutObjectInput {
	s.Tagging = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *PutObjectInput) SetWebsiteRedirectLocation(v string) *PutObjectInput {
	s.WebsiteRedirectLocation = &v
	return s
}

type PutObjectOutput struct {
	_ struct{} `type:"structure"`

	// Entity tag for the uploaded object.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the expiration is configured for the object (see PutBucketLifecycleConfiguration
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html)),
	// the response includes this header. It includes the expiry-date and rule-id
	// key-value pairs that provide information about object expiration. The value
	// of the rule-id is URL encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round-trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If x-amz-server-side-encryption is present and has the value of aws:kms,
	// this header specifies the ID of the AWS Key Management Service (AWS KMS)
	// symmetric customer managed customer master key (CMK) that was used for the
	// object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// If you specified server-side encryption either with an AWS KMS customer master
	// key (CMK) or Amazon S3-managed encryption key in your PUT request, the response
	// includes this header. It confirms the encryption algorithm that Amazon S3
	// used to encrypt the object.
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s PutObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *PutObjectOutput) SetETag(v string) *PutObjectOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *PutObjectOutput) SetExpiration(v string) *PutObjectOutput {
	s.Expiration = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *PutObjectOutput) SetRequestCharged(v string) *PutObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *PutObjectOutput) SetSSECustomerAlgorithm(v string) *PutObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *PutObjectOutput) SetSSECustomerKeyMD5(v string) *PutObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *PutObjectOutput) SetSSEKMSKeyId(v string) *PutObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *PutObjectOutput) SetServerSideEncryption(v string) *PutObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PutObjectOutput) SetVersionId(v string) *PutObjectOutput {
	s.VersionId = &v
	return s
}

type PutObjectTaggingInput struct {
	_ struct{} `locationName:"PutObjectTaggingRequest" type:"structure" payload:"Tagging"`

	// The bucket name containing the object.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Name of the object key.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Container for the TagSet and Tag elements
	//
	// Tagging is a required field
	Tagging *Tagging `locationName:"Tagging" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The versionId of the object that the tag-set will be added to.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PutObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutObjectTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Tagging == nil {
		invalidParams.Add(request.NewErrParamRequired("Tagging"))
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutObjectTaggingInput) SetBucket(v string) *PutObjectTaggingInput {
	s.Bucket = &v
	return s
}

func (s *PutObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *PutObjectTaggingInput) SetExpectedBucketOwner(v string) *PutObjectTaggingInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *PutObjectTaggingInput) SetKey(v string) *PutObjectTaggingInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *PutObjectTaggingInput) SetRequestPayer(v string) *PutObjectTaggingInput {
	s.RequestPayer = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *PutObjectTaggingInput) SetTagging(v *Tagging) *PutObjectTaggingInput {
	s.Tagging = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PutObjectTaggingInput) SetVersionId(v string) *PutObjectTaggingInput {
	s.VersionId = &v
	return s
}

type PutObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	// The versionId of the object the tag-set was added to.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s PutObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectTaggingOutput) GoString() string {
	return s.String()
}

// SetVersionId sets the VersionId field's value.
func (s *PutObjectTaggingOutput) SetVersionId(v string) *PutObjectTaggingOutput {
	s.VersionId = &v
	return s
}

type PutPublicAccessBlockInput struct {
	_ struct{} `locationName:"PutPublicAccessBlockRequest" type:"structure" payload:"PublicAccessBlockConfiguration"`

	// The name of the Amazon S3 bucket whose PublicAccessBlock configuration you
	// want to set.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The PublicAccessBlock configuration that you want to apply to this Amazon
	// S3 bucket. You can enable the configuration options in any combination. For
	// more information about when Amazon S3 considers a bucket or object public,
	// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
	// in the Amazon S3 User Guide.
	//
	// PublicAccessBlockConfiguration is a required field
	PublicAccessBlockConfiguration *PublicAccessBlockConfiguration `locationName:"PublicAccessBlockConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutPublicAccessBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPublicAccessBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPublicAccessBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPublicAccessBlockInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.PublicAccessBlockConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicAccessBlockConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutPublicAccessBlockInput) SetBucket(v string) *PutPublicAccessBlockInput {
	s.Bucket = &v
	return s
}

func (s *PutPublicAccessBlockInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *PutPublicAccessBlockInput) SetExpectedBucketOwner(v string) *PutPublicAccessBlockInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetPublicAccessBlockConfiguration sets the PublicAccessBlockConfiguration field's value.
func (s *PutPublicAccessBlockInput) SetPublicAccessBlockConfiguration(v *PublicAccessBlockConfiguration) *PutPublicAccessBlockInput {
	s.PublicAccessBlockConfiguration = v
	return s
}

type PutPublicAccessBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutPublicAccessBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPublicAccessBlockOutput) GoString() string {
	return s.String()
}

// Specifies how requests are redirected. In the event of an error, you can
// specify a different error code to return.
type Redirect struct {
	_ struct{} `type:"structure"`

	// The host name to use in the redirect request.
	HostName *string `type:"string"`

	// The HTTP redirect code to use on the response. Not required if one of the
	// siblings is present.
	HttpRedirectCode *string `type:"string"`

	// Protocol to use when redirecting requests. The default is the protocol that
	// is used in the original request.
	Protocol *string `type:"string" enum:"Protocol"`

	// The object key prefix to use in the redirect request. For example, to redirect
	// requests for all pages with prefix docs/ (objects in the docs/ folder) to
	// documents/, you can set a condition block with KeyPrefixEquals set to docs/
	// and in the Redirect set ReplaceKeyPrefixWith to /documents. Not required
	// if one of the siblings is present. Can be present only if ReplaceKeyWith
	// is not provided.
	//
	// Replacement must be made for object keys containing special characters (such
	// as carriage returns) when using XML requests. For more information, see XML
	// related object key constraints (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
	ReplaceKeyPrefixWith *string `type:"string"`

	// The specific object key to use in the redirect request. For example, redirect
	// request to error.html. Not required if one of the siblings is present. Can
	// be present only if ReplaceKeyPrefixWith is not provided.
	//
	// Replacement must be made for object keys containing special characters (such
	// as carriage returns) when using XML requests. For more information, see XML
	// related object key constraints (https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
	ReplaceKeyWith *string `type:"string"`
}

// String returns the string representation
func (s Redirect) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Redirect) GoString() string {
	return s.String()
}

// SetHostName sets the HostName field's value.
func (s *Redirect) SetHostName(v string) *Redirect {
	s.HostName = &v
	return s
}

// SetHttpRedirectCode sets the HttpRedirectCode field's value.
func (s *Redirect) SetHttpRedirectCode(v string) *Redirect {
	s.HttpRedirectCode = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Redirect) SetProtocol(v string) *Redirect {
	s.Protocol = &v
	return s
}

// SetReplaceKeyPrefixWith sets the ReplaceKeyPrefixWith field's value.
func (s *Redirect) SetReplaceKeyPrefixWith(v string) *Redirect {
	s.ReplaceKeyPrefixWith = &v
	return s
}

// SetReplaceKeyWith sets the ReplaceKeyWith field's value.
func (s *Redirect) SetReplaceKeyWith(v string) *Redirect {
	s.ReplaceKeyWith = &v
	return s
}

// Specifies the redirect behavior of all requests to a website endpoint of
// an Amazon S3 bucket.
type RedirectAllRequestsTo struct {
	_ struct{} `type:"structure"`

	// Name of the host where requests are redirected.
	//
	// HostName is a required field
	HostName *string `type:"string" required:"true"`

	// Protocol to use when redirecting requests. The default is the protocol that
	// is used in the original request.
	Protocol *string `type:"string" enum:"Protocol"`
}

// String returns the string representation
func (s RedirectAllRequestsTo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectAllRequestsTo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedirectAllRequestsTo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedirectAllRequestsTo"}
	if s.HostName == nil {
		invalidParams.Add(request.NewErrParamRequired("HostName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostName sets the HostName field's value.
func (s *RedirectAllRequestsTo) SetHostName(v string) *RedirectAllRequestsTo {
	s.HostName = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *RedirectAllRequestsTo) SetProtocol(v string) *RedirectAllRequestsTo {
	s.Protocol = &v
	return s
}

type RestoreObjectInput struct {
	_ struct{} `locationName:"RestoreObjectRequest" type:"structure" payload:"RestoreRequest"`

	// The bucket name containing the object to restore.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Object key for which the action was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Container for restore job parameters.
	RestoreRequest *RestoreRequest `locationName:"RestoreRequest" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s RestoreObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.RestoreRequest != nil {
		if err := s.RestoreRequest.Validate(); err != nil {
			invalidParams.AddNested("RestoreRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *RestoreObjectInput) SetBucket(v string) *RestoreObjectInput {
	s.Bucket = &v
	return s
}

func (s *RestoreObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *RestoreObjectInput) SetExpectedBucketOwner(v string) *RestoreObjectInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *RestoreObjectInput) SetKey(v string) *RestoreObjectInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *RestoreObjectInput) SetRequestPayer(v string) *RestoreObjectInput {
	s.RequestPayer = &v
	return s
}

// SetRestoreRequest sets the RestoreRequest field's value.
func (s *RestoreObjectInput) SetRestoreRequest(v *RestoreRequest) *RestoreObjectInput {
	s.RestoreRequest = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *RestoreObjectInput) SetVersionId(v string) *RestoreObjectInput {
	s.VersionId = &v
	return s
}

type RestoreObjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestoreObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreObjectOutput) GoString() string {
	return s.String()
}

// Container for restore job parameters.
type RestoreRequest struct {
	_ struct{} `type:"structure"`

	// Lifetime of the active copy in days. Do not use with restores that specify
	// OutputLocation.
	//
	// The Days element is required for regular restores, and must not be provided
	// for select requests.
	//
	// Days is a required field
	Days *int64 `type:"integer" required:"true"`

	// S3 Glacier related parameters pertaining to this job. Do not use with restores
	// that specify OutputLocation.
	GlacierJobParameters *GlacierJobParameters `type:"structure"`
}

// String returns the string representation
func (s RestoreRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreRequest"}
	if s.Days == nil {
		invalidParams.Add(request.NewErrParamRequired("Days"))
	}
	if s.GlacierJobParameters != nil {
		if err := s.GlacierJobParameters.Validate(); err != nil {
			invalidParams.AddNested("GlacierJobParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDays sets the Days field's value.
func (s *RestoreRequest) SetDays(v int64) *RestoreRequest {
	s.Days = &v
	return s
}

// SetGlacierJobParameters sets the GlacierJobParameters field's value.
func (s *RestoreRequest) SetGlacierJobParameters(v *GlacierJobParameters) *RestoreRequest {
	s.GlacierJobParameters = v
	return s
}

// Specifies the redirect behavior and when a redirect is applied. For more
// information about routing rules, see Configuring advanced conditional redirects
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/how-to-page-redirect.html#advanced-conditional-redirects)
// in the Amazon S3 User Guide.
type RoutingRule struct {
	_ struct{} `type:"structure"`

	// A container for describing a condition that must be met for the specified
	// redirect to apply. For example, 1. If request is for pages in the /docs folder,
	// redirect to the /documents folder. 2. If request results in HTTP error 4xx,
	// redirect request to another host where you might process the error.
	Condition *Condition `type:"structure"`

	// Container for redirect information. You can redirect requests to another
	// host, to another page, or with another protocol. In the event of an error,
	// you can specify a different error code to return.
	//
	// Redirect is a required field
	Redirect *Redirect `type:"structure" required:"true"`
}

// String returns the string representation
func (s RoutingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoutingRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoutingRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RoutingRule"}
	if s.Redirect == nil {
		invalidParams.Add(request.NewErrParamRequired("Redirect"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *RoutingRule) SetCondition(v *Condition) *RoutingRule {
	s.Condition = v
	return s
}

// SetRedirect sets the Redirect field's value.
func (s *RoutingRule) SetRedirect(v *Redirect) *RoutingRule {
	s.Redirect = v
	return s
}

// A container of a key value name pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// Name of the object key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Container for TagSet elements.
type Tagging struct {
	_ struct{} `type:"structure"`

	// A collection for a set of tags
	//
	// TagSet is a required field
	TagSet []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s Tagging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tagging) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tagging) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tagging"}
	if s.TagSet == nil {
		invalidParams.Add(request.NewErrParamRequired("TagSet"))
	}
	if s.TagSet != nil {
		for i, v := range s.TagSet {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagSet", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagSet sets the TagSet field's value.
func (s *Tagging) SetTagSet(v []*Tag) *Tagging {
	s.TagSet = v
	return s
}

// Container for granting information.
type TargetGrant struct {
	_ struct{} `type:"structure"`

	// Container for the person being granted permissions.
	Grantee *Grantee `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Logging permissions assigned to the grantee for the bucket.
	Permission *string `type:"string" enum:"BucketLogsPermission"`
}

// String returns the string representation
func (s TargetGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetGrant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetGrant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetGrant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantee sets the Grantee field's value.
func (s *TargetGrant) SetGrantee(v *Grantee) *TargetGrant {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *TargetGrant) SetPermission(v string) *TargetGrant {
	s.Permission = &v
	return s
}

// Specifies when an object transitions to a specified storage class. For more
// information about Amazon S3 lifecycle configuration rules, see Transitioning
// Objects Using Amazon S3 Lifecycle (https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html)
// in the Amazon S3 User Guide.
type Transition struct {
	_ struct{} `type:"structure"`

	// Indicates when objects are transitioned to the specified storage class. The
	// date value must be in ISO 8601 format. The time is always midnight UTC.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the number of days after creation when objects are transitioned
	// to the specified storage class. The value must be a positive integer.
	Days *int64 `type:"integer"`

	// The storage class to which you want the object to transition.
	StorageClass *string `type:"string" enum:"TransitionStorageClass"`
}

// String returns the string representation
func (s Transition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Transition) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Transition) SetDate(v time.Time) *Transition {
	s.Date = &v
	return s
}

// SetDays sets the Days field's value.
func (s *Transition) SetDays(v int64) *Transition {
	s.Days = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Transition) SetStorageClass(v string) *Transition {
	s.StorageClass = &v
	return s
}

type UploadPartCopyInput struct {
	_ struct{} `locationName:"UploadPartCopyRequest" type:"structure"`

	// The bucket name.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies the source object for the copy operation. You specify the value
	// in one of two formats, depending on whether you want to access the source
	// object through an access point (https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html):
	//
	//    * For objects not accessed through an access point, specify the name of
	//    the source bucket and key of the source object, separated by a slash (/).
	//    For example, to copy the object reports/january.pdf from the bucket awsexamplebucket,
	//    use awsexamplebucket/reports/january.pdf. The value must be URL encoded.
	//
	//    * For objects accessed through access points, specify the Amazon Resource
	//    Name (ARN) of the object as accessed through the access point, in the
	//    format arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>.
	//    For example, to copy the object reports/january.pdf through access point
	//    my-access-point owned by account 123456789012 in Region us-west-2, use
	//    the URL encoding of arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf.
	//    The value must be URL encoded. Amazon S3 supports copy operations using
	//    access points only when the source and destination buckets are in the
	//    same AWS Region. Alternatively, for objects accessed through Amazon S3
	//    on Outposts, specify the ARN of the object as accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>.
	//    For example, to copy the object reports/january.pdf through outpost my-outpost
	//    owned by account 123456789012 in Region us-west-2, use the URL encoding
	//    of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf.
	//    The value must be URL encoded.
	//
	// To copy a specific version of an object, append ?versionId=<version-id> to
	// the value (for example, awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893).
	// If you don't specify a version ID, Amazon S3 copies the latest version of
	// the source object.
	//
	// CopySource is a required field
	CopySource *string `location:"header" locationName:"x-amz-copy-source" type:"string" required:"true"`

	// Copies the object if its entity tag (ETag) matches the specified tag.
	CopySourceIfMatch *string `location:"header" locationName:"x-amz-copy-source-if-match" type:"string"`

	// Copies the object if it has been modified since the specified time.
	CopySourceIfModifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-modified-since" type:"timestamp"`

	// Copies the object if its entity tag (ETag) is different than the specified
	// ETag.
	CopySourceIfNoneMatch *string `location:"header" locationName:"x-amz-copy-source-if-none-match" type:"string"`

	// Copies the object if it hasn't been modified since the specified time.
	CopySourceIfUnmodifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-unmodified-since" type:"timestamp"`

	// The range of bytes to copy from the source object. The range value must use
	// the form bytes=first-last, where the first and last are the zero-based byte
	// offsets to copy. For example, bytes=0-9 indicates that you want to copy the
	// first 10 bytes of the source. You can copy a range only if the source object
	// is greater than 5 MB.
	CopySourceRange *string `location:"header" locationName:"x-amz-copy-source-range" type:"string"`

	// Specifies the algorithm to use when decrypting the source object (for example,
	// AES256).
	CopySourceSSECustomerAlgorithm *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use to decrypt
	// the source object. The encryption key provided in this header must be one
	// that was used when the source object was created.
	CopySourceSSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	CopySourceSSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key-MD5" type:"string"`

	// The account ID of the expected destination bucket owner. If the destination
	// bucket is owned by a different account, the request will fail with an HTTP
	// 403 (Access Denied) error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// The account ID of the expected source bucket owner. If the source bucket
	// is owned by a different account, the request will fail with an HTTP 403 (Access
	// Denied) error.
	ExpectedSourceBucketOwner *string `location:"header" locationName:"x-amz-source-expected-bucket-owner" type:"string"`

	// Object key for which the multipart upload was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of part being copied. This is a positive integer between 1 and
	// 10,000.
	//
	// PartNumber is a required field
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (for example,
	// AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// S3 does not store the encryption key. The key must be appropriate for use
	// with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header. This must be the same encryption key specified in the initiate multipart
	// upload request.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Upload ID identifying the multipart upload whose part is being copied.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadPartCopyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartCopyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadPartCopyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadPartCopyInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.CopySource == nil {
		invalidParams.Add(request.NewErrParamRequired("CopySource"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.PartNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PartNumber"))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *UploadPartCopyInput) SetBucket(v string) *UploadPartCopyInput {
	s.Bucket = &v
	return s
}

func (s *UploadPartCopyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCopySource sets the CopySource field's value.
func (s *UploadPartCopyInput) SetCopySource(v string) *UploadPartCopyInput {
	s.CopySource = &v
	return s
}

// SetCopySourceIfMatch sets the CopySourceIfMatch field's value.
func (s *UploadPartCopyInput) SetCopySourceIfMatch(v string) *UploadPartCopyInput {
	s.CopySourceIfMatch = &v
	return s
}

// SetCopySourceIfModifiedSince sets the CopySourceIfModifiedSince field's value.
func (s *UploadPartCopyInput) SetCopySourceIfModifiedSince(v time.Time) *UploadPartCopyInput {
	s.CopySourceIfModifiedSince = &v
	return s
}

// SetCopySourceIfNoneMatch sets the CopySourceIfNoneMatch field's value.
func (s *UploadPartCopyInput) SetCopySourceIfNoneMatch(v string) *UploadPartCopyInput {
	s.CopySourceIfNoneMatch = &v
	return s
}

// SetCopySourceIfUnmodifiedSince sets the CopySourceIfUnmodifiedSince field's value.
func (s *UploadPartCopyInput) SetCopySourceIfUnmodifiedSince(v time.Time) *UploadPartCopyInput {
	s.CopySourceIfUnmodifiedSince = &v
	return s
}

// SetCopySourceRange sets the CopySourceRange field's value.
func (s *UploadPartCopyInput) SetCopySourceRange(v string) *UploadPartCopyInput {
	s.CopySourceRange = &v
	return s
}

// SetCopySourceSSECustomerAlgorithm sets the CopySourceSSECustomerAlgorithm field's value.
func (s *UploadPartCopyInput) SetCopySourceSSECustomerAlgorithm(v string) *UploadPartCopyInput {
	s.CopySourceSSECustomerAlgorithm = &v
	return s
}

// SetCopySourceSSECustomerKey sets the CopySourceSSECustomerKey field's value.
func (s *UploadPartCopyInput) SetCopySourceSSECustomerKey(v string) *UploadPartCopyInput {
	s.CopySourceSSECustomerKey = &v
	return s
}

func (s *UploadPartCopyInput) getCopySourceSSECustomerKey() (v string) {
	if s.CopySourceSSECustomerKey == nil {
		return v
	}
	return *s.CopySourceSSECustomerKey
}

// SetCopySourceSSECustomerKeyMD5 sets the CopySourceSSECustomerKeyMD5 field's value.
func (s *UploadPartCopyInput) SetCopySourceSSECustomerKeyMD5(v string) *UploadPartCopyInput {
	s.CopySourceSSECustomerKeyMD5 = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *UploadPartCopyInput) SetExpectedBucketOwner(v string) *UploadPartCopyInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetExpectedSourceBucketOwner sets the ExpectedSourceBucketOwner field's value.
func (s *UploadPartCopyInput) SetExpectedSourceBucketOwner(v string) *UploadPartCopyInput {
	s.ExpectedSourceBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *UploadPartCopyInput) SetKey(v string) *UploadPartCopyInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *UploadPartCopyInput) SetPartNumber(v int64) *UploadPartCopyInput {
	s.PartNumber = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *UploadPartCopyInput) SetRequestPayer(v string) *UploadPartCopyInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartCopyInput) SetSSECustomerAlgorithm(v string) *UploadPartCopyInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *UploadPartCopyInput) SetSSECustomerKey(v string) *UploadPartCopyInput {
	s.SSECustomerKey = &v
	return s
}

func (s *UploadPartCopyInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartCopyInput) SetSSECustomerKeyMD5(v string) *UploadPartCopyInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadPartCopyInput) SetUploadId(v string) *UploadPartCopyInput {
	s.UploadId = &v
	return s
}

type UploadPartCopyOutput struct {
	_ struct{} `type:"structure" payload:"CopyPartResult"`

	// Container for all response elements.
	CopyPartResult *CopyPartResult `type:"structure"`

	// The version of the source object that was copied, if you have enabled versioning
	// on the source bucket.
	CopySourceVersionId *string `location:"header" locationName:"x-amz-copy-source-version-id" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round-trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (AWS KMS)
	// symmetric customer managed customer master key (CMK) that was used for the
	// object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`
}

// String returns the string representation
func (s UploadPartCopyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartCopyOutput) GoString() string {
	return s.String()
}

// SetCopyPartResult sets the CopyPartResult field's value.
func (s *UploadPartCopyOutput) SetCopyPartResult(v *CopyPartResult) *UploadPartCopyOutput {
	s.CopyPartResult = v
	return s
}

// SetCopySourceVersionId sets the CopySourceVersionId field's value.
func (s *UploadPartCopyOutput) SetCopySourceVersionId(v string) *UploadPartCopyOutput {
	s.CopySourceVersionId = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *UploadPartCopyOutput) SetRequestCharged(v string) *UploadPartCopyOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartCopyOutput) SetSSECustomerAlgorithm(v string) *UploadPartCopyOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartCopyOutput) SetSSECustomerKeyMD5(v string) *UploadPartCopyOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *UploadPartCopyOutput) SetSSEKMSKeyId(v string) *UploadPartCopyOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *UploadPartCopyOutput) SetServerSideEncryption(v string) *UploadPartCopyOutput {
	s.ServerSideEncryption = &v
	return s
}

type UploadPartInput struct {
	_ struct{} `locationName:"UploadPartRequest" type:"structure" payload:"Body"`

	// Object data.
	Body io.ReadSeeker `type:"blob"`

	// The name of the bucket to which the multipart upload was initiated.
	//
	// When using this action with an access point, you must direct requests to
	// the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com.
	// When using this action with an access point through the AWS SDKs, you provide
	// the access point ARN in place of the bucket name. For more information about
	// access point ARNs, see Using Access Points (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
	// in the Amazon S3 User Guide.
	//
	// When using this action with Amazon S3 on Outposts, you must direct requests
	// to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form
	// AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When
	// using this action using S3 on Outposts through the AWS SDKs, you provide
	// the Outposts bucket ARN in place of the bucket name. For more information
	// about S3 on Outposts ARNs, see Using S3 on Outposts (https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
	// in the Amazon S3 User Guide.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Size of the body in bytes. This parameter is useful when the size of the
	// body cannot be determined automatically.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// The base64-encoded 128-bit MD5 digest of the part data. This parameter is
	// auto-populated when using the command from the CLI. This parameter is required
	// if object lock parameters are specified.
	ContentMD5 *string `location:"header" locationName:"Content-MD5" type:"string"`

	// The account ID of the expected bucket owner. If the bucket is owned by a
	// different account, the request will fail with an HTTP 403 (Access Denied)
	// error.
	ExpectedBucketOwner *string `location:"header" locationName:"x-amz-expected-bucket-owner" type:"string"`

	// Object key for which the multipart upload was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of part being uploaded. This is a positive integer between 1
	// and 10,000.
	//
	// PartNumber is a required field
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer" required:"true"`

	// Confirms that the requester knows that they will be charged for the request.
	// Bucket owners need not specify this parameter in their requests. For information
	// about downloading objects from requester pays buckets, see Downloading Objects
	// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
	// in the Amazon S3 Developer Guide.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (for example,
	// AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// S3 does not store the encryption key. The key must be appropriate for use
	// with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm
	// header. This must be the same encryption key specified in the initiate multipart
	// upload request.
	SSECustomerKey *string `marshal-as:"blob" location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string" sensitive:"true"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure that the
	// encryption key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Upload ID identifying the multipart upload whose part is being uploaded.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadPartInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.PartNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PartNumber"))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *UploadPartInput) SetBody(v io.ReadSeeker) *UploadPartInput {
	s.Body = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *UploadPartInput) SetBucket(v string) *UploadPartInput {
	s.Bucket = &v
	return s
}

func (s *UploadPartInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetContentLength sets the ContentLength field's value.
func (s *UploadPartInput) SetContentLength(v int64) *UploadPartInput {
	s.ContentLength = &v
	return s
}

// SetContentMD5 sets the ContentMD5 field's value.
func (s *UploadPartInput) SetContentMD5(v string) *UploadPartInput {
	s.ContentMD5 = &v
	return s
}

// SetExpectedBucketOwner sets the ExpectedBucketOwner field's value.
func (s *UploadPartInput) SetExpectedBucketOwner(v string) *UploadPartInput {
	s.ExpectedBucketOwner = &v
	return s
}

// SetKey sets the Key field's value.
func (s *UploadPartInput) SetKey(v string) *UploadPartInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *UploadPartInput) SetPartNumber(v int64) *UploadPartInput {
	s.PartNumber = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *UploadPartInput) SetRequestPayer(v string) *UploadPartInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartInput) SetSSECustomerAlgorithm(v string) *UploadPartInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *UploadPartInput) SetSSECustomerKey(v string) *UploadPartInput {
	s.SSECustomerKey = &v
	return s
}

func (s *UploadPartInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartInput) SetSSECustomerKeyMD5(v string) *UploadPartInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadPartInput) SetUploadId(v string) *UploadPartInput {
	s.UploadId = &v
	return s
}

type UploadPartOutput struct {
	_ struct{} `type:"structure"`

	// Entity tag for the uploaded object.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round-trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (AWS KMS)
	// symmetric customer managed customer master key (CMK) was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string" sensitive:"true"`

	// The server-side encryption algorithm used when storing this object in Amazon
	// S3 (for example, AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`
}

// String returns the string representation
func (s UploadPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UploadPartOutput) SetETag(v string) *UploadPartOutput {
	s.ETag = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *UploadPartOutput) SetRequestCharged(v string) *UploadPartOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartOutput) SetSSECustomerAlgorithm(v string) *UploadPartOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartOutput) SetSSECustomerKeyMD5(v string) *UploadPartOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *UploadPartOutput) SetSSEKMSKeyId(v string) *UploadPartOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *UploadPartOutput) SetServerSideEncryption(v string) *UploadPartOutput {
	s.ServerSideEncryption = &v
	return s
}

// Describes the versioning state of an Amazon S3 bucket. For more information,
// see PUT Bucket versioning (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTVersioningStatus.html)
// in the Amazon Simple Storage Service API Reference.
type VersioningConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete *string `locationName:"MfaDelete" type:"string" enum:"MFADelete"`

	// The versioning state of the bucket.
	Status *string `type:"string" enum:"BucketVersioningStatus"`
}

// String returns the string representation
func (s VersioningConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VersioningConfiguration) GoString() string {
	return s.String()
}

// SetMFADelete sets the MFADelete field's value.
func (s *VersioningConfiguration) SetMFADelete(v string) *VersioningConfiguration {
	s.MFADelete = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VersioningConfiguration) SetStatus(v string) *VersioningConfiguration {
	s.Status = &v
	return s
}

// Specifies website configuration parameters for an Amazon S3 bucket.
type WebsiteConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the error document for the website.
	ErrorDocument *ErrorDocument `type:"structure"`

	// The name of the index document for the website.
	IndexDocument *IndexDocument `type:"structure"`

	// The redirect behavior for every request to this bucket's website endpoint.
	//
	// If you specify this property, you can't specify any other property.
	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	// Rules that define when a redirect is applied and the redirect behavior.
	RoutingRules []*RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s WebsiteConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebsiteConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebsiteConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebsiteConfiguration"}
	if s.ErrorDocument != nil {
		if err := s.ErrorDocument.Validate(); err != nil {
			invalidParams.AddNested("ErrorDocument", err.(request.ErrInvalidParams))
		}
	}
	if s.IndexDocument != nil {
		if err := s.IndexDocument.Validate(); err != nil {
			invalidParams.AddNested("IndexDocument", err.(request.ErrInvalidParams))
		}
	}
	if s.RedirectAllRequestsTo != nil {
		if err := s.RedirectAllRequestsTo.Validate(); err != nil {
			invalidParams.AddNested("RedirectAllRequestsTo", err.(request.ErrInvalidParams))
		}
	}
	if s.RoutingRules != nil {
		for i, v := range s.RoutingRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetErrorDocument sets the ErrorDocument field's value.
func (s *WebsiteConfiguration) SetErrorDocument(v *ErrorDocument) *WebsiteConfiguration {
	s.ErrorDocument = v
	return s
}

// SetIndexDocument sets the IndexDocument field's value.
func (s *WebsiteConfiguration) SetIndexDocument(v *IndexDocument) *WebsiteConfiguration {
	s.IndexDocument = v
	return s
}

// SetRedirectAllRequestsTo sets the RedirectAllRequestsTo field's value.
func (s *WebsiteConfiguration) SetRedirectAllRequestsTo(v *RedirectAllRequestsTo) *WebsiteConfiguration {
	s.RedirectAllRequestsTo = v
	return s
}

// SetRoutingRules sets the RoutingRules field's value.
func (s *WebsiteConfiguration) SetRoutingRules(v []*RoutingRule) *WebsiteConfiguration {
	s.RoutingRules = v
	return s
}

const (
	// BucketCannedACLPrivate is a BucketCannedACL enum value
	BucketCannedACLPrivate = "private"

	// BucketCannedACLPublicRead is a BucketCannedACL enum value
	BucketCannedACLPublicRead = "public-read"

	// BucketCannedACLPublicReadWrite is a BucketCannedACL enum value
	BucketCannedACLPublicReadWrite = "public-read-write"

	// BucketCannedACLAuthenticatedRead is a BucketCannedACL enum value
	BucketCannedACLAuthenticatedRead = "authenticated-read"
)

// BucketCannedACL_Values returns all elements of the BucketCannedACL enum
func BucketCannedACL_Values() []string {
	return []string{
		BucketCannedACLPrivate,
		BucketCannedACLPublicRead,
		BucketCannedACLPublicReadWrite,
		BucketCannedACLAuthenticatedRead,
	}
}

const (
	// BucketLocationConstraintEu is a BucketLocationConstraint enum value
	BucketLocationConstraintEu = "EU"

	// BucketLocationConstraintEuWest1 is a BucketLocationConstraint enum value
	BucketLocationConstraintEuWest1 = "eu-west-1"

	// BucketLocationConstraintUsWest1 is a BucketLocationConstraint enum value
	BucketLocationConstraintUsWest1 = "us-west-1"

	// BucketLocationConstraintUsWest2 is a BucketLocationConstraint enum value
	BucketLocationConstraintUsWest2 = "us-west-2"

	// BucketLocationConstraintApSouth1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSouth1 = "ap-south-1"

	// BucketLocationConstraintApSoutheast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSoutheast1 = "ap-southeast-1"

	// BucketLocationConstraintApSoutheast2 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSoutheast2 = "ap-southeast-2"

	// BucketLocationConstraintApNortheast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApNortheast1 = "ap-northeast-1"

	// BucketLocationConstraintSaEast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintSaEast1 = "sa-east-1"

	// BucketLocationConstraintCnNorth1 is a BucketLocationConstraint enum value
	BucketLocationConstraintCnNorth1 = "cn-north-1"

	// BucketLocationConstraintEuCentral1 is a BucketLocationConstraint enum value
	BucketLocationConstraintEuCentral1 = "eu-central-1"
)

// BucketLocationConstraint_Values returns all elements of the BucketLocationConstraint enum
func BucketLocationConstraint_Values() []string {
	return []string{
		BucketLocationConstraintEu,
		BucketLocationConstraintEuWest1,
		BucketLocationConstraintUsWest1,
		BucketLocationConstraintUsWest2,
		BucketLocationConstraintApSouth1,
		BucketLocationConstraintApSoutheast1,
		BucketLocationConstraintApSoutheast2,
		BucketLocationConstraintApNortheast1,
		BucketLocationConstraintSaEast1,
		BucketLocationConstraintCnNorth1,
		BucketLocationConstraintEuCentral1,
	}
}

const (
	// BucketLogsPermissionFullControl is a BucketLogsPermission enum value
	BucketLogsPermissionFullControl = "FULL_CONTROL"

	// BucketLogsPermissionRead is a BucketLogsPermission enum value
	BucketLogsPermissionRead = "READ"

	// BucketLogsPermissionWrite is a BucketLogsPermission enum value
	BucketLogsPermissionWrite = "WRITE"
)

// BucketLogsPermission_Values returns all elements of the BucketLogsPermission enum
func BucketLogsPermission_Values() []string {
	return []string{
		BucketLogsPermissionFullControl,
		BucketLogsPermissionRead,
		BucketLogsPermissionWrite,
	}
}

const (
	// BucketProtectionStatusRetention is a BucketProtectionStatus enum value
	BucketProtectionStatusRetention = "Retention"
)

// BucketProtectionStatus_Values returns all elements of the BucketProtectionStatus enum
func BucketProtectionStatus_Values() []string {
	return []string{
		BucketProtectionStatusRetention,
	}
}

const (
	// BucketVersioningStatusEnabled is a BucketVersioningStatus enum value
	BucketVersioningStatusEnabled = "Enabled"

	// BucketVersioningStatusSuspended is a BucketVersioningStatus enum value
	BucketVersioningStatusSuspended = "Suspended"
)

// BucketVersioningStatus_Values returns all elements of the BucketVersioningStatus enum
func BucketVersioningStatus_Values() []string {
	return []string{
		BucketVersioningStatusEnabled,
		BucketVersioningStatusSuspended,
	}
}

// Requests Amazon S3 to encode the object keys in the response and specifies
// the encoding method to use. An object key may contain any Unicode character;
// however, XML 1.0 parser cannot parse some characters, such as characters
// with an ASCII value from 0 to 10. For characters that are not supported in
// XML 1.0, you can add this parameter to request that Amazon S3 encode the
// keys in the response.
const (
	// EncodingTypeUrl is a EncodingType enum value
	EncodingTypeUrl = "url"
)

// EncodingType_Values returns all elements of the EncodingType enum
func EncodingType_Values() []string {
	return []string{
		EncodingTypeUrl,
	}
}

const (
	// ExpirationStatusEnabled is a ExpirationStatus enum value
	ExpirationStatusEnabled = "Enabled"

	// ExpirationStatusDisabled is a ExpirationStatus enum value
	ExpirationStatusDisabled = "Disabled"
)

// ExpirationStatus_Values returns all elements of the ExpirationStatus enum
func ExpirationStatus_Values() []string {
	return []string{
		ExpirationStatusEnabled,
		ExpirationStatusDisabled,
	}
}

const (
	// MFADeleteEnabled is a MFADelete enum value
	MFADeleteEnabled = "Enabled"

	// MFADeleteDisabled is a MFADelete enum value
	MFADeleteDisabled = "Disabled"
)

// MFADelete_Values returns all elements of the MFADelete enum
func MFADelete_Values() []string {
	return []string{
		MFADeleteEnabled,
		MFADeleteDisabled,
	}
}

const (
	// MFADeleteStatusEnabled is a MFADeleteStatus enum value
	MFADeleteStatusEnabled = "Enabled"

	// MFADeleteStatusDisabled is a MFADeleteStatus enum value
	MFADeleteStatusDisabled = "Disabled"
)

// MFADeleteStatus_Values returns all elements of the MFADeleteStatus enum
func MFADeleteStatus_Values() []string {
	return []string{
		MFADeleteStatusEnabled,
		MFADeleteStatusDisabled,
	}
}

const (
	// MetadataDirectiveCopy is a MetadataDirective enum value
	MetadataDirectiveCopy = "COPY"

	// MetadataDirectiveReplace is a MetadataDirective enum value
	MetadataDirectiveReplace = "REPLACE"
)

// MetadataDirective_Values returns all elements of the MetadataDirective enum
func MetadataDirective_Values() []string {
	return []string{
		MetadataDirectiveCopy,
		MetadataDirectiveReplace,
	}
}

const (
	// ObjectCannedACLPrivate is a ObjectCannedACL enum value
	ObjectCannedACLPrivate = "private"

	// ObjectCannedACLPublicRead is a ObjectCannedACL enum value
	ObjectCannedACLPublicRead = "public-read"

	// ObjectCannedACLPublicReadWrite is a ObjectCannedACL enum value
	ObjectCannedACLPublicReadWrite = "public-read-write"

	// ObjectCannedACLAuthenticatedRead is a ObjectCannedACL enum value
	ObjectCannedACLAuthenticatedRead = "authenticated-read"

	// ObjectCannedACLAwsExecRead is a ObjectCannedACL enum value
	ObjectCannedACLAwsExecRead = "aws-exec-read"

	// ObjectCannedACLBucketOwnerRead is a ObjectCannedACL enum value
	ObjectCannedACLBucketOwnerRead = "bucket-owner-read"

	// ObjectCannedACLBucketOwnerFullControl is a ObjectCannedACL enum value
	ObjectCannedACLBucketOwnerFullControl = "bucket-owner-full-control"
)

// ObjectCannedACL_Values returns all elements of the ObjectCannedACL enum
func ObjectCannedACL_Values() []string {
	return []string{
		ObjectCannedACLPrivate,
		ObjectCannedACLPublicRead,
		ObjectCannedACLPublicReadWrite,
		ObjectCannedACLAuthenticatedRead,
		ObjectCannedACLAwsExecRead,
		ObjectCannedACLBucketOwnerRead,
		ObjectCannedACLBucketOwnerFullControl,
	}
}

const (
	// ObjectStorageClassStandard is a ObjectStorageClass enum value
	ObjectStorageClassStandard = "STANDARD"

	// ObjectStorageClassReducedRedundancy is a ObjectStorageClass enum value
	ObjectStorageClassReducedRedundancy = "REDUCED_REDUNDANCY"

	// ObjectStorageClassGlacier is a ObjectStorageClass enum value
	ObjectStorageClassGlacier = "GLACIER"

	// ObjectStorageClassAccelerated is a ObjectStorageClass enum value
	ObjectStorageClassAccelerated = "ACCELERATED"

	// ObjectStorageClassStandardIa is a ObjectStorageClass enum value
	ObjectStorageClassStandardIa = "STANDARD_IA"

	// ObjectStorageClassOnezoneIa is a ObjectStorageClass enum value
	ObjectStorageClassOnezoneIa = "ONEZONE_IA"

	// ObjectStorageClassIntelligentTiering is a ObjectStorageClass enum value
	ObjectStorageClassIntelligentTiering = "INTELLIGENT_TIERING"

	// ObjectStorageClassDeepArchive is a ObjectStorageClass enum value
	ObjectStorageClassDeepArchive = "DEEP_ARCHIVE"
)

// ObjectStorageClass_Values returns all elements of the ObjectStorageClass enum
func ObjectStorageClass_Values() []string {
	return []string{
		ObjectStorageClassStandard,
		ObjectStorageClassReducedRedundancy,
		ObjectStorageClassGlacier,
		ObjectStorageClassAccelerated,
		ObjectStorageClassStandardIa,
		ObjectStorageClassOnezoneIa,
		ObjectStorageClassIntelligentTiering,
		ObjectStorageClassDeepArchive,
	}
}

const (
	// ObjectVersionStorageClassStandard is a ObjectVersionStorageClass enum value
	ObjectVersionStorageClassStandard = "STANDARD"
)

// ObjectVersionStorageClass_Values returns all elements of the ObjectVersionStorageClass enum
func ObjectVersionStorageClass_Values() []string {
	return []string{
		ObjectVersionStorageClassStandard,
	}
}

const (
	// PermissionFullControl is a Permission enum value
	PermissionFullControl = "FULL_CONTROL"

	// PermissionWrite is a Permission enum value
	PermissionWrite = "WRITE"

	// PermissionWriteAcp is a Permission enum value
	PermissionWriteAcp = "WRITE_ACP"

	// PermissionRead is a Permission enum value
	PermissionRead = "READ"

	// PermissionReadAcp is a Permission enum value
	PermissionReadAcp = "READ_ACP"
)

// Permission_Values returns all elements of the Permission enum
func Permission_Values() []string {
	return []string{
		PermissionFullControl,
		PermissionWrite,
		PermissionWriteAcp,
		PermissionRead,
		PermissionReadAcp,
	}
}

const (
	// ProtocolHttp is a Protocol enum value
	ProtocolHttp = "http"

	// ProtocolHttps is a Protocol enum value
	ProtocolHttps = "https"
)

// Protocol_Values returns all elements of the Protocol enum
func Protocol_Values() []string {
	return []string{
		ProtocolHttp,
		ProtocolHttps,
	}
}

const (
	// ReplicationStatusComplete is a ReplicationStatus enum value
	ReplicationStatusComplete = "COMPLETE"

	// ReplicationStatusPending is a ReplicationStatus enum value
	ReplicationStatusPending = "PENDING"

	// ReplicationStatusFailed is a ReplicationStatus enum value
	ReplicationStatusFailed = "FAILED"

	// ReplicationStatusReplica is a ReplicationStatus enum value
	ReplicationStatusReplica = "REPLICA"
)

// ReplicationStatus_Values returns all elements of the ReplicationStatus enum
func ReplicationStatus_Values() []string {
	return []string{
		ReplicationStatusComplete,
		ReplicationStatusPending,
		ReplicationStatusFailed,
		ReplicationStatusReplica,
	}
}

// If present, indicates that the requester was successfully charged for the
// request.
const (
	// RequestChargedRequester is a RequestCharged enum value
	RequestChargedRequester = "requester"
)

// RequestCharged_Values returns all elements of the RequestCharged enum
func RequestCharged_Values() []string {
	return []string{
		RequestChargedRequester,
	}
}

// Confirms that the requester knows that they will be charged for the request.
// Bucket owners need not specify this parameter in their requests. For information
// about downloading objects from requester pays buckets, see Downloading Objects
// in Requestor Pays Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html)
// in the Amazon S3 Developer Guide.
const (
	// RequestPayerRequester is a RequestPayer enum value
	RequestPayerRequester = "requester"
)

// RequestPayer_Values returns all elements of the RequestPayer enum
func RequestPayer_Values() []string {
	return []string{
		RequestPayerRequester,
	}
}

const (
	// RetentionDirectiveCopy is a RetentionDirective enum value
	RetentionDirectiveCopy = "COPY"

	// RetentionDirectiveReplace is a RetentionDirective enum value
	RetentionDirectiveReplace = "REPLACE"
)

// RetentionDirective_Values returns all elements of the RetentionDirective enum
func RetentionDirective_Values() []string {
	return []string{
		RetentionDirectiveCopy,
		RetentionDirectiveReplace,
	}
}

const (
	// ServerSideEncryptionAes256 is a ServerSideEncryption enum value
	ServerSideEncryptionAes256 = "AES256"

	// ServerSideEncryptionAwsKms is a ServerSideEncryption enum value
	ServerSideEncryptionAwsKms = "aws:kms"
)

// ServerSideEncryption_Values returns all elements of the ServerSideEncryption enum
func ServerSideEncryption_Values() []string {
	return []string{
		ServerSideEncryptionAes256,
		ServerSideEncryptionAwsKms,
	}
}

const (
	// StorageClassStandard is a StorageClass enum value
	StorageClassStandard = "STANDARD"

	// StorageClassReducedRedundancy is a StorageClass enum value
	StorageClassReducedRedundancy = "REDUCED_REDUNDANCY"

	// StorageClassStandardIa is a StorageClass enum value
	StorageClassStandardIa = "STANDARD_IA"

	// StorageClassOnezoneIa is a StorageClass enum value
	StorageClassOnezoneIa = "ONEZONE_IA"

	// StorageClassIntelligentTiering is a StorageClass enum value
	StorageClassIntelligentTiering = "INTELLIGENT_TIERING"

	// StorageClassGlacier is a StorageClass enum value
	StorageClassGlacier = "GLACIER"

	// StorageClassAccelerated is a StorageClass enum value
	StorageClassAccelerated = "ACCELERATED"

	// StorageClassDeepArchive is a StorageClass enum value
	StorageClassDeepArchive = "DEEP_ARCHIVE"
)

// StorageClass_Values returns all elements of the StorageClass enum
func StorageClass_Values() []string {
	return []string{
		StorageClassStandard,
		StorageClassReducedRedundancy,
		StorageClassStandardIa,
		StorageClassOnezoneIa,
		StorageClassIntelligentTiering,
		StorageClassGlacier,
		StorageClassAccelerated,
		StorageClassDeepArchive,
	}
}

const (
	// TaggingDirectiveCopy is a TaggingDirective enum value
	TaggingDirectiveCopy = "COPY"

	// TaggingDirectiveReplace is a TaggingDirective enum value
	TaggingDirectiveReplace = "REPLACE"
)

// TaggingDirective_Values returns all elements of the TaggingDirective enum
func TaggingDirective_Values() []string {
	return []string{
		TaggingDirectiveCopy,
		TaggingDirectiveReplace,
	}
}

const (
	// TierAccelerated is a Tier enum value
	TierAccelerated = "Accelerated"

	// TierStandard is a Tier enum value
	TierStandard = "Standard"

	// TierBulk is a Tier enum value
	TierBulk = "Bulk"

	// TierExpedited is a Tier enum value
	TierExpedited = "Expedited"
)

// Tier_Values returns all elements of the Tier enum
func Tier_Values() []string {
	return []string{
		TierAccelerated,
		TierStandard,
		TierBulk,
		TierExpedited,
	}
}

const (
	// TransitionStorageClassGlacier is a TransitionStorageClass enum value
	TransitionStorageClassGlacier = "GLACIER"

	// TransitionStorageClassAccelerated is a TransitionStorageClass enum value
	TransitionStorageClassAccelerated = "ACCELERATED"

	// TransitionStorageClassStandardIa is a TransitionStorageClass enum value
	TransitionStorageClassStandardIa = "STANDARD_IA"

	// TransitionStorageClassOnezoneIa is a TransitionStorageClass enum value
	TransitionStorageClassOnezoneIa = "ONEZONE_IA"

	// TransitionStorageClassIntelligentTiering is a TransitionStorageClass enum value
	TransitionStorageClassIntelligentTiering = "INTELLIGENT_TIERING"

	// TransitionStorageClassDeepArchive is a TransitionStorageClass enum value
	TransitionStorageClassDeepArchive = "DEEP_ARCHIVE"
)

// TransitionStorageClass_Values returns all elements of the TransitionStorageClass enum
func TransitionStorageClass_Values() []string {
	return []string{
		TransitionStorageClassGlacier,
		TransitionStorageClassAccelerated,
		TransitionStorageClassStandardIa,
		TransitionStorageClassOnezoneIa,
		TransitionStorageClassIntelligentTiering,
		TransitionStorageClassDeepArchive,
	}
}

const (
	// TypeCanonicalUser is a Type enum value
	TypeCanonicalUser = "CanonicalUser"

	// TypeAmazonCustomerByEmail is a Type enum value
	TypeAmazonCustomerByEmail = "AmazonCustomerByEmail"

	// TypeGroup is a Type enum value
	TypeGroup = "Group"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeCanonicalUser,
		TypeAmazonCustomerByEmail,
		TypeGroup,
	}
}
