// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
)

// TenantUpdate tenant update
// swagger:model TenantUpdate
type TenantUpdate struct {

	// IBM Customer Number
	Icn *string `json:"icn,omitempty"`

	// Peering Network Information (optional)
	PeeringNetworks []*PeeringNetwork `json:"peeringNetworks"`
}

// Validate validates this tenant update
func (m *TenantUpdate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePeeringNetworks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TenantUpdate) validatePeeringNetworks(formats strfmt.Registry) error {

	if swag.IsZero(m.PeeringNetworks) { // not required
		return nil
	}

	for i := 0; i < len(m.PeeringNetworks); i++ {
		if swag.IsZero(m.PeeringNetworks[i]) { // not required
			continue
		}

		if m.PeeringNetworks[i] != nil {
			if err := m.PeeringNetworks[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("peeringNetworks" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *TenantUpdate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TenantUpdate) UnmarshalBinary(b []byte) error {
	var res TenantUpdate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
