// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SAPCreate s a p create
// swagger:model SAPCreate
type SAPCreate struct {

	// Image ID of the sap image to use for the server
	// Required: true
	ImageID *string `json:"imageID"`

	// instances
	Instances *PVMInstanceMultiCreate `json:"instances,omitempty"`

	// Name of the sap pvm-instance
	// Required: true
	Name *string `json:"name"`

	// The pvm instance networks information
	// Required: true
	Networks []*PVMInstanceAddNetwork `json:"networks"`

	// pin policy
	PinPolicy PinPolicy `json:"pinPolicy,omitempty"`

	// SAP Profile ID for the amount of cores and memory
	// Required: true
	ProfileID *string `json:"profileID"`

	// The name of the SSH Key to provide to the server for authenticating
	SSHKeyName string `json:"sshKeyName,omitempty"`

	// Cloud init user defined data
	UserData string `json:"userData,omitempty"`

	// List of Volume IDs to attach to the pvm-instance on creation
	VolumeIds []string `json:"volumeIDs"`
}

// Validate validates this s a p create
func (m *SAPCreate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateImageID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInstances(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetworks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePinPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProfileID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SAPCreate) validateImageID(formats strfmt.Registry) error {

	if err := validate.Required("imageID", "body", m.ImageID); err != nil {
		return err
	}

	return nil
}

func (m *SAPCreate) validateInstances(formats strfmt.Registry) error {

	if swag.IsZero(m.Instances) { // not required
		return nil
	}

	if m.Instances != nil {
		if err := m.Instances.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("instances")
			}
			return err
		}
	}

	return nil
}

func (m *SAPCreate) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *SAPCreate) validateNetworks(formats strfmt.Registry) error {

	if err := validate.Required("networks", "body", m.Networks); err != nil {
		return err
	}

	for i := 0; i < len(m.Networks); i++ {
		if swag.IsZero(m.Networks[i]) { // not required
			continue
		}

		if m.Networks[i] != nil {
			if err := m.Networks[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("networks" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *SAPCreate) validatePinPolicy(formats strfmt.Registry) error {

	if swag.IsZero(m.PinPolicy) { // not required
		return nil
	}

	if err := m.PinPolicy.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("pinPolicy")
		}
		return err
	}

	return nil
}

func (m *SAPCreate) validateProfileID(formats strfmt.Registry) error {

	if err := validate.Required("profileID", "body", m.ProfileID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SAPCreate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SAPCreate) UnmarshalBinary(b []byte) error {
	var res SAPCreate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
