// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MaximumStorageAllocation Maximum storage allocation
// swagger:model MaximumStorageAllocation
type MaximumStorageAllocation struct {

	// Maximum allocation storage size (GB)
	// Required: true
	MaxAllocationSize *int64 `json:"maxAllocationSize"`

	// Storage pool
	// Required: true
	StoragePool *string `json:"storagePool"`

	// Storage type
	// Required: true
	StorageType *string `json:"storageType"`
}

// Validate validates this maximum storage allocation
func (m *MaximumStorageAllocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMaxAllocationSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStoragePool(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MaximumStorageAllocation) validateMaxAllocationSize(formats strfmt.Registry) error {

	if err := validate.Required("maxAllocationSize", "body", m.MaxAllocationSize); err != nil {
		return err
	}

	return nil
}

func (m *MaximumStorageAllocation) validateStoragePool(formats strfmt.Registry) error {

	if err := validate.Required("storagePool", "body", m.StoragePool); err != nil {
		return err
	}

	return nil
}

func (m *MaximumStorageAllocation) validateStorageType(formats strfmt.Registry) error {

	if err := validate.Required("storageType", "body", m.StorageType); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MaximumStorageAllocation) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MaximumStorageAllocation) UnmarshalBinary(b []byte) error {
	var res MaximumStorageAllocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
