// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    AUTO GENERATED CODE     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"regexp"
	"strconv"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/helper/schema"
)

func resourceDataCatalogTag() *schema.Resource {
	return &schema.Resource{
		Create: resourceDataCatalogTagCreate,
		Read:   resourceDataCatalogTagRead,
		Update: resourceDataCatalogTagUpdate,
		Delete: resourceDataCatalogTagDelete,

		Importer: &schema.ResourceImporter{
			State: resourceDataCatalogTagImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(4 * time.Minute),
			Update: schema.DefaultTimeout(4 * time.Minute),
			Delete: schema.DefaultTimeout(4 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"fields": {
				Type:     schema.TypeSet,
				Required: true,
				Description: `This maps the ID of a tag field to the value of and additional information about that field.
Valid field IDs are defined by the tag's template. A tag must have at least 1 field and at most 500 fields.`,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"field_name": {
							Type:     schema.TypeString,
							Required: true,
						},
						"bool_value": {
							Type:        schema.TypeBool,
							Optional:    true,
							Description: `Holds the value for a tag field with boolean type.`,
						},
						"double_value": {
							Type:        schema.TypeFloat,
							Optional:    true,
							Description: `Holds the value for a tag field with double type.`,
						},
						"enum_value": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `The display name of the enum value.`,
						},

						"string_value": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Holds the value for a tag field with string type.`,
						},
						"timestamp_value": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `Holds the value for a tag field with timestamp type.`,
						},
						"display_name": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The display name of this field`,
						},
						"order": {
							Type:     schema.TypeInt,
							Computed: true,
							Description: `The order of this field with respect to other fields in this tag. For example, a higher value can indicate
a more important field. The value can be negative. Multiple fields can have the same order, and field orders
within a tag do not have to be sequential.`,
						},
					},
				},
			},
			"template": {
				Type:     schema.TypeString,
				Required: true,
				ForceNew: true,
				Description: `The resource name of the tag template that this tag uses. Example:
projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
This field cannot be modified after creation.`,
			},
			"column": {
				Type:     schema.TypeString,
				Optional: true,
				Description: `Resources like Entry can have schemas associated with them. This scope allows users to attach tags to an
individual column based on that schema.

For attaching a tag to a nested column, use '.' to separate the column names. Example:
'outer_column.inner_column'`,
			},
			"parent": {
				Type:     schema.TypeString,
				Optional: true,
				Description: `The name of the parent this tag is attached to. This can be the name of an entry or an entry group. If an entry group, the tag will be attached to
all entries in that group.`,
			},
			"name": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `The resource name of the tag in URL format. Example:
projects/{project_id}/locations/{location}/entrygroups/{entryGroupId}/entries/{entryId}/tags/{tag_id} or
projects/{project_id}/locations/{location}/entrygroups/{entryGroupId}/tags/{tag_id}
where tag_id is a system-generated identifier. Note that this Tag may not actually be stored in the location in this name.`,
			},
			"template_displayname": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The display name of the tag template.`,
			},
		},
	}
}

func resourceDataCatalogTagCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	obj := make(map[string]interface{})
	templateProp, err := expandNestedDataCatalogTagTemplate(d.Get("template"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("template"); !isEmptyValue(reflect.ValueOf(templateProp)) && (ok || !reflect.DeepEqual(v, templateProp)) {
		obj["template"] = templateProp
	}
	fieldsProp, err := expandNestedDataCatalogTagFields(d.Get("fields"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("fields"); !isEmptyValue(reflect.ValueOf(fieldsProp)) && (ok || !reflect.DeepEqual(v, fieldsProp)) {
		obj["fields"] = fieldsProp
	}
	columnProp, err := expandNestedDataCatalogTagColumn(d.Get("column"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("column"); !isEmptyValue(reflect.ValueOf(columnProp)) && (ok || !reflect.DeepEqual(v, columnProp)) {
		obj["column"] = columnProp
	}

	url, err := replaceVars(d, config, "{{DataCatalogBasePath}}{{parent}}/tags")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new Tag: %#v", obj)
	res, err := sendRequestWithTimeout(config, "POST", "", url, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating Tag: %s", err)
	}
	if err := d.Set("name", flattenNestedDataCatalogTagName(res["name"], d, config)); err != nil {
		return fmt.Errorf(`Error setting computed identity field "name": %s`, err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "{{name}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating Tag %q: %#v", d.Id(), res)

	return resourceDataCatalogTagRead(d, meta)
}

func resourceDataCatalogTagRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	url, err := replaceVars(d, config, "{{DataCatalogBasePath}}{{parent}}/tags")
	if err != nil {
		return err
	}

	res, err := sendRequest(config, "GET", "", url, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("DataCatalogTag %q", d.Id()))
	}

	res, err = flattenNestedDataCatalogTag(d, meta, res)
	if err != nil {
		return err
	}

	if res == nil {
		// Object isn't there any more - remove it from the state.
		log.Printf("[DEBUG] Removing DataCatalogTag because it couldn't be matched.")
		d.SetId("")
		return nil
	}

	if err := d.Set("name", flattenNestedDataCatalogTagName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading Tag: %s", err)
	}
	if err := d.Set("template", flattenNestedDataCatalogTagTemplate(res["template"], d, config)); err != nil {
		return fmt.Errorf("Error reading Tag: %s", err)
	}
	if err := d.Set("template_displayname", flattenNestedDataCatalogTagTemplateDisplayname(res["templateDisplayName"], d, config)); err != nil {
		return fmt.Errorf("Error reading Tag: %s", err)
	}
	if err := d.Set("fields", flattenNestedDataCatalogTagFields(res["fields"], d, config)); err != nil {
		return fmt.Errorf("Error reading Tag: %s", err)
	}
	if err := d.Set("column", flattenNestedDataCatalogTagColumn(res["column"], d, config)); err != nil {
		return fmt.Errorf("Error reading Tag: %s", err)
	}

	return nil
}

func resourceDataCatalogTagUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	obj := make(map[string]interface{})
	fieldsProp, err := expandNestedDataCatalogTagFields(d.Get("fields"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("fields"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, fieldsProp)) {
		obj["fields"] = fieldsProp
	}
	columnProp, err := expandNestedDataCatalogTagColumn(d.Get("column"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("column"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, columnProp)) {
		obj["column"] = columnProp
	}

	url, err := replaceVars(d, config, "{{DataCatalogBasePath}}{{name}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating Tag %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("fields") {
		updateMask = append(updateMask, "fields")
	}

	if d.HasChange("column") {
		updateMask = append(updateMask, "column")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}
	_, err = sendRequestWithTimeout(config, "PATCH", "", url, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating Tag %q: %s", d.Id(), err)
	}

	return resourceDataCatalogTagRead(d, meta)
}

func resourceDataCatalogTagDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)

	url, err := replaceVars(d, config, "{{DataCatalogBasePath}}{{name}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting Tag %q", d.Id())

	res, err := sendRequestWithTimeout(config, "DELETE", "", url, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "Tag")
	}

	log.Printf("[DEBUG] Finished deleting Tag %q: %#v", d.Id(), res)
	return nil
}

func resourceDataCatalogTagImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)

	// current import_formats can't import fields with forward slashes in their value
	if err := parseImportId([]string{"(?P<name>.+)"}, d, config); err != nil {
		return nil, err
	}

	name := d.Get("name").(string)
	egRegex := regexp.MustCompile("(.+)/tags")

	parts := egRegex.FindStringSubmatch(name)
	if len(parts) != 2 {
		return nil, fmt.Errorf("entry name does not fit the format %s", egRegex)
	}

	d.Set("parent", parts[1])
	return []*schema.ResourceData{d}, nil
}

func flattenNestedDataCatalogTagName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNestedDataCatalogTagTemplate(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNestedDataCatalogTagTemplateDisplayname(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNestedDataCatalogTagFields(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return v
	}
	l := v.(map[string]interface{})
	transformed := make([]interface{}, 0, len(l))
	for k, raw := range l {
		original := raw.(map[string]interface{})
		transformed = append(transformed, map[string]interface{}{
			"field_name":      k,
			"display_name":    flattenNestedDataCatalogTagFieldsDisplayName(original["display_name"], d, config),
			"order":           flattenNestedDataCatalogTagFieldsOrder(original["order"], d, config),
			"double_value":    flattenNestedDataCatalogTagFieldsDoubleValue(original["doubleValue"], d, config),
			"string_value":    flattenNestedDataCatalogTagFieldsStringValue(original["stringValue"], d, config),
			"bool_value":      flattenNestedDataCatalogTagFieldsBoolValue(original["boolValue"], d, config),
			"timestamp_value": flattenNestedDataCatalogTagFieldsTimestampValue(original["timestampValue"], d, config),
			"enum_value":      flattenNestedDataCatalogTagFieldsEnumValue(original["enumValue"], d, config),
		})
	}
	return transformed
}
func flattenNestedDataCatalogTagFieldsDisplayName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNestedDataCatalogTagFieldsOrder(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := strconv.ParseInt(strVal, 10, 64); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenNestedDataCatalogTagFieldsDoubleValue(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNestedDataCatalogTagFieldsStringValue(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNestedDataCatalogTagFieldsBoolValue(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNestedDataCatalogTagFieldsTimestampValue(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenNestedDataCatalogTagFieldsEnumValue(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}

	return v.(map[string]interface{})["displayName"]
}

func flattenNestedDataCatalogTagColumn(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandNestedDataCatalogTagTemplate(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNestedDataCatalogTagFields(v interface{}, d TerraformResourceData, config *Config) (map[string]interface{}, error) {
	if v == nil {
		return map[string]interface{}{}, nil
	}
	m := make(map[string]interface{})
	for _, raw := range v.(*schema.Set).List() {
		original := raw.(map[string]interface{})
		transformed := make(map[string]interface{})

		transformedDisplayName, err := expandNestedDataCatalogTagFieldsDisplayName(original["display_name"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedDisplayName); val.IsValid() && !isEmptyValue(val) {
			transformed["display_name"] = transformedDisplayName
		}

		transformedOrder, err := expandNestedDataCatalogTagFieldsOrder(original["order"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedOrder); val.IsValid() && !isEmptyValue(val) {
			transformed["order"] = transformedOrder
		}

		transformedDoubleValue, err := expandNestedDataCatalogTagFieldsDoubleValue(original["double_value"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedDoubleValue); val.IsValid() && !isEmptyValue(val) {
			transformed["doubleValue"] = transformedDoubleValue
		}

		transformedStringValue, err := expandNestedDataCatalogTagFieldsStringValue(original["string_value"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedStringValue); val.IsValid() && !isEmptyValue(val) {
			transformed["stringValue"] = transformedStringValue
		}

		transformedBoolValue, err := expandNestedDataCatalogTagFieldsBoolValue(original["bool_value"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedBoolValue); val.IsValid() && !isEmptyValue(val) {
			transformed["boolValue"] = transformedBoolValue
		}

		transformedTimestampValue, err := expandNestedDataCatalogTagFieldsTimestampValue(original["timestamp_value"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedTimestampValue); val.IsValid() && !isEmptyValue(val) {
			transformed["timestampValue"] = transformedTimestampValue
		}

		transformedEnumValue, err := expandNestedDataCatalogTagFieldsEnumValue(original["enum_value"], d, config)
		if err != nil {
			return nil, err
		} else if val := reflect.ValueOf(transformedEnumValue); val.IsValid() && !isEmptyValue(val) {
			transformed["enumValue"] = transformedEnumValue
		}

		transformedFieldName, err := expandString(original["field_name"], d, config)
		if err != nil {
			return nil, err
		}
		m[transformedFieldName] = transformed
	}
	return m, nil
}

func expandNestedDataCatalogTagFieldsDisplayName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNestedDataCatalogTagFieldsOrder(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNestedDataCatalogTagFieldsDoubleValue(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNestedDataCatalogTagFieldsStringValue(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNestedDataCatalogTagFieldsBoolValue(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNestedDataCatalogTagFieldsTimestampValue(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandNestedDataCatalogTagFieldsEnumValue(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	// we flattened the original["enum_value"]["display_name"] object to be just original["enum_value"] so here,
	// v is the value we want from the config
	transformed := make(map[string]interface{})
	if val := reflect.ValueOf(v); val.IsValid() && !isEmptyValue(val) {
		transformed["displayName"] = v
	}

	return transformed, nil
}

func expandNestedDataCatalogTagColumn(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func flattenNestedDataCatalogTag(d *schema.ResourceData, meta interface{}, res map[string]interface{}) (map[string]interface{}, error) {
	var v interface{}
	var ok bool

	v, ok = res["tags"]
	if !ok || v == nil {
		return nil, nil
	}

	switch v.(type) {
	case []interface{}:
		break
	case map[string]interface{}:
		// Construct list out of single nested resource
		v = []interface{}{v}
	default:
		return nil, fmt.Errorf("expected list or map for value tags. Actual value: %v", v)
	}

	_, item, err := resourceDataCatalogTagFindNestedObjectInList(d, meta, v.([]interface{}))
	if err != nil {
		return nil, err
	}
	return item, nil
}

func resourceDataCatalogTagFindNestedObjectInList(d *schema.ResourceData, meta interface{}, items []interface{}) (index int, item map[string]interface{}, err error) {
	expectedName := d.Get("name")
	expectedFlattenedName := flattenNestedDataCatalogTagName(expectedName, d, meta.(*Config))

	// Search list for this resource.
	for idx, itemRaw := range items {
		if itemRaw == nil {
			continue
		}
		item := itemRaw.(map[string]interface{})

		itemName := flattenNestedDataCatalogTagName(item["name"], d, meta.(*Config))
		// isEmptyValue check so that if one is nil and the other is "", that's considered a match
		if !(isEmptyValue(reflect.ValueOf(itemName)) && isEmptyValue(reflect.ValueOf(expectedFlattenedName))) && !reflect.DeepEqual(itemName, expectedFlattenedName) {
			log.Printf("[DEBUG] Skipping item with name= %#v, looking for %#v)", itemName, expectedFlattenedName)
			continue
		}
		log.Printf("[DEBUG] Found item for resource %q: %#v)", d.Id(), item)
		return idx, item, nil
	}
	return -1, nil, nil
}
