// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalytics

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddApplicationCloudWatchLoggingOption = "AddApplicationCloudWatchLoggingOption"

// AddApplicationCloudWatchLoggingOptionRequest generates a "aws/request.Request" representing the
// client's request for the AddApplicationCloudWatchLoggingOption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddApplicationCloudWatchLoggingOption for more information on using the AddApplicationCloudWatchLoggingOption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddApplicationCloudWatchLoggingOptionRequest method.
//    req, resp := client.AddApplicationCloudWatchLoggingOptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/AddApplicationCloudWatchLoggingOption
func (c *KinesisAnalytics) AddApplicationCloudWatchLoggingOptionRequest(input *AddApplicationCloudWatchLoggingOptionInput) (req *request.Request, output *AddApplicationCloudWatchLoggingOptionOutput) {
	op := &request.Operation{
		Name:       opAddApplicationCloudWatchLoggingOption,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationCloudWatchLoggingOptionInput{}
	}

	output = &AddApplicationCloudWatchLoggingOptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddApplicationCloudWatchLoggingOption API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Adds a CloudWatch log stream to monitor application configuration errors.
// For more information about using CloudWatch log streams with Amazon Kinesis
// Analytics applications, see Working with Amazon CloudWatch Logs (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation AddApplicationCloudWatchLoggingOption for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/AddApplicationCloudWatchLoggingOption
func (c *KinesisAnalytics) AddApplicationCloudWatchLoggingOption(input *AddApplicationCloudWatchLoggingOptionInput) (*AddApplicationCloudWatchLoggingOptionOutput, error) {
	req, out := c.AddApplicationCloudWatchLoggingOptionRequest(input)
	return out, req.Send()
}

// AddApplicationCloudWatchLoggingOptionWithContext is the same as AddApplicationCloudWatchLoggingOption with the addition of
// the ability to pass a context and additional request options.
//
// See AddApplicationCloudWatchLoggingOption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) AddApplicationCloudWatchLoggingOptionWithContext(ctx aws.Context, input *AddApplicationCloudWatchLoggingOptionInput, opts ...request.Option) (*AddApplicationCloudWatchLoggingOptionOutput, error) {
	req, out := c.AddApplicationCloudWatchLoggingOptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddApplicationInput = "AddApplicationInput"

// AddApplicationInputRequest generates a "aws/request.Request" representing the
// client's request for the AddApplicationInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddApplicationInput for more information on using the AddApplicationInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddApplicationInputRequest method.
//    req, resp := client.AddApplicationInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/AddApplicationInput
func (c *KinesisAnalytics) AddApplicationInputRequest(input *AddApplicationInputInput) (req *request.Request, output *AddApplicationInputOutput) {
	op := &request.Operation{
		Name:       opAddApplicationInput,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationInputInput{}
	}

	output = &AddApplicationInputOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddApplicationInput API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Adds a streaming source to your Amazon Kinesis application. For conceptual
// information, see Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
//
// You can add a streaming source either when you create an application or you
// can use this operation to add a streaming source after you create an application.
// For more information, see CreateApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_CreateApplication.html).
//
// Any configuration update, including adding a streaming source using this
// operation, results in a new version of the application. You can use the DescribeApplication
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
// operation to find the current application version.
//
// This operation requires permissions to perform the kinesisanalytics:AddApplicationInput
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation AddApplicationInput for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
//   * CodeValidationException
//   User-provided application code (query) is invalid. This can be a simple syntax
//   error.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/AddApplicationInput
func (c *KinesisAnalytics) AddApplicationInput(input *AddApplicationInputInput) (*AddApplicationInputOutput, error) {
	req, out := c.AddApplicationInputRequest(input)
	return out, req.Send()
}

// AddApplicationInputWithContext is the same as AddApplicationInput with the addition of
// the ability to pass a context and additional request options.
//
// See AddApplicationInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) AddApplicationInputWithContext(ctx aws.Context, input *AddApplicationInputInput, opts ...request.Option) (*AddApplicationInputOutput, error) {
	req, out := c.AddApplicationInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddApplicationInputProcessingConfiguration = "AddApplicationInputProcessingConfiguration"

// AddApplicationInputProcessingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the AddApplicationInputProcessingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddApplicationInputProcessingConfiguration for more information on using the AddApplicationInputProcessingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddApplicationInputProcessingConfigurationRequest method.
//    req, resp := client.AddApplicationInputProcessingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/AddApplicationInputProcessingConfiguration
func (c *KinesisAnalytics) AddApplicationInputProcessingConfigurationRequest(input *AddApplicationInputProcessingConfigurationInput) (req *request.Request, output *AddApplicationInputProcessingConfigurationOutput) {
	op := &request.Operation{
		Name:       opAddApplicationInputProcessingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationInputProcessingConfigurationInput{}
	}

	output = &AddApplicationInputProcessingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddApplicationInputProcessingConfiguration API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Adds an InputProcessingConfiguration (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html)
// to an application. An input processor preprocesses records on the input stream
// before the application's SQL code executes. Currently, the only input processor
// available is AWS Lambda (https://docs.aws.amazon.com/lambda/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation AddApplicationInputProcessingConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/AddApplicationInputProcessingConfiguration
func (c *KinesisAnalytics) AddApplicationInputProcessingConfiguration(input *AddApplicationInputProcessingConfigurationInput) (*AddApplicationInputProcessingConfigurationOutput, error) {
	req, out := c.AddApplicationInputProcessingConfigurationRequest(input)
	return out, req.Send()
}

// AddApplicationInputProcessingConfigurationWithContext is the same as AddApplicationInputProcessingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See AddApplicationInputProcessingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) AddApplicationInputProcessingConfigurationWithContext(ctx aws.Context, input *AddApplicationInputProcessingConfigurationInput, opts ...request.Option) (*AddApplicationInputProcessingConfigurationOutput, error) {
	req, out := c.AddApplicationInputProcessingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddApplicationOutput = "AddApplicationOutput"

// AddApplicationOutputRequest generates a "aws/request.Request" representing the
// client's request for the AddApplicationOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddApplicationOutput for more information on using the AddApplicationOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddApplicationOutputRequest method.
//    req, resp := client.AddApplicationOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/AddApplicationOutput
func (c *KinesisAnalytics) AddApplicationOutputRequest(input *AddApplicationOutputInput) (req *request.Request, output *AddApplicationOutputOutput) {
	op := &request.Operation{
		Name:       opAddApplicationOutput,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationOutputInput{}
	}

	output = &AddApplicationOutputOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddApplicationOutput API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Adds an external destination to your Amazon Kinesis Analytics application.
//
// If you want Amazon Kinesis Analytics to deliver data from an in-application
// stream within your application to an external destination (such as an Amazon
// Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda
// function), you add the relevant configuration to your application using this
// operation. You can configure one or more outputs for your application. Each
// output configuration maps an in-application stream and an external destination.
//
// You can use one of the output configurations to deliver data from your in-application
// error stream to an external destination so that you can analyze the errors.
// For more information, see Understanding Application Output (Destination)
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
//
// Any configuration update, including adding a streaming source using this
// operation, results in a new version of the application. You can use the DescribeApplication
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
// operation to find the current application version.
//
// For the limits on the number of application inputs and outputs you can configure,
// see Limits (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
//
// This operation requires permissions to perform the kinesisanalytics:AddApplicationOutput
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation AddApplicationOutput for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/AddApplicationOutput
func (c *KinesisAnalytics) AddApplicationOutput(input *AddApplicationOutputInput) (*AddApplicationOutputOutput, error) {
	req, out := c.AddApplicationOutputRequest(input)
	return out, req.Send()
}

// AddApplicationOutputWithContext is the same as AddApplicationOutput with the addition of
// the ability to pass a context and additional request options.
//
// See AddApplicationOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) AddApplicationOutputWithContext(ctx aws.Context, input *AddApplicationOutputInput, opts ...request.Option) (*AddApplicationOutputOutput, error) {
	req, out := c.AddApplicationOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddApplicationReferenceDataSource = "AddApplicationReferenceDataSource"

// AddApplicationReferenceDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the AddApplicationReferenceDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddApplicationReferenceDataSource for more information on using the AddApplicationReferenceDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddApplicationReferenceDataSourceRequest method.
//    req, resp := client.AddApplicationReferenceDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/AddApplicationReferenceDataSource
func (c *KinesisAnalytics) AddApplicationReferenceDataSourceRequest(input *AddApplicationReferenceDataSourceInput) (req *request.Request, output *AddApplicationReferenceDataSourceOutput) {
	op := &request.Operation{
		Name:       opAddApplicationReferenceDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationReferenceDataSourceInput{}
	}

	output = &AddApplicationReferenceDataSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddApplicationReferenceDataSource API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Adds a reference data source to an existing application.
//
// Amazon Kinesis Analytics reads reference data (that is, an Amazon S3 object)
// and creates an in-application table within your application. In the request,
// you provide the source (S3 bucket name and object key name), name of the
// in-application table to create, and the necessary mapping information that
// describes how data in Amazon S3 object maps to columns in the resulting in-application
// table.
//
// For conceptual information, see Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
// For the limits on data sources you can add to your application, see Limits
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
//
// This operation requires permissions to perform the kinesisanalytics:AddApplicationOutput
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation AddApplicationReferenceDataSource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/AddApplicationReferenceDataSource
func (c *KinesisAnalytics) AddApplicationReferenceDataSource(input *AddApplicationReferenceDataSourceInput) (*AddApplicationReferenceDataSourceOutput, error) {
	req, out := c.AddApplicationReferenceDataSourceRequest(input)
	return out, req.Send()
}

// AddApplicationReferenceDataSourceWithContext is the same as AddApplicationReferenceDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See AddApplicationReferenceDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) AddApplicationReferenceDataSourceWithContext(ctx aws.Context, input *AddApplicationReferenceDataSourceInput, opts ...request.Option) (*AddApplicationReferenceDataSourceOutput, error) {
	req, out := c.AddApplicationReferenceDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/CreateApplication
func (c *KinesisAnalytics) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Creates an Amazon Kinesis Analytics application. You can configure each application
// with one streaming source as input, application code to process the input,
// and up to three destinations where you want Amazon Kinesis Analytics to write
// the output data from your application. For an overview, see How it Works
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works.html).
//
// In the input configuration, you map the streaming source to an in-application
// stream, which you can think of as a constantly updating table. In the mapping,
// you must provide a schema for the in-application stream and map each data
// column in the in-application stream to a data element in the streaming source.
//
// Your application code is one or more SQL statements that read input data,
// transform it, and generate output. Your application code can create one or
// more SQL artifacts like SQL streams or pumps.
//
// In the output configuration, you can configure the application to write data
// from in-application streams created in your applications to up to three destinations.
//
// To read data from your source stream or write data to destination streams,
// Amazon Kinesis Analytics needs your permissions. You grant these permissions
// by creating IAM roles. This operation requires permissions to perform the
// kinesisanalytics:CreateApplication action.
//
// For introductory exercises to create an Amazon Kinesis Analytics application,
// see Getting Started (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/getting-started.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//   * CodeValidationException
//   User-provided application code (query) is invalid. This can be a simple syntax
//   error.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * LimitExceededException
//   Exceeded the number of applications allowed.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * TooManyTagsException
//   Application created with too many tags, or too many tags added to an application.
//   Note that the maximum number of application tags includes system tags. The
//   maximum number of user-defined application tags is 50.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/CreateApplication
func (c *KinesisAnalytics) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationRequest method.
//    req, resp := client.DeleteApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DeleteApplication
func (c *KinesisAnalytics) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Deletes the specified application. Amazon Kinesis Analytics halts application
// execution and deletes the application, including any application artifacts
// (such as in-application streams, reference table, and application code).
//
// This operation requires permissions to perform the kinesisanalytics:DeleteApplication
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DeleteApplication
func (c *KinesisAnalytics) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationCloudWatchLoggingOption = "DeleteApplicationCloudWatchLoggingOption"

// DeleteApplicationCloudWatchLoggingOptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationCloudWatchLoggingOption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationCloudWatchLoggingOption for more information on using the DeleteApplicationCloudWatchLoggingOption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationCloudWatchLoggingOptionRequest method.
//    req, resp := client.DeleteApplicationCloudWatchLoggingOptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DeleteApplicationCloudWatchLoggingOption
func (c *KinesisAnalytics) DeleteApplicationCloudWatchLoggingOptionRequest(input *DeleteApplicationCloudWatchLoggingOptionInput) (req *request.Request, output *DeleteApplicationCloudWatchLoggingOptionOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationCloudWatchLoggingOption,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationCloudWatchLoggingOptionInput{}
	}

	output = &DeleteApplicationCloudWatchLoggingOptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplicationCloudWatchLoggingOption API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Deletes a CloudWatch log stream from an application. For more information
// about using CloudWatch log streams with Amazon Kinesis Analytics applications,
// see Working with Amazon CloudWatch Logs (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplicationCloudWatchLoggingOption for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DeleteApplicationCloudWatchLoggingOption
func (c *KinesisAnalytics) DeleteApplicationCloudWatchLoggingOption(input *DeleteApplicationCloudWatchLoggingOptionInput) (*DeleteApplicationCloudWatchLoggingOptionOutput, error) {
	req, out := c.DeleteApplicationCloudWatchLoggingOptionRequest(input)
	return out, req.Send()
}

// DeleteApplicationCloudWatchLoggingOptionWithContext is the same as DeleteApplicationCloudWatchLoggingOption with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationCloudWatchLoggingOption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) DeleteApplicationCloudWatchLoggingOptionWithContext(ctx aws.Context, input *DeleteApplicationCloudWatchLoggingOptionInput, opts ...request.Option) (*DeleteApplicationCloudWatchLoggingOptionOutput, error) {
	req, out := c.DeleteApplicationCloudWatchLoggingOptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationInputProcessingConfiguration = "DeleteApplicationInputProcessingConfiguration"

// DeleteApplicationInputProcessingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationInputProcessingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationInputProcessingConfiguration for more information on using the DeleteApplicationInputProcessingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationInputProcessingConfigurationRequest method.
//    req, resp := client.DeleteApplicationInputProcessingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DeleteApplicationInputProcessingConfiguration
func (c *KinesisAnalytics) DeleteApplicationInputProcessingConfigurationRequest(input *DeleteApplicationInputProcessingConfigurationInput) (req *request.Request, output *DeleteApplicationInputProcessingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationInputProcessingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInputProcessingConfigurationInput{}
	}

	output = &DeleteApplicationInputProcessingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplicationInputProcessingConfiguration API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Deletes an InputProcessingConfiguration (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html)
// from an input.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplicationInputProcessingConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DeleteApplicationInputProcessingConfiguration
func (c *KinesisAnalytics) DeleteApplicationInputProcessingConfiguration(input *DeleteApplicationInputProcessingConfigurationInput) (*DeleteApplicationInputProcessingConfigurationOutput, error) {
	req, out := c.DeleteApplicationInputProcessingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteApplicationInputProcessingConfigurationWithContext is the same as DeleteApplicationInputProcessingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationInputProcessingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) DeleteApplicationInputProcessingConfigurationWithContext(ctx aws.Context, input *DeleteApplicationInputProcessingConfigurationInput, opts ...request.Option) (*DeleteApplicationInputProcessingConfigurationOutput, error) {
	req, out := c.DeleteApplicationInputProcessingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationOutput = "DeleteApplicationOutput"

// DeleteApplicationOutputRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationOutput for more information on using the DeleteApplicationOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationOutputRequest method.
//    req, resp := client.DeleteApplicationOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DeleteApplicationOutput
func (c *KinesisAnalytics) DeleteApplicationOutputRequest(input *DeleteApplicationOutputInput) (req *request.Request, output *DeleteApplicationOutputOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationOutput,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationOutputInput{}
	}

	output = &DeleteApplicationOutputOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplicationOutput API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Deletes output destination configuration from your application configuration.
// Amazon Kinesis Analytics will no longer write data from the corresponding
// in-application stream to the external output destination.
//
// This operation requires permissions to perform the kinesisanalytics:DeleteApplicationOutput
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplicationOutput for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DeleteApplicationOutput
func (c *KinesisAnalytics) DeleteApplicationOutput(input *DeleteApplicationOutputInput) (*DeleteApplicationOutputOutput, error) {
	req, out := c.DeleteApplicationOutputRequest(input)
	return out, req.Send()
}

// DeleteApplicationOutputWithContext is the same as DeleteApplicationOutput with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) DeleteApplicationOutputWithContext(ctx aws.Context, input *DeleteApplicationOutputInput, opts ...request.Option) (*DeleteApplicationOutputOutput, error) {
	req, out := c.DeleteApplicationOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationReferenceDataSource = "DeleteApplicationReferenceDataSource"

// DeleteApplicationReferenceDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationReferenceDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationReferenceDataSource for more information on using the DeleteApplicationReferenceDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationReferenceDataSourceRequest method.
//    req, resp := client.DeleteApplicationReferenceDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DeleteApplicationReferenceDataSource
func (c *KinesisAnalytics) DeleteApplicationReferenceDataSourceRequest(input *DeleteApplicationReferenceDataSourceInput) (req *request.Request, output *DeleteApplicationReferenceDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationReferenceDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationReferenceDataSourceInput{}
	}

	output = &DeleteApplicationReferenceDataSourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplicationReferenceDataSource API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Deletes a reference data source configuration from the specified application
// configuration.
//
// If the application is running, Amazon Kinesis Analytics immediately removes
// the in-application table that you created using the AddApplicationReferenceDataSource
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html)
// operation.
//
// This operation requires permissions to perform the kinesisanalytics.DeleteApplicationReferenceDataSource
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplicationReferenceDataSource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DeleteApplicationReferenceDataSource
func (c *KinesisAnalytics) DeleteApplicationReferenceDataSource(input *DeleteApplicationReferenceDataSourceInput) (*DeleteApplicationReferenceDataSourceOutput, error) {
	req, out := c.DeleteApplicationReferenceDataSourceRequest(input)
	return out, req.Send()
}

// DeleteApplicationReferenceDataSourceWithContext is the same as DeleteApplicationReferenceDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationReferenceDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) DeleteApplicationReferenceDataSourceWithContext(ctx aws.Context, input *DeleteApplicationReferenceDataSourceInput, opts ...request.Option) (*DeleteApplicationReferenceDataSourceOutput, error) {
	req, out := c.DeleteApplicationReferenceDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplication = "DescribeApplication"

// DescribeApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplication for more information on using the DescribeApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationRequest method.
//    req, resp := client.DescribeApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DescribeApplication
func (c *KinesisAnalytics) DescribeApplicationRequest(input *DescribeApplicationInput) (req *request.Request, output *DescribeApplicationOutput) {
	op := &request.Operation{
		Name:       opDescribeApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationInput{}
	}

	output = &DescribeApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplication API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Returns information about a specific Amazon Kinesis Analytics application.
//
// If you want to retrieve a list of all applications in your account, use the
// ListApplications (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_ListApplications.html)
// operation.
//
// This operation requires permissions to perform the kinesisanalytics:DescribeApplication
// action. You can use DescribeApplication to get the current application versionId,
// which you need to call other operations such as Update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DescribeApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DescribeApplication
func (c *KinesisAnalytics) DescribeApplication(input *DescribeApplicationInput) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	return out, req.Send()
}

// DescribeApplicationWithContext is the same as DescribeApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) DescribeApplicationWithContext(ctx aws.Context, input *DescribeApplicationInput, opts ...request.Option) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDiscoverInputSchema = "DiscoverInputSchema"

// DiscoverInputSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DiscoverInputSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DiscoverInputSchema for more information on using the DiscoverInputSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DiscoverInputSchemaRequest method.
//    req, resp := client.DiscoverInputSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DiscoverInputSchema
func (c *KinesisAnalytics) DiscoverInputSchemaRequest(input *DiscoverInputSchemaInput) (req *request.Request, output *DiscoverInputSchemaOutput) {
	op := &request.Operation{
		Name:       opDiscoverInputSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DiscoverInputSchemaInput{}
	}

	output = &DiscoverInputSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DiscoverInputSchema API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Infers a schema by evaluating sample records on the specified streaming source
// (Amazon Kinesis stream or Amazon Kinesis Firehose delivery stream) or S3
// object. In the response, the operation returns the inferred schema and also
// the sample records that the operation used to infer the schema.
//
// You can use the inferred schema when configuring a streaming source for your
// application. For conceptual information, see Configuring Application Input
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
// Note that when you create an application using the Amazon Kinesis Analytics
// console, the console uses this operation to infer a schema and show it in
// the console user interface.
//
// This operation requires permissions to perform the kinesisanalytics:DiscoverInputSchema
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DiscoverInputSchema for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * UnableToDetectSchemaException
//   Data format is not valid. Amazon Kinesis Analytics is not able to detect
//   schema for the given streaming source.
//
//   * ResourceProvisionedThroughputExceededException
//   Discovery failed to get a record from the streaming source because of the
//   Amazon Kinesis Streams ProvisionedThroughputExceededException. For more information,
//   see GetRecords (https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetRecords.html)
//   in the Amazon Kinesis Streams API Reference.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DiscoverInputSchema
func (c *KinesisAnalytics) DiscoverInputSchema(input *DiscoverInputSchemaInput) (*DiscoverInputSchemaOutput, error) {
	req, out := c.DiscoverInputSchemaRequest(input)
	return out, req.Send()
}

// DiscoverInputSchemaWithContext is the same as DiscoverInputSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DiscoverInputSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) DiscoverInputSchemaWithContext(ctx aws.Context, input *DiscoverInputSchemaInput, opts ...request.Option) (*DiscoverInputSchemaOutput, error) {
	req, out := c.DiscoverInputSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationsRequest method.
//    req, resp := client.ListApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/ListApplications
func (c *KinesisAnalytics) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Returns a list of Amazon Kinesis Analytics applications in your account.
// For each application, the response includes the application name, Amazon
// Resource Name (ARN), and status. If the response returns the HasMoreApplications
// value as true, you can send another request by adding the ExclusiveStartApplicationName
// in the request body, and set the value of this to the last application name
// from the previous response.
//
// If you want detailed information about a specific application, use DescribeApplication
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html).
//
// This operation requires permissions to perform the kinesisanalytics:ListApplications
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation ListApplications for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/ListApplications
func (c *KinesisAnalytics) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/ListTagsForResource
func (c *KinesisAnalytics) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Kinesis Analytics.
//
// Retrieves the list of key-value tags assigned to the application. For more
// information, see Using Tagging (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/ListTagsForResource
func (c *KinesisAnalytics) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartApplication = "StartApplication"

// StartApplicationRequest generates a "aws/request.Request" representing the
// client's request for the StartApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartApplication for more information on using the StartApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartApplicationRequest method.
//    req, resp := client.StartApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/StartApplication
func (c *KinesisAnalytics) StartApplicationRequest(input *StartApplicationInput) (req *request.Request, output *StartApplicationOutput) {
	op := &request.Operation{
		Name:       opStartApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartApplicationInput{}
	}

	output = &StartApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartApplication API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Starts the specified Amazon Kinesis Analytics application. After creating
// an application, you must exclusively call this operation to start your application.
//
// After the application starts, it begins consuming the input data, processes
// it, and writes the output to the configured destination.
//
// The application status must be READY for you to start an application. You
// can get the application status in the console or using the DescribeApplication
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
// operation.
//
// After you start the application, you can stop the application from processing
// the input by calling the StopApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_StopApplication.html)
// operation.
//
// This operation requires permissions to perform the kinesisanalytics:StartApplication
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation StartApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * InvalidApplicationConfigurationException
//   User-provided application configuration is not valid.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/StartApplication
func (c *KinesisAnalytics) StartApplication(input *StartApplicationInput) (*StartApplicationOutput, error) {
	req, out := c.StartApplicationRequest(input)
	return out, req.Send()
}

// StartApplicationWithContext is the same as StartApplication with the addition of
// the ability to pass a context and additional request options.
//
// See StartApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) StartApplicationWithContext(ctx aws.Context, input *StartApplicationInput, opts ...request.Option) (*StartApplicationOutput, error) {
	req, out := c.StartApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopApplication = "StopApplication"

// StopApplicationRequest generates a "aws/request.Request" representing the
// client's request for the StopApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopApplication for more information on using the StopApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopApplicationRequest method.
//    req, resp := client.StopApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/StopApplication
func (c *KinesisAnalytics) StopApplicationRequest(input *StopApplicationInput) (req *request.Request, output *StopApplicationOutput) {
	op := &request.Operation{
		Name:       opStopApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopApplicationInput{}
	}

	output = &StopApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopApplication API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Stops the application from processing input data. You can stop an application
// only if it is in the running state. You can use the DescribeApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
// operation to find the application state. After the application is stopped,
// Amazon Kinesis Analytics stops reading data from the input, the application
// stops processing data, and there is no output written to the destination.
//
// This operation requires permissions to perform the kinesisanalytics:StopApplication
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation StopApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/StopApplication
func (c *KinesisAnalytics) StopApplication(input *StopApplicationInput) (*StopApplicationOutput, error) {
	req, out := c.StopApplicationRequest(input)
	return out, req.Send()
}

// StopApplicationWithContext is the same as StopApplication with the addition of
// the ability to pass a context and additional request options.
//
// See StopApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) StopApplicationWithContext(ctx aws.Context, input *StopApplicationInput, opts ...request.Option) (*StopApplicationOutput, error) {
	req, out := c.StopApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/TagResource
func (c *KinesisAnalytics) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Kinesis Analytics.
//
// Adds one or more key-value tags to a Kinesis Analytics application. Note
// that the maximum number of application tags includes system tags. The maximum
// number of user-defined application tags is 50. For more information, see
// Using Tagging (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * TooManyTagsException
//   Application created with too many tags, or too many tags added to an application.
//   Note that the maximum number of application tags includes system tags. The
//   maximum number of user-defined application tags is 50.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/TagResource
func (c *KinesisAnalytics) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/UntagResource
func (c *KinesisAnalytics) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Kinesis Analytics.
//
// Removes one or more tags from a Kinesis Analytics application. For more information,
// see Using Tagging (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * TooManyTagsException
//   Application created with too many tags, or too many tags added to an application.
//   Note that the maximum number of application tags includes system tags. The
//   maximum number of user-defined application tags is 50.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/UntagResource
func (c *KinesisAnalytics) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationRequest method.
//    req, resp := client.UpdateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/UpdateApplication
func (c *KinesisAnalytics) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateApplication API operation for Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Updates an existing Amazon Kinesis Analytics application. Using this API,
// you can update application code, input configuration, and output configuration.
//
// Note that Amazon Kinesis Analytics updates the CurrentApplicationVersionId
// each time you update your application.
//
// This operation requires permission for the kinesisanalytics:UpdateApplication
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Types:
//   * CodeValidationException
//   User-provided application code (query) is invalid. This can be a simple syntax
//   error.
//
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   Application is not available for this operation.
//
//   * InvalidArgumentException
//   Specified input parameter value is invalid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modification to an application.
//   For example, two individuals attempting to edit the same application at the
//   same time.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/UpdateApplication
func (c *KinesisAnalytics) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalytics) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddApplicationCloudWatchLoggingOptionInput struct {
	_ struct{} `type:"structure"`

	// The Kinesis Analytics application name.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM
	// role ARN. Note: To write application messages to CloudWatch, the IAM role
	// that is used must have the PutLogEvents policy action enabled.
	//
	// CloudWatchLoggingOption is a required field
	CloudWatchLoggingOption *CloudWatchLoggingOption `type:"structure" required:"true"`

	// The version ID of the Kinesis Analytics application.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s AddApplicationCloudWatchLoggingOptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddApplicationCloudWatchLoggingOptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationCloudWatchLoggingOptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddApplicationCloudWatchLoggingOptionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CloudWatchLoggingOption == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLoggingOption"))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.CloudWatchLoggingOption != nil {
		if err := s.CloudWatchLoggingOption.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLoggingOption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AddApplicationCloudWatchLoggingOptionInput) SetApplicationName(v string) *AddApplicationCloudWatchLoggingOptionInput {
	s.ApplicationName = &v
	return s
}

// SetCloudWatchLoggingOption sets the CloudWatchLoggingOption field's value.
func (s *AddApplicationCloudWatchLoggingOptionInput) SetCloudWatchLoggingOption(v *CloudWatchLoggingOption) *AddApplicationCloudWatchLoggingOptionInput {
	s.CloudWatchLoggingOption = v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *AddApplicationCloudWatchLoggingOptionInput) SetCurrentApplicationVersionId(v int64) *AddApplicationCloudWatchLoggingOptionInput {
	s.CurrentApplicationVersionId = &v
	return s
}

type AddApplicationCloudWatchLoggingOptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddApplicationCloudWatchLoggingOptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddApplicationCloudWatchLoggingOptionOutput) GoString() string {
	return s.String()
}

type AddApplicationInputInput struct {
	_ struct{} `type:"structure"`

	// Name of your existing Amazon Kinesis Analytics application to which you want
	// to add the streaming source.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Current version of your Amazon Kinesis Analytics application. You can use
	// the DescribeApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation to find the current application version.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_Input.html)
	// to add.
	//
	// Input is a required field
	Input *Input `type:"structure" required:"true"`
}

// String returns the string representation
func (s AddApplicationInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddApplicationInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddApplicationInputInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.Input == nil {
		invalidParams.Add(request.NewErrParamRequired("Input"))
	}
	if s.Input != nil {
		if err := s.Input.Validate(); err != nil {
			invalidParams.AddNested("Input", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AddApplicationInputInput) SetApplicationName(v string) *AddApplicationInputInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *AddApplicationInputInput) SetCurrentApplicationVersionId(v int64) *AddApplicationInputInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetInput sets the Input field's value.
func (s *AddApplicationInputInput) SetInput(v *Input) *AddApplicationInputInput {
	s.Input = v
	return s
}

type AddApplicationInputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddApplicationInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddApplicationInputOutput) GoString() string {
	return s.String()
}

type AddApplicationInputProcessingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Name of the application to which you want to add the input processing configuration.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Version of the application to which you want to add the input processing
	// configuration. You can use the DescribeApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation to get the current application version. If the version specified
	// is not the current version, the ConcurrentModificationException is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The ID of the input configuration to add the input processing configuration
	// to. You can get a list of the input IDs for an application using the DescribeApplication
	// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation.
	//
	// InputId is a required field
	InputId *string `min:"1" type:"string" required:"true"`

	// The InputProcessingConfiguration (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html)
	// to add to the application.
	//
	// InputProcessingConfiguration is a required field
	InputProcessingConfiguration *InputProcessingConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s AddApplicationInputProcessingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddApplicationInputProcessingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationInputProcessingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddApplicationInputProcessingConfigurationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}
	if s.InputProcessingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InputProcessingConfiguration"))
	}
	if s.InputProcessingConfiguration != nil {
		if err := s.InputProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AddApplicationInputProcessingConfigurationInput) SetApplicationName(v string) *AddApplicationInputProcessingConfigurationInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *AddApplicationInputProcessingConfigurationInput) SetCurrentApplicationVersionId(v int64) *AddApplicationInputProcessingConfigurationInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetInputId sets the InputId field's value.
func (s *AddApplicationInputProcessingConfigurationInput) SetInputId(v string) *AddApplicationInputProcessingConfigurationInput {
	s.InputId = &v
	return s
}

// SetInputProcessingConfiguration sets the InputProcessingConfiguration field's value.
func (s *AddApplicationInputProcessingConfigurationInput) SetInputProcessingConfiguration(v *InputProcessingConfiguration) *AddApplicationInputProcessingConfigurationInput {
	s.InputProcessingConfiguration = v
	return s
}

type AddApplicationInputProcessingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddApplicationInputProcessingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddApplicationInputProcessingConfigurationOutput) GoString() string {
	return s.String()
}

type AddApplicationOutputInput struct {
	_ struct{} `type:"structure"`

	// Name of the application to which you want to add the output configuration.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Version of the application to which you want to add the output configuration.
	// You can use the DescribeApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation to get the current application version. If the version specified
	// is not the current version, the ConcurrentModificationException is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// An array of objects, each describing one output configuration. In the output
	// configuration, you specify the name of an in-application stream, a destination
	// (that is, an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream,
	// or an AWS Lambda function), and record the formation to use when writing
	// to the destination.
	//
	// Output is a required field
	Output *Output `type:"structure" required:"true"`
}

// String returns the string representation
func (s AddApplicationOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddApplicationOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddApplicationOutputInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.Output == nil {
		invalidParams.Add(request.NewErrParamRequired("Output"))
	}
	if s.Output != nil {
		if err := s.Output.Validate(); err != nil {
			invalidParams.AddNested("Output", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AddApplicationOutputInput) SetApplicationName(v string) *AddApplicationOutputInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *AddApplicationOutputInput) SetCurrentApplicationVersionId(v int64) *AddApplicationOutputInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *AddApplicationOutputInput) SetOutput(v *Output) *AddApplicationOutputInput {
	s.Output = v
	return s
}

type AddApplicationOutputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddApplicationOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddApplicationOutputOutput) GoString() string {
	return s.String()
}

type AddApplicationReferenceDataSourceInput struct {
	_ struct{} `type:"structure"`

	// Name of an existing application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Version of the application for which you are adding the reference data source.
	// You can use the DescribeApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation to get the current application version. If the version specified
	// is not the current version, the ConcurrentModificationException is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The reference data source can be an object in your Amazon S3 bucket. Amazon
	// Kinesis Analytics reads the object and copies the data into the in-application
	// table that is created. You provide an S3 bucket, object key name, and the
	// resulting in-application table that is created. You must also provide an
	// IAM role with the necessary permissions that Amazon Kinesis Analytics can
	// assume to read the object from your S3 bucket on your behalf.
	//
	// ReferenceDataSource is a required field
	ReferenceDataSource *ReferenceDataSource `type:"structure" required:"true"`
}

// String returns the string representation
func (s AddApplicationReferenceDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddApplicationReferenceDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationReferenceDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddApplicationReferenceDataSourceInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.ReferenceDataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceDataSource"))
	}
	if s.ReferenceDataSource != nil {
		if err := s.ReferenceDataSource.Validate(); err != nil {
			invalidParams.AddNested("ReferenceDataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AddApplicationReferenceDataSourceInput) SetApplicationName(v string) *AddApplicationReferenceDataSourceInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *AddApplicationReferenceDataSourceInput) SetCurrentApplicationVersionId(v int64) *AddApplicationReferenceDataSourceInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetReferenceDataSource sets the ReferenceDataSource field's value.
func (s *AddApplicationReferenceDataSourceInput) SetReferenceDataSource(v *ReferenceDataSource) *AddApplicationReferenceDataSourceInput {
	s.ReferenceDataSource = v
	return s
}

type AddApplicationReferenceDataSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddApplicationReferenceDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddApplicationReferenceDataSourceOutput) GoString() string {
	return s.String()
}

//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Provides a description of the application, including the application Amazon
// Resource Name (ARN), status, latest version, and input and output configuration.
type ApplicationDetail struct {
	_ struct{} `type:"structure"`

	// ARN of the application.
	//
	// ApplicationARN is a required field
	ApplicationARN *string `min:"1" type:"string" required:"true"`

	// Returns the application code that you provided to perform data analysis on
	// any of the in-application streams in your application.
	ApplicationCode *string `type:"string"`

	// Description of the application.
	ApplicationDescription *string `type:"string"`

	// Name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Status of the application.
	//
	// ApplicationStatus is a required field
	ApplicationStatus *string `type:"string" required:"true" enum:"ApplicationStatus"`

	// Provides the current application version.
	//
	// ApplicationVersionId is a required field
	ApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// Describes the CloudWatch log streams that are configured to receive application
	// messages. For more information about using CloudWatch log streams with Amazon
	// Kinesis Analytics applications, see Working with Amazon CloudWatch Logs (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
	CloudWatchLoggingOptionDescriptions []*CloudWatchLoggingOptionDescription `type:"list"`

	// Time stamp when the application version was created.
	CreateTimestamp *time.Time `type:"timestamp"`

	// Describes the application input configuration. For more information, see
	// Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
	InputDescriptions []*InputDescription `type:"list"`

	// Time stamp when the application was last updated.
	LastUpdateTimestamp *time.Time `type:"timestamp"`

	// Describes the application output configuration. For more information, see
	// Configuring Application Output (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
	OutputDescriptions []*OutputDescription `type:"list"`

	// Describes reference data sources configured for the application. For more
	// information, see Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
	ReferenceDataSourceDescriptions []*ReferenceDataSourceDescription `type:"list"`
}

// String returns the string representation
func (s ApplicationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationDetail) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *ApplicationDetail) SetApplicationARN(v string) *ApplicationDetail {
	s.ApplicationARN = &v
	return s
}

// SetApplicationCode sets the ApplicationCode field's value.
func (s *ApplicationDetail) SetApplicationCode(v string) *ApplicationDetail {
	s.ApplicationCode = &v
	return s
}

// SetApplicationDescription sets the ApplicationDescription field's value.
func (s *ApplicationDetail) SetApplicationDescription(v string) *ApplicationDetail {
	s.ApplicationDescription = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ApplicationDetail) SetApplicationName(v string) *ApplicationDetail {
	s.ApplicationName = &v
	return s
}

// SetApplicationStatus sets the ApplicationStatus field's value.
func (s *ApplicationDetail) SetApplicationStatus(v string) *ApplicationDetail {
	s.ApplicationStatus = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *ApplicationDetail) SetApplicationVersionId(v int64) *ApplicationDetail {
	s.ApplicationVersionId = &v
	return s
}

// SetCloudWatchLoggingOptionDescriptions sets the CloudWatchLoggingOptionDescriptions field's value.
func (s *ApplicationDetail) SetCloudWatchLoggingOptionDescriptions(v []*CloudWatchLoggingOptionDescription) *ApplicationDetail {
	s.CloudWatchLoggingOptionDescriptions = v
	return s
}

// SetCreateTimestamp sets the CreateTimestamp field's value.
func (s *ApplicationDetail) SetCreateTimestamp(v time.Time) *ApplicationDetail {
	s.CreateTimestamp = &v
	return s
}

// SetInputDescriptions sets the InputDescriptions field's value.
func (s *ApplicationDetail) SetInputDescriptions(v []*InputDescription) *ApplicationDetail {
	s.InputDescriptions = v
	return s
}

// SetLastUpdateTimestamp sets the LastUpdateTimestamp field's value.
func (s *ApplicationDetail) SetLastUpdateTimestamp(v time.Time) *ApplicationDetail {
	s.LastUpdateTimestamp = &v
	return s
}

// SetOutputDescriptions sets the OutputDescriptions field's value.
func (s *ApplicationDetail) SetOutputDescriptions(v []*OutputDescription) *ApplicationDetail {
	s.OutputDescriptions = v
	return s
}

// SetReferenceDataSourceDescriptions sets the ReferenceDataSourceDescriptions field's value.
func (s *ApplicationDetail) SetReferenceDataSourceDescriptions(v []*ReferenceDataSourceDescription) *ApplicationDetail {
	s.ReferenceDataSourceDescriptions = v
	return s
}

//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Provides application summary information, including the application Amazon
// Resource Name (ARN), name, and status.
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// ARN of the application.
	//
	// ApplicationARN is a required field
	ApplicationARN *string `min:"1" type:"string" required:"true"`

	// Name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Status of the application.
	//
	// ApplicationStatus is a required field
	ApplicationStatus *string `type:"string" required:"true" enum:"ApplicationStatus"`
}

// String returns the string representation
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationSummary) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *ApplicationSummary) SetApplicationARN(v string) *ApplicationSummary {
	s.ApplicationARN = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ApplicationSummary) SetApplicationName(v string) *ApplicationSummary {
	s.ApplicationName = &v
	return s
}

// SetApplicationStatus sets the ApplicationStatus field's value.
func (s *ApplicationSummary) SetApplicationStatus(v string) *ApplicationSummary {
	s.ApplicationStatus = &v
	return s
}

// Describes updates to apply to an existing Amazon Kinesis Analytics application.
type ApplicationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes application code updates.
	ApplicationCodeUpdate *string `type:"string"`

	// Describes application CloudWatch logging option updates.
	CloudWatchLoggingOptionUpdates []*CloudWatchLoggingOptionUpdate `type:"list"`

	// Describes application input configuration updates.
	InputUpdates []*InputUpdate `type:"list"`

	// Describes application output configuration updates.
	OutputUpdates []*OutputUpdate `type:"list"`

	// Describes application reference data source updates.
	ReferenceDataSourceUpdates []*ReferenceDataSourceUpdate `type:"list"`
}

// String returns the string representation
func (s ApplicationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationUpdate"}
	if s.CloudWatchLoggingOptionUpdates != nil {
		for i, v := range s.CloudWatchLoggingOptionUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CloudWatchLoggingOptionUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InputUpdates != nil {
		for i, v := range s.InputUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputUpdates != nil {
		for i, v := range s.OutputUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ReferenceDataSourceUpdates != nil {
		for i, v := range s.ReferenceDataSourceUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReferenceDataSourceUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationCodeUpdate sets the ApplicationCodeUpdate field's value.
func (s *ApplicationUpdate) SetApplicationCodeUpdate(v string) *ApplicationUpdate {
	s.ApplicationCodeUpdate = &v
	return s
}

// SetCloudWatchLoggingOptionUpdates sets the CloudWatchLoggingOptionUpdates field's value.
func (s *ApplicationUpdate) SetCloudWatchLoggingOptionUpdates(v []*CloudWatchLoggingOptionUpdate) *ApplicationUpdate {
	s.CloudWatchLoggingOptionUpdates = v
	return s
}

// SetInputUpdates sets the InputUpdates field's value.
func (s *ApplicationUpdate) SetInputUpdates(v []*InputUpdate) *ApplicationUpdate {
	s.InputUpdates = v
	return s
}

// SetOutputUpdates sets the OutputUpdates field's value.
func (s *ApplicationUpdate) SetOutputUpdates(v []*OutputUpdate) *ApplicationUpdate {
	s.OutputUpdates = v
	return s
}

// SetReferenceDataSourceUpdates sets the ReferenceDataSourceUpdates field's value.
func (s *ApplicationUpdate) SetReferenceDataSourceUpdates(v []*ReferenceDataSourceUpdate) *ApplicationUpdate {
	s.ReferenceDataSourceUpdates = v
	return s
}

// Provides additional mapping information when the record format uses delimiters,
// such as CSV. For example, the following sample records use CSV format, where
// the records use the '\n' as the row delimiter and a comma (",") as the column
// delimiter:
//
// "name1", "address1"
//
// "name2", "address2"
type CSVMappingParameters struct {
	_ struct{} `type:"structure"`

	// Column delimiter. For example, in a CSV format, a comma (",") is the typical
	// column delimiter.
	//
	// RecordColumnDelimiter is a required field
	RecordColumnDelimiter *string `min:"1" type:"string" required:"true"`

	// Row delimiter. For example, in a CSV format, '\n' is the typical row delimiter.
	//
	// RecordRowDelimiter is a required field
	RecordRowDelimiter *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CSVMappingParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CSVMappingParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CSVMappingParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CSVMappingParameters"}
	if s.RecordColumnDelimiter == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordColumnDelimiter"))
	}
	if s.RecordColumnDelimiter != nil && len(*s.RecordColumnDelimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecordColumnDelimiter", 1))
	}
	if s.RecordRowDelimiter == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordRowDelimiter"))
	}
	if s.RecordRowDelimiter != nil && len(*s.RecordRowDelimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecordRowDelimiter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordColumnDelimiter sets the RecordColumnDelimiter field's value.
func (s *CSVMappingParameters) SetRecordColumnDelimiter(v string) *CSVMappingParameters {
	s.RecordColumnDelimiter = &v
	return s
}

// SetRecordRowDelimiter sets the RecordRowDelimiter field's value.
func (s *CSVMappingParameters) SetRecordRowDelimiter(v string) *CSVMappingParameters {
	s.RecordRowDelimiter = &v
	return s
}

// Provides a description of CloudWatch logging options, including the log stream
// Amazon Resource Name (ARN) and the role ARN.
type CloudWatchLoggingOption struct {
	_ struct{} `type:"structure"`

	// ARN of the CloudWatch log to receive application messages.
	//
	// LogStreamARN is a required field
	LogStreamARN *string `min:"1" type:"string" required:"true"`

	// IAM ARN of the role to use to send application messages. Note: To write application
	// messages to CloudWatch, the IAM role that is used must have the PutLogEvents
	// policy action enabled.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudWatchLoggingOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchLoggingOption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLoggingOption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLoggingOption"}
	if s.LogStreamARN == nil {
		invalidParams.Add(request.NewErrParamRequired("LogStreamARN"))
	}
	if s.LogStreamARN != nil && len(*s.LogStreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogStreamARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogStreamARN sets the LogStreamARN field's value.
func (s *CloudWatchLoggingOption) SetLogStreamARN(v string) *CloudWatchLoggingOption {
	s.LogStreamARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CloudWatchLoggingOption) SetRoleARN(v string) *CloudWatchLoggingOption {
	s.RoleARN = &v
	return s
}

// Description of the CloudWatch logging option.
type CloudWatchLoggingOptionDescription struct {
	_ struct{} `type:"structure"`

	// ID of the CloudWatch logging option description.
	CloudWatchLoggingOptionId *string `min:"1" type:"string"`

	// ARN of the CloudWatch log to receive application messages.
	//
	// LogStreamARN is a required field
	LogStreamARN *string `min:"1" type:"string" required:"true"`

	// IAM ARN of the role to use to send application messages. Note: To write application
	// messages to CloudWatch, the IAM role used must have the PutLogEvents policy
	// action enabled.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudWatchLoggingOptionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchLoggingOptionDescription) GoString() string {
	return s.String()
}

// SetCloudWatchLoggingOptionId sets the CloudWatchLoggingOptionId field's value.
func (s *CloudWatchLoggingOptionDescription) SetCloudWatchLoggingOptionId(v string) *CloudWatchLoggingOptionDescription {
	s.CloudWatchLoggingOptionId = &v
	return s
}

// SetLogStreamARN sets the LogStreamARN field's value.
func (s *CloudWatchLoggingOptionDescription) SetLogStreamARN(v string) *CloudWatchLoggingOptionDescription {
	s.LogStreamARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CloudWatchLoggingOptionDescription) SetRoleARN(v string) *CloudWatchLoggingOptionDescription {
	s.RoleARN = &v
	return s
}

// Describes CloudWatch logging option updates.
type CloudWatchLoggingOptionUpdate struct {
	_ struct{} `type:"structure"`

	// ID of the CloudWatch logging option to update
	//
	// CloudWatchLoggingOptionId is a required field
	CloudWatchLoggingOptionId *string `min:"1" type:"string" required:"true"`

	// ARN of the CloudWatch log to receive application messages.
	LogStreamARNUpdate *string `min:"1" type:"string"`

	// IAM ARN of the role to use to send application messages. Note: To write application
	// messages to CloudWatch, the IAM role used must have the PutLogEvents policy
	// action enabled.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CloudWatchLoggingOptionUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchLoggingOptionUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLoggingOptionUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLoggingOptionUpdate"}
	if s.CloudWatchLoggingOptionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLoggingOptionId"))
	}
	if s.CloudWatchLoggingOptionId != nil && len(*s.CloudWatchLoggingOptionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLoggingOptionId", 1))
	}
	if s.LogStreamARNUpdate != nil && len(*s.LogStreamARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogStreamARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLoggingOptionId sets the CloudWatchLoggingOptionId field's value.
func (s *CloudWatchLoggingOptionUpdate) SetCloudWatchLoggingOptionId(v string) *CloudWatchLoggingOptionUpdate {
	s.CloudWatchLoggingOptionId = &v
	return s
}

// SetLogStreamARNUpdate sets the LogStreamARNUpdate field's value.
func (s *CloudWatchLoggingOptionUpdate) SetLogStreamARNUpdate(v string) *CloudWatchLoggingOptionUpdate {
	s.LogStreamARNUpdate = &v
	return s
}

// SetRoleARNUpdate sets the RoleARNUpdate field's value.
func (s *CloudWatchLoggingOptionUpdate) SetRoleARNUpdate(v string) *CloudWatchLoggingOptionUpdate {
	s.RoleARNUpdate = &v
	return s
}

// User-provided application code (query) is invalid. This can be a simple syntax
// error.
type CodeValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Test
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s CodeValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeValidationException) GoString() string {
	return s.String()
}

func newErrorCodeValidationException(v protocol.ResponseMetadata) error {
	return &CodeValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CodeValidationException) Code() string {
	return "CodeValidationException"
}

// Message returns the exception's message.
func (s *CodeValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CodeValidationException) OrigErr() error {
	return nil
}

func (s *CodeValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CodeValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CodeValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Exception thrown as a result of concurrent modification to an application.
// For example, two individuals attempting to edit the same application at the
// same time.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// TBD
type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// One or more SQL statements that read input data, transform it, and generate
	// output. For example, you can write a SQL statement that reads data from one
	// in-application stream, generates a running average of the number of advertisement
	// clicks by vendor, and insert resulting rows in another in-application stream
	// using pumps. For more information about the typical pattern, see Application
	// Code (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html).
	//
	// You can provide such series of SQL statements, where output of one statement
	// can be used as the input for the next statement. You store intermediate results
	// by creating in-application streams and pumps.
	//
	// Note that the application code must create the streams with names specified
	// in the Outputs. For example, if your Outputs defines output streams named
	// ExampleOutputStream1 and ExampleOutputStream2, then your application code
	// must create these streams.
	ApplicationCode *string `type:"string"`

	// Summary description of the application.
	ApplicationDescription *string `type:"string"`

	// Name of your Amazon Kinesis Analytics application (for example, sample-app).
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Use this parameter to configure a CloudWatch log stream to monitor application
	// configuration errors. For more information, see Working with Amazon CloudWatch
	// Logs (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
	CloudWatchLoggingOptions []*CloudWatchLoggingOption `type:"list"`

	// Use this parameter to configure the application input.
	//
	// You can configure your application to receive input from a single streaming
	// source. In this configuration, you map this streaming source to an in-application
	// stream that is created. Your application code can then query the in-application
	// stream like a table (you can think of it as a constantly updating table).
	//
	// For the streaming source, you provide its Amazon Resource Name (ARN) and
	// format of data on the stream (for example, JSON, CSV, etc.). You also must
	// provide an IAM role that Amazon Kinesis Analytics can assume to read this
	// stream on your behalf.
	//
	// To create the in-application stream, you need to specify a schema to transform
	// your data into a schematized version used in SQL. In the schema, you provide
	// the necessary mapping of the data elements in the streaming source to record
	// columns in the in-app stream.
	Inputs []*Input `type:"list"`

	// You can configure application output to write data from any of the in-application
	// streams to up to three destinations.
	//
	// These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose
	// delivery streams, AWS Lambda destinations, or any combination of the three.
	//
	// In the configuration, you specify the in-application stream name, the destination
	// stream or Lambda function Amazon Resource Name (ARN), and the format to use
	// when writing data. You must also provide an IAM role that Amazon Kinesis
	// Analytics can assume to write to the destination stream or Lambda function
	// on your behalf.
	//
	// In the output configuration, you also provide the output stream or Lambda
	// function ARN. For stream destinations, you provide the format of data in
	// the stream (for example, JSON, CSV). You also must provide an IAM role that
	// Amazon Kinesis Analytics can assume to write to the stream or Lambda function
	// on your behalf.
	Outputs []*Output `type:"list"`

	// A list of one or more tags to assign to the application. A tag is a key-value
	// pair that identifies an application. Note that the maximum number of application
	// tags includes system tags. The maximum number of user-defined application
	// tags is 50. For more information, see Using Tagging (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.CloudWatchLoggingOptions != nil {
		for i, v := range s.CloudWatchLoggingOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CloudWatchLoggingOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Inputs != nil {
		for i, v := range s.Inputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Inputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationCode sets the ApplicationCode field's value.
func (s *CreateApplicationInput) SetApplicationCode(v string) *CreateApplicationInput {
	s.ApplicationCode = &v
	return s
}

// SetApplicationDescription sets the ApplicationDescription field's value.
func (s *CreateApplicationInput) SetApplicationDescription(v string) *CreateApplicationInput {
	s.ApplicationDescription = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateApplicationInput) SetApplicationName(v string) *CreateApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *CreateApplicationInput) SetCloudWatchLoggingOptions(v []*CloudWatchLoggingOption) *CreateApplicationInput {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *CreateApplicationInput) SetInputs(v []*Input) *CreateApplicationInput {
	s.Inputs = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *CreateApplicationInput) SetOutputs(v []*Output) *CreateApplicationInput {
	s.Outputs = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v []*Tag) *CreateApplicationInput {
	s.Tags = v
	return s
}

// TBD
type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// In response to your CreateApplication request, Amazon Kinesis Analytics returns
	// a response with a summary of the application it created, including the application
	// Amazon Resource Name (ARN), name, and status.
	//
	// ApplicationSummary is a required field
	ApplicationSummary *ApplicationSummary `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationSummary sets the ApplicationSummary field's value.
func (s *CreateApplicationOutput) SetApplicationSummary(v *ApplicationSummary) *CreateApplicationOutput {
	s.ApplicationSummary = v
	return s
}

type DeleteApplicationCloudWatchLoggingOptionInput struct {
	_ struct{} `type:"structure"`

	// The Kinesis Analytics application name.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The CloudWatchLoggingOptionId of the CloudWatch logging option to delete.
	// You can get the CloudWatchLoggingOptionId by using the DescribeApplication
	// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation.
	//
	// CloudWatchLoggingOptionId is a required field
	CloudWatchLoggingOptionId *string `min:"1" type:"string" required:"true"`

	// The version ID of the Kinesis Analytics application.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationCloudWatchLoggingOptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationCloudWatchLoggingOptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationCloudWatchLoggingOptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationCloudWatchLoggingOptionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CloudWatchLoggingOptionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLoggingOptionId"))
	}
	if s.CloudWatchLoggingOptionId != nil && len(*s.CloudWatchLoggingOptionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLoggingOptionId", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationCloudWatchLoggingOptionInput) SetApplicationName(v string) *DeleteApplicationCloudWatchLoggingOptionInput {
	s.ApplicationName = &v
	return s
}

// SetCloudWatchLoggingOptionId sets the CloudWatchLoggingOptionId field's value.
func (s *DeleteApplicationCloudWatchLoggingOptionInput) SetCloudWatchLoggingOptionId(v string) *DeleteApplicationCloudWatchLoggingOptionInput {
	s.CloudWatchLoggingOptionId = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *DeleteApplicationCloudWatchLoggingOptionInput) SetCurrentApplicationVersionId(v int64) *DeleteApplicationCloudWatchLoggingOptionInput {
	s.CurrentApplicationVersionId = &v
	return s
}

type DeleteApplicationCloudWatchLoggingOptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationCloudWatchLoggingOptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationCloudWatchLoggingOptionOutput) GoString() string {
	return s.String()
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure"`

	// Name of the Amazon Kinesis Analytics application to delete.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// You can use the DescribeApplication operation to get this value.
	//
	// CreateTimestamp is a required field
	CreateTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CreateTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("CreateTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationInput) SetApplicationName(v string) *DeleteApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetCreateTimestamp sets the CreateTimestamp field's value.
func (s *DeleteApplicationInput) SetCreateTimestamp(v time.Time) *DeleteApplicationInput {
	s.CreateTimestamp = &v
	return s
}

type DeleteApplicationInputProcessingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Kinesis Analytics application name.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The version ID of the Kinesis Analytics application.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The ID of the input configuration from which to delete the input processing
	// configuration. You can get a list of the input IDs for an application by
	// using the DescribeApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation.
	//
	// InputId is a required field
	InputId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationInputProcessingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInputProcessingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInputProcessingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInputProcessingConfigurationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationInputProcessingConfigurationInput) SetApplicationName(v string) *DeleteApplicationInputProcessingConfigurationInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *DeleteApplicationInputProcessingConfigurationInput) SetCurrentApplicationVersionId(v int64) *DeleteApplicationInputProcessingConfigurationInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetInputId sets the InputId field's value.
func (s *DeleteApplicationInputProcessingConfigurationInput) SetInputId(v string) *DeleteApplicationInputProcessingConfigurationInput {
	s.InputId = &v
	return s
}

type DeleteApplicationInputProcessingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationInputProcessingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInputProcessingConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type DeleteApplicationOutputInput struct {
	_ struct{} `type:"structure"`

	// Amazon Kinesis Analytics application name.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Amazon Kinesis Analytics application version. You can use the DescribeApplication
	// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation to get the current application version. If the version specified
	// is not the current version, the ConcurrentModificationException is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The ID of the configuration to delete. Each output configuration that is
	// added to the application, either when the application is created or later
	// using the AddApplicationOutput (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationOutput.html)
	// operation, has a unique ID. You need to provide the ID to uniquely identify
	// the output configuration that you want to delete from the application configuration.
	// You can use the DescribeApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation to get the specific OutputId.
	//
	// OutputId is a required field
	OutputId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationOutputInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.OutputId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputId"))
	}
	if s.OutputId != nil && len(*s.OutputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationOutputInput) SetApplicationName(v string) *DeleteApplicationOutputInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *DeleteApplicationOutputInput) SetCurrentApplicationVersionId(v int64) *DeleteApplicationOutputInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetOutputId sets the OutputId field's value.
func (s *DeleteApplicationOutputInput) SetOutputId(v string) *DeleteApplicationOutputInput {
	s.OutputId = &v
	return s
}

type DeleteApplicationOutputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutputOutput) GoString() string {
	return s.String()
}

type DeleteApplicationReferenceDataSourceInput struct {
	_ struct{} `type:"structure"`

	// Name of an existing application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Version of the application. You can use the DescribeApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation to get the current application version. If the version specified
	// is not the current version, the ConcurrentModificationException is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// ID of the reference data source. When you add a reference data source to
	// your application using the AddApplicationReferenceDataSource (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html),
	// Amazon Kinesis Analytics assigns an ID. You can use the DescribeApplication
	// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation to get the reference ID.
	//
	// ReferenceId is a required field
	ReferenceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationReferenceDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationReferenceDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationReferenceDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationReferenceDataSourceInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.ReferenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceId"))
	}
	if s.ReferenceId != nil && len(*s.ReferenceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationReferenceDataSourceInput) SetApplicationName(v string) *DeleteApplicationReferenceDataSourceInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *DeleteApplicationReferenceDataSourceInput) SetCurrentApplicationVersionId(v int64) *DeleteApplicationReferenceDataSourceInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *DeleteApplicationReferenceDataSourceInput) SetReferenceId(v string) *DeleteApplicationReferenceDataSourceInput {
	s.ReferenceId = &v
	return s
}

type DeleteApplicationReferenceDataSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationReferenceDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationReferenceDataSourceOutput) GoString() string {
	return s.String()
}

type DescribeApplicationInput struct {
	_ struct{} `type:"structure"`

	// Name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DescribeApplicationInput) SetApplicationName(v string) *DescribeApplicationInput {
	s.ApplicationName = &v
	return s
}

type DescribeApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Provides a description of the application, such as the application Amazon
	// Resource Name (ARN), status, latest version, and input and output configuration
	// details.
	//
	// ApplicationDetail is a required field
	ApplicationDetail *ApplicationDetail `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationDetail sets the ApplicationDetail field's value.
func (s *DescribeApplicationOutput) SetApplicationDetail(v *ApplicationDetail) *DescribeApplicationOutput {
	s.ApplicationDetail = v
	return s
}

// Describes the data format when records are written to the destination. For
// more information, see Configuring Application Output (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
type DestinationSchema struct {
	_ struct{} `type:"structure"`

	// Specifies the format of the records on the output stream.
	//
	// RecordFormatType is a required field
	RecordFormatType *string `type:"string" required:"true" enum:"RecordFormatType"`
}

// String returns the string representation
func (s DestinationSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationSchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationSchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationSchema"}
	if s.RecordFormatType == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordFormatType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordFormatType sets the RecordFormatType field's value.
func (s *DestinationSchema) SetRecordFormatType(v string) *DestinationSchema {
	s.RecordFormatType = &v
	return s
}

type DiscoverInputSchemaInput struct {
	_ struct{} `type:"structure"`

	// The InputProcessingConfiguration (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html)
	// to use to preprocess the records before discovering the schema of the records.
	InputProcessingConfiguration *InputProcessingConfiguration `type:"structure"`

	// Point at which you want Amazon Kinesis Analytics to start reading records
	// from the specified streaming source discovery purposes.
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure"`

	// Amazon Resource Name (ARN) of the streaming source.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf.
	RoleARN *string `min:"1" type:"string"`

	// Specify this parameter to discover a schema from data in an Amazon S3 object.
	S3Configuration *S3Configuration `type:"structure"`
}

// String returns the string representation
func (s DiscoverInputSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiscoverInputSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DiscoverInputSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DiscoverInputSchemaInput"}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.InputProcessingConfiguration != nil {
		if err := s.InputProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputProcessingConfiguration sets the InputProcessingConfiguration field's value.
func (s *DiscoverInputSchemaInput) SetInputProcessingConfiguration(v *InputProcessingConfiguration) *DiscoverInputSchemaInput {
	s.InputProcessingConfiguration = v
	return s
}

// SetInputStartingPositionConfiguration sets the InputStartingPositionConfiguration field's value.
func (s *DiscoverInputSchemaInput) SetInputStartingPositionConfiguration(v *InputStartingPositionConfiguration) *DiscoverInputSchemaInput {
	s.InputStartingPositionConfiguration = v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *DiscoverInputSchemaInput) SetResourceARN(v string) *DiscoverInputSchemaInput {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *DiscoverInputSchemaInput) SetRoleARN(v string) *DiscoverInputSchemaInput {
	s.RoleARN = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *DiscoverInputSchemaInput) SetS3Configuration(v *S3Configuration) *DiscoverInputSchemaInput {
	s.S3Configuration = v
	return s
}

type DiscoverInputSchemaOutput struct {
	_ struct{} `type:"structure"`

	// Schema inferred from the streaming source. It identifies the format of the
	// data in the streaming source and how each data element maps to corresponding
	// columns in the in-application stream that you can create.
	InputSchema *SourceSchema `type:"structure"`

	// An array of elements, where each element corresponds to a row in a stream
	// record (a stream record can have more than one row).
	ParsedInputRecords [][]*string `type:"list"`

	// Stream data that was modified by the processor specified in the InputProcessingConfiguration
	// parameter.
	ProcessedInputRecords []*string `type:"list"`

	// Raw stream data that was sampled to infer the schema.
	RawInputRecords []*string `type:"list"`
}

// String returns the string representation
func (s DiscoverInputSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiscoverInputSchemaOutput) GoString() string {
	return s.String()
}

// SetInputSchema sets the InputSchema field's value.
func (s *DiscoverInputSchemaOutput) SetInputSchema(v *SourceSchema) *DiscoverInputSchemaOutput {
	s.InputSchema = v
	return s
}

// SetParsedInputRecords sets the ParsedInputRecords field's value.
func (s *DiscoverInputSchemaOutput) SetParsedInputRecords(v [][]*string) *DiscoverInputSchemaOutput {
	s.ParsedInputRecords = v
	return s
}

// SetProcessedInputRecords sets the ProcessedInputRecords field's value.
func (s *DiscoverInputSchemaOutput) SetProcessedInputRecords(v []*string) *DiscoverInputSchemaOutput {
	s.ProcessedInputRecords = v
	return s
}

// SetRawInputRecords sets the RawInputRecords field's value.
func (s *DiscoverInputSchemaOutput) SetRawInputRecords(v []*string) *DiscoverInputSchemaOutput {
	s.RawInputRecords = v
	return s
}

// When you configure the application input, you specify the streaming source,
// the in-application stream name that is created, and the mapping between the
// two. For more information, see Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
type Input struct {
	_ struct{} `type:"structure"`

	// Describes the number of in-application streams to create.
	//
	// Data from your source is routed to these in-application input streams.
	//
	// (see Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
	InputParallelism *InputParallelism `type:"structure"`

	// The InputProcessingConfiguration (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html)
	// for the input. An input processor transforms records as they are received
	// from the stream, before the application's SQL code executes. Currently, the
	// only input processing configuration available is InputLambdaProcessor (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html).
	InputProcessingConfiguration *InputProcessingConfiguration `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns in the in-application stream that is
	// being created.
	//
	// Also used to describe the format of the reference data source.
	//
	// InputSchema is a required field
	InputSchema *SourceSchema `type:"structure" required:"true"`

	// If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies
	// the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics
	// to access the stream on your behalf.
	//
	// Note: Either KinesisStreamsInput or KinesisFirehoseInput is required.
	KinesisFirehoseInput *KinesisFirehoseInput `type:"structure"`

	// If the streaming source is an Amazon Kinesis stream, identifies the stream's
	// Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics
	// to access the stream on your behalf.
	//
	// Note: Either KinesisStreamsInput or KinesisFirehoseInput is required.
	KinesisStreamsInput *KinesisStreamsInput `type:"structure"`

	// Name prefix to use when creating an in-application stream. Suppose that you
	// specify a prefix "MyInApplicationStream." Amazon Kinesis Analytics then creates
	// one or more (as per the InputParallelism count you specified) in-application
	// streams with names "MyInApplicationStream_001," "MyInApplicationStream_002,"
	// and so on.
	//
	// NamePrefix is a required field
	NamePrefix *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Input"}
	if s.InputSchema == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSchema"))
	}
	if s.NamePrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("NamePrefix"))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.InputParallelism != nil {
		if err := s.InputParallelism.Validate(); err != nil {
			invalidParams.AddNested("InputParallelism", err.(request.ErrInvalidParams))
		}
	}
	if s.InputProcessingConfiguration != nil {
		if err := s.InputProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.InputSchema != nil {
		if err := s.InputSchema.Validate(); err != nil {
			invalidParams.AddNested("InputSchema", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseInput != nil {
		if err := s.KinesisFirehoseInput.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseInput", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsInput != nil {
		if err := s.KinesisStreamsInput.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputParallelism sets the InputParallelism field's value.
func (s *Input) SetInputParallelism(v *InputParallelism) *Input {
	s.InputParallelism = v
	return s
}

// SetInputProcessingConfiguration sets the InputProcessingConfiguration field's value.
func (s *Input) SetInputProcessingConfiguration(v *InputProcessingConfiguration) *Input {
	s.InputProcessingConfiguration = v
	return s
}

// SetInputSchema sets the InputSchema field's value.
func (s *Input) SetInputSchema(v *SourceSchema) *Input {
	s.InputSchema = v
	return s
}

// SetKinesisFirehoseInput sets the KinesisFirehoseInput field's value.
func (s *Input) SetKinesisFirehoseInput(v *KinesisFirehoseInput) *Input {
	s.KinesisFirehoseInput = v
	return s
}

// SetKinesisStreamsInput sets the KinesisStreamsInput field's value.
func (s *Input) SetKinesisStreamsInput(v *KinesisStreamsInput) *Input {
	s.KinesisStreamsInput = v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *Input) SetNamePrefix(v string) *Input {
	s.NamePrefix = &v
	return s
}

// When you start your application, you provide this configuration, which identifies
// the input source and the point in the input source at which you want the
// application to start processing records.
type InputConfiguration struct {
	_ struct{} `type:"structure"`

	// Input source ID. You can get this ID by calling the DescribeApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Point at which you want the application to start processing records from
	// the streaming source.
	//
	// InputStartingPositionConfiguration is a required field
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s InputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputConfiguration"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.InputStartingPositionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InputStartingPositionConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *InputConfiguration) SetId(v string) *InputConfiguration {
	s.Id = &v
	return s
}

// SetInputStartingPositionConfiguration sets the InputStartingPositionConfiguration field's value.
func (s *InputConfiguration) SetInputStartingPositionConfiguration(v *InputStartingPositionConfiguration) *InputConfiguration {
	s.InputStartingPositionConfiguration = v
	return s
}

// Describes the application input configuration. For more information, see
// Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
type InputDescription struct {
	_ struct{} `type:"structure"`

	// Returns the in-application stream names that are mapped to the stream source.
	InAppStreamNames []*string `type:"list"`

	// Input ID associated with the application input. This is the ID that Amazon
	// Kinesis Analytics assigns to each input configuration you add to your application.
	InputId *string `min:"1" type:"string"`

	// Describes the configured parallelism (number of in-application streams mapped
	// to the streaming source).
	InputParallelism *InputParallelism `type:"structure"`

	// The description of the preprocessor that executes on records in this input
	// before the application's code is run.
	InputProcessingConfigurationDescription *InputProcessingConfigurationDescription `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns in the in-application stream that is
	// being created.
	InputSchema *SourceSchema `type:"structure"`

	// Point at which the application is configured to read from the input stream.
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure"`

	// If an Amazon Kinesis Firehose delivery stream is configured as a streaming
	// source, provides the delivery stream's ARN and an IAM role that enables Amazon
	// Kinesis Analytics to access the stream on your behalf.
	KinesisFirehoseInputDescription *KinesisFirehoseInputDescription `type:"structure"`

	// If an Amazon Kinesis stream is configured as streaming source, provides Amazon
	// Kinesis stream's Amazon Resource Name (ARN) and an IAM role that enables
	// Amazon Kinesis Analytics to access the stream on your behalf.
	KinesisStreamsInputDescription *KinesisStreamsInputDescription `type:"structure"`

	// In-application name prefix.
	NamePrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDescription) GoString() string {
	return s.String()
}

// SetInAppStreamNames sets the InAppStreamNames field's value.
func (s *InputDescription) SetInAppStreamNames(v []*string) *InputDescription {
	s.InAppStreamNames = v
	return s
}

// SetInputId sets the InputId field's value.
func (s *InputDescription) SetInputId(v string) *InputDescription {
	s.InputId = &v
	return s
}

// SetInputParallelism sets the InputParallelism field's value.
func (s *InputDescription) SetInputParallelism(v *InputParallelism) *InputDescription {
	s.InputParallelism = v
	return s
}

// SetInputProcessingConfigurationDescription sets the InputProcessingConfigurationDescription field's value.
func (s *InputDescription) SetInputProcessingConfigurationDescription(v *InputProcessingConfigurationDescription) *InputDescription {
	s.InputProcessingConfigurationDescription = v
	return s
}

// SetInputSchema sets the InputSchema field's value.
func (s *InputDescription) SetInputSchema(v *SourceSchema) *InputDescription {
	s.InputSchema = v
	return s
}

// SetInputStartingPositionConfiguration sets the InputStartingPositionConfiguration field's value.
func (s *InputDescription) SetInputStartingPositionConfiguration(v *InputStartingPositionConfiguration) *InputDescription {
	s.InputStartingPositionConfiguration = v
	return s
}

// SetKinesisFirehoseInputDescription sets the KinesisFirehoseInputDescription field's value.
func (s *InputDescription) SetKinesisFirehoseInputDescription(v *KinesisFirehoseInputDescription) *InputDescription {
	s.KinesisFirehoseInputDescription = v
	return s
}

// SetKinesisStreamsInputDescription sets the KinesisStreamsInputDescription field's value.
func (s *InputDescription) SetKinesisStreamsInputDescription(v *KinesisStreamsInputDescription) *InputDescription {
	s.KinesisStreamsInputDescription = v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *InputDescription) SetNamePrefix(v string) *InputDescription {
	s.NamePrefix = &v
	return s
}

// An object that contains the Amazon Resource Name (ARN) of the AWS Lambda
// (https://docs.aws.amazon.com/lambda/) function that is used to preprocess
// records in the stream, and the ARN of the IAM role that is used to access
// the AWS Lambda function.
type InputLambdaProcessor struct {
	_ struct{} `type:"structure"`

	// The ARN of the AWS Lambda (https://docs.aws.amazon.com/lambda/) function
	// that operates on records in the stream.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that is used to access the AWS Lambda function.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InputLambdaProcessor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputLambdaProcessor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLambdaProcessor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputLambdaProcessor"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *InputLambdaProcessor) SetResourceARN(v string) *InputLambdaProcessor {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *InputLambdaProcessor) SetRoleARN(v string) *InputLambdaProcessor {
	s.RoleARN = &v
	return s
}

// An object that contains the Amazon Resource Name (ARN) of the AWS Lambda
// (https://docs.aws.amazon.com/lambda/) function that is used to preprocess
// records in the stream, and the ARN of the IAM role that is used to access
// the AWS Lambda expression.
type InputLambdaProcessorDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the AWS Lambda (https://docs.aws.amazon.com/lambda/) function
	// that is used to preprocess the records in the stream.
	ResourceARN *string `min:"1" type:"string"`

	// The ARN of the IAM role that is used to access the AWS Lambda function.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputLambdaProcessorDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputLambdaProcessorDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *InputLambdaProcessorDescription) SetResourceARN(v string) *InputLambdaProcessorDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *InputLambdaProcessorDescription) SetRoleARN(v string) *InputLambdaProcessorDescription {
	s.RoleARN = &v
	return s
}

// Represents an update to the InputLambdaProcessor (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html)
// that is used to preprocess the records in the stream.
type InputLambdaProcessorUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new AWS Lambda (https://docs.aws.amazon.com/lambda/)
	// function that is used to preprocess the records in the stream.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	ResourceARNUpdate *string `min:"1" type:"string"`

	// The ARN of the new IAM role that is used to access the AWS Lambda function.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputLambdaProcessorUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputLambdaProcessorUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLambdaProcessorUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputLambdaProcessorUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *InputLambdaProcessorUpdate) SetResourceARNUpdate(v string) *InputLambdaProcessorUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// SetRoleARNUpdate sets the RoleARNUpdate field's value.
func (s *InputLambdaProcessorUpdate) SetRoleARNUpdate(v string) *InputLambdaProcessorUpdate {
	s.RoleARNUpdate = &v
	return s
}

// Describes the number of in-application streams to create for a given streaming
// source. For information about parallelism, see Configuring Application Input
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
type InputParallelism struct {
	_ struct{} `type:"structure"`

	// Number of in-application streams to create. For more information, see Limits
	// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
	Count *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s InputParallelism) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputParallelism) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputParallelism) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputParallelism"}
	if s.Count != nil && *s.Count < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Count", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCount sets the Count field's value.
func (s *InputParallelism) SetCount(v int64) *InputParallelism {
	s.Count = &v
	return s
}

// Provides updates to the parallelism count.
type InputParallelismUpdate struct {
	_ struct{} `type:"structure"`

	// Number of in-application streams to create for the specified streaming source.
	CountUpdate *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s InputParallelismUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputParallelismUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputParallelismUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputParallelismUpdate"}
	if s.CountUpdate != nil && *s.CountUpdate < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CountUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCountUpdate sets the CountUpdate field's value.
func (s *InputParallelismUpdate) SetCountUpdate(v int64) *InputParallelismUpdate {
	s.CountUpdate = &v
	return s
}

// Provides a description of a processor that is used to preprocess the records
// in the stream before being processed by your application code. Currently,
// the only input processor available is AWS Lambda (https://docs.aws.amazon.com/lambda/).
type InputProcessingConfiguration struct {
	_ struct{} `type:"structure"`

	// The InputLambdaProcessor (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html)
	// that is used to preprocess the records in the stream before being processed
	// by your application code.
	//
	// InputLambdaProcessor is a required field
	InputLambdaProcessor *InputLambdaProcessor `type:"structure" required:"true"`
}

// String returns the string representation
func (s InputProcessingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputProcessingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputProcessingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputProcessingConfiguration"}
	if s.InputLambdaProcessor == nil {
		invalidParams.Add(request.NewErrParamRequired("InputLambdaProcessor"))
	}
	if s.InputLambdaProcessor != nil {
		if err := s.InputLambdaProcessor.Validate(); err != nil {
			invalidParams.AddNested("InputLambdaProcessor", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputLambdaProcessor sets the InputLambdaProcessor field's value.
func (s *InputProcessingConfiguration) SetInputLambdaProcessor(v *InputLambdaProcessor) *InputProcessingConfiguration {
	s.InputLambdaProcessor = v
	return s
}

// Provides configuration information about an input processor. Currently, the
// only input processor available is AWS Lambda (https://docs.aws.amazon.com/lambda/).
type InputProcessingConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Provides configuration information about the associated InputLambdaProcessorDescription
	// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessorDescription.html).
	InputLambdaProcessorDescription *InputLambdaProcessorDescription `type:"structure"`
}

// String returns the string representation
func (s InputProcessingConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputProcessingConfigurationDescription) GoString() string {
	return s.String()
}

// SetInputLambdaProcessorDescription sets the InputLambdaProcessorDescription field's value.
func (s *InputProcessingConfigurationDescription) SetInputLambdaProcessorDescription(v *InputLambdaProcessorDescription) *InputProcessingConfigurationDescription {
	s.InputLambdaProcessorDescription = v
	return s
}

// Describes updates to an InputProcessingConfiguration (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html).
type InputProcessingConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Provides update information for an InputLambdaProcessor (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html).
	//
	// InputLambdaProcessorUpdate is a required field
	InputLambdaProcessorUpdate *InputLambdaProcessorUpdate `type:"structure" required:"true"`
}

// String returns the string representation
func (s InputProcessingConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputProcessingConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputProcessingConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputProcessingConfigurationUpdate"}
	if s.InputLambdaProcessorUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("InputLambdaProcessorUpdate"))
	}
	if s.InputLambdaProcessorUpdate != nil {
		if err := s.InputLambdaProcessorUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputLambdaProcessorUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputLambdaProcessorUpdate sets the InputLambdaProcessorUpdate field's value.
func (s *InputProcessingConfigurationUpdate) SetInputLambdaProcessorUpdate(v *InputLambdaProcessorUpdate) *InputProcessingConfigurationUpdate {
	s.InputLambdaProcessorUpdate = v
	return s
}

// Describes updates for the application's input schema.
type InputSchemaUpdate struct {
	_ struct{} `type:"structure"`

	// A list of RecordColumn objects. Each object describes the mapping of the
	// streaming source element to the corresponding column in the in-application
	// stream.
	RecordColumnUpdates []*RecordColumn `min:"1" type:"list"`

	// Specifies the encoding of the records in the streaming source. For example,
	// UTF-8.
	RecordEncodingUpdate *string `type:"string"`

	// Specifies the format of the records on the streaming source.
	RecordFormatUpdate *RecordFormat `type:"structure"`
}

// String returns the string representation
func (s InputSchemaUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSchemaUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSchemaUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputSchemaUpdate"}
	if s.RecordColumnUpdates != nil && len(s.RecordColumnUpdates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecordColumnUpdates", 1))
	}
	if s.RecordColumnUpdates != nil {
		for i, v := range s.RecordColumnUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecordColumnUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RecordFormatUpdate != nil {
		if err := s.RecordFormatUpdate.Validate(); err != nil {
			invalidParams.AddNested("RecordFormatUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordColumnUpdates sets the RecordColumnUpdates field's value.
func (s *InputSchemaUpdate) SetRecordColumnUpdates(v []*RecordColumn) *InputSchemaUpdate {
	s.RecordColumnUpdates = v
	return s
}

// SetRecordEncodingUpdate sets the RecordEncodingUpdate field's value.
func (s *InputSchemaUpdate) SetRecordEncodingUpdate(v string) *InputSchemaUpdate {
	s.RecordEncodingUpdate = &v
	return s
}

// SetRecordFormatUpdate sets the RecordFormatUpdate field's value.
func (s *InputSchemaUpdate) SetRecordFormatUpdate(v *RecordFormat) *InputSchemaUpdate {
	s.RecordFormatUpdate = v
	return s
}

// Describes the point at which the application reads from the streaming source.
type InputStartingPositionConfiguration struct {
	_ struct{} `type:"structure"`

	// The starting position on the stream.
	//
	//    * NOW - Start reading just after the most recent record in the stream,
	//    start at the request time stamp that the customer issued.
	//
	//    * TRIM_HORIZON - Start reading at the last untrimmed record in the stream,
	//    which is the oldest record available in the stream. This option is not
	//    available for an Amazon Kinesis Firehose delivery stream.
	//
	//    * LAST_STOPPED_POINT - Resume reading from where the application last
	//    stopped reading.
	InputStartingPosition *string `type:"string" enum:"InputStartingPosition"`
}

// String returns the string representation
func (s InputStartingPositionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputStartingPositionConfiguration) GoString() string {
	return s.String()
}

// SetInputStartingPosition sets the InputStartingPosition field's value.
func (s *InputStartingPositionConfiguration) SetInputStartingPosition(v string) *InputStartingPositionConfiguration {
	s.InputStartingPosition = &v
	return s
}

// Describes updates to a specific input configuration (identified by the InputId
// of an application).
type InputUpdate struct {
	_ struct{} `type:"structure"`

	// Input ID of the application input to be updated.
	//
	// InputId is a required field
	InputId *string `min:"1" type:"string" required:"true"`

	// Describes the parallelism updates (the number in-application streams Amazon
	// Kinesis Analytics creates for the specific streaming source).
	InputParallelismUpdate *InputParallelismUpdate `type:"structure"`

	// Describes updates for an input processing configuration.
	InputProcessingConfigurationUpdate *InputProcessingConfigurationUpdate `type:"structure"`

	// Describes the data format on the streaming source, and how record elements
	// on the streaming source map to columns of the in-application stream that
	// is created.
	InputSchemaUpdate *InputSchemaUpdate `type:"structure"`

	// If an Amazon Kinesis Firehose delivery stream is the streaming source to
	// be updated, provides an updated stream ARN and IAM role ARN.
	KinesisFirehoseInputUpdate *KinesisFirehoseInputUpdate `type:"structure"`

	// If an Amazon Kinesis stream is the streaming source to be updated, provides
	// an updated stream Amazon Resource Name (ARN) and IAM role ARN.
	KinesisStreamsInputUpdate *KinesisStreamsInputUpdate `type:"structure"`

	// Name prefix for in-application streams that Amazon Kinesis Analytics creates
	// for the specific streaming source.
	NamePrefixUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputUpdate"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}
	if s.NamePrefixUpdate != nil && len(*s.NamePrefixUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefixUpdate", 1))
	}
	if s.InputParallelismUpdate != nil {
		if err := s.InputParallelismUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputParallelismUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.InputProcessingConfigurationUpdate != nil {
		if err := s.InputProcessingConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.InputSchemaUpdate != nil {
		if err := s.InputSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputSchemaUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseInputUpdate != nil {
		if err := s.KinesisFirehoseInputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseInputUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsInputUpdate != nil {
		if err := s.KinesisStreamsInputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsInputUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputId sets the InputId field's value.
func (s *InputUpdate) SetInputId(v string) *InputUpdate {
	s.InputId = &v
	return s
}

// SetInputParallelismUpdate sets the InputParallelismUpdate field's value.
func (s *InputUpdate) SetInputParallelismUpdate(v *InputParallelismUpdate) *InputUpdate {
	s.InputParallelismUpdate = v
	return s
}

// SetInputProcessingConfigurationUpdate sets the InputProcessingConfigurationUpdate field's value.
func (s *InputUpdate) SetInputProcessingConfigurationUpdate(v *InputProcessingConfigurationUpdate) *InputUpdate {
	s.InputProcessingConfigurationUpdate = v
	return s
}

// SetInputSchemaUpdate sets the InputSchemaUpdate field's value.
func (s *InputUpdate) SetInputSchemaUpdate(v *InputSchemaUpdate) *InputUpdate {
	s.InputSchemaUpdate = v
	return s
}

// SetKinesisFirehoseInputUpdate sets the KinesisFirehoseInputUpdate field's value.
func (s *InputUpdate) SetKinesisFirehoseInputUpdate(v *KinesisFirehoseInputUpdate) *InputUpdate {
	s.KinesisFirehoseInputUpdate = v
	return s
}

// SetKinesisStreamsInputUpdate sets the KinesisStreamsInputUpdate field's value.
func (s *InputUpdate) SetKinesisStreamsInputUpdate(v *KinesisStreamsInputUpdate) *InputUpdate {
	s.KinesisStreamsInputUpdate = v
	return s
}

// SetNamePrefixUpdate sets the NamePrefixUpdate field's value.
func (s *InputUpdate) SetNamePrefixUpdate(v string) *InputUpdate {
	s.NamePrefixUpdate = &v
	return s
}

// User-provided application configuration is not valid.
type InvalidApplicationConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// test
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidApplicationConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidApplicationConfigurationException) GoString() string {
	return s.String()
}

func newErrorInvalidApplicationConfigurationException(v protocol.ResponseMetadata) error {
	return &InvalidApplicationConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidApplicationConfigurationException) Code() string {
	return "InvalidApplicationConfigurationException"
}

// Message returns the exception's message.
func (s *InvalidApplicationConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidApplicationConfigurationException) OrigErr() error {
	return nil
}

func (s *InvalidApplicationConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidApplicationConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidApplicationConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specified input parameter value is invalid.
type InvalidArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidArgumentException) GoString() string {
	return s.String()
}

func newErrorInvalidArgumentException(v protocol.ResponseMetadata) error {
	return &InvalidArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArgumentException) Code() string {
	return "InvalidArgumentException"
}

// Message returns the exception's message.
func (s *InvalidArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArgumentException) OrigErr() error {
	return nil
}

func (s *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides additional mapping information when JSON is the record format on
// the streaming source.
type JSONMappingParameters struct {
	_ struct{} `type:"structure"`

	// Path to the top-level parent that contains the records.
	//
	// RecordRowPath is a required field
	RecordRowPath *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s JSONMappingParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JSONMappingParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JSONMappingParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JSONMappingParameters"}
	if s.RecordRowPath == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordRowPath"))
	}
	if s.RecordRowPath != nil && len(*s.RecordRowPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecordRowPath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordRowPath sets the RecordRowPath field's value.
func (s *JSONMappingParameters) SetRecordRowPath(v string) *JSONMappingParameters {
	s.RecordRowPath = &v
	return s
}

// Identifies an Amazon Kinesis Firehose delivery stream as the streaming source.
// You provide the delivery stream's Amazon Resource Name (ARN) and an IAM role
// ARN that enables Amazon Kinesis Analytics to access the stream on your behalf.
type KinesisFirehoseInput struct {
	_ struct{} `type:"structure"`

	// ARN of the input delivery stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to make sure that the role has the necessary
	// permissions to access the stream.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisFirehoseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisFirehoseInput) SetResourceARN(v string) *KinesisFirehoseInput {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisFirehoseInput) SetRoleARN(v string) *KinesisFirehoseInput {
	s.RoleARN = &v
	return s
}

// Describes the Amazon Kinesis Firehose delivery stream that is configured
// as the streaming source in the application input configuration.
type KinesisFirehoseInputDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics assumes to access the stream.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisFirehoseInputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisFirehoseInputDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisFirehoseInputDescription) SetResourceARN(v string) *KinesisFirehoseInputDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisFirehoseInputDescription) SetRoleARN(v string) *KinesisFirehoseInputDescription {
	s.RoleARN = &v
	return s
}

// When updating application input configuration, provides information about
// an Amazon Kinesis Firehose delivery stream as the streaming source.
type KinesisFirehoseInputUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the input Amazon Kinesis Firehose delivery
	// stream to read.
	ResourceARNUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to grant the necessary permissions to this
	// role.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisFirehoseInputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisFirehoseInputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseInputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseInputUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *KinesisFirehoseInputUpdate) SetResourceARNUpdate(v string) *KinesisFirehoseInputUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// SetRoleARNUpdate sets the RoleARNUpdate field's value.
func (s *KinesisFirehoseInputUpdate) SetRoleARNUpdate(v string) *KinesisFirehoseInputUpdate {
	s.RoleARNUpdate = &v
	return s
}

// When configuring application output, identifies an Amazon Kinesis Firehose
// delivery stream as the destination. You provide the stream Amazon Resource
// Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to write
// to the stream on your behalf.
type KinesisFirehoseOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the destination Amazon Kinesis Firehose delivery stream to write to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to write to
	// the destination stream on your behalf. You need to grant the necessary permissions
	// to this role.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisFirehoseOutput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseOutput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseOutput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisFirehoseOutput) SetResourceARN(v string) *KinesisFirehoseOutput {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisFirehoseOutput) SetRoleARN(v string) *KinesisFirehoseOutput {
	s.RoleARN = &v
	return s
}

// For an application output, describes the Amazon Kinesis Firehose delivery
// stream configured as its destination.
type KinesisFirehoseOutputDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisFirehoseOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisFirehoseOutputDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisFirehoseOutputDescription) SetResourceARN(v string) *KinesisFirehoseOutputDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisFirehoseOutputDescription) SetRoleARN(v string) *KinesisFirehoseOutputDescription {
	s.RoleARN = &v
	return s
}

// When updating an output configuration using the UpdateApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html)
// operation, provides information about an Amazon Kinesis Firehose delivery
// stream configured as the destination.
type KinesisFirehoseOutputUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream
	// to write to.
	ResourceARNUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to grant the necessary permissions to this
	// role.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisFirehoseOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisFirehoseOutputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseOutputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseOutputUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *KinesisFirehoseOutputUpdate) SetResourceARNUpdate(v string) *KinesisFirehoseOutputUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// SetRoleARNUpdate sets the RoleARNUpdate field's value.
func (s *KinesisFirehoseOutputUpdate) SetRoleARNUpdate(v string) *KinesisFirehoseOutputUpdate {
	s.RoleARNUpdate = &v
	return s
}

// Identifies an Amazon Kinesis stream as the streaming source. You provide
// the stream's Amazon Resource Name (ARN) and an IAM role ARN that enables
// Amazon Kinesis Analytics to access the stream on your behalf.
type KinesisStreamsInput struct {
	_ struct{} `type:"structure"`

	// ARN of the input Amazon Kinesis stream to read.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to grant the necessary permissions to this
	// role.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisStreamsInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisStreamsInput) SetResourceARN(v string) *KinesisStreamsInput {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisStreamsInput) SetRoleARN(v string) *KinesisStreamsInput {
	s.RoleARN = &v
	return s
}

// Describes the Amazon Kinesis stream that is configured as the streaming source
// in the application input configuration.
type KinesisStreamsInputDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis stream.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisStreamsInputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisStreamsInputDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisStreamsInputDescription) SetResourceARN(v string) *KinesisStreamsInputDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisStreamsInputDescription) SetRoleARN(v string) *KinesisStreamsInputDescription {
	s.RoleARN = &v
	return s
}

// When updating application input configuration, provides information about
// an Amazon Kinesis stream as the streaming source.
type KinesisStreamsInputUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the input Amazon Kinesis stream to read.
	ResourceARNUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to grant the necessary permissions to this
	// role.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisStreamsInputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisStreamsInputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsInputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisStreamsInputUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *KinesisStreamsInputUpdate) SetResourceARNUpdate(v string) *KinesisStreamsInputUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// SetRoleARNUpdate sets the RoleARNUpdate field's value.
func (s *KinesisStreamsInputUpdate) SetRoleARNUpdate(v string) *KinesisStreamsInputUpdate {
	s.RoleARNUpdate = &v
	return s
}

// When configuring application output, identifies an Amazon Kinesis stream
// as the destination. You provide the stream Amazon Resource Name (ARN) and
// also an IAM role ARN that Amazon Kinesis Analytics can use to write to the
// stream on your behalf.
type KinesisStreamsOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the destination Amazon Kinesis stream to write to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to write to
	// the destination stream on your behalf. You need to grant the necessary permissions
	// to this role.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisStreamsOutput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsOutput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisStreamsOutput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisStreamsOutput) SetResourceARN(v string) *KinesisStreamsOutput {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisStreamsOutput) SetRoleARN(v string) *KinesisStreamsOutput {
	s.RoleARN = &v
	return s
}

// For an application output, describes the Amazon Kinesis stream configured
// as its destination.
type KinesisStreamsOutputDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis stream.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisStreamsOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisStreamsOutputDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisStreamsOutputDescription) SetResourceARN(v string) *KinesisStreamsOutputDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisStreamsOutputDescription) SetRoleARN(v string) *KinesisStreamsOutputDescription {
	s.RoleARN = &v
	return s
}

// When updating an output configuration using the UpdateApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html)
// operation, provides information about an Amazon Kinesis stream configured
// as the destination.
type KinesisStreamsOutputUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to
	// write the output.
	ResourceARNUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to grant the necessary permissions to this
	// role.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisStreamsOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisStreamsOutputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsOutputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisStreamsOutputUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *KinesisStreamsOutputUpdate) SetResourceARNUpdate(v string) *KinesisStreamsOutputUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// SetRoleARNUpdate sets the RoleARNUpdate field's value.
func (s *KinesisStreamsOutputUpdate) SetRoleARNUpdate(v string) *KinesisStreamsOutputUpdate {
	s.RoleARNUpdate = &v
	return s
}

// When configuring application output, identifies an AWS Lambda function as
// the destination. You provide the function Amazon Resource Name (ARN) and
// also an IAM role ARN that Amazon Kinesis Analytics can use to write to the
// function on your behalf.
type LambdaOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the destination Lambda function to write to.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to write to
	// the destination function on your behalf. You need to grant the necessary
	// permissions to this role.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaOutput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaOutput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaOutput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *LambdaOutput) SetResourceARN(v string) *LambdaOutput {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *LambdaOutput) SetRoleARN(v string) *LambdaOutput {
	s.RoleARN = &v
	return s
}

// For an application output, describes the AWS Lambda function configured as
// its destination.
type LambdaOutputDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the destination Lambda function.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to write to
	// the destination function.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LambdaOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaOutputDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *LambdaOutputDescription) SetResourceARN(v string) *LambdaOutputDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *LambdaOutputDescription) SetRoleARN(v string) *LambdaOutputDescription {
	s.RoleARN = &v
	return s
}

// When updating an output configuration using the UpdateApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html)
// operation, provides information about an AWS Lambda function configured as
// the destination.
type LambdaOutputUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the destination Lambda function.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	ResourceARNUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to write to
	// the destination function on your behalf. You need to grant the necessary
	// permissions to this role.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LambdaOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaOutputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaOutputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaOutputUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *LambdaOutputUpdate) SetResourceARNUpdate(v string) *LambdaOutputUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// SetRoleARNUpdate sets the RoleARNUpdate field's value.
func (s *LambdaOutputUpdate) SetRoleARNUpdate(v string) *LambdaOutputUpdate {
	s.RoleARNUpdate = &v
	return s
}

// Exceeded the number of applications allowed.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	// Name of the application to start the list with. When using pagination to
	// retrieve the list, you don't need to specify this parameter in the first
	// request. However, in subsequent requests, you add the last application name
	// from the previous response to get the next page of applications.
	ExclusiveStartApplicationName *string `min:"1" type:"string"`

	// Maximum number of applications to list.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.ExclusiveStartApplicationName != nil && len(*s.ExclusiveStartApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartApplicationName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartApplicationName sets the ExclusiveStartApplicationName field's value.
func (s *ListApplicationsInput) SetExclusiveStartApplicationName(v string) *ListApplicationsInput {
	s.ExclusiveStartApplicationName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListApplicationsInput) SetLimit(v int64) *ListApplicationsInput {
	s.Limit = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// List of ApplicationSummary objects.
	//
	// ApplicationSummaries is a required field
	ApplicationSummaries []*ApplicationSummary `type:"list" required:"true"`

	// Returns true if there are more applications to retrieve.
	//
	// HasMoreApplications is a required field
	HasMoreApplications *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplicationSummaries sets the ApplicationSummaries field's value.
func (s *ListApplicationsOutput) SetApplicationSummaries(v []*ApplicationSummary) *ListApplicationsOutput {
	s.ApplicationSummaries = v
	return s
}

// SetHasMoreApplications sets the HasMoreApplications field's value.
func (s *ListApplicationsOutput) SetHasMoreApplications(v bool) *ListApplicationsOutput {
	s.HasMoreApplications = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the application for which to retrieve tags.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The key-value tags assigned to the application.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// When configuring application input at the time of creating or updating an
// application, provides additional mapping information specific to the record
// format (such as JSON, CSV, or record fields delimited by some delimiter)
// on the streaming source.
type MappingParameters struct {
	_ struct{} `type:"structure"`

	// Provides additional mapping information when the record format uses delimiters
	// (for example, CSV).
	CSVMappingParameters *CSVMappingParameters `type:"structure"`

	// Provides additional mapping information when JSON is the record format on
	// the streaming source.
	JSONMappingParameters *JSONMappingParameters `type:"structure"`
}

// String returns the string representation
func (s MappingParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MappingParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MappingParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MappingParameters"}
	if s.CSVMappingParameters != nil {
		if err := s.CSVMappingParameters.Validate(); err != nil {
			invalidParams.AddNested("CSVMappingParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.JSONMappingParameters != nil {
		if err := s.JSONMappingParameters.Validate(); err != nil {
			invalidParams.AddNested("JSONMappingParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCSVMappingParameters sets the CSVMappingParameters field's value.
func (s *MappingParameters) SetCSVMappingParameters(v *CSVMappingParameters) *MappingParameters {
	s.CSVMappingParameters = v
	return s
}

// SetJSONMappingParameters sets the JSONMappingParameters field's value.
func (s *MappingParameters) SetJSONMappingParameters(v *JSONMappingParameters) *MappingParameters {
	s.JSONMappingParameters = v
	return s
}

// Describes application output configuration in which you identify an in-application
// stream and a destination where you want the in-application stream data to
// be written. The destination can be an Amazon Kinesis stream or an Amazon
// Kinesis Firehose delivery stream.
//
// For limits on how many destinations an application can write and other limitations,
// see Limits (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
type Output struct {
	_ struct{} `type:"structure"`

	// Describes the data format when records are written to the destination. For
	// more information, see Configuring Application Output (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
	//
	// DestinationSchema is a required field
	DestinationSchema *DestinationSchema `type:"structure" required:"true"`

	// Identifies an Amazon Kinesis Firehose delivery stream as the destination.
	KinesisFirehoseOutput *KinesisFirehoseOutput `type:"structure"`

	// Identifies an Amazon Kinesis stream as the destination.
	KinesisStreamsOutput *KinesisStreamsOutput `type:"structure"`

	// Identifies an AWS Lambda function as the destination.
	LambdaOutput *LambdaOutput `type:"structure"`

	// Name of the in-application stream.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Output) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Output) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Output"}
	if s.DestinationSchema == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationSchema"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.DestinationSchema != nil {
		if err := s.DestinationSchema.Validate(); err != nil {
			invalidParams.AddNested("DestinationSchema", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseOutput != nil {
		if err := s.KinesisFirehoseOutput.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseOutput", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsOutput != nil {
		if err := s.KinesisStreamsOutput.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsOutput", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaOutput != nil {
		if err := s.LambdaOutput.Validate(); err != nil {
			invalidParams.AddNested("LambdaOutput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationSchema sets the DestinationSchema field's value.
func (s *Output) SetDestinationSchema(v *DestinationSchema) *Output {
	s.DestinationSchema = v
	return s
}

// SetKinesisFirehoseOutput sets the KinesisFirehoseOutput field's value.
func (s *Output) SetKinesisFirehoseOutput(v *KinesisFirehoseOutput) *Output {
	s.KinesisFirehoseOutput = v
	return s
}

// SetKinesisStreamsOutput sets the KinesisStreamsOutput field's value.
func (s *Output) SetKinesisStreamsOutput(v *KinesisStreamsOutput) *Output {
	s.KinesisStreamsOutput = v
	return s
}

// SetLambdaOutput sets the LambdaOutput field's value.
func (s *Output) SetLambdaOutput(v *LambdaOutput) *Output {
	s.LambdaOutput = v
	return s
}

// SetName sets the Name field's value.
func (s *Output) SetName(v string) *Output {
	s.Name = &v
	return s
}

// Describes the application output configuration, which includes the in-application
// stream name and the destination where the stream data is written. The destination
// can be an Amazon Kinesis stream or an Amazon Kinesis Firehose delivery stream.
type OutputDescription struct {
	_ struct{} `type:"structure"`

	// Data format used for writing data to the destination.
	DestinationSchema *DestinationSchema `type:"structure"`

	// Describes the Amazon Kinesis Firehose delivery stream configured as the destination
	// where output is written.
	KinesisFirehoseOutputDescription *KinesisFirehoseOutputDescription `type:"structure"`

	// Describes Amazon Kinesis stream configured as the destination where output
	// is written.
	KinesisStreamsOutputDescription *KinesisStreamsOutputDescription `type:"structure"`

	// Describes the AWS Lambda function configured as the destination where output
	// is written.
	LambdaOutputDescription *LambdaOutputDescription `type:"structure"`

	// Name of the in-application stream configured as output.
	Name *string `min:"1" type:"string"`

	// A unique identifier for the output configuration.
	OutputId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s OutputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputDescription) GoString() string {
	return s.String()
}

// SetDestinationSchema sets the DestinationSchema field's value.
func (s *OutputDescription) SetDestinationSchema(v *DestinationSchema) *OutputDescription {
	s.DestinationSchema = v
	return s
}

// SetKinesisFirehoseOutputDescription sets the KinesisFirehoseOutputDescription field's value.
func (s *OutputDescription) SetKinesisFirehoseOutputDescription(v *KinesisFirehoseOutputDescription) *OutputDescription {
	s.KinesisFirehoseOutputDescription = v
	return s
}

// SetKinesisStreamsOutputDescription sets the KinesisStreamsOutputDescription field's value.
func (s *OutputDescription) SetKinesisStreamsOutputDescription(v *KinesisStreamsOutputDescription) *OutputDescription {
	s.KinesisStreamsOutputDescription = v
	return s
}

// SetLambdaOutputDescription sets the LambdaOutputDescription field's value.
func (s *OutputDescription) SetLambdaOutputDescription(v *LambdaOutputDescription) *OutputDescription {
	s.LambdaOutputDescription = v
	return s
}

// SetName sets the Name field's value.
func (s *OutputDescription) SetName(v string) *OutputDescription {
	s.Name = &v
	return s
}

// SetOutputId sets the OutputId field's value.
func (s *OutputDescription) SetOutputId(v string) *OutputDescription {
	s.OutputId = &v
	return s
}

// Describes updates to the output configuration identified by the OutputId.
type OutputUpdate struct {
	_ struct{} `type:"structure"`

	// Describes the data format when records are written to the destination. For
	// more information, see Configuring Application Output (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
	DestinationSchemaUpdate *DestinationSchema `type:"structure"`

	// Describes an Amazon Kinesis Firehose delivery stream as the destination for
	// the output.
	KinesisFirehoseOutputUpdate *KinesisFirehoseOutputUpdate `type:"structure"`

	// Describes an Amazon Kinesis stream as the destination for the output.
	KinesisStreamsOutputUpdate *KinesisStreamsOutputUpdate `type:"structure"`

	// Describes an AWS Lambda function as the destination for the output.
	LambdaOutputUpdate *LambdaOutputUpdate `type:"structure"`

	// If you want to specify a different in-application stream for this output
	// configuration, use this field to specify the new in-application stream name.
	NameUpdate *string `min:"1" type:"string"`

	// Identifies the specific output configuration that you want to update.
	//
	// OutputId is a required field
	OutputId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s OutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputUpdate"}
	if s.NameUpdate != nil && len(*s.NameUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameUpdate", 1))
	}
	if s.OutputId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputId"))
	}
	if s.OutputId != nil && len(*s.OutputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputId", 1))
	}
	if s.DestinationSchemaUpdate != nil {
		if err := s.DestinationSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("DestinationSchemaUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseOutputUpdate != nil {
		if err := s.KinesisFirehoseOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseOutputUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsOutputUpdate != nil {
		if err := s.KinesisStreamsOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsOutputUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaOutputUpdate != nil {
		if err := s.LambdaOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("LambdaOutputUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationSchemaUpdate sets the DestinationSchemaUpdate field's value.
func (s *OutputUpdate) SetDestinationSchemaUpdate(v *DestinationSchema) *OutputUpdate {
	s.DestinationSchemaUpdate = v
	return s
}

// SetKinesisFirehoseOutputUpdate sets the KinesisFirehoseOutputUpdate field's value.
func (s *OutputUpdate) SetKinesisFirehoseOutputUpdate(v *KinesisFirehoseOutputUpdate) *OutputUpdate {
	s.KinesisFirehoseOutputUpdate = v
	return s
}

// SetKinesisStreamsOutputUpdate sets the KinesisStreamsOutputUpdate field's value.
func (s *OutputUpdate) SetKinesisStreamsOutputUpdate(v *KinesisStreamsOutputUpdate) *OutputUpdate {
	s.KinesisStreamsOutputUpdate = v
	return s
}

// SetLambdaOutputUpdate sets the LambdaOutputUpdate field's value.
func (s *OutputUpdate) SetLambdaOutputUpdate(v *LambdaOutputUpdate) *OutputUpdate {
	s.LambdaOutputUpdate = v
	return s
}

// SetNameUpdate sets the NameUpdate field's value.
func (s *OutputUpdate) SetNameUpdate(v string) *OutputUpdate {
	s.NameUpdate = &v
	return s
}

// SetOutputId sets the OutputId field's value.
func (s *OutputUpdate) SetOutputId(v string) *OutputUpdate {
	s.OutputId = &v
	return s
}

// Describes the mapping of each data element in the streaming source to the
// corresponding column in the in-application stream.
//
// Also used to describe the format of the reference data source.
type RecordColumn struct {
	_ struct{} `type:"structure"`

	// Reference to the data element in the streaming input or the reference data
	// source. This element is required if the RecordFormatType (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel)
	// is JSON.
	Mapping *string `type:"string"`

	// Name of the column created in the in-application input stream or reference
	// table.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Type of column created in the in-application input stream or reference table.
	//
	// SqlType is a required field
	SqlType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordColumn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordColumn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordColumn"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SqlType == nil {
		invalidParams.Add(request.NewErrParamRequired("SqlType"))
	}
	if s.SqlType != nil && len(*s.SqlType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SqlType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMapping sets the Mapping field's value.
func (s *RecordColumn) SetMapping(v string) *RecordColumn {
	s.Mapping = &v
	return s
}

// SetName sets the Name field's value.
func (s *RecordColumn) SetName(v string) *RecordColumn {
	s.Name = &v
	return s
}

// SetSqlType sets the SqlType field's value.
func (s *RecordColumn) SetSqlType(v string) *RecordColumn {
	s.SqlType = &v
	return s
}

// Describes the record format and relevant mapping information that should
// be applied to schematize the records on the stream.
type RecordFormat struct {
	_ struct{} `type:"structure"`

	// When configuring application input at the time of creating or updating an
	// application, provides additional mapping information specific to the record
	// format (such as JSON, CSV, or record fields delimited by some delimiter)
	// on the streaming source.
	MappingParameters *MappingParameters `type:"structure"`

	// The type of record format.
	//
	// RecordFormatType is a required field
	RecordFormatType *string `type:"string" required:"true" enum:"RecordFormatType"`
}

// String returns the string representation
func (s RecordFormat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordFormat) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordFormat) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordFormat"}
	if s.RecordFormatType == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordFormatType"))
	}
	if s.MappingParameters != nil {
		if err := s.MappingParameters.Validate(); err != nil {
			invalidParams.AddNested("MappingParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMappingParameters sets the MappingParameters field's value.
func (s *RecordFormat) SetMappingParameters(v *MappingParameters) *RecordFormat {
	s.MappingParameters = v
	return s
}

// SetRecordFormatType sets the RecordFormatType field's value.
func (s *RecordFormat) SetRecordFormatType(v string) *RecordFormat {
	s.RecordFormatType = &v
	return s
}

// Describes the reference data source by providing the source information (S3
// bucket name and object key name), the resulting in-application table name
// that is created, and the necessary schema to map the data elements in the
// Amazon S3 object to the in-application table.
type ReferenceDataSource struct {
	_ struct{} `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	//
	// ReferenceSchema is a required field
	ReferenceSchema *SourceSchema `type:"structure" required:"true"`

	// Identifies the S3 bucket and object that contains the reference data. Also
	// identifies the IAM role Amazon Kinesis Analytics can assume to read this
	// object on your behalf. An Amazon Kinesis Analytics application loads reference
	// data only once. If the data changes, you call the UpdateApplication operation
	// to trigger reloading of data into your application.
	S3ReferenceDataSource *S3ReferenceDataSource `type:"structure"`

	// Name of the in-application table to create.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ReferenceDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReferenceDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReferenceDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReferenceDataSource"}
	if s.ReferenceSchema == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceSchema"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.ReferenceSchema != nil {
		if err := s.ReferenceSchema.Validate(); err != nil {
			invalidParams.AddNested("ReferenceSchema", err.(request.ErrInvalidParams))
		}
	}
	if s.S3ReferenceDataSource != nil {
		if err := s.S3ReferenceDataSource.Validate(); err != nil {
			invalidParams.AddNested("S3ReferenceDataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReferenceSchema sets the ReferenceSchema field's value.
func (s *ReferenceDataSource) SetReferenceSchema(v *SourceSchema) *ReferenceDataSource {
	s.ReferenceSchema = v
	return s
}

// SetS3ReferenceDataSource sets the S3ReferenceDataSource field's value.
func (s *ReferenceDataSource) SetS3ReferenceDataSource(v *S3ReferenceDataSource) *ReferenceDataSource {
	s.S3ReferenceDataSource = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ReferenceDataSource) SetTableName(v string) *ReferenceDataSource {
	s.TableName = &v
	return s
}

// Describes the reference data source configured for an application.
type ReferenceDataSourceDescription struct {
	_ struct{} `type:"structure"`

	// ID of the reference data source. This is the ID that Amazon Kinesis Analytics
	// assigns when you add the reference data source to your application using
	// the AddApplicationReferenceDataSource (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html)
	// operation.
	//
	// ReferenceId is a required field
	ReferenceId *string `min:"1" type:"string" required:"true"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	ReferenceSchema *SourceSchema `type:"structure"`

	// Provides the S3 bucket name, the object key name that contains the reference
	// data. It also provides the Amazon Resource Name (ARN) of the IAM role that
	// Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate
	// the in-application reference table.
	//
	// S3ReferenceDataSourceDescription is a required field
	S3ReferenceDataSourceDescription *S3ReferenceDataSourceDescription `type:"structure" required:"true"`

	// The in-application table name created by the specific reference data source
	// configuration.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ReferenceDataSourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReferenceDataSourceDescription) GoString() string {
	return s.String()
}

// SetReferenceId sets the ReferenceId field's value.
func (s *ReferenceDataSourceDescription) SetReferenceId(v string) *ReferenceDataSourceDescription {
	s.ReferenceId = &v
	return s
}

// SetReferenceSchema sets the ReferenceSchema field's value.
func (s *ReferenceDataSourceDescription) SetReferenceSchema(v *SourceSchema) *ReferenceDataSourceDescription {
	s.ReferenceSchema = v
	return s
}

// SetS3ReferenceDataSourceDescription sets the S3ReferenceDataSourceDescription field's value.
func (s *ReferenceDataSourceDescription) SetS3ReferenceDataSourceDescription(v *S3ReferenceDataSourceDescription) *ReferenceDataSourceDescription {
	s.S3ReferenceDataSourceDescription = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ReferenceDataSourceDescription) SetTableName(v string) *ReferenceDataSourceDescription {
	s.TableName = &v
	return s
}

// When you update a reference data source configuration for an application,
// this object provides all the updated values (such as the source bucket name
// and object key name), the in-application table name that is created, and
// updated mapping information that maps the data in the Amazon S3 object to
// the in-application reference table that is created.
type ReferenceDataSourceUpdate struct {
	_ struct{} `type:"structure"`

	// ID of the reference data source being updated. You can use the DescribeApplication
	// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation to get this value.
	//
	// ReferenceId is a required field
	ReferenceId *string `min:"1" type:"string" required:"true"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	ReferenceSchemaUpdate *SourceSchema `type:"structure"`

	// Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis
	// Analytics can assume to read the Amazon S3 object on your behalf and populate
	// the in-application reference table.
	S3ReferenceDataSourceUpdate *S3ReferenceDataSourceUpdate `type:"structure"`

	// In-application table name that is created by this update.
	TableNameUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ReferenceDataSourceUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReferenceDataSourceUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReferenceDataSourceUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReferenceDataSourceUpdate"}
	if s.ReferenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceId"))
	}
	if s.ReferenceId != nil && len(*s.ReferenceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceId", 1))
	}
	if s.TableNameUpdate != nil && len(*s.TableNameUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableNameUpdate", 1))
	}
	if s.ReferenceSchemaUpdate != nil {
		if err := s.ReferenceSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("ReferenceSchemaUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.S3ReferenceDataSourceUpdate != nil {
		if err := s.S3ReferenceDataSourceUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3ReferenceDataSourceUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReferenceId sets the ReferenceId field's value.
func (s *ReferenceDataSourceUpdate) SetReferenceId(v string) *ReferenceDataSourceUpdate {
	s.ReferenceId = &v
	return s
}

// SetReferenceSchemaUpdate sets the ReferenceSchemaUpdate field's value.
func (s *ReferenceDataSourceUpdate) SetReferenceSchemaUpdate(v *SourceSchema) *ReferenceDataSourceUpdate {
	s.ReferenceSchemaUpdate = v
	return s
}

// SetS3ReferenceDataSourceUpdate sets the S3ReferenceDataSourceUpdate field's value.
func (s *ReferenceDataSourceUpdate) SetS3ReferenceDataSourceUpdate(v *S3ReferenceDataSourceUpdate) *ReferenceDataSourceUpdate {
	s.S3ReferenceDataSourceUpdate = v
	return s
}

// SetTableNameUpdate sets the TableNameUpdate field's value.
func (s *ReferenceDataSourceUpdate) SetTableNameUpdate(v string) *ReferenceDataSourceUpdate {
	s.TableNameUpdate = &v
	return s
}

// Application is not available for this operation.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specified application can't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Discovery failed to get a record from the streaming source because of the
// Amazon Kinesis Streams ProvisionedThroughputExceededException. For more information,
// see GetRecords (https://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetRecords.html)
// in the Amazon Kinesis Streams API Reference.
type ResourceProvisionedThroughputExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceProvisionedThroughputExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceProvisionedThroughputExceededException) GoString() string {
	return s.String()
}

func newErrorResourceProvisionedThroughputExceededException(v protocol.ResponseMetadata) error {
	return &ResourceProvisionedThroughputExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceProvisionedThroughputExceededException) Code() string {
	return "ResourceProvisionedThroughputExceededException"
}

// Message returns the exception's message.
func (s *ResourceProvisionedThroughputExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceProvisionedThroughputExceededException) OrigErr() error {
	return nil
}

func (s *ResourceProvisionedThroughputExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceProvisionedThroughputExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceProvisionedThroughputExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides a description of an Amazon S3 data source, including the Amazon
// Resource Name (ARN) of the S3 bucket, the ARN of the IAM role that is used
// to access the bucket, and the name of the Amazon S3 object that contains
// the data.
type S3Configuration struct {
	_ struct{} `type:"structure"`

	// ARN of the S3 bucket that contains the data.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The name of the object that contains the data.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// IAM ARN of the role used to access the data.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Configuration"}
	if s.BucketARN == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.FileKey == nil {
		invalidParams.Add(request.NewErrParamRequired("FileKey"))
	}
	if s.FileKey != nil && len(*s.FileKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileKey", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3Configuration) SetBucketARN(v string) *S3Configuration {
	s.BucketARN = &v
	return s
}

// SetFileKey sets the FileKey field's value.
func (s *S3Configuration) SetFileKey(v string) *S3Configuration {
	s.FileKey = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *S3Configuration) SetRoleARN(v string) *S3Configuration {
	s.RoleARN = &v
	return s
}

// Identifies the S3 bucket and object that contains the reference data. Also
// identifies the IAM role Amazon Kinesis Analytics can assume to read this
// object on your behalf.
//
// An Amazon Kinesis Analytics application loads reference data only once. If
// the data changes, you call the UpdateApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html)
// operation to trigger reloading of data into your application.
type S3ReferenceDataSource struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// Object key name containing reference data.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that the service can assume to read data on your behalf.
	// This role must have permission for the s3:GetObject action on the object
	// and trust policy that allows Amazon Kinesis Analytics service principal to
	// assume this role.
	//
	// ReferenceRoleARN is a required field
	ReferenceRoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3ReferenceDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ReferenceDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ReferenceDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ReferenceDataSource"}
	if s.BucketARN == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.FileKey == nil {
		invalidParams.Add(request.NewErrParamRequired("FileKey"))
	}
	if s.FileKey != nil && len(*s.FileKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileKey", 1))
	}
	if s.ReferenceRoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceRoleARN"))
	}
	if s.ReferenceRoleARN != nil && len(*s.ReferenceRoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceRoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3ReferenceDataSource) SetBucketARN(v string) *S3ReferenceDataSource {
	s.BucketARN = &v
	return s
}

// SetFileKey sets the FileKey field's value.
func (s *S3ReferenceDataSource) SetFileKey(v string) *S3ReferenceDataSource {
	s.FileKey = &v
	return s
}

// SetReferenceRoleARN sets the ReferenceRoleARN field's value.
func (s *S3ReferenceDataSource) SetReferenceRoleARN(v string) *S3ReferenceDataSource {
	s.ReferenceRoleARN = &v
	return s
}

// Provides the bucket name and object key name that stores the reference data.
type S3ReferenceDataSourceDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// Amazon S3 object key name.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to read the
	// Amazon S3 object on your behalf to populate the in-application reference
	// table.
	//
	// ReferenceRoleARN is a required field
	ReferenceRoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3ReferenceDataSourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ReferenceDataSourceDescription) GoString() string {
	return s.String()
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3ReferenceDataSourceDescription) SetBucketARN(v string) *S3ReferenceDataSourceDescription {
	s.BucketARN = &v
	return s
}

// SetFileKey sets the FileKey field's value.
func (s *S3ReferenceDataSourceDescription) SetFileKey(v string) *S3ReferenceDataSourceDescription {
	s.FileKey = &v
	return s
}

// SetReferenceRoleARN sets the ReferenceRoleARN field's value.
func (s *S3ReferenceDataSourceDescription) SetReferenceRoleARN(v string) *S3ReferenceDataSourceDescription {
	s.ReferenceRoleARN = &v
	return s
}

// Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis
// Analytics can assume to read the Amazon S3 object on your behalf and populate
// the in-application reference table.
type S3ReferenceDataSourceUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the S3 bucket.
	BucketARNUpdate *string `min:"1" type:"string"`

	// Object key name.
	FileKeyUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to read the
	// Amazon S3 object and populate the in-application.
	ReferenceRoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3ReferenceDataSourceUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ReferenceDataSourceUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ReferenceDataSourceUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ReferenceDataSourceUpdate"}
	if s.BucketARNUpdate != nil && len(*s.BucketARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARNUpdate", 1))
	}
	if s.FileKeyUpdate != nil && len(*s.FileKeyUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileKeyUpdate", 1))
	}
	if s.ReferenceRoleARNUpdate != nil && len(*s.ReferenceRoleARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceRoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARNUpdate sets the BucketARNUpdate field's value.
func (s *S3ReferenceDataSourceUpdate) SetBucketARNUpdate(v string) *S3ReferenceDataSourceUpdate {
	s.BucketARNUpdate = &v
	return s
}

// SetFileKeyUpdate sets the FileKeyUpdate field's value.
func (s *S3ReferenceDataSourceUpdate) SetFileKeyUpdate(v string) *S3ReferenceDataSourceUpdate {
	s.FileKeyUpdate = &v
	return s
}

// SetReferenceRoleARNUpdate sets the ReferenceRoleARNUpdate field's value.
func (s *S3ReferenceDataSourceUpdate) SetReferenceRoleARNUpdate(v string) *S3ReferenceDataSourceUpdate {
	s.ReferenceRoleARNUpdate = &v
	return s
}

// The service is unavailable. Back off and retry the operation.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the format of the data in the streaming source, and how each data
// element maps to corresponding columns created in the in-application stream.
type SourceSchema struct {
	_ struct{} `type:"structure"`

	// A list of RecordColumn objects.
	//
	// RecordColumns is a required field
	RecordColumns []*RecordColumn `min:"1" type:"list" required:"true"`

	// Specifies the encoding of the records in the streaming source. For example,
	// UTF-8.
	RecordEncoding *string `type:"string"`

	// Specifies the format of the records on the streaming source.
	//
	// RecordFormat is a required field
	RecordFormat *RecordFormat `type:"structure" required:"true"`
}

// String returns the string representation
func (s SourceSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceSchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceSchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceSchema"}
	if s.RecordColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordColumns"))
	}
	if s.RecordColumns != nil && len(s.RecordColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecordColumns", 1))
	}
	if s.RecordFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordFormat"))
	}
	if s.RecordColumns != nil {
		for i, v := range s.RecordColumns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecordColumns", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RecordFormat != nil {
		if err := s.RecordFormat.Validate(); err != nil {
			invalidParams.AddNested("RecordFormat", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordColumns sets the RecordColumns field's value.
func (s *SourceSchema) SetRecordColumns(v []*RecordColumn) *SourceSchema {
	s.RecordColumns = v
	return s
}

// SetRecordEncoding sets the RecordEncoding field's value.
func (s *SourceSchema) SetRecordEncoding(v string) *SourceSchema {
	s.RecordEncoding = &v
	return s
}

// SetRecordFormat sets the RecordFormat field's value.
func (s *SourceSchema) SetRecordFormat(v *RecordFormat) *SourceSchema {
	s.RecordFormat = v
	return s
}

type StartApplicationInput struct {
	_ struct{} `type:"structure"`

	// Name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Identifies the specific input, by ID, that the application starts consuming.
	// Amazon Kinesis Analytics starts reading the streaming source associated with
	// the input. You can also specify where in the streaming source you want Amazon
	// Kinesis Analytics to start reading.
	//
	// InputConfigurations is a required field
	InputConfigurations []*InputConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s StartApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.InputConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("InputConfigurations"))
	}
	if s.InputConfigurations != nil {
		for i, v := range s.InputConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *StartApplicationInput) SetApplicationName(v string) *StartApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetInputConfigurations sets the InputConfigurations field's value.
func (s *StartApplicationInput) SetInputConfigurations(v []*InputConfiguration) *StartApplicationInput {
	s.InputConfigurations = v
	return s
}

type StartApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartApplicationOutput) GoString() string {
	return s.String()
}

type StopApplicationInput struct {
	_ struct{} `type:"structure"`

	// Name of the running application to stop.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *StopApplicationInput) SetApplicationName(v string) *StopApplicationInput {
	s.ApplicationName = &v
	return s
}

type StopApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopApplicationOutput) GoString() string {
	return s.String()
}

// A key-value pair (the value is optional) that you can define and assign to
// AWS resources. If you specify a tag that already exists, the tag value is
// replaced with the value that you specify in the request. Note that the maximum
// number of application tags includes system tags. The maximum number of user-defined
// application tags is 50. For more information, see Using Tagging (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the key-value tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the key-value tag. The value is optional.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the application to assign the tags.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The key-value tags to assign to the application.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Application created with too many tags, or too many tags added to an application.
// Note that the maximum number of application tags includes system tags. The
// maximum number of user-defined application tags is 50.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Data format is not valid. Amazon Kinesis Analytics is not able to detect
// schema for the given streaming source.
type UnableToDetectSchemaException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	ProcessedInputRecords []*string `type:"list"`

	RawInputRecords []*string `type:"list"`
}

// String returns the string representation
func (s UnableToDetectSchemaException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnableToDetectSchemaException) GoString() string {
	return s.String()
}

func newErrorUnableToDetectSchemaException(v protocol.ResponseMetadata) error {
	return &UnableToDetectSchemaException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnableToDetectSchemaException) Code() string {
	return "UnableToDetectSchemaException"
}

// Message returns the exception's message.
func (s *UnableToDetectSchemaException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnableToDetectSchemaException) OrigErr() error {
	return nil
}

func (s *UnableToDetectSchemaException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnableToDetectSchemaException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnableToDetectSchemaException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because a specified parameter is not supported or
// a specified resource is not valid for this operation.
type UnsupportedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UnsupportedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedOperationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedOperationException(v protocol.ResponseMetadata) error {
	return &UnsupportedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedOperationException) Code() string {
	return "UnsupportedOperationException"
}

// Message returns the exception's message.
func (s *UnsupportedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedOperationException) OrigErr() error {
	return nil
}

func (s *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Kinesis Analytics application from which to remove the tags.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of keys of tags to remove from the specified application.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Name of the Amazon Kinesis Analytics application to update.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Describes application updates.
	//
	// ApplicationUpdate is a required field
	ApplicationUpdate *ApplicationUpdate `type:"structure" required:"true"`

	// The current application version ID. You can use the DescribeApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation to get this value.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.ApplicationUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationUpdate"))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.ApplicationUpdate != nil {
		if err := s.ApplicationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ApplicationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateApplicationInput) SetApplicationName(v string) *UpdateApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetApplicationUpdate sets the ApplicationUpdate field's value.
func (s *UpdateApplicationInput) SetApplicationUpdate(v *ApplicationUpdate) *UpdateApplicationInput {
	s.ApplicationUpdate = v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *UpdateApplicationInput) SetCurrentApplicationVersionId(v int64) *UpdateApplicationInput {
	s.CurrentApplicationVersionId = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

const (
	// ApplicationStatusDeleting is a ApplicationStatus enum value
	ApplicationStatusDeleting = "DELETING"

	// ApplicationStatusStarting is a ApplicationStatus enum value
	ApplicationStatusStarting = "STARTING"

	// ApplicationStatusStopping is a ApplicationStatus enum value
	ApplicationStatusStopping = "STOPPING"

	// ApplicationStatusReady is a ApplicationStatus enum value
	ApplicationStatusReady = "READY"

	// ApplicationStatusRunning is a ApplicationStatus enum value
	ApplicationStatusRunning = "RUNNING"

	// ApplicationStatusUpdating is a ApplicationStatus enum value
	ApplicationStatusUpdating = "UPDATING"
)

const (
	// InputStartingPositionNow is a InputStartingPosition enum value
	InputStartingPositionNow = "NOW"

	// InputStartingPositionTrimHorizon is a InputStartingPosition enum value
	InputStartingPositionTrimHorizon = "TRIM_HORIZON"

	// InputStartingPositionLastStoppedPoint is a InputStartingPosition enum value
	InputStartingPositionLastStoppedPoint = "LAST_STOPPED_POINT"
)

const (
	// RecordFormatTypeJson is a RecordFormatType enum value
	RecordFormatTypeJson = "JSON"

	// RecordFormatTypeCsv is a RecordFormatType enum value
	RecordFormatTypeCsv = "CSV"
)
