package botservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ChannelName enumerates the values for channel name.
type ChannelName string

const (
	// ChannelNameDirectLineChannel ...
	ChannelNameDirectLineChannel ChannelName = "DirectLineChannel"
	// ChannelNameEmailChannel ...
	ChannelNameEmailChannel ChannelName = "EmailChannel"
	// ChannelNameFacebookChannel ...
	ChannelNameFacebookChannel ChannelName = "FacebookChannel"
	// ChannelNameKikChannel ...
	ChannelNameKikChannel ChannelName = "KikChannel"
	// ChannelNameMsTeamsChannel ...
	ChannelNameMsTeamsChannel ChannelName = "MsTeamsChannel"
	// ChannelNameSkypeChannel ...
	ChannelNameSkypeChannel ChannelName = "SkypeChannel"
	// ChannelNameSlackChannel ...
	ChannelNameSlackChannel ChannelName = "SlackChannel"
	// ChannelNameSmsChannel ...
	ChannelNameSmsChannel ChannelName = "SmsChannel"
	// ChannelNameTelegramChannel ...
	ChannelNameTelegramChannel ChannelName = "TelegramChannel"
	// ChannelNameWebChatChannel ...
	ChannelNameWebChatChannel ChannelName = "WebChatChannel"
)

// PossibleChannelNameValues returns an array of possible values for the ChannelName const type.
func PossibleChannelNameValues() []ChannelName {
	return []ChannelName{ChannelNameDirectLineChannel, ChannelNameEmailChannel, ChannelNameFacebookChannel, ChannelNameKikChannel, ChannelNameMsTeamsChannel, ChannelNameSkypeChannel, ChannelNameSlackChannel, ChannelNameSmsChannel, ChannelNameTelegramChannel, ChannelNameWebChatChannel}
}

// ChannelNameBasicChannel enumerates the values for channel name basic channel.
type ChannelNameBasicChannel string

const (
	// ChannelNameChannel ...
	ChannelNameChannel ChannelNameBasicChannel = "Channel"
	// ChannelNameDirectLineChannel1 ...
	ChannelNameDirectLineChannel1 ChannelNameBasicChannel = "DirectLineChannel"
	// ChannelNameEmailChannel1 ...
	ChannelNameEmailChannel1 ChannelNameBasicChannel = "EmailChannel"
	// ChannelNameFacebookChannel1 ...
	ChannelNameFacebookChannel1 ChannelNameBasicChannel = "FacebookChannel"
	// ChannelNameKikChannel1 ...
	ChannelNameKikChannel1 ChannelNameBasicChannel = "KikChannel"
	// ChannelNameMsTeamsChannel1 ...
	ChannelNameMsTeamsChannel1 ChannelNameBasicChannel = "MsTeamsChannel"
	// ChannelNameSkypeChannel1 ...
	ChannelNameSkypeChannel1 ChannelNameBasicChannel = "SkypeChannel"
	// ChannelNameSlackChannel1 ...
	ChannelNameSlackChannel1 ChannelNameBasicChannel = "SlackChannel"
	// ChannelNameSmsChannel1 ...
	ChannelNameSmsChannel1 ChannelNameBasicChannel = "SmsChannel"
	// ChannelNameTelegramChannel1 ...
	ChannelNameTelegramChannel1 ChannelNameBasicChannel = "TelegramChannel"
	// ChannelNameWebChatChannel1 ...
	ChannelNameWebChatChannel1 ChannelNameBasicChannel = "WebChatChannel"
)

// PossibleChannelNameBasicChannelValues returns an array of possible values for the ChannelNameBasicChannel const type.
func PossibleChannelNameBasicChannelValues() []ChannelNameBasicChannel {
	return []ChannelNameBasicChannel{ChannelNameChannel, ChannelNameDirectLineChannel1, ChannelNameEmailChannel1, ChannelNameFacebookChannel1, ChannelNameKikChannel1, ChannelNameMsTeamsChannel1, ChannelNameSkypeChannel1, ChannelNameSlackChannel1, ChannelNameSmsChannel1, ChannelNameTelegramChannel1, ChannelNameWebChatChannel1}
}

// EnterpriseChannelNodeState enumerates the values for enterprise channel node state.
type EnterpriseChannelNodeState string

const (
	// CreateFailed ...
	CreateFailed EnterpriseChannelNodeState = "CreateFailed"
	// Creating ...
	Creating EnterpriseChannelNodeState = "Creating"
	// DeleteFailed ...
	DeleteFailed EnterpriseChannelNodeState = "DeleteFailed"
	// Deleting ...
	Deleting EnterpriseChannelNodeState = "Deleting"
	// Started ...
	Started EnterpriseChannelNodeState = "Started"
	// StartFailed ...
	StartFailed EnterpriseChannelNodeState = "StartFailed"
	// Starting ...
	Starting EnterpriseChannelNodeState = "Starting"
	// StopFailed ...
	StopFailed EnterpriseChannelNodeState = "StopFailed"
	// Stopped ...
	Stopped EnterpriseChannelNodeState = "Stopped"
	// Stopping ...
	Stopping EnterpriseChannelNodeState = "Stopping"
)

// PossibleEnterpriseChannelNodeStateValues returns an array of possible values for the EnterpriseChannelNodeState const type.
func PossibleEnterpriseChannelNodeStateValues() []EnterpriseChannelNodeState {
	return []EnterpriseChannelNodeState{CreateFailed, Creating, DeleteFailed, Deleting, Started, StartFailed, Starting, StopFailed, Stopped, Stopping}
}

// EnterpriseChannelState enumerates the values for enterprise channel state.
type EnterpriseChannelState string

const (
	// EnterpriseChannelStateCreateFailed ...
	EnterpriseChannelStateCreateFailed EnterpriseChannelState = "CreateFailed"
	// EnterpriseChannelStateCreating ...
	EnterpriseChannelStateCreating EnterpriseChannelState = "Creating"
	// EnterpriseChannelStateDeleteFailed ...
	EnterpriseChannelStateDeleteFailed EnterpriseChannelState = "DeleteFailed"
	// EnterpriseChannelStateDeleting ...
	EnterpriseChannelStateDeleting EnterpriseChannelState = "Deleting"
	// EnterpriseChannelStateStarted ...
	EnterpriseChannelStateStarted EnterpriseChannelState = "Started"
	// EnterpriseChannelStateStartFailed ...
	EnterpriseChannelStateStartFailed EnterpriseChannelState = "StartFailed"
	// EnterpriseChannelStateStarting ...
	EnterpriseChannelStateStarting EnterpriseChannelState = "Starting"
	// EnterpriseChannelStateStopFailed ...
	EnterpriseChannelStateStopFailed EnterpriseChannelState = "StopFailed"
	// EnterpriseChannelStateStopped ...
	EnterpriseChannelStateStopped EnterpriseChannelState = "Stopped"
	// EnterpriseChannelStateStopping ...
	EnterpriseChannelStateStopping EnterpriseChannelState = "Stopping"
)

// PossibleEnterpriseChannelStateValues returns an array of possible values for the EnterpriseChannelState const type.
func PossibleEnterpriseChannelStateValues() []EnterpriseChannelState {
	return []EnterpriseChannelState{EnterpriseChannelStateCreateFailed, EnterpriseChannelStateCreating, EnterpriseChannelStateDeleteFailed, EnterpriseChannelStateDeleting, EnterpriseChannelStateStarted, EnterpriseChannelStateStartFailed, EnterpriseChannelStateStarting, EnterpriseChannelStateStopFailed, EnterpriseChannelStateStopped, EnterpriseChannelStateStopping}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindBot ...
	KindBot Kind = "bot"
	// KindDesigner ...
	KindDesigner Kind = "designer"
	// KindFunction ...
	KindFunction Kind = "function"
	// KindSdk ...
	KindSdk Kind = "sdk"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindBot, KindDesigner, KindFunction, KindSdk}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// F0 ...
	F0 SkuName = "F0"
	// S1 ...
	S1 SkuName = "S1"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{F0, S1}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Free ...
	Free SkuTier = "Free"
	// Standard ...
	Standard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{Free, Standard}
}
