package validate

import (
	"fmt"

	"github.com/hashicorp/go-uuid"
)

// IsUUIDOrEmpty is a ValidateFunc that ensures a string can be parsed as UUID or is empty
func IsUUIDOrEmpty(i interface{}, k string) (warnings []string, errors []error) {
	v, ok := i.(string)
	if !ok {
		errors = append(errors, fmt.Errorf("expected type of %q to be string", k))
		return
	}

	if v == "" {
		return
	}

	if _, err := uuid.ParseUUID(v); err != nil {
		errors = append(errors, fmt.Errorf("expected %q to be a valid UUID, got %v", k, v))
	}

	return warnings, errors
}
