// Code generated by generators/gettag/main.go; DO NOT EDIT.

package keyvaluetags

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/ec2"
	"github.com/aws/aws-sdk-go/service/ecs"
	"github.com/aws/aws-sdk-go/service/route53resolver"
)

// DynamodbGetTag fetches an individual dynamodb service tag for a resource.
// Returns whether the key exists, the key value, and any errors.
// This function will optimise the handling over DynamodbListTags, if possible.
// The identifier is typically the Amazon Resource Name (ARN), although
// it may also be a different identifier depending on the service.
func DynamodbGetTag(conn *dynamodb.DynamoDB, identifier string, key string) (bool, *string, error) {
	listTags, err := DynamodbListTags(conn, identifier)

	if err != nil {
		return false, nil, err
	}

	return listTags.KeyExists(key), listTags.KeyValue(key), nil
}

// Ec2GetTag fetches an individual ec2 service tag for a resource.
// Returns whether the key exists, the key value, and any errors.
// This function will optimise the handling over Ec2ListTags, if possible.
// The identifier is typically the Amazon Resource Name (ARN), although
// it may also be a different identifier depending on the service.
func Ec2GetTag(conn *ec2.EC2, identifier string, key string) (bool, *string, error) {
	input := &ec2.DescribeTagsInput{
		Filters: []*ec2.Filter{
			{
				Name:   aws.String("resource-id"),
				Values: []*string{aws.String(identifier)},
			},
			{
				Name:   aws.String("key"),
				Values: []*string{aws.String(key)},
			},
		},
	}

	output, err := conn.DescribeTags(input)

	if err != nil {
		return false, nil, err
	}

	listTags := Ec2KeyValueTags(output.Tags)

	return listTags.KeyExists(key), listTags.KeyValue(key), nil
}

// EcsGetTag fetches an individual ecs service tag for a resource.
// Returns whether the key exists, the key value, and any errors.
// This function will optimise the handling over EcsListTags, if possible.
// The identifier is typically the Amazon Resource Name (ARN), although
// it may also be a different identifier depending on the service.
func EcsGetTag(conn *ecs.ECS, identifier string, key string) (bool, *string, error) {
	listTags, err := EcsListTags(conn, identifier)

	if err != nil {
		return false, nil, err
	}

	return listTags.KeyExists(key), listTags.KeyValue(key), nil
}

// Route53resolverGetTag fetches an individual route53resolver service tag for a resource.
// Returns whether the key exists, the key value, and any errors.
// This function will optimise the handling over Route53resolverListTags, if possible.
// The identifier is typically the Amazon Resource Name (ARN), although
// it may also be a different identifier depending on the service.
func Route53resolverGetTag(conn *route53resolver.Route53Resolver, identifier string, key string) (bool, *string, error) {
	listTags, err := Route53resolverListTags(conn, identifier)

	if err != nil {
		return false, nil, err
	}

	return listTags.KeyExists(key), listTags.KeyValue(key), nil
}
