// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restxml"
)

const opCreateCloudFrontOriginAccessIdentity = "CreateCloudFrontOriginAccessIdentity2019_03_26"

// CreateCloudFrontOriginAccessIdentityRequest generates a "aws/request.Request" representing the
// client's request for the CreateCloudFrontOriginAccessIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCloudFrontOriginAccessIdentity for more information on using the CreateCloudFrontOriginAccessIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCloudFrontOriginAccessIdentityRequest method.
//    req, resp := client.CreateCloudFrontOriginAccessIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateCloudFrontOriginAccessIdentity
func (c *CloudFront) CreateCloudFrontOriginAccessIdentityRequest(input *CreateCloudFrontOriginAccessIdentityInput) (req *request.Request, output *CreateCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opCreateCloudFrontOriginAccessIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-03-26/origin-access-identity/cloudfront",
	}

	if input == nil {
		input = &CreateCloudFrontOriginAccessIdentityInput{}
	}

	output = &CreateCloudFrontOriginAccessIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCloudFrontOriginAccessIdentity API operation for Amazon CloudFront.
//
// Creates a new origin access identity. If you're using Amazon S3 for your
// origin, you can use an origin access identity to require users to access
// your content using a CloudFront URL instead of the Amazon S3 URL. For more
// information about how to use origin access identities, see Serving Private
// Content through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
// in the Amazon CloudFront Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateCloudFrontOriginAccessIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOriginAccessIdentityAlreadyExists "CloudFrontOriginAccessIdentityAlreadyExists"
//   If the CallerReference is a value you already sent in a previous request
//   to create an identity but the content of the CloudFrontOriginAccessIdentityConfig
//   is different from the original request, CloudFront returns a CloudFrontOriginAccessIdentityAlreadyExists
//   error.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeTooManyCloudFrontOriginAccessIdentities "TooManyCloudFrontOriginAccessIdentities"
//   Processing your request would cause you to exceed the maximum number of origin
//   access identities allowed.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateCloudFrontOriginAccessIdentity
func (c *CloudFront) CreateCloudFrontOriginAccessIdentity(input *CreateCloudFrontOriginAccessIdentityInput) (*CreateCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.CreateCloudFrontOriginAccessIdentityRequest(input)
	return out, req.Send()
}

// CreateCloudFrontOriginAccessIdentityWithContext is the same as CreateCloudFrontOriginAccessIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCloudFrontOriginAccessIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateCloudFrontOriginAccessIdentityWithContext(ctx aws.Context, input *CreateCloudFrontOriginAccessIdentityInput, opts ...request.Option) (*CreateCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.CreateCloudFrontOriginAccessIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDistribution = "CreateDistribution2019_03_26"

// CreateDistributionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDistribution for more information on using the CreateDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDistributionRequest method.
//    req, resp := client.CreateDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateDistribution
func (c *CloudFront) CreateDistributionRequest(input *CreateDistributionInput) (req *request.Request, output *CreateDistributionOutput) {
	op := &request.Operation{
		Name:       opCreateDistribution,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-03-26/distribution",
	}

	if input == nil {
		input = &CreateDistributionInput{}
	}

	output = &CreateDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDistribution API operation for Amazon CloudFront.
//
// Creates a new web distribution. You create a CloudFront distribution to tell
// CloudFront where you want content to be delivered from, and the details about
// how to track and manage content delivery. Send a POST request to the /CloudFront
// API version/distribution/distribution ID resource.
//
// When you update a distribution, there are more required fields than when
// you create a distribution. When you update your distribution by using UpdateDistribution
// (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html),
// follow the steps included in the documentation to get the current configuration
// and then make your updates. This helps to make sure that you include all
// of the required fields. To view a summary, see Required Fields for Create
// Distribution and Update Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html)
// in the Amazon CloudFront Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeDistributionAlreadyExists "DistributionAlreadyExists"
//   The caller reference you attempted to create the distribution with is associated
//   with another distribution.
//
//   * ErrCodeInvalidOrigin "InvalidOrigin"
//   The Amazon S3 origin server specified does not refer to a valid Amazon S3
//   bucket.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeInvalidViewerCertificate "InvalidViewerCertificate"
//   A viewer certificate specified is not valid.
//
//   * ErrCodeInvalidMinimumProtocolVersion "InvalidMinimumProtocolVersion"
//   The minimum protocol version specified is not valid.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeTooManyDistributionCNAMEs "TooManyDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeTooManyDistributions "TooManyDistributions"
//   Processing your request would cause you to exceed the maximum number of distributions
//   allowed.
//
//   * ErrCodeInvalidDefaultRootObject "InvalidDefaultRootObject"
//   The default root object file name is too big or contains an invalid character.
//
//   * ErrCodeInvalidRelativePath "InvalidRelativePath"
//   The relative path is too big, is not URL-encoded, or does not begin with
//   a slash (/).
//
//   * ErrCodeInvalidErrorCode "InvalidErrorCode"
//   An invalid error code was specified.
//
//   * ErrCodeInvalidResponseCode "InvalidResponseCode"
//   A response code is not valid.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidRequiredProtocol "InvalidRequiredProtocol"
//   This operation requires the HTTPS protocol. Ensure that you specify the HTTPS
//   protocol in your request, or omit the RequiredProtocols element from your
//   distribution configuration.
//
//   * ErrCodeNoSuchOrigin "NoSuchOrigin"
//   No origin exists with the specified Origin Id.
//
//   * ErrCodeTooManyOrigins "TooManyOrigins"
//   You cannot create more origins for the distribution.
//
//   * ErrCodeTooManyOriginGroupsPerDistribution "TooManyOriginGroupsPerDistribution"
//   Processing your request would cause you to exceed the maximum number of origin
//   groups allowed.
//
//   * ErrCodeTooManyCacheBehaviors "TooManyCacheBehaviors"
//   You cannot create more cache behaviors for the distribution.
//
//   * ErrCodeTooManyCookieNamesInWhiteList "TooManyCookieNamesInWhiteList"
//   Your request contains more cookie names in the whitelist than are allowed
//   per cache behavior.
//
//   * ErrCodeInvalidForwardCookies "InvalidForwardCookies"
//   Your request contains forward cookies option which doesn't match with the
//   expectation for the whitelisted list of cookie names. Either list of cookie
//   names has been specified when not allowed or list of cookie names is missing
//   when expected.
//
//   * ErrCodeTooManyHeadersInForwardedValues "TooManyHeadersInForwardedValues"
//   Your request contains too many headers in forwarded values.
//
//   * ErrCodeInvalidHeadersForS3Origin "InvalidHeadersForS3Origin"
//   The headers specified are not valid for an Amazon S3 origin.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeTooManyCertificates "TooManyCertificates"
//   You cannot create anymore custom SSL/TLS certificates.
//
//   * ErrCodeInvalidLocationCode "InvalidLocationCode"
//   The location code specified is not valid.
//
//   * ErrCodeInvalidGeoRestrictionParameter "InvalidGeoRestrictionParameter"
//   The specified geo restriction parameter is not valid.
//
//   * ErrCodeInvalidProtocolSettings "InvalidProtocolSettings"
//   You cannot specify SSLv3 as the minimum protocol version if you only want
//   to support only clients that support Server Name Indication (SNI).
//
//   * ErrCodeInvalidTTLOrder "InvalidTTLOrder"
//   The TTL order specified is not valid.
//
//   * ErrCodeInvalidWebACLId "InvalidWebACLId"
//   A web ACL ID specified is not valid. To specify a web ACL created using the
//   latest version of AWS WAF, use the ACL ARN, for example arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
//   To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
//   473e64fd-f30b-4765-81a0-62ad96dd167a.
//
//   * ErrCodeTooManyOriginCustomHeaders "TooManyOriginCustomHeaders"
//   Your request contains too many origin custom headers.
//
//   * ErrCodeTooManyQueryStringParameters "TooManyQueryStringParameters"
//   Your request contains too many query string parameters.
//
//   * ErrCodeInvalidQueryStringParameters "InvalidQueryStringParameters"
//   The query string parameters specified are not valid.
//
//   * ErrCodeTooManyDistributionsWithLambdaAssociations "TooManyDistributionsWithLambdaAssociations"
//   Processing your request would cause the maximum number of distributions with
//   Lambda function associations per owner to be exceeded.
//
//   * ErrCodeTooManyLambdaFunctionAssociations "TooManyLambdaFunctionAssociations"
//   Your request contains more Lambda function associations than are allowed
//   per distribution.
//
//   * ErrCodeInvalidLambdaFunctionAssociation "InvalidLambdaFunctionAssociation"
//   The specified Lambda function association is invalid.
//
//   * ErrCodeInvalidOriginReadTimeout "InvalidOriginReadTimeout"
//   The read timeout specified for the origin is not valid.
//
//   * ErrCodeInvalidOriginKeepaliveTimeout "InvalidOriginKeepaliveTimeout"
//   The keep alive timeout specified for the origin is not valid.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
//   * ErrCodeIllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior"
//   The specified configuration for field-level encryption can't be associated
//   with the specified cache behavior.
//
//   * ErrCodeTooManyDistributionsAssociatedToFieldLevelEncryptionConfig "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig"
//   The maximum number of distributions have been associated with the specified
//   configuration for field-level encryption.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateDistribution
func (c *CloudFront) CreateDistribution(input *CreateDistributionInput) (*CreateDistributionOutput, error) {
	req, out := c.CreateDistributionRequest(input)
	return out, req.Send()
}

// CreateDistributionWithContext is the same as CreateDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateDistributionWithContext(ctx aws.Context, input *CreateDistributionInput, opts ...request.Option) (*CreateDistributionOutput, error) {
	req, out := c.CreateDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDistributionWithTags = "CreateDistributionWithTags2019_03_26"

// CreateDistributionWithTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateDistributionWithTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDistributionWithTags for more information on using the CreateDistributionWithTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDistributionWithTagsRequest method.
//    req, resp := client.CreateDistributionWithTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateDistributionWithTags
func (c *CloudFront) CreateDistributionWithTagsRequest(input *CreateDistributionWithTagsInput) (req *request.Request, output *CreateDistributionWithTagsOutput) {
	op := &request.Operation{
		Name:       opCreateDistributionWithTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-03-26/distribution?WithTags",
	}

	if input == nil {
		input = &CreateDistributionWithTagsInput{}
	}

	output = &CreateDistributionWithTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDistributionWithTags API operation for Amazon CloudFront.
//
// Create a new distribution with tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateDistributionWithTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeDistributionAlreadyExists "DistributionAlreadyExists"
//   The caller reference you attempted to create the distribution with is associated
//   with another distribution.
//
//   * ErrCodeInvalidOrigin "InvalidOrigin"
//   The Amazon S3 origin server specified does not refer to a valid Amazon S3
//   bucket.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeInvalidViewerCertificate "InvalidViewerCertificate"
//   A viewer certificate specified is not valid.
//
//   * ErrCodeInvalidMinimumProtocolVersion "InvalidMinimumProtocolVersion"
//   The minimum protocol version specified is not valid.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeTooManyDistributionCNAMEs "TooManyDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeTooManyDistributions "TooManyDistributions"
//   Processing your request would cause you to exceed the maximum number of distributions
//   allowed.
//
//   * ErrCodeInvalidDefaultRootObject "InvalidDefaultRootObject"
//   The default root object file name is too big or contains an invalid character.
//
//   * ErrCodeInvalidRelativePath "InvalidRelativePath"
//   The relative path is too big, is not URL-encoded, or does not begin with
//   a slash (/).
//
//   * ErrCodeInvalidErrorCode "InvalidErrorCode"
//   An invalid error code was specified.
//
//   * ErrCodeInvalidResponseCode "InvalidResponseCode"
//   A response code is not valid.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidRequiredProtocol "InvalidRequiredProtocol"
//   This operation requires the HTTPS protocol. Ensure that you specify the HTTPS
//   protocol in your request, or omit the RequiredProtocols element from your
//   distribution configuration.
//
//   * ErrCodeNoSuchOrigin "NoSuchOrigin"
//   No origin exists with the specified Origin Id.
//
//   * ErrCodeTooManyOrigins "TooManyOrigins"
//   You cannot create more origins for the distribution.
//
//   * ErrCodeTooManyOriginGroupsPerDistribution "TooManyOriginGroupsPerDistribution"
//   Processing your request would cause you to exceed the maximum number of origin
//   groups allowed.
//
//   * ErrCodeTooManyCacheBehaviors "TooManyCacheBehaviors"
//   You cannot create more cache behaviors for the distribution.
//
//   * ErrCodeTooManyCookieNamesInWhiteList "TooManyCookieNamesInWhiteList"
//   Your request contains more cookie names in the whitelist than are allowed
//   per cache behavior.
//
//   * ErrCodeInvalidForwardCookies "InvalidForwardCookies"
//   Your request contains forward cookies option which doesn't match with the
//   expectation for the whitelisted list of cookie names. Either list of cookie
//   names has been specified when not allowed or list of cookie names is missing
//   when expected.
//
//   * ErrCodeTooManyHeadersInForwardedValues "TooManyHeadersInForwardedValues"
//   Your request contains too many headers in forwarded values.
//
//   * ErrCodeInvalidHeadersForS3Origin "InvalidHeadersForS3Origin"
//   The headers specified are not valid for an Amazon S3 origin.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeTooManyCertificates "TooManyCertificates"
//   You cannot create anymore custom SSL/TLS certificates.
//
//   * ErrCodeInvalidLocationCode "InvalidLocationCode"
//   The location code specified is not valid.
//
//   * ErrCodeInvalidGeoRestrictionParameter "InvalidGeoRestrictionParameter"
//   The specified geo restriction parameter is not valid.
//
//   * ErrCodeInvalidProtocolSettings "InvalidProtocolSettings"
//   You cannot specify SSLv3 as the minimum protocol version if you only want
//   to support only clients that support Server Name Indication (SNI).
//
//   * ErrCodeInvalidTTLOrder "InvalidTTLOrder"
//   The TTL order specified is not valid.
//
//   * ErrCodeInvalidWebACLId "InvalidWebACLId"
//   A web ACL ID specified is not valid. To specify a web ACL created using the
//   latest version of AWS WAF, use the ACL ARN, for example arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
//   To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
//   473e64fd-f30b-4765-81a0-62ad96dd167a.
//
//   * ErrCodeTooManyOriginCustomHeaders "TooManyOriginCustomHeaders"
//   Your request contains too many origin custom headers.
//
//   * ErrCodeInvalidTagging "InvalidTagging"
//   The tagging specified is not valid.
//
//   * ErrCodeTooManyQueryStringParameters "TooManyQueryStringParameters"
//   Your request contains too many query string parameters.
//
//   * ErrCodeInvalidQueryStringParameters "InvalidQueryStringParameters"
//   The query string parameters specified are not valid.
//
//   * ErrCodeTooManyDistributionsWithLambdaAssociations "TooManyDistributionsWithLambdaAssociations"
//   Processing your request would cause the maximum number of distributions with
//   Lambda function associations per owner to be exceeded.
//
//   * ErrCodeTooManyLambdaFunctionAssociations "TooManyLambdaFunctionAssociations"
//   Your request contains more Lambda function associations than are allowed
//   per distribution.
//
//   * ErrCodeInvalidLambdaFunctionAssociation "InvalidLambdaFunctionAssociation"
//   The specified Lambda function association is invalid.
//
//   * ErrCodeInvalidOriginReadTimeout "InvalidOriginReadTimeout"
//   The read timeout specified for the origin is not valid.
//
//   * ErrCodeInvalidOriginKeepaliveTimeout "InvalidOriginKeepaliveTimeout"
//   The keep alive timeout specified for the origin is not valid.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
//   * ErrCodeIllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior"
//   The specified configuration for field-level encryption can't be associated
//   with the specified cache behavior.
//
//   * ErrCodeTooManyDistributionsAssociatedToFieldLevelEncryptionConfig "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig"
//   The maximum number of distributions have been associated with the specified
//   configuration for field-level encryption.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateDistributionWithTags
func (c *CloudFront) CreateDistributionWithTags(input *CreateDistributionWithTagsInput) (*CreateDistributionWithTagsOutput, error) {
	req, out := c.CreateDistributionWithTagsRequest(input)
	return out, req.Send()
}

// CreateDistributionWithTagsWithContext is the same as CreateDistributionWithTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDistributionWithTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateDistributionWithTagsWithContext(ctx aws.Context, input *CreateDistributionWithTagsInput, opts ...request.Option) (*CreateDistributionWithTagsOutput, error) {
	req, out := c.CreateDistributionWithTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFieldLevelEncryptionConfig = "CreateFieldLevelEncryptionConfig2019_03_26"

// CreateFieldLevelEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateFieldLevelEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFieldLevelEncryptionConfig for more information on using the CreateFieldLevelEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFieldLevelEncryptionConfigRequest method.
//    req, resp := client.CreateFieldLevelEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateFieldLevelEncryptionConfig
func (c *CloudFront) CreateFieldLevelEncryptionConfigRequest(input *CreateFieldLevelEncryptionConfigInput) (req *request.Request, output *CreateFieldLevelEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opCreateFieldLevelEncryptionConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-03-26/field-level-encryption",
	}

	if input == nil {
		input = &CreateFieldLevelEncryptionConfigInput{}
	}

	output = &CreateFieldLevelEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFieldLevelEncryptionConfig API operation for Amazon CloudFront.
//
// Create a new field-level encryption configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateFieldLevelEncryptionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
//   * ErrCodeFieldLevelEncryptionConfigAlreadyExists "FieldLevelEncryptionConfigAlreadyExists"
//   The specified configuration for field-level encryption already exists.
//
//   * ErrCodeTooManyFieldLevelEncryptionConfigs "TooManyFieldLevelEncryptionConfigs"
//   The maximum number of configurations for field-level encryption have been
//   created.
//
//   * ErrCodeTooManyFieldLevelEncryptionQueryArgProfiles "TooManyFieldLevelEncryptionQueryArgProfiles"
//   The maximum number of query arg profiles for field-level encryption have
//   been created.
//
//   * ErrCodeTooManyFieldLevelEncryptionContentTypeProfiles "TooManyFieldLevelEncryptionContentTypeProfiles"
//   The maximum number of content type profiles for field-level encryption have
//   been created.
//
//   * ErrCodeQueryArgProfileEmpty "QueryArgProfileEmpty"
//   No profile specified for the field-level encryption query argument.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateFieldLevelEncryptionConfig
func (c *CloudFront) CreateFieldLevelEncryptionConfig(input *CreateFieldLevelEncryptionConfigInput) (*CreateFieldLevelEncryptionConfigOutput, error) {
	req, out := c.CreateFieldLevelEncryptionConfigRequest(input)
	return out, req.Send()
}

// CreateFieldLevelEncryptionConfigWithContext is the same as CreateFieldLevelEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFieldLevelEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateFieldLevelEncryptionConfigWithContext(ctx aws.Context, input *CreateFieldLevelEncryptionConfigInput, opts ...request.Option) (*CreateFieldLevelEncryptionConfigOutput, error) {
	req, out := c.CreateFieldLevelEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFieldLevelEncryptionProfile = "CreateFieldLevelEncryptionProfile2019_03_26"

// CreateFieldLevelEncryptionProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateFieldLevelEncryptionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFieldLevelEncryptionProfile for more information on using the CreateFieldLevelEncryptionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFieldLevelEncryptionProfileRequest method.
//    req, resp := client.CreateFieldLevelEncryptionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateFieldLevelEncryptionProfile
func (c *CloudFront) CreateFieldLevelEncryptionProfileRequest(input *CreateFieldLevelEncryptionProfileInput) (req *request.Request, output *CreateFieldLevelEncryptionProfileOutput) {
	op := &request.Operation{
		Name:       opCreateFieldLevelEncryptionProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-03-26/field-level-encryption-profile",
	}

	if input == nil {
		input = &CreateFieldLevelEncryptionProfileInput{}
	}

	output = &CreateFieldLevelEncryptionProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFieldLevelEncryptionProfile API operation for Amazon CloudFront.
//
// Create a field-level encryption profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateFieldLevelEncryptionProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
//   * ErrCodeFieldLevelEncryptionProfileAlreadyExists "FieldLevelEncryptionProfileAlreadyExists"
//   The specified profile for field-level encryption already exists.
//
//   * ErrCodeFieldLevelEncryptionProfileSizeExceeded "FieldLevelEncryptionProfileSizeExceeded"
//   The maximum size of a profile for field-level encryption was exceeded.
//
//   * ErrCodeTooManyFieldLevelEncryptionProfiles "TooManyFieldLevelEncryptionProfiles"
//   The maximum number of profiles for field-level encryption have been created.
//
//   * ErrCodeTooManyFieldLevelEncryptionEncryptionEntities "TooManyFieldLevelEncryptionEncryptionEntities"
//   The maximum number of encryption entities for field-level encryption have
//   been created.
//
//   * ErrCodeTooManyFieldLevelEncryptionFieldPatterns "TooManyFieldLevelEncryptionFieldPatterns"
//   The maximum number of field patterns for field-level encryption have been
//   created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateFieldLevelEncryptionProfile
func (c *CloudFront) CreateFieldLevelEncryptionProfile(input *CreateFieldLevelEncryptionProfileInput) (*CreateFieldLevelEncryptionProfileOutput, error) {
	req, out := c.CreateFieldLevelEncryptionProfileRequest(input)
	return out, req.Send()
}

// CreateFieldLevelEncryptionProfileWithContext is the same as CreateFieldLevelEncryptionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFieldLevelEncryptionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateFieldLevelEncryptionProfileWithContext(ctx aws.Context, input *CreateFieldLevelEncryptionProfileInput, opts ...request.Option) (*CreateFieldLevelEncryptionProfileOutput, error) {
	req, out := c.CreateFieldLevelEncryptionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInvalidation = "CreateInvalidation2019_03_26"

// CreateInvalidationRequest generates a "aws/request.Request" representing the
// client's request for the CreateInvalidation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInvalidation for more information on using the CreateInvalidation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInvalidationRequest method.
//    req, resp := client.CreateInvalidationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateInvalidation
func (c *CloudFront) CreateInvalidationRequest(input *CreateInvalidationInput) (req *request.Request, output *CreateInvalidationOutput) {
	op := &request.Operation{
		Name:       opCreateInvalidation,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-03-26/distribution/{DistributionId}/invalidation",
	}

	if input == nil {
		input = &CreateInvalidationInput{}
	}

	output = &CreateInvalidationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInvalidation API operation for Amazon CloudFront.
//
// Create a new invalidation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateInvalidation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodeBatchTooLarge "BatchTooLarge"
//   Invalidation batch specified is too large.
//
//   * ErrCodeTooManyInvalidationsInProgress "TooManyInvalidationsInProgress"
//   You have exceeded the maximum number of allowable InProgress invalidation
//   batch requests, or invalidation objects.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateInvalidation
func (c *CloudFront) CreateInvalidation(input *CreateInvalidationInput) (*CreateInvalidationOutput, error) {
	req, out := c.CreateInvalidationRequest(input)
	return out, req.Send()
}

// CreateInvalidationWithContext is the same as CreateInvalidation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInvalidation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateInvalidationWithContext(ctx aws.Context, input *CreateInvalidationInput, opts ...request.Option) (*CreateInvalidationOutput, error) {
	req, out := c.CreateInvalidationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePublicKey = "CreatePublicKey2019_03_26"

// CreatePublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreatePublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePublicKey for more information on using the CreatePublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePublicKeyRequest method.
//    req, resp := client.CreatePublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreatePublicKey
func (c *CloudFront) CreatePublicKeyRequest(input *CreatePublicKeyInput) (req *request.Request, output *CreatePublicKeyOutput) {
	op := &request.Operation{
		Name:       opCreatePublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-03-26/public-key",
	}

	if input == nil {
		input = &CreatePublicKeyInput{}
	}

	output = &CreatePublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePublicKey API operation for Amazon CloudFront.
//
// Add a new public key to CloudFront to use, for example, for field-level encryption.
// You can add a maximum of 10 public keys with one AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreatePublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodePublicKeyAlreadyExists "PublicKeyAlreadyExists"
//   The specified public key already exists.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeTooManyPublicKeys "TooManyPublicKeys"
//   The maximum number of public keys for field-level encryption have been created.
//   To create a new public key, delete one of the existing keys.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreatePublicKey
func (c *CloudFront) CreatePublicKey(input *CreatePublicKeyInput) (*CreatePublicKeyOutput, error) {
	req, out := c.CreatePublicKeyRequest(input)
	return out, req.Send()
}

// CreatePublicKeyWithContext is the same as CreatePublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreatePublicKeyWithContext(ctx aws.Context, input *CreatePublicKeyInput, opts ...request.Option) (*CreatePublicKeyOutput, error) {
	req, out := c.CreatePublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamingDistribution = "CreateStreamingDistribution2019_03_26"

// CreateStreamingDistributionRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamingDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamingDistribution for more information on using the CreateStreamingDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStreamingDistributionRequest method.
//    req, resp := client.CreateStreamingDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateStreamingDistribution
func (c *CloudFront) CreateStreamingDistributionRequest(input *CreateStreamingDistributionInput) (req *request.Request, output *CreateStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opCreateStreamingDistribution,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-03-26/streaming-distribution",
	}

	if input == nil {
		input = &CreateStreamingDistributionInput{}
	}

	output = &CreateStreamingDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamingDistribution API operation for Amazon CloudFront.
//
// Creates a new RTMP distribution. An RTMP distribution is similar to a web
// distribution, but an RTMP distribution streams media files using the Adobe
// Real-Time Messaging Protocol (RTMP) instead of serving files using HTTP.
//
// To create a new distribution, submit a POST request to the CloudFront API
// version/distribution resource. The request body must include a document with
// a StreamingDistributionConfig element. The response echoes the StreamingDistributionConfig
// element and returns other information about the RTMP distribution.
//
// To get the status of your request, use the GET StreamingDistribution API
// action. When the value of Enabled is true and the value of Status is Deployed,
// your distribution is ready. A distribution usually deploys in less than 15
// minutes.
//
// For more information about web distributions, see Working with RTMP Distributions
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-rtmp.html)
// in the Amazon CloudFront Developer Guide.
//
// Beginning with the 2012-05-05 version of the CloudFront API, we made substantial
// changes to the format of the XML document that you include in the request
// body when you create or update a web distribution or an RTMP distribution,
// and when you invalidate objects. With previous versions of the API, we discovered
// that it was too easy to accidentally delete one or more values for an element
// that accepts multiple values, for example, CNAMEs and trusted signers. Our
// changes for the 2012-05-05 release are intended to prevent these accidental
// deletions and to notify you when there's a mismatch between the number of
// values you say you're specifying in the Quantity element and the number of
// values specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateStreamingDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeStreamingDistributionAlreadyExists "StreamingDistributionAlreadyExists"
//   The caller reference you attempted to create the streaming distribution with
//   is associated with another distribution
//
//   * ErrCodeInvalidOrigin "InvalidOrigin"
//   The Amazon S3 origin server specified does not refer to a valid Amazon S3
//   bucket.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeTooManyStreamingDistributionCNAMEs "TooManyStreamingDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeTooManyStreamingDistributions "TooManyStreamingDistributions"
//   Processing your request would cause you to exceed the maximum number of streaming
//   distributions allowed.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateStreamingDistribution
func (c *CloudFront) CreateStreamingDistribution(input *CreateStreamingDistributionInput) (*CreateStreamingDistributionOutput, error) {
	req, out := c.CreateStreamingDistributionRequest(input)
	return out, req.Send()
}

// CreateStreamingDistributionWithContext is the same as CreateStreamingDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamingDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateStreamingDistributionWithContext(ctx aws.Context, input *CreateStreamingDistributionInput, opts ...request.Option) (*CreateStreamingDistributionOutput, error) {
	req, out := c.CreateStreamingDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamingDistributionWithTags = "CreateStreamingDistributionWithTags2019_03_26"

// CreateStreamingDistributionWithTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamingDistributionWithTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamingDistributionWithTags for more information on using the CreateStreamingDistributionWithTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStreamingDistributionWithTagsRequest method.
//    req, resp := client.CreateStreamingDistributionWithTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateStreamingDistributionWithTags
func (c *CloudFront) CreateStreamingDistributionWithTagsRequest(input *CreateStreamingDistributionWithTagsInput) (req *request.Request, output *CreateStreamingDistributionWithTagsOutput) {
	op := &request.Operation{
		Name:       opCreateStreamingDistributionWithTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-03-26/streaming-distribution?WithTags",
	}

	if input == nil {
		input = &CreateStreamingDistributionWithTagsInput{}
	}

	output = &CreateStreamingDistributionWithTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamingDistributionWithTags API operation for Amazon CloudFront.
//
// Create a new streaming distribution with tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation CreateStreamingDistributionWithTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeStreamingDistributionAlreadyExists "StreamingDistributionAlreadyExists"
//   The caller reference you attempted to create the streaming distribution with
//   is associated with another distribution
//
//   * ErrCodeInvalidOrigin "InvalidOrigin"
//   The Amazon S3 origin server specified does not refer to a valid Amazon S3
//   bucket.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeTooManyStreamingDistributionCNAMEs "TooManyStreamingDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeTooManyStreamingDistributions "TooManyStreamingDistributions"
//   Processing your request would cause you to exceed the maximum number of streaming
//   distributions allowed.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidTagging "InvalidTagging"
//   The tagging specified is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateStreamingDistributionWithTags
func (c *CloudFront) CreateStreamingDistributionWithTags(input *CreateStreamingDistributionWithTagsInput) (*CreateStreamingDistributionWithTagsOutput, error) {
	req, out := c.CreateStreamingDistributionWithTagsRequest(input)
	return out, req.Send()
}

// CreateStreamingDistributionWithTagsWithContext is the same as CreateStreamingDistributionWithTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamingDistributionWithTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) CreateStreamingDistributionWithTagsWithContext(ctx aws.Context, input *CreateStreamingDistributionWithTagsInput, opts ...request.Option) (*CreateStreamingDistributionWithTagsOutput, error) {
	req, out := c.CreateStreamingDistributionWithTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCloudFrontOriginAccessIdentity = "DeleteCloudFrontOriginAccessIdentity2019_03_26"

// DeleteCloudFrontOriginAccessIdentityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCloudFrontOriginAccessIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCloudFrontOriginAccessIdentity for more information on using the DeleteCloudFrontOriginAccessIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCloudFrontOriginAccessIdentityRequest method.
//    req, resp := client.DeleteCloudFrontOriginAccessIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteCloudFrontOriginAccessIdentity
func (c *CloudFront) DeleteCloudFrontOriginAccessIdentityRequest(input *DeleteCloudFrontOriginAccessIdentityInput) (req *request.Request, output *DeleteCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opDeleteCloudFrontOriginAccessIdentity,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2019-03-26/origin-access-identity/cloudfront/{Id}",
	}

	if input == nil {
		input = &DeleteCloudFrontOriginAccessIdentityInput{}
	}

	output = &DeleteCloudFrontOriginAccessIdentityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCloudFrontOriginAccessIdentity API operation for Amazon CloudFront.
//
// Delete an origin access identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteCloudFrontOriginAccessIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeNoSuchCloudFrontOriginAccessIdentity "NoSuchCloudFrontOriginAccessIdentity"
//   The specified origin access identity does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeOriginAccessIdentityInUse "CloudFrontOriginAccessIdentityInUse"
//   The Origin Access Identity specified is already in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteCloudFrontOriginAccessIdentity
func (c *CloudFront) DeleteCloudFrontOriginAccessIdentity(input *DeleteCloudFrontOriginAccessIdentityInput) (*DeleteCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.DeleteCloudFrontOriginAccessIdentityRequest(input)
	return out, req.Send()
}

// DeleteCloudFrontOriginAccessIdentityWithContext is the same as DeleteCloudFrontOriginAccessIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCloudFrontOriginAccessIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteCloudFrontOriginAccessIdentityWithContext(ctx aws.Context, input *DeleteCloudFrontOriginAccessIdentityInput, opts ...request.Option) (*DeleteCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.DeleteCloudFrontOriginAccessIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDistribution = "DeleteDistribution2019_03_26"

// DeleteDistributionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDistribution for more information on using the DeleteDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDistributionRequest method.
//    req, resp := client.DeleteDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteDistribution
func (c *CloudFront) DeleteDistributionRequest(input *DeleteDistributionInput) (req *request.Request, output *DeleteDistributionOutput) {
	op := &request.Operation{
		Name:       opDeleteDistribution,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2019-03-26/distribution/{Id}",
	}

	if input == nil {
		input = &DeleteDistributionInput{}
	}

	output = &DeleteDistributionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDistribution API operation for Amazon CloudFront.
//
// Delete a distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeDistributionNotDisabled "DistributionNotDisabled"
//   The specified CloudFront distribution is not disabled. You must disable the
//   distribution before you can delete it.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteDistribution
func (c *CloudFront) DeleteDistribution(input *DeleteDistributionInput) (*DeleteDistributionOutput, error) {
	req, out := c.DeleteDistributionRequest(input)
	return out, req.Send()
}

// DeleteDistributionWithContext is the same as DeleteDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteDistributionWithContext(ctx aws.Context, input *DeleteDistributionInput, opts ...request.Option) (*DeleteDistributionOutput, error) {
	req, out := c.DeleteDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFieldLevelEncryptionConfig = "DeleteFieldLevelEncryptionConfig2019_03_26"

// DeleteFieldLevelEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFieldLevelEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFieldLevelEncryptionConfig for more information on using the DeleteFieldLevelEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFieldLevelEncryptionConfigRequest method.
//    req, resp := client.DeleteFieldLevelEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteFieldLevelEncryptionConfig
func (c *CloudFront) DeleteFieldLevelEncryptionConfigRequest(input *DeleteFieldLevelEncryptionConfigInput) (req *request.Request, output *DeleteFieldLevelEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteFieldLevelEncryptionConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2019-03-26/field-level-encryption/{Id}",
	}

	if input == nil {
		input = &DeleteFieldLevelEncryptionConfigInput{}
	}

	output = &DeleteFieldLevelEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFieldLevelEncryptionConfig API operation for Amazon CloudFront.
//
// Remove a field-level encryption configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteFieldLevelEncryptionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeFieldLevelEncryptionConfigInUse "FieldLevelEncryptionConfigInUse"
//   The specified configuration for field-level encryption is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteFieldLevelEncryptionConfig
func (c *CloudFront) DeleteFieldLevelEncryptionConfig(input *DeleteFieldLevelEncryptionConfigInput) (*DeleteFieldLevelEncryptionConfigOutput, error) {
	req, out := c.DeleteFieldLevelEncryptionConfigRequest(input)
	return out, req.Send()
}

// DeleteFieldLevelEncryptionConfigWithContext is the same as DeleteFieldLevelEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFieldLevelEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteFieldLevelEncryptionConfigWithContext(ctx aws.Context, input *DeleteFieldLevelEncryptionConfigInput, opts ...request.Option) (*DeleteFieldLevelEncryptionConfigOutput, error) {
	req, out := c.DeleteFieldLevelEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFieldLevelEncryptionProfile = "DeleteFieldLevelEncryptionProfile2019_03_26"

// DeleteFieldLevelEncryptionProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFieldLevelEncryptionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFieldLevelEncryptionProfile for more information on using the DeleteFieldLevelEncryptionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFieldLevelEncryptionProfileRequest method.
//    req, resp := client.DeleteFieldLevelEncryptionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteFieldLevelEncryptionProfile
func (c *CloudFront) DeleteFieldLevelEncryptionProfileRequest(input *DeleteFieldLevelEncryptionProfileInput) (req *request.Request, output *DeleteFieldLevelEncryptionProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteFieldLevelEncryptionProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2019-03-26/field-level-encryption-profile/{Id}",
	}

	if input == nil {
		input = &DeleteFieldLevelEncryptionProfileInput{}
	}

	output = &DeleteFieldLevelEncryptionProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFieldLevelEncryptionProfile API operation for Amazon CloudFront.
//
// Remove a field-level encryption profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteFieldLevelEncryptionProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeFieldLevelEncryptionProfileInUse "FieldLevelEncryptionProfileInUse"
//   The specified profile for field-level encryption is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteFieldLevelEncryptionProfile
func (c *CloudFront) DeleteFieldLevelEncryptionProfile(input *DeleteFieldLevelEncryptionProfileInput) (*DeleteFieldLevelEncryptionProfileOutput, error) {
	req, out := c.DeleteFieldLevelEncryptionProfileRequest(input)
	return out, req.Send()
}

// DeleteFieldLevelEncryptionProfileWithContext is the same as DeleteFieldLevelEncryptionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFieldLevelEncryptionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteFieldLevelEncryptionProfileWithContext(ctx aws.Context, input *DeleteFieldLevelEncryptionProfileInput, opts ...request.Option) (*DeleteFieldLevelEncryptionProfileOutput, error) {
	req, out := c.DeleteFieldLevelEncryptionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePublicKey = "DeletePublicKey2019_03_26"

// DeletePublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePublicKey for more information on using the DeletePublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePublicKeyRequest method.
//    req, resp := client.DeletePublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeletePublicKey
func (c *CloudFront) DeletePublicKeyRequest(input *DeletePublicKeyInput) (req *request.Request, output *DeletePublicKeyOutput) {
	op := &request.Operation{
		Name:       opDeletePublicKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2019-03-26/public-key/{Id}",
	}

	if input == nil {
		input = &DeletePublicKeyInput{}
	}

	output = &DeletePublicKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePublicKey API operation for Amazon CloudFront.
//
// Remove a public key you previously added to CloudFront.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeletePublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodePublicKeyInUse "PublicKeyInUse"
//   The specified public key is in use.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeletePublicKey
func (c *CloudFront) DeletePublicKey(input *DeletePublicKeyInput) (*DeletePublicKeyOutput, error) {
	req, out := c.DeletePublicKeyRequest(input)
	return out, req.Send()
}

// DeletePublicKeyWithContext is the same as DeletePublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeletePublicKeyWithContext(ctx aws.Context, input *DeletePublicKeyInput, opts ...request.Option) (*DeletePublicKeyOutput, error) {
	req, out := c.DeletePublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStreamingDistribution = "DeleteStreamingDistribution2019_03_26"

// DeleteStreamingDistributionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStreamingDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStreamingDistribution for more information on using the DeleteStreamingDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStreamingDistributionRequest method.
//    req, resp := client.DeleteStreamingDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteStreamingDistribution
func (c *CloudFront) DeleteStreamingDistributionRequest(input *DeleteStreamingDistributionInput) (req *request.Request, output *DeleteStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opDeleteStreamingDistribution,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2019-03-26/streaming-distribution/{Id}",
	}

	if input == nil {
		input = &DeleteStreamingDistributionInput{}
	}

	output = &DeleteStreamingDistributionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStreamingDistribution API operation for Amazon CloudFront.
//
// Delete a streaming distribution. To delete an RTMP distribution using the
// CloudFront API, perform the following steps.
//
// To delete an RTMP distribution using the CloudFront API:
//
// Disable the RTMP distribution.
//
// Submit a GET Streaming Distribution Config request to get the current configuration
// and the Etag header for the distribution.
//
// Update the XML document that was returned in the response to your GET Streaming
// Distribution Config request to change the value of Enabled to false.
//
// Submit a PUT Streaming Distribution Config request to update the configuration
// for your distribution. In the request body, include the XML document that
// you updated in Step 3. Then set the value of the HTTP If-Match header to
// the value of the ETag header that CloudFront returned when you submitted
// the GET Streaming Distribution Config request in Step 2.
//
// Review the response to the PUT Streaming Distribution Config request to confirm
// that the distribution was successfully disabled.
//
// Submit a GET Streaming Distribution Config request to confirm that your changes
// have propagated. When propagation is complete, the value of Status is Deployed.
//
// Submit a DELETE Streaming Distribution request. Set the value of the HTTP
// If-Match header to the value of the ETag header that CloudFront returned
// when you submitted the GET Streaming Distribution Config request in Step
// 2.
//
// Review the response to your DELETE Streaming Distribution request to confirm
// that the distribution was successfully deleted.
//
// For information about deleting a distribution using the CloudFront console,
// see Deleting a Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html)
// in the Amazon CloudFront Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation DeleteStreamingDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeStreamingDistributionNotDisabled "StreamingDistributionNotDisabled"
//   The specified CloudFront distribution is not disabled. You must disable the
//   distribution before you can delete it.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeNoSuchStreamingDistribution "NoSuchStreamingDistribution"
//   The specified streaming distribution does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteStreamingDistribution
func (c *CloudFront) DeleteStreamingDistribution(input *DeleteStreamingDistributionInput) (*DeleteStreamingDistributionOutput, error) {
	req, out := c.DeleteStreamingDistributionRequest(input)
	return out, req.Send()
}

// DeleteStreamingDistributionWithContext is the same as DeleteStreamingDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStreamingDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) DeleteStreamingDistributionWithContext(ctx aws.Context, input *DeleteStreamingDistributionInput, opts ...request.Option) (*DeleteStreamingDistributionOutput, error) {
	req, out := c.DeleteStreamingDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCloudFrontOriginAccessIdentity = "GetCloudFrontOriginAccessIdentity2019_03_26"

// GetCloudFrontOriginAccessIdentityRequest generates a "aws/request.Request" representing the
// client's request for the GetCloudFrontOriginAccessIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCloudFrontOriginAccessIdentity for more information on using the GetCloudFrontOriginAccessIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCloudFrontOriginAccessIdentityRequest method.
//    req, resp := client.GetCloudFrontOriginAccessIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetCloudFrontOriginAccessIdentity
func (c *CloudFront) GetCloudFrontOriginAccessIdentityRequest(input *GetCloudFrontOriginAccessIdentityInput) (req *request.Request, output *GetCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opGetCloudFrontOriginAccessIdentity,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/origin-access-identity/cloudfront/{Id}",
	}

	if input == nil {
		input = &GetCloudFrontOriginAccessIdentityInput{}
	}

	output = &GetCloudFrontOriginAccessIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCloudFrontOriginAccessIdentity API operation for Amazon CloudFront.
//
// Get the information about an origin access identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetCloudFrontOriginAccessIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchCloudFrontOriginAccessIdentity "NoSuchCloudFrontOriginAccessIdentity"
//   The specified origin access identity does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetCloudFrontOriginAccessIdentity
func (c *CloudFront) GetCloudFrontOriginAccessIdentity(input *GetCloudFrontOriginAccessIdentityInput) (*GetCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.GetCloudFrontOriginAccessIdentityRequest(input)
	return out, req.Send()
}

// GetCloudFrontOriginAccessIdentityWithContext is the same as GetCloudFrontOriginAccessIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See GetCloudFrontOriginAccessIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetCloudFrontOriginAccessIdentityWithContext(ctx aws.Context, input *GetCloudFrontOriginAccessIdentityInput, opts ...request.Option) (*GetCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.GetCloudFrontOriginAccessIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCloudFrontOriginAccessIdentityConfig = "GetCloudFrontOriginAccessIdentityConfig2019_03_26"

// GetCloudFrontOriginAccessIdentityConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetCloudFrontOriginAccessIdentityConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCloudFrontOriginAccessIdentityConfig for more information on using the GetCloudFrontOriginAccessIdentityConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCloudFrontOriginAccessIdentityConfigRequest method.
//    req, resp := client.GetCloudFrontOriginAccessIdentityConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetCloudFrontOriginAccessIdentityConfig
func (c *CloudFront) GetCloudFrontOriginAccessIdentityConfigRequest(input *GetCloudFrontOriginAccessIdentityConfigInput) (req *request.Request, output *GetCloudFrontOriginAccessIdentityConfigOutput) {
	op := &request.Operation{
		Name:       opGetCloudFrontOriginAccessIdentityConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/origin-access-identity/cloudfront/{Id}/config",
	}

	if input == nil {
		input = &GetCloudFrontOriginAccessIdentityConfigInput{}
	}

	output = &GetCloudFrontOriginAccessIdentityConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCloudFrontOriginAccessIdentityConfig API operation for Amazon CloudFront.
//
// Get the configuration information about an origin access identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetCloudFrontOriginAccessIdentityConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchCloudFrontOriginAccessIdentity "NoSuchCloudFrontOriginAccessIdentity"
//   The specified origin access identity does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetCloudFrontOriginAccessIdentityConfig
func (c *CloudFront) GetCloudFrontOriginAccessIdentityConfig(input *GetCloudFrontOriginAccessIdentityConfigInput) (*GetCloudFrontOriginAccessIdentityConfigOutput, error) {
	req, out := c.GetCloudFrontOriginAccessIdentityConfigRequest(input)
	return out, req.Send()
}

// GetCloudFrontOriginAccessIdentityConfigWithContext is the same as GetCloudFrontOriginAccessIdentityConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetCloudFrontOriginAccessIdentityConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetCloudFrontOriginAccessIdentityConfigWithContext(ctx aws.Context, input *GetCloudFrontOriginAccessIdentityConfigInput, opts ...request.Option) (*GetCloudFrontOriginAccessIdentityConfigOutput, error) {
	req, out := c.GetCloudFrontOriginAccessIdentityConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDistribution = "GetDistribution2019_03_26"

// GetDistributionRequest generates a "aws/request.Request" representing the
// client's request for the GetDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDistribution for more information on using the GetDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDistributionRequest method.
//    req, resp := client.GetDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetDistribution
func (c *CloudFront) GetDistributionRequest(input *GetDistributionInput) (req *request.Request, output *GetDistributionOutput) {
	op := &request.Operation{
		Name:       opGetDistribution,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/distribution/{Id}",
	}

	if input == nil {
		input = &GetDistributionInput{}
	}

	output = &GetDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDistribution API operation for Amazon CloudFront.
//
// Get the information about a distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetDistribution
func (c *CloudFront) GetDistribution(input *GetDistributionInput) (*GetDistributionOutput, error) {
	req, out := c.GetDistributionRequest(input)
	return out, req.Send()
}

// GetDistributionWithContext is the same as GetDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See GetDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetDistributionWithContext(ctx aws.Context, input *GetDistributionInput, opts ...request.Option) (*GetDistributionOutput, error) {
	req, out := c.GetDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDistributionConfig = "GetDistributionConfig2019_03_26"

// GetDistributionConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetDistributionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDistributionConfig for more information on using the GetDistributionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDistributionConfigRequest method.
//    req, resp := client.GetDistributionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetDistributionConfig
func (c *CloudFront) GetDistributionConfigRequest(input *GetDistributionConfigInput) (req *request.Request, output *GetDistributionConfigOutput) {
	op := &request.Operation{
		Name:       opGetDistributionConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/distribution/{Id}/config",
	}

	if input == nil {
		input = &GetDistributionConfigInput{}
	}

	output = &GetDistributionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDistributionConfig API operation for Amazon CloudFront.
//
// Get the configuration information about a distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetDistributionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetDistributionConfig
func (c *CloudFront) GetDistributionConfig(input *GetDistributionConfigInput) (*GetDistributionConfigOutput, error) {
	req, out := c.GetDistributionConfigRequest(input)
	return out, req.Send()
}

// GetDistributionConfigWithContext is the same as GetDistributionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetDistributionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetDistributionConfigWithContext(ctx aws.Context, input *GetDistributionConfigInput, opts ...request.Option) (*GetDistributionConfigOutput, error) {
	req, out := c.GetDistributionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFieldLevelEncryption = "GetFieldLevelEncryption2019_03_26"

// GetFieldLevelEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the GetFieldLevelEncryption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFieldLevelEncryption for more information on using the GetFieldLevelEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFieldLevelEncryptionRequest method.
//    req, resp := client.GetFieldLevelEncryptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryption
func (c *CloudFront) GetFieldLevelEncryptionRequest(input *GetFieldLevelEncryptionInput) (req *request.Request, output *GetFieldLevelEncryptionOutput) {
	op := &request.Operation{
		Name:       opGetFieldLevelEncryption,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/field-level-encryption/{Id}",
	}

	if input == nil {
		input = &GetFieldLevelEncryptionInput{}
	}

	output = &GetFieldLevelEncryptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFieldLevelEncryption API operation for Amazon CloudFront.
//
// Get the field-level encryption configuration information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetFieldLevelEncryption for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryption
func (c *CloudFront) GetFieldLevelEncryption(input *GetFieldLevelEncryptionInput) (*GetFieldLevelEncryptionOutput, error) {
	req, out := c.GetFieldLevelEncryptionRequest(input)
	return out, req.Send()
}

// GetFieldLevelEncryptionWithContext is the same as GetFieldLevelEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See GetFieldLevelEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetFieldLevelEncryptionWithContext(ctx aws.Context, input *GetFieldLevelEncryptionInput, opts ...request.Option) (*GetFieldLevelEncryptionOutput, error) {
	req, out := c.GetFieldLevelEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFieldLevelEncryptionConfig = "GetFieldLevelEncryptionConfig2019_03_26"

// GetFieldLevelEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetFieldLevelEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFieldLevelEncryptionConfig for more information on using the GetFieldLevelEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFieldLevelEncryptionConfigRequest method.
//    req, resp := client.GetFieldLevelEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionConfig
func (c *CloudFront) GetFieldLevelEncryptionConfigRequest(input *GetFieldLevelEncryptionConfigInput) (req *request.Request, output *GetFieldLevelEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opGetFieldLevelEncryptionConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/field-level-encryption/{Id}/config",
	}

	if input == nil {
		input = &GetFieldLevelEncryptionConfigInput{}
	}

	output = &GetFieldLevelEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFieldLevelEncryptionConfig API operation for Amazon CloudFront.
//
// Get the field-level encryption configuration information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetFieldLevelEncryptionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionConfig
func (c *CloudFront) GetFieldLevelEncryptionConfig(input *GetFieldLevelEncryptionConfigInput) (*GetFieldLevelEncryptionConfigOutput, error) {
	req, out := c.GetFieldLevelEncryptionConfigRequest(input)
	return out, req.Send()
}

// GetFieldLevelEncryptionConfigWithContext is the same as GetFieldLevelEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetFieldLevelEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetFieldLevelEncryptionConfigWithContext(ctx aws.Context, input *GetFieldLevelEncryptionConfigInput, opts ...request.Option) (*GetFieldLevelEncryptionConfigOutput, error) {
	req, out := c.GetFieldLevelEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFieldLevelEncryptionProfile = "GetFieldLevelEncryptionProfile2019_03_26"

// GetFieldLevelEncryptionProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetFieldLevelEncryptionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFieldLevelEncryptionProfile for more information on using the GetFieldLevelEncryptionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFieldLevelEncryptionProfileRequest method.
//    req, resp := client.GetFieldLevelEncryptionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionProfile
func (c *CloudFront) GetFieldLevelEncryptionProfileRequest(input *GetFieldLevelEncryptionProfileInput) (req *request.Request, output *GetFieldLevelEncryptionProfileOutput) {
	op := &request.Operation{
		Name:       opGetFieldLevelEncryptionProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/field-level-encryption-profile/{Id}",
	}

	if input == nil {
		input = &GetFieldLevelEncryptionProfileInput{}
	}

	output = &GetFieldLevelEncryptionProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFieldLevelEncryptionProfile API operation for Amazon CloudFront.
//
// Get the field-level encryption profile information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetFieldLevelEncryptionProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionProfile
func (c *CloudFront) GetFieldLevelEncryptionProfile(input *GetFieldLevelEncryptionProfileInput) (*GetFieldLevelEncryptionProfileOutput, error) {
	req, out := c.GetFieldLevelEncryptionProfileRequest(input)
	return out, req.Send()
}

// GetFieldLevelEncryptionProfileWithContext is the same as GetFieldLevelEncryptionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetFieldLevelEncryptionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetFieldLevelEncryptionProfileWithContext(ctx aws.Context, input *GetFieldLevelEncryptionProfileInput, opts ...request.Option) (*GetFieldLevelEncryptionProfileOutput, error) {
	req, out := c.GetFieldLevelEncryptionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFieldLevelEncryptionProfileConfig = "GetFieldLevelEncryptionProfileConfig2019_03_26"

// GetFieldLevelEncryptionProfileConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetFieldLevelEncryptionProfileConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFieldLevelEncryptionProfileConfig for more information on using the GetFieldLevelEncryptionProfileConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFieldLevelEncryptionProfileConfigRequest method.
//    req, resp := client.GetFieldLevelEncryptionProfileConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionProfileConfig
func (c *CloudFront) GetFieldLevelEncryptionProfileConfigRequest(input *GetFieldLevelEncryptionProfileConfigInput) (req *request.Request, output *GetFieldLevelEncryptionProfileConfigOutput) {
	op := &request.Operation{
		Name:       opGetFieldLevelEncryptionProfileConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/field-level-encryption-profile/{Id}/config",
	}

	if input == nil {
		input = &GetFieldLevelEncryptionProfileConfigInput{}
	}

	output = &GetFieldLevelEncryptionProfileConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFieldLevelEncryptionProfileConfig API operation for Amazon CloudFront.
//
// Get the field-level encryption profile configuration information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetFieldLevelEncryptionProfileConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionProfileConfig
func (c *CloudFront) GetFieldLevelEncryptionProfileConfig(input *GetFieldLevelEncryptionProfileConfigInput) (*GetFieldLevelEncryptionProfileConfigOutput, error) {
	req, out := c.GetFieldLevelEncryptionProfileConfigRequest(input)
	return out, req.Send()
}

// GetFieldLevelEncryptionProfileConfigWithContext is the same as GetFieldLevelEncryptionProfileConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetFieldLevelEncryptionProfileConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetFieldLevelEncryptionProfileConfigWithContext(ctx aws.Context, input *GetFieldLevelEncryptionProfileConfigInput, opts ...request.Option) (*GetFieldLevelEncryptionProfileConfigOutput, error) {
	req, out := c.GetFieldLevelEncryptionProfileConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInvalidation = "GetInvalidation2019_03_26"

// GetInvalidationRequest generates a "aws/request.Request" representing the
// client's request for the GetInvalidation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInvalidation for more information on using the GetInvalidation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInvalidationRequest method.
//    req, resp := client.GetInvalidationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetInvalidation
func (c *CloudFront) GetInvalidationRequest(input *GetInvalidationInput) (req *request.Request, output *GetInvalidationOutput) {
	op := &request.Operation{
		Name:       opGetInvalidation,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/distribution/{DistributionId}/invalidation/{Id}",
	}

	if input == nil {
		input = &GetInvalidationInput{}
	}

	output = &GetInvalidationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInvalidation API operation for Amazon CloudFront.
//
// Get the information about an invalidation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetInvalidation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchInvalidation "NoSuchInvalidation"
//   The specified invalidation does not exist.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetInvalidation
func (c *CloudFront) GetInvalidation(input *GetInvalidationInput) (*GetInvalidationOutput, error) {
	req, out := c.GetInvalidationRequest(input)
	return out, req.Send()
}

// GetInvalidationWithContext is the same as GetInvalidation with the addition of
// the ability to pass a context and additional request options.
//
// See GetInvalidation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetInvalidationWithContext(ctx aws.Context, input *GetInvalidationInput, opts ...request.Option) (*GetInvalidationOutput, error) {
	req, out := c.GetInvalidationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicKey = "GetPublicKey2019_03_26"

// GetPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicKey for more information on using the GetPublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPublicKeyRequest method.
//    req, resp := client.GetPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetPublicKey
func (c *CloudFront) GetPublicKeyRequest(input *GetPublicKeyInput) (req *request.Request, output *GetPublicKeyOutput) {
	op := &request.Operation{
		Name:       opGetPublicKey,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/public-key/{Id}",
	}

	if input == nil {
		input = &GetPublicKeyInput{}
	}

	output = &GetPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPublicKey API operation for Amazon CloudFront.
//
// Get the public key information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetPublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetPublicKey
func (c *CloudFront) GetPublicKey(input *GetPublicKeyInput) (*GetPublicKeyOutput, error) {
	req, out := c.GetPublicKeyRequest(input)
	return out, req.Send()
}

// GetPublicKeyWithContext is the same as GetPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetPublicKeyWithContext(ctx aws.Context, input *GetPublicKeyInput, opts ...request.Option) (*GetPublicKeyOutput, error) {
	req, out := c.GetPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPublicKeyConfig = "GetPublicKeyConfig2019_03_26"

// GetPublicKeyConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetPublicKeyConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPublicKeyConfig for more information on using the GetPublicKeyConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPublicKeyConfigRequest method.
//    req, resp := client.GetPublicKeyConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetPublicKeyConfig
func (c *CloudFront) GetPublicKeyConfigRequest(input *GetPublicKeyConfigInput) (req *request.Request, output *GetPublicKeyConfigOutput) {
	op := &request.Operation{
		Name:       opGetPublicKeyConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/public-key/{Id}/config",
	}

	if input == nil {
		input = &GetPublicKeyConfigInput{}
	}

	output = &GetPublicKeyConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPublicKeyConfig API operation for Amazon CloudFront.
//
// Return public key configuration informaation
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetPublicKeyConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetPublicKeyConfig
func (c *CloudFront) GetPublicKeyConfig(input *GetPublicKeyConfigInput) (*GetPublicKeyConfigOutput, error) {
	req, out := c.GetPublicKeyConfigRequest(input)
	return out, req.Send()
}

// GetPublicKeyConfigWithContext is the same as GetPublicKeyConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetPublicKeyConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetPublicKeyConfigWithContext(ctx aws.Context, input *GetPublicKeyConfigInput, opts ...request.Option) (*GetPublicKeyConfigOutput, error) {
	req, out := c.GetPublicKeyConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStreamingDistribution = "GetStreamingDistribution2019_03_26"

// GetStreamingDistributionRequest generates a "aws/request.Request" representing the
// client's request for the GetStreamingDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStreamingDistribution for more information on using the GetStreamingDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStreamingDistributionRequest method.
//    req, resp := client.GetStreamingDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetStreamingDistribution
func (c *CloudFront) GetStreamingDistributionRequest(input *GetStreamingDistributionInput) (req *request.Request, output *GetStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opGetStreamingDistribution,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/streaming-distribution/{Id}",
	}

	if input == nil {
		input = &GetStreamingDistributionInput{}
	}

	output = &GetStreamingDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStreamingDistribution API operation for Amazon CloudFront.
//
// Gets information about a specified RTMP distribution, including the distribution
// configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetStreamingDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchStreamingDistribution "NoSuchStreamingDistribution"
//   The specified streaming distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetStreamingDistribution
func (c *CloudFront) GetStreamingDistribution(input *GetStreamingDistributionInput) (*GetStreamingDistributionOutput, error) {
	req, out := c.GetStreamingDistributionRequest(input)
	return out, req.Send()
}

// GetStreamingDistributionWithContext is the same as GetStreamingDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See GetStreamingDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetStreamingDistributionWithContext(ctx aws.Context, input *GetStreamingDistributionInput, opts ...request.Option) (*GetStreamingDistributionOutput, error) {
	req, out := c.GetStreamingDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStreamingDistributionConfig = "GetStreamingDistributionConfig2019_03_26"

// GetStreamingDistributionConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetStreamingDistributionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStreamingDistributionConfig for more information on using the GetStreamingDistributionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStreamingDistributionConfigRequest method.
//    req, resp := client.GetStreamingDistributionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetStreamingDistributionConfig
func (c *CloudFront) GetStreamingDistributionConfigRequest(input *GetStreamingDistributionConfigInput) (req *request.Request, output *GetStreamingDistributionConfigOutput) {
	op := &request.Operation{
		Name:       opGetStreamingDistributionConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/streaming-distribution/{Id}/config",
	}

	if input == nil {
		input = &GetStreamingDistributionConfigInput{}
	}

	output = &GetStreamingDistributionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStreamingDistributionConfig API operation for Amazon CloudFront.
//
// Get the configuration information about a streaming distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation GetStreamingDistributionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchStreamingDistribution "NoSuchStreamingDistribution"
//   The specified streaming distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetStreamingDistributionConfig
func (c *CloudFront) GetStreamingDistributionConfig(input *GetStreamingDistributionConfigInput) (*GetStreamingDistributionConfigOutput, error) {
	req, out := c.GetStreamingDistributionConfigRequest(input)
	return out, req.Send()
}

// GetStreamingDistributionConfigWithContext is the same as GetStreamingDistributionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetStreamingDistributionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) GetStreamingDistributionConfigWithContext(ctx aws.Context, input *GetStreamingDistributionConfigInput, opts ...request.Option) (*GetStreamingDistributionConfigOutput, error) {
	req, out := c.GetStreamingDistributionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCloudFrontOriginAccessIdentities = "ListCloudFrontOriginAccessIdentities2019_03_26"

// ListCloudFrontOriginAccessIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListCloudFrontOriginAccessIdentities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCloudFrontOriginAccessIdentities for more information on using the ListCloudFrontOriginAccessIdentities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCloudFrontOriginAccessIdentitiesRequest method.
//    req, resp := client.ListCloudFrontOriginAccessIdentitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListCloudFrontOriginAccessIdentities
func (c *CloudFront) ListCloudFrontOriginAccessIdentitiesRequest(input *ListCloudFrontOriginAccessIdentitiesInput) (req *request.Request, output *ListCloudFrontOriginAccessIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListCloudFrontOriginAccessIdentities,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/origin-access-identity/cloudfront",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"CloudFrontOriginAccessIdentityList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "CloudFrontOriginAccessIdentityList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListCloudFrontOriginAccessIdentitiesInput{}
	}

	output = &ListCloudFrontOriginAccessIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCloudFrontOriginAccessIdentities API operation for Amazon CloudFront.
//
// Lists origin access identities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListCloudFrontOriginAccessIdentities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListCloudFrontOriginAccessIdentities
func (c *CloudFront) ListCloudFrontOriginAccessIdentities(input *ListCloudFrontOriginAccessIdentitiesInput) (*ListCloudFrontOriginAccessIdentitiesOutput, error) {
	req, out := c.ListCloudFrontOriginAccessIdentitiesRequest(input)
	return out, req.Send()
}

// ListCloudFrontOriginAccessIdentitiesWithContext is the same as ListCloudFrontOriginAccessIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See ListCloudFrontOriginAccessIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListCloudFrontOriginAccessIdentitiesWithContext(ctx aws.Context, input *ListCloudFrontOriginAccessIdentitiesInput, opts ...request.Option) (*ListCloudFrontOriginAccessIdentitiesOutput, error) {
	req, out := c.ListCloudFrontOriginAccessIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCloudFrontOriginAccessIdentitiesPages iterates over the pages of a ListCloudFrontOriginAccessIdentities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCloudFrontOriginAccessIdentities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCloudFrontOriginAccessIdentities operation.
//    pageNum := 0
//    err := client.ListCloudFrontOriginAccessIdentitiesPages(params,
//        func(page *cloudfront.ListCloudFrontOriginAccessIdentitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFront) ListCloudFrontOriginAccessIdentitiesPages(input *ListCloudFrontOriginAccessIdentitiesInput, fn func(*ListCloudFrontOriginAccessIdentitiesOutput, bool) bool) error {
	return c.ListCloudFrontOriginAccessIdentitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCloudFrontOriginAccessIdentitiesPagesWithContext same as ListCloudFrontOriginAccessIdentitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListCloudFrontOriginAccessIdentitiesPagesWithContext(ctx aws.Context, input *ListCloudFrontOriginAccessIdentitiesInput, fn func(*ListCloudFrontOriginAccessIdentitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCloudFrontOriginAccessIdentitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCloudFrontOriginAccessIdentitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCloudFrontOriginAccessIdentitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDistributions = "ListDistributions2019_03_26"

// ListDistributionsRequest generates a "aws/request.Request" representing the
// client's request for the ListDistributions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDistributions for more information on using the ListDistributions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDistributionsRequest method.
//    req, resp := client.ListDistributionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListDistributions
func (c *CloudFront) ListDistributionsRequest(input *ListDistributionsInput) (req *request.Request, output *ListDistributionsOutput) {
	op := &request.Operation{
		Name:       opListDistributions,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/distribution",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"DistributionList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "DistributionList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListDistributionsInput{}
	}

	output = &ListDistributionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDistributions API operation for Amazon CloudFront.
//
// List CloudFront distributions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListDistributions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListDistributions
func (c *CloudFront) ListDistributions(input *ListDistributionsInput) (*ListDistributionsOutput, error) {
	req, out := c.ListDistributionsRequest(input)
	return out, req.Send()
}

// ListDistributionsWithContext is the same as ListDistributions with the addition of
// the ability to pass a context and additional request options.
//
// See ListDistributions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListDistributionsWithContext(ctx aws.Context, input *ListDistributionsInput, opts ...request.Option) (*ListDistributionsOutput, error) {
	req, out := c.ListDistributionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDistributionsPages iterates over the pages of a ListDistributions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDistributions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDistributions operation.
//    pageNum := 0
//    err := client.ListDistributionsPages(params,
//        func(page *cloudfront.ListDistributionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFront) ListDistributionsPages(input *ListDistributionsInput, fn func(*ListDistributionsOutput, bool) bool) error {
	return c.ListDistributionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDistributionsPagesWithContext same as ListDistributionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListDistributionsPagesWithContext(ctx aws.Context, input *ListDistributionsInput, fn func(*ListDistributionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDistributionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDistributionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDistributionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDistributionsByWebACLId = "ListDistributionsByWebACLId2019_03_26"

// ListDistributionsByWebACLIdRequest generates a "aws/request.Request" representing the
// client's request for the ListDistributionsByWebACLId operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDistributionsByWebACLId for more information on using the ListDistributionsByWebACLId
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDistributionsByWebACLIdRequest method.
//    req, resp := client.ListDistributionsByWebACLIdRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListDistributionsByWebACLId
func (c *CloudFront) ListDistributionsByWebACLIdRequest(input *ListDistributionsByWebACLIdInput) (req *request.Request, output *ListDistributionsByWebACLIdOutput) {
	op := &request.Operation{
		Name:       opListDistributionsByWebACLId,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/distributionsByWebACLId/{WebACLId}",
	}

	if input == nil {
		input = &ListDistributionsByWebACLIdInput{}
	}

	output = &ListDistributionsByWebACLIdOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDistributionsByWebACLId API operation for Amazon CloudFront.
//
// List the distributions that are associated with a specified AWS WAF web ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListDistributionsByWebACLId for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidWebACLId "InvalidWebACLId"
//   A web ACL ID specified is not valid. To specify a web ACL created using the
//   latest version of AWS WAF, use the ACL ARN, for example arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
//   To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
//   473e64fd-f30b-4765-81a0-62ad96dd167a.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListDistributionsByWebACLId
func (c *CloudFront) ListDistributionsByWebACLId(input *ListDistributionsByWebACLIdInput) (*ListDistributionsByWebACLIdOutput, error) {
	req, out := c.ListDistributionsByWebACLIdRequest(input)
	return out, req.Send()
}

// ListDistributionsByWebACLIdWithContext is the same as ListDistributionsByWebACLId with the addition of
// the ability to pass a context and additional request options.
//
// See ListDistributionsByWebACLId for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListDistributionsByWebACLIdWithContext(ctx aws.Context, input *ListDistributionsByWebACLIdInput, opts ...request.Option) (*ListDistributionsByWebACLIdOutput, error) {
	req, out := c.ListDistributionsByWebACLIdRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFieldLevelEncryptionConfigs = "ListFieldLevelEncryptionConfigs2019_03_26"

// ListFieldLevelEncryptionConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListFieldLevelEncryptionConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFieldLevelEncryptionConfigs for more information on using the ListFieldLevelEncryptionConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFieldLevelEncryptionConfigsRequest method.
//    req, resp := client.ListFieldLevelEncryptionConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionConfigs
func (c *CloudFront) ListFieldLevelEncryptionConfigsRequest(input *ListFieldLevelEncryptionConfigsInput) (req *request.Request, output *ListFieldLevelEncryptionConfigsOutput) {
	op := &request.Operation{
		Name:       opListFieldLevelEncryptionConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/field-level-encryption",
	}

	if input == nil {
		input = &ListFieldLevelEncryptionConfigsInput{}
	}

	output = &ListFieldLevelEncryptionConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFieldLevelEncryptionConfigs API operation for Amazon CloudFront.
//
// List all field-level encryption configurations that have been created in
// CloudFront for this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListFieldLevelEncryptionConfigs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionConfigs
func (c *CloudFront) ListFieldLevelEncryptionConfigs(input *ListFieldLevelEncryptionConfigsInput) (*ListFieldLevelEncryptionConfigsOutput, error) {
	req, out := c.ListFieldLevelEncryptionConfigsRequest(input)
	return out, req.Send()
}

// ListFieldLevelEncryptionConfigsWithContext is the same as ListFieldLevelEncryptionConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListFieldLevelEncryptionConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListFieldLevelEncryptionConfigsWithContext(ctx aws.Context, input *ListFieldLevelEncryptionConfigsInput, opts ...request.Option) (*ListFieldLevelEncryptionConfigsOutput, error) {
	req, out := c.ListFieldLevelEncryptionConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFieldLevelEncryptionProfiles = "ListFieldLevelEncryptionProfiles2019_03_26"

// ListFieldLevelEncryptionProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListFieldLevelEncryptionProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFieldLevelEncryptionProfiles for more information on using the ListFieldLevelEncryptionProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFieldLevelEncryptionProfilesRequest method.
//    req, resp := client.ListFieldLevelEncryptionProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionProfiles
func (c *CloudFront) ListFieldLevelEncryptionProfilesRequest(input *ListFieldLevelEncryptionProfilesInput) (req *request.Request, output *ListFieldLevelEncryptionProfilesOutput) {
	op := &request.Operation{
		Name:       opListFieldLevelEncryptionProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/field-level-encryption-profile",
	}

	if input == nil {
		input = &ListFieldLevelEncryptionProfilesInput{}
	}

	output = &ListFieldLevelEncryptionProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFieldLevelEncryptionProfiles API operation for Amazon CloudFront.
//
// Request a list of field-level encryption profiles that have been created
// in CloudFront for this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListFieldLevelEncryptionProfiles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionProfiles
func (c *CloudFront) ListFieldLevelEncryptionProfiles(input *ListFieldLevelEncryptionProfilesInput) (*ListFieldLevelEncryptionProfilesOutput, error) {
	req, out := c.ListFieldLevelEncryptionProfilesRequest(input)
	return out, req.Send()
}

// ListFieldLevelEncryptionProfilesWithContext is the same as ListFieldLevelEncryptionProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListFieldLevelEncryptionProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListFieldLevelEncryptionProfilesWithContext(ctx aws.Context, input *ListFieldLevelEncryptionProfilesInput, opts ...request.Option) (*ListFieldLevelEncryptionProfilesOutput, error) {
	req, out := c.ListFieldLevelEncryptionProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListInvalidations = "ListInvalidations2019_03_26"

// ListInvalidationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvalidations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvalidations for more information on using the ListInvalidations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInvalidationsRequest method.
//    req, resp := client.ListInvalidationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListInvalidations
func (c *CloudFront) ListInvalidationsRequest(input *ListInvalidationsInput) (req *request.Request, output *ListInvalidationsOutput) {
	op := &request.Operation{
		Name:       opListInvalidations,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/distribution/{DistributionId}/invalidation",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"InvalidationList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "InvalidationList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListInvalidationsInput{}
	}

	output = &ListInvalidationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvalidations API operation for Amazon CloudFront.
//
// Lists invalidation batches.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListInvalidations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListInvalidations
func (c *CloudFront) ListInvalidations(input *ListInvalidationsInput) (*ListInvalidationsOutput, error) {
	req, out := c.ListInvalidationsRequest(input)
	return out, req.Send()
}

// ListInvalidationsWithContext is the same as ListInvalidations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvalidations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListInvalidationsWithContext(ctx aws.Context, input *ListInvalidationsInput, opts ...request.Option) (*ListInvalidationsOutput, error) {
	req, out := c.ListInvalidationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvalidationsPages iterates over the pages of a ListInvalidations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvalidations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInvalidations operation.
//    pageNum := 0
//    err := client.ListInvalidationsPages(params,
//        func(page *cloudfront.ListInvalidationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFront) ListInvalidationsPages(input *ListInvalidationsInput, fn func(*ListInvalidationsOutput, bool) bool) error {
	return c.ListInvalidationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvalidationsPagesWithContext same as ListInvalidationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListInvalidationsPagesWithContext(ctx aws.Context, input *ListInvalidationsInput, fn func(*ListInvalidationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvalidationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvalidationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInvalidationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPublicKeys = "ListPublicKeys2019_03_26"

// ListPublicKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListPublicKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPublicKeys for more information on using the ListPublicKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPublicKeysRequest method.
//    req, resp := client.ListPublicKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListPublicKeys
func (c *CloudFront) ListPublicKeysRequest(input *ListPublicKeysInput) (req *request.Request, output *ListPublicKeysOutput) {
	op := &request.Operation{
		Name:       opListPublicKeys,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/public-key",
	}

	if input == nil {
		input = &ListPublicKeysInput{}
	}

	output = &ListPublicKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPublicKeys API operation for Amazon CloudFront.
//
// List all public keys that have been added to CloudFront for this account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListPublicKeys for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListPublicKeys
func (c *CloudFront) ListPublicKeys(input *ListPublicKeysInput) (*ListPublicKeysOutput, error) {
	req, out := c.ListPublicKeysRequest(input)
	return out, req.Send()
}

// ListPublicKeysWithContext is the same as ListPublicKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListPublicKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListPublicKeysWithContext(ctx aws.Context, input *ListPublicKeysInput, opts ...request.Option) (*ListPublicKeysOutput, error) {
	req, out := c.ListPublicKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStreamingDistributions = "ListStreamingDistributions2019_03_26"

// ListStreamingDistributionsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreamingDistributions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreamingDistributions for more information on using the ListStreamingDistributions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStreamingDistributionsRequest method.
//    req, resp := client.ListStreamingDistributionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListStreamingDistributions
func (c *CloudFront) ListStreamingDistributionsRequest(input *ListStreamingDistributionsInput) (req *request.Request, output *ListStreamingDistributionsOutput) {
	op := &request.Operation{
		Name:       opListStreamingDistributions,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/streaming-distribution",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"StreamingDistributionList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "StreamingDistributionList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListStreamingDistributionsInput{}
	}

	output = &ListStreamingDistributionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreamingDistributions API operation for Amazon CloudFront.
//
// List streaming distributions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListStreamingDistributions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListStreamingDistributions
func (c *CloudFront) ListStreamingDistributions(input *ListStreamingDistributionsInput) (*ListStreamingDistributionsOutput, error) {
	req, out := c.ListStreamingDistributionsRequest(input)
	return out, req.Send()
}

// ListStreamingDistributionsWithContext is the same as ListStreamingDistributions with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreamingDistributions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListStreamingDistributionsWithContext(ctx aws.Context, input *ListStreamingDistributionsInput, opts ...request.Option) (*ListStreamingDistributionsOutput, error) {
	req, out := c.ListStreamingDistributionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamingDistributionsPages iterates over the pages of a ListStreamingDistributions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreamingDistributions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStreamingDistributions operation.
//    pageNum := 0
//    err := client.ListStreamingDistributionsPages(params,
//        func(page *cloudfront.ListStreamingDistributionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudFront) ListStreamingDistributionsPages(input *ListStreamingDistributionsInput, fn func(*ListStreamingDistributionsOutput, bool) bool) error {
	return c.ListStreamingDistributionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamingDistributionsPagesWithContext same as ListStreamingDistributionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListStreamingDistributionsPagesWithContext(ctx aws.Context, input *ListStreamingDistributionsInput, fn func(*ListStreamingDistributionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamingDistributionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamingDistributionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamingDistributionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource2019_03_26"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListTagsForResource
func (c *CloudFront) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-03-26/tagging",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CloudFront.
//
// List tags for a CloudFront resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidTagging "InvalidTagging"
//   The tagging specified is not valid.
//
//   * ErrCodeNoSuchResource "NoSuchResource"
//   A resource that was specified is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListTagsForResource
func (c *CloudFront) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource2019_03_26"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/TagResource
func (c *CloudFront) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-03-26/tagging?Operation=Tag",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon CloudFront.
//
// Add tags to a CloudFront resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidTagging "InvalidTagging"
//   The tagging specified is not valid.
//
//   * ErrCodeNoSuchResource "NoSuchResource"
//   A resource that was specified is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/TagResource
func (c *CloudFront) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource2019_03_26"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UntagResource
func (c *CloudFront) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-03-26/tagging?Operation=Untag",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restxml.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon CloudFront.
//
// Remove tags from a CloudFront resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidTagging "InvalidTagging"
//   The tagging specified is not valid.
//
//   * ErrCodeNoSuchResource "NoSuchResource"
//   A resource that was specified is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UntagResource
func (c *CloudFront) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCloudFrontOriginAccessIdentity = "UpdateCloudFrontOriginAccessIdentity2019_03_26"

// UpdateCloudFrontOriginAccessIdentityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCloudFrontOriginAccessIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCloudFrontOriginAccessIdentity for more information on using the UpdateCloudFrontOriginAccessIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCloudFrontOriginAccessIdentityRequest method.
//    req, resp := client.UpdateCloudFrontOriginAccessIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateCloudFrontOriginAccessIdentity
func (c *CloudFront) UpdateCloudFrontOriginAccessIdentityRequest(input *UpdateCloudFrontOriginAccessIdentityInput) (req *request.Request, output *UpdateCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opUpdateCloudFrontOriginAccessIdentity,
		HTTPMethod: "PUT",
		HTTPPath:   "/2019-03-26/origin-access-identity/cloudfront/{Id}/config",
	}

	if input == nil {
		input = &UpdateCloudFrontOriginAccessIdentityInput{}
	}

	output = &UpdateCloudFrontOriginAccessIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCloudFrontOriginAccessIdentity API operation for Amazon CloudFront.
//
// Update an origin access identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateCloudFrontOriginAccessIdentity for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   Origin and CallerReference cannot be updated.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeNoSuchCloudFrontOriginAccessIdentity "NoSuchCloudFrontOriginAccessIdentity"
//   The specified origin access identity does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateCloudFrontOriginAccessIdentity
func (c *CloudFront) UpdateCloudFrontOriginAccessIdentity(input *UpdateCloudFrontOriginAccessIdentityInput) (*UpdateCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.UpdateCloudFrontOriginAccessIdentityRequest(input)
	return out, req.Send()
}

// UpdateCloudFrontOriginAccessIdentityWithContext is the same as UpdateCloudFrontOriginAccessIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCloudFrontOriginAccessIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateCloudFrontOriginAccessIdentityWithContext(ctx aws.Context, input *UpdateCloudFrontOriginAccessIdentityInput, opts ...request.Option) (*UpdateCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.UpdateCloudFrontOriginAccessIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDistribution = "UpdateDistribution2019_03_26"

// UpdateDistributionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDistribution for more information on using the UpdateDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDistributionRequest method.
//    req, resp := client.UpdateDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateDistribution
func (c *CloudFront) UpdateDistributionRequest(input *UpdateDistributionInput) (req *request.Request, output *UpdateDistributionOutput) {
	op := &request.Operation{
		Name:       opUpdateDistribution,
		HTTPMethod: "PUT",
		HTTPPath:   "/2019-03-26/distribution/{Id}/config",
	}

	if input == nil {
		input = &UpdateDistributionInput{}
	}

	output = &UpdateDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDistribution API operation for Amazon CloudFront.
//
// Updates the configuration for a web distribution.
//
// When you update a distribution, there are more required fields than when
// you create a distribution. When you update your distribution by using this
// API action, follow the steps here to get the current configuration and then
// make your updates, to make sure that you include all of the required fields.
// To view a summary, see Required Fields for Create Distribution and Update
// Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html)
// in the Amazon CloudFront Developer Guide.
//
// The update process includes getting the current distribution configuration,
// updating the XML document that is returned to make your changes, and then
// submitting an UpdateDistribution request to make the updates.
//
// For information about updating a distribution using the CloudFront console
// instead, see Creating a Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html)
// in the Amazon CloudFront Developer Guide.
//
// To update a web distribution using the CloudFront API
//
// Submit a GetDistributionConfig (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html)
// request to get the current configuration and an Etag header for the distribution.
//
// If you update the distribution again, you must get a new Etag header.
//
// Update the XML document that was returned in the response to your GetDistributionConfig
// request to include your changes.
//
// When you edit the XML file, be aware of the following:
//
//    * You must strip out the ETag parameter that is returned.
//
//    * Additional fields are required when you update a distribution. There
//    may be fields included in the XML file for features that you haven't configured
//    for your distribution. This is expected and required to successfully update
//    the distribution.
//
//    * You can't change the value of CallerReference. If you try to change
//    this value, CloudFront returns an IllegalUpdate error.
//
//    * The new configuration replaces the existing configuration; the values
//    that you specify in an UpdateDistribution request are not merged into
//    your existing configuration. When you add, delete, or replace values in
//    an element that allows multiple values (for example, CNAME), you must
//    specify all of the values that you want to appear in the updated distribution.
//    In addition, you must update the corresponding Quantity element.
//
// Submit an UpdateDistribution request to update the configuration for your
// distribution:
//
//    * In the request body, include the XML document that you updated in Step
//    2. The request body must include an XML document with a DistributionConfig
//    element.
//
//    * Set the value of the HTTP If-Match header to the value of the ETag header
//    that CloudFront returned when you submitted the GetDistributionConfig
//    request in Step 1.
//
// Review the response to the UpdateDistribution request to confirm that the
// configuration was successfully updated.
//
// Optional: Submit a GetDistribution (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html)
// request to confirm that your changes have propagated. When propagation is
// complete, the value of Status is Deployed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   Origin and CallerReference cannot be updated.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeNoSuchDistribution "NoSuchDistribution"
//   The specified distribution does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeTooManyDistributionCNAMEs "TooManyDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeInvalidDefaultRootObject "InvalidDefaultRootObject"
//   The default root object file name is too big or contains an invalid character.
//
//   * ErrCodeInvalidRelativePath "InvalidRelativePath"
//   The relative path is too big, is not URL-encoded, or does not begin with
//   a slash (/).
//
//   * ErrCodeInvalidErrorCode "InvalidErrorCode"
//   An invalid error code was specified.
//
//   * ErrCodeInvalidResponseCode "InvalidResponseCode"
//   A response code is not valid.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeInvalidViewerCertificate "InvalidViewerCertificate"
//   A viewer certificate specified is not valid.
//
//   * ErrCodeInvalidMinimumProtocolVersion "InvalidMinimumProtocolVersion"
//   The minimum protocol version specified is not valid.
//
//   * ErrCodeInvalidRequiredProtocol "InvalidRequiredProtocol"
//   This operation requires the HTTPS protocol. Ensure that you specify the HTTPS
//   protocol in your request, or omit the RequiredProtocols element from your
//   distribution configuration.
//
//   * ErrCodeNoSuchOrigin "NoSuchOrigin"
//   No origin exists with the specified Origin Id.
//
//   * ErrCodeTooManyOrigins "TooManyOrigins"
//   You cannot create more origins for the distribution.
//
//   * ErrCodeTooManyOriginGroupsPerDistribution "TooManyOriginGroupsPerDistribution"
//   Processing your request would cause you to exceed the maximum number of origin
//   groups allowed.
//
//   * ErrCodeTooManyCacheBehaviors "TooManyCacheBehaviors"
//   You cannot create more cache behaviors for the distribution.
//
//   * ErrCodeTooManyCookieNamesInWhiteList "TooManyCookieNamesInWhiteList"
//   Your request contains more cookie names in the whitelist than are allowed
//   per cache behavior.
//
//   * ErrCodeInvalidForwardCookies "InvalidForwardCookies"
//   Your request contains forward cookies option which doesn't match with the
//   expectation for the whitelisted list of cookie names. Either list of cookie
//   names has been specified when not allowed or list of cookie names is missing
//   when expected.
//
//   * ErrCodeTooManyHeadersInForwardedValues "TooManyHeadersInForwardedValues"
//   Your request contains too many headers in forwarded values.
//
//   * ErrCodeInvalidHeadersForS3Origin "InvalidHeadersForS3Origin"
//   The headers specified are not valid for an Amazon S3 origin.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeTooManyCertificates "TooManyCertificates"
//   You cannot create anymore custom SSL/TLS certificates.
//
//   * ErrCodeInvalidLocationCode "InvalidLocationCode"
//   The location code specified is not valid.
//
//   * ErrCodeInvalidGeoRestrictionParameter "InvalidGeoRestrictionParameter"
//   The specified geo restriction parameter is not valid.
//
//   * ErrCodeInvalidTTLOrder "InvalidTTLOrder"
//   The TTL order specified is not valid.
//
//   * ErrCodeInvalidWebACLId "InvalidWebACLId"
//   A web ACL ID specified is not valid. To specify a web ACL created using the
//   latest version of AWS WAF, use the ACL ARN, for example arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
//   To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
//   473e64fd-f30b-4765-81a0-62ad96dd167a.
//
//   * ErrCodeTooManyOriginCustomHeaders "TooManyOriginCustomHeaders"
//   Your request contains too many origin custom headers.
//
//   * ErrCodeTooManyQueryStringParameters "TooManyQueryStringParameters"
//   Your request contains too many query string parameters.
//
//   * ErrCodeInvalidQueryStringParameters "InvalidQueryStringParameters"
//   The query string parameters specified are not valid.
//
//   * ErrCodeTooManyDistributionsWithLambdaAssociations "TooManyDistributionsWithLambdaAssociations"
//   Processing your request would cause the maximum number of distributions with
//   Lambda function associations per owner to be exceeded.
//
//   * ErrCodeTooManyLambdaFunctionAssociations "TooManyLambdaFunctionAssociations"
//   Your request contains more Lambda function associations than are allowed
//   per distribution.
//
//   * ErrCodeInvalidLambdaFunctionAssociation "InvalidLambdaFunctionAssociation"
//   The specified Lambda function association is invalid.
//
//   * ErrCodeInvalidOriginReadTimeout "InvalidOriginReadTimeout"
//   The read timeout specified for the origin is not valid.
//
//   * ErrCodeInvalidOriginKeepaliveTimeout "InvalidOriginKeepaliveTimeout"
//   The keep alive timeout specified for the origin is not valid.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
//   * ErrCodeIllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior"
//   The specified configuration for field-level encryption can't be associated
//   with the specified cache behavior.
//
//   * ErrCodeTooManyDistributionsAssociatedToFieldLevelEncryptionConfig "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig"
//   The maximum number of distributions have been associated with the specified
//   configuration for field-level encryption.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateDistribution
func (c *CloudFront) UpdateDistribution(input *UpdateDistributionInput) (*UpdateDistributionOutput, error) {
	req, out := c.UpdateDistributionRequest(input)
	return out, req.Send()
}

// UpdateDistributionWithContext is the same as UpdateDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateDistributionWithContext(ctx aws.Context, input *UpdateDistributionInput, opts ...request.Option) (*UpdateDistributionOutput, error) {
	req, out := c.UpdateDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFieldLevelEncryptionConfig = "UpdateFieldLevelEncryptionConfig2019_03_26"

// UpdateFieldLevelEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFieldLevelEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFieldLevelEncryptionConfig for more information on using the UpdateFieldLevelEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFieldLevelEncryptionConfigRequest method.
//    req, resp := client.UpdateFieldLevelEncryptionConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateFieldLevelEncryptionConfig
func (c *CloudFront) UpdateFieldLevelEncryptionConfigRequest(input *UpdateFieldLevelEncryptionConfigInput) (req *request.Request, output *UpdateFieldLevelEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateFieldLevelEncryptionConfig,
		HTTPMethod: "PUT",
		HTTPPath:   "/2019-03-26/field-level-encryption/{Id}/config",
	}

	if input == nil {
		input = &UpdateFieldLevelEncryptionConfigInput{}
	}

	output = &UpdateFieldLevelEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFieldLevelEncryptionConfig API operation for Amazon CloudFront.
//
// Update a field-level encryption configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateFieldLevelEncryptionConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   Origin and CallerReference cannot be updated.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
//   * ErrCodeNoSuchFieldLevelEncryptionConfig "NoSuchFieldLevelEncryptionConfig"
//   The specified configuration for field-level encryption doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeTooManyFieldLevelEncryptionQueryArgProfiles "TooManyFieldLevelEncryptionQueryArgProfiles"
//   The maximum number of query arg profiles for field-level encryption have
//   been created.
//
//   * ErrCodeTooManyFieldLevelEncryptionContentTypeProfiles "TooManyFieldLevelEncryptionContentTypeProfiles"
//   The maximum number of content type profiles for field-level encryption have
//   been created.
//
//   * ErrCodeQueryArgProfileEmpty "QueryArgProfileEmpty"
//   No profile specified for the field-level encryption query argument.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateFieldLevelEncryptionConfig
func (c *CloudFront) UpdateFieldLevelEncryptionConfig(input *UpdateFieldLevelEncryptionConfigInput) (*UpdateFieldLevelEncryptionConfigOutput, error) {
	req, out := c.UpdateFieldLevelEncryptionConfigRequest(input)
	return out, req.Send()
}

// UpdateFieldLevelEncryptionConfigWithContext is the same as UpdateFieldLevelEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFieldLevelEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateFieldLevelEncryptionConfigWithContext(ctx aws.Context, input *UpdateFieldLevelEncryptionConfigInput, opts ...request.Option) (*UpdateFieldLevelEncryptionConfigOutput, error) {
	req, out := c.UpdateFieldLevelEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFieldLevelEncryptionProfile = "UpdateFieldLevelEncryptionProfile2019_03_26"

// UpdateFieldLevelEncryptionProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFieldLevelEncryptionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFieldLevelEncryptionProfile for more information on using the UpdateFieldLevelEncryptionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFieldLevelEncryptionProfileRequest method.
//    req, resp := client.UpdateFieldLevelEncryptionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateFieldLevelEncryptionProfile
func (c *CloudFront) UpdateFieldLevelEncryptionProfileRequest(input *UpdateFieldLevelEncryptionProfileInput) (req *request.Request, output *UpdateFieldLevelEncryptionProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateFieldLevelEncryptionProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/2019-03-26/field-level-encryption-profile/{Id}/config",
	}

	if input == nil {
		input = &UpdateFieldLevelEncryptionProfileInput{}
	}

	output = &UpdateFieldLevelEncryptionProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFieldLevelEncryptionProfile API operation for Amazon CloudFront.
//
// Update a field-level encryption profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateFieldLevelEncryptionProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeFieldLevelEncryptionProfileAlreadyExists "FieldLevelEncryptionProfileAlreadyExists"
//   The specified profile for field-level encryption already exists.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   Origin and CallerReference cannot be updated.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
//   * ErrCodeNoSuchFieldLevelEncryptionProfile "NoSuchFieldLevelEncryptionProfile"
//   The specified profile for field-level encryption doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeFieldLevelEncryptionProfileSizeExceeded "FieldLevelEncryptionProfileSizeExceeded"
//   The maximum size of a profile for field-level encryption was exceeded.
//
//   * ErrCodeTooManyFieldLevelEncryptionEncryptionEntities "TooManyFieldLevelEncryptionEncryptionEntities"
//   The maximum number of encryption entities for field-level encryption have
//   been created.
//
//   * ErrCodeTooManyFieldLevelEncryptionFieldPatterns "TooManyFieldLevelEncryptionFieldPatterns"
//   The maximum number of field patterns for field-level encryption have been
//   created.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateFieldLevelEncryptionProfile
func (c *CloudFront) UpdateFieldLevelEncryptionProfile(input *UpdateFieldLevelEncryptionProfileInput) (*UpdateFieldLevelEncryptionProfileOutput, error) {
	req, out := c.UpdateFieldLevelEncryptionProfileRequest(input)
	return out, req.Send()
}

// UpdateFieldLevelEncryptionProfileWithContext is the same as UpdateFieldLevelEncryptionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFieldLevelEncryptionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateFieldLevelEncryptionProfileWithContext(ctx aws.Context, input *UpdateFieldLevelEncryptionProfileInput, opts ...request.Option) (*UpdateFieldLevelEncryptionProfileOutput, error) {
	req, out := c.UpdateFieldLevelEncryptionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePublicKey = "UpdatePublicKey2019_03_26"

// UpdatePublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePublicKey for more information on using the UpdatePublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePublicKeyRequest method.
//    req, resp := client.UpdatePublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdatePublicKey
func (c *CloudFront) UpdatePublicKeyRequest(input *UpdatePublicKeyInput) (req *request.Request, output *UpdatePublicKeyOutput) {
	op := &request.Operation{
		Name:       opUpdatePublicKey,
		HTTPMethod: "PUT",
		HTTPPath:   "/2019-03-26/public-key/{Id}/config",
	}

	if input == nil {
		input = &UpdatePublicKeyInput{}
	}

	output = &UpdatePublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePublicKey API operation for Amazon CloudFront.
//
// Update public key information. Note that the only value you can change is
// the comment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdatePublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeCannotChangeImmutablePublicKeyFields "CannotChangeImmutablePublicKeyFields"
//   You can't change the value of a public key.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   Origin and CallerReference cannot be updated.
//
//   * ErrCodeNoSuchPublicKey "NoSuchPublicKey"
//   The specified public key doesn't exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdatePublicKey
func (c *CloudFront) UpdatePublicKey(input *UpdatePublicKeyInput) (*UpdatePublicKeyOutput, error) {
	req, out := c.UpdatePublicKeyRequest(input)
	return out, req.Send()
}

// UpdatePublicKeyWithContext is the same as UpdatePublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdatePublicKeyWithContext(ctx aws.Context, input *UpdatePublicKeyInput, opts ...request.Option) (*UpdatePublicKeyOutput, error) {
	req, out := c.UpdatePublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStreamingDistribution = "UpdateStreamingDistribution2019_03_26"

// UpdateStreamingDistributionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStreamingDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStreamingDistribution for more information on using the UpdateStreamingDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStreamingDistributionRequest method.
//    req, resp := client.UpdateStreamingDistributionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateStreamingDistribution
func (c *CloudFront) UpdateStreamingDistributionRequest(input *UpdateStreamingDistributionInput) (req *request.Request, output *UpdateStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opUpdateStreamingDistribution,
		HTTPMethod: "PUT",
		HTTPPath:   "/2019-03-26/streaming-distribution/{Id}/config",
	}

	if input == nil {
		input = &UpdateStreamingDistributionInput{}
	}

	output = &UpdateStreamingDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStreamingDistribution API operation for Amazon CloudFront.
//
// Update a streaming distribution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudFront's
// API operation UpdateStreamingDistribution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDenied "AccessDenied"
//   Access denied.
//
//   * ErrCodeCNAMEAlreadyExists "CNAMEAlreadyExists"
//   The CNAME specified is already defined for CloudFront.
//
//   * ErrCodeIllegalUpdate "IllegalUpdate"
//   Origin and CallerReference cannot be updated.
//
//   * ErrCodeInvalidIfMatchVersion "InvalidIfMatchVersion"
//   The If-Match version is missing or not valid for the distribution.
//
//   * ErrCodeMissingBody "MissingBody"
//   This operation requires a body. Ensure that the body is present and the Content-Type
//   header is set.
//
//   * ErrCodeNoSuchStreamingDistribution "NoSuchStreamingDistribution"
//   The specified streaming distribution does not exist.
//
//   * ErrCodePreconditionFailed "PreconditionFailed"
//   The precondition given in one or more of the request header fields evaluated
//   to false.
//
//   * ErrCodeTooManyStreamingDistributionCNAMEs "TooManyStreamingDistributionCNAMEs"
//   Your request contains more CNAMEs than are allowed per distribution.
//
//   * ErrCodeInvalidArgument "InvalidArgument"
//   An argument is invalid.
//
//   * ErrCodeInvalidOriginAccessIdentity "InvalidOriginAccessIdentity"
//   The origin access identity is not valid or doesn't exist.
//
//   * ErrCodeTooManyTrustedSigners "TooManyTrustedSigners"
//   Your request contains more trusted signers than are allowed per distribution.
//
//   * ErrCodeTrustedSignerDoesNotExist "TrustedSignerDoesNotExist"
//   One or more of your trusted signers don't exist.
//
//   * ErrCodeInconsistentQuantities "InconsistentQuantities"
//   The value of Quantity and the size of Items don't match.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateStreamingDistribution
func (c *CloudFront) UpdateStreamingDistribution(input *UpdateStreamingDistributionInput) (*UpdateStreamingDistributionOutput, error) {
	req, out := c.UpdateStreamingDistributionRequest(input)
	return out, req.Send()
}

// UpdateStreamingDistributionWithContext is the same as UpdateStreamingDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStreamingDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudFront) UpdateStreamingDistributionWithContext(ctx aws.Context, input *UpdateStreamingDistributionInput, opts ...request.Option) (*UpdateStreamingDistributionOutput, error) {
	req, out := c.UpdateStreamingDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A complex type that lists the AWS accounts, if any, that you included in
// the TrustedSigners complex type for this distribution. These are the accounts
// that you want to allow to create signed URLs for private content.
//
// The Signer complex type lists the AWS account number of the trusted signer
// or self if the signer is the AWS account that created the distribution. The
// Signer element also includes the IDs of any active CloudFront key pairs that
// are associated with the trusted signer's AWS account. If no KeyPairId element
// appears for a Signer, that signer can't create signed URLs.
//
// For more information, see Serving Private Content through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
// in the Amazon CloudFront Developer Guide.
type ActiveTrustedSigners struct {
	_ struct{} `type:"structure"`

	// Enabled is true if any of the AWS accounts listed in the TrustedSigners complex
	// type for this distribution have active CloudFront key pairs. If not, Enabled
	// is false.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A complex type that contains one Signer complex type for each trusted signer
	// that is specified in the TrustedSigners complex type.
	Items []*Signer `locationNameList:"Signer" type:"list"`

	// The number of trusted signers specified in the TrustedSigners complex type.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ActiveTrustedSigners) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActiveTrustedSigners) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *ActiveTrustedSigners) SetEnabled(v bool) *ActiveTrustedSigners {
	s.Enabled = &v
	return s
}

// SetItems sets the Items field's value.
func (s *ActiveTrustedSigners) SetItems(v []*Signer) *ActiveTrustedSigners {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *ActiveTrustedSigners) SetQuantity(v int64) *ActiveTrustedSigners {
	s.Quantity = &v
	return s
}

// AWS services in China customers must file for an Internet Content Provider
// (ICP) recordal if they want to serve content publicly on an alternate domain
// name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal
// provides the ICP recordal status for CNAMEs associated with distributions.
// The status is returned in the CloudFront response; you can't configure it
// yourself.
//
// For more information about ICP recordals, see Signup, Accounts, and Credentials
// (https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html)
// in Getting Started with AWS services in China.
type AliasICPRecordal struct {
	_ struct{} `type:"structure"`

	// A domain name associated with a distribution.
	CNAME *string `type:"string"`

	// The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus
	// is set to APPROVED for all CNAMEs (aliases) in regions outside of China.
	//
	// The status values returned are the following:
	//
	//    * APPROVED indicates that the associated CNAME has a valid ICP recordal
	//    number. Multiple CNAMEs can be associated with a distribution, and CNAMEs
	//    can correspond to different ICP recordals. To be marked as APPROVED, that
	//    is, valid to use with China region, a CNAME must have one ICP recordal
	//    number associated with it.
	//
	//    * SUSPENDED indicates that the associated CNAME does not have a valid
	//    ICP recordal number.
	//
	//    * PENDING indicates that CloudFront can't determine the ICP recordal status
	//    of the CNAME associated with the distribution because there was an error
	//    in trying to determine the status. You can try again to see if the error
	//    is resolved in which case CloudFront returns an APPROVED or SUSPENDED
	//    status.
	ICPRecordalStatus *string `type:"string" enum:"ICPRecordalStatus"`
}

// String returns the string representation
func (s AliasICPRecordal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasICPRecordal) GoString() string {
	return s.String()
}

// SetCNAME sets the CNAME field's value.
func (s *AliasICPRecordal) SetCNAME(v string) *AliasICPRecordal {
	s.CNAME = &v
	return s
}

// SetICPRecordalStatus sets the ICPRecordalStatus field's value.
func (s *AliasICPRecordal) SetICPRecordalStatus(v string) *AliasICPRecordal {
	s.ICPRecordalStatus = &v
	return s
}

// A complex type that contains information about CNAMEs (alternate domain names),
// if any, for this distribution.
type Aliases struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the CNAME aliases, if any, that you want to
	// associate with this distribution.
	Items []*string `locationNameList:"CNAME" type:"list"`

	// The number of CNAME aliases, if any, that you want to associate with this
	// distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Aliases) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Aliases) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Aliases) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Aliases"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *Aliases) SetItems(v []*string) *Aliases {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *Aliases) SetQuantity(v int64) *Aliases {
	s.Quantity = &v
	return s
}

// A complex type that controls which HTTP methods CloudFront processes and
// forwards to your Amazon S3 bucket or your custom origin. There are three
// choices:
//
//    * CloudFront forwards only GET and HEAD requests.
//
//    * CloudFront forwards only GET, HEAD, and OPTIONS requests.
//
//    * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE
//    requests.
//
// If you pick the third choice, you may need to restrict access to your Amazon
// S3 bucket or to your custom origin so users can't perform operations that
// you don't want them to. For example, you might not want users to have permissions
// to delete objects from your origin.
type AllowedMethods struct {
	_ struct{} `type:"structure"`

	// A complex type that controls whether CloudFront caches the response to requests
	// using the specified HTTP methods. There are two choices:
	//
	//    * CloudFront caches responses to GET and HEAD requests.
	//
	//    * CloudFront caches responses to GET, HEAD, and OPTIONS requests.
	//
	// If you pick the second choice for your Amazon S3 Origin, you may need to
	// forward Access-Control-Request-Method, Access-Control-Request-Headers, and
	// Origin headers for the responses to be cached correctly.
	CachedMethods *CachedMethods `type:"structure"`

	// A complex type that contains the HTTP methods that you want CloudFront to
	// process and forward to your origin.
	//
	// Items is a required field
	Items []*string `locationNameList:"Method" type:"list" required:"true"`

	// The number of HTTP methods that you want CloudFront to forward to your origin.
	// Valid values are 2 (for GET and HEAD requests), 3 (for GET, HEAD, and OPTIONS
	// requests) and 7 (for GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE requests).
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s AllowedMethods) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllowedMethods) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllowedMethods) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllowedMethods"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.CachedMethods != nil {
		if err := s.CachedMethods.Validate(); err != nil {
			invalidParams.AddNested("CachedMethods", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCachedMethods sets the CachedMethods field's value.
func (s *AllowedMethods) SetCachedMethods(v *CachedMethods) *AllowedMethods {
	s.CachedMethods = v
	return s
}

// SetItems sets the Items field's value.
func (s *AllowedMethods) SetItems(v []*string) *AllowedMethods {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *AllowedMethods) SetQuantity(v int64) *AllowedMethods {
	s.Quantity = &v
	return s
}

// A complex type that describes how CloudFront processes requests.
//
// You must create at least as many cache behaviors (including the default cache
// behavior) as you have origins if you want CloudFront to serve objects from
// all of the origins. Each cache behavior specifies the one origin from which
// you want CloudFront to get objects. If you have two origins and only the
// default cache behavior, the default cache behavior will cause CloudFront
// to get objects from one of the origins, but the other origin is never used.
//
// For the current quota (formerly known as limit) on the number of cache behaviors
// that you can add to a distribution, see Quotas (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html)
// in the Amazon CloudFront Developer Guide.
//
// If you don’t want to specify any cache behaviors, include only an empty
// CacheBehaviors element. Don’t include an empty CacheBehavior element because
// this is invalid.
//
// To delete all cache behaviors in an existing distribution, update the distribution
// configuration and include only an empty CacheBehaviors element.
//
// To add, change, or remove one or more cache behaviors, update the distribution
// configuration and specify all of the cache behaviors that you want to include
// in the updated distribution.
//
// For more information about cache behaviors, see Cache Behavior Settings (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior)
// in the Amazon CloudFront Developer Guide.
type CacheBehavior struct {
	_ struct{} `type:"structure"`

	// A complex type that controls which HTTP methods CloudFront processes and
	// forwards to your Amazon S3 bucket or your custom origin. There are three
	// choices:
	//
	//    * CloudFront forwards only GET and HEAD requests.
	//
	//    * CloudFront forwards only GET, HEAD, and OPTIONS requests.
	//
	//    * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE
	//    requests.
	//
	// If you pick the third choice, you may need to restrict access to your Amazon
	// S3 bucket or to your custom origin so users can't perform operations that
	// you don't want them to. For example, you might not want users to have permissions
	// to delete objects from your origin.
	AllowedMethods *AllowedMethods `type:"structure"`

	// Whether you want CloudFront to automatically compress certain files for this
	// cache behavior. If so, specify true; if not, specify false. For more information,
	// see Serving Compressed Files (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html)
	// in the Amazon CloudFront Developer Guide.
	Compress *bool `type:"boolean"`

	// The default amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when
	// your origin does not add HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. For more information, see Managing How
	// Long Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	DefaultTTL *int64 `type:"long"`

	// The value of ID for the field-level encryption configuration that you want
	// CloudFront to use for encrypting specific fields of data for this cache behavior.
	FieldLevelEncryptionId *string `type:"string"`

	// A complex type that specifies how CloudFront handles query strings, cookies,
	// and HTTP headers.
	//
	// ForwardedValues is a required field
	ForwardedValues *ForwardedValues `type:"structure" required:"true"`

	// A complex type that contains zero or more Lambda function associations for
	// a cache behavior.
	LambdaFunctionAssociations *LambdaFunctionAssociations `type:"structure"`

	// The maximum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when
	// your origin adds HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. For more information, see Managing How
	// Long Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	MaxTTL *int64 `type:"long"`

	// The minimum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. For more information, see Managing How Long
	// Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// You must specify 0 for MinTTL if you configure CloudFront to forward all
	// headers to your origin (under Headers, if you specify 1 for Quantity and
	// * for Name).
	//
	// MinTTL is a required field
	MinTTL *int64 `type:"long" required:"true"`

	// The pattern (for example, images/*.jpg) that specifies which requests to
	// apply the behavior to. When CloudFront receives a viewer request, the requested
	// path is compared with path patterns in the order in which cache behaviors
	// are listed in the distribution.
	//
	// You can optionally include a slash (/) at the beginning of the path pattern.
	// For example, /images/*.jpg. CloudFront behavior is the same with or without
	// the leading /.
	//
	// The path pattern for the default cache behavior is * and cannot be changed.
	// If the request for an object does not match the path pattern for any cache
	// behaviors, CloudFront applies the behavior in the default cache behavior.
	//
	// For more information, see Path Pattern (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern)
	// in the Amazon CloudFront Developer Guide.
	//
	// PathPattern is a required field
	PathPattern *string `type:"string" required:"true"`

	// Indicates whether you want to distribute media files in the Microsoft Smooth
	// Streaming format using the origin that is associated with this cache behavior.
	// If so, specify true; if not, specify false. If you specify true for SmoothStreaming,
	// you can still distribute other content using this cache behavior if the content
	// matches the value of PathPattern.
	SmoothStreaming *bool `type:"boolean"`

	// The value of ID for the origin that you want CloudFront to route requests
	// to when they match this cache behavior.
	//
	// TargetOriginId is a required field
	TargetOriginId *string `type:"string" required:"true"`

	// A complex type that specifies the AWS accounts, if any, that you want to
	// allow to create signed URLs for private content.
	//
	// If you want to require signed URLs in requests for objects in the target
	// origin that match the PathPattern for this cache behavior, specify true for
	// Enabled, and specify the applicable values for Quantity and Items. For more
	// information, see Serving Private Content with Signed URLs and Signed Cookies
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you don’t want to require signed URLs in requests for objects that match
	// PathPattern, specify false for Enabled and 0 for Quantity. Omit Items.
	//
	// To add, change, or remove one or more trusted signers, change Enabled to
	// true (if it’s currently false), change Quantity as applicable, and specify
	// all of the trusted signers that you want to include in the updated distribution.
	//
	// TrustedSigners is a required field
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`

	// The protocol that viewers can use to access the files in the origin specified
	// by TargetOriginId when a request matches the path pattern in PathPattern.
	// You can specify the following options:
	//
	//    * allow-all: Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https: If a viewer submits an HTTP request, CloudFront returns
	//    an HTTP status code of 301 (Moved Permanently) to the viewer along with
	//    the HTTPS URL. The viewer then resubmits the request using the new URL.
	//
	//    * https-only: If a viewer sends an HTTP request, CloudFront returns an
	//    HTTP status code of 403 (Forbidden).
	//
	// For more information about requiring the HTTPS protocol, see Requiring HTTPS
	// Between Viewers and CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The only way to guarantee that viewers retrieve an object that was fetched
	// from the origin using HTTPS is never to use any other protocol to fetch the
	// object. If you have recently changed from HTTP to HTTPS, we recommend that
	// you clear your objects’ cache because cached objects are protocol agnostic.
	// That means that an edge location will return an object from the cache regardless
	// of whether the current request protocol matches the protocol used previously.
	// For more information, see Managing Cache Expiration (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// ViewerProtocolPolicy is a required field
	ViewerProtocolPolicy *string `type:"string" required:"true" enum:"ViewerProtocolPolicy"`
}

// String returns the string representation
func (s CacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheBehavior) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CacheBehavior) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CacheBehavior"}
	if s.ForwardedValues == nil {
		invalidParams.Add(request.NewErrParamRequired("ForwardedValues"))
	}
	if s.MinTTL == nil {
		invalidParams.Add(request.NewErrParamRequired("MinTTL"))
	}
	if s.PathPattern == nil {
		invalidParams.Add(request.NewErrParamRequired("PathPattern"))
	}
	if s.TargetOriginId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetOriginId"))
	}
	if s.TrustedSigners == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustedSigners"))
	}
	if s.ViewerProtocolPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewerProtocolPolicy"))
	}
	if s.AllowedMethods != nil {
		if err := s.AllowedMethods.Validate(); err != nil {
			invalidParams.AddNested("AllowedMethods", err.(request.ErrInvalidParams))
		}
	}
	if s.ForwardedValues != nil {
		if err := s.ForwardedValues.Validate(); err != nil {
			invalidParams.AddNested("ForwardedValues", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaFunctionAssociations != nil {
		if err := s.LambdaFunctionAssociations.Validate(); err != nil {
			invalidParams.AddNested("LambdaFunctionAssociations", err.(request.ErrInvalidParams))
		}
	}
	if s.TrustedSigners != nil {
		if err := s.TrustedSigners.Validate(); err != nil {
			invalidParams.AddNested("TrustedSigners", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedMethods sets the AllowedMethods field's value.
func (s *CacheBehavior) SetAllowedMethods(v *AllowedMethods) *CacheBehavior {
	s.AllowedMethods = v
	return s
}

// SetCompress sets the Compress field's value.
func (s *CacheBehavior) SetCompress(v bool) *CacheBehavior {
	s.Compress = &v
	return s
}

// SetDefaultTTL sets the DefaultTTL field's value.
func (s *CacheBehavior) SetDefaultTTL(v int64) *CacheBehavior {
	s.DefaultTTL = &v
	return s
}

// SetFieldLevelEncryptionId sets the FieldLevelEncryptionId field's value.
func (s *CacheBehavior) SetFieldLevelEncryptionId(v string) *CacheBehavior {
	s.FieldLevelEncryptionId = &v
	return s
}

// SetForwardedValues sets the ForwardedValues field's value.
func (s *CacheBehavior) SetForwardedValues(v *ForwardedValues) *CacheBehavior {
	s.ForwardedValues = v
	return s
}

// SetLambdaFunctionAssociations sets the LambdaFunctionAssociations field's value.
func (s *CacheBehavior) SetLambdaFunctionAssociations(v *LambdaFunctionAssociations) *CacheBehavior {
	s.LambdaFunctionAssociations = v
	return s
}

// SetMaxTTL sets the MaxTTL field's value.
func (s *CacheBehavior) SetMaxTTL(v int64) *CacheBehavior {
	s.MaxTTL = &v
	return s
}

// SetMinTTL sets the MinTTL field's value.
func (s *CacheBehavior) SetMinTTL(v int64) *CacheBehavior {
	s.MinTTL = &v
	return s
}

// SetPathPattern sets the PathPattern field's value.
func (s *CacheBehavior) SetPathPattern(v string) *CacheBehavior {
	s.PathPattern = &v
	return s
}

// SetSmoothStreaming sets the SmoothStreaming field's value.
func (s *CacheBehavior) SetSmoothStreaming(v bool) *CacheBehavior {
	s.SmoothStreaming = &v
	return s
}

// SetTargetOriginId sets the TargetOriginId field's value.
func (s *CacheBehavior) SetTargetOriginId(v string) *CacheBehavior {
	s.TargetOriginId = &v
	return s
}

// SetTrustedSigners sets the TrustedSigners field's value.
func (s *CacheBehavior) SetTrustedSigners(v *TrustedSigners) *CacheBehavior {
	s.TrustedSigners = v
	return s
}

// SetViewerProtocolPolicy sets the ViewerProtocolPolicy field's value.
func (s *CacheBehavior) SetViewerProtocolPolicy(v string) *CacheBehavior {
	s.ViewerProtocolPolicy = &v
	return s
}

// A complex type that contains zero or more CacheBehavior elements.
type CacheBehaviors struct {
	_ struct{} `type:"structure"`

	// Optional: A complex type that contains cache behaviors for this distribution.
	// If Quantity is 0, you can omit Items.
	Items []*CacheBehavior `locationNameList:"CacheBehavior" type:"list"`

	// The number of cache behaviors for this distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CacheBehaviors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheBehaviors) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CacheBehaviors) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CacheBehaviors"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *CacheBehaviors) SetItems(v []*CacheBehavior) *CacheBehaviors {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *CacheBehaviors) SetQuantity(v int64) *CacheBehaviors {
	s.Quantity = &v
	return s
}

// A complex type that controls whether CloudFront caches the response to requests
// using the specified HTTP methods. There are two choices:
//
//    * CloudFront caches responses to GET and HEAD requests.
//
//    * CloudFront caches responses to GET, HEAD, and OPTIONS requests.
//
// If you pick the second choice for your Amazon S3 Origin, you may need to
// forward Access-Control-Request-Method, Access-Control-Request-Headers, and
// Origin headers for the responses to be cached correctly.
type CachedMethods struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the HTTP methods that you want CloudFront to
	// cache responses to.
	//
	// Items is a required field
	Items []*string `locationNameList:"Method" type:"list" required:"true"`

	// The number of HTTP methods for which you want CloudFront to cache responses.
	// Valid values are 2 (for caching responses to GET and HEAD requests) and 3
	// (for caching responses to GET, HEAD, and OPTIONS requests).
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CachedMethods) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachedMethods) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CachedMethods) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CachedMethods"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *CachedMethods) SetItems(v []*string) *CachedMethods {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *CachedMethods) SetQuantity(v int64) *CachedMethods {
	s.Quantity = &v
	return s
}

// A field-level encryption content type profile.
type ContentTypeProfile struct {
	_ struct{} `type:"structure"`

	// The content type for a field-level encryption content type-profile mapping.
	//
	// ContentType is a required field
	ContentType *string `type:"string" required:"true"`

	// The format for a field-level encryption content type-profile mapping.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"Format"`

	// The profile ID for a field-level encryption content type-profile mapping.
	ProfileId *string `type:"string"`
}

// String returns the string representation
func (s ContentTypeProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContentTypeProfile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentTypeProfile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentTypeProfile"}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *ContentTypeProfile) SetContentType(v string) *ContentTypeProfile {
	s.ContentType = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ContentTypeProfile) SetFormat(v string) *ContentTypeProfile {
	s.Format = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ContentTypeProfile) SetProfileId(v string) *ContentTypeProfile {
	s.ProfileId = &v
	return s
}

// The configuration for a field-level encryption content type-profile mapping.
type ContentTypeProfileConfig struct {
	_ struct{} `type:"structure"`

	// The configuration for a field-level encryption content type-profile.
	ContentTypeProfiles *ContentTypeProfiles `type:"structure"`

	// The setting in a field-level encryption content type-profile mapping that
	// specifies what to do when an unknown content type is provided for the profile.
	// If true, content is forwarded without being encrypted when the content type
	// is unknown. If false (the default), an error is returned when the content
	// type is unknown.
	//
	// ForwardWhenContentTypeIsUnknown is a required field
	ForwardWhenContentTypeIsUnknown *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ContentTypeProfileConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContentTypeProfileConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentTypeProfileConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentTypeProfileConfig"}
	if s.ForwardWhenContentTypeIsUnknown == nil {
		invalidParams.Add(request.NewErrParamRequired("ForwardWhenContentTypeIsUnknown"))
	}
	if s.ContentTypeProfiles != nil {
		if err := s.ContentTypeProfiles.Validate(); err != nil {
			invalidParams.AddNested("ContentTypeProfiles", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentTypeProfiles sets the ContentTypeProfiles field's value.
func (s *ContentTypeProfileConfig) SetContentTypeProfiles(v *ContentTypeProfiles) *ContentTypeProfileConfig {
	s.ContentTypeProfiles = v
	return s
}

// SetForwardWhenContentTypeIsUnknown sets the ForwardWhenContentTypeIsUnknown field's value.
func (s *ContentTypeProfileConfig) SetForwardWhenContentTypeIsUnknown(v bool) *ContentTypeProfileConfig {
	s.ForwardWhenContentTypeIsUnknown = &v
	return s
}

// Field-level encryption content type-profile.
type ContentTypeProfiles struct {
	_ struct{} `type:"structure"`

	// Items in a field-level encryption content type-profile mapping.
	Items []*ContentTypeProfile `locationNameList:"ContentTypeProfile" type:"list"`

	// The number of field-level encryption content type-profile mappings.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ContentTypeProfiles) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContentTypeProfiles) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentTypeProfiles) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentTypeProfiles"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *ContentTypeProfiles) SetItems(v []*ContentTypeProfile) *ContentTypeProfiles {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *ContentTypeProfiles) SetQuantity(v int64) *ContentTypeProfiles {
	s.Quantity = &v
	return s
}

// A complex type that specifies whether you want CloudFront to forward cookies
// to the origin and, if so, which ones. For more information about forwarding
// cookies to the origin, see Caching Content Based on Request Headers (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html)
// in the Amazon CloudFront Developer Guide.
type CookieNames struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one Name element for each cookie that you want
	// CloudFront to forward to the origin for this cache behavior. It must contain
	// the same number of items that is specified in the Quantity field.
	//
	// When you set Forward = whitelist (in the CookiePreferences object), this
	// field must contain at least one item.
	Items []*string `locationNameList:"Name" type:"list"`

	// The number of different cookies that you want CloudFront to forward to the
	// origin for this cache behavior. The value must equal the number of items
	// that are in the Items field.
	//
	// When you set Forward = whitelist (in the CookiePreferences object), this
	// value must be 1 or higher.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CookieNames) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CookieNames) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CookieNames) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CookieNames"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *CookieNames) SetItems(v []*string) *CookieNames {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *CookieNames) SetQuantity(v int64) *CookieNames {
	s.Quantity = &v
	return s
}

// A complex type that specifies whether you want CloudFront to forward cookies
// to the origin and, if so, which ones. For more information about forwarding
// cookies to the origin, see Caching Content Based on Cookies (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html)
// in the Amazon CloudFront Developer Guide.
type CookiePreference struct {
	_ struct{} `type:"structure"`

	// Specifies which cookies to forward to the origin for this cache behavior:
	// all, none, or the list of cookies specified in the WhitelistedNames complex
	// type.
	//
	// Amazon S3 doesn't process cookies. When the cache behavior is forwarding
	// requests to an Amazon S3 origin, specify none for the Forward element.
	//
	// Forward is a required field
	Forward *string `type:"string" required:"true" enum:"ItemSelection"`

	// Required if you specify whitelist for the value of Forward. A complex type
	// that specifies how many different cookies you want CloudFront to forward
	// to the origin for this cache behavior and, if you want to forward selected
	// cookies, the names of those cookies.
	//
	// If you specify all or none for the value of Forward, omit WhitelistedNames.
	// If you change the value of Forward from whitelist to all or none and you
	// don't delete the WhitelistedNames element and its child elements, CloudFront
	// deletes them automatically.
	//
	// For the current limit on the number of cookie names that you can whitelist
	// for each cache behavior, see CloudFront Limits (https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront)
	// in the AWS General Reference.
	WhitelistedNames *CookieNames `type:"structure"`
}

// String returns the string representation
func (s CookiePreference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CookiePreference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CookiePreference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CookiePreference"}
	if s.Forward == nil {
		invalidParams.Add(request.NewErrParamRequired("Forward"))
	}
	if s.WhitelistedNames != nil {
		if err := s.WhitelistedNames.Validate(); err != nil {
			invalidParams.AddNested("WhitelistedNames", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForward sets the Forward field's value.
func (s *CookiePreference) SetForward(v string) *CookiePreference {
	s.Forward = &v
	return s
}

// SetWhitelistedNames sets the WhitelistedNames field's value.
func (s *CookiePreference) SetWhitelistedNames(v *CookieNames) *CookiePreference {
	s.WhitelistedNames = v
	return s
}

// The request to create a new origin access identity (OAI). An origin access
// identity is a special CloudFront user that you can associate with Amazon
// S3 origins, so that you can secure all or just some of your Amazon S3 content.
// For more information, see Restricting Access to Amazon S3 Content by Using
// an Origin Access Identity (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html)
// in the Amazon CloudFront Developer Guide.
type CreateCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `locationName:"CreateCloudFrontOriginAccessIdentityRequest" type:"structure" payload:"CloudFrontOriginAccessIdentityConfig"`

	// The current configuration information for the identity.
	//
	// CloudFrontOriginAccessIdentityConfig is a required field
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `locationName:"CloudFrontOriginAccessIdentityConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s CreateCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCloudFrontOriginAccessIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCloudFrontOriginAccessIdentityInput"}
	if s.CloudFrontOriginAccessIdentityConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudFrontOriginAccessIdentityConfig"))
	}
	if s.CloudFrontOriginAccessIdentityConfig != nil {
		if err := s.CloudFrontOriginAccessIdentityConfig.Validate(); err != nil {
			invalidParams.AddNested("CloudFrontOriginAccessIdentityConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFrontOriginAccessIdentityConfig sets the CloudFrontOriginAccessIdentityConfig field's value.
func (s *CreateCloudFrontOriginAccessIdentityInput) SetCloudFrontOriginAccessIdentityConfig(v *OriginAccessIdentityConfig) *CreateCloudFrontOriginAccessIdentityInput {
	s.CloudFrontOriginAccessIdentityConfig = v
	return s
}

// The returned result of the corresponding request.
type CreateCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentity"`

	// The origin access identity's information.
	CloudFrontOriginAccessIdentity *OriginAccessIdentity `type:"structure"`

	// The current version of the origin access identity created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new origin access identity just created. For
	// example: https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/E74FTE3AJFJ256A.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentity sets the CloudFrontOriginAccessIdentity field's value.
func (s *CreateCloudFrontOriginAccessIdentityOutput) SetCloudFrontOriginAccessIdentity(v *OriginAccessIdentity) *CreateCloudFrontOriginAccessIdentityOutput {
	s.CloudFrontOriginAccessIdentity = v
	return s
}

// SetETag sets the ETag field's value.
func (s *CreateCloudFrontOriginAccessIdentityOutput) SetETag(v string) *CreateCloudFrontOriginAccessIdentityOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateCloudFrontOriginAccessIdentityOutput) SetLocation(v string) *CreateCloudFrontOriginAccessIdentityOutput {
	s.Location = &v
	return s
}

// The request to create a new distribution.
type CreateDistributionInput struct {
	_ struct{} `locationName:"CreateDistributionRequest" type:"structure" payload:"DistributionConfig"`

	// The distribution's configuration information.
	//
	// DistributionConfig is a required field
	DistributionConfig *DistributionConfig `locationName:"DistributionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s CreateDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDistributionInput"}
	if s.DistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionConfig"))
	}
	if s.DistributionConfig != nil {
		if err := s.DistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("DistributionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionConfig sets the DistributionConfig field's value.
func (s *CreateDistributionInput) SetDistributionConfig(v *DistributionConfig) *CreateDistributionInput {
	s.DistributionConfig = v
	return s
}

// The returned result of the corresponding request.
type CreateDistributionOutput struct {
	_ struct{} `type:"structure" payload:"Distribution"`

	// The distribution's information.
	Distribution *Distribution `type:"structure"`

	// The current version of the distribution created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new distribution resource just created. For
	// example: https://cloudfront.amazonaws.com/2010-11-01/distribution/EDFDVBD632BHDS5.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionOutput) GoString() string {
	return s.String()
}

// SetDistribution sets the Distribution field's value.
func (s *CreateDistributionOutput) SetDistribution(v *Distribution) *CreateDistributionOutput {
	s.Distribution = v
	return s
}

// SetETag sets the ETag field's value.
func (s *CreateDistributionOutput) SetETag(v string) *CreateDistributionOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateDistributionOutput) SetLocation(v string) *CreateDistributionOutput {
	s.Location = &v
	return s
}

// The request to create a new distribution with tags.
type CreateDistributionWithTagsInput struct {
	_ struct{} `locationName:"CreateDistributionWithTagsRequest" type:"structure" payload:"DistributionConfigWithTags"`

	// The distribution's configuration information.
	//
	// DistributionConfigWithTags is a required field
	DistributionConfigWithTags *DistributionConfigWithTags `locationName:"DistributionConfigWithTags" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s CreateDistributionWithTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionWithTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDistributionWithTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDistributionWithTagsInput"}
	if s.DistributionConfigWithTags == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionConfigWithTags"))
	}
	if s.DistributionConfigWithTags != nil {
		if err := s.DistributionConfigWithTags.Validate(); err != nil {
			invalidParams.AddNested("DistributionConfigWithTags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionConfigWithTags sets the DistributionConfigWithTags field's value.
func (s *CreateDistributionWithTagsInput) SetDistributionConfigWithTags(v *DistributionConfigWithTags) *CreateDistributionWithTagsInput {
	s.DistributionConfigWithTags = v
	return s
}

// The returned result of the corresponding request.
type CreateDistributionWithTagsOutput struct {
	_ struct{} `type:"structure" payload:"Distribution"`

	// The distribution's information.
	Distribution *Distribution `type:"structure"`

	// The current version of the distribution created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new distribution resource just created. For
	// example: https://cloudfront.amazonaws.com/2010-11-01/distribution/EDFDVBD632BHDS5.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateDistributionWithTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionWithTagsOutput) GoString() string {
	return s.String()
}

// SetDistribution sets the Distribution field's value.
func (s *CreateDistributionWithTagsOutput) SetDistribution(v *Distribution) *CreateDistributionWithTagsOutput {
	s.Distribution = v
	return s
}

// SetETag sets the ETag field's value.
func (s *CreateDistributionWithTagsOutput) SetETag(v string) *CreateDistributionWithTagsOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateDistributionWithTagsOutput) SetLocation(v string) *CreateDistributionWithTagsOutput {
	s.Location = &v
	return s
}

type CreateFieldLevelEncryptionConfigInput struct {
	_ struct{} `locationName:"CreateFieldLevelEncryptionConfigRequest" type:"structure" payload:"FieldLevelEncryptionConfig"`

	// The request to create a new field-level encryption configuration.
	//
	// FieldLevelEncryptionConfig is a required field
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig `locationName:"FieldLevelEncryptionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s CreateFieldLevelEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFieldLevelEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFieldLevelEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFieldLevelEncryptionConfigInput"}
	if s.FieldLevelEncryptionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldLevelEncryptionConfig"))
	}
	if s.FieldLevelEncryptionConfig != nil {
		if err := s.FieldLevelEncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("FieldLevelEncryptionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldLevelEncryptionConfig sets the FieldLevelEncryptionConfig field's value.
func (s *CreateFieldLevelEncryptionConfigInput) SetFieldLevelEncryptionConfig(v *FieldLevelEncryptionConfig) *CreateFieldLevelEncryptionConfigInput {
	s.FieldLevelEncryptionConfig = v
	return s
}

type CreateFieldLevelEncryptionConfigOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryption"`

	// The current version of the field level encryption configuration. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Returned when you create a new field-level encryption configuration.
	FieldLevelEncryption *FieldLevelEncryption `type:"structure"`

	// The fully qualified URI of the new configuration resource just created. For
	// example: https://cloudfront.amazonaws.com/2010-11-01/field-level-encryption-config/EDFDVBD632BHDS5.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateFieldLevelEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFieldLevelEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreateFieldLevelEncryptionConfigOutput) SetETag(v string) *CreateFieldLevelEncryptionConfigOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryption sets the FieldLevelEncryption field's value.
func (s *CreateFieldLevelEncryptionConfigOutput) SetFieldLevelEncryption(v *FieldLevelEncryption) *CreateFieldLevelEncryptionConfigOutput {
	s.FieldLevelEncryption = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateFieldLevelEncryptionConfigOutput) SetLocation(v string) *CreateFieldLevelEncryptionConfigOutput {
	s.Location = &v
	return s
}

type CreateFieldLevelEncryptionProfileInput struct {
	_ struct{} `locationName:"CreateFieldLevelEncryptionProfileRequest" type:"structure" payload:"FieldLevelEncryptionProfileConfig"`

	// The request to create a field-level encryption profile.
	//
	// FieldLevelEncryptionProfileConfig is a required field
	FieldLevelEncryptionProfileConfig *FieldLevelEncryptionProfileConfig `locationName:"FieldLevelEncryptionProfileConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s CreateFieldLevelEncryptionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFieldLevelEncryptionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFieldLevelEncryptionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFieldLevelEncryptionProfileInput"}
	if s.FieldLevelEncryptionProfileConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldLevelEncryptionProfileConfig"))
	}
	if s.FieldLevelEncryptionProfileConfig != nil {
		if err := s.FieldLevelEncryptionProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("FieldLevelEncryptionProfileConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldLevelEncryptionProfileConfig sets the FieldLevelEncryptionProfileConfig field's value.
func (s *CreateFieldLevelEncryptionProfileInput) SetFieldLevelEncryptionProfileConfig(v *FieldLevelEncryptionProfileConfig) *CreateFieldLevelEncryptionProfileInput {
	s.FieldLevelEncryptionProfileConfig = v
	return s
}

type CreateFieldLevelEncryptionProfileOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionProfile"`

	// The current version of the field level encryption profile. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Returned when you create a new field-level encryption profile.
	FieldLevelEncryptionProfile *FieldLevelEncryptionProfile `type:"structure"`

	// The fully qualified URI of the new profile resource just created. For example:
	// https://cloudfront.amazonaws.com/2010-11-01/field-level-encryption-profile/EDFDVBD632BHDS5.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateFieldLevelEncryptionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFieldLevelEncryptionProfileOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreateFieldLevelEncryptionProfileOutput) SetETag(v string) *CreateFieldLevelEncryptionProfileOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryptionProfile sets the FieldLevelEncryptionProfile field's value.
func (s *CreateFieldLevelEncryptionProfileOutput) SetFieldLevelEncryptionProfile(v *FieldLevelEncryptionProfile) *CreateFieldLevelEncryptionProfileOutput {
	s.FieldLevelEncryptionProfile = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateFieldLevelEncryptionProfileOutput) SetLocation(v string) *CreateFieldLevelEncryptionProfileOutput {
	s.Location = &v
	return s
}

// The request to create an invalidation.
type CreateInvalidationInput struct {
	_ struct{} `locationName:"CreateInvalidationRequest" type:"structure" payload:"InvalidationBatch"`

	// The distribution's id.
	//
	// DistributionId is a required field
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`

	// The batch information for the invalidation.
	//
	// InvalidationBatch is a required field
	InvalidationBatch *InvalidationBatch `locationName:"InvalidationBatch" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s CreateInvalidationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInvalidationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInvalidationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInvalidationInput"}
	if s.DistributionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionId"))
	}
	if s.DistributionId != nil && len(*s.DistributionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DistributionId", 1))
	}
	if s.InvalidationBatch == nil {
		invalidParams.Add(request.NewErrParamRequired("InvalidationBatch"))
	}
	if s.InvalidationBatch != nil {
		if err := s.InvalidationBatch.Validate(); err != nil {
			invalidParams.AddNested("InvalidationBatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionId sets the DistributionId field's value.
func (s *CreateInvalidationInput) SetDistributionId(v string) *CreateInvalidationInput {
	s.DistributionId = &v
	return s
}

// SetInvalidationBatch sets the InvalidationBatch field's value.
func (s *CreateInvalidationInput) SetInvalidationBatch(v *InvalidationBatch) *CreateInvalidationInput {
	s.InvalidationBatch = v
	return s
}

// The returned result of the corresponding request.
type CreateInvalidationOutput struct {
	_ struct{} `type:"structure" payload:"Invalidation"`

	// The invalidation's information.
	Invalidation *Invalidation `type:"structure"`

	// The fully qualified URI of the distribution and invalidation batch request,
	// including the Invalidation ID.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateInvalidationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInvalidationOutput) GoString() string {
	return s.String()
}

// SetInvalidation sets the Invalidation field's value.
func (s *CreateInvalidationOutput) SetInvalidation(v *Invalidation) *CreateInvalidationOutput {
	s.Invalidation = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateInvalidationOutput) SetLocation(v string) *CreateInvalidationOutput {
	s.Location = &v
	return s
}

type CreatePublicKeyInput struct {
	_ struct{} `locationName:"CreatePublicKeyRequest" type:"structure" payload:"PublicKeyConfig"`

	// The request to add a public key to CloudFront.
	//
	// PublicKeyConfig is a required field
	PublicKeyConfig *PublicKeyConfig `locationName:"PublicKeyConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s CreatePublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePublicKeyInput"}
	if s.PublicKeyConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyConfig"))
	}
	if s.PublicKeyConfig != nil {
		if err := s.PublicKeyConfig.Validate(); err != nil {
			invalidParams.AddNested("PublicKeyConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPublicKeyConfig sets the PublicKeyConfig field's value.
func (s *CreatePublicKeyInput) SetPublicKeyConfig(v *PublicKeyConfig) *CreatePublicKeyInput {
	s.PublicKeyConfig = v
	return s
}

type CreatePublicKeyOutput struct {
	_ struct{} `type:"structure" payload:"PublicKey"`

	// The current version of the public key. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new public key resource just created. For
	// example: https://cloudfront.amazonaws.com/2010-11-01/cloudfront-public-key/EDFDVBD632BHDS5.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// Returned when you add a public key.
	PublicKey *PublicKey `type:"structure"`
}

// String returns the string representation
func (s CreatePublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicKeyOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreatePublicKeyOutput) SetETag(v string) *CreatePublicKeyOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreatePublicKeyOutput) SetLocation(v string) *CreatePublicKeyOutput {
	s.Location = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *CreatePublicKeyOutput) SetPublicKey(v *PublicKey) *CreatePublicKeyOutput {
	s.PublicKey = v
	return s
}

// The request to create a new streaming distribution.
type CreateStreamingDistributionInput struct {
	_ struct{} `locationName:"CreateStreamingDistributionRequest" type:"structure" payload:"StreamingDistributionConfig"`

	// The streaming distribution's configuration information.
	//
	// StreamingDistributionConfig is a required field
	StreamingDistributionConfig *StreamingDistributionConfig `locationName:"StreamingDistributionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s CreateStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamingDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamingDistributionInput"}
	if s.StreamingDistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingDistributionConfig"))
	}
	if s.StreamingDistributionConfig != nil {
		if err := s.StreamingDistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("StreamingDistributionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamingDistributionConfig sets the StreamingDistributionConfig field's value.
func (s *CreateStreamingDistributionInput) SetStreamingDistributionConfig(v *StreamingDistributionConfig) *CreateStreamingDistributionInput {
	s.StreamingDistributionConfig = v
	return s
}

// The returned result of the corresponding request.
type CreateStreamingDistributionOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the streaming distribution created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new streaming distribution resource just created.
	// For example: https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s CreateStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingDistributionOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreateStreamingDistributionOutput) SetETag(v string) *CreateStreamingDistributionOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateStreamingDistributionOutput) SetLocation(v string) *CreateStreamingDistributionOutput {
	s.Location = &v
	return s
}

// SetStreamingDistribution sets the StreamingDistribution field's value.
func (s *CreateStreamingDistributionOutput) SetStreamingDistribution(v *StreamingDistribution) *CreateStreamingDistributionOutput {
	s.StreamingDistribution = v
	return s
}

// The request to create a new streaming distribution with tags.
type CreateStreamingDistributionWithTagsInput struct {
	_ struct{} `locationName:"CreateStreamingDistributionWithTagsRequest" type:"structure" payload:"StreamingDistributionConfigWithTags"`

	// The streaming distribution's configuration information.
	//
	// StreamingDistributionConfigWithTags is a required field
	StreamingDistributionConfigWithTags *StreamingDistributionConfigWithTags `locationName:"StreamingDistributionConfigWithTags" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s CreateStreamingDistributionWithTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingDistributionWithTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamingDistributionWithTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamingDistributionWithTagsInput"}
	if s.StreamingDistributionConfigWithTags == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingDistributionConfigWithTags"))
	}
	if s.StreamingDistributionConfigWithTags != nil {
		if err := s.StreamingDistributionConfigWithTags.Validate(); err != nil {
			invalidParams.AddNested("StreamingDistributionConfigWithTags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamingDistributionConfigWithTags sets the StreamingDistributionConfigWithTags field's value.
func (s *CreateStreamingDistributionWithTagsInput) SetStreamingDistributionConfigWithTags(v *StreamingDistributionConfigWithTags) *CreateStreamingDistributionWithTagsInput {
	s.StreamingDistributionConfigWithTags = v
	return s
}

// The returned result of the corresponding request.
type CreateStreamingDistributionWithTagsOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the distribution created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new streaming distribution resource just created.
	// For example:https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s CreateStreamingDistributionWithTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingDistributionWithTagsOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CreateStreamingDistributionWithTagsOutput) SetETag(v string) *CreateStreamingDistributionWithTagsOutput {
	s.ETag = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateStreamingDistributionWithTagsOutput) SetLocation(v string) *CreateStreamingDistributionWithTagsOutput {
	s.Location = &v
	return s
}

// SetStreamingDistribution sets the StreamingDistribution field's value.
func (s *CreateStreamingDistributionWithTagsOutput) SetStreamingDistribution(v *StreamingDistribution) *CreateStreamingDistributionWithTagsOutput {
	s.StreamingDistribution = v
	return s
}

// A complex type that controls:
//
//    * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range
//    with custom error messages before returning the response to the viewer.
//
//    * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
//
// For more information about custom error pages, see Customizing Error Responses
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
// in the Amazon CloudFront Developer Guide.
type CustomErrorResponse struct {
	_ struct{} `type:"structure"`

	// The minimum amount of time, in seconds, that you want CloudFront to cache
	// the HTTP status code specified in ErrorCode. When this time period has elapsed,
	// CloudFront queries your origin to see whether the problem that caused the
	// error has been resolved and the requested object is now available.
	//
	// For more information, see Customizing Error Responses (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
	// in the Amazon CloudFront Developer Guide.
	ErrorCachingMinTTL *int64 `type:"long"`

	// The HTTP status code for which you want to specify a custom error page and/or
	// a caching duration.
	//
	// ErrorCode is a required field
	ErrorCode *int64 `type:"integer" required:"true"`

	// The HTTP status code that you want CloudFront to return to the viewer along
	// with the custom error page. There are a variety of reasons that you might
	// want CloudFront to return a status code different from the status code that
	// your origin returned to CloudFront, for example:
	//
	//    * Some Internet devices (some firewalls and corporate proxies, for example)
	//    intercept HTTP 4xx and 5xx and prevent the response from being returned
	//    to the viewer. If you substitute 200, the response typically won't be
	//    intercepted.
	//
	//    * If you don't care about distinguishing among different client errors
	//    or server errors, you can specify 400 or 500 as the ResponseCode for all
	//    4xx or 5xx errors.
	//
	//    * You might want to return a 200 status code (OK) and static website so
	//    your customers don't know that your website is down.
	//
	// If you specify a value for ResponseCode, you must also specify a value for
	// ResponsePagePath.
	ResponseCode *string `type:"string"`

	// The path to the custom error page that you want CloudFront to return to a
	// viewer when your origin returns the HTTP status code specified by ErrorCode,
	// for example, /4xx-errors/403-forbidden.html. If you want to store your objects
	// and your custom error pages in different locations, your distribution must
	// include a cache behavior for which the following is true:
	//
	//    * The value of PathPattern matches the path to your custom error messages.
	//    For example, suppose you saved custom error pages for 4xx errors in an
	//    Amazon S3 bucket in a directory named /4xx-errors. Your distribution must
	//    include a cache behavior for which the path pattern routes requests for
	//    your custom error pages to that location, for example, /4xx-errors/*.
	//
	//    * The value of TargetOriginId specifies the value of the ID element for
	//    the origin that contains your custom error pages.
	//
	// If you specify a value for ResponsePagePath, you must also specify a value
	// for ResponseCode.
	//
	// We recommend that you store custom error pages in an Amazon S3 bucket. If
	// you store custom error pages on an HTTP server and the server starts to return
	// 5xx errors, CloudFront can't get the files that you want to return to viewers
	// because the origin server is unavailable.
	ResponsePagePath *string `type:"string"`
}

// String returns the string representation
func (s CustomErrorResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomErrorResponse) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomErrorResponse) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomErrorResponse"}
	if s.ErrorCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ErrorCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetErrorCachingMinTTL sets the ErrorCachingMinTTL field's value.
func (s *CustomErrorResponse) SetErrorCachingMinTTL(v int64) *CustomErrorResponse {
	s.ErrorCachingMinTTL = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *CustomErrorResponse) SetErrorCode(v int64) *CustomErrorResponse {
	s.ErrorCode = &v
	return s
}

// SetResponseCode sets the ResponseCode field's value.
func (s *CustomErrorResponse) SetResponseCode(v string) *CustomErrorResponse {
	s.ResponseCode = &v
	return s
}

// SetResponsePagePath sets the ResponsePagePath field's value.
func (s *CustomErrorResponse) SetResponsePagePath(v string) *CustomErrorResponse {
	s.ResponsePagePath = &v
	return s
}

// A complex type that controls:
//
//    * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range
//    with custom error messages before returning the response to the viewer.
//
//    * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
//
// For more information about custom error pages, see Customizing Error Responses
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
// in the Amazon CloudFront Developer Guide.
type CustomErrorResponses struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a CustomErrorResponse element for each HTTP
	// status code for which you want to specify a custom error page and/or a caching
	// duration.
	Items []*CustomErrorResponse `locationNameList:"CustomErrorResponse" type:"list"`

	// The number of HTTP status codes for which you want to specify a custom error
	// page and/or a caching duration. If Quantity is 0, you can omit Items.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomErrorResponses) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomErrorResponses) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomErrorResponses) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomErrorResponses"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *CustomErrorResponses) SetItems(v []*CustomErrorResponse) *CustomErrorResponses {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *CustomErrorResponses) SetQuantity(v int64) *CustomErrorResponses {
	s.Quantity = &v
	return s
}

// A complex type that contains the list of Custom Headers for each origin.
type CustomHeaders struct {
	_ struct{} `type:"structure"`

	// Optional: A list that contains one OriginCustomHeader element for each custom
	// header that you want CloudFront to forward to the origin. If Quantity is
	// 0, omit Items.
	Items []*OriginCustomHeader `locationNameList:"OriginCustomHeader" type:"list"`

	// The number of custom headers, if any, for this distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomHeaders) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomHeaders) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomHeaders) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomHeaders"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *CustomHeaders) SetItems(v []*OriginCustomHeader) *CustomHeaders {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *CustomHeaders) SetQuantity(v int64) *CustomHeaders {
	s.Quantity = &v
	return s
}

// A custom origin. A custom origin is any origin that is not an Amazon S3 bucket,
// with one exception. An Amazon S3 bucket that is configured with static website
// hosting (https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html)
// is a custom origin.
type CustomOriginConfig struct {
	_ struct{} `type:"structure"`

	// The HTTP port that CloudFront uses to connect to the origin. Specify the
	// HTTP port that the origin listens on.
	//
	// HTTPPort is a required field
	HTTPPort *int64 `type:"integer" required:"true"`

	// The HTTPS port that CloudFront uses to connect to the origin. Specify the
	// HTTPS port that the origin listens on.
	//
	// HTTPSPort is a required field
	HTTPSPort *int64 `type:"integer" required:"true"`

	// Specifies how long, in seconds, CloudFront persists its connection to the
	// origin. The minimum timeout is 1 second, the maximum is 60 seconds, and the
	// default (if you don’t specify otherwise) is 5 seconds.
	//
	// For more information, see Origin Keep-alive Timeout (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout)
	// in the Amazon CloudFront Developer Guide.
	OriginKeepaliveTimeout *int64 `type:"integer"`

	// Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to
	// the origin. Valid values are:
	//
	//    * http-only – CloudFront always uses HTTP to connect to the origin.
	//
	//    * match-viewer – CloudFront connects to the origin using the same protocol
	//    that the viewer used to connect to CloudFront.
	//
	//    * https-only – CloudFront always uses HTTPS to connect to the origin.
	//
	// OriginProtocolPolicy is a required field
	OriginProtocolPolicy *string `type:"string" required:"true" enum:"OriginProtocolPolicy"`

	// Specifies how long, in seconds, CloudFront waits for a response from the
	// origin. This is also known as the origin response timeout. The minimum timeout
	// is 1 second, the maximum is 60 seconds, and the default (if you don’t specify
	// otherwise) is 30 seconds.
	//
	// For more information, see Origin Response Timeout (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout)
	// in the Amazon CloudFront Developer Guide.
	OriginReadTimeout *int64 `type:"integer"`

	// Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting
	// to your origin over HTTPS. Valid values include SSLv3, TLSv1, TLSv1.1, and
	// TLSv1.2.
	//
	// For more information, see Minimum Origin SSL Protocol (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols)
	// in the Amazon CloudFront Developer Guide.
	OriginSslProtocols *OriginSslProtocols `type:"structure"`
}

// String returns the string representation
func (s CustomOriginConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomOriginConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomOriginConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomOriginConfig"}
	if s.HTTPPort == nil {
		invalidParams.Add(request.NewErrParamRequired("HTTPPort"))
	}
	if s.HTTPSPort == nil {
		invalidParams.Add(request.NewErrParamRequired("HTTPSPort"))
	}
	if s.OriginProtocolPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginProtocolPolicy"))
	}
	if s.OriginSslProtocols != nil {
		if err := s.OriginSslProtocols.Validate(); err != nil {
			invalidParams.AddNested("OriginSslProtocols", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHTTPPort sets the HTTPPort field's value.
func (s *CustomOriginConfig) SetHTTPPort(v int64) *CustomOriginConfig {
	s.HTTPPort = &v
	return s
}

// SetHTTPSPort sets the HTTPSPort field's value.
func (s *CustomOriginConfig) SetHTTPSPort(v int64) *CustomOriginConfig {
	s.HTTPSPort = &v
	return s
}

// SetOriginKeepaliveTimeout sets the OriginKeepaliveTimeout field's value.
func (s *CustomOriginConfig) SetOriginKeepaliveTimeout(v int64) *CustomOriginConfig {
	s.OriginKeepaliveTimeout = &v
	return s
}

// SetOriginProtocolPolicy sets the OriginProtocolPolicy field's value.
func (s *CustomOriginConfig) SetOriginProtocolPolicy(v string) *CustomOriginConfig {
	s.OriginProtocolPolicy = &v
	return s
}

// SetOriginReadTimeout sets the OriginReadTimeout field's value.
func (s *CustomOriginConfig) SetOriginReadTimeout(v int64) *CustomOriginConfig {
	s.OriginReadTimeout = &v
	return s
}

// SetOriginSslProtocols sets the OriginSslProtocols field's value.
func (s *CustomOriginConfig) SetOriginSslProtocols(v *OriginSslProtocols) *CustomOriginConfig {
	s.OriginSslProtocols = v
	return s
}

// A complex type that describes the default cache behavior if you don’t specify
// a CacheBehavior element or if request URLs don’t match any of the values
// of PathPattern in CacheBehavior elements. You must create exactly one default
// cache behavior.
type DefaultCacheBehavior struct {
	_ struct{} `type:"structure"`

	// A complex type that controls which HTTP methods CloudFront processes and
	// forwards to your Amazon S3 bucket or your custom origin. There are three
	// choices:
	//
	//    * CloudFront forwards only GET and HEAD requests.
	//
	//    * CloudFront forwards only GET, HEAD, and OPTIONS requests.
	//
	//    * CloudFront forwards GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE
	//    requests.
	//
	// If you pick the third choice, you may need to restrict access to your Amazon
	// S3 bucket or to your custom origin so users can't perform operations that
	// you don't want them to. For example, you might not want users to have permissions
	// to delete objects from your origin.
	AllowedMethods *AllowedMethods `type:"structure"`

	// Whether you want CloudFront to automatically compress certain files for this
	// cache behavior. If so, specify true; if not, specify false. For more information,
	// see Serving Compressed Files (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html)
	// in the Amazon CloudFront Developer Guide.
	Compress *bool `type:"boolean"`

	// The default amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when
	// your origin does not add HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. For more information, see Managing How
	// Long Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	DefaultTTL *int64 `type:"long"`

	// The value of ID for the field-level encryption configuration that you want
	// CloudFront to use for encrypting specific fields of data for the default
	// cache behavior.
	FieldLevelEncryptionId *string `type:"string"`

	// A complex type that specifies how CloudFront handles query strings, cookies,
	// and HTTP headers.
	//
	// ForwardedValues is a required field
	ForwardedValues *ForwardedValues `type:"structure" required:"true"`

	// A complex type that contains zero or more Lambda function associations for
	// a cache behavior.
	LambdaFunctionAssociations *LambdaFunctionAssociations `type:"structure"`

	// The maximum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. The value that you specify applies only when
	// your origin adds HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. For more information, see Managing How
	// Long Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	MaxTTL *int64 `type:"long"`

	// The minimum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront forwards another request to your origin to determine whether
	// the object has been updated. For more information, see Managing How Long
	// Content Stays in an Edge Cache (Expiration) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// You must specify 0 for MinTTL if you configure CloudFront to forward all
	// headers to your origin (under Headers, if you specify 1 for Quantity and
	// * for Name).
	//
	// MinTTL is a required field
	MinTTL *int64 `type:"long" required:"true"`

	// Indicates whether you want to distribute media files in the Microsoft Smooth
	// Streaming format using the origin that is associated with this cache behavior.
	// If so, specify true; if not, specify false. If you specify true for SmoothStreaming,
	// you can still distribute other content using this cache behavior if the content
	// matches the value of PathPattern.
	SmoothStreaming *bool `type:"boolean"`

	// The value of ID for the origin that you want CloudFront to route requests
	// to when they use the default cache behavior.
	//
	// TargetOriginId is a required field
	TargetOriginId *string `type:"string" required:"true"`

	// A complex type that specifies the AWS accounts, if any, that you want to
	// allow to create signed URLs for private content.
	//
	// If you want to require signed URLs in requests for objects in the target
	// origin that match the PathPattern for this cache behavior, specify true for
	// Enabled, and specify the applicable values for Quantity and Items. For more
	// information, see Serving Private Content with Signed URLs and Signed Cookies
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you don’t want to require signed URLs in requests for objects that match
	// PathPattern, specify false for Enabled and 0 for Quantity. Omit Items.
	//
	// To add, change, or remove one or more trusted signers, change Enabled to
	// true (if it’s currently false), change Quantity as applicable, and specify
	// all of the trusted signers that you want to include in the updated distribution.
	//
	// TrustedSigners is a required field
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`

	// The protocol that viewers can use to access the files in the origin specified
	// by TargetOriginId when a request matches the path pattern in PathPattern.
	// You can specify the following options:
	//
	//    * allow-all: Viewers can use HTTP or HTTPS.
	//
	//    * redirect-to-https: If a viewer submits an HTTP request, CloudFront returns
	//    an HTTP status code of 301 (Moved Permanently) to the viewer along with
	//    the HTTPS URL. The viewer then resubmits the request using the new URL.
	//
	//    * https-only: If a viewer sends an HTTP request, CloudFront returns an
	//    HTTP status code of 403 (Forbidden).
	//
	// For more information about requiring the HTTPS protocol, see Requiring HTTPS
	// Between Viewers and CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// The only way to guarantee that viewers retrieve an object that was fetched
	// from the origin using HTTPS is never to use any other protocol to fetch the
	// object. If you have recently changed from HTTP to HTTPS, we recommend that
	// you clear your objects’ cache because cached objects are protocol agnostic.
	// That means that an edge location will return an object from the cache regardless
	// of whether the current request protocol matches the protocol used previously.
	// For more information, see Managing Cache Expiration (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// ViewerProtocolPolicy is a required field
	ViewerProtocolPolicy *string `type:"string" required:"true" enum:"ViewerProtocolPolicy"`
}

// String returns the string representation
func (s DefaultCacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultCacheBehavior) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefaultCacheBehavior) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DefaultCacheBehavior"}
	if s.ForwardedValues == nil {
		invalidParams.Add(request.NewErrParamRequired("ForwardedValues"))
	}
	if s.MinTTL == nil {
		invalidParams.Add(request.NewErrParamRequired("MinTTL"))
	}
	if s.TargetOriginId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetOriginId"))
	}
	if s.TrustedSigners == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustedSigners"))
	}
	if s.ViewerProtocolPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ViewerProtocolPolicy"))
	}
	if s.AllowedMethods != nil {
		if err := s.AllowedMethods.Validate(); err != nil {
			invalidParams.AddNested("AllowedMethods", err.(request.ErrInvalidParams))
		}
	}
	if s.ForwardedValues != nil {
		if err := s.ForwardedValues.Validate(); err != nil {
			invalidParams.AddNested("ForwardedValues", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaFunctionAssociations != nil {
		if err := s.LambdaFunctionAssociations.Validate(); err != nil {
			invalidParams.AddNested("LambdaFunctionAssociations", err.(request.ErrInvalidParams))
		}
	}
	if s.TrustedSigners != nil {
		if err := s.TrustedSigners.Validate(); err != nil {
			invalidParams.AddNested("TrustedSigners", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedMethods sets the AllowedMethods field's value.
func (s *DefaultCacheBehavior) SetAllowedMethods(v *AllowedMethods) *DefaultCacheBehavior {
	s.AllowedMethods = v
	return s
}

// SetCompress sets the Compress field's value.
func (s *DefaultCacheBehavior) SetCompress(v bool) *DefaultCacheBehavior {
	s.Compress = &v
	return s
}

// SetDefaultTTL sets the DefaultTTL field's value.
func (s *DefaultCacheBehavior) SetDefaultTTL(v int64) *DefaultCacheBehavior {
	s.DefaultTTL = &v
	return s
}

// SetFieldLevelEncryptionId sets the FieldLevelEncryptionId field's value.
func (s *DefaultCacheBehavior) SetFieldLevelEncryptionId(v string) *DefaultCacheBehavior {
	s.FieldLevelEncryptionId = &v
	return s
}

// SetForwardedValues sets the ForwardedValues field's value.
func (s *DefaultCacheBehavior) SetForwardedValues(v *ForwardedValues) *DefaultCacheBehavior {
	s.ForwardedValues = v
	return s
}

// SetLambdaFunctionAssociations sets the LambdaFunctionAssociations field's value.
func (s *DefaultCacheBehavior) SetLambdaFunctionAssociations(v *LambdaFunctionAssociations) *DefaultCacheBehavior {
	s.LambdaFunctionAssociations = v
	return s
}

// SetMaxTTL sets the MaxTTL field's value.
func (s *DefaultCacheBehavior) SetMaxTTL(v int64) *DefaultCacheBehavior {
	s.MaxTTL = &v
	return s
}

// SetMinTTL sets the MinTTL field's value.
func (s *DefaultCacheBehavior) SetMinTTL(v int64) *DefaultCacheBehavior {
	s.MinTTL = &v
	return s
}

// SetSmoothStreaming sets the SmoothStreaming field's value.
func (s *DefaultCacheBehavior) SetSmoothStreaming(v bool) *DefaultCacheBehavior {
	s.SmoothStreaming = &v
	return s
}

// SetTargetOriginId sets the TargetOriginId field's value.
func (s *DefaultCacheBehavior) SetTargetOriginId(v string) *DefaultCacheBehavior {
	s.TargetOriginId = &v
	return s
}

// SetTrustedSigners sets the TrustedSigners field's value.
func (s *DefaultCacheBehavior) SetTrustedSigners(v *TrustedSigners) *DefaultCacheBehavior {
	s.TrustedSigners = v
	return s
}

// SetViewerProtocolPolicy sets the ViewerProtocolPolicy field's value.
func (s *DefaultCacheBehavior) SetViewerProtocolPolicy(v string) *DefaultCacheBehavior {
	s.ViewerProtocolPolicy = &v
	return s
}

// Deletes a origin access identity.
type DeleteCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `locationName:"DeleteCloudFrontOriginAccessIdentityRequest" type:"structure"`

	// The origin access identity's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header you received from a previous GET or PUT request.
	// For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCloudFrontOriginAccessIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCloudFrontOriginAccessIdentityInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteCloudFrontOriginAccessIdentityInput) SetId(v string) *DeleteCloudFrontOriginAccessIdentityInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteCloudFrontOriginAccessIdentityInput) SetIfMatch(v string) *DeleteCloudFrontOriginAccessIdentityInput {
	s.IfMatch = &v
	return s
}

type DeleteCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// This action deletes a web distribution. To delete a web distribution using
// the CloudFront API, perform the following steps.
//
// To delete a web distribution using the CloudFront API:
//
// Disable the web distribution
//
// Submit a GET Distribution Config request to get the current configuration
// and the Etag header for the distribution.
//
// Update the XML document that was returned in the response to your GET Distribution
// Config request to change the value of Enabled to false.
//
// Submit a PUT Distribution Config request to update the configuration for
// your distribution. In the request body, include the XML document that you
// updated in Step 3. Set the value of the HTTP If-Match header to the value
// of the ETag header that CloudFront returned when you submitted the GET Distribution
// Config request in Step 2.
//
// Review the response to the PUT Distribution Config request to confirm that
// the distribution was successfully disabled.
//
// Submit a GET Distribution request to confirm that your changes have propagated.
// When propagation is complete, the value of Status is Deployed.
//
// Submit a DELETE Distribution request. Set the value of the HTTP If-Match
// header to the value of the ETag header that CloudFront returned when you
// submitted the GET Distribution Config request in Step 6.
//
// Review the response to your DELETE Distribution request to confirm that the
// distribution was successfully deleted.
//
// For information about deleting a distribution using the CloudFront console,
// see Deleting a Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html)
// in the Amazon CloudFront Developer Guide.
type DeleteDistributionInput struct {
	_ struct{} `locationName:"DeleteDistributionRequest" type:"structure"`

	// The distribution ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when you disabled the distribution.
	// For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDistributionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteDistributionInput) SetId(v string) *DeleteDistributionInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteDistributionInput) SetIfMatch(v string) *DeleteDistributionInput {
	s.IfMatch = &v
	return s
}

type DeleteDistributionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDistributionOutput) GoString() string {
	return s.String()
}

type DeleteFieldLevelEncryptionConfigInput struct {
	_ struct{} `locationName:"DeleteFieldLevelEncryptionConfigRequest" type:"structure"`

	// The ID of the configuration you want to delete from CloudFront.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the configuration
	// identity to delete. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteFieldLevelEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFieldLevelEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFieldLevelEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFieldLevelEncryptionConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteFieldLevelEncryptionConfigInput) SetId(v string) *DeleteFieldLevelEncryptionConfigInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteFieldLevelEncryptionConfigInput) SetIfMatch(v string) *DeleteFieldLevelEncryptionConfigInput {
	s.IfMatch = &v
	return s
}

type DeleteFieldLevelEncryptionConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFieldLevelEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFieldLevelEncryptionConfigOutput) GoString() string {
	return s.String()
}

type DeleteFieldLevelEncryptionProfileInput struct {
	_ struct{} `locationName:"DeleteFieldLevelEncryptionProfileRequest" type:"structure"`

	// Request the ID of the profile you want to delete from CloudFront.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the profile
	// to delete. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteFieldLevelEncryptionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFieldLevelEncryptionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFieldLevelEncryptionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFieldLevelEncryptionProfileInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteFieldLevelEncryptionProfileInput) SetId(v string) *DeleteFieldLevelEncryptionProfileInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteFieldLevelEncryptionProfileInput) SetIfMatch(v string) *DeleteFieldLevelEncryptionProfileInput {
	s.IfMatch = &v
	return s
}

type DeleteFieldLevelEncryptionProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFieldLevelEncryptionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFieldLevelEncryptionProfileOutput) GoString() string {
	return s.String()
}

type DeletePublicKeyInput struct {
	_ struct{} `locationName:"DeletePublicKeyRequest" type:"structure"`

	// The ID of the public key you want to remove from CloudFront.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the public
	// key identity to delete. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeletePublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePublicKeyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeletePublicKeyInput) SetId(v string) *DeletePublicKeyInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeletePublicKeyInput) SetIfMatch(v string) *DeletePublicKeyInput {
	s.IfMatch = &v
	return s
}

type DeletePublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePublicKeyOutput) GoString() string {
	return s.String()
}

// The request to delete a streaming distribution.
type DeleteStreamingDistributionInput struct {
	_ struct{} `locationName:"DeleteStreamingDistributionRequest" type:"structure"`

	// The distribution ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when you disabled the streaming
	// distribution. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamingDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamingDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamingDistributionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteStreamingDistributionInput) SetId(v string) *DeleteStreamingDistributionInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *DeleteStreamingDistributionInput) SetIfMatch(v string) *DeleteStreamingDistributionInput {
	s.IfMatch = &v
	return s
}

type DeleteStreamingDistributionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamingDistributionOutput) GoString() string {
	return s.String()
}

// A distribution tells CloudFront where you want content to be delivered from,
// and the details about how to track and manage content delivery.
type Distribution struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the distribution. For example: arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// CloudFront automatically adds this element to the response only if you've
	// set up the distribution to serve private content with signed URLs. The element
	// lists the key pair IDs that CloudFront is aware of for each trusted signer.
	// The Signer child element lists the AWS account number of the trusted signer
	// (or an empty Self element if the signer is you). The Signer element also
	// includes the IDs of any active key pairs associated with the trusted signer's
	// AWS account. If no KeyPairId element appears for a Signer, that signer can't
	// create working signed URLs.
	//
	// ActiveTrustedSigners is a required field
	ActiveTrustedSigners *ActiveTrustedSigners `type:"structure" required:"true"`

	// AWS services in China customers must file for an Internet Content Provider
	// (ICP) recordal if they want to serve content publicly on an alternate domain
	// name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal
	// provides the ICP recordal status for CNAMEs associated with distributions.
	//
	// For more information about ICP recordals, see Signup, Accounts, and Credentials
	// (https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html)
	// in Getting Started with AWS services in China.
	AliasICPRecordals []*AliasICPRecordal `locationNameList:"AliasICPRecordal" type:"list"`

	// The current configuration information for the distribution. Send a GET request
	// to the /CloudFront API version/distribution ID/config resource.
	//
	// DistributionConfig is a required field
	DistributionConfig *DistributionConfig `type:"structure" required:"true"`

	// The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The identifier for the distribution. For example: EDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The number of invalidation batches currently in progress.
	//
	// InProgressInvalidationBatches is a required field
	InProgressInvalidationBatches *int64 `type:"integer" required:"true"`

	// The date and time the distribution was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// This response element indicates the current status of the distribution. When
	// the status is Deployed, the distribution's information is fully propagated
	// to all CloudFront edge locations.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Distribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Distribution) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *Distribution) SetARN(v string) *Distribution {
	s.ARN = &v
	return s
}

// SetActiveTrustedSigners sets the ActiveTrustedSigners field's value.
func (s *Distribution) SetActiveTrustedSigners(v *ActiveTrustedSigners) *Distribution {
	s.ActiveTrustedSigners = v
	return s
}

// SetAliasICPRecordals sets the AliasICPRecordals field's value.
func (s *Distribution) SetAliasICPRecordals(v []*AliasICPRecordal) *Distribution {
	s.AliasICPRecordals = v
	return s
}

// SetDistributionConfig sets the DistributionConfig field's value.
func (s *Distribution) SetDistributionConfig(v *DistributionConfig) *Distribution {
	s.DistributionConfig = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *Distribution) SetDomainName(v string) *Distribution {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *Distribution) SetId(v string) *Distribution {
	s.Id = &v
	return s
}

// SetInProgressInvalidationBatches sets the InProgressInvalidationBatches field's value.
func (s *Distribution) SetInProgressInvalidationBatches(v int64) *Distribution {
	s.InProgressInvalidationBatches = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Distribution) SetLastModifiedTime(v time.Time) *Distribution {
	s.LastModifiedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Distribution) SetStatus(v string) *Distribution {
	s.Status = &v
	return s
}

// A distribution configuration.
type DistributionConfig struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this distribution.
	Aliases *Aliases `type:"structure"`

	// A complex type that contains zero or more CacheBehavior elements.
	CacheBehaviors *CacheBehaviors `type:"structure"`

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// DistributionConfig object), CloudFront creates a new distribution.
	//
	// If CallerReference is a value that you already sent in a previous request
	// to create a distribution, CloudFront returns a DistributionAlreadyExists
	// error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the distribution.
	//
	// If you don't want to specify a comment, include an empty Comment element.
	//
	// To delete an existing comment, update the distribution configuration and
	// include an empty Comment element.
	//
	// To add or change a comment, update the distribution configuration and specify
	// the new comment.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true" sensitive:"true"`

	// A complex type that controls the following:
	//
	//    * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range
	//    with custom error messages before returning the response to the viewer.
	//
	//    * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
	//
	// For more information about custom error pages, see Customizing Error Responses
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html)
	// in the Amazon CloudFront Developer Guide.
	CustomErrorResponses *CustomErrorResponses `type:"structure"`

	// A complex type that describes the default cache behavior if you don't specify
	// a CacheBehavior element or if files don't match any of the values of PathPattern
	// in CacheBehavior elements. You must create exactly one default cache behavior.
	//
	// DefaultCacheBehavior is a required field
	DefaultCacheBehavior *DefaultCacheBehavior `type:"structure" required:"true"`

	// The object that you want CloudFront to request from your origin (for example,
	// index.html) when a viewer requests the root URL for your distribution (http://www.example.com)
	// instead of an object in your distribution (http://www.example.com/product-description.html).
	// Specifying a default root object avoids exposing the contents of your distribution.
	//
	// Specify only the object name, for example, index.html. Don't add a / before
	// the object name.
	//
	// If you don't want to specify a default root object when you create a distribution,
	// include an empty DefaultRootObject element.
	//
	// To delete the default root object from an existing distribution, update the
	// distribution configuration and include an empty DefaultRootObject element.
	//
	// To replace the default root object, update the distribution configuration
	// and specify the new object.
	//
	// For more information about the default root object, see Creating a Default
	// Root Object (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html)
	// in the Amazon CloudFront Developer Guide.
	DefaultRootObject *string `type:"string"`

	// From this field, you can enable or disable the selected distribution.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// (Optional) Specify the maximum HTTP version that you want viewers to use
	// to communicate with CloudFront. The default value for new web distributions
	// is http2. Viewers that don't support HTTP/2 automatically use an earlier
	// HTTP version.
	//
	// For viewers and CloudFront to use HTTP/2, viewers must support TLS 1.2 or
	// later, and must support Server Name Identification (SNI).
	//
	// In general, configuring CloudFront to communicate with viewers using HTTP/2
	// reduces latency. You can improve performance by optimizing for HTTP/2. For
	// more information, do an Internet search for "http/2 optimization."
	HttpVersion *string `type:"string" enum:"HttpVersion"`

	// If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address
	// for your distribution, specify true. If you specify false, CloudFront responds
	// to IPv6 DNS requests with the DNS response code NOERROR and with no IP addresses.
	// This allows viewers to submit a second request, for an IPv4 address for your
	// distribution.
	//
	// In general, you should enable IPv6 if you have users on IPv6 networks who
	// want to access your content. However, if you're using signed URLs or signed
	// cookies to restrict access to your content, and if you're using a custom
	// policy that includes the IpAddress parameter to restrict the IP addresses
	// that can access your content, don't enable IPv6. If you want to restrict
	// access to some content by IP address and not restrict access to other content
	// (or restrict access but not by IP address), you can create two distributions.
	// For more information, see Creating a Signed URL Using a Custom Policy (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// If you're using an Amazon Route 53 alias resource record set to route traffic
	// to your CloudFront distribution, you need to create a second alias resource
	// record set when both of the following are true:
	//
	//    * You enable IPv6 for the distribution
	//
	//    * You're using alternate domain names in the URLs for your objects
	//
	// For more information, see Routing Traffic to an Amazon CloudFront Web Distribution
	// by Using Your Domain Name (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// If you created a CNAME resource record set, either with Amazon Route 53 or
	// with another DNS service, you don't need to make any changes. A CNAME record
	// will route traffic to your distribution regardless of the IP address format
	// of the viewer request.
	IsIPV6Enabled *bool `type:"boolean"`

	// A complex type that controls whether access logs are written for the distribution.
	//
	// For more information about logging, see Access Logs (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html)
	// in the Amazon CloudFront Developer Guide.
	Logging *LoggingConfig `type:"structure"`

	// A complex type that contains information about origin groups for this distribution.
	OriginGroups *OriginGroups `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	//
	// Origins is a required field
	Origins *Origins `type:"structure" required:"true"`

	// The price class that corresponds with the maximum price that you want to
	// pay for CloudFront service. If you specify PriceClass_All, CloudFront responds
	// to requests for your objects from all CloudFront edge locations.
	//
	// If you specify a price class other than PriceClass_All, CloudFront serves
	// your objects from the CloudFront edge location that has the lowest latency
	// among the edge locations in your price class. Viewers who are in or near
	// regions that are excluded from your specified price class may encounter slower
	// performance.
	//
	// For more information about price classes, see Choosing the Price Class for
	// a CloudFront Distribution (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html)
	// in the Amazon CloudFront Developer Guide. For information about CloudFront
	// pricing, including how price classes (such as Price Class 100) map to CloudFront
	// regions, see Amazon CloudFront Pricing (http://aws.amazon.com/cloudfront/pricing/).
	// For price class information, scroll down to see the table at the bottom of
	// the page.
	PriceClass *string `type:"string" enum:"PriceClass"`

	// A complex type that identifies ways in which you want to restrict distribution
	// of your content.
	Restrictions *Restrictions `type:"structure"`

	// A complex type that determines the distribution’s SSL/TLS configuration
	// for communicating with viewers.
	ViewerCertificate *ViewerCertificate `type:"structure"`

	// A unique identifier that specifies the AWS WAF web ACL, if any, to associate
	// with this distribution. To specify a web ACL created using the latest version
	// of AWS WAF, use the ACL ARN, for example arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a.
	// To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
	// 473e64fd-f30b-4765-81a0-62ad96dd167a.
	//
	// AWS WAF is a web application firewall that lets you monitor the HTTP and
	// HTTPS requests that are forwarded to CloudFront, and lets you control access
	// to your content. Based on conditions that you specify, such as the IP addresses
	// that requests originate from or the values of query strings, CloudFront responds
	// to requests either with the requested content or with an HTTP 403 status
	// code (Forbidden). You can also configure CloudFront to return a custom error
	// page when a request is blocked. For more information about AWS WAF, see the
	// AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
	WebACLId *string `type:"string"`
}

// String returns the string representation
func (s DistributionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DistributionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DistributionConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.Comment == nil {
		invalidParams.Add(request.NewErrParamRequired("Comment"))
	}
	if s.DefaultCacheBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultCacheBehavior"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Origins == nil {
		invalidParams.Add(request.NewErrParamRequired("Origins"))
	}
	if s.Aliases != nil {
		if err := s.Aliases.Validate(); err != nil {
			invalidParams.AddNested("Aliases", err.(request.ErrInvalidParams))
		}
	}
	if s.CacheBehaviors != nil {
		if err := s.CacheBehaviors.Validate(); err != nil {
			invalidParams.AddNested("CacheBehaviors", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomErrorResponses != nil {
		if err := s.CustomErrorResponses.Validate(); err != nil {
			invalidParams.AddNested("CustomErrorResponses", err.(request.ErrInvalidParams))
		}
	}
	if s.DefaultCacheBehavior != nil {
		if err := s.DefaultCacheBehavior.Validate(); err != nil {
			invalidParams.AddNested("DefaultCacheBehavior", err.(request.ErrInvalidParams))
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(request.ErrInvalidParams))
		}
	}
	if s.OriginGroups != nil {
		if err := s.OriginGroups.Validate(); err != nil {
			invalidParams.AddNested("OriginGroups", err.(request.ErrInvalidParams))
		}
	}
	if s.Origins != nil {
		if err := s.Origins.Validate(); err != nil {
			invalidParams.AddNested("Origins", err.(request.ErrInvalidParams))
		}
	}
	if s.Restrictions != nil {
		if err := s.Restrictions.Validate(); err != nil {
			invalidParams.AddNested("Restrictions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliases sets the Aliases field's value.
func (s *DistributionConfig) SetAliases(v *Aliases) *DistributionConfig {
	s.Aliases = v
	return s
}

// SetCacheBehaviors sets the CacheBehaviors field's value.
func (s *DistributionConfig) SetCacheBehaviors(v *CacheBehaviors) *DistributionConfig {
	s.CacheBehaviors = v
	return s
}

// SetCallerReference sets the CallerReference field's value.
func (s *DistributionConfig) SetCallerReference(v string) *DistributionConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *DistributionConfig) SetComment(v string) *DistributionConfig {
	s.Comment = &v
	return s
}

// SetCustomErrorResponses sets the CustomErrorResponses field's value.
func (s *DistributionConfig) SetCustomErrorResponses(v *CustomErrorResponses) *DistributionConfig {
	s.CustomErrorResponses = v
	return s
}

// SetDefaultCacheBehavior sets the DefaultCacheBehavior field's value.
func (s *DistributionConfig) SetDefaultCacheBehavior(v *DefaultCacheBehavior) *DistributionConfig {
	s.DefaultCacheBehavior = v
	return s
}

// SetDefaultRootObject sets the DefaultRootObject field's value.
func (s *DistributionConfig) SetDefaultRootObject(v string) *DistributionConfig {
	s.DefaultRootObject = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *DistributionConfig) SetEnabled(v bool) *DistributionConfig {
	s.Enabled = &v
	return s
}

// SetHttpVersion sets the HttpVersion field's value.
func (s *DistributionConfig) SetHttpVersion(v string) *DistributionConfig {
	s.HttpVersion = &v
	return s
}

// SetIsIPV6Enabled sets the IsIPV6Enabled field's value.
func (s *DistributionConfig) SetIsIPV6Enabled(v bool) *DistributionConfig {
	s.IsIPV6Enabled = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *DistributionConfig) SetLogging(v *LoggingConfig) *DistributionConfig {
	s.Logging = v
	return s
}

// SetOriginGroups sets the OriginGroups field's value.
func (s *DistributionConfig) SetOriginGroups(v *OriginGroups) *DistributionConfig {
	s.OriginGroups = v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *DistributionConfig) SetOrigins(v *Origins) *DistributionConfig {
	s.Origins = v
	return s
}

// SetPriceClass sets the PriceClass field's value.
func (s *DistributionConfig) SetPriceClass(v string) *DistributionConfig {
	s.PriceClass = &v
	return s
}

// SetRestrictions sets the Restrictions field's value.
func (s *DistributionConfig) SetRestrictions(v *Restrictions) *DistributionConfig {
	s.Restrictions = v
	return s
}

// SetViewerCertificate sets the ViewerCertificate field's value.
func (s *DistributionConfig) SetViewerCertificate(v *ViewerCertificate) *DistributionConfig {
	s.ViewerCertificate = v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *DistributionConfig) SetWebACLId(v string) *DistributionConfig {
	s.WebACLId = &v
	return s
}

// A distribution Configuration and a list of tags to be associated with the
// distribution.
type DistributionConfigWithTags struct {
	_ struct{} `type:"structure"`

	// A distribution configuration.
	//
	// DistributionConfig is a required field
	DistributionConfig *DistributionConfig `type:"structure" required:"true"`

	// A complex type that contains zero or more Tag elements.
	//
	// Tags is a required field
	Tags *Tags `type:"structure" required:"true"`
}

// String returns the string representation
func (s DistributionConfigWithTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionConfigWithTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DistributionConfigWithTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DistributionConfigWithTags"}
	if s.DistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionConfig"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.DistributionConfig != nil {
		if err := s.DistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("DistributionConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		if err := s.Tags.Validate(); err != nil {
			invalidParams.AddNested("Tags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionConfig sets the DistributionConfig field's value.
func (s *DistributionConfigWithTags) SetDistributionConfig(v *DistributionConfig) *DistributionConfigWithTags {
	s.DistributionConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DistributionConfigWithTags) SetTags(v *Tags) *DistributionConfigWithTags {
	s.Tags = v
	return s
}

// A distribution list.
type DistributionList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more distributions remain to be listed. If
	// your results were truncated, you can make a follow-up pagination request
	// using the Marker request parameter to retrieve more distributions in the
	// list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one DistributionSummary element for each distribution
	// that was created by the current AWS account.
	Items []*DistributionSummary `locationNameList:"DistributionSummary" type:"list"`

	// The value you provided for the Marker request parameter.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value you provided for the MaxItems request parameter.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your distributions
	// where they left off.
	NextMarker *string `type:"string"`

	// The number of distributions that were created by the current AWS account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s DistributionList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionList) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *DistributionList) SetIsTruncated(v bool) *DistributionList {
	s.IsTruncated = &v
	return s
}

// SetItems sets the Items field's value.
func (s *DistributionList) SetItems(v []*DistributionSummary) *DistributionList {
	s.Items = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DistributionList) SetMarker(v string) *DistributionList {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *DistributionList) SetMaxItems(v int64) *DistributionList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *DistributionList) SetNextMarker(v string) *DistributionList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *DistributionList) SetQuantity(v int64) *DistributionList {
	s.Quantity = &v
	return s
}

// A summary of the information about a CloudFront distribution.
type DistributionSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the distribution. For example: arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// AWS services in China customers must file for an Internet Content Provider
	// (ICP) recordal if they want to serve content publicly on an alternate domain
	// name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal
	// provides the ICP recordal status for CNAMEs associated with distributions.
	//
	// For more information about ICP recordals, see Signup, Accounts, and Credentials
	// (https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html)
	// in Getting Started with AWS services in China.
	AliasICPRecordals []*AliasICPRecordal `locationNameList:"AliasICPRecordal" type:"list"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this distribution.
	//
	// Aliases is a required field
	Aliases *Aliases `type:"structure" required:"true"`

	// A complex type that contains zero or more CacheBehavior elements.
	//
	// CacheBehaviors is a required field
	CacheBehaviors *CacheBehaviors `type:"structure" required:"true"`

	// The comment originally specified when this distribution was created.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// A complex type that contains zero or more CustomErrorResponses elements.
	//
	// CustomErrorResponses is a required field
	CustomErrorResponses *CustomErrorResponses `type:"structure" required:"true"`

	// A complex type that describes the default cache behavior if you don't specify
	// a CacheBehavior element or if files don't match any of the values of PathPattern
	// in CacheBehavior elements. You must create exactly one default cache behavior.
	//
	// DefaultCacheBehavior is a required field
	DefaultCacheBehavior *DefaultCacheBehavior `type:"structure" required:"true"`

	// The domain name that corresponds to the distribution, for example, d111111abcdef8.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Whether the distribution is enabled to accept user requests for content.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specify the maximum HTTP version that you want viewers to use to communicate
	// with CloudFront. The default value for new web distributions is http2. Viewers
	// that don't support HTTP/2 will automatically use an earlier version.
	//
	// HttpVersion is a required field
	HttpVersion *string `type:"string" required:"true" enum:"HttpVersion"`

	// The identifier for the distribution. For example: EDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for
	// your distribution.
	//
	// IsIPV6Enabled is a required field
	IsIPV6Enabled *bool `type:"boolean" required:"true"`

	// The date and time the distribution was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// A complex type that contains information about origin groups for this distribution.
	OriginGroups *OriginGroups `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	//
	// Origins is a required field
	Origins *Origins `type:"structure" required:"true"`

	// A complex type that contains information about price class for this streaming
	// distribution.
	//
	// PriceClass is a required field
	PriceClass *string `type:"string" required:"true" enum:"PriceClass"`

	// A complex type that identifies ways in which you want to restrict distribution
	// of your content.
	//
	// Restrictions is a required field
	Restrictions *Restrictions `type:"structure" required:"true"`

	// The current status of the distribution. When the status is Deployed, the
	// distribution's information is propagated to all CloudFront edge locations.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// A complex type that determines the distribution’s SSL/TLS configuration
	// for communicating with viewers.
	//
	// ViewerCertificate is a required field
	ViewerCertificate *ViewerCertificate `type:"structure" required:"true"`

	// The Web ACL Id (if any) associated with the distribution.
	//
	// WebACLId is a required field
	WebACLId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DistributionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionSummary) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *DistributionSummary) SetARN(v string) *DistributionSummary {
	s.ARN = &v
	return s
}

// SetAliasICPRecordals sets the AliasICPRecordals field's value.
func (s *DistributionSummary) SetAliasICPRecordals(v []*AliasICPRecordal) *DistributionSummary {
	s.AliasICPRecordals = v
	return s
}

// SetAliases sets the Aliases field's value.
func (s *DistributionSummary) SetAliases(v *Aliases) *DistributionSummary {
	s.Aliases = v
	return s
}

// SetCacheBehaviors sets the CacheBehaviors field's value.
func (s *DistributionSummary) SetCacheBehaviors(v *CacheBehaviors) *DistributionSummary {
	s.CacheBehaviors = v
	return s
}

// SetComment sets the Comment field's value.
func (s *DistributionSummary) SetComment(v string) *DistributionSummary {
	s.Comment = &v
	return s
}

// SetCustomErrorResponses sets the CustomErrorResponses field's value.
func (s *DistributionSummary) SetCustomErrorResponses(v *CustomErrorResponses) *DistributionSummary {
	s.CustomErrorResponses = v
	return s
}

// SetDefaultCacheBehavior sets the DefaultCacheBehavior field's value.
func (s *DistributionSummary) SetDefaultCacheBehavior(v *DefaultCacheBehavior) *DistributionSummary {
	s.DefaultCacheBehavior = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DistributionSummary) SetDomainName(v string) *DistributionSummary {
	s.DomainName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *DistributionSummary) SetEnabled(v bool) *DistributionSummary {
	s.Enabled = &v
	return s
}

// SetHttpVersion sets the HttpVersion field's value.
func (s *DistributionSummary) SetHttpVersion(v string) *DistributionSummary {
	s.HttpVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *DistributionSummary) SetId(v string) *DistributionSummary {
	s.Id = &v
	return s
}

// SetIsIPV6Enabled sets the IsIPV6Enabled field's value.
func (s *DistributionSummary) SetIsIPV6Enabled(v bool) *DistributionSummary {
	s.IsIPV6Enabled = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DistributionSummary) SetLastModifiedTime(v time.Time) *DistributionSummary {
	s.LastModifiedTime = &v
	return s
}

// SetOriginGroups sets the OriginGroups field's value.
func (s *DistributionSummary) SetOriginGroups(v *OriginGroups) *DistributionSummary {
	s.OriginGroups = v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *DistributionSummary) SetOrigins(v *Origins) *DistributionSummary {
	s.Origins = v
	return s
}

// SetPriceClass sets the PriceClass field's value.
func (s *DistributionSummary) SetPriceClass(v string) *DistributionSummary {
	s.PriceClass = &v
	return s
}

// SetRestrictions sets the Restrictions field's value.
func (s *DistributionSummary) SetRestrictions(v *Restrictions) *DistributionSummary {
	s.Restrictions = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DistributionSummary) SetStatus(v string) *DistributionSummary {
	s.Status = &v
	return s
}

// SetViewerCertificate sets the ViewerCertificate field's value.
func (s *DistributionSummary) SetViewerCertificate(v *ViewerCertificate) *DistributionSummary {
	s.ViewerCertificate = v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *DistributionSummary) SetWebACLId(v string) *DistributionSummary {
	s.WebACLId = &v
	return s
}

// Complex data type for field-level encryption profiles that includes all of
// the encryption entities.
type EncryptionEntities struct {
	_ struct{} `type:"structure"`

	// An array of field patterns in a field-level encryption content type-profile
	// mapping.
	Items []*EncryptionEntity `locationNameList:"EncryptionEntity" type:"list"`

	// Number of field pattern items in a field-level encryption content type-profile
	// mapping.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s EncryptionEntities) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionEntities) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionEntities) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionEntities"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *EncryptionEntities) SetItems(v []*EncryptionEntity) *EncryptionEntities {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *EncryptionEntities) SetQuantity(v int64) *EncryptionEntities {
	s.Quantity = &v
	return s
}

// Complex data type for field-level encryption profiles that includes the encryption
// key and field pattern specifications.
type EncryptionEntity struct {
	_ struct{} `type:"structure"`

	// Field patterns in a field-level encryption content type profile specify the
	// fields that you want to be encrypted. You can provide the full field name,
	// or any beginning characters followed by a wildcard (*). You can't overlap
	// field patterns. For example, you can't have both ABC* and AB*. Note that
	// field patterns are case-sensitive.
	//
	// FieldPatterns is a required field
	FieldPatterns *FieldPatterns `type:"structure" required:"true"`

	// The provider associated with the public key being used for encryption. This
	// value must also be provided with the private key for applications to be able
	// to decrypt data.
	//
	// ProviderId is a required field
	ProviderId *string `type:"string" required:"true"`

	// The public key associated with a set of field-level encryption patterns,
	// to be used when encrypting the fields that match the patterns.
	//
	// PublicKeyId is a required field
	PublicKeyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EncryptionEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionEntity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionEntity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionEntity"}
	if s.FieldPatterns == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldPatterns"))
	}
	if s.ProviderId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProviderId"))
	}
	if s.PublicKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyId"))
	}
	if s.FieldPatterns != nil {
		if err := s.FieldPatterns.Validate(); err != nil {
			invalidParams.AddNested("FieldPatterns", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldPatterns sets the FieldPatterns field's value.
func (s *EncryptionEntity) SetFieldPatterns(v *FieldPatterns) *EncryptionEntity {
	s.FieldPatterns = v
	return s
}

// SetProviderId sets the ProviderId field's value.
func (s *EncryptionEntity) SetProviderId(v string) *EncryptionEntity {
	s.ProviderId = &v
	return s
}

// SetPublicKeyId sets the PublicKeyId field's value.
func (s *EncryptionEntity) SetPublicKeyId(v string) *EncryptionEntity {
	s.PublicKeyId = &v
	return s
}

// A complex data type that includes the profile configurations and other options
// specified for field-level encryption.
type FieldLevelEncryption struct {
	_ struct{} `type:"structure"`

	// A complex data type that includes the profile configurations specified for
	// field-level encryption.
	//
	// FieldLevelEncryptionConfig is a required field
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig `type:"structure" required:"true"`

	// The configuration ID for a field-level encryption configuration which includes
	// a set of profiles that specify certain selected data fields to be encrypted
	// by specific public keys.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The last time the field-level encryption configuration was changed.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryption) GoString() string {
	return s.String()
}

// SetFieldLevelEncryptionConfig sets the FieldLevelEncryptionConfig field's value.
func (s *FieldLevelEncryption) SetFieldLevelEncryptionConfig(v *FieldLevelEncryptionConfig) *FieldLevelEncryption {
	s.FieldLevelEncryptionConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *FieldLevelEncryption) SetId(v string) *FieldLevelEncryption {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *FieldLevelEncryption) SetLastModifiedTime(v time.Time) *FieldLevelEncryption {
	s.LastModifiedTime = &v
	return s
}

// A complex data type that includes the profile configurations specified for
// field-level encryption.
type FieldLevelEncryptionConfig struct {
	_ struct{} `type:"structure"`

	// A unique number that ensures the request can't be replayed.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// An optional comment about the configuration.
	Comment *string `type:"string"`

	// A complex data type that specifies when to forward content if a content type
	// isn't recognized and profiles to use as by default in a request if a query
	// argument doesn't specify a profile to use.
	ContentTypeProfileConfig *ContentTypeProfileConfig `type:"structure"`

	// A complex data type that specifies when to forward content if a profile isn't
	// found and the profile that can be provided as a query argument in a request.
	QueryArgProfileConfig *QueryArgProfileConfig `type:"structure"`
}

// String returns the string representation
func (s FieldLevelEncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldLevelEncryptionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldLevelEncryptionConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.ContentTypeProfileConfig != nil {
		if err := s.ContentTypeProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("ContentTypeProfileConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.QueryArgProfileConfig != nil {
		if err := s.QueryArgProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("QueryArgProfileConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *FieldLevelEncryptionConfig) SetCallerReference(v string) *FieldLevelEncryptionConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *FieldLevelEncryptionConfig) SetComment(v string) *FieldLevelEncryptionConfig {
	s.Comment = &v
	return s
}

// SetContentTypeProfileConfig sets the ContentTypeProfileConfig field's value.
func (s *FieldLevelEncryptionConfig) SetContentTypeProfileConfig(v *ContentTypeProfileConfig) *FieldLevelEncryptionConfig {
	s.ContentTypeProfileConfig = v
	return s
}

// SetQueryArgProfileConfig sets the QueryArgProfileConfig field's value.
func (s *FieldLevelEncryptionConfig) SetQueryArgProfileConfig(v *QueryArgProfileConfig) *FieldLevelEncryptionConfig {
	s.QueryArgProfileConfig = v
	return s
}

// List of field-level encrpytion configurations.
type FieldLevelEncryptionList struct {
	_ struct{} `type:"structure"`

	// An array of field-level encryption items.
	Items []*FieldLevelEncryptionSummary `locationNameList:"FieldLevelEncryptionSummary" type:"list"`

	// The maximum number of elements you want in the response body.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your configurations where you left off.
	NextMarker *string `type:"string"`

	// The number of field-level encryption items.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionList) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *FieldLevelEncryptionList) SetItems(v []*FieldLevelEncryptionSummary) *FieldLevelEncryptionList {
	s.Items = v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *FieldLevelEncryptionList) SetMaxItems(v int64) *FieldLevelEncryptionList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *FieldLevelEncryptionList) SetNextMarker(v string) *FieldLevelEncryptionList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *FieldLevelEncryptionList) SetQuantity(v int64) *FieldLevelEncryptionList {
	s.Quantity = &v
	return s
}

// A complex data type for field-level encryption profiles.
type FieldLevelEncryptionProfile struct {
	_ struct{} `type:"structure"`

	// A complex data type that includes the profile name and the encryption entities
	// for the field-level encryption profile.
	//
	// FieldLevelEncryptionProfileConfig is a required field
	FieldLevelEncryptionProfileConfig *FieldLevelEncryptionProfileConfig `type:"structure" required:"true"`

	// The ID for a field-level encryption profile configuration which includes
	// a set of profiles that specify certain selected data fields to be encrypted
	// by specific public keys.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The last time the field-level encryption profile was updated.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionProfile) GoString() string {
	return s.String()
}

// SetFieldLevelEncryptionProfileConfig sets the FieldLevelEncryptionProfileConfig field's value.
func (s *FieldLevelEncryptionProfile) SetFieldLevelEncryptionProfileConfig(v *FieldLevelEncryptionProfileConfig) *FieldLevelEncryptionProfile {
	s.FieldLevelEncryptionProfileConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *FieldLevelEncryptionProfile) SetId(v string) *FieldLevelEncryptionProfile {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *FieldLevelEncryptionProfile) SetLastModifiedTime(v time.Time) *FieldLevelEncryptionProfile {
	s.LastModifiedTime = &v
	return s
}

// A complex data type of profiles for the field-level encryption.
type FieldLevelEncryptionProfileConfig struct {
	_ struct{} `type:"structure"`

	// A unique number that ensures that the request can't be replayed.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// An optional comment for the field-level encryption profile.
	Comment *string `type:"string"`

	// A complex data type of encryption entities for the field-level encryption
	// profile that include the public key ID, provider, and field patterns for
	// specifying which fields to encrypt with this key.
	//
	// EncryptionEntities is a required field
	EncryptionEntities *EncryptionEntities `type:"structure" required:"true"`

	// Profile name for the field-level encryption profile.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfileConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionProfileConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldLevelEncryptionProfileConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldLevelEncryptionProfileConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.EncryptionEntities == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionEntities"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.EncryptionEntities != nil {
		if err := s.EncryptionEntities.Validate(); err != nil {
			invalidParams.AddNested("EncryptionEntities", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *FieldLevelEncryptionProfileConfig) SetCallerReference(v string) *FieldLevelEncryptionProfileConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *FieldLevelEncryptionProfileConfig) SetComment(v string) *FieldLevelEncryptionProfileConfig {
	s.Comment = &v
	return s
}

// SetEncryptionEntities sets the EncryptionEntities field's value.
func (s *FieldLevelEncryptionProfileConfig) SetEncryptionEntities(v *EncryptionEntities) *FieldLevelEncryptionProfileConfig {
	s.EncryptionEntities = v
	return s
}

// SetName sets the Name field's value.
func (s *FieldLevelEncryptionProfileConfig) SetName(v string) *FieldLevelEncryptionProfileConfig {
	s.Name = &v
	return s
}

// List of field-level encryption profiles.
type FieldLevelEncryptionProfileList struct {
	_ struct{} `type:"structure"`

	// The field-level encryption profile items.
	Items []*FieldLevelEncryptionProfileSummary `locationNameList:"FieldLevelEncryptionProfileSummary" type:"list"`

	// The maximum number of field-level encryption profiles you want in the response
	// body.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your profiles where you left off.
	NextMarker *string `type:"string"`

	// The number of field-level encryption profiles.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfileList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionProfileList) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *FieldLevelEncryptionProfileList) SetItems(v []*FieldLevelEncryptionProfileSummary) *FieldLevelEncryptionProfileList {
	s.Items = v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *FieldLevelEncryptionProfileList) SetMaxItems(v int64) *FieldLevelEncryptionProfileList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *FieldLevelEncryptionProfileList) SetNextMarker(v string) *FieldLevelEncryptionProfileList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *FieldLevelEncryptionProfileList) SetQuantity(v int64) *FieldLevelEncryptionProfileList {
	s.Quantity = &v
	return s
}

// The field-level encryption profile summary.
type FieldLevelEncryptionProfileSummary struct {
	_ struct{} `type:"structure"`

	// An optional comment for the field-level encryption profile summary.
	Comment *string `type:"string"`

	// A complex data type of encryption entities for the field-level encryption
	// profile that include the public key ID, provider, and field patterns for
	// specifying which fields to encrypt with this key.
	//
	// EncryptionEntities is a required field
	EncryptionEntities *EncryptionEntities `type:"structure" required:"true"`

	// ID for the field-level encryption profile summary.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The time when the the field-level encryption profile summary was last updated.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// Name for the field-level encryption profile summary.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FieldLevelEncryptionProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionProfileSummary) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *FieldLevelEncryptionProfileSummary) SetComment(v string) *FieldLevelEncryptionProfileSummary {
	s.Comment = &v
	return s
}

// SetEncryptionEntities sets the EncryptionEntities field's value.
func (s *FieldLevelEncryptionProfileSummary) SetEncryptionEntities(v *EncryptionEntities) *FieldLevelEncryptionProfileSummary {
	s.EncryptionEntities = v
	return s
}

// SetId sets the Id field's value.
func (s *FieldLevelEncryptionProfileSummary) SetId(v string) *FieldLevelEncryptionProfileSummary {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *FieldLevelEncryptionProfileSummary) SetLastModifiedTime(v time.Time) *FieldLevelEncryptionProfileSummary {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *FieldLevelEncryptionProfileSummary) SetName(v string) *FieldLevelEncryptionProfileSummary {
	s.Name = &v
	return s
}

// A summary of a field-level encryption item.
type FieldLevelEncryptionSummary struct {
	_ struct{} `type:"structure"`

	// An optional comment about the field-level encryption item.
	Comment *string `type:"string"`

	// A summary of a content type-profile mapping.
	ContentTypeProfileConfig *ContentTypeProfileConfig `type:"structure"`

	// The unique ID of a field-level encryption item.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The last time that the summary of field-level encryption items was modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// A summary of a query argument-profile mapping.
	QueryArgProfileConfig *QueryArgProfileConfig `type:"structure"`
}

// String returns the string representation
func (s FieldLevelEncryptionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldLevelEncryptionSummary) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *FieldLevelEncryptionSummary) SetComment(v string) *FieldLevelEncryptionSummary {
	s.Comment = &v
	return s
}

// SetContentTypeProfileConfig sets the ContentTypeProfileConfig field's value.
func (s *FieldLevelEncryptionSummary) SetContentTypeProfileConfig(v *ContentTypeProfileConfig) *FieldLevelEncryptionSummary {
	s.ContentTypeProfileConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *FieldLevelEncryptionSummary) SetId(v string) *FieldLevelEncryptionSummary {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *FieldLevelEncryptionSummary) SetLastModifiedTime(v time.Time) *FieldLevelEncryptionSummary {
	s.LastModifiedTime = &v
	return s
}

// SetQueryArgProfileConfig sets the QueryArgProfileConfig field's value.
func (s *FieldLevelEncryptionSummary) SetQueryArgProfileConfig(v *QueryArgProfileConfig) *FieldLevelEncryptionSummary {
	s.QueryArgProfileConfig = v
	return s
}

// A complex data type that includes the field patterns to match for field-level
// encryption.
type FieldPatterns struct {
	_ struct{} `type:"structure"`

	// An array of the field-level encryption field patterns.
	Items []*string `locationNameList:"FieldPattern" type:"list"`

	// The number of field-level encryption field patterns.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s FieldPatterns) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldPatterns) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldPatterns) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldPatterns"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *FieldPatterns) SetItems(v []*string) *FieldPatterns {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *FieldPatterns) SetQuantity(v int64) *FieldPatterns {
	s.Quantity = &v
	return s
}

// A complex type that specifies how CloudFront handles query strings, cookies,
// and HTTP headers.
type ForwardedValues struct {
	_ struct{} `type:"structure"`

	// A complex type that specifies whether you want CloudFront to forward cookies
	// to the origin and, if so, which ones. For more information about forwarding
	// cookies to the origin, see How CloudFront Forwards, Caches, and Logs Cookies
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// Cookies is a required field
	Cookies *CookiePreference `type:"structure" required:"true"`

	// A complex type that specifies the Headers, if any, that you want CloudFront
	// to forward to the origin for this cache behavior (whitelisted headers). For
	// the headers that you specify, CloudFront also caches separate versions of
	// a specified object that is based on the header values in viewer requests.
	//
	// For more information, see Caching Content Based on Request Headers (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html)
	// in the Amazon CloudFront Developer Guide.
	Headers *Headers `type:"structure"`

	// Indicates whether you want CloudFront to forward query strings to the origin
	// that is associated with this cache behavior and cache based on the query
	// string parameters. CloudFront behavior depends on the value of QueryString
	// and on the values that you specify for QueryStringCacheKeys, if any:
	//
	// If you specify true for QueryString and you don't specify any values for
	// QueryStringCacheKeys, CloudFront forwards all query string parameters to
	// the origin and caches based on all query string parameters. Depending on
	// how many query string parameters and values you have, this can adversely
	// affect performance because CloudFront must forward more requests to the origin.
	//
	// If you specify true for QueryString and you specify one or more values for
	// QueryStringCacheKeys, CloudFront forwards all query string parameters to
	// the origin, but it only caches based on the query string parameters that
	// you specify.
	//
	// If you specify false for QueryString, CloudFront doesn't forward any query
	// string parameters to the origin, and doesn't cache based on query string
	// parameters.
	//
	// For more information, see Configuring CloudFront to Cache Based on Query
	// String Parameters (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// QueryString is a required field
	QueryString *bool `type:"boolean" required:"true"`

	// A complex type that contains information about the query string parameters
	// that you want CloudFront to use for caching for this cache behavior.
	QueryStringCacheKeys *QueryStringCacheKeys `type:"structure"`
}

// String returns the string representation
func (s ForwardedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForwardedValues) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForwardedValues) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ForwardedValues"}
	if s.Cookies == nil {
		invalidParams.Add(request.NewErrParamRequired("Cookies"))
	}
	if s.QueryString == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryString"))
	}
	if s.Cookies != nil {
		if err := s.Cookies.Validate(); err != nil {
			invalidParams.AddNested("Cookies", err.(request.ErrInvalidParams))
		}
	}
	if s.Headers != nil {
		if err := s.Headers.Validate(); err != nil {
			invalidParams.AddNested("Headers", err.(request.ErrInvalidParams))
		}
	}
	if s.QueryStringCacheKeys != nil {
		if err := s.QueryStringCacheKeys.Validate(); err != nil {
			invalidParams.AddNested("QueryStringCacheKeys", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCookies sets the Cookies field's value.
func (s *ForwardedValues) SetCookies(v *CookiePreference) *ForwardedValues {
	s.Cookies = v
	return s
}

// SetHeaders sets the Headers field's value.
func (s *ForwardedValues) SetHeaders(v *Headers) *ForwardedValues {
	s.Headers = v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *ForwardedValues) SetQueryString(v bool) *ForwardedValues {
	s.QueryString = &v
	return s
}

// SetQueryStringCacheKeys sets the QueryStringCacheKeys field's value.
func (s *ForwardedValues) SetQueryStringCacheKeys(v *QueryStringCacheKeys) *ForwardedValues {
	s.QueryStringCacheKeys = v
	return s
}

// A complex type that controls the countries in which your content is distributed.
// CloudFront determines the location of your users using MaxMind GeoIP databases.
type GeoRestriction struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a Location element for each country in which
	// you want CloudFront either to distribute your content (whitelist) or not
	// distribute your content (blacklist).
	//
	// The Location element is a two-letter, uppercase country code for a country
	// that you want to include in your blacklist or whitelist. Include one Location
	// element for each country.
	//
	// CloudFront and MaxMind both use ISO 3166 country codes. For the current list
	// of countries and the corresponding codes, see ISO 3166-1-alpha-2 code on
	// the International Organization for Standardization website. You can also
	// refer to the country list on the CloudFront console, which includes both
	// country names and codes.
	Items []*string `locationNameList:"Location" type:"list"`

	// When geo restriction is enabled, this is the number of countries in your
	// whitelist or blacklist. Otherwise, when it is not enabled, Quantity is 0,
	// and you can omit Items.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`

	// The method that you want to use to restrict distribution of your content
	// by country:
	//
	//    * none: No geo restriction is enabled, meaning access to content is not
	//    restricted by client geo location.
	//
	//    * blacklist: The Location elements specify the countries in which you
	//    don't want CloudFront to distribute your content.
	//
	//    * whitelist: The Location elements specify the countries in which you
	//    want CloudFront to distribute your content.
	//
	// RestrictionType is a required field
	RestrictionType *string `type:"string" required:"true" enum:"GeoRestrictionType"`
}

// String returns the string representation
func (s GeoRestriction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoRestriction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoRestriction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeoRestriction"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.RestrictionType == nil {
		invalidParams.Add(request.NewErrParamRequired("RestrictionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *GeoRestriction) SetItems(v []*string) *GeoRestriction {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *GeoRestriction) SetQuantity(v int64) *GeoRestriction {
	s.Quantity = &v
	return s
}

// SetRestrictionType sets the RestrictionType field's value.
func (s *GeoRestriction) SetRestrictionType(v string) *GeoRestriction {
	s.RestrictionType = &v
	return s
}

// The origin access identity's configuration information. For more information,
// see CloudFrontOriginAccessIdentityConfig (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html).
type GetCloudFrontOriginAccessIdentityConfigInput struct {
	_ struct{} `locationName:"GetCloudFrontOriginAccessIdentityConfigRequest" type:"structure"`

	// The identity's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCloudFrontOriginAccessIdentityConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCloudFrontOriginAccessIdentityConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetCloudFrontOriginAccessIdentityConfigInput) SetId(v string) *GetCloudFrontOriginAccessIdentityConfigInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetCloudFrontOriginAccessIdentityConfigOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentityConfig"`

	// The origin access identity's configuration information.
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigOutput) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentityConfig sets the CloudFrontOriginAccessIdentityConfig field's value.
func (s *GetCloudFrontOriginAccessIdentityConfigOutput) SetCloudFrontOriginAccessIdentityConfig(v *OriginAccessIdentityConfig) *GetCloudFrontOriginAccessIdentityConfigOutput {
	s.CloudFrontOriginAccessIdentityConfig = v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetCloudFrontOriginAccessIdentityConfigOutput) SetETag(v string) *GetCloudFrontOriginAccessIdentityConfigOutput {
	s.ETag = &v
	return s
}

// The request to get an origin access identity's information.
type GetCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `locationName:"GetCloudFrontOriginAccessIdentityRequest" type:"structure"`

	// The identity's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCloudFrontOriginAccessIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCloudFrontOriginAccessIdentityInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetCloudFrontOriginAccessIdentityInput) SetId(v string) *GetCloudFrontOriginAccessIdentityInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentity"`

	// The origin access identity's information.
	CloudFrontOriginAccessIdentity *OriginAccessIdentity `type:"structure"`

	// The current version of the origin access identity's information. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentity sets the CloudFrontOriginAccessIdentity field's value.
func (s *GetCloudFrontOriginAccessIdentityOutput) SetCloudFrontOriginAccessIdentity(v *OriginAccessIdentity) *GetCloudFrontOriginAccessIdentityOutput {
	s.CloudFrontOriginAccessIdentity = v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetCloudFrontOriginAccessIdentityOutput) SetETag(v string) *GetCloudFrontOriginAccessIdentityOutput {
	s.ETag = &v
	return s
}

// The request to get a distribution configuration.
type GetDistributionConfigInput struct {
	_ struct{} `locationName:"GetDistributionConfigRequest" type:"structure"`

	// The distribution's ID. If the ID is empty, an empty distribution configuration
	// is returned.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDistributionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDistributionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDistributionConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetDistributionConfigInput) SetId(v string) *GetDistributionConfigInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetDistributionConfigOutput struct {
	_ struct{} `type:"structure" payload:"DistributionConfig"`

	// The distribution's configuration information.
	DistributionConfig *DistributionConfig `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetDistributionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionConfigOutput) GoString() string {
	return s.String()
}

// SetDistributionConfig sets the DistributionConfig field's value.
func (s *GetDistributionConfigOutput) SetDistributionConfig(v *DistributionConfig) *GetDistributionConfigOutput {
	s.DistributionConfig = v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetDistributionConfigOutput) SetETag(v string) *GetDistributionConfigOutput {
	s.ETag = &v
	return s
}

// The request to get a distribution's information.
type GetDistributionInput struct {
	_ struct{} `locationName:"GetDistributionRequest" type:"structure"`

	// The distribution's ID. If the ID is empty, an empty distribution configuration
	// is returned.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDistributionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetDistributionInput) SetId(v string) *GetDistributionInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetDistributionOutput struct {
	_ struct{} `type:"structure" payload:"Distribution"`

	// The distribution's information.
	Distribution *Distribution `type:"structure"`

	// The current version of the distribution's information. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionOutput) GoString() string {
	return s.String()
}

// SetDistribution sets the Distribution field's value.
func (s *GetDistributionOutput) SetDistribution(v *Distribution) *GetDistributionOutput {
	s.Distribution = v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetDistributionOutput) SetETag(v string) *GetDistributionOutput {
	s.ETag = &v
	return s
}

type GetFieldLevelEncryptionConfigInput struct {
	_ struct{} `locationName:"GetFieldLevelEncryptionConfigRequest" type:"structure"`

	// Request the ID for the field-level encryption configuration information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFieldLevelEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFieldLevelEncryptionConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetFieldLevelEncryptionConfigInput) SetId(v string) *GetFieldLevelEncryptionConfigInput {
	s.Id = &v
	return s
}

type GetFieldLevelEncryptionConfigOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionConfig"`

	// The current version of the field level encryption configuration. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the field-level encryption configuration information.
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig `type:"structure"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetFieldLevelEncryptionConfigOutput) SetETag(v string) *GetFieldLevelEncryptionConfigOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryptionConfig sets the FieldLevelEncryptionConfig field's value.
func (s *GetFieldLevelEncryptionConfigOutput) SetFieldLevelEncryptionConfig(v *FieldLevelEncryptionConfig) *GetFieldLevelEncryptionConfigOutput {
	s.FieldLevelEncryptionConfig = v
	return s
}

type GetFieldLevelEncryptionInput struct {
	_ struct{} `locationName:"GetFieldLevelEncryptionRequest" type:"structure"`

	// Request the ID for the field-level encryption configuration information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFieldLevelEncryptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFieldLevelEncryptionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetFieldLevelEncryptionInput) SetId(v string) *GetFieldLevelEncryptionInput {
	s.Id = &v
	return s
}

type GetFieldLevelEncryptionOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryption"`

	// The current version of the field level encryption configuration. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the field-level encryption configuration information.
	FieldLevelEncryption *FieldLevelEncryption `type:"structure"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetFieldLevelEncryptionOutput) SetETag(v string) *GetFieldLevelEncryptionOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryption sets the FieldLevelEncryption field's value.
func (s *GetFieldLevelEncryptionOutput) SetFieldLevelEncryption(v *FieldLevelEncryption) *GetFieldLevelEncryptionOutput {
	s.FieldLevelEncryption = v
	return s
}

type GetFieldLevelEncryptionProfileConfigInput struct {
	_ struct{} `locationName:"GetFieldLevelEncryptionProfileConfigRequest" type:"structure"`

	// Get the ID for the field-level encryption profile configuration information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionProfileConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionProfileConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFieldLevelEncryptionProfileConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFieldLevelEncryptionProfileConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetFieldLevelEncryptionProfileConfigInput) SetId(v string) *GetFieldLevelEncryptionProfileConfigInput {
	s.Id = &v
	return s
}

type GetFieldLevelEncryptionProfileConfigOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionProfileConfig"`

	// The current version of the field-level encryption profile configuration result.
	// For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the field-level encryption profile configuration information.
	FieldLevelEncryptionProfileConfig *FieldLevelEncryptionProfileConfig `type:"structure"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionProfileConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionProfileConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetFieldLevelEncryptionProfileConfigOutput) SetETag(v string) *GetFieldLevelEncryptionProfileConfigOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryptionProfileConfig sets the FieldLevelEncryptionProfileConfig field's value.
func (s *GetFieldLevelEncryptionProfileConfigOutput) SetFieldLevelEncryptionProfileConfig(v *FieldLevelEncryptionProfileConfig) *GetFieldLevelEncryptionProfileConfigOutput {
	s.FieldLevelEncryptionProfileConfig = v
	return s
}

type GetFieldLevelEncryptionProfileInput struct {
	_ struct{} `locationName:"GetFieldLevelEncryptionProfileRequest" type:"structure"`

	// Get the ID for the field-level encryption profile information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFieldLevelEncryptionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFieldLevelEncryptionProfileInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetFieldLevelEncryptionProfileInput) SetId(v string) *GetFieldLevelEncryptionProfileInput {
	s.Id = &v
	return s
}

type GetFieldLevelEncryptionProfileOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionProfile"`

	// The current version of the field level encryption profile. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the field-level encryption profile information.
	FieldLevelEncryptionProfile *FieldLevelEncryptionProfile `type:"structure"`
}

// String returns the string representation
func (s GetFieldLevelEncryptionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFieldLevelEncryptionProfileOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetFieldLevelEncryptionProfileOutput) SetETag(v string) *GetFieldLevelEncryptionProfileOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryptionProfile sets the FieldLevelEncryptionProfile field's value.
func (s *GetFieldLevelEncryptionProfileOutput) SetFieldLevelEncryptionProfile(v *FieldLevelEncryptionProfile) *GetFieldLevelEncryptionProfileOutput {
	s.FieldLevelEncryptionProfile = v
	return s
}

// The request to get an invalidation's information.
type GetInvalidationInput struct {
	_ struct{} `locationName:"GetInvalidationRequest" type:"structure"`

	// The distribution's ID.
	//
	// DistributionId is a required field
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`

	// The identifier for the invalidation request, for example, IDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInvalidationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvalidationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInvalidationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInvalidationInput"}
	if s.DistributionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionId"))
	}
	if s.DistributionId != nil && len(*s.DistributionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DistributionId", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionId sets the DistributionId field's value.
func (s *GetInvalidationInput) SetDistributionId(v string) *GetInvalidationInput {
	s.DistributionId = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetInvalidationInput) SetId(v string) *GetInvalidationInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetInvalidationOutput struct {
	_ struct{} `type:"structure" payload:"Invalidation"`

	// The invalidation's information. For more information, see Invalidation Complex
	// Type (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/InvalidationDatatype.html).
	Invalidation *Invalidation `type:"structure"`
}

// String returns the string representation
func (s GetInvalidationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvalidationOutput) GoString() string {
	return s.String()
}

// SetInvalidation sets the Invalidation field's value.
func (s *GetInvalidationOutput) SetInvalidation(v *Invalidation) *GetInvalidationOutput {
	s.Invalidation = v
	return s
}

type GetPublicKeyConfigInput struct {
	_ struct{} `locationName:"GetPublicKeyConfigRequest" type:"structure"`

	// Request the ID for the public key configuration.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPublicKeyConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicKeyConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicKeyConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicKeyConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetPublicKeyConfigInput) SetId(v string) *GetPublicKeyConfigInput {
	s.Id = &v
	return s
}

type GetPublicKeyConfigOutput struct {
	_ struct{} `type:"structure" payload:"PublicKeyConfig"`

	// The current version of the public key configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the result for the public key configuration.
	PublicKeyConfig *PublicKeyConfig `type:"structure"`
}

// String returns the string representation
func (s GetPublicKeyConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicKeyConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetPublicKeyConfigOutput) SetETag(v string) *GetPublicKeyConfigOutput {
	s.ETag = &v
	return s
}

// SetPublicKeyConfig sets the PublicKeyConfig field's value.
func (s *GetPublicKeyConfigOutput) SetPublicKeyConfig(v *PublicKeyConfig) *GetPublicKeyConfigOutput {
	s.PublicKeyConfig = v
	return s
}

type GetPublicKeyInput struct {
	_ struct{} `locationName:"GetPublicKeyRequest" type:"structure"`

	// Request the ID for the public key.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPublicKeyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetPublicKeyInput) SetId(v string) *GetPublicKeyInput {
	s.Id = &v
	return s
}

type GetPublicKeyOutput struct {
	_ struct{} `type:"structure" payload:"PublicKey"`

	// The current version of the public key. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the public key.
	PublicKey *PublicKey `type:"structure"`
}

// String returns the string representation
func (s GetPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPublicKeyOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetPublicKeyOutput) SetETag(v string) *GetPublicKeyOutput {
	s.ETag = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *GetPublicKeyOutput) SetPublicKey(v *PublicKey) *GetPublicKeyOutput {
	s.PublicKey = v
	return s
}

// To request to get a streaming distribution configuration.
type GetStreamingDistributionConfigInput struct {
	_ struct{} `locationName:"GetStreamingDistributionConfigRequest" type:"structure"`

	// The streaming distribution's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamingDistributionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamingDistributionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamingDistributionConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetStreamingDistributionConfigInput) SetId(v string) *GetStreamingDistributionConfigInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetStreamingDistributionConfigOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistributionConfig"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The streaming distribution's configuration information.
	StreamingDistributionConfig *StreamingDistributionConfig `type:"structure"`
}

// String returns the string representation
func (s GetStreamingDistributionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetStreamingDistributionConfigOutput) SetETag(v string) *GetStreamingDistributionConfigOutput {
	s.ETag = &v
	return s
}

// SetStreamingDistributionConfig sets the StreamingDistributionConfig field's value.
func (s *GetStreamingDistributionConfigOutput) SetStreamingDistributionConfig(v *StreamingDistributionConfig) *GetStreamingDistributionConfigOutput {
	s.StreamingDistributionConfig = v
	return s
}

// The request to get a streaming distribution's information.
type GetStreamingDistributionInput struct {
	_ struct{} `locationName:"GetStreamingDistributionRequest" type:"structure"`

	// The streaming distribution's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamingDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStreamingDistributionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetStreamingDistributionInput) SetId(v string) *GetStreamingDistributionInput {
	s.Id = &v
	return s
}

// The returned result of the corresponding request.
type GetStreamingDistributionOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the streaming distribution's information. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s GetStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *GetStreamingDistributionOutput) SetETag(v string) *GetStreamingDistributionOutput {
	s.ETag = &v
	return s
}

// SetStreamingDistribution sets the StreamingDistribution field's value.
func (s *GetStreamingDistributionOutput) SetStreamingDistribution(v *StreamingDistribution) *GetStreamingDistributionOutput {
	s.StreamingDistribution = v
	return s
}

// A complex type that specifies the request headers, if any, that you want
// CloudFront to base caching on for this cache behavior.
//
// For the headers that you specify, CloudFront caches separate versions of
// a specified object based on the header values in viewer requests. For example,
// suppose viewer requests for logo.jpg contain a custom product header that
// has a value of either acme or apex, and you configure CloudFront to cache
// your content based on values in the product header. CloudFront forwards the
// product header to the origin and caches the response from the origin once
// for each header value. For more information about caching based on header
// values, see How CloudFront Forwards and Caches Headers (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html)
// in the Amazon CloudFront Developer Guide.
type Headers struct {
	_ struct{} `type:"structure"`

	// A list that contains one Name element for each header that you want CloudFront
	// to use for caching in this cache behavior. If Quantity is 0, omit Items.
	Items []*string `locationNameList:"Name" type:"list"`

	// The number of different headers that you want CloudFront to base caching
	// on for this cache behavior. You can configure each cache behavior in a web
	// distribution to do one of the following:
	//
	//    * Forward all headers to your origin: Specify 1 for Quantity and * for
	//    Name. CloudFront doesn't cache the objects that are associated with this
	//    cache behavior. Instead, CloudFront sends every request to the origin.
	//
	//    * Forward a whitelist of headers you specify: Specify the number of headers
	//    that you want CloudFront to base caching on. Then specify the header names
	//    in Name elements. CloudFront caches your objects based on the values in
	//    the specified headers.
	//
	//    * Forward only the default headers: Specify 0 for Quantity and omit Items.
	//    In this configuration, CloudFront doesn't cache based on the values in
	//    the request headers.
	//
	// Regardless of which option you choose, CloudFront forwards headers to your
	// origin based on whether the origin is an S3 bucket or a custom origin. See
	// the following documentation:
	//
	//    * S3 bucket: See HTTP Request Headers That CloudFront Removes or Updates
	//    (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorS3Origin.html#request-s3-removed-headers)
	//
	//    * Custom origin: See HTTP Request Headers and CloudFront Behavior (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/RequestAndResponseBehaviorCustomOrigin.html#request-custom-headers-behavior)
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Headers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Headers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Headers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Headers"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *Headers) SetItems(v []*string) *Headers {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *Headers) SetQuantity(v int64) *Headers {
	s.Quantity = &v
	return s
}

// An invalidation.
type Invalidation struct {
	_ struct{} `type:"structure"`

	// The date and time the invalidation request was first made.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" required:"true"`

	// The identifier for the invalidation request. For example: IDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The current invalidation information for the batch request.
	//
	// InvalidationBatch is a required field
	InvalidationBatch *InvalidationBatch `type:"structure" required:"true"`

	// The status of the invalidation request. When the invalidation batch is finished,
	// the status is Completed.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Invalidation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invalidation) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *Invalidation) SetCreateTime(v time.Time) *Invalidation {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *Invalidation) SetId(v string) *Invalidation {
	s.Id = &v
	return s
}

// SetInvalidationBatch sets the InvalidationBatch field's value.
func (s *Invalidation) SetInvalidationBatch(v *InvalidationBatch) *Invalidation {
	s.InvalidationBatch = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Invalidation) SetStatus(v string) *Invalidation {
	s.Status = &v
	return s
}

// An invalidation batch.
type InvalidationBatch struct {
	_ struct{} `type:"structure"`

	// A value that you specify to uniquely identify an invalidation request. CloudFront
	// uses the value to prevent you from accidentally resubmitting an identical
	// request. Whenever you create a new invalidation request, you must specify
	// a new value for CallerReference and change other values in the request as
	// applicable. One way to ensure that the value of CallerReference is unique
	// is to use a timestamp, for example, 20120301090000.
	//
	// If you make a second invalidation request with the same value for CallerReference,
	// and if the rest of the request is the same, CloudFront doesn't create a new
	// invalidation request. Instead, CloudFront returns information about the invalidation
	// request that you previously created with the same CallerReference.
	//
	// If CallerReference is a value you already sent in a previous invalidation
	// batch request but the content of any Path is different from the original
	// request, CloudFront returns an InvalidationBatchAlreadyExists error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// A complex type that contains information about the objects that you want
	// to invalidate. For more information, see Specifying the Objects to Invalidate
	// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects)
	// in the Amazon CloudFront Developer Guide.
	//
	// Paths is a required field
	Paths *Paths `type:"structure" required:"true"`
}

// String returns the string representation
func (s InvalidationBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidationBatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvalidationBatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvalidationBatch"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.Paths == nil {
		invalidParams.Add(request.NewErrParamRequired("Paths"))
	}
	if s.Paths != nil {
		if err := s.Paths.Validate(); err != nil {
			invalidParams.AddNested("Paths", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *InvalidationBatch) SetCallerReference(v string) *InvalidationBatch {
	s.CallerReference = &v
	return s
}

// SetPaths sets the Paths field's value.
func (s *InvalidationBatch) SetPaths(v *Paths) *InvalidationBatch {
	s.Paths = v
	return s
}

// The InvalidationList complex type describes the list of invalidation objects.
// For more information about invalidation, see Invalidating Objects (Web Distributions
// Only) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html)
// in the Amazon CloudFront Developer Guide.
type InvalidationList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more invalidation batch requests remain to
	// be listed. If your results were truncated, you can make a follow-up pagination
	// request using the Marker request parameter to retrieve more invalidation
	// batches in the list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one InvalidationSummary element for each invalidation
	// batch created by the current AWS account.
	Items []*InvalidationSummary `locationNameList:"InvalidationSummary" type:"list"`

	// The value that you provided for the Marker request parameter.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value that you provided for the MaxItems request parameter.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value that
	// you can use for the Marker request parameter to continue listing your invalidation
	// batches where they left off.
	NextMarker *string `type:"string"`

	// The number of invalidation batches that were created by the current AWS account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s InvalidationList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidationList) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *InvalidationList) SetIsTruncated(v bool) *InvalidationList {
	s.IsTruncated = &v
	return s
}

// SetItems sets the Items field's value.
func (s *InvalidationList) SetItems(v []*InvalidationSummary) *InvalidationList {
	s.Items = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *InvalidationList) SetMarker(v string) *InvalidationList {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *InvalidationList) SetMaxItems(v int64) *InvalidationList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *InvalidationList) SetNextMarker(v string) *InvalidationList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *InvalidationList) SetQuantity(v int64) *InvalidationList {
	s.Quantity = &v
	return s
}

// A summary of an invalidation request.
type InvalidationSummary struct {
	_ struct{} `type:"structure"`

	// The time that an invalidation request was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" required:"true"`

	// The unique ID for an invalidation request.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The status of an invalidation request.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InvalidationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidationSummary) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *InvalidationSummary) SetCreateTime(v time.Time) *InvalidationSummary {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *InvalidationSummary) SetId(v string) *InvalidationSummary {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InvalidationSummary) SetStatus(v string) *InvalidationSummary {
	s.Status = &v
	return s
}

// A complex type that lists the active CloudFront key pairs, if any, that are
// associated with AwsAccountNumber.
//
// For more information, see ActiveTrustedSigners (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ActiveTrustedSigners.html).
type KeyPairIds struct {
	_ struct{} `type:"structure"`

	// A complex type that lists the active CloudFront key pairs, if any, that are
	// associated with AwsAccountNumber.
	//
	// For more information, see ActiveTrustedSigners (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ActiveTrustedSigners.html).
	Items []*string `locationNameList:"KeyPairId" type:"list"`

	// The number of active CloudFront key pairs for AwsAccountNumber.
	//
	// For more information, see ActiveTrustedSigners (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ActiveTrustedSigners.html).
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s KeyPairIds) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPairIds) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *KeyPairIds) SetItems(v []*string) *KeyPairIds {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *KeyPairIds) SetQuantity(v int64) *KeyPairIds {
	s.Quantity = &v
	return s
}

// A complex type that contains a Lambda function association.
type LambdaFunctionAssociation struct {
	_ struct{} `type:"structure"`

	// Specifies the event type that triggers a Lambda function invocation. You
	// can specify the following values:
	//
	//    * viewer-request: The function executes when CloudFront receives a request
	//    from a viewer and before it checks to see whether the requested object
	//    is in the edge cache.
	//
	//    * origin-request: The function executes only when CloudFront forwards
	//    a request to your origin. When the requested object is in the edge cache,
	//    the function doesn't execute.
	//
	//    * origin-response: The function executes after CloudFront receives a response
	//    from the origin and before it caches the object in the response. When
	//    the requested object is in the edge cache, the function doesn't execute.
	//
	//    * viewer-response: The function executes before CloudFront returns the
	//    requested object to the viewer. The function executes regardless of whether
	//    the object was already in the edge cache. If the origin returns an HTTP
	//    status code other than HTTP 200 (OK), the function doesn't execute.
	//
	// EventType is a required field
	EventType *string `type:"string" required:"true" enum:"EventType"`

	// A flag that allows a Lambda function to have read access to the body content.
	// For more information, see Accessing the Request Body by Choosing the Include
	// Body Option (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html)
	// in the Amazon CloudFront Developer Guide.
	IncludeBody *bool `type:"boolean"`

	// The ARN of the Lambda function. You must specify the ARN of a function version;
	// you can't specify a Lambda alias or $LATEST.
	//
	// LambdaFunctionARN is a required field
	LambdaFunctionARN *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionAssociation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionAssociation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaFunctionAssociation"}
	if s.EventType == nil {
		invalidParams.Add(request.NewErrParamRequired("EventType"))
	}
	if s.LambdaFunctionARN == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaFunctionARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventType sets the EventType field's value.
func (s *LambdaFunctionAssociation) SetEventType(v string) *LambdaFunctionAssociation {
	s.EventType = &v
	return s
}

// SetIncludeBody sets the IncludeBody field's value.
func (s *LambdaFunctionAssociation) SetIncludeBody(v bool) *LambdaFunctionAssociation {
	s.IncludeBody = &v
	return s
}

// SetLambdaFunctionARN sets the LambdaFunctionARN field's value.
func (s *LambdaFunctionAssociation) SetLambdaFunctionARN(v string) *LambdaFunctionAssociation {
	s.LambdaFunctionARN = &v
	return s
}

// A complex type that specifies a list of Lambda functions associations for
// a cache behavior.
//
// If you want to invoke one or more Lambda functions triggered by requests
// that match the PathPattern of the cache behavior, specify the applicable
// values for Quantity and Items. Note that there can be up to 4 LambdaFunctionAssociation
// items in this list (one for each possible value of EventType) and each EventType
// can be associated with the Lambda function only once.
//
// If you don't want to invoke any Lambda functions for the requests that match
// PathPattern, specify 0 for Quantity and omit Items.
type LambdaFunctionAssociations struct {
	_ struct{} `type:"structure"`

	// Optional: A complex type that contains LambdaFunctionAssociation items for
	// this cache behavior. If Quantity is 0, you can omit Items.
	Items []*LambdaFunctionAssociation `locationNameList:"LambdaFunctionAssociation" type:"list"`

	// The number of Lambda function associations for this cache behavior.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionAssociations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionAssociations) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionAssociations) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaFunctionAssociations"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *LambdaFunctionAssociations) SetItems(v []*LambdaFunctionAssociation) *LambdaFunctionAssociations {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *LambdaFunctionAssociations) SetQuantity(v int64) *LambdaFunctionAssociations {
	s.Quantity = &v
	return s
}

// The request to list origin access identities.
type ListCloudFrontOriginAccessIdentitiesInput struct {
	_ struct{} `locationName:"ListCloudFrontOriginAccessIdentitiesRequest" type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of origin access identities. The results include identities in the list that
	// occur after the marker. To get the next page of results, set the Marker to
	// the value of the NextMarker from the current page's response (which is also
	// the ID of the last identity on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of origin access identities you want in the response body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListCloudFrontOriginAccessIdentitiesInput) SetMarker(v string) *ListCloudFrontOriginAccessIdentitiesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListCloudFrontOriginAccessIdentitiesInput) SetMaxItems(v int64) *ListCloudFrontOriginAccessIdentitiesInput {
	s.MaxItems = &v
	return s
}

// The returned result of the corresponding request.
type ListCloudFrontOriginAccessIdentitiesOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentityList"`

	// The CloudFrontOriginAccessIdentityList type.
	CloudFrontOriginAccessIdentityList *OriginAccessIdentityList `type:"structure"`
}

// String returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesOutput) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentityList sets the CloudFrontOriginAccessIdentityList field's value.
func (s *ListCloudFrontOriginAccessIdentitiesOutput) SetCloudFrontOriginAccessIdentityList(v *OriginAccessIdentityList) *ListCloudFrontOriginAccessIdentitiesOutput {
	s.CloudFrontOriginAccessIdentityList = v
	return s
}

// The request to list distributions that are associated with a specified AWS
// WAF web ACL.
type ListDistributionsByWebACLIdInput struct {
	_ struct{} `locationName:"ListDistributionsByWebACLIdRequest" type:"structure"`

	// Use Marker and MaxItems to control pagination of results. If you have more
	// than MaxItems distributions that satisfy the request, the response includes
	// a NextMarker element. To get the next page of results, submit another request.
	// For the value of Marker, specify the value of NextMarker from the last response.
	// (For the first request, omit Marker.)
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of distributions that you want CloudFront to return in
	// the response body. The maximum and default values are both 100.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`

	// The ID of the AWS WAF web ACL that you want to list the associated distributions.
	// If you specify "null" for the ID, the request returns a list of the distributions
	// that aren't associated with a web ACL.
	//
	// WebACLId is a required field
	WebACLId *string `location:"uri" locationName:"WebACLId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListDistributionsByWebACLIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByWebACLIdInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDistributionsByWebACLIdInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDistributionsByWebACLIdInput"}
	if s.WebACLId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListDistributionsByWebACLIdInput) SetMarker(v string) *ListDistributionsByWebACLIdInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListDistributionsByWebACLIdInput) SetMaxItems(v int64) *ListDistributionsByWebACLIdInput {
	s.MaxItems = &v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *ListDistributionsByWebACLIdInput) SetWebACLId(v string) *ListDistributionsByWebACLIdInput {
	s.WebACLId = &v
	return s
}

// The response to a request to list the distributions that are associated with
// a specified AWS WAF web ACL.
type ListDistributionsByWebACLIdOutput struct {
	_ struct{} `type:"structure" payload:"DistributionList"`

	// The DistributionList type.
	DistributionList *DistributionList `type:"structure"`
}

// String returns the string representation
func (s ListDistributionsByWebACLIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByWebACLIdOutput) GoString() string {
	return s.String()
}

// SetDistributionList sets the DistributionList field's value.
func (s *ListDistributionsByWebACLIdOutput) SetDistributionList(v *DistributionList) *ListDistributionsByWebACLIdOutput {
	s.DistributionList = v
	return s
}

// The request to list your distributions.
type ListDistributionsInput struct {
	_ struct{} `locationName:"ListDistributionsRequest" type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of distributions. The results include distributions in the list that occur
	// after the marker. To get the next page of results, set the Marker to the
	// value of the NextMarker from the current page's response (which is also the
	// ID of the last distribution on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of distributions you want in the response body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListDistributionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListDistributionsInput) SetMarker(v string) *ListDistributionsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListDistributionsInput) SetMaxItems(v int64) *ListDistributionsInput {
	s.MaxItems = &v
	return s
}

// The returned result of the corresponding request.
type ListDistributionsOutput struct {
	_ struct{} `type:"structure" payload:"DistributionList"`

	// The DistributionList type.
	DistributionList *DistributionList `type:"structure"`
}

// String returns the string representation
func (s ListDistributionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsOutput) GoString() string {
	return s.String()
}

// SetDistributionList sets the DistributionList field's value.
func (s *ListDistributionsOutput) SetDistributionList(v *DistributionList) *ListDistributionsOutput {
	s.DistributionList = v
	return s
}

type ListFieldLevelEncryptionConfigsInput struct {
	_ struct{} `locationName:"ListFieldLevelEncryptionConfigsRequest" type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of configurations. The results include configurations in the list that occur
	// after the marker. To get the next page of results, set the Marker to the
	// value of the NextMarker from the current page's response (which is also the
	// ID of the last configuration on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of field-level encryption configurations you want in the
	// response body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListFieldLevelEncryptionConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFieldLevelEncryptionConfigsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListFieldLevelEncryptionConfigsInput) SetMarker(v string) *ListFieldLevelEncryptionConfigsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListFieldLevelEncryptionConfigsInput) SetMaxItems(v int64) *ListFieldLevelEncryptionConfigsInput {
	s.MaxItems = &v
	return s
}

type ListFieldLevelEncryptionConfigsOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionList"`

	// Returns a list of all field-level encryption configurations that have been
	// created in CloudFront for this account.
	FieldLevelEncryptionList *FieldLevelEncryptionList `type:"structure"`
}

// String returns the string representation
func (s ListFieldLevelEncryptionConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFieldLevelEncryptionConfigsOutput) GoString() string {
	return s.String()
}

// SetFieldLevelEncryptionList sets the FieldLevelEncryptionList field's value.
func (s *ListFieldLevelEncryptionConfigsOutput) SetFieldLevelEncryptionList(v *FieldLevelEncryptionList) *ListFieldLevelEncryptionConfigsOutput {
	s.FieldLevelEncryptionList = v
	return s
}

type ListFieldLevelEncryptionProfilesInput struct {
	_ struct{} `locationName:"ListFieldLevelEncryptionProfilesRequest" type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of profiles. The results include profiles in the list that occur after the
	// marker. To get the next page of results, set the Marker to the value of the
	// NextMarker from the current page's response (which is also the ID of the
	// last profile on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of field-level encryption profiles you want in the response
	// body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListFieldLevelEncryptionProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFieldLevelEncryptionProfilesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListFieldLevelEncryptionProfilesInput) SetMarker(v string) *ListFieldLevelEncryptionProfilesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListFieldLevelEncryptionProfilesInput) SetMaxItems(v int64) *ListFieldLevelEncryptionProfilesInput {
	s.MaxItems = &v
	return s
}

type ListFieldLevelEncryptionProfilesOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionProfileList"`

	// Returns a list of the field-level encryption profiles that have been created
	// in CloudFront for this account.
	FieldLevelEncryptionProfileList *FieldLevelEncryptionProfileList `type:"structure"`
}

// String returns the string representation
func (s ListFieldLevelEncryptionProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFieldLevelEncryptionProfilesOutput) GoString() string {
	return s.String()
}

// SetFieldLevelEncryptionProfileList sets the FieldLevelEncryptionProfileList field's value.
func (s *ListFieldLevelEncryptionProfilesOutput) SetFieldLevelEncryptionProfileList(v *FieldLevelEncryptionProfileList) *ListFieldLevelEncryptionProfilesOutput {
	s.FieldLevelEncryptionProfileList = v
	return s
}

// The request to list invalidations.
type ListInvalidationsInput struct {
	_ struct{} `locationName:"ListInvalidationsRequest" type:"structure"`

	// The distribution's ID.
	//
	// DistributionId is a required field
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`

	// Use this parameter when paginating results to indicate where to begin in
	// your list of invalidation batches. Because the results are returned in decreasing
	// order from most recent to oldest, the most recent results are on the first
	// page, the second page will contain earlier results, and so on. To get the
	// next page of results, set Marker to the value of the NextMarker from the
	// current page's response. This value is the same as the ID of the last invalidation
	// batch on that page.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of invalidation batches that you want in the response
	// body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListInvalidationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvalidationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvalidationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvalidationsInput"}
	if s.DistributionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionId"))
	}
	if s.DistributionId != nil && len(*s.DistributionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DistributionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionId sets the DistributionId field's value.
func (s *ListInvalidationsInput) SetDistributionId(v string) *ListInvalidationsInput {
	s.DistributionId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListInvalidationsInput) SetMarker(v string) *ListInvalidationsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListInvalidationsInput) SetMaxItems(v int64) *ListInvalidationsInput {
	s.MaxItems = &v
	return s
}

// The returned result of the corresponding request.
type ListInvalidationsOutput struct {
	_ struct{} `type:"structure" payload:"InvalidationList"`

	// Information about invalidation batches.
	InvalidationList *InvalidationList `type:"structure"`
}

// String returns the string representation
func (s ListInvalidationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvalidationsOutput) GoString() string {
	return s.String()
}

// SetInvalidationList sets the InvalidationList field's value.
func (s *ListInvalidationsOutput) SetInvalidationList(v *InvalidationList) *ListInvalidationsOutput {
	s.InvalidationList = v
	return s
}

type ListPublicKeysInput struct {
	_ struct{} `locationName:"ListPublicKeysRequest" type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of public keys. The results include public keys in the list that occur after
	// the marker. To get the next page of results, set the Marker to the value
	// of the NextMarker from the current page's response (which is also the ID
	// of the last public key on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of public keys you want in the response body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListPublicKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublicKeysInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListPublicKeysInput) SetMarker(v string) *ListPublicKeysInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListPublicKeysInput) SetMaxItems(v int64) *ListPublicKeysInput {
	s.MaxItems = &v
	return s
}

type ListPublicKeysOutput struct {
	_ struct{} `type:"structure" payload:"PublicKeyList"`

	// Returns a list of all public keys that have been added to CloudFront for
	// this account.
	PublicKeyList *PublicKeyList `type:"structure"`
}

// String returns the string representation
func (s ListPublicKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublicKeysOutput) GoString() string {
	return s.String()
}

// SetPublicKeyList sets the PublicKeyList field's value.
func (s *ListPublicKeysOutput) SetPublicKeyList(v *PublicKeyList) *ListPublicKeysOutput {
	s.PublicKeyList = v
	return s
}

// The request to list your streaming distributions.
type ListStreamingDistributionsInput struct {
	_ struct{} `locationName:"ListStreamingDistributionsRequest" type:"structure"`

	// The value that you provided for the Marker request parameter.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The value that you provided for the MaxItems request parameter.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListStreamingDistributionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamingDistributionsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListStreamingDistributionsInput) SetMarker(v string) *ListStreamingDistributionsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListStreamingDistributionsInput) SetMaxItems(v int64) *ListStreamingDistributionsInput {
	s.MaxItems = &v
	return s
}

// The returned result of the corresponding request.
type ListStreamingDistributionsOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistributionList"`

	// The StreamingDistributionList type.
	StreamingDistributionList *StreamingDistributionList `type:"structure"`
}

// String returns the string representation
func (s ListStreamingDistributionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamingDistributionsOutput) GoString() string {
	return s.String()
}

// SetStreamingDistributionList sets the StreamingDistributionList field's value.
func (s *ListStreamingDistributionsOutput) SetStreamingDistributionList(v *StreamingDistributionList) *ListStreamingDistributionsOutput {
	s.StreamingDistributionList = v
	return s
}

// The request to list tags for a CloudFront resource.
type ListTagsForResourceInput struct {
	_ struct{} `locationName:"ListTagsForResourceRequest" type:"structure"`

	// An ARN of a CloudFront resource.
	//
	// Resource is a required field
	Resource *string `location:"querystring" locationName:"Resource" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *ListTagsForResourceInput) SetResource(v string) *ListTagsForResourceInput {
	s.Resource = &v
	return s
}

// The returned result of the corresponding request.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure" payload:"Tags"`

	// A complex type that contains zero or more Tag elements.
	//
	// Tags is a required field
	Tags *Tags `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v *Tags) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A complex type that controls whether access logs are written for the distribution.
type LoggingConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to store the access logs in, for example, myawslogbucket.s3.amazonaws.com.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Specifies whether you want CloudFront to save access logs to an Amazon S3
	// bucket. If you don't want to enable logging when you create a distribution
	// or if you want to disable logging for an existing distribution, specify false
	// for Enabled, and specify empty Bucket and Prefix elements. If you specify
	// false for Enabled but you specify values for Bucket, prefix, and IncludeCookies,
	// the values are automatically deleted.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Specifies whether you want CloudFront to include cookies in access logs,
	// specify true for IncludeCookies. If you choose to include cookies in logs,
	// CloudFront logs all cookies regardless of how you configure the cache behaviors
	// for this distribution. If you don't want to include cookies when you create
	// a distribution or if you want to disable include cookies for an existing
	// distribution, specify false for IncludeCookies.
	//
	// IncludeCookies is a required field
	IncludeCookies *bool `type:"boolean" required:"true"`

	// An optional string that you want CloudFront to prefix to the access log filenames
	// for this distribution, for example, myprefix/. If you want to enable logging,
	// but you don't want to specify a prefix, you still must include an empty Prefix
	// element in the Logging element.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingConfig"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.IncludeCookies == nil {
		invalidParams.Add(request.NewErrParamRequired("IncludeCookies"))
	}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *LoggingConfig) SetBucket(v string) *LoggingConfig {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *LoggingConfig) SetEnabled(v bool) *LoggingConfig {
	s.Enabled = &v
	return s
}

// SetIncludeCookies sets the IncludeCookies field's value.
func (s *LoggingConfig) SetIncludeCookies(v bool) *LoggingConfig {
	s.IncludeCookies = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *LoggingConfig) SetPrefix(v string) *LoggingConfig {
	s.Prefix = &v
	return s
}

// An origin.
//
// An origin is the location where content is stored, and from which CloudFront
// gets content to serve to viewers. To specify an origin:
//
//    * Use the S3OriginConfig type to specify an Amazon S3 bucket that is not
//    configured with static website hosting.
//
//    * Use the CustomOriginConfig type to specify various other kinds of content
//    containers or HTTP servers, including: An Amazon S3 bucket that is configured
//    with static website hosting An Elastic Load Balancing load balancer An
//    AWS Elemental MediaPackage origin An AWS Elemental MediaStore container
//    Any other HTTP server, running on an Amazon EC2 instance or any other
//    kind of host
//
// For the current maximum number of origins that you can specify per distribution,
// see General Quotas on Web Distributions (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions)
// in the Amazon CloudFront Developer Guide (quotas were formerly referred to
// as limits).
type Origin struct {
	_ struct{} `type:"structure"`

	// The number of times that CloudFront attempts to connect to the origin. The
	// minimum number is 1, the maximum is 3, and the default (if you don’t specify
	// otherwise) is 3.
	//
	// For a custom origin (including an Amazon S3 bucket that’s configured with
	// static website hosting), this value also specifies the number of times that
	// CloudFront attempts to get a response from the origin, in the case of an
	// Origin Response Timeout (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).
	//
	// For more information, see Origin Connection Attempts (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts)
	// in the Amazon CloudFront Developer Guide.
	ConnectionAttempts *int64 `type:"integer"`

	// The number of seconds that CloudFront waits when trying to establish a connection
	// to the origin. The minimum timeout is 1 second, the maximum is 10 seconds,
	// and the default (if you don’t specify otherwise) is 10 seconds.
	//
	// For more information, see Origin Connection Timeout (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout)
	// in the Amazon CloudFront Developer Guide.
	ConnectionTimeout *int64 `type:"integer"`

	// A list of HTTP header names and values that CloudFront adds to requests it
	// sends to the origin.
	//
	// For more information, see Adding Custom Headers to Origin Requests (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html)
	// in the Amazon CloudFront Developer Guide.
	CustomHeaders *CustomHeaders `type:"structure"`

	// Use this type to specify an origin that is a content container or HTTP server,
	// including an Amazon S3 bucket that is configured with static website hosting.
	// To specify an Amazon S3 bucket that is not configured with static website
	// hosting, use the S3OriginConfig type instead.
	CustomOriginConfig *CustomOriginConfig `type:"structure"`

	// The domain name for the origin.
	//
	// For more information, see Origin Domain Name (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName)
	// in the Amazon CloudFront Developer Guide.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// A unique identifier for the origin. This value must be unique within the
	// distribution.
	//
	// Use this value to specify the TargetOriginId in a CacheBehavior or DefaultCacheBehavior.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// An optional path that CloudFront appends to the origin domain name when CloudFront
	// requests content from the origin.
	//
	// For more information, see Origin Path (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath)
	// in the Amazon CloudFront Developer Guide.
	OriginPath *string `type:"string"`

	// Use this type to specify an origin that is an Amazon S3 bucket that is not
	// configured with static website hosting. To specify any other type of origin,
	// including an Amazon S3 bucket that is configured with static website hosting,
	// use the CustomOriginConfig type instead.
	S3OriginConfig *S3OriginConfig `type:"structure"`
}

// String returns the string representation
func (s Origin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Origin) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Origin) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Origin"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.CustomHeaders != nil {
		if err := s.CustomHeaders.Validate(); err != nil {
			invalidParams.AddNested("CustomHeaders", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomOriginConfig != nil {
		if err := s.CustomOriginConfig.Validate(); err != nil {
			invalidParams.AddNested("CustomOriginConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.S3OriginConfig != nil {
		if err := s.S3OriginConfig.Validate(); err != nil {
			invalidParams.AddNested("S3OriginConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionAttempts sets the ConnectionAttempts field's value.
func (s *Origin) SetConnectionAttempts(v int64) *Origin {
	s.ConnectionAttempts = &v
	return s
}

// SetConnectionTimeout sets the ConnectionTimeout field's value.
func (s *Origin) SetConnectionTimeout(v int64) *Origin {
	s.ConnectionTimeout = &v
	return s
}

// SetCustomHeaders sets the CustomHeaders field's value.
func (s *Origin) SetCustomHeaders(v *CustomHeaders) *Origin {
	s.CustomHeaders = v
	return s
}

// SetCustomOriginConfig sets the CustomOriginConfig field's value.
func (s *Origin) SetCustomOriginConfig(v *CustomOriginConfig) *Origin {
	s.CustomOriginConfig = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *Origin) SetDomainName(v string) *Origin {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *Origin) SetId(v string) *Origin {
	s.Id = &v
	return s
}

// SetOriginPath sets the OriginPath field's value.
func (s *Origin) SetOriginPath(v string) *Origin {
	s.OriginPath = &v
	return s
}

// SetS3OriginConfig sets the S3OriginConfig field's value.
func (s *Origin) SetS3OriginConfig(v *S3OriginConfig) *Origin {
	s.S3OriginConfig = v
	return s
}

// CloudFront origin access identity.
type OriginAccessIdentity struct {
	_ struct{} `type:"structure"`

	// The current configuration information for the identity.
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `type:"structure"`

	// The ID for the origin access identity, for example, E74FTE3AJFJ256A.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The Amazon S3 canonical user ID for the origin access identity, used when
	// giving the origin access identity read permission to an object in Amazon
	// S3.
	//
	// S3CanonicalUserId is a required field
	S3CanonicalUserId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentity) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentityConfig sets the CloudFrontOriginAccessIdentityConfig field's value.
func (s *OriginAccessIdentity) SetCloudFrontOriginAccessIdentityConfig(v *OriginAccessIdentityConfig) *OriginAccessIdentity {
	s.CloudFrontOriginAccessIdentityConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *OriginAccessIdentity) SetId(v string) *OriginAccessIdentity {
	s.Id = &v
	return s
}

// SetS3CanonicalUserId sets the S3CanonicalUserId field's value.
func (s *OriginAccessIdentity) SetS3CanonicalUserId(v string) *OriginAccessIdentity {
	s.S3CanonicalUserId = &v
	return s
}

// Origin access identity configuration. Send a GET request to the /CloudFront
// API version/CloudFront/identity ID/config resource.
type OriginAccessIdentityConfig struct {
	_ struct{} `type:"structure"`

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// CloudFrontOriginAccessIdentityConfig object), a new origin access identity
	// is created.
	//
	// If the CallerReference is a value already sent in a previous identity request,
	// and the content of the CloudFrontOriginAccessIdentityConfig is identical
	// to the original request (ignoring white space), the response includes the
	// same information returned to the original request.
	//
	// If the CallerReference is a value you already sent in a previous request
	// to create an identity, but the content of the CloudFrontOriginAccessIdentityConfig
	// is different from the original request, CloudFront returns a CloudFrontOriginAccessIdentityAlreadyExists
	// error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the origin access identity.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentityConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentityConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginAccessIdentityConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginAccessIdentityConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.Comment == nil {
		invalidParams.Add(request.NewErrParamRequired("Comment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *OriginAccessIdentityConfig) SetCallerReference(v string) *OriginAccessIdentityConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *OriginAccessIdentityConfig) SetComment(v string) *OriginAccessIdentityConfig {
	s.Comment = &v
	return s
}

// Lists the origin access identities for CloudFront.Send a GET request to the
// /CloudFront API version/origin-access-identity/cloudfront resource. The response
// includes a CloudFrontOriginAccessIdentityList element with zero or more CloudFrontOriginAccessIdentitySummary
// child elements. By default, your entire list of origin access identities
// is returned in one single page. If the list is long, you can paginate it
// using the MaxItems and Marker parameters.
type OriginAccessIdentityList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more origin access identities remain to be
	// listed. If your results were truncated, you can make a follow-up pagination
	// request using the Marker request parameter to retrieve more items in the
	// list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one CloudFrontOriginAccessIdentitySummary element
	// for each origin access identity that was created by the current AWS account.
	Items []*OriginAccessIdentitySummary `locationNameList:"CloudFrontOriginAccessIdentitySummary" type:"list"`

	// Use this when paginating results to indicate where to begin in your list
	// of origin access identities. The results include identities in the list that
	// occur after the marker. To get the next page of results, set the Marker to
	// the value of the NextMarker from the current page's response (which is also
	// the ID of the last identity on that page).
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The maximum number of origin access identities you want in the response body.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your origin
	// access identities where they left off.
	NextMarker *string `type:"string"`

	// The number of CloudFront origin access identities that were created by the
	// current AWS account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentityList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentityList) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *OriginAccessIdentityList) SetIsTruncated(v bool) *OriginAccessIdentityList {
	s.IsTruncated = &v
	return s
}

// SetItems sets the Items field's value.
func (s *OriginAccessIdentityList) SetItems(v []*OriginAccessIdentitySummary) *OriginAccessIdentityList {
	s.Items = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *OriginAccessIdentityList) SetMarker(v string) *OriginAccessIdentityList {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *OriginAccessIdentityList) SetMaxItems(v int64) *OriginAccessIdentityList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *OriginAccessIdentityList) SetNextMarker(v string) *OriginAccessIdentityList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *OriginAccessIdentityList) SetQuantity(v int64) *OriginAccessIdentityList {
	s.Quantity = &v
	return s
}

// Summary of the information about a CloudFront origin access identity.
type OriginAccessIdentitySummary struct {
	_ struct{} `type:"structure"`

	// The comment for this origin access identity, as originally specified when
	// created.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// The ID for the origin access identity. For example: E74FTE3AJFJ256A.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The Amazon S3 canonical user ID for the origin access identity, which you
	// use when giving the origin access identity read permission to an object in
	// Amazon S3.
	//
	// S3CanonicalUserId is a required field
	S3CanonicalUserId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentitySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentitySummary) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *OriginAccessIdentitySummary) SetComment(v string) *OriginAccessIdentitySummary {
	s.Comment = &v
	return s
}

// SetId sets the Id field's value.
func (s *OriginAccessIdentitySummary) SetId(v string) *OriginAccessIdentitySummary {
	s.Id = &v
	return s
}

// SetS3CanonicalUserId sets the S3CanonicalUserId field's value.
func (s *OriginAccessIdentitySummary) SetS3CanonicalUserId(v string) *OriginAccessIdentitySummary {
	s.S3CanonicalUserId = &v
	return s
}

// A complex type that contains HeaderName and HeaderValue elements, if any,
// for this distribution.
type OriginCustomHeader struct {
	_ struct{} `type:"structure"`

	// The name of a header that you want CloudFront to forward to your origin.
	// For more information, see Forwarding Custom Headers to Your Origin (Web Distributions
	// Only) (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// HeaderName is a required field
	HeaderName *string `type:"string" required:"true"`

	// The value for the header that you specified in the HeaderName field.
	//
	// HeaderValue is a required field
	HeaderValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginCustomHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginCustomHeader) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginCustomHeader) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginCustomHeader"}
	if s.HeaderName == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderName"))
	}
	if s.HeaderValue == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaderName sets the HeaderName field's value.
func (s *OriginCustomHeader) SetHeaderName(v string) *OriginCustomHeader {
	s.HeaderName = &v
	return s
}

// SetHeaderValue sets the HeaderValue field's value.
func (s *OriginCustomHeader) SetHeaderValue(v string) *OriginCustomHeader {
	s.HeaderValue = &v
	return s
}

// An origin group includes two origins (a primary origin and a second origin
// to failover to) and a failover criteria that you specify. You create an origin
// group to support origin failover in CloudFront. When you create or update
// a distribution, you can specifiy the origin group instead of a single origin,
// and CloudFront will failover from the primary origin to the second origin
// under the failover conditions that you've chosen.
type OriginGroup struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the failover criteria for
	// an origin group.
	//
	// FailoverCriteria is a required field
	FailoverCriteria *OriginGroupFailoverCriteria `type:"structure" required:"true"`

	// The origin group's ID.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A complex type that contains information about the origins in an origin group.
	//
	// Members is a required field
	Members *OriginGroupMembers `type:"structure" required:"true"`
}

// String returns the string representation
func (s OriginGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginGroup"}
	if s.FailoverCriteria == nil {
		invalidParams.Add(request.NewErrParamRequired("FailoverCriteria"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Members == nil {
		invalidParams.Add(request.NewErrParamRequired("Members"))
	}
	if s.FailoverCriteria != nil {
		if err := s.FailoverCriteria.Validate(); err != nil {
			invalidParams.AddNested("FailoverCriteria", err.(request.ErrInvalidParams))
		}
	}
	if s.Members != nil {
		if err := s.Members.Validate(); err != nil {
			invalidParams.AddNested("Members", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailoverCriteria sets the FailoverCriteria field's value.
func (s *OriginGroup) SetFailoverCriteria(v *OriginGroupFailoverCriteria) *OriginGroup {
	s.FailoverCriteria = v
	return s
}

// SetId sets the Id field's value.
func (s *OriginGroup) SetId(v string) *OriginGroup {
	s.Id = &v
	return s
}

// SetMembers sets the Members field's value.
func (s *OriginGroup) SetMembers(v *OriginGroupMembers) *OriginGroup {
	s.Members = v
	return s
}

// A complex data type that includes information about the failover criteria
// for an origin group, including the status codes for which CloudFront will
// failover from the primary origin to the second origin.
type OriginGroupFailoverCriteria struct {
	_ struct{} `type:"structure"`

	// The status codes that, when returned from the primary origin, will trigger
	// CloudFront to failover to the second origin.
	//
	// StatusCodes is a required field
	StatusCodes *StatusCodes `type:"structure" required:"true"`
}

// String returns the string representation
func (s OriginGroupFailoverCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginGroupFailoverCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroupFailoverCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginGroupFailoverCriteria"}
	if s.StatusCodes == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusCodes"))
	}
	if s.StatusCodes != nil {
		if err := s.StatusCodes.Validate(); err != nil {
			invalidParams.AddNested("StatusCodes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatusCodes sets the StatusCodes field's value.
func (s *OriginGroupFailoverCriteria) SetStatusCodes(v *StatusCodes) *OriginGroupFailoverCriteria {
	s.StatusCodes = v
	return s
}

// An origin in an origin group.
type OriginGroupMember struct {
	_ struct{} `type:"structure"`

	// The ID for an origin in an origin group.
	//
	// OriginId is a required field
	OriginId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginGroupMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginGroupMember) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroupMember) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginGroupMember"}
	if s.OriginId == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOriginId sets the OriginId field's value.
func (s *OriginGroupMember) SetOriginId(v string) *OriginGroupMember {
	s.OriginId = &v
	return s
}

// A complex data type for the origins included in an origin group.
type OriginGroupMembers struct {
	_ struct{} `type:"structure"`

	// Items (origins) in an origin group.
	//
	// Items is a required field
	Items []*OriginGroupMember `locationNameList:"OriginGroupMember" min:"2" type:"list" required:"true"`

	// The number of origins in an origin group.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginGroupMembers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginGroupMembers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroupMembers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginGroupMembers"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Items != nil && len(s.Items) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Items", 2))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *OriginGroupMembers) SetItems(v []*OriginGroupMember) *OriginGroupMembers {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *OriginGroupMembers) SetQuantity(v int64) *OriginGroupMembers {
	s.Quantity = &v
	return s
}

// A complex data type for the origin groups specified for a distribution.
type OriginGroups struct {
	_ struct{} `type:"structure"`

	// The items (origin groups) in a distribution.
	Items []*OriginGroup `locationNameList:"OriginGroup" type:"list"`

	// The number of origin groups.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginGroups) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginGroups) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginGroups) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginGroups"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *OriginGroups) SetItems(v []*OriginGroup) *OriginGroups {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *OriginGroups) SetQuantity(v int64) *OriginGroups {
	s.Quantity = &v
	return s
}

// A complex type that contains information about the SSL/TLS protocols that
// CloudFront can use when establishing an HTTPS connection with your origin.
type OriginSslProtocols struct {
	_ struct{} `type:"structure"`

	// A list that contains allowed SSL/TLS protocols for this distribution.
	//
	// Items is a required field
	Items []*string `locationNameList:"SslProtocol" type:"list" required:"true"`

	// The number of SSL/TLS protocols that you want to allow CloudFront to use
	// when establishing an HTTPS connection with this origin.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginSslProtocols) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginSslProtocols) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginSslProtocols) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginSslProtocols"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *OriginSslProtocols) SetItems(v []*string) *OriginSslProtocols {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *OriginSslProtocols) SetQuantity(v int64) *OriginSslProtocols {
	s.Quantity = &v
	return s
}

// A complex type that contains information about origins and origin groups
// for this distribution.
type Origins struct {
	_ struct{} `type:"structure"`

	// A complex type that contains origins or origin groups for this distribution.
	//
	// Items is a required field
	Items []*Origin `locationNameList:"Origin" min:"1" type:"list" required:"true"`

	// The number of origins or origin groups for this distribution.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Origins) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Origins) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Origins) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Origins"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Items != nil && len(s.Items) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Items", 1))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *Origins) SetItems(v []*Origin) *Origins {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *Origins) SetQuantity(v int64) *Origins {
	s.Quantity = &v
	return s
}

// A complex type that contains information about the objects that you want
// to invalidate. For more information, see Specifying the Objects to Invalidate
// (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects)
// in the Amazon CloudFront Developer Guide.
type Paths struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a list of the paths that you want to invalidate.
	Items []*string `locationNameList:"Path" type:"list"`

	// The number of invalidation paths specified for the objects that you want
	// to invalidate.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Paths) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Paths) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Paths) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Paths"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *Paths) SetItems(v []*string) *Paths {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *Paths) SetQuantity(v int64) *Paths {
	s.Quantity = &v
	return s
}

// A complex data type of public keys you add to CloudFront to use with features
// like field-level encryption.
type PublicKey struct {
	_ struct{} `type:"structure"`

	// A time you added a public key to CloudFront.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// A unique ID assigned to a public key you've added to CloudFront.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A complex data type for a public key you add to CloudFront to use with features
	// like field-level encryption.
	//
	// PublicKeyConfig is a required field
	PublicKeyConfig *PublicKeyConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s PublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicKey) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *PublicKey) SetCreatedTime(v time.Time) *PublicKey {
	s.CreatedTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *PublicKey) SetId(v string) *PublicKey {
	s.Id = &v
	return s
}

// SetPublicKeyConfig sets the PublicKeyConfig field's value.
func (s *PublicKey) SetPublicKeyConfig(v *PublicKeyConfig) *PublicKey {
	s.PublicKeyConfig = v
	return s
}

// Information about a public key you add to CloudFront to use with features
// like field-level encryption.
type PublicKeyConfig struct {
	_ struct{} `type:"structure"`

	// A unique number that ensures that the request can't be replayed.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// An optional comment about a public key.
	Comment *string `type:"string"`

	// The encoded public key that you want to add to CloudFront to use with features
	// like field-level encryption.
	//
	// EncodedKey is a required field
	EncodedKey *string `type:"string" required:"true"`

	// The name for a public key you add to CloudFront to use with features like
	// field-level encryption.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PublicKeyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicKeyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublicKeyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublicKeyConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.EncodedKey == nil {
		invalidParams.Add(request.NewErrParamRequired("EncodedKey"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallerReference sets the CallerReference field's value.
func (s *PublicKeyConfig) SetCallerReference(v string) *PublicKeyConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *PublicKeyConfig) SetComment(v string) *PublicKeyConfig {
	s.Comment = &v
	return s
}

// SetEncodedKey sets the EncodedKey field's value.
func (s *PublicKeyConfig) SetEncodedKey(v string) *PublicKeyConfig {
	s.EncodedKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *PublicKeyConfig) SetName(v string) *PublicKeyConfig {
	s.Name = &v
	return s
}

// A list of public keys you've added to CloudFront to use with features like
// field-level encryption.
type PublicKeyList struct {
	_ struct{} `type:"structure"`

	// An array of information about a public key you add to CloudFront to use with
	// features like field-level encryption.
	Items []*PublicKeySummary `locationNameList:"PublicKeySummary" type:"list"`

	// The maximum number of public keys you want in the response body.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If there are more elements to be listed, this element is present and contains
	// the value that you can use for the Marker request parameter to continue listing
	// your public keys where you left off.
	NextMarker *string `type:"string"`

	// The number of public keys you added to CloudFront to use with features like
	// field-level encryption.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s PublicKeyList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicKeyList) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *PublicKeyList) SetItems(v []*PublicKeySummary) *PublicKeyList {
	s.Items = v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *PublicKeyList) SetMaxItems(v int64) *PublicKeyList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *PublicKeyList) SetNextMarker(v string) *PublicKeyList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *PublicKeyList) SetQuantity(v int64) *PublicKeyList {
	s.Quantity = &v
	return s
}

// A complex data type for public key information.
type PublicKeySummary struct {
	_ struct{} `type:"structure"`

	// Comment for public key information summary.
	Comment *string `type:"string"`

	// Creation time for public key information summary.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// Encoded key for public key information summary.
	//
	// EncodedKey is a required field
	EncodedKey *string `type:"string" required:"true"`

	// ID for public key information summary.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Name for public key information summary.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PublicKeySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicKeySummary) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *PublicKeySummary) SetComment(v string) *PublicKeySummary {
	s.Comment = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *PublicKeySummary) SetCreatedTime(v time.Time) *PublicKeySummary {
	s.CreatedTime = &v
	return s
}

// SetEncodedKey sets the EncodedKey field's value.
func (s *PublicKeySummary) SetEncodedKey(v string) *PublicKeySummary {
	s.EncodedKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *PublicKeySummary) SetId(v string) *PublicKeySummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *PublicKeySummary) SetName(v string) *PublicKeySummary {
	s.Name = &v
	return s
}

// Query argument-profile mapping for field-level encryption.
type QueryArgProfile struct {
	_ struct{} `type:"structure"`

	// ID of profile to use for field-level encryption query argument-profile mapping
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`

	// Query argument for field-level encryption query argument-profile mapping.
	//
	// QueryArg is a required field
	QueryArg *string `type:"string" required:"true"`
}

// String returns the string representation
func (s QueryArgProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryArgProfile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryArgProfile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryArgProfile"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.QueryArg == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryArg"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *QueryArgProfile) SetProfileId(v string) *QueryArgProfile {
	s.ProfileId = &v
	return s
}

// SetQueryArg sets the QueryArg field's value.
func (s *QueryArgProfile) SetQueryArg(v string) *QueryArgProfile {
	s.QueryArg = &v
	return s
}

// Configuration for query argument-profile mapping for field-level encryption.
type QueryArgProfileConfig struct {
	_ struct{} `type:"structure"`

	// Flag to set if you want a request to be forwarded to the origin even if the
	// profile specified by the field-level encryption query argument, fle-profile,
	// is unknown.
	//
	// ForwardWhenQueryArgProfileIsUnknown is a required field
	ForwardWhenQueryArgProfileIsUnknown *bool `type:"boolean" required:"true"`

	// Profiles specified for query argument-profile mapping for field-level encryption.
	QueryArgProfiles *QueryArgProfiles `type:"structure"`
}

// String returns the string representation
func (s QueryArgProfileConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryArgProfileConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryArgProfileConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryArgProfileConfig"}
	if s.ForwardWhenQueryArgProfileIsUnknown == nil {
		invalidParams.Add(request.NewErrParamRequired("ForwardWhenQueryArgProfileIsUnknown"))
	}
	if s.QueryArgProfiles != nil {
		if err := s.QueryArgProfiles.Validate(); err != nil {
			invalidParams.AddNested("QueryArgProfiles", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForwardWhenQueryArgProfileIsUnknown sets the ForwardWhenQueryArgProfileIsUnknown field's value.
func (s *QueryArgProfileConfig) SetForwardWhenQueryArgProfileIsUnknown(v bool) *QueryArgProfileConfig {
	s.ForwardWhenQueryArgProfileIsUnknown = &v
	return s
}

// SetQueryArgProfiles sets the QueryArgProfiles field's value.
func (s *QueryArgProfileConfig) SetQueryArgProfiles(v *QueryArgProfiles) *QueryArgProfileConfig {
	s.QueryArgProfiles = v
	return s
}

// Query argument-profile mapping for field-level encryption.
type QueryArgProfiles struct {
	_ struct{} `type:"structure"`

	// Number of items for query argument-profile mapping for field-level encryption.
	Items []*QueryArgProfile `locationNameList:"QueryArgProfile" type:"list"`

	// Number of profiles for query argument-profile mapping for field-level encryption.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s QueryArgProfiles) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryArgProfiles) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryArgProfiles) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryArgProfiles"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *QueryArgProfiles) SetItems(v []*QueryArgProfile) *QueryArgProfiles {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *QueryArgProfiles) SetQuantity(v int64) *QueryArgProfiles {
	s.Quantity = &v
	return s
}

// A complex type that contains information about the query string parameters
// that you want CloudFront to use for caching for a cache behavior.
type QueryStringCacheKeys struct {
	_ struct{} `type:"structure"`

	// A list that contains the query string parameters that you want CloudFront
	// to use as a basis for caching for a cache behavior. If Quantity is 0, you
	// can omit Items.
	Items []*string `locationNameList:"Name" type:"list"`

	// The number of whitelisted query string parameters for a cache behavior.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s QueryStringCacheKeys) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringCacheKeys) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryStringCacheKeys) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryStringCacheKeys"}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *QueryStringCacheKeys) SetItems(v []*string) *QueryStringCacheKeys {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *QueryStringCacheKeys) SetQuantity(v int64) *QueryStringCacheKeys {
	s.Quantity = &v
	return s
}

// A complex type that identifies ways in which you want to restrict distribution
// of your content.
type Restrictions struct {
	_ struct{} `type:"structure"`

	// A complex type that controls the countries in which your content is distributed.
	// CloudFront determines the location of your users using MaxMind GeoIP databases.
	//
	// GeoRestriction is a required field
	GeoRestriction *GeoRestriction `type:"structure" required:"true"`
}

// String returns the string representation
func (s Restrictions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Restrictions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Restrictions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Restrictions"}
	if s.GeoRestriction == nil {
		invalidParams.Add(request.NewErrParamRequired("GeoRestriction"))
	}
	if s.GeoRestriction != nil {
		if err := s.GeoRestriction.Validate(); err != nil {
			invalidParams.AddNested("GeoRestriction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeoRestriction sets the GeoRestriction field's value.
func (s *Restrictions) SetGeoRestriction(v *GeoRestriction) *Restrictions {
	s.GeoRestriction = v
	return s
}

// A complex type that contains information about the Amazon S3 bucket from
// which you want CloudFront to get your media files for distribution.
type S3Origin struct {
	_ struct{} `type:"structure"`

	// The DNS name of the Amazon S3 origin.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The CloudFront origin access identity to associate with the distribution.
	// Use an origin access identity to configure the distribution so that end users
	// can only access objects in an Amazon S3 bucket through CloudFront.
	//
	// If you want end users to be able to access objects using either the CloudFront
	// URL or the Amazon S3 URL, specify an empty OriginAccessIdentity element.
	//
	// To delete the origin access identity from an existing distribution, update
	// the distribution configuration and include an empty OriginAccessIdentity
	// element.
	//
	// To replace the origin access identity, update the distribution configuration
	// and specify the new origin access identity.
	//
	// For more information, see Using an Origin Access Identity to Restrict Access
	// to Your Amazon S3 Content (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// OriginAccessIdentity is a required field
	OriginAccessIdentity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3Origin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Origin) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Origin) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Origin"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.OriginAccessIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginAccessIdentity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *S3Origin) SetDomainName(v string) *S3Origin {
	s.DomainName = &v
	return s
}

// SetOriginAccessIdentity sets the OriginAccessIdentity field's value.
func (s *S3Origin) SetOriginAccessIdentity(v string) *S3Origin {
	s.OriginAccessIdentity = &v
	return s
}

// A complex type that contains information about the Amazon S3 origin. If the
// origin is a custom origin or an S3 bucket that is configured as a website
// endpoint, use the CustomOriginConfig element instead.
type S3OriginConfig struct {
	_ struct{} `type:"structure"`

	// The CloudFront origin access identity to associate with the origin. Use an
	// origin access identity to configure the origin so that viewers can only access
	// objects in an Amazon S3 bucket through CloudFront. The format of the value
	// is:
	//
	// origin-access-identity/cloudfront/ID-of-origin-access-identity
	//
	// where ID-of-origin-access-identity is the value that CloudFront returned
	// in the ID element when you created the origin access identity.
	//
	// If you want viewers to be able to access objects using either the CloudFront
	// URL or the Amazon S3 URL, specify an empty OriginAccessIdentity element.
	//
	// To delete the origin access identity from an existing distribution, update
	// the distribution configuration and include an empty OriginAccessIdentity
	// element.
	//
	// To replace the origin access identity, update the distribution configuration
	// and specify the new origin access identity.
	//
	// For more information about the origin access identity, see Serving Private
	// Content through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// OriginAccessIdentity is a required field
	OriginAccessIdentity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3OriginConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3OriginConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3OriginConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3OriginConfig"}
	if s.OriginAccessIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginAccessIdentity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOriginAccessIdentity sets the OriginAccessIdentity field's value.
func (s *S3OriginConfig) SetOriginAccessIdentity(v string) *S3OriginConfig {
	s.OriginAccessIdentity = &v
	return s
}

// A complex type that lists the AWS accounts that were included in the TrustedSigners
// complex type, as well as their active CloudFront key pair IDs, if any.
type Signer struct {
	_ struct{} `type:"structure"`

	// An AWS account that is included in the TrustedSigners complex type for this
	// distribution. Valid values include:
	//
	//    * self, which is the AWS account used to create the distribution.
	//
	//    * An AWS account number.
	AwsAccountNumber *string `type:"string"`

	// A complex type that lists the active CloudFront key pairs, if any, that are
	// associated with AwsAccountNumber.
	KeyPairIds *KeyPairIds `type:"structure"`
}

// String returns the string representation
func (s Signer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Signer) GoString() string {
	return s.String()
}

// SetAwsAccountNumber sets the AwsAccountNumber field's value.
func (s *Signer) SetAwsAccountNumber(v string) *Signer {
	s.AwsAccountNumber = &v
	return s
}

// SetKeyPairIds sets the KeyPairIds field's value.
func (s *Signer) SetKeyPairIds(v *KeyPairIds) *Signer {
	s.KeyPairIds = v
	return s
}

// A complex data type for the status codes that you specify that, when returned
// by a primary origin, trigger CloudFront to failover to a second origin.
type StatusCodes struct {
	_ struct{} `type:"structure"`

	// The items (status codes) for an origin group.
	//
	// Items is a required field
	Items []*int64 `locationNameList:"StatusCode" min:"1" type:"list" required:"true"`

	// The number of status codes.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StatusCodes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusCodes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatusCodes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StatusCodes"}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Items != nil && len(s.Items) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Items", 1))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *StatusCodes) SetItems(v []*int64) *StatusCodes {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *StatusCodes) SetQuantity(v int64) *StatusCodes {
	s.Quantity = &v
	return s
}

// A streaming distribution tells CloudFront where you want RTMP content to
// be delivered from, and the details about how to track and manage content
// delivery.
type StreamingDistribution struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the distribution. For example: arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// A complex type that lists the AWS accounts, if any, that you included in
	// the TrustedSigners complex type for this distribution. These are the accounts
	// that you want to allow to create signed URLs for private content.
	//
	// The Signer complex type lists the AWS account number of the trusted signer
	// or self if the signer is the AWS account that created the distribution. The
	// Signer element also includes the IDs of any active CloudFront key pairs that
	// are associated with the trusted signer's AWS account. If no KeyPairId element
	// appears for a Signer, that signer can't create signed URLs.
	//
	// For more information, see Serving Private Content through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// ActiveTrustedSigners is a required field
	ActiveTrustedSigners *ActiveTrustedSigners `type:"structure" required:"true"`

	// The domain name that corresponds to the streaming distribution, for example,
	// s5c39gqb8ow64r.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The identifier for the RTMP distribution. For example: EGTXBD79EXAMPLE.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date and time that the distribution was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The current status of the RTMP distribution. When the status is Deployed,
	// the distribution's information is propagated to all CloudFront edge locations.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// The current configuration information for the RTMP distribution.
	//
	// StreamingDistributionConfig is a required field
	StreamingDistributionConfig *StreamingDistributionConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistribution) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *StreamingDistribution) SetARN(v string) *StreamingDistribution {
	s.ARN = &v
	return s
}

// SetActiveTrustedSigners sets the ActiveTrustedSigners field's value.
func (s *StreamingDistribution) SetActiveTrustedSigners(v *ActiveTrustedSigners) *StreamingDistribution {
	s.ActiveTrustedSigners = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *StreamingDistribution) SetDomainName(v string) *StreamingDistribution {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *StreamingDistribution) SetId(v string) *StreamingDistribution {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *StreamingDistribution) SetLastModifiedTime(v time.Time) *StreamingDistribution {
	s.LastModifiedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StreamingDistribution) SetStatus(v string) *StreamingDistribution {
	s.Status = &v
	return s
}

// SetStreamingDistributionConfig sets the StreamingDistributionConfig field's value.
func (s *StreamingDistribution) SetStreamingDistributionConfig(v *StreamingDistributionConfig) *StreamingDistribution {
	s.StreamingDistributionConfig = v
	return s
}

// The RTMP distribution's configuration information.
type StreamingDistributionConfig struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this streaming distribution.
	Aliases *Aliases `type:"structure"`

	// A unique value (for example, a date-time stamp) that ensures that the request
	// can't be replayed.
	//
	// If the value of CallerReference is new (regardless of the content of the
	// StreamingDistributionConfig object), CloudFront creates a new distribution.
	//
	// If CallerReference is a value that you already sent in a previous request
	// to create a distribution, CloudFront returns a DistributionAlreadyExists
	// error.
	//
	// CallerReference is a required field
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the streaming distribution.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// Whether the streaming distribution is enabled to accept user requests for
	// content.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// A complex type that controls whether access logs are written for the streaming
	// distribution.
	Logging *StreamingLoggingConfig `type:"structure"`

	// A complex type that contains information about price class for this streaming
	// distribution.
	PriceClass *string `type:"string" enum:"PriceClass"`

	// A complex type that contains information about the Amazon S3 bucket from
	// which you want CloudFront to get your media files for distribution.
	//
	// S3Origin is a required field
	S3Origin *S3Origin `type:"structure" required:"true"`

	// A complex type that specifies any AWS accounts that you want to permit to
	// create signed URLs for private content. If you want the distribution to use
	// signed URLs, include this element; if you want the distribution to use public
	// URLs, remove this element. For more information, see Serving Private Content
	// through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// TrustedSigners is a required field
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistributionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingDistributionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamingDistributionConfig"}
	if s.CallerReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CallerReference"))
	}
	if s.Comment == nil {
		invalidParams.Add(request.NewErrParamRequired("Comment"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.S3Origin == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Origin"))
	}
	if s.TrustedSigners == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustedSigners"))
	}
	if s.Aliases != nil {
		if err := s.Aliases.Validate(); err != nil {
			invalidParams.AddNested("Aliases", err.(request.ErrInvalidParams))
		}
	}
	if s.Logging != nil {
		if err := s.Logging.Validate(); err != nil {
			invalidParams.AddNested("Logging", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Origin != nil {
		if err := s.S3Origin.Validate(); err != nil {
			invalidParams.AddNested("S3Origin", err.(request.ErrInvalidParams))
		}
	}
	if s.TrustedSigners != nil {
		if err := s.TrustedSigners.Validate(); err != nil {
			invalidParams.AddNested("TrustedSigners", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliases sets the Aliases field's value.
func (s *StreamingDistributionConfig) SetAliases(v *Aliases) *StreamingDistributionConfig {
	s.Aliases = v
	return s
}

// SetCallerReference sets the CallerReference field's value.
func (s *StreamingDistributionConfig) SetCallerReference(v string) *StreamingDistributionConfig {
	s.CallerReference = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *StreamingDistributionConfig) SetComment(v string) *StreamingDistributionConfig {
	s.Comment = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *StreamingDistributionConfig) SetEnabled(v bool) *StreamingDistributionConfig {
	s.Enabled = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *StreamingDistributionConfig) SetLogging(v *StreamingLoggingConfig) *StreamingDistributionConfig {
	s.Logging = v
	return s
}

// SetPriceClass sets the PriceClass field's value.
func (s *StreamingDistributionConfig) SetPriceClass(v string) *StreamingDistributionConfig {
	s.PriceClass = &v
	return s
}

// SetS3Origin sets the S3Origin field's value.
func (s *StreamingDistributionConfig) SetS3Origin(v *S3Origin) *StreamingDistributionConfig {
	s.S3Origin = v
	return s
}

// SetTrustedSigners sets the TrustedSigners field's value.
func (s *StreamingDistributionConfig) SetTrustedSigners(v *TrustedSigners) *StreamingDistributionConfig {
	s.TrustedSigners = v
	return s
}

// A streaming distribution Configuration and a list of tags to be associated
// with the streaming distribution.
type StreamingDistributionConfigWithTags struct {
	_ struct{} `type:"structure"`

	// A streaming distribution Configuration.
	//
	// StreamingDistributionConfig is a required field
	StreamingDistributionConfig *StreamingDistributionConfig `type:"structure" required:"true"`

	// A complex type that contains zero or more Tag elements.
	//
	// Tags is a required field
	Tags *Tags `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionConfigWithTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistributionConfigWithTags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingDistributionConfigWithTags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamingDistributionConfigWithTags"}
	if s.StreamingDistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingDistributionConfig"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.StreamingDistributionConfig != nil {
		if err := s.StreamingDistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("StreamingDistributionConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		if err := s.Tags.Validate(); err != nil {
			invalidParams.AddNested("Tags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamingDistributionConfig sets the StreamingDistributionConfig field's value.
func (s *StreamingDistributionConfigWithTags) SetStreamingDistributionConfig(v *StreamingDistributionConfig) *StreamingDistributionConfigWithTags {
	s.StreamingDistributionConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StreamingDistributionConfigWithTags) SetTags(v *Tags) *StreamingDistributionConfigWithTags {
	s.Tags = v
	return s
}

// A streaming distribution list.
type StreamingDistributionList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more streaming distributions remain to be listed.
	// If your results were truncated, you can make a follow-up pagination request
	// using the Marker request parameter to retrieve more distributions in the
	// list.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one StreamingDistributionSummary element for
	// each distribution that was created by the current AWS account.
	Items []*StreamingDistributionSummary `locationNameList:"StreamingDistributionSummary" type:"list"`

	// The value you provided for the Marker request parameter.
	//
	// Marker is a required field
	Marker *string `type:"string" required:"true"`

	// The value you provided for the MaxItems request parameter.
	//
	// MaxItems is a required field
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your RTMP distributions
	// where they left off.
	NextMarker *string `type:"string"`

	// The number of streaming distributions that were created by the current AWS
	// account.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistributionList) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *StreamingDistributionList) SetIsTruncated(v bool) *StreamingDistributionList {
	s.IsTruncated = &v
	return s
}

// SetItems sets the Items field's value.
func (s *StreamingDistributionList) SetItems(v []*StreamingDistributionSummary) *StreamingDistributionList {
	s.Items = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *StreamingDistributionList) SetMarker(v string) *StreamingDistributionList {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *StreamingDistributionList) SetMaxItems(v int64) *StreamingDistributionList {
	s.MaxItems = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *StreamingDistributionList) SetNextMarker(v string) *StreamingDistributionList {
	s.NextMarker = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *StreamingDistributionList) SetQuantity(v int64) *StreamingDistributionList {
	s.Quantity = &v
	return s
}

// A summary of the information for a CloudFront streaming distribution.
type StreamingDistributionSummary struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the streaming distribution. For example:
	// arn:aws:cloudfront::123456789012:streaming-distribution/EDFDVBD632BHDS5,
	// where 123456789012 is your AWS account ID.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this streaming distribution.
	//
	// Aliases is a required field
	Aliases *Aliases `type:"structure" required:"true"`

	// The comment originally specified when this distribution was created.
	//
	// Comment is a required field
	Comment *string `type:"string" required:"true"`

	// The domain name corresponding to the distribution, for example, d111111abcdef8.cloudfront.net.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Whether the distribution is enabled to accept end user requests for content.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The identifier for the distribution, for example, EDFDVBD632BHDS5.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The date and time the distribution was last modified.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// A complex type that contains information about price class for this streaming
	// distribution.
	//
	// PriceClass is a required field
	PriceClass *string `type:"string" required:"true" enum:"PriceClass"`

	// A complex type that contains information about the Amazon S3 bucket from
	// which you want CloudFront to get your media files for distribution.
	//
	// S3Origin is a required field
	S3Origin *S3Origin `type:"structure" required:"true"`

	// Indicates the current status of the distribution. When the status is Deployed,
	// the distribution's information is fully propagated throughout the Amazon
	// CloudFront system.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// A complex type that specifies the AWS accounts, if any, that you want to
	// allow to create signed URLs for private content. If you want to require signed
	// URLs in requests for objects in the target origin that match the PathPattern
	// for this cache behavior, specify true for Enabled, and specify the applicable
	// values for Quantity and Items.If you don't want to require signed URLs in
	// requests for objects that match PathPattern, specify false for Enabled and
	// 0 for Quantity. Omit Items. To add, change, or remove one or more trusted
	// signers, change Enabled to true (if it's currently false), change Quantity
	// as applicable, and specify all of the trusted signers that you want to include
	// in the updated distribution.
	//
	// For more information, see Serving Private Content through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// TrustedSigners is a required field
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistributionSummary) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *StreamingDistributionSummary) SetARN(v string) *StreamingDistributionSummary {
	s.ARN = &v
	return s
}

// SetAliases sets the Aliases field's value.
func (s *StreamingDistributionSummary) SetAliases(v *Aliases) *StreamingDistributionSummary {
	s.Aliases = v
	return s
}

// SetComment sets the Comment field's value.
func (s *StreamingDistributionSummary) SetComment(v string) *StreamingDistributionSummary {
	s.Comment = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *StreamingDistributionSummary) SetDomainName(v string) *StreamingDistributionSummary {
	s.DomainName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *StreamingDistributionSummary) SetEnabled(v bool) *StreamingDistributionSummary {
	s.Enabled = &v
	return s
}

// SetId sets the Id field's value.
func (s *StreamingDistributionSummary) SetId(v string) *StreamingDistributionSummary {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *StreamingDistributionSummary) SetLastModifiedTime(v time.Time) *StreamingDistributionSummary {
	s.LastModifiedTime = &v
	return s
}

// SetPriceClass sets the PriceClass field's value.
func (s *StreamingDistributionSummary) SetPriceClass(v string) *StreamingDistributionSummary {
	s.PriceClass = &v
	return s
}

// SetS3Origin sets the S3Origin field's value.
func (s *StreamingDistributionSummary) SetS3Origin(v *S3Origin) *StreamingDistributionSummary {
	s.S3Origin = v
	return s
}

// SetStatus sets the Status field's value.
func (s *StreamingDistributionSummary) SetStatus(v string) *StreamingDistributionSummary {
	s.Status = &v
	return s
}

// SetTrustedSigners sets the TrustedSigners field's value.
func (s *StreamingDistributionSummary) SetTrustedSigners(v *TrustedSigners) *StreamingDistributionSummary {
	s.TrustedSigners = v
	return s
}

// A complex type that controls whether access logs are written for this streaming
// distribution.
type StreamingLoggingConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to store the access logs in, for example, myawslogbucket.s3.amazonaws.com.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Specifies whether you want CloudFront to save access logs to an Amazon S3
	// bucket. If you don't want to enable logging when you create a streaming distribution
	// or if you want to disable logging for an existing streaming distribution,
	// specify false for Enabled, and specify empty Bucket and Prefix elements.
	// If you specify false for Enabled but you specify values for Bucket and Prefix,
	// the values are automatically deleted.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// An optional string that you want CloudFront to prefix to the access log filenames
	// for this streaming distribution, for example, myprefix/. If you want to enable
	// logging, but you don't want to specify a prefix, you still must include an
	// empty Prefix element in the Logging element.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StreamingLoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingLoggingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingLoggingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamingLoggingConfig"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *StreamingLoggingConfig) SetBucket(v string) *StreamingLoggingConfig {
	s.Bucket = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *StreamingLoggingConfig) SetEnabled(v bool) *StreamingLoggingConfig {
	s.Enabled = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *StreamingLoggingConfig) SetPrefix(v string) *StreamingLoggingConfig {
	s.Prefix = &v
	return s
}

// A complex type that contains Tag key and Tag value.
type Tag struct {
	_ struct{} `type:"structure"`

	// A string that contains Tag key.
	//
	// The string length should be between 1 and 128 characters. Valid characters
	// include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// A string that contains an optional Tag value.
	//
	// The string length should be between 0 and 256 characters. Valid characters
	// include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// A complex type that contains zero or more Tag elements.
type TagKeys struct {
	_ struct{} `type:"structure"`

	// A complex type that contains Tag key elements.
	Items []*string `locationNameList:"Key" type:"list"`
}

// String returns the string representation
func (s TagKeys) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagKeys) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *TagKeys) SetItems(v []*string) *TagKeys {
	s.Items = v
	return s
}

// The request to add tags to a CloudFront resource.
type TagResourceInput struct {
	_ struct{} `locationName:"TagResourceRequest" type:"structure" payload:"Tags"`

	// An ARN of a CloudFront resource.
	//
	// Resource is a required field
	Resource *string `location:"querystring" locationName:"Resource" type:"string" required:"true"`

	// A complex type that contains zero or more Tag elements.
	//
	// Tags is a required field
	Tags *Tags `locationName:"Tags" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		if err := s.Tags.Validate(); err != nil {
			invalidParams.AddNested("Tags", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *TagResourceInput) SetResource(v string) *TagResourceInput {
	s.Resource = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v *Tags) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A complex type that contains zero or more Tag elements.
type Tags struct {
	_ struct{} `type:"structure"`

	// A complex type that contains Tag elements.
	Items []*Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s Tags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tags) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tags) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tags"}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetItems sets the Items field's value.
func (s *Tags) SetItems(v []*Tag) *Tags {
	s.Items = v
	return s
}

// A complex type that specifies the AWS accounts, if any, that you want to
// allow to create signed URLs for private content.
//
// If you want to require signed URLs in requests for objects in the target
// origin that match the PathPattern for this cache behavior, specify true for
// Enabled, and specify the applicable values for Quantity and Items. For more
// information, see Serving Private Content through CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
// in the Amazon CloudFront Developer Guide.
//
// If you don't want to require signed URLs in requests for objects that match
// PathPattern, specify false for Enabled and 0 for Quantity. Omit Items.
//
// To add, change, or remove one or more trusted signers, change Enabled to
// true (if it's currently false), change Quantity as applicable, and specify
// all of the trusted signers that you want to include in the updated distribution.
//
// For more information about updating the distribution configuration, see DistributionConfig
// (https://docs.aws.amazon.com/cloudfront/latest/APIReference/DistributionConfig.html)
// in the Amazon CloudFront API Reference.
type TrustedSigners struct {
	_ struct{} `type:"structure"`

	// Specifies whether you want to require viewers to use signed URLs to access
	// the files specified by PathPattern and TargetOriginId.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Optional: A complex type that contains trusted signers for this cache behavior.
	// If Quantity is 0, you can omit Items.
	Items []*string `locationNameList:"AwsAccountNumber" type:"list"`

	// The number of trusted signers for this cache behavior.
	//
	// Quantity is a required field
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s TrustedSigners) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedSigners) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrustedSigners) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrustedSigners"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Quantity == nil {
		invalidParams.Add(request.NewErrParamRequired("Quantity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *TrustedSigners) SetEnabled(v bool) *TrustedSigners {
	s.Enabled = &v
	return s
}

// SetItems sets the Items field's value.
func (s *TrustedSigners) SetItems(v []*string) *TrustedSigners {
	s.Items = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *TrustedSigners) SetQuantity(v int64) *TrustedSigners {
	s.Quantity = &v
	return s
}

// The request to remove tags from a CloudFront resource.
type UntagResourceInput struct {
	_ struct{} `locationName:"UntagResourceRequest" type:"structure" payload:"TagKeys"`

	// An ARN of a CloudFront resource.
	//
	// Resource is a required field
	Resource *string `location:"querystring" locationName:"Resource" type:"string" required:"true"`

	// A complex type that contains zero or more Tag key elements.
	//
	// TagKeys is a required field
	TagKeys *TagKeys `locationName:"TagKeys" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *UntagResourceInput) SetResource(v string) *UntagResourceInput {
	s.Resource = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v *TagKeys) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The request to update an origin access identity.
type UpdateCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `locationName:"UpdateCloudFrontOriginAccessIdentityRequest" type:"structure" payload:"CloudFrontOriginAccessIdentityConfig"`

	// The identity's configuration information.
	//
	// CloudFrontOriginAccessIdentityConfig is a required field
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `locationName:"CloudFrontOriginAccessIdentityConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`

	// The identity's id.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the identity's
	// configuration. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCloudFrontOriginAccessIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCloudFrontOriginAccessIdentityInput"}
	if s.CloudFrontOriginAccessIdentityConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudFrontOriginAccessIdentityConfig"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.CloudFrontOriginAccessIdentityConfig != nil {
		if err := s.CloudFrontOriginAccessIdentityConfig.Validate(); err != nil {
			invalidParams.AddNested("CloudFrontOriginAccessIdentityConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFrontOriginAccessIdentityConfig sets the CloudFrontOriginAccessIdentityConfig field's value.
func (s *UpdateCloudFrontOriginAccessIdentityInput) SetCloudFrontOriginAccessIdentityConfig(v *OriginAccessIdentityConfig) *UpdateCloudFrontOriginAccessIdentityInput {
	s.CloudFrontOriginAccessIdentityConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateCloudFrontOriginAccessIdentityInput) SetId(v string) *UpdateCloudFrontOriginAccessIdentityInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateCloudFrontOriginAccessIdentityInput) SetIfMatch(v string) *UpdateCloudFrontOriginAccessIdentityInput {
	s.IfMatch = &v
	return s
}

// The returned result of the corresponding request.
type UpdateCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentity"`

	// The origin access identity's information.
	CloudFrontOriginAccessIdentity *OriginAccessIdentity `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// SetCloudFrontOriginAccessIdentity sets the CloudFrontOriginAccessIdentity field's value.
func (s *UpdateCloudFrontOriginAccessIdentityOutput) SetCloudFrontOriginAccessIdentity(v *OriginAccessIdentity) *UpdateCloudFrontOriginAccessIdentityOutput {
	s.CloudFrontOriginAccessIdentity = v
	return s
}

// SetETag sets the ETag field's value.
func (s *UpdateCloudFrontOriginAccessIdentityOutput) SetETag(v string) *UpdateCloudFrontOriginAccessIdentityOutput {
	s.ETag = &v
	return s
}

// The request to update a distribution.
type UpdateDistributionInput struct {
	_ struct{} `locationName:"UpdateDistributionRequest" type:"structure" payload:"DistributionConfig"`

	// The distribution's configuration information.
	//
	// DistributionConfig is a required field
	DistributionConfig *DistributionConfig `locationName:"DistributionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`

	// The distribution's id.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the distribution's
	// configuration. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDistributionInput"}
	if s.DistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DistributionConfig"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.DistributionConfig != nil {
		if err := s.DistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("DistributionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDistributionConfig sets the DistributionConfig field's value.
func (s *UpdateDistributionInput) SetDistributionConfig(v *DistributionConfig) *UpdateDistributionInput {
	s.DistributionConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateDistributionInput) SetId(v string) *UpdateDistributionInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateDistributionInput) SetIfMatch(v string) *UpdateDistributionInput {
	s.IfMatch = &v
	return s
}

// The returned result of the corresponding request.
type UpdateDistributionOutput struct {
	_ struct{} `type:"structure" payload:"Distribution"`

	// The distribution's information.
	Distribution *Distribution `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s UpdateDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDistributionOutput) GoString() string {
	return s.String()
}

// SetDistribution sets the Distribution field's value.
func (s *UpdateDistributionOutput) SetDistribution(v *Distribution) *UpdateDistributionOutput {
	s.Distribution = v
	return s
}

// SetETag sets the ETag field's value.
func (s *UpdateDistributionOutput) SetETag(v string) *UpdateDistributionOutput {
	s.ETag = &v
	return s
}

type UpdateFieldLevelEncryptionConfigInput struct {
	_ struct{} `locationName:"UpdateFieldLevelEncryptionConfigRequest" type:"structure" payload:"FieldLevelEncryptionConfig"`

	// Request to update a field-level encryption configuration.
	//
	// FieldLevelEncryptionConfig is a required field
	FieldLevelEncryptionConfig *FieldLevelEncryptionConfig `locationName:"FieldLevelEncryptionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`

	// The ID of the configuration you want to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the configuration
	// identity to update. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateFieldLevelEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFieldLevelEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFieldLevelEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFieldLevelEncryptionConfigInput"}
	if s.FieldLevelEncryptionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldLevelEncryptionConfig"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.FieldLevelEncryptionConfig != nil {
		if err := s.FieldLevelEncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("FieldLevelEncryptionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldLevelEncryptionConfig sets the FieldLevelEncryptionConfig field's value.
func (s *UpdateFieldLevelEncryptionConfigInput) SetFieldLevelEncryptionConfig(v *FieldLevelEncryptionConfig) *UpdateFieldLevelEncryptionConfigInput {
	s.FieldLevelEncryptionConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateFieldLevelEncryptionConfigInput) SetId(v string) *UpdateFieldLevelEncryptionConfigInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateFieldLevelEncryptionConfigInput) SetIfMatch(v string) *UpdateFieldLevelEncryptionConfigInput {
	s.IfMatch = &v
	return s
}

type UpdateFieldLevelEncryptionConfigOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryption"`

	// The value of the ETag header that you received when updating the configuration.
	// For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the results of updating the configuration.
	FieldLevelEncryption *FieldLevelEncryption `type:"structure"`
}

// String returns the string representation
func (s UpdateFieldLevelEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFieldLevelEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UpdateFieldLevelEncryptionConfigOutput) SetETag(v string) *UpdateFieldLevelEncryptionConfigOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryption sets the FieldLevelEncryption field's value.
func (s *UpdateFieldLevelEncryptionConfigOutput) SetFieldLevelEncryption(v *FieldLevelEncryption) *UpdateFieldLevelEncryptionConfigOutput {
	s.FieldLevelEncryption = v
	return s
}

type UpdateFieldLevelEncryptionProfileInput struct {
	_ struct{} `locationName:"UpdateFieldLevelEncryptionProfileRequest" type:"structure" payload:"FieldLevelEncryptionProfileConfig"`

	// Request to update a field-level encryption profile.
	//
	// FieldLevelEncryptionProfileConfig is a required field
	FieldLevelEncryptionProfileConfig *FieldLevelEncryptionProfileConfig `locationName:"FieldLevelEncryptionProfileConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`

	// The ID of the field-level encryption profile request.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the profile
	// identity to update. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateFieldLevelEncryptionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFieldLevelEncryptionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFieldLevelEncryptionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFieldLevelEncryptionProfileInput"}
	if s.FieldLevelEncryptionProfileConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldLevelEncryptionProfileConfig"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.FieldLevelEncryptionProfileConfig != nil {
		if err := s.FieldLevelEncryptionProfileConfig.Validate(); err != nil {
			invalidParams.AddNested("FieldLevelEncryptionProfileConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldLevelEncryptionProfileConfig sets the FieldLevelEncryptionProfileConfig field's value.
func (s *UpdateFieldLevelEncryptionProfileInput) SetFieldLevelEncryptionProfileConfig(v *FieldLevelEncryptionProfileConfig) *UpdateFieldLevelEncryptionProfileInput {
	s.FieldLevelEncryptionProfileConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateFieldLevelEncryptionProfileInput) SetId(v string) *UpdateFieldLevelEncryptionProfileInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateFieldLevelEncryptionProfileInput) SetIfMatch(v string) *UpdateFieldLevelEncryptionProfileInput {
	s.IfMatch = &v
	return s
}

type UpdateFieldLevelEncryptionProfileOutput struct {
	_ struct{} `type:"structure" payload:"FieldLevelEncryptionProfile"`

	// The result of the field-level encryption profile request.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the results of updating the profile.
	FieldLevelEncryptionProfile *FieldLevelEncryptionProfile `type:"structure"`
}

// String returns the string representation
func (s UpdateFieldLevelEncryptionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFieldLevelEncryptionProfileOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UpdateFieldLevelEncryptionProfileOutput) SetETag(v string) *UpdateFieldLevelEncryptionProfileOutput {
	s.ETag = &v
	return s
}

// SetFieldLevelEncryptionProfile sets the FieldLevelEncryptionProfile field's value.
func (s *UpdateFieldLevelEncryptionProfileOutput) SetFieldLevelEncryptionProfile(v *FieldLevelEncryptionProfile) *UpdateFieldLevelEncryptionProfileOutput {
	s.FieldLevelEncryptionProfile = v
	return s
}

type UpdatePublicKeyInput struct {
	_ struct{} `locationName:"UpdatePublicKeyRequest" type:"structure" payload:"PublicKeyConfig"`

	// ID of the public key to be updated.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the public
	// key to update. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Request to update public key information.
	//
	// PublicKeyConfig is a required field
	PublicKeyConfig *PublicKeyConfig `locationName:"PublicKeyConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s UpdatePublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePublicKeyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.PublicKeyConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyConfig"))
	}
	if s.PublicKeyConfig != nil {
		if err := s.PublicKeyConfig.Validate(); err != nil {
			invalidParams.AddNested("PublicKeyConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdatePublicKeyInput) SetId(v string) *UpdatePublicKeyInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdatePublicKeyInput) SetIfMatch(v string) *UpdatePublicKeyInput {
	s.IfMatch = &v
	return s
}

// SetPublicKeyConfig sets the PublicKeyConfig field's value.
func (s *UpdatePublicKeyInput) SetPublicKeyConfig(v *PublicKeyConfig) *UpdatePublicKeyInput {
	s.PublicKeyConfig = v
	return s
}

type UpdatePublicKeyOutput struct {
	_ struct{} `type:"structure" payload:"PublicKey"`

	// The current version of the update public key result. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// Return the results of updating the public key.
	PublicKey *PublicKey `type:"structure"`
}

// String returns the string representation
func (s UpdatePublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePublicKeyOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UpdatePublicKeyOutput) SetETag(v string) *UpdatePublicKeyOutput {
	s.ETag = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *UpdatePublicKeyOutput) SetPublicKey(v *PublicKey) *UpdatePublicKeyOutput {
	s.PublicKey = v
	return s
}

// The request to update a streaming distribution.
type UpdateStreamingDistributionInput struct {
	_ struct{} `locationName:"UpdateStreamingDistributionRequest" type:"structure" payload:"StreamingDistributionConfig"`

	// The streaming distribution's id.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the streaming
	// distribution's configuration. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// The streaming distribution's configuration information.
	//
	// StreamingDistributionConfig is a required field
	StreamingDistributionConfig *StreamingDistributionConfig `locationName:"StreamingDistributionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2019-03-26/"`
}

// String returns the string representation
func (s UpdateStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStreamingDistributionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStreamingDistributionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStreamingDistributionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.StreamingDistributionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingDistributionConfig"))
	}
	if s.StreamingDistributionConfig != nil {
		if err := s.StreamingDistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("StreamingDistributionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateStreamingDistributionInput) SetId(v string) *UpdateStreamingDistributionInput {
	s.Id = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *UpdateStreamingDistributionInput) SetIfMatch(v string) *UpdateStreamingDistributionInput {
	s.IfMatch = &v
	return s
}

// SetStreamingDistributionConfig sets the StreamingDistributionConfig field's value.
func (s *UpdateStreamingDistributionInput) SetStreamingDistributionConfig(v *StreamingDistributionConfig) *UpdateStreamingDistributionInput {
	s.StreamingDistributionConfig = v
	return s
}

// The returned result of the corresponding request.
type UpdateStreamingDistributionOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s UpdateStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStreamingDistributionOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UpdateStreamingDistributionOutput) SetETag(v string) *UpdateStreamingDistributionOutput {
	s.ETag = &v
	return s
}

// SetStreamingDistribution sets the StreamingDistribution field's value.
func (s *UpdateStreamingDistributionOutput) SetStreamingDistribution(v *StreamingDistribution) *UpdateStreamingDistributionOutput {
	s.StreamingDistribution = v
	return s
}

// A complex type that determines the distribution’s SSL/TLS configuration
// for communicating with viewers.
//
// If the distribution doesn’t use Aliases (also known as alternate domain
// names or CNAMEs)—that is, if the distribution uses the CloudFront domain
// name such as d111111abcdef8.cloudfront.net—set CloudFrontDefaultCertificate
// to true and leave all other fields empty.
//
// If the distribution uses Aliases (alternate domain names or CNAMEs), use
// the fields in this type to specify the following settings:
//
//    * Which viewers the distribution accepts HTTPS connections from: only
//    viewers that support server name indication (SNI) (https://en.wikipedia.org/wiki/Server_Name_Indication)
//    (recommended), or all viewers including those that don’t support SNI.
//    To accept HTTPS connections from only viewers that support SNI, set SSLSupportMethod
//    to sni-only. This is recommended. Most browsers and clients released after
//    2010 support SNI. To accept HTTPS connections from all viewers, including
//    those that don’t support SNI, set SSLSupportMethod to vip. This is not
//    recommended, and results in additional monthly charges from CloudFront.
//
//    * The minimum SSL/TLS protocol version that the distribution can use to
//    communicate with viewers. To specify a minimum version, choose a value
//    for MinimumProtocolVersion. For more information, see Security Policy
//    (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy)
//    in the Amazon CloudFront Developer Guide.
//
//    * The location of the SSL/TLS certificate, AWS Certificate Manager (ACM)
//    (https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html) (recommended)
//    or AWS Identity and Access Management (AWS IAM) (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html).
//    You specify the location by setting a value in one of the following fields
//    (not both): ACMCertificateArn IAMCertificateId
//
// All distributions support HTTPS connections from viewers. To require viewers
// to use HTTPS only, or to redirect them from HTTP to HTTPS, use ViewerProtocolPolicy
// in the CacheBehavior or DefaultCacheBehavior. To specify how CloudFront should
// use SSL/TLS to communicate with your custom origin, use CustomOriginConfig.
//
// For more information, see Using HTTPS with CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html)
// and Using Alternate Domain Names and HTTPS (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html)
// in the Amazon CloudFront Developer Guide.
type ViewerCertificate struct {
	_ struct{} `type:"structure"`

	// If the distribution uses Aliases (alternate domain names or CNAMEs) and the
	// SSL/TLS certificate is stored in AWS Certificate Manager (ACM) (https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html),
	// provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront
	// only supports ACM certificates in the US East (N. Virginia) Region (us-east-1).
	//
	// If you specify an ACM certificate ARN, you must also specify values for MinimumProtocolVerison
	// and SSLSupportMethod.
	ACMCertificateArn *string `type:"string"`

	// This field is deprecated. Use one of the following fields instead:
	//
	//    * ACMCertificateArn
	//
	//    * IAMCertificateId
	//
	//    * CloudFrontDefaultCertificate
	//
	// Deprecated: Certificate has been deprecated
	Certificate *string `deprecated:"true" type:"string"`

	// This field is deprecated. Use one of the following fields instead:
	//
	//    * ACMCertificateArn
	//
	//    * IAMCertificateId
	//
	//    * CloudFrontDefaultCertificate
	//
	// Deprecated: CertificateSource has been deprecated
	CertificateSource *string `deprecated:"true" type:"string" enum:"CertificateSource"`

	// If the distribution uses the CloudFront domain name such as d111111abcdef8.cloudfront.net,
	// set this field to true.
	//
	// If the distribution uses Aliases (alternate domain names or CNAMEs), set
	// this field to false and specify values for the following fields:
	//
	//    * ACMCertificateArn or IAMCertificateId (specify a value for one, not
	//    both)
	//
	//    * MinimumProtocolVersion
	//
	//    * SSLSupportMethod
	CloudFrontDefaultCertificate *bool `type:"boolean"`

	// If the distribution uses Aliases (alternate domain names or CNAMEs) and the
	// SSL/TLS certificate is stored in AWS Identity and Access Management (AWS
	// IAM) (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html),
	// provide the ID of the IAM certificate.
	//
	// If you specify an IAM certificate ID, you must also specify values for MinimumProtocolVerison
	// and SSLSupportMethod.
	IAMCertificateId *string `type:"string"`

	// If the distribution uses Aliases (alternate domain names or CNAMEs), specify
	// the security policy that you want CloudFront to use for HTTPS connections
	// with viewers. The security policy determines two settings:
	//
	//    * The minimum SSL/TLS protocol that CloudFront can use to communicate
	//    with viewers.
	//
	//    * The ciphers that CloudFront can use to encrypt the content that it returns
	//    to viewers.
	//
	// For more information, see Security Policy (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy)
	// and Supported Protocols and Ciphers Between Viewers and CloudFront (https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers)
	// in the Amazon CloudFront Developer Guide.
	//
	// On the CloudFront console, this setting is called Security Policy.
	//
	// We recommend that you specify TLSv1.2_2018 unless your viewers are using
	// browsers or devices that don’t support TLSv1.2.
	//
	// When you’re using SNI only (you set SSLSupportMethod to sni-only), you
	// must specify TLSv1 or higher.
	//
	// If the distribution uses the CloudFront domain name such as d111111abcdef8.cloudfront.net
	// (you set CloudFrontDefaultCertificate to true), CloudFront automatically
	// sets the security policy to TLSv1 regardless of the value that you set here.
	MinimumProtocolVersion *string `type:"string" enum:"MinimumProtocolVersion"`

	// If the distribution uses Aliases (alternate domain names or CNAMEs), specify
	// which viewers the distribution accepts HTTPS connections from.
	//
	//    * sni-only – The distribution accepts HTTPS connections from only viewers
	//    that support server name indication (SNI) (https://en.wikipedia.org/wiki/Server_Name_Indication).
	//    This is recommended. Most browsers and clients released after 2010 support
	//    SNI.
	//
	//    * vip – The distribution accepts HTTPS connections from all viewers
	//    including those that don’t support SNI. This is not recommended, and
	//    results in additional monthly charges from CloudFront.
	//
	// If the distribution uses the CloudFront domain name such as d111111abcdef8.cloudfront.net,
	// don’t set a value for this field.
	SSLSupportMethod *string `type:"string" enum:"SSLSupportMethod"`
}

// String returns the string representation
func (s ViewerCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ViewerCertificate) GoString() string {
	return s.String()
}

// SetACMCertificateArn sets the ACMCertificateArn field's value.
func (s *ViewerCertificate) SetACMCertificateArn(v string) *ViewerCertificate {
	s.ACMCertificateArn = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *ViewerCertificate) SetCertificate(v string) *ViewerCertificate {
	s.Certificate = &v
	return s
}

// SetCertificateSource sets the CertificateSource field's value.
func (s *ViewerCertificate) SetCertificateSource(v string) *ViewerCertificate {
	s.CertificateSource = &v
	return s
}

// SetCloudFrontDefaultCertificate sets the CloudFrontDefaultCertificate field's value.
func (s *ViewerCertificate) SetCloudFrontDefaultCertificate(v bool) *ViewerCertificate {
	s.CloudFrontDefaultCertificate = &v
	return s
}

// SetIAMCertificateId sets the IAMCertificateId field's value.
func (s *ViewerCertificate) SetIAMCertificateId(v string) *ViewerCertificate {
	s.IAMCertificateId = &v
	return s
}

// SetMinimumProtocolVersion sets the MinimumProtocolVersion field's value.
func (s *ViewerCertificate) SetMinimumProtocolVersion(v string) *ViewerCertificate {
	s.MinimumProtocolVersion = &v
	return s
}

// SetSSLSupportMethod sets the SSLSupportMethod field's value.
func (s *ViewerCertificate) SetSSLSupportMethod(v string) *ViewerCertificate {
	s.SSLSupportMethod = &v
	return s
}

const (
	// CertificateSourceCloudfront is a CertificateSource enum value
	CertificateSourceCloudfront = "cloudfront"

	// CertificateSourceIam is a CertificateSource enum value
	CertificateSourceIam = "iam"

	// CertificateSourceAcm is a CertificateSource enum value
	CertificateSourceAcm = "acm"
)

const (
	// EventTypeViewerRequest is a EventType enum value
	EventTypeViewerRequest = "viewer-request"

	// EventTypeViewerResponse is a EventType enum value
	EventTypeViewerResponse = "viewer-response"

	// EventTypeOriginRequest is a EventType enum value
	EventTypeOriginRequest = "origin-request"

	// EventTypeOriginResponse is a EventType enum value
	EventTypeOriginResponse = "origin-response"
)

const (
	// FormatUrlencoded is a Format enum value
	FormatUrlencoded = "URLEncoded"
)

const (
	// GeoRestrictionTypeBlacklist is a GeoRestrictionType enum value
	GeoRestrictionTypeBlacklist = "blacklist"

	// GeoRestrictionTypeWhitelist is a GeoRestrictionType enum value
	GeoRestrictionTypeWhitelist = "whitelist"

	// GeoRestrictionTypeNone is a GeoRestrictionType enum value
	GeoRestrictionTypeNone = "none"
)

const (
	// HttpVersionHttp11 is a HttpVersion enum value
	HttpVersionHttp11 = "http1.1"

	// HttpVersionHttp2 is a HttpVersion enum value
	HttpVersionHttp2 = "http2"
)

const (
	// ICPRecordalStatusApproved is a ICPRecordalStatus enum value
	ICPRecordalStatusApproved = "APPROVED"

	// ICPRecordalStatusSuspended is a ICPRecordalStatus enum value
	ICPRecordalStatusSuspended = "SUSPENDED"

	// ICPRecordalStatusPending is a ICPRecordalStatus enum value
	ICPRecordalStatusPending = "PENDING"
)

const (
	// ItemSelectionNone is a ItemSelection enum value
	ItemSelectionNone = "none"

	// ItemSelectionWhitelist is a ItemSelection enum value
	ItemSelectionWhitelist = "whitelist"

	// ItemSelectionAll is a ItemSelection enum value
	ItemSelectionAll = "all"
)

const (
	// MethodGet is a Method enum value
	MethodGet = "GET"

	// MethodHead is a Method enum value
	MethodHead = "HEAD"

	// MethodPost is a Method enum value
	MethodPost = "POST"

	// MethodPut is a Method enum value
	MethodPut = "PUT"

	// MethodPatch is a Method enum value
	MethodPatch = "PATCH"

	// MethodOptions is a Method enum value
	MethodOptions = "OPTIONS"

	// MethodDelete is a Method enum value
	MethodDelete = "DELETE"
)

const (
	// MinimumProtocolVersionSslv3 is a MinimumProtocolVersion enum value
	MinimumProtocolVersionSslv3 = "SSLv3"

	// MinimumProtocolVersionTlsv1 is a MinimumProtocolVersion enum value
	MinimumProtocolVersionTlsv1 = "TLSv1"

	// MinimumProtocolVersionTlsv12016 is a MinimumProtocolVersion enum value
	MinimumProtocolVersionTlsv12016 = "TLSv1_2016"

	// MinimumProtocolVersionTlsv112016 is a MinimumProtocolVersion enum value
	MinimumProtocolVersionTlsv112016 = "TLSv1.1_2016"

	// MinimumProtocolVersionTlsv122018 is a MinimumProtocolVersion enum value
	MinimumProtocolVersionTlsv122018 = "TLSv1.2_2018"
)

const (
	// OriginProtocolPolicyHttpOnly is a OriginProtocolPolicy enum value
	OriginProtocolPolicyHttpOnly = "http-only"

	// OriginProtocolPolicyMatchViewer is a OriginProtocolPolicy enum value
	OriginProtocolPolicyMatchViewer = "match-viewer"

	// OriginProtocolPolicyHttpsOnly is a OriginProtocolPolicy enum value
	OriginProtocolPolicyHttpsOnly = "https-only"
)

const (
	// PriceClassPriceClass100 is a PriceClass enum value
	PriceClassPriceClass100 = "PriceClass_100"

	// PriceClassPriceClass200 is a PriceClass enum value
	PriceClassPriceClass200 = "PriceClass_200"

	// PriceClassPriceClassAll is a PriceClass enum value
	PriceClassPriceClassAll = "PriceClass_All"
)

const (
	// SSLSupportMethodSniOnly is a SSLSupportMethod enum value
	SSLSupportMethodSniOnly = "sni-only"

	// SSLSupportMethodVip is a SSLSupportMethod enum value
	SSLSupportMethodVip = "vip"
)

const (
	// SslProtocolSslv3 is a SslProtocol enum value
	SslProtocolSslv3 = "SSLv3"

	// SslProtocolTlsv1 is a SslProtocol enum value
	SslProtocolTlsv1 = "TLSv1"

	// SslProtocolTlsv11 is a SslProtocol enum value
	SslProtocolTlsv11 = "TLSv1.1"

	// SslProtocolTlsv12 is a SslProtocol enum value
	SslProtocolTlsv12 = "TLSv1.2"
)

const (
	// ViewerProtocolPolicyAllowAll is a ViewerProtocolPolicy enum value
	ViewerProtocolPolicyAllowAll = "allow-all"

	// ViewerProtocolPolicyHttpsOnly is a ViewerProtocolPolicy enum value
	ViewerProtocolPolicyHttpsOnly = "https-only"

	// ViewerProtocolPolicyRedirectToHttps is a ViewerProtocolPolicy enum value
	ViewerProtocolPolicyRedirectToHttps = "redirect-to-https"
)
