// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/bigquery/storage/v1beta2/storage.proto

package storage

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for `CreateReadSession`.
type CreateReadSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The request project that owns the session, in the form of
	// `projects/{project_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Session to be created.
	ReadSession *ReadSession `protobuf:"bytes,2,opt,name=read_session,json=readSession,proto3" json:"read_session,omitempty"`
	// Max initial number of streams. If unset or zero, the server will
	// provide a value of streams so as to produce reasonable throughput. Must be
	// non-negative. The number of streams may be lower than the requested number,
	// depending on the amount parallelism that is reasonable for the table. Error
	// will be returned if the max count is greater than the current system
	// max limit of 1,000.
	//
	// Streams must be read starting from offset 0.
	MaxStreamCount int32 `protobuf:"varint,3,opt,name=max_stream_count,json=maxStreamCount,proto3" json:"max_stream_count,omitempty"`
}

func (x *CreateReadSessionRequest) Reset() {
	*x = CreateReadSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateReadSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReadSessionRequest) ProtoMessage() {}

func (x *CreateReadSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReadSessionRequest.ProtoReflect.Descriptor instead.
func (*CreateReadSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{0}
}

func (x *CreateReadSessionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReadSessionRequest) GetReadSession() *ReadSession {
	if x != nil {
		return x.ReadSession
	}
	return nil
}

func (x *CreateReadSessionRequest) GetMaxStreamCount() int32 {
	if x != nil {
		return x.MaxStreamCount
	}
	return 0
}

// Request message for `ReadRows`.
type ReadRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Stream to read rows from.
	ReadStream string `protobuf:"bytes,1,opt,name=read_stream,json=readStream,proto3" json:"read_stream,omitempty"`
	// The offset requested must be less than the last row read from Read.
	// Requesting a larger offset is undefined. If not specified, start reading
	// from offset zero.
	Offset int64 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *ReadRowsRequest) Reset() {
	*x = ReadRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRowsRequest) ProtoMessage() {}

func (x *ReadRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRowsRequest.ProtoReflect.Descriptor instead.
func (*ReadRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{1}
}

func (x *ReadRowsRequest) GetReadStream() string {
	if x != nil {
		return x.ReadStream
	}
	return ""
}

func (x *ReadRowsRequest) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// Information on if the current connection is being throttled.
type ThrottleState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How much this connection is being throttled. Zero means no throttling,
	// 100 means fully throttled.
	ThrottlePercent int32 `protobuf:"varint,1,opt,name=throttle_percent,json=throttlePercent,proto3" json:"throttle_percent,omitempty"`
}

func (x *ThrottleState) Reset() {
	*x = ThrottleState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ThrottleState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ThrottleState) ProtoMessage() {}

func (x *ThrottleState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ThrottleState.ProtoReflect.Descriptor instead.
func (*ThrottleState) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{2}
}

func (x *ThrottleState) GetThrottlePercent() int32 {
	if x != nil {
		return x.ThrottlePercent
	}
	return 0
}

// Estimated stream statistics for a given Stream.
type StreamStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the progress of the current stream.
	Progress *StreamStats_Progress `protobuf:"bytes,2,opt,name=progress,proto3" json:"progress,omitempty"`
}

func (x *StreamStats) Reset() {
	*x = StreamStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamStats) ProtoMessage() {}

func (x *StreamStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamStats.ProtoReflect.Descriptor instead.
func (*StreamStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{3}
}

func (x *StreamStats) GetProgress() *StreamStats_Progress {
	if x != nil {
		return x.Progress
	}
	return nil
}

// Response from calling `ReadRows` may include row data, progress and
// throttling information.
type ReadRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Row data is returned in format specified during session creation.
	//
	// Types that are assignable to Rows:
	//	*ReadRowsResponse_AvroRows
	//	*ReadRowsResponse_ArrowRecordBatch
	Rows isReadRowsResponse_Rows `protobuf_oneof:"rows"`
	// Number of serialized rows in the rows block.
	RowCount int64 `protobuf:"varint,6,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// Statistics for the stream.
	Stats *StreamStats `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
	// Throttling state. If unset, the latest response still describes
	// the current throttling status.
	ThrottleState *ThrottleState `protobuf:"bytes,5,opt,name=throttle_state,json=throttleState,proto3" json:"throttle_state,omitempty"`
}

func (x *ReadRowsResponse) Reset() {
	*x = ReadRowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRowsResponse) ProtoMessage() {}

func (x *ReadRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRowsResponse.ProtoReflect.Descriptor instead.
func (*ReadRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{4}
}

func (m *ReadRowsResponse) GetRows() isReadRowsResponse_Rows {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (x *ReadRowsResponse) GetAvroRows() *AvroRows {
	if x, ok := x.GetRows().(*ReadRowsResponse_AvroRows); ok {
		return x.AvroRows
	}
	return nil
}

func (x *ReadRowsResponse) GetArrowRecordBatch() *ArrowRecordBatch {
	if x, ok := x.GetRows().(*ReadRowsResponse_ArrowRecordBatch); ok {
		return x.ArrowRecordBatch
	}
	return nil
}

func (x *ReadRowsResponse) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *ReadRowsResponse) GetStats() *StreamStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

func (x *ReadRowsResponse) GetThrottleState() *ThrottleState {
	if x != nil {
		return x.ThrottleState
	}
	return nil
}

type isReadRowsResponse_Rows interface {
	isReadRowsResponse_Rows()
}

type ReadRowsResponse_AvroRows struct {
	// Serialized row data in AVRO format.
	AvroRows *AvroRows `protobuf:"bytes,3,opt,name=avro_rows,json=avroRows,proto3,oneof"`
}

type ReadRowsResponse_ArrowRecordBatch struct {
	// Serialized row data in Arrow RecordBatch format.
	ArrowRecordBatch *ArrowRecordBatch `protobuf:"bytes,4,opt,name=arrow_record_batch,json=arrowRecordBatch,proto3,oneof"`
}

func (*ReadRowsResponse_AvroRows) isReadRowsResponse_Rows() {}

func (*ReadRowsResponse_ArrowRecordBatch) isReadRowsResponse_Rows() {}

// Request message for `SplitReadStream`.
type SplitReadStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the stream to split.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A value in the range (0.0, 1.0) that specifies the fractional point at
	// which the original stream should be split. The actual split point is
	// evaluated on pre-filtered rows, so if a filter is provided, then there is
	// no guarantee that the division of the rows between the new child streams
	// will be proportional to this fractional value. Additionally, because the
	// server-side unit for assigning data is collections of rows, this fraction
	// will always map to a data storage boundary on the server side.
	Fraction float64 `protobuf:"fixed64,2,opt,name=fraction,proto3" json:"fraction,omitempty"`
}

func (x *SplitReadStreamRequest) Reset() {
	*x = SplitReadStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitReadStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitReadStreamRequest) ProtoMessage() {}

func (x *SplitReadStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitReadStreamRequest.ProtoReflect.Descriptor instead.
func (*SplitReadStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{5}
}

func (x *SplitReadStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SplitReadStreamRequest) GetFraction() float64 {
	if x != nil {
		return x.Fraction
	}
	return 0
}

type SplitReadStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Primary stream, which contains the beginning portion of
	// |original_stream|. An empty value indicates that the original stream can no
	// longer be split.
	PrimaryStream *ReadStream `protobuf:"bytes,1,opt,name=primary_stream,json=primaryStream,proto3" json:"primary_stream,omitempty"`
	// Remainder stream, which contains the tail of |original_stream|. An empty
	// value indicates that the original stream can no longer be split.
	RemainderStream *ReadStream `protobuf:"bytes,2,opt,name=remainder_stream,json=remainderStream,proto3" json:"remainder_stream,omitempty"`
}

func (x *SplitReadStreamResponse) Reset() {
	*x = SplitReadStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitReadStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitReadStreamResponse) ProtoMessage() {}

func (x *SplitReadStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitReadStreamResponse.ProtoReflect.Descriptor instead.
func (*SplitReadStreamResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{6}
}

func (x *SplitReadStreamResponse) GetPrimaryStream() *ReadStream {
	if x != nil {
		return x.PrimaryStream
	}
	return nil
}

func (x *SplitReadStreamResponse) GetRemainderStream() *ReadStream {
	if x != nil {
		return x.RemainderStream
	}
	return nil
}

// Request message for `CreateWriteStream`.
type CreateWriteStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Reference to the table to which the stream belongs, in the format
	// of `projects/{project}/datasets/{dataset}/tables/{table}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Stream to be created.
	WriteStream *WriteStream `protobuf:"bytes,2,opt,name=write_stream,json=writeStream,proto3" json:"write_stream,omitempty"`
}

func (x *CreateWriteStreamRequest) Reset() {
	*x = CreateWriteStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWriteStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWriteStreamRequest) ProtoMessage() {}

func (x *CreateWriteStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWriteStreamRequest.ProtoReflect.Descriptor instead.
func (*CreateWriteStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{7}
}

func (x *CreateWriteStreamRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWriteStreamRequest) GetWriteStream() *WriteStream {
	if x != nil {
		return x.WriteStream
	}
	return nil
}

// Request message for `AppendRows`.
type AppendRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The stream that is the target of the append operation. This value
	// must be specified for the initial request. If subsequent requests specify
	// the stream name, it must equal to the value provided in the first request.
	// To write to the _default stream, populate this field with a string in the
	// format `projects/{project}/datasets/{dataset}/tables/{table}/_default`.
	WriteStream string `protobuf:"bytes,1,opt,name=write_stream,json=writeStream,proto3" json:"write_stream,omitempty"`
	// If present, the write is only performed if the next append offset is same
	// as the provided value. If not present, the write is performed at the
	// current end of stream. Specifying a value for this field is not allowed
	// when calling AppendRows for the '_default' stream.
	Offset *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// Input rows. The `writer_schema` field must be specified at the initial
	// request and currently, it will be ignored if specified in following
	// requests. Following requests must have data in the same format as the
	// initial request.
	//
	// Types that are assignable to Rows:
	//	*AppendRowsRequest_ProtoRows
	Rows isAppendRowsRequest_Rows `protobuf_oneof:"rows"`
	// Only initial request setting is respected. If true, drop unknown input
	// fields. Otherwise, the extra fields will cause append to fail. Default
	// value is false.
	IgnoreUnknownFields bool `protobuf:"varint,5,opt,name=ignore_unknown_fields,json=ignoreUnknownFields,proto3" json:"ignore_unknown_fields,omitempty"`
}

func (x *AppendRowsRequest) Reset() {
	*x = AppendRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppendRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppendRowsRequest) ProtoMessage() {}

func (x *AppendRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppendRowsRequest.ProtoReflect.Descriptor instead.
func (*AppendRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{8}
}

func (x *AppendRowsRequest) GetWriteStream() string {
	if x != nil {
		return x.WriteStream
	}
	return ""
}

func (x *AppendRowsRequest) GetOffset() *wrapperspb.Int64Value {
	if x != nil {
		return x.Offset
	}
	return nil
}

func (m *AppendRowsRequest) GetRows() isAppendRowsRequest_Rows {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (x *AppendRowsRequest) GetProtoRows() *AppendRowsRequest_ProtoData {
	if x, ok := x.GetRows().(*AppendRowsRequest_ProtoRows); ok {
		return x.ProtoRows
	}
	return nil
}

func (x *AppendRowsRequest) GetIgnoreUnknownFields() bool {
	if x != nil {
		return x.IgnoreUnknownFields
	}
	return false
}

type isAppendRowsRequest_Rows interface {
	isAppendRowsRequest_Rows()
}

type AppendRowsRequest_ProtoRows struct {
	// Rows in proto format.
	ProtoRows *AppendRowsRequest_ProtoData `protobuf:"bytes,4,opt,name=proto_rows,json=protoRows,proto3,oneof"`
}

func (*AppendRowsRequest_ProtoRows) isAppendRowsRequest_Rows() {}

// Response message for `AppendRows`.
type AppendRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Response:
	//	*AppendRowsResponse_Offset
	//	*AppendRowsResponse_Error
	Response isAppendRowsResponse_Response `protobuf_oneof:"response"`
	// If backend detects a schema update, pass it to user so that user can
	// use it to input new type of message. It will be empty when there is no
	// schema updates.
	UpdatedSchema *TableSchema `protobuf:"bytes,3,opt,name=updated_schema,json=updatedSchema,proto3" json:"updated_schema,omitempty"`
}

func (x *AppendRowsResponse) Reset() {
	*x = AppendRowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppendRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppendRowsResponse) ProtoMessage() {}

func (x *AppendRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppendRowsResponse.ProtoReflect.Descriptor instead.
func (*AppendRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{9}
}

func (m *AppendRowsResponse) GetResponse() isAppendRowsResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *AppendRowsResponse) GetOffset() int64 {
	if x, ok := x.GetResponse().(*AppendRowsResponse_Offset); ok {
		return x.Offset
	}
	return 0
}

func (x *AppendRowsResponse) GetError() *status.Status {
	if x, ok := x.GetResponse().(*AppendRowsResponse_Error); ok {
		return x.Error
	}
	return nil
}

func (x *AppendRowsResponse) GetUpdatedSchema() *TableSchema {
	if x != nil {
		return x.UpdatedSchema
	}
	return nil
}

type isAppendRowsResponse_Response interface {
	isAppendRowsResponse_Response()
}

type AppendRowsResponse_Offset struct {
	// The row offset at which the last append occurred.
	Offset int64 `protobuf:"varint,1,opt,name=offset,proto3,oneof"`
}

type AppendRowsResponse_Error struct {
	// Error in case of append failure. If set, it means rows are not accepted
	// into the system. Users can retry within the same connection.
	Error *status.Status `protobuf:"bytes,2,opt,name=error,proto3,oneof"`
}

func (*AppendRowsResponse_Offset) isAppendRowsResponse_Response() {}

func (*AppendRowsResponse_Error) isAppendRowsResponse_Response() {}

// Request message for `GetWriteStreamRequest`.
type GetWriteStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the stream to get, in the form of
	// `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWriteStreamRequest) Reset() {
	*x = GetWriteStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWriteStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWriteStreamRequest) ProtoMessage() {}

func (x *GetWriteStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWriteStreamRequest.ProtoReflect.Descriptor instead.
func (*GetWriteStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{10}
}

func (x *GetWriteStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `BatchCommitWriteStreams`.
type BatchCommitWriteStreamsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent table that all the streams should belong to, in the form
	// of `projects/{project}/datasets/{dataset}/tables/{table}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The group of streams that will be committed atomically.
	WriteStreams []string `protobuf:"bytes,2,rep,name=write_streams,json=writeStreams,proto3" json:"write_streams,omitempty"`
}

func (x *BatchCommitWriteStreamsRequest) Reset() {
	*x = BatchCommitWriteStreamsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCommitWriteStreamsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCommitWriteStreamsRequest) ProtoMessage() {}

func (x *BatchCommitWriteStreamsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCommitWriteStreamsRequest.ProtoReflect.Descriptor instead.
func (*BatchCommitWriteStreamsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{11}
}

func (x *BatchCommitWriteStreamsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCommitWriteStreamsRequest) GetWriteStreams() []string {
	if x != nil {
		return x.WriteStreams
	}
	return nil
}

// Response message for `BatchCommitWriteStreams`.
type BatchCommitWriteStreamsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time at which streams were committed in microseconds granularity.
	CommitTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=commit_time,json=commitTime,proto3" json:"commit_time,omitempty"`
}

func (x *BatchCommitWriteStreamsResponse) Reset() {
	*x = BatchCommitWriteStreamsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCommitWriteStreamsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCommitWriteStreamsResponse) ProtoMessage() {}

func (x *BatchCommitWriteStreamsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCommitWriteStreamsResponse.ProtoReflect.Descriptor instead.
func (*BatchCommitWriteStreamsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{12}
}

func (x *BatchCommitWriteStreamsResponse) GetCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTime
	}
	return nil
}

// Request message for invoking `FinalizeWriteStream`.
type FinalizeWriteStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the stream to finalize, in the form of
	// `projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FinalizeWriteStreamRequest) Reset() {
	*x = FinalizeWriteStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeWriteStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeWriteStreamRequest) ProtoMessage() {}

func (x *FinalizeWriteStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeWriteStreamRequest.ProtoReflect.Descriptor instead.
func (*FinalizeWriteStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{13}
}

func (x *FinalizeWriteStreamRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for `FinalizeWriteStream`.
type FinalizeWriteStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of rows in the finalized stream.
	RowCount int64 `protobuf:"varint,1,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
}

func (x *FinalizeWriteStreamResponse) Reset() {
	*x = FinalizeWriteStreamResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeWriteStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeWriteStreamResponse) ProtoMessage() {}

func (x *FinalizeWriteStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeWriteStreamResponse.ProtoReflect.Descriptor instead.
func (*FinalizeWriteStreamResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{14}
}

func (x *FinalizeWriteStreamResponse) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

// Request message for `FlushRows`.
type FlushRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The stream that is the target of the flush operation.
	WriteStream string `protobuf:"bytes,1,opt,name=write_stream,json=writeStream,proto3" json:"write_stream,omitempty"`
	// Ending offset of the flush operation. Rows before this offset(including
	// this offset) will be flushed.
	Offset *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *FlushRowsRequest) Reset() {
	*x = FlushRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FlushRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlushRowsRequest) ProtoMessage() {}

func (x *FlushRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlushRowsRequest.ProtoReflect.Descriptor instead.
func (*FlushRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{15}
}

func (x *FlushRowsRequest) GetWriteStream() string {
	if x != nil {
		return x.WriteStream
	}
	return ""
}

func (x *FlushRowsRequest) GetOffset() *wrapperspb.Int64Value {
	if x != nil {
		return x.Offset
	}
	return nil
}

// Respond message for `FlushRows`.
type FlushRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The rows before this offset (including this offset) are flushed.
	Offset int64 `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *FlushRowsResponse) Reset() {
	*x = FlushRowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FlushRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlushRowsResponse) ProtoMessage() {}

func (x *FlushRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlushRowsResponse.ProtoReflect.Descriptor instead.
func (*FlushRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{16}
}

func (x *FlushRowsResponse) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

type StreamStats_Progress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fraction of rows assigned to the stream that have been processed by
	// the server so far, not including the rows in the current response
	// message.
	//
	// This value, along with `at_response_end`, can be used to interpolate
	// the progress made as the rows in the message are being processed using
	// the following formula: `at_response_start + (at_response_end -
	// at_response_start) * rows_processed_from_response / rows_in_response`.
	//
	// Note that if a filter is provided, the `at_response_end` value of the
	// previous response may not necessarily be equal to the
	// `at_response_start` value of the current response.
	AtResponseStart float64 `protobuf:"fixed64,1,opt,name=at_response_start,json=atResponseStart,proto3" json:"at_response_start,omitempty"`
	// Similar to `at_response_start`, except that this value includes the
	// rows in the current response.
	AtResponseEnd float64 `protobuf:"fixed64,2,opt,name=at_response_end,json=atResponseEnd,proto3" json:"at_response_end,omitempty"`
}

func (x *StreamStats_Progress) Reset() {
	*x = StreamStats_Progress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamStats_Progress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamStats_Progress) ProtoMessage() {}

func (x *StreamStats_Progress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamStats_Progress.ProtoReflect.Descriptor instead.
func (*StreamStats_Progress) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{3, 0}
}

func (x *StreamStats_Progress) GetAtResponseStart() float64 {
	if x != nil {
		return x.AtResponseStart
	}
	return 0
}

func (x *StreamStats_Progress) GetAtResponseEnd() float64 {
	if x != nil {
		return x.AtResponseEnd
	}
	return 0
}

// Proto schema and data.
type AppendRowsRequest_ProtoData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Proto schema used to serialize the data.
	WriterSchema *ProtoSchema `protobuf:"bytes,1,opt,name=writer_schema,json=writerSchema,proto3" json:"writer_schema,omitempty"`
	// Serialized row data in protobuf message format.
	Rows *ProtoRows `protobuf:"bytes,2,opt,name=rows,proto3" json:"rows,omitempty"`
}

func (x *AppendRowsRequest_ProtoData) Reset() {
	*x = AppendRowsRequest_ProtoData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppendRowsRequest_ProtoData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppendRowsRequest_ProtoData) ProtoMessage() {}

func (x *AppendRowsRequest_ProtoData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppendRowsRequest_ProtoData.ProtoReflect.Descriptor instead.
func (*AppendRowsRequest_ProtoData) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP(), []int{8, 0}
}

func (x *AppendRowsRequest_ProtoData) GetWriterSchema() *ProtoSchema {
	if x != nil {
		return x.WriterSchema
	}
	return nil
}

func (x *AppendRowsRequest_ProtoData) GetRows() *ProtoRows {
	if x != nil {
		return x.Rows
	}
	return nil
}

var File_google_cloud_bigquery_storage_v1beta2_storage_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x61, 0x76, 0x72, 0x6f, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xed, 0x01, 0x0a, 0x18,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0c, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x72, 0x65, 0x61, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x7d, 0x0a, 0x0f, 0x52,
	0x65, 0x61, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52,
	0x0a, 0x0b, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x64,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0a, 0x72, 0x65, 0x61, 0x64, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x3a, 0x0a, 0x0d, 0x54, 0x68,
	0x72, 0x6f, 0x74, 0x74, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x74,
	0x68, 0x72, 0x6f, 0x74, 0x74, 0x6c, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x74, 0x68, 0x72, 0x6f, 0x74, 0x74, 0x6c, 0x65, 0x50,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x22, 0xc6, 0x01, 0x0a, 0x0b, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x57, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x1a,
	0x5e, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x61,
	0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x61, 0x74, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x0d, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x45, 0x6e, 0x64, 0x22,
	0x97, 0x03, 0x0a, 0x10, 0x52, 0x65, 0x61, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x09, 0x61, 0x76, 0x72, 0x6f, 0x5f, 0x72, 0x6f, 0x77,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e,
	0x41, 0x76, 0x72, 0x6f, 0x52, 0x6f, 0x77, 0x73, 0x48, 0x00, 0x52, 0x08, 0x61, 0x76, 0x72, 0x6f,
	0x52, 0x6f, 0x77, 0x73, 0x12, 0x67, 0x0a, 0x12, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x5f, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x41, 0x72, 0x72, 0x6f, 0x77, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x48, 0x00, 0x52, 0x10, 0x61, 0x72, 0x72,
	0x6f, 0x77, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x1b, 0x0a,
	0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x73, 0x12, 0x5b, 0x0a, 0x0e, 0x74, 0x68, 0x72, 0x6f, 0x74, 0x74, 0x6c, 0x65,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x32, 0x2e, 0x54, 0x68, 0x72, 0x6f, 0x74, 0x74, 0x6c, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x0d, 0x74, 0x68, 0x72, 0x6f, 0x74, 0x74, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x06, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x22, 0x7b, 0x0a, 0x16, 0x53, 0x70, 0x6c,
	0x69, 0x74, 0x52, 0x65, 0x61, 0x64, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x64, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x66, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x66, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd1, 0x01, 0x0a, 0x17, 0x53, 0x70, 0x6c, 0x69, 0x74,
	0x52, 0x65, 0x61, 0x64, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0d, 0x70,
	0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x5c, 0x0a, 0x10,
	0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x52,
	0x65, 0x61, 0x64, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0f, 0x72, 0x65, 0x6d, 0x61, 0x69,
	0x6e, 0x64, 0x65, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0xb5, 0x01, 0x0a, 0x18, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x77, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x22, 0xed, 0x03, 0x0a, 0x11, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x6f, 0x77,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0c, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x0b, 0x77, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12,
	0x33, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x63, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x72, 0x6f,
	0x77, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2e, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x67, 0x6e,
	0x6f, 0x72, 0x65, 0x5f, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65,
	0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x1a, 0xaa, 0x01,
	0x0a, 0x09, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x44, 0x61, 0x74, 0x61, 0x12, 0x57, 0x0a, 0x0d, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x72, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x12, 0x44, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x6f, 0x77, 0x73, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x72, 0x6f,
	0x77, 0x73, 0x22, 0xc1, 0x01, 0x0a, 0x12, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x6f, 0x77,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x59, 0x0a, 0x0e, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x0d, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5f, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x67, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x22, 0x5e, 0x0a, 0x1f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x64, 0x0a, 0x1a, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x3a, 0x0a, 0x1b, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x22, 0x9e, 0x01, 0x0a, 0x10, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x52, 0x6f, 0x77, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x0b, 0x77, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x33,
	0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x22, 0x2b, 0x0a, 0x11, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x52, 0x6f, 0x77, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x32, 0xf3, 0x06, 0x0a, 0x0c, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x61,
	0x64, 0x12, 0xf8, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x64,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2e, 0x52, 0x65, 0x61, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x6e, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x41, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x24, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x6d, 0x61, 0x78, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0xde, 0x01, 0x0a,
	0x08, 0x52, 0x65, 0x61, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x6f,
	0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5f, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x72, 0x65,
	0x61, 0x64, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x12, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2c, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x30, 0x01, 0x12, 0xd5, 0x01,
	0x0a, 0x0f, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x52, 0x65, 0x61, 0x64, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x52,
	0x65, 0x61, 0x64, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x52, 0x65,
	0x61, 0x64, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0xae, 0x01, 0xca, 0x41, 0x1e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x89, 0x01, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x72,
	0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x32, 0x96, 0x0c, 0x0a, 0x0d, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0xe6, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x22, 0x5c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22, 0x30, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0c, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0xda, 0x41, 0x13, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x12, 0xe1, 0x01, 0x0a, 0x0a, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x6f, 0x77, 0x73,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x52,
	0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2e, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x40, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x0c, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x28, 0x01, 0x30, 0x01, 0x12, 0xce, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32,
	0x2e, 0x47, 0x65, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe8, 0x01, 0x0a, 0x13, 0x46, 0x69, 0x6e, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xeb, 0x01, 0x0a, 0x17, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x57, 0x72, 0x69, 0x74, 0x65, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0xda, 0x01, 0x0a, 0x09, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x52, 0x6f, 0x77, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x2e, 0x46,
	0x6c, 0x75, 0x73, 0x68, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x32, 0x2f, 0x7b, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0c,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x1a, 0xb0, 0x01, 0xca,
	0x41, 0x1e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x8b, 0x01, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x64, 0x61, 0x74, 0x61,
	0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x89, 0x01, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x32, 0x42, 0x0c, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x32, 0x3b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescData = file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDesc
)

func file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescData)
	})
	return file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDescData
}

var file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_google_cloud_bigquery_storage_v1beta2_storage_proto_goTypes = []interface{}{
	(*CreateReadSessionRequest)(nil),        // 0: google.cloud.bigquery.storage.v1beta2.CreateReadSessionRequest
	(*ReadRowsRequest)(nil),                 // 1: google.cloud.bigquery.storage.v1beta2.ReadRowsRequest
	(*ThrottleState)(nil),                   // 2: google.cloud.bigquery.storage.v1beta2.ThrottleState
	(*StreamStats)(nil),                     // 3: google.cloud.bigquery.storage.v1beta2.StreamStats
	(*ReadRowsResponse)(nil),                // 4: google.cloud.bigquery.storage.v1beta2.ReadRowsResponse
	(*SplitReadStreamRequest)(nil),          // 5: google.cloud.bigquery.storage.v1beta2.SplitReadStreamRequest
	(*SplitReadStreamResponse)(nil),         // 6: google.cloud.bigquery.storage.v1beta2.SplitReadStreamResponse
	(*CreateWriteStreamRequest)(nil),        // 7: google.cloud.bigquery.storage.v1beta2.CreateWriteStreamRequest
	(*AppendRowsRequest)(nil),               // 8: google.cloud.bigquery.storage.v1beta2.AppendRowsRequest
	(*AppendRowsResponse)(nil),              // 9: google.cloud.bigquery.storage.v1beta2.AppendRowsResponse
	(*GetWriteStreamRequest)(nil),           // 10: google.cloud.bigquery.storage.v1beta2.GetWriteStreamRequest
	(*BatchCommitWriteStreamsRequest)(nil),  // 11: google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsRequest
	(*BatchCommitWriteStreamsResponse)(nil), // 12: google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse
	(*FinalizeWriteStreamRequest)(nil),      // 13: google.cloud.bigquery.storage.v1beta2.FinalizeWriteStreamRequest
	(*FinalizeWriteStreamResponse)(nil),     // 14: google.cloud.bigquery.storage.v1beta2.FinalizeWriteStreamResponse
	(*FlushRowsRequest)(nil),                // 15: google.cloud.bigquery.storage.v1beta2.FlushRowsRequest
	(*FlushRowsResponse)(nil),               // 16: google.cloud.bigquery.storage.v1beta2.FlushRowsResponse
	(*StreamStats_Progress)(nil),            // 17: google.cloud.bigquery.storage.v1beta2.StreamStats.Progress
	(*AppendRowsRequest_ProtoData)(nil),     // 18: google.cloud.bigquery.storage.v1beta2.AppendRowsRequest.ProtoData
	(*ReadSession)(nil),                     // 19: google.cloud.bigquery.storage.v1beta2.ReadSession
	(*AvroRows)(nil),                        // 20: google.cloud.bigquery.storage.v1beta2.AvroRows
	(*ArrowRecordBatch)(nil),                // 21: google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch
	(*ReadStream)(nil),                      // 22: google.cloud.bigquery.storage.v1beta2.ReadStream
	(*WriteStream)(nil),                     // 23: google.cloud.bigquery.storage.v1beta2.WriteStream
	(*wrapperspb.Int64Value)(nil),           // 24: google.protobuf.Int64Value
	(*status.Status)(nil),                   // 25: google.rpc.Status
	(*TableSchema)(nil),                     // 26: google.cloud.bigquery.storage.v1beta2.TableSchema
	(*timestamppb.Timestamp)(nil),           // 27: google.protobuf.Timestamp
	(*ProtoSchema)(nil),                     // 28: google.cloud.bigquery.storage.v1beta2.ProtoSchema
	(*ProtoRows)(nil),                       // 29: google.cloud.bigquery.storage.v1beta2.ProtoRows
}
var file_google_cloud_bigquery_storage_v1beta2_storage_proto_depIdxs = []int32{
	19, // 0: google.cloud.bigquery.storage.v1beta2.CreateReadSessionRequest.read_session:type_name -> google.cloud.bigquery.storage.v1beta2.ReadSession
	17, // 1: google.cloud.bigquery.storage.v1beta2.StreamStats.progress:type_name -> google.cloud.bigquery.storage.v1beta2.StreamStats.Progress
	20, // 2: google.cloud.bigquery.storage.v1beta2.ReadRowsResponse.avro_rows:type_name -> google.cloud.bigquery.storage.v1beta2.AvroRows
	21, // 3: google.cloud.bigquery.storage.v1beta2.ReadRowsResponse.arrow_record_batch:type_name -> google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch
	3,  // 4: google.cloud.bigquery.storage.v1beta2.ReadRowsResponse.stats:type_name -> google.cloud.bigquery.storage.v1beta2.StreamStats
	2,  // 5: google.cloud.bigquery.storage.v1beta2.ReadRowsResponse.throttle_state:type_name -> google.cloud.bigquery.storage.v1beta2.ThrottleState
	22, // 6: google.cloud.bigquery.storage.v1beta2.SplitReadStreamResponse.primary_stream:type_name -> google.cloud.bigquery.storage.v1beta2.ReadStream
	22, // 7: google.cloud.bigquery.storage.v1beta2.SplitReadStreamResponse.remainder_stream:type_name -> google.cloud.bigquery.storage.v1beta2.ReadStream
	23, // 8: google.cloud.bigquery.storage.v1beta2.CreateWriteStreamRequest.write_stream:type_name -> google.cloud.bigquery.storage.v1beta2.WriteStream
	24, // 9: google.cloud.bigquery.storage.v1beta2.AppendRowsRequest.offset:type_name -> google.protobuf.Int64Value
	18, // 10: google.cloud.bigquery.storage.v1beta2.AppendRowsRequest.proto_rows:type_name -> google.cloud.bigquery.storage.v1beta2.AppendRowsRequest.ProtoData
	25, // 11: google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.error:type_name -> google.rpc.Status
	26, // 12: google.cloud.bigquery.storage.v1beta2.AppendRowsResponse.updated_schema:type_name -> google.cloud.bigquery.storage.v1beta2.TableSchema
	27, // 13: google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse.commit_time:type_name -> google.protobuf.Timestamp
	24, // 14: google.cloud.bigquery.storage.v1beta2.FlushRowsRequest.offset:type_name -> google.protobuf.Int64Value
	28, // 15: google.cloud.bigquery.storage.v1beta2.AppendRowsRequest.ProtoData.writer_schema:type_name -> google.cloud.bigquery.storage.v1beta2.ProtoSchema
	29, // 16: google.cloud.bigquery.storage.v1beta2.AppendRowsRequest.ProtoData.rows:type_name -> google.cloud.bigquery.storage.v1beta2.ProtoRows
	0,  // 17: google.cloud.bigquery.storage.v1beta2.BigQueryRead.CreateReadSession:input_type -> google.cloud.bigquery.storage.v1beta2.CreateReadSessionRequest
	1,  // 18: google.cloud.bigquery.storage.v1beta2.BigQueryRead.ReadRows:input_type -> google.cloud.bigquery.storage.v1beta2.ReadRowsRequest
	5,  // 19: google.cloud.bigquery.storage.v1beta2.BigQueryRead.SplitReadStream:input_type -> google.cloud.bigquery.storage.v1beta2.SplitReadStreamRequest
	7,  // 20: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.CreateWriteStream:input_type -> google.cloud.bigquery.storage.v1beta2.CreateWriteStreamRequest
	8,  // 21: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.AppendRows:input_type -> google.cloud.bigquery.storage.v1beta2.AppendRowsRequest
	10, // 22: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.GetWriteStream:input_type -> google.cloud.bigquery.storage.v1beta2.GetWriteStreamRequest
	13, // 23: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.FinalizeWriteStream:input_type -> google.cloud.bigquery.storage.v1beta2.FinalizeWriteStreamRequest
	11, // 24: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.BatchCommitWriteStreams:input_type -> google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsRequest
	15, // 25: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.FlushRows:input_type -> google.cloud.bigquery.storage.v1beta2.FlushRowsRequest
	19, // 26: google.cloud.bigquery.storage.v1beta2.BigQueryRead.CreateReadSession:output_type -> google.cloud.bigquery.storage.v1beta2.ReadSession
	4,  // 27: google.cloud.bigquery.storage.v1beta2.BigQueryRead.ReadRows:output_type -> google.cloud.bigquery.storage.v1beta2.ReadRowsResponse
	6,  // 28: google.cloud.bigquery.storage.v1beta2.BigQueryRead.SplitReadStream:output_type -> google.cloud.bigquery.storage.v1beta2.SplitReadStreamResponse
	23, // 29: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.CreateWriteStream:output_type -> google.cloud.bigquery.storage.v1beta2.WriteStream
	9,  // 30: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.AppendRows:output_type -> google.cloud.bigquery.storage.v1beta2.AppendRowsResponse
	23, // 31: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.GetWriteStream:output_type -> google.cloud.bigquery.storage.v1beta2.WriteStream
	14, // 32: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.FinalizeWriteStream:output_type -> google.cloud.bigquery.storage.v1beta2.FinalizeWriteStreamResponse
	12, // 33: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.BatchCommitWriteStreams:output_type -> google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse
	16, // 34: google.cloud.bigquery.storage.v1beta2.BigQueryWrite.FlushRows:output_type -> google.cloud.bigquery.storage.v1beta2.FlushRowsResponse
	26, // [26:35] is the sub-list for method output_type
	17, // [17:26] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_storage_v1beta2_storage_proto_init() }
func file_google_cloud_bigquery_storage_v1beta2_storage_proto_init() {
	if File_google_cloud_bigquery_storage_v1beta2_storage_proto != nil {
		return
	}
	file_google_cloud_bigquery_storage_v1beta2_arrow_proto_init()
	file_google_cloud_bigquery_storage_v1beta2_avro_proto_init()
	file_google_cloud_bigquery_storage_v1beta2_protobuf_proto_init()
	file_google_cloud_bigquery_storage_v1beta2_stream_proto_init()
	file_google_cloud_bigquery_storage_v1beta2_table_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateReadSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ThrottleState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitReadStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitReadStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWriteStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppendRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppendRowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWriteStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCommitWriteStreamsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCommitWriteStreamsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeWriteStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeWriteStreamResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FlushRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FlushRowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamStats_Progress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppendRowsRequest_ProtoData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ReadRowsResponse_AvroRows)(nil),
		(*ReadRowsResponse_ArrowRecordBatch)(nil),
	}
	file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*AppendRowsRequest_ProtoRows)(nil),
	}
	file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*AppendRowsResponse_Offset)(nil),
		(*AppendRowsResponse_Error)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_google_cloud_bigquery_storage_v1beta2_storage_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_storage_v1beta2_storage_proto_depIdxs,
		MessageInfos:      file_google_cloud_bigquery_storage_v1beta2_storage_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_storage_v1beta2_storage_proto = out.File
	file_google_cloud_bigquery_storage_v1beta2_storage_proto_rawDesc = nil
	file_google_cloud_bigquery_storage_v1beta2_storage_proto_goTypes = nil
	file_google_cloud_bigquery_storage_v1beta2_storage_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BigQueryReadClient is the client API for BigQueryRead service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BigQueryReadClient interface {
	// Creates a new read session. A read session divides the contents of a
	// BigQuery table into one or more streams, which can then be used to read
	// data from the table. The read session also specifies properties of the
	// data to be read, such as a list of columns or a push-down filter describing
	// the rows to be returned.
	//
	// A particular row can be read by at most one stream. When the caller has
	// reached the end of each stream in the session, then all the data in the
	// table has been read.
	//
	// Data is assigned to each stream such that roughly the same number of
	// rows can be read from each stream. Because the server-side unit for
	// assigning data is collections of rows, the API does not guarantee that
	// each stream will return the same number or rows. Additionally, the
	// limits are enforced based on the number of pre-filtered rows, so some
	// filters can lead to lopsided assignments.
	//
	// Read sessions automatically expire 24 hours after they are created and do
	// not require manual clean-up by the caller.
	CreateReadSession(ctx context.Context, in *CreateReadSessionRequest, opts ...grpc.CallOption) (*ReadSession, error)
	// Reads rows from the stream in the format prescribed by the ReadSession.
	// Each response contains one or more table rows, up to a maximum of 100 MiB
	// per response; read requests which attempt to read individual rows larger
	// than 100 MiB will fail.
	//
	// Each request also returns a set of stream statistics reflecting the current
	// state of the stream.
	ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigQueryRead_ReadRowsClient, error)
	// Splits a given `ReadStream` into two `ReadStream` objects. These
	// `ReadStream` objects are referred to as the primary and the residual
	// streams of the split. The original `ReadStream` can still be read from in
	// the same manner as before. Both of the returned `ReadStream` objects can
	// also be read from, and the rows returned by both child streams will be
	// the same as the rows read from the original stream.
	//
	// Moreover, the two child streams will be allocated back-to-back in the
	// original `ReadStream`. Concretely, it is guaranteed that for streams
	// original, primary, and residual, that original[0-j] = primary[0-j] and
	// original[j-n] = residual[0-m] once the streams have been read to
	// completion.
	SplitReadStream(ctx context.Context, in *SplitReadStreamRequest, opts ...grpc.CallOption) (*SplitReadStreamResponse, error)
}

type bigQueryReadClient struct {
	cc grpc.ClientConnInterface
}

func NewBigQueryReadClient(cc grpc.ClientConnInterface) BigQueryReadClient {
	return &bigQueryReadClient{cc}
}

func (c *bigQueryReadClient) CreateReadSession(ctx context.Context, in *CreateReadSessionRequest, opts ...grpc.CallOption) (*ReadSession, error) {
	out := new(ReadSession)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1beta2.BigQueryRead/CreateReadSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryReadClient) ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigQueryRead_ReadRowsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BigQueryRead_serviceDesc.Streams[0], "/google.cloud.bigquery.storage.v1beta2.BigQueryRead/ReadRows", opts...)
	if err != nil {
		return nil, err
	}
	x := &bigQueryReadReadRowsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BigQueryRead_ReadRowsClient interface {
	Recv() (*ReadRowsResponse, error)
	grpc.ClientStream
}

type bigQueryReadReadRowsClient struct {
	grpc.ClientStream
}

func (x *bigQueryReadReadRowsClient) Recv() (*ReadRowsResponse, error) {
	m := new(ReadRowsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigQueryReadClient) SplitReadStream(ctx context.Context, in *SplitReadStreamRequest, opts ...grpc.CallOption) (*SplitReadStreamResponse, error) {
	out := new(SplitReadStreamResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1beta2.BigQueryRead/SplitReadStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigQueryReadServer is the server API for BigQueryRead service.
type BigQueryReadServer interface {
	// Creates a new read session. A read session divides the contents of a
	// BigQuery table into one or more streams, which can then be used to read
	// data from the table. The read session also specifies properties of the
	// data to be read, such as a list of columns or a push-down filter describing
	// the rows to be returned.
	//
	// A particular row can be read by at most one stream. When the caller has
	// reached the end of each stream in the session, then all the data in the
	// table has been read.
	//
	// Data is assigned to each stream such that roughly the same number of
	// rows can be read from each stream. Because the server-side unit for
	// assigning data is collections of rows, the API does not guarantee that
	// each stream will return the same number or rows. Additionally, the
	// limits are enforced based on the number of pre-filtered rows, so some
	// filters can lead to lopsided assignments.
	//
	// Read sessions automatically expire 24 hours after they are created and do
	// not require manual clean-up by the caller.
	CreateReadSession(context.Context, *CreateReadSessionRequest) (*ReadSession, error)
	// Reads rows from the stream in the format prescribed by the ReadSession.
	// Each response contains one or more table rows, up to a maximum of 100 MiB
	// per response; read requests which attempt to read individual rows larger
	// than 100 MiB will fail.
	//
	// Each request also returns a set of stream statistics reflecting the current
	// state of the stream.
	ReadRows(*ReadRowsRequest, BigQueryRead_ReadRowsServer) error
	// Splits a given `ReadStream` into two `ReadStream` objects. These
	// `ReadStream` objects are referred to as the primary and the residual
	// streams of the split. The original `ReadStream` can still be read from in
	// the same manner as before. Both of the returned `ReadStream` objects can
	// also be read from, and the rows returned by both child streams will be
	// the same as the rows read from the original stream.
	//
	// Moreover, the two child streams will be allocated back-to-back in the
	// original `ReadStream`. Concretely, it is guaranteed that for streams
	// original, primary, and residual, that original[0-j] = primary[0-j] and
	// original[j-n] = residual[0-m] once the streams have been read to
	// completion.
	SplitReadStream(context.Context, *SplitReadStreamRequest) (*SplitReadStreamResponse, error)
}

// UnimplementedBigQueryReadServer can be embedded to have forward compatible implementations.
type UnimplementedBigQueryReadServer struct {
}

func (*UnimplementedBigQueryReadServer) CreateReadSession(context.Context, *CreateReadSessionRequest) (*ReadSession, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateReadSession not implemented")
}
func (*UnimplementedBigQueryReadServer) ReadRows(*ReadRowsRequest, BigQueryRead_ReadRowsServer) error {
	return status1.Errorf(codes.Unimplemented, "method ReadRows not implemented")
}
func (*UnimplementedBigQueryReadServer) SplitReadStream(context.Context, *SplitReadStreamRequest) (*SplitReadStreamResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SplitReadStream not implemented")
}

func RegisterBigQueryReadServer(s *grpc.Server, srv BigQueryReadServer) {
	s.RegisterService(&_BigQueryRead_serviceDesc, srv)
}

func _BigQueryRead_CreateReadSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReadSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryReadServer).CreateReadSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1beta2.BigQueryRead/CreateReadSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryReadServer).CreateReadSession(ctx, req.(*CreateReadSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryRead_ReadRows_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRowsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigQueryReadServer).ReadRows(m, &bigQueryReadReadRowsServer{stream})
}

type BigQueryRead_ReadRowsServer interface {
	Send(*ReadRowsResponse) error
	grpc.ServerStream
}

type bigQueryReadReadRowsServer struct {
	grpc.ServerStream
}

func (x *bigQueryReadReadRowsServer) Send(m *ReadRowsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BigQueryRead_SplitReadStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SplitReadStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryReadServer).SplitReadStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1beta2.BigQueryRead/SplitReadStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryReadServer).SplitReadStream(ctx, req.(*SplitReadStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigQueryRead_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.storage.v1beta2.BigQueryRead",
	HandlerType: (*BigQueryReadServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateReadSession",
			Handler:    _BigQueryRead_CreateReadSession_Handler,
		},
		{
			MethodName: "SplitReadStream",
			Handler:    _BigQueryRead_SplitReadStream_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadRows",
			Handler:       _BigQueryRead_ReadRows_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/bigquery/storage/v1beta2/storage.proto",
}

// BigQueryWriteClient is the client API for BigQueryWrite service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BigQueryWriteClient interface {
	// Creates a write stream to the given table.
	// Additionally, every table has a special COMMITTED stream named '_default'
	// to which data can be written. This stream doesn't need to be created using
	// CreateWriteStream. It is a stream that can be used simultaneously by any
	// number of clients. Data written to this stream is considered committed as
	// soon as an acknowledgement is received.
	CreateWriteStream(ctx context.Context, in *CreateWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error)
	// Appends data to the given stream.
	//
	// If `offset` is specified, the `offset` is checked against the end of
	// stream. The server returns `OUT_OF_RANGE` in `AppendRowsResponse` if an
	// attempt is made to append to an offset beyond the current end of the stream
	// or `ALREADY_EXISTS` if user provids an `offset` that has already been
	// written to. User can retry with adjusted offset within the same RPC
	// stream. If `offset` is not specified, append happens at the end of the
	// stream.
	//
	// The response contains the offset at which the append happened. Responses
	// are received in the same order in which requests are sent. There will be
	// one response for each successful request. If the `offset` is not set in
	// response, it means append didn't happen due to some errors. If one request
	// fails, all the subsequent requests will also fail until a success request
	// is made again.
	//
	// If the stream is of `PENDING` type, data will only be available for read
	// operations after the stream is committed.
	AppendRows(ctx context.Context, opts ...grpc.CallOption) (BigQueryWrite_AppendRowsClient, error)
	// Gets a write stream.
	GetWriteStream(ctx context.Context, in *GetWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error)
	// Finalize a write stream so that no new data can be appended to the
	// stream. Finalize is not supported on the '_default' stream.
	FinalizeWriteStream(ctx context.Context, in *FinalizeWriteStreamRequest, opts ...grpc.CallOption) (*FinalizeWriteStreamResponse, error)
	// Atomically commits a group of `PENDING` streams that belong to the same
	// `parent` table.
	// Streams must be finalized before commit and cannot be committed multiple
	// times. Once a stream is committed, data in the stream becomes available
	// for read operations.
	BatchCommitWriteStreams(ctx context.Context, in *BatchCommitWriteStreamsRequest, opts ...grpc.CallOption) (*BatchCommitWriteStreamsResponse, error)
	// Flushes rows to a BUFFERED stream.
	// If users are appending rows to BUFFERED stream, flush operation is
	// required in order for the rows to become available for reading. A
	// Flush operation flushes up to any previously flushed offset in a BUFFERED
	// stream, to the offset specified in the request.
	// Flush is not supported on the _default stream, since it is not BUFFERED.
	FlushRows(ctx context.Context, in *FlushRowsRequest, opts ...grpc.CallOption) (*FlushRowsResponse, error)
}

type bigQueryWriteClient struct {
	cc grpc.ClientConnInterface
}

func NewBigQueryWriteClient(cc grpc.ClientConnInterface) BigQueryWriteClient {
	return &bigQueryWriteClient{cc}
}

func (c *bigQueryWriteClient) CreateWriteStream(ctx context.Context, in *CreateWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error) {
	out := new(WriteStream)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1beta2.BigQueryWrite/CreateWriteStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) AppendRows(ctx context.Context, opts ...grpc.CallOption) (BigQueryWrite_AppendRowsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BigQueryWrite_serviceDesc.Streams[0], "/google.cloud.bigquery.storage.v1beta2.BigQueryWrite/AppendRows", opts...)
	if err != nil {
		return nil, err
	}
	x := &bigQueryWriteAppendRowsClient{stream}
	return x, nil
}

type BigQueryWrite_AppendRowsClient interface {
	Send(*AppendRowsRequest) error
	Recv() (*AppendRowsResponse, error)
	grpc.ClientStream
}

type bigQueryWriteAppendRowsClient struct {
	grpc.ClientStream
}

func (x *bigQueryWriteAppendRowsClient) Send(m *AppendRowsRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *bigQueryWriteAppendRowsClient) Recv() (*AppendRowsResponse, error) {
	m := new(AppendRowsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigQueryWriteClient) GetWriteStream(ctx context.Context, in *GetWriteStreamRequest, opts ...grpc.CallOption) (*WriteStream, error) {
	out := new(WriteStream)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1beta2.BigQueryWrite/GetWriteStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) FinalizeWriteStream(ctx context.Context, in *FinalizeWriteStreamRequest, opts ...grpc.CallOption) (*FinalizeWriteStreamResponse, error) {
	out := new(FinalizeWriteStreamResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1beta2.BigQueryWrite/FinalizeWriteStream", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) BatchCommitWriteStreams(ctx context.Context, in *BatchCommitWriteStreamsRequest, opts ...grpc.CallOption) (*BatchCommitWriteStreamsResponse, error) {
	out := new(BatchCommitWriteStreamsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1beta2.BigQueryWrite/BatchCommitWriteStreams", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryWriteClient) FlushRows(ctx context.Context, in *FlushRowsRequest, opts ...grpc.CallOption) (*FlushRowsResponse, error) {
	out := new(FlushRowsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.storage.v1beta2.BigQueryWrite/FlushRows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigQueryWriteServer is the server API for BigQueryWrite service.
type BigQueryWriteServer interface {
	// Creates a write stream to the given table.
	// Additionally, every table has a special COMMITTED stream named '_default'
	// to which data can be written. This stream doesn't need to be created using
	// CreateWriteStream. It is a stream that can be used simultaneously by any
	// number of clients. Data written to this stream is considered committed as
	// soon as an acknowledgement is received.
	CreateWriteStream(context.Context, *CreateWriteStreamRequest) (*WriteStream, error)
	// Appends data to the given stream.
	//
	// If `offset` is specified, the `offset` is checked against the end of
	// stream. The server returns `OUT_OF_RANGE` in `AppendRowsResponse` if an
	// attempt is made to append to an offset beyond the current end of the stream
	// or `ALREADY_EXISTS` if user provids an `offset` that has already been
	// written to. User can retry with adjusted offset within the same RPC
	// stream. If `offset` is not specified, append happens at the end of the
	// stream.
	//
	// The response contains the offset at which the append happened. Responses
	// are received in the same order in which requests are sent. There will be
	// one response for each successful request. If the `offset` is not set in
	// response, it means append didn't happen due to some errors. If one request
	// fails, all the subsequent requests will also fail until a success request
	// is made again.
	//
	// If the stream is of `PENDING` type, data will only be available for read
	// operations after the stream is committed.
	AppendRows(BigQueryWrite_AppendRowsServer) error
	// Gets a write stream.
	GetWriteStream(context.Context, *GetWriteStreamRequest) (*WriteStream, error)
	// Finalize a write stream so that no new data can be appended to the
	// stream. Finalize is not supported on the '_default' stream.
	FinalizeWriteStream(context.Context, *FinalizeWriteStreamRequest) (*FinalizeWriteStreamResponse, error)
	// Atomically commits a group of `PENDING` streams that belong to the same
	// `parent` table.
	// Streams must be finalized before commit and cannot be committed multiple
	// times. Once a stream is committed, data in the stream becomes available
	// for read operations.
	BatchCommitWriteStreams(context.Context, *BatchCommitWriteStreamsRequest) (*BatchCommitWriteStreamsResponse, error)
	// Flushes rows to a BUFFERED stream.
	// If users are appending rows to BUFFERED stream, flush operation is
	// required in order for the rows to become available for reading. A
	// Flush operation flushes up to any previously flushed offset in a BUFFERED
	// stream, to the offset specified in the request.
	// Flush is not supported on the _default stream, since it is not BUFFERED.
	FlushRows(context.Context, *FlushRowsRequest) (*FlushRowsResponse, error)
}

// UnimplementedBigQueryWriteServer can be embedded to have forward compatible implementations.
type UnimplementedBigQueryWriteServer struct {
}

func (*UnimplementedBigQueryWriteServer) CreateWriteStream(context.Context, *CreateWriteStreamRequest) (*WriteStream, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateWriteStream not implemented")
}
func (*UnimplementedBigQueryWriteServer) AppendRows(BigQueryWrite_AppendRowsServer) error {
	return status1.Errorf(codes.Unimplemented, "method AppendRows not implemented")
}
func (*UnimplementedBigQueryWriteServer) GetWriteStream(context.Context, *GetWriteStreamRequest) (*WriteStream, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetWriteStream not implemented")
}
func (*UnimplementedBigQueryWriteServer) FinalizeWriteStream(context.Context, *FinalizeWriteStreamRequest) (*FinalizeWriteStreamResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FinalizeWriteStream not implemented")
}
func (*UnimplementedBigQueryWriteServer) BatchCommitWriteStreams(context.Context, *BatchCommitWriteStreamsRequest) (*BatchCommitWriteStreamsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchCommitWriteStreams not implemented")
}
func (*UnimplementedBigQueryWriteServer) FlushRows(context.Context, *FlushRowsRequest) (*FlushRowsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method FlushRows not implemented")
}

func RegisterBigQueryWriteServer(s *grpc.Server, srv BigQueryWriteServer) {
	s.RegisterService(&_BigQueryWrite_serviceDesc, srv)
}

func _BigQueryWrite_CreateWriteStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWriteStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).CreateWriteStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1beta2.BigQueryWrite/CreateWriteStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).CreateWriteStream(ctx, req.(*CreateWriteStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_AppendRows_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BigQueryWriteServer).AppendRows(&bigQueryWriteAppendRowsServer{stream})
}

type BigQueryWrite_AppendRowsServer interface {
	Send(*AppendRowsResponse) error
	Recv() (*AppendRowsRequest, error)
	grpc.ServerStream
}

type bigQueryWriteAppendRowsServer struct {
	grpc.ServerStream
}

func (x *bigQueryWriteAppendRowsServer) Send(m *AppendRowsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *bigQueryWriteAppendRowsServer) Recv() (*AppendRowsRequest, error) {
	m := new(AppendRowsRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _BigQueryWrite_GetWriteStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWriteStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).GetWriteStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1beta2.BigQueryWrite/GetWriteStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).GetWriteStream(ctx, req.(*GetWriteStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_FinalizeWriteStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeWriteStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).FinalizeWriteStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1beta2.BigQueryWrite/FinalizeWriteStream",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).FinalizeWriteStream(ctx, req.(*FinalizeWriteStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_BatchCommitWriteStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCommitWriteStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).BatchCommitWriteStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1beta2.BigQueryWrite/BatchCommitWriteStreams",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).BatchCommitWriteStreams(ctx, req.(*BatchCommitWriteStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryWrite_FlushRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FlushRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryWriteServer).FlushRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.storage.v1beta2.BigQueryWrite/FlushRows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryWriteServer).FlushRows(ctx, req.(*FlushRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigQueryWrite_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.storage.v1beta2.BigQueryWrite",
	HandlerType: (*BigQueryWriteServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateWriteStream",
			Handler:    _BigQueryWrite_CreateWriteStream_Handler,
		},
		{
			MethodName: "GetWriteStream",
			Handler:    _BigQueryWrite_GetWriteStream_Handler,
		},
		{
			MethodName: "FinalizeWriteStream",
			Handler:    _BigQueryWrite_FinalizeWriteStream_Handler,
		},
		{
			MethodName: "BatchCommitWriteStreams",
			Handler:    _BigQueryWrite_BatchCommitWriteStreams_Handler,
		},
		{
			MethodName: "FlushRows",
			Handler:    _BigQueryWrite_FlushRows_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "AppendRows",
			Handler:       _BigQueryWrite_AppendRows_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/bigquery/storage/v1beta2/storage.proto",
}
