// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/operator/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// EtcdLister helps list Etcds.
// All objects returned here must be treated as read-only.
type EtcdLister interface {
	// List lists all Etcds in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Etcd, err error)
	// Get retrieves the Etcd from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.Etcd, error)
	EtcdListerExpansion
}

// etcdLister implements the EtcdLister interface.
type etcdLister struct {
	indexer cache.Indexer
}

// NewEtcdLister returns a new EtcdLister.
func NewEtcdLister(indexer cache.Indexer) EtcdLister {
	return &etcdLister{indexer: indexer}
}

// List lists all Etcds in the indexer.
func (s *etcdLister) List(selector labels.Selector) (ret []*v1.Etcd, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Etcd))
	})
	return ret, err
}

// Get retrieves the Etcd from the index for a given name.
func (s *etcdLister) Get(name string) (*v1.Etcd, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("etcd"), name)
	}
	return obj.(*v1.Etcd), nil
}
