// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroups

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// A resource group.
type Group struct {
	_ struct{} `type:"structure"`

	// The description of the resource group.
	Description *string `type:"string"`

	// The ARN of a resource group.
	//
	// GroupArn is a required field
	GroupArn *string `min:"12" type:"string" required:"true"`

	// The name of a resource group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Group) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupArn != nil {
		v := *s.GroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A filter name and value pair that is used to obtain more specific results
// from a list of groups.
type GroupFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	//
	// Name is a required field
	Name GroupFilterName `type:"string" required:"true" enum:"true"`

	// One or more filter values. Allowed filter values vary by group filter name,
	// and are case-sensitive.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s GroupFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GroupFilter"}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// The ARN and group name of a group.
type GroupIdentifier struct {
	_ struct{} `type:"structure"`

	// The ARN of a resource group.
	GroupArn *string `min:"12" type:"string"`

	// The name of a resource group.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GroupIdentifier) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupIdentifier) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupArn != nil {
		v := *s.GroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The underlying resource query of a resource group. Resources that match query
// results are part of the group.
type GroupQuery struct {
	_ struct{} `type:"structure"`

	// The name of a resource group that is associated with a specific resource
	// query.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The resource query which determines which AWS resources are members of the
	// associated resource group.
	//
	// ResourceQuery is a required field
	ResourceQuery *ResourceQuery `type:"structure" required:"true"`
}

// String returns the string representation
func (s GroupQuery) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupQuery) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceQuery != nil {
		v := s.ResourceQuery

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ResourceQuery", v, metadata)
	}
	return nil
}

// A two-part error structure that can occur in ListGroupResources or SearchResources
// operations on CloudFormation stack-based queries. The error occurs if the
// CloudFormation stack on which the query is based either does not exist, or
// has a status that renders the stack inactive. A QueryError occurrence does
// not necessarily mean that AWS Resource Groups could not complete the operation,
// but the resulting group might have no member resources.
type QueryError struct {
	_ struct{} `type:"structure"`

	// Possible values are CLOUDFORMATION_STACK_INACTIVE and CLOUDFORMATION_STACK_NOT_EXISTING.
	ErrorCode QueryErrorCode `type:"string" enum:"true"`

	// A message that explains the ErrorCode value. Messages might state that the
	// specified CloudFormation stack does not exist (or no longer exists). For
	// CLOUDFORMATION_STACK_INACTIVE, the message typically states that the CloudFormation
	// stack has a status that is not (or no longer) active, such as CREATE_FAILED.
	Message *string `type:"string"`
}

// String returns the string representation
func (s QueryError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueryError) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ErrorCode) > 0 {
		v := s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A filter name and value pair that is used to obtain more specific results
// from a list of resources.
type ResourceFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	//
	// Name is a required field
	Name ResourceFilterName `type:"string" required:"true" enum:"true"`

	// One or more filter values. Allowed filter values vary by resource filter
	// name, and are case-sensitive.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ResourceFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceFilter"}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// The ARN of a resource, and its resource type.
type ResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// The ARN of a resource.
	ResourceArn *string `type:"string"`

	// The resource type of a resource, such as AWS::EC2::Instance.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s ResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceIdentifier) MarshalFields(e protocol.FieldEncoder) error {
	if s.ResourceArn != nil {
		v := *s.ResourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceType != nil {
		v := *s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The query that is used to define a resource group or a search for resources.
type ResourceQuery struct {
	_ struct{} `type:"structure"`

	// The query that defines a group or a search.
	//
	// Query is a required field
	Query *string `type:"string" required:"true"`

	// The type of the query. The valid values in this release are TAG_FILTERS_1_0
	// and CLOUDFORMATION_STACK_1_0.
	//
	//  TAG_FILTERS_1_0: A JSON syntax that lets you specify a collection of simple
	//  tag filters for resource types and tags, as supported by the AWS Tagging
	//  API GetResources (https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html)
	//  operation. If you specify more than one tag key, only resources that match
	//  all tag keys, and at least one value of each specified tag key, are returned
	//  in your query. If you specify more than one value for a tag key, a resource
	//  matches the filter if it has a tag key value that matches any of the specified
	//  values.
	//
	// For example, consider the following sample query for resources that have
	// two tags, Stage and Version, with two values each. ([{"Key":"Stage","Values":["Test","Deploy"]},{"Key":"Version","Values":["1","2"]}])
	// The results of this query might include the following.
	//
	//    * An EC2 instance that has the following two tags: {"Key":"Stage","Value":"Deploy"},
	//    and {"Key":"Version","Value":"2"}
	//
	//    * An S3 bucket that has the following two tags: {"Key":"Stage","Value":"Test"},
	//    and {"Key":"Version","Value":"1"}
	//
	// The query would not return the following results, however. The following
	// EC2 instance does not have all tag keys specified in the filter, so it is
	// rejected. The RDS database has all of the tag keys, but no values that match
	// at least one of the specified tag key values in the filter.
	//
	//    * An EC2 instance that has only the following tag: {"Key":"Stage","Value":"Deploy"}.
	//
	//    * An RDS database that has the following two tags: {"Key":"Stage","Value":"Archived"},
	//    and {"Key":"Version","Value":"4"}
	//
	//  CLOUDFORMATION_STACK_1_0: A JSON syntax that lets you specify a CloudFormation
	//  stack ARN.
	//
	// Type is a required field
	Type QueryType `min:"1" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ResourceQuery) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceQuery) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceQuery"}

	if s.Query == nil {
		invalidParams.Add(aws.NewErrParamRequired("Query"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceQuery) MarshalFields(e protocol.FieldEncoder) error {
	if s.Query != nil {
		v := *s.Query

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Query", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}
