// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package iot1clickprojectsiface provides an interface to enable mocking the AWS IoT 1-Click Projects Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package iot1clickprojectsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/iot1clickprojects"
)

// ClientAPI provides an interface to enable mocking the
// iot1clickprojects.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS IoT 1-Click Projects.
//    func myFunc(svc iot1clickprojectsiface.ClientAPI) bool {
//        // Make svc.AssociateDeviceWithPlacement request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := iot1clickprojects.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        iot1clickprojectsiface.ClientPI
//    }
//    func (m *mockClientClient) AssociateDeviceWithPlacement(input *iot1clickprojects.AssociateDeviceWithPlacementInput) (*iot1clickprojects.AssociateDeviceWithPlacementOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AssociateDeviceWithPlacementRequest(*iot1clickprojects.AssociateDeviceWithPlacementInput) iot1clickprojects.AssociateDeviceWithPlacementRequest

	CreatePlacementRequest(*iot1clickprojects.CreatePlacementInput) iot1clickprojects.CreatePlacementRequest

	CreateProjectRequest(*iot1clickprojects.CreateProjectInput) iot1clickprojects.CreateProjectRequest

	DeletePlacementRequest(*iot1clickprojects.DeletePlacementInput) iot1clickprojects.DeletePlacementRequest

	DeleteProjectRequest(*iot1clickprojects.DeleteProjectInput) iot1clickprojects.DeleteProjectRequest

	DescribePlacementRequest(*iot1clickprojects.DescribePlacementInput) iot1clickprojects.DescribePlacementRequest

	DescribeProjectRequest(*iot1clickprojects.DescribeProjectInput) iot1clickprojects.DescribeProjectRequest

	DisassociateDeviceFromPlacementRequest(*iot1clickprojects.DisassociateDeviceFromPlacementInput) iot1clickprojects.DisassociateDeviceFromPlacementRequest

	GetDevicesInPlacementRequest(*iot1clickprojects.GetDevicesInPlacementInput) iot1clickprojects.GetDevicesInPlacementRequest

	ListPlacementsRequest(*iot1clickprojects.ListPlacementsInput) iot1clickprojects.ListPlacementsRequest

	ListProjectsRequest(*iot1clickprojects.ListProjectsInput) iot1clickprojects.ListProjectsRequest

	ListTagsForResourceRequest(*iot1clickprojects.ListTagsForResourceInput) iot1clickprojects.ListTagsForResourceRequest

	TagResourceRequest(*iot1clickprojects.TagResourceInput) iot1clickprojects.TagResourceRequest

	UntagResourceRequest(*iot1clickprojects.UntagResourceInput) iot1clickprojects.UntagResourceRequest

	UpdatePlacementRequest(*iot1clickprojects.UpdatePlacementInput) iot1clickprojects.UpdatePlacementRequest

	UpdateProjectRequest(*iot1clickprojects.UpdateProjectInput) iot1clickprojects.UpdateProjectRequest
}

var _ ClientAPI = (*iot1clickprojects.Client)(nil)
