/* System-dependent timing definitions.  Linux version.
   Copyright (C) 1996-2016 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <http://www.gnu.org/licenses/>.  */

/*
 * Never include this file directly; use <time.h> instead.
 */

#if defined __need_timeval || defined __USE_GNU
#ifndef _STRUCT_TIMEVAL
#define _STRUCT_TIMEVAL	1
#include <bits/types.h>

/* A time value that is accurate to the nearest
   microsecond but also has a range of years.  */
struct timeval {
	__time_t tv_sec;	/* Seconds.  */
	__suseconds_t tv_usec;	/* Microseconds.  */
};
#endif				/* struct timeval */
#endif

#ifndef __need_timeval
#ifndef _BITS_TIME_H
#define _BITS_TIME_H	1

/* ISO/IEC 9899:1999 7.23.1: Components of time
   The macro `CLOCKS_PER_SEC' is an expression with type `clock_t' that is
   the number per second of the value returned by the `clock' function.  */
/* CAE XSH, Issue 4, Version 2: <time.h>
   The value of CLOCKS_PER_SEC is required to be 1 million on all
   XSI-conformant systems. */
#define CLOCKS_PER_SEC  ((clock_t) 1000000)

#if (!defined __STRICT_ANSI__ || defined __USE_POSIX) \
   && !defined __USE_XOPEN2K
/* Even though CLOCKS_PER_SEC has such a strange value CLK_TCK
   presents the real value for clock ticks per second for the system.  */
#include <bits/types.h>
extern long int __sysconf(int);
#define CLK_TCK ((__clock_t) __sysconf (2))	/* 2 is _SC_CLK_TCK */
#endif

#ifdef __USE_POSIX199309
/* Identifier for system-wide realtime clock.  */
#define CLOCK_REALTIME		0
/* Monotonic system-wide clock.  */
#define CLOCK_MONOTONIC		1
/* High-resolution timer from the CPU.  */
#define CLOCK_PROCESS_CPUTIME_ID	2
/* Thread-specific CPU-time clock.  */
#define CLOCK_THREAD_CPUTIME_ID	3
/* Monotonic system-wide clock, not adjusted for frequency scaling.  */
#define CLOCK_MONOTONIC_RAW		4
/* Identifier for system-wide realtime clock, updated only on ticks.  */
#define CLOCK_REALTIME_COARSE	5
/* Monotonic system-wide clock, updated only on ticks.  */
#define CLOCK_MONOTONIC_COARSE	6
/* Monotonic system-wide clock that includes time spent in suspension.  */
#define CLOCK_BOOTTIME		7
/* Like CLOCK_REALTIME but also wakes suspended system.  */
#define CLOCK_REALTIME_ALARM		8
/* Like CLOCK_BOOTTIME but also wakes suspended system.  */
#define CLOCK_BOOTTIME_ALARM		9
/* Like CLOCK_REALTIME but in International Atomic Time.  */
#define CLOCK_TAI			11

/* Flag to indicate time is absolute.  */
#define TIMER_ABSTIME		1
#endif

#ifdef __USE_GNU
#include <bits/timex.h>

__BEGIN_DECLS
/* Tune a POSIX clock.  */
extern int clock_adjtime(__clockid_t __clock_id, struct timex *__utx) __THROW;

__END_DECLS
#endif				/* use GNU */
#endif				/* bits/time.h */
#endif
#undef __need_timeval
