package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLogServiceStatus invokes the waf_openapi.DescribeLogServiceStatus API synchronously
func (client *Client) DescribeLogServiceStatus(request *DescribeLogServiceStatusRequest) (response *DescribeLogServiceStatusResponse, err error) {
	response = CreateDescribeLogServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLogServiceStatusWithChan invokes the waf_openapi.DescribeLogServiceStatus API asynchronously
func (client *Client) DescribeLogServiceStatusWithChan(request *DescribeLogServiceStatusRequest) (<-chan *DescribeLogServiceStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeLogServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLogServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLogServiceStatusWithCallback invokes the waf_openapi.DescribeLogServiceStatus API asynchronously
func (client *Client) DescribeLogServiceStatusWithCallback(request *DescribeLogServiceStatusRequest, callback func(response *DescribeLogServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLogServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeLogServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLogServiceStatusRequest is the request struct for api DescribeLogServiceStatus
type DescribeLogServiceStatusRequest struct {
	*requests.RpcRequest
	DomainNames     *[]string        `position:"Query" name:"DomainNames"  type:"Repeated"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	Region          string           `position:"Query" name:"Region"`
}

// DescribeLogServiceStatusResponse is the response struct for api DescribeLogServiceStatus
type DescribeLogServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId    string   `json:"RequestId" xml:"RequestId"`
	TotalCount   int      `json:"TotalCount" xml:"TotalCount"`
	DomainStatus []Status `json:"DomainStatus" xml:"DomainStatus"`
}

// CreateDescribeLogServiceStatusRequest creates a request to invoke DescribeLogServiceStatus API
func CreateDescribeLogServiceStatusRequest() (request *DescribeLogServiceStatusRequest) {
	request = &DescribeLogServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2019-09-10", "DescribeLogServiceStatus", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLogServiceStatusResponse creates a response to parse from DescribeLogServiceStatus response
func CreateDescribeLogServiceStatusResponse() (response *DescribeLogServiceStatusResponse) {
	response = &DescribeLogServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
