package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDomainConfig invokes the waf_openapi.DeleteDomainConfig API synchronously
func (client *Client) DeleteDomainConfig(request *DeleteDomainConfigRequest) (response *DeleteDomainConfigResponse, err error) {
	response = CreateDeleteDomainConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDomainConfigWithChan invokes the waf_openapi.DeleteDomainConfig API asynchronously
func (client *Client) DeleteDomainConfigWithChan(request *DeleteDomainConfigRequest) (<-chan *DeleteDomainConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteDomainConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDomainConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDomainConfigWithCallback invokes the waf_openapi.DeleteDomainConfig API asynchronously
func (client *Client) DeleteDomainConfigWithCallback(request *DeleteDomainConfigRequest, callback func(response *DeleteDomainConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDomainConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteDomainConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDomainConfigRequest is the request struct for api DeleteDomainConfig
type DeleteDomainConfigRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Domain     string `position:"Query" name:"Domain"`
	Lang       string `position:"Query" name:"Lang"`
	Region     string `position:"Query" name:"Region"`
}

// DeleteDomainConfigResponse is the response struct for api DeleteDomainConfig
type DeleteDomainConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDeleteDomainConfigRequest creates a request to invoke DeleteDomainConfig API
func CreateDeleteDomainConfigRequest() (request *DeleteDomainConfigRequest) {
	request = &DeleteDomainConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2018-01-17", "DeleteDomainConfig", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDomainConfigResponse creates a response to parse from DeleteDomainConfig response
func CreateDeleteDomainConfigResponse() (response *DeleteDomainConfigResponse) {
	response = &DeleteDomainConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
