package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAclRule invokes the waf_openapi.CreateAclRule API synchronously
func (client *Client) CreateAclRule(request *CreateAclRuleRequest) (response *CreateAclRuleResponse, err error) {
	response = CreateCreateAclRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAclRuleWithChan invokes the waf_openapi.CreateAclRule API asynchronously
func (client *Client) CreateAclRuleWithChan(request *CreateAclRuleRequest) (<-chan *CreateAclRuleResponse, <-chan error) {
	responseChan := make(chan *CreateAclRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAclRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAclRuleWithCallback invokes the waf_openapi.CreateAclRule API asynchronously
func (client *Client) CreateAclRuleWithCallback(request *CreateAclRuleRequest, callback func(response *CreateAclRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAclRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateAclRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAclRuleRequest is the request struct for api CreateAclRule
type CreateAclRuleRequest struct {
	*requests.RpcRequest
	Rules      string `position:"Query" name:"Rules"`
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Domain     string `position:"Query" name:"Domain"`
	Lang       string `position:"Query" name:"Lang"`
	Region     string `position:"Query" name:"Region"`
}

// CreateAclRuleResponse is the response struct for api CreateAclRule
type CreateAclRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreateAclRuleRequest creates a request to invoke CreateAclRule API
func CreateCreateAclRuleRequest() (request *CreateAclRuleRequest) {
	request = &CreateAclRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2018-01-17", "CreateAclRule", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAclRuleResponse creates a response to parse from CreateAclRule response
func CreateCreateAclRuleResponse() (response *CreateAclRuleResponse) {
	response = &CreateAclRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
