package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitAICaptionExtractionJob invokes the vod.SubmitAICaptionExtractionJob API synchronously
func (client *Client) SubmitAICaptionExtractionJob(request *SubmitAICaptionExtractionJobRequest) (response *SubmitAICaptionExtractionJobResponse, err error) {
	response = CreateSubmitAICaptionExtractionJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitAICaptionExtractionJobWithChan invokes the vod.SubmitAICaptionExtractionJob API asynchronously
func (client *Client) SubmitAICaptionExtractionJobWithChan(request *SubmitAICaptionExtractionJobRequest) (<-chan *SubmitAICaptionExtractionJobResponse, <-chan error) {
	responseChan := make(chan *SubmitAICaptionExtractionJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitAICaptionExtractionJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitAICaptionExtractionJobWithCallback invokes the vod.SubmitAICaptionExtractionJob API asynchronously
func (client *Client) SubmitAICaptionExtractionJobWithCallback(request *SubmitAICaptionExtractionJobRequest, callback func(response *SubmitAICaptionExtractionJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitAICaptionExtractionJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitAICaptionExtractionJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitAICaptionExtractionJobRequest is the request struct for api SubmitAICaptionExtractionJob
type SubmitAICaptionExtractionJobRequest struct {
	*requests.RpcRequest
	JobConfig    string `position:"Query" name:"JobConfig"`
	VideoId      string `position:"Query" name:"VideoId"`
	AIPipelineId string `position:"Query" name:"AIPipelineId"`
	UserData     string `position:"Query" name:"UserData"`
}

// SubmitAICaptionExtractionJobResponse is the response struct for api SubmitAICaptionExtractionJob
type SubmitAICaptionExtractionJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateSubmitAICaptionExtractionJobRequest creates a request to invoke SubmitAICaptionExtractionJob API
func CreateSubmitAICaptionExtractionJobRequest() (request *SubmitAICaptionExtractionJobRequest) {
	request = &SubmitAICaptionExtractionJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "SubmitAICaptionExtractionJob", "", "")
	request.Method = requests.POST
	return
}

// CreateSubmitAICaptionExtractionJobResponse creates a response to parse from SubmitAICaptionExtractionJob response
func CreateSubmitAICaptionExtractionJobResponse() (response *SubmitAICaptionExtractionJobResponse) {
	response = &SubmitAICaptionExtractionJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
