package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMediaDNADeleteJob invokes the vod.ListMediaDNADeleteJob API synchronously
func (client *Client) ListMediaDNADeleteJob(request *ListMediaDNADeleteJobRequest) (response *ListMediaDNADeleteJobResponse, err error) {
	response = CreateListMediaDNADeleteJobResponse()
	err = client.DoAction(request, response)
	return
}

// ListMediaDNADeleteJobWithChan invokes the vod.ListMediaDNADeleteJob API asynchronously
func (client *Client) ListMediaDNADeleteJobWithChan(request *ListMediaDNADeleteJobRequest) (<-chan *ListMediaDNADeleteJobResponse, <-chan error) {
	responseChan := make(chan *ListMediaDNADeleteJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMediaDNADeleteJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMediaDNADeleteJobWithCallback invokes the vod.ListMediaDNADeleteJob API asynchronously
func (client *Client) ListMediaDNADeleteJobWithCallback(request *ListMediaDNADeleteJobRequest, callback func(response *ListMediaDNADeleteJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMediaDNADeleteJobResponse
		var err error
		defer close(result)
		response, err = client.ListMediaDNADeleteJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMediaDNADeleteJobRequest is the request struct for api ListMediaDNADeleteJob
type ListMediaDNADeleteJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string `position:"Query" name:"OwnerAccount"`
	OwnerId              string `position:"Query" name:"OwnerId"`
	JobIds               string `position:"Query" name:"JobIds"`
}

// ListMediaDNADeleteJobResponse is the response struct for api ListMediaDNADeleteJob
type ListMediaDNADeleteJobResponse struct {
	*responses.BaseResponse
	RequestId        string                                  `json:"RequestId" xml:"RequestId"`
	NonExistAIJobIds NonExistAIJobIdsInListMediaDNADeleteJob `json:"NonExistAIJobIds" xml:"NonExistAIJobIds"`
	AIJobList        AIJobListInListMediaDNADeleteJob        `json:"AIJobList" xml:"AIJobList"`
}

// CreateListMediaDNADeleteJobRequest creates a request to invoke ListMediaDNADeleteJob API
func CreateListMediaDNADeleteJobRequest() (request *ListMediaDNADeleteJobRequest) {
	request = &ListMediaDNADeleteJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "ListMediaDNADeleteJob", "", "")
	request.Method = requests.POST
	return
}

// CreateListMediaDNADeleteJobResponse creates a response to parse from ListMediaDNADeleteJob response
func CreateListMediaDNADeleteJobResponse() (response *ListMediaDNADeleteJobResponse) {
	response = &ListMediaDNADeleteJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
