package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLetterSendJob invokes the vod.ListLetterSendJob API synchronously
func (client *Client) ListLetterSendJob(request *ListLetterSendJobRequest) (response *ListLetterSendJobResponse, err error) {
	response = CreateListLetterSendJobResponse()
	err = client.DoAction(request, response)
	return
}

// ListLetterSendJobWithChan invokes the vod.ListLetterSendJob API asynchronously
func (client *Client) ListLetterSendJobWithChan(request *ListLetterSendJobRequest) (<-chan *ListLetterSendJobResponse, <-chan error) {
	responseChan := make(chan *ListLetterSendJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLetterSendJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLetterSendJobWithCallback invokes the vod.ListLetterSendJob API asynchronously
func (client *Client) ListLetterSendJobWithCallback(request *ListLetterSendJobRequest, callback func(response *ListLetterSendJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLetterSendJobResponse
		var err error
		defer close(result)
		response, err = client.ListLetterSendJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLetterSendJobRequest is the request struct for api ListLetterSendJob
type ListLetterSendJobRequest struct {
	*requests.RpcRequest
	ToAddress   string `position:"Query" name:"ToAddress"`
	TemplateId  string `position:"Query" name:"TemplateId"`
	DetectionId string `position:"Query" name:"DetectionId"`
}

// ListLetterSendJobResponse is the response struct for api ListLetterSendJob
type ListLetterSendJobResponse struct {
	*responses.BaseResponse
	RequestId     string      `json:"RequestId" xml:"RequestId"`
	LetterJobList []LetterJob `json:"LetterJobList" xml:"LetterJobList"`
}

// CreateListLetterSendJobRequest creates a request to invoke ListLetterSendJob API
func CreateListLetterSendJobRequest() (request *ListLetterSendJobRequest) {
	request = &ListLetterSendJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "ListLetterSendJob", "", "")
	request.Method = requests.GET
	return
}

// CreateListLetterSendJobResponse creates a response to parse from ListLetterSendJob response
func CreateListLetterSendJobResponse() (response *ListLetterSendJobResponse) {
	response = &ListLetterSendJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
