package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDetectionTemplate invokes the vod.ListDetectionTemplate API synchronously
func (client *Client) ListDetectionTemplate(request *ListDetectionTemplateRequest) (response *ListDetectionTemplateResponse, err error) {
	response = CreateListDetectionTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ListDetectionTemplateWithChan invokes the vod.ListDetectionTemplate API asynchronously
func (client *Client) ListDetectionTemplateWithChan(request *ListDetectionTemplateRequest) (<-chan *ListDetectionTemplateResponse, <-chan error) {
	responseChan := make(chan *ListDetectionTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDetectionTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDetectionTemplateWithCallback invokes the vod.ListDetectionTemplate API asynchronously
func (client *Client) ListDetectionTemplateWithCallback(request *ListDetectionTemplateRequest, callback func(response *ListDetectionTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDetectionTemplateResponse
		var err error
		defer close(result)
		response, err = client.ListDetectionTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDetectionTemplateRequest is the request struct for api ListDetectionTemplate
type ListDetectionTemplateRequest struct {
	*requests.RpcRequest
	Period           string `position:"Query" name:"Period"`
	TemplateName     string `position:"Query" name:"TemplateName"`
	LetterTemplateId string `position:"Query" name:"LetterTemplateId"`
}

// ListDetectionTemplateResponse is the response struct for api ListDetectionTemplate
type ListDetectionTemplateResponse struct {
	*responses.BaseResponse
	RequestId             string              `json:"RequestId" xml:"RequestId"`
	DetectionTemplateList []DetectionTemplate `json:"DetectionTemplateList" xml:"DetectionTemplateList"`
}

// CreateListDetectionTemplateRequest creates a request to invoke ListDetectionTemplate API
func CreateListDetectionTemplateRequest() (request *ListDetectionTemplateRequest) {
	request = &ListDetectionTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "ListDetectionTemplate", "", "")
	request.Method = requests.GET
	return
}

// CreateListDetectionTemplateResponse creates a response to parse from ListDetectionTemplate response
func CreateListDetectionTemplateResponse() (response *ListDetectionTemplateResponse) {
	response = &ListDetectionTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
