package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDetectionJob invokes the vod.ListDetectionJob API synchronously
func (client *Client) ListDetectionJob(request *ListDetectionJobRequest) (response *ListDetectionJobResponse, err error) {
	response = CreateListDetectionJobResponse()
	err = client.DoAction(request, response)
	return
}

// ListDetectionJobWithChan invokes the vod.ListDetectionJob API asynchronously
func (client *Client) ListDetectionJobWithChan(request *ListDetectionJobRequest) (<-chan *ListDetectionJobResponse, <-chan error) {
	responseChan := make(chan *ListDetectionJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDetectionJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDetectionJobWithCallback invokes the vod.ListDetectionJob API asynchronously
func (client *Client) ListDetectionJobWithCallback(request *ListDetectionJobRequest, callback func(response *ListDetectionJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDetectionJobResponse
		var err error
		defer close(result)
		response, err = client.ListDetectionJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDetectionJobRequest is the request struct for api ListDetectionJob
type ListDetectionJobRequest struct {
	*requests.RpcRequest
	VideoId string `position:"Query" name:"VideoId"`
}

// ListDetectionJobResponse is the response struct for api ListDetectionJob
type ListDetectionJobResponse struct {
	*responses.BaseResponse
	RequestId        string         `json:"RequestId" xml:"RequestId"`
	DetectionJobList []DetectionJob `json:"DetectionJobList" xml:"DetectionJobList"`
}

// CreateListDetectionJobRequest creates a request to invoke ListDetectionJob API
func CreateListDetectionJobRequest() (request *ListDetectionJobRequest) {
	request = &ListDetectionJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "ListDetectionJob", "", "")
	request.Method = requests.GET
	return
}

// CreateListDetectionJobResponse creates a response to parse from ListDetectionJob response
func CreateListDetectionJobResponse() (response *ListDetectionJobResponse) {
	response = &ListDetectionJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
