package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMediaAuditResultTimeline invokes the vod.GetMediaAuditResultTimeline API synchronously
func (client *Client) GetMediaAuditResultTimeline(request *GetMediaAuditResultTimelineRequest) (response *GetMediaAuditResultTimelineResponse, err error) {
	response = CreateGetMediaAuditResultTimelineResponse()
	err = client.DoAction(request, response)
	return
}

// GetMediaAuditResultTimelineWithChan invokes the vod.GetMediaAuditResultTimeline API asynchronously
func (client *Client) GetMediaAuditResultTimelineWithChan(request *GetMediaAuditResultTimelineRequest) (<-chan *GetMediaAuditResultTimelineResponse, <-chan error) {
	responseChan := make(chan *GetMediaAuditResultTimelineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMediaAuditResultTimeline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMediaAuditResultTimelineWithCallback invokes the vod.GetMediaAuditResultTimeline API asynchronously
func (client *Client) GetMediaAuditResultTimelineWithCallback(request *GetMediaAuditResultTimelineRequest, callback func(response *GetMediaAuditResultTimelineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMediaAuditResultTimelineResponse
		var err error
		defer close(result)
		response, err = client.GetMediaAuditResultTimeline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMediaAuditResultTimelineRequest is the request struct for api GetMediaAuditResultTimeline
type GetMediaAuditResultTimelineRequest struct {
	*requests.RpcRequest
	MediaId string `position:"Query" name:"MediaId"`
}

// GetMediaAuditResultTimelineResponse is the response struct for api GetMediaAuditResultTimeline
type GetMediaAuditResultTimelineResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	MediaAuditResultTimeline MediaAuditResultTimeline `json:"MediaAuditResultTimeline" xml:"MediaAuditResultTimeline"`
}

// CreateGetMediaAuditResultTimelineRequest creates a request to invoke GetMediaAuditResultTimeline API
func CreateGetMediaAuditResultTimelineRequest() (request *GetMediaAuditResultTimelineRequest) {
	request = &GetMediaAuditResultTimelineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "GetMediaAuditResultTimeline", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMediaAuditResultTimelineResponse creates a response to parse from GetMediaAuditResultTimeline response
func CreateGetMediaAuditResultTimelineResponse() (response *GetMediaAuditResultTimelineResponse) {
	response = &GetMediaAuditResultTimelineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
