package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDetectionResult invokes the vod.GetDetectionResult API synchronously
func (client *Client) GetDetectionResult(request *GetDetectionResultRequest) (response *GetDetectionResultResponse, err error) {
	response = CreateGetDetectionResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetDetectionResultWithChan invokes the vod.GetDetectionResult API asynchronously
func (client *Client) GetDetectionResultWithChan(request *GetDetectionResultRequest) (<-chan *GetDetectionResultResponse, <-chan error) {
	responseChan := make(chan *GetDetectionResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDetectionResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDetectionResultWithCallback invokes the vod.GetDetectionResult API asynchronously
func (client *Client) GetDetectionResultWithCallback(request *GetDetectionResultRequest, callback func(response *GetDetectionResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDetectionResultResponse
		var err error
		defer close(result)
		response, err = client.GetDetectionResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDetectionResultRequest is the request struct for api GetDetectionResult
type GetDetectionResultRequest struct {
	*requests.RpcRequest
	CountByPage     requests.Integer `position:"Query" name:"CountByPage"`
	Desensitization requests.Boolean `position:"Query" name:"Desensitization"`
	JobId           string           `position:"Query" name:"JobId"`
	Page            requests.Integer `position:"Query" name:"Page"`
	Status          string           `position:"Query" name:"Status"`
}

// GetDetectionResultResponse is the response struct for api GetDetectionResult
type GetDetectionResultResponse struct {
	*responses.BaseResponse
	RequestId           string            `json:"RequestId" xml:"RequestId"`
	DetectionResultList []DetectionResult `json:"DetectionResultList" xml:"DetectionResultList"`
}

// CreateGetDetectionResultRequest creates a request to invoke GetDetectionResult API
func CreateGetDetectionResultRequest() (request *GetDetectionResultRequest) {
	request = &GetDetectionResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "GetDetectionResult", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDetectionResultResponse creates a response to parse from GetDetectionResult response
func CreateGetDetectionResultResponse() (response *GetDetectionResultResponse) {
	response = &GetDetectionResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
