package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDetectionJob invokes the vod.GetDetectionJob API synchronously
func (client *Client) GetDetectionJob(request *GetDetectionJobRequest) (response *GetDetectionJobResponse, err error) {
	response = CreateGetDetectionJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetDetectionJobWithChan invokes the vod.GetDetectionJob API asynchronously
func (client *Client) GetDetectionJobWithChan(request *GetDetectionJobRequest) (<-chan *GetDetectionJobResponse, <-chan error) {
	responseChan := make(chan *GetDetectionJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDetectionJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDetectionJobWithCallback invokes the vod.GetDetectionJob API asynchronously
func (client *Client) GetDetectionJobWithCallback(request *GetDetectionJobRequest, callback func(response *GetDetectionJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDetectionJobResponse
		var err error
		defer close(result)
		response, err = client.GetDetectionJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDetectionJobRequest is the request struct for api GetDetectionJob
type GetDetectionJobRequest struct {
	*requests.RpcRequest
	JobId string `position:"Query" name:"JobId"`
}

// GetDetectionJobResponse is the response struct for api GetDetectionJob
type GetDetectionJobResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	DetectionJob DetectionJob `json:"DetectionJob" xml:"DetectionJob"`
}

// CreateGetDetectionJobRequest creates a request to invoke GetDetectionJob API
func CreateGetDetectionJobRequest() (request *GetDetectionJobRequest) {
	request = &GetDetectionJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "GetDetectionJob", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDetectionJobResponse creates a response to parse from GetDetectionJob response
func CreateGetDetectionJobResponse() (response *GetDetectionJobResponse) {
	response = &GetDetectionJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
