package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableVodRealtimeLogDelivery invokes the vod.EnableVodRealtimeLogDelivery API synchronously
func (client *Client) EnableVodRealtimeLogDelivery(request *EnableVodRealtimeLogDeliveryRequest) (response *EnableVodRealtimeLogDeliveryResponse, err error) {
	response = CreateEnableVodRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// EnableVodRealtimeLogDeliveryWithChan invokes the vod.EnableVodRealtimeLogDelivery API asynchronously
func (client *Client) EnableVodRealtimeLogDeliveryWithChan(request *EnableVodRealtimeLogDeliveryRequest) (<-chan *EnableVodRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *EnableVodRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableVodRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableVodRealtimeLogDeliveryWithCallback invokes the vod.EnableVodRealtimeLogDelivery API asynchronously
func (client *Client) EnableVodRealtimeLogDeliveryWithCallback(request *EnableVodRealtimeLogDeliveryRequest, callback func(response *EnableVodRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableVodRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.EnableVodRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableVodRealtimeLogDeliveryRequest is the request struct for api EnableVodRealtimeLogDelivery
type EnableVodRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// EnableVodRealtimeLogDeliveryResponse is the response struct for api EnableVodRealtimeLogDelivery
type EnableVodRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableVodRealtimeLogDeliveryRequest creates a request to invoke EnableVodRealtimeLogDelivery API
func CreateEnableVodRealtimeLogDeliveryRequest() (request *EnableVodRealtimeLogDeliveryRequest) {
	request = &EnableVodRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "EnableVodRealtimeLogDelivery", "", "")
	request.Method = requests.GET
	return
}

// CreateEnableVodRealtimeLogDeliveryResponse creates a response to parse from EnableVodRealtimeLogDelivery response
func CreateEnableVodRealtimeLogDeliveryResponse() (response *EnableVodRealtimeLogDeliveryResponse) {
	response = &EnableVodRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
