package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodUserTags invokes the vod.DescribeVodUserTags API synchronously
func (client *Client) DescribeVodUserTags(request *DescribeVodUserTagsRequest) (response *DescribeVodUserTagsResponse, err error) {
	response = CreateDescribeVodUserTagsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodUserTagsWithChan invokes the vod.DescribeVodUserTags API asynchronously
func (client *Client) DescribeVodUserTagsWithChan(request *DescribeVodUserTagsRequest) (<-chan *DescribeVodUserTagsResponse, <-chan error) {
	responseChan := make(chan *DescribeVodUserTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodUserTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodUserTagsWithCallback invokes the vod.DescribeVodUserTags API asynchronously
func (client *Client) DescribeVodUserTagsWithCallback(request *DescribeVodUserTagsRequest, callback func(response *DescribeVodUserTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodUserTagsResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodUserTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodUserTagsRequest is the request struct for api DescribeVodUserTags
type DescribeVodUserTagsRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVodUserTagsResponse is the response struct for api DescribeVodUserTags
type DescribeVodUserTagsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Tags      []Tag  `json:"Tags" xml:"Tags"`
}

// CreateDescribeVodUserTagsRequest creates a request to invoke DescribeVodUserTags API
func CreateDescribeVodUserTagsRequest() (request *DescribeVodUserTagsRequest) {
	request = &DescribeVodUserTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodUserTags", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVodUserTagsResponse creates a response to parse from DescribeVodUserTags response
func CreateDescribeVodUserTagsResponse() (response *DescribeVodUserTagsResponse) {
	response = &DescribeVodUserTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
