package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodTranscodeData invokes the vod.DescribeVodTranscodeData API synchronously
func (client *Client) DescribeVodTranscodeData(request *DescribeVodTranscodeDataRequest) (response *DescribeVodTranscodeDataResponse, err error) {
	response = CreateDescribeVodTranscodeDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodTranscodeDataWithChan invokes the vod.DescribeVodTranscodeData API asynchronously
func (client *Client) DescribeVodTranscodeDataWithChan(request *DescribeVodTranscodeDataRequest) (<-chan *DescribeVodTranscodeDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodTranscodeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodTranscodeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodTranscodeDataWithCallback invokes the vod.DescribeVodTranscodeData API asynchronously
func (client *Client) DescribeVodTranscodeDataWithCallback(request *DescribeVodTranscodeDataRequest, callback func(response *DescribeVodTranscodeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodTranscodeDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodTranscodeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodTranscodeDataRequest is the request struct for api DescribeVodTranscodeData
type DescribeVodTranscodeDataRequest struct {
	*requests.RpcRequest
	StartTime     string           `position:"Query" name:"StartTime"`
	Storage       string           `position:"Query" name:"Storage"`
	EndTime       string           `position:"Query" name:"EndTime"`
	Specification string           `position:"Query" name:"Specification"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	Interval      string           `position:"Query" name:"Interval"`
	Region        string           `position:"Query" name:"Region"`
}

// DescribeVodTranscodeDataResponse is the response struct for api DescribeVodTranscodeData
type DescribeVodTranscodeDataResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	DataInterval  string        `json:"DataInterval" xml:"DataInterval"`
	TranscodeData TranscodeData `json:"TranscodeData" xml:"TranscodeData"`
}

// CreateDescribeVodTranscodeDataRequest creates a request to invoke DescribeVodTranscodeData API
func CreateDescribeVodTranscodeDataRequest() (request *DescribeVodTranscodeDataRequest) {
	request = &DescribeVodTranscodeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodTranscodeData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVodTranscodeDataResponse creates a response to parse from DescribeVodTranscodeData response
func CreateDescribeVodTranscodeDataResponse() (response *DescribeVodTranscodeDataResponse) {
	response = &DescribeVodTranscodeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
