package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainUsageData invokes the vod.DescribeVodDomainUsageData API synchronously
func (client *Client) DescribeVodDomainUsageData(request *DescribeVodDomainUsageDataRequest) (response *DescribeVodDomainUsageDataResponse, err error) {
	response = CreateDescribeVodDomainUsageDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainUsageDataWithChan invokes the vod.DescribeVodDomainUsageData API asynchronously
func (client *Client) DescribeVodDomainUsageDataWithChan(request *DescribeVodDomainUsageDataRequest) (<-chan *DescribeVodDomainUsageDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainUsageDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainUsageData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainUsageDataWithCallback invokes the vod.DescribeVodDomainUsageData API asynchronously
func (client *Client) DescribeVodDomainUsageDataWithCallback(request *DescribeVodDomainUsageDataRequest, callback func(response *DescribeVodDomainUsageDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainUsageDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainUsageData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainUsageDataRequest is the request struct for api DescribeVodDomainUsageData
type DescribeVodDomainUsageDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	Type       string           `position:"Query" name:"Type"`
	Area       string           `position:"Query" name:"Area"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Field      string           `position:"Query" name:"Field"`
}

// DescribeVodDomainUsageDataResponse is the response struct for api DescribeVodDomainUsageData
type DescribeVodDomainUsageDataResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	DomainName           string               `json:"DomainName" xml:"DomainName"`
	StartTime            string               `json:"StartTime" xml:"StartTime"`
	EndTime              string               `json:"EndTime" xml:"EndTime"`
	Type                 string               `json:"Type" xml:"Type"`
	Area                 string               `json:"Area" xml:"Area"`
	DataInterval         string               `json:"DataInterval" xml:"DataInterval"`
	UsageDataPerInterval UsageDataPerInterval `json:"UsageDataPerInterval" xml:"UsageDataPerInterval"`
}

// CreateDescribeVodDomainUsageDataRequest creates a request to invoke DescribeVodDomainUsageData API
func CreateDescribeVodDomainUsageDataRequest() (request *DescribeVodDomainUsageDataRequest) {
	request = &DescribeVodDomainUsageDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainUsageData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVodDomainUsageDataResponse creates a response to parse from DescribeVodDomainUsageData response
func CreateDescribeVodDomainUsageDataResponse() (response *DescribeVodDomainUsageDataResponse) {
	response = &DescribeVodDomainUsageDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
