package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainRealtimeLogDelivery invokes the vod.DescribeVodDomainRealtimeLogDelivery API synchronously
func (client *Client) DescribeVodDomainRealtimeLogDelivery(request *DescribeVodDomainRealtimeLogDeliveryRequest) (response *DescribeVodDomainRealtimeLogDeliveryResponse, err error) {
	response = CreateDescribeVodDomainRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainRealtimeLogDeliveryWithChan invokes the vod.DescribeVodDomainRealtimeLogDelivery API asynchronously
func (client *Client) DescribeVodDomainRealtimeLogDeliveryWithChan(request *DescribeVodDomainRealtimeLogDeliveryRequest) (<-chan *DescribeVodDomainRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainRealtimeLogDeliveryWithCallback invokes the vod.DescribeVodDomainRealtimeLogDelivery API asynchronously
func (client *Client) DescribeVodDomainRealtimeLogDeliveryWithCallback(request *DescribeVodDomainRealtimeLogDeliveryRequest, callback func(response *DescribeVodDomainRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainRealtimeLogDeliveryRequest is the request struct for api DescribeVodDomainRealtimeLogDelivery
type DescribeVodDomainRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVodDomainRealtimeLogDeliveryResponse is the response struct for api DescribeVodDomainRealtimeLogDelivery
type DescribeVodDomainRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Project   string `json:"Project" xml:"Project"`
	Region    string `json:"Region" xml:"Region"`
	Logstore  string `json:"Logstore" xml:"Logstore"`
	Status    string `json:"Status" xml:"Status"`
}

// CreateDescribeVodDomainRealtimeLogDeliveryRequest creates a request to invoke DescribeVodDomainRealtimeLogDelivery API
func CreateDescribeVodDomainRealtimeLogDeliveryRequest() (request *DescribeVodDomainRealtimeLogDeliveryRequest) {
	request = &DescribeVodDomainRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainRealtimeLogDelivery", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeVodDomainRealtimeLogDeliveryResponse creates a response to parse from DescribeVodDomainRealtimeLogDelivery response
func CreateDescribeVodDomainRealtimeLogDeliveryResponse() (response *DescribeVodDomainRealtimeLogDeliveryResponse) {
	response = &DescribeVodDomainRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
