package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDetectionTemplate invokes the vod.CreateDetectionTemplate API synchronously
func (client *Client) CreateDetectionTemplate(request *CreateDetectionTemplateRequest) (response *CreateDetectionTemplateResponse, err error) {
	response = CreateCreateDetectionTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDetectionTemplateWithChan invokes the vod.CreateDetectionTemplate API asynchronously
func (client *Client) CreateDetectionTemplateWithChan(request *CreateDetectionTemplateRequest) (<-chan *CreateDetectionTemplateResponse, <-chan error) {
	responseChan := make(chan *CreateDetectionTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDetectionTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDetectionTemplateWithCallback invokes the vod.CreateDetectionTemplate API asynchronously
func (client *Client) CreateDetectionTemplateWithCallback(request *CreateDetectionTemplateRequest, callback func(response *CreateDetectionTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDetectionTemplateResponse
		var err error
		defer close(result)
		response, err = client.CreateDetectionTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDetectionTemplateRequest is the request struct for api CreateDetectionTemplate
type CreateDetectionTemplateRequest struct {
	*requests.RpcRequest
	Period              string           `position:"Query" name:"Period"`
	AutoEvidenceSuspect requests.Boolean `position:"Query" name:"AutoEvidenceSuspect"`
	LetterSendTime      string           `position:"Query" name:"LetterSendTime"`
	AutoLetterSuspect   requests.Boolean `position:"Query" name:"AutoLetterSuspect"`
	Platform            string           `position:"Query" name:"Platform"`
	AutoLetter          requests.Boolean `position:"Query" name:"AutoLetter"`
	TemplateName        string           `position:"Query" name:"TemplateName"`
	AutoEvidence        requests.Boolean `position:"Query" name:"AutoEvidence"`
	LetterTemplateId    string           `position:"Query" name:"LetterTemplateId"`
}

// CreateDetectionTemplateResponse is the response struct for api CreateDetectionTemplate
type CreateDetectionTemplateResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	DetectionTemplate DetectionTemplate `json:"DetectionTemplate" xml:"DetectionTemplate"`
}

// CreateCreateDetectionTemplateRequest creates a request to invoke CreateDetectionTemplate API
func CreateCreateDetectionTemplateRequest() (request *CreateDetectionTemplateRequest) {
	request = &CreateDetectionTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "CreateDetectionTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDetectionTemplateResponse creates a response to parse from CreateDetectionTemplate response
func CreateCreateDetectionTemplateResponse() (response *CreateDetectionTemplateResponse) {
	response = &CreateDetectionTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
