package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAudit invokes the vod.CreateAudit API synchronously
func (client *Client) CreateAudit(request *CreateAuditRequest) (response *CreateAuditResponse, err error) {
	response = CreateCreateAuditResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAuditWithChan invokes the vod.CreateAudit API asynchronously
func (client *Client) CreateAuditWithChan(request *CreateAuditRequest) (<-chan *CreateAuditResponse, <-chan error) {
	responseChan := make(chan *CreateAuditResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAudit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAuditWithCallback invokes the vod.CreateAudit API asynchronously
func (client *Client) CreateAuditWithCallback(request *CreateAuditRequest, callback func(response *CreateAuditResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAuditResponse
		var err error
		defer close(result)
		response, err = client.CreateAudit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAuditRequest is the request struct for api CreateAudit
type CreateAuditRequest struct {
	*requests.RpcRequest
	AuditContent string `position:"Query" name:"AuditContent"`
}

// CreateAuditResponse is the response struct for api CreateAudit
type CreateAuditResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateAuditRequest creates a request to invoke CreateAudit API
func CreateCreateAuditRequest() (request *CreateAuditRequest) {
	request = &CreateAuditRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "CreateAudit", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateAuditResponse creates a response to parse from CreateAudit response
func CreateCreateAuditResponse() (response *CreateAuditResponse) {
	response = &CreateAuditResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
