package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelUrlUploadJobs invokes the vod.CancelUrlUploadJobs API synchronously
func (client *Client) CancelUrlUploadJobs(request *CancelUrlUploadJobsRequest) (response *CancelUrlUploadJobsResponse, err error) {
	response = CreateCancelUrlUploadJobsResponse()
	err = client.DoAction(request, response)
	return
}

// CancelUrlUploadJobsWithChan invokes the vod.CancelUrlUploadJobs API asynchronously
func (client *Client) CancelUrlUploadJobsWithChan(request *CancelUrlUploadJobsRequest) (<-chan *CancelUrlUploadJobsResponse, <-chan error) {
	responseChan := make(chan *CancelUrlUploadJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelUrlUploadJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelUrlUploadJobsWithCallback invokes the vod.CancelUrlUploadJobs API asynchronously
func (client *Client) CancelUrlUploadJobsWithCallback(request *CancelUrlUploadJobsRequest, callback func(response *CancelUrlUploadJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelUrlUploadJobsResponse
		var err error
		defer close(result)
		response, err = client.CancelUrlUploadJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelUrlUploadJobsRequest is the request struct for api CancelUrlUploadJobs
type CancelUrlUploadJobsRequest struct {
	*requests.RpcRequest
	JobIds     string `position:"Query" name:"JobIds"`
	UploadUrls string `position:"Query" name:"UploadUrls"`
}

// CancelUrlUploadJobsResponse is the response struct for api CancelUrlUploadJobs
type CancelUrlUploadJobsResponse struct {
	*responses.BaseResponse
	RequestId    string   `json:"RequestId" xml:"RequestId"`
	CanceledJobs []string `json:"CanceledJobs" xml:"CanceledJobs"`
	NonExists    []string `json:"NonExists" xml:"NonExists"`
}

// CreateCancelUrlUploadJobsRequest creates a request to invoke CancelUrlUploadJobs API
func CreateCancelUrlUploadJobsRequest() (request *CancelUrlUploadJobsRequest) {
	request = &CancelUrlUploadJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "CancelUrlUploadJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateCancelUrlUploadJobsResponse creates a response to parse from CancelUrlUploadJobs response
func CreateCancelUrlUploadJobsResponse() (response *CancelUrlUploadJobsResponse) {
	response = &CancelUrlUploadJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
