package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachAppPolicyToIdentity invokes the vod.AttachAppPolicyToIdentity API synchronously
func (client *Client) AttachAppPolicyToIdentity(request *AttachAppPolicyToIdentityRequest) (response *AttachAppPolicyToIdentityResponse, err error) {
	response = CreateAttachAppPolicyToIdentityResponse()
	err = client.DoAction(request, response)
	return
}

// AttachAppPolicyToIdentityWithChan invokes the vod.AttachAppPolicyToIdentity API asynchronously
func (client *Client) AttachAppPolicyToIdentityWithChan(request *AttachAppPolicyToIdentityRequest) (<-chan *AttachAppPolicyToIdentityResponse, <-chan error) {
	responseChan := make(chan *AttachAppPolicyToIdentityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachAppPolicyToIdentity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachAppPolicyToIdentityWithCallback invokes the vod.AttachAppPolicyToIdentity API asynchronously
func (client *Client) AttachAppPolicyToIdentityWithCallback(request *AttachAppPolicyToIdentityRequest, callback func(response *AttachAppPolicyToIdentityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachAppPolicyToIdentityResponse
		var err error
		defer close(result)
		response, err = client.AttachAppPolicyToIdentity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachAppPolicyToIdentityRequest is the request struct for api AttachAppPolicyToIdentity
type AttachAppPolicyToIdentityRequest struct {
	*requests.RpcRequest
	PolicyNames         string `position:"Query" name:"PolicyNames"`
	ResourceRealOwnerId string `position:"Query" name:"ResourceRealOwnerId"`
	IdentityName        string `position:"Query" name:"IdentityName"`
	IdentityType        string `position:"Query" name:"IdentityType"`
	AppId               string `position:"Query" name:"AppId"`
}

// AttachAppPolicyToIdentityResponse is the response struct for api AttachAppPolicyToIdentity
type AttachAppPolicyToIdentityResponse struct {
	*responses.BaseResponse
	RequestId           string   `json:"RequestId" xml:"RequestId"`
	NonExistPolicyNames []string `json:"NonExistPolicyNames" xml:"NonExistPolicyNames"`
	FailedPolicyNames   []string `json:"FailedPolicyNames" xml:"FailedPolicyNames"`
}

// CreateAttachAppPolicyToIdentityRequest creates a request to invoke AttachAppPolicyToIdentity API
func CreateAttachAppPolicyToIdentityRequest() (request *AttachAppPolicyToIdentityRequest) {
	request = &AttachAppPolicyToIdentityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "AttachAppPolicyToIdentity", "", "")
	request.Method = requests.POST
	return
}

// CreateAttachAppPolicyToIdentityResponse creates a response to parse from AttachAppPolicyToIdentity response
func CreateAttachAppPolicyToIdentityResponse() (response *AttachAppPolicyToIdentityResponse) {
	response = &AttachAppPolicyToIdentityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
