package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SuperResolveVideo invokes the videoenhan.SuperResolveVideo API synchronously
func (client *Client) SuperResolveVideo(request *SuperResolveVideoRequest) (response *SuperResolveVideoResponse, err error) {
	response = CreateSuperResolveVideoResponse()
	err = client.DoAction(request, response)
	return
}

// SuperResolveVideoWithChan invokes the videoenhan.SuperResolveVideo API asynchronously
func (client *Client) SuperResolveVideoWithChan(request *SuperResolveVideoRequest) (<-chan *SuperResolveVideoResponse, <-chan error) {
	responseChan := make(chan *SuperResolveVideoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SuperResolveVideo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SuperResolveVideoWithCallback invokes the videoenhan.SuperResolveVideo API asynchronously
func (client *Client) SuperResolveVideoWithCallback(request *SuperResolveVideoRequest, callback func(response *SuperResolveVideoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SuperResolveVideoResponse
		var err error
		defer close(result)
		response, err = client.SuperResolveVideo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SuperResolveVideoRequest is the request struct for api SuperResolveVideo
type SuperResolveVideoRequest struct {
	*requests.RpcRequest
	BitRate  requests.Integer `position:"Body" name:"BitRate"`
	Async    requests.Boolean `position:"Body" name:"Async"`
	VideoUrl string           `position:"Body" name:"VideoUrl"`
}

// SuperResolveVideoResponse is the response struct for api SuperResolveVideo
type SuperResolveVideoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSuperResolveVideoRequest creates a request to invoke SuperResolveVideo API
func CreateSuperResolveVideoRequest() (request *SuperResolveVideoRequest) {
	request = &SuperResolveVideoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "SuperResolveVideo", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSuperResolveVideoResponse creates a response to parse from SuperResolveVideo response
func CreateSuperResolveVideoResponse() (response *SuperResolveVideoResponse) {
	response = &SuperResolveVideoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
