package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InitUserAlertResource invokes the sls.InitUserAlertResource API synchronously
func (client *Client) InitUserAlertResource(request *InitUserAlertResourceRequest) (response *InitUserAlertResourceResponse, err error) {
	response = CreateInitUserAlertResourceResponse()
	err = client.DoAction(request, response)
	return
}

// InitUserAlertResourceWithChan invokes the sls.InitUserAlertResource API asynchronously
func (client *Client) InitUserAlertResourceWithChan(request *InitUserAlertResourceRequest) (<-chan *InitUserAlertResourceResponse, <-chan error) {
	responseChan := make(chan *InitUserAlertResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InitUserAlertResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InitUserAlertResourceWithCallback invokes the sls.InitUserAlertResource API asynchronously
func (client *Client) InitUserAlertResourceWithCallback(request *InitUserAlertResourceRequest, callback func(response *InitUserAlertResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InitUserAlertResourceResponse
		var err error
		defer close(result)
		response, err = client.InitUserAlertResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InitUserAlertResourceRequest is the request struct for api InitUserAlertResource
type InitUserAlertResourceRequest struct {
	*requests.RpcRequest
	App      string `position:"Body" name:"App"`
	Language string `position:"Body" name:"Language"`
	Region   string `position:"Body" name:"Region"`
}

// InitUserAlertResourceResponse is the response struct for api InitUserAlertResource
type InitUserAlertResourceResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateInitUserAlertResourceRequest creates a request to invoke InitUserAlertResource API
func CreateInitUserAlertResourceRequest() (request *InitUserAlertResourceRequest) {
	request = &InitUserAlertResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "InitUserAlertResource", "", "")
	request.Method = requests.POST
	return
}

// CreateInitUserAlertResourceResponse creates a response to parse from InitUserAlertResource response
func CreateInitUserAlertResourceResponse() (response *InitUserAlertResourceResponse) {
	response = &InitUserAlertResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
