package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveBackendServers invokes the slb.RemoveBackendServers API synchronously
func (client *Client) RemoveBackendServers(request *RemoveBackendServersRequest) (response *RemoveBackendServersResponse, err error) {
	response = CreateRemoveBackendServersResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveBackendServersWithChan invokes the slb.RemoveBackendServers API asynchronously
func (client *Client) RemoveBackendServersWithChan(request *RemoveBackendServersRequest) (<-chan *RemoveBackendServersResponse, <-chan error) {
	responseChan := make(chan *RemoveBackendServersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveBackendServers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveBackendServersWithCallback invokes the slb.RemoveBackendServers API asynchronously
func (client *Client) RemoveBackendServersWithCallback(request *RemoveBackendServersRequest, callback func(response *RemoveBackendServersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveBackendServersResponse
		var err error
		defer close(result)
		response, err = client.RemoveBackendServers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveBackendServersRequest is the request struct for api RemoveBackendServers
type RemoveBackendServersRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BackendServers       string           `position:"Query" name:"BackendServers"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Tags                 string           `position:"Query" name:"Tags"`
	LoadBalancerId       string           `position:"Query" name:"LoadBalancerId"`
}

// RemoveBackendServersResponse is the response struct for api RemoveBackendServers
type RemoveBackendServersResponse struct {
	*responses.BaseResponse
	RequestId      string                               `json:"RequestId" xml:"RequestId"`
	LoadBalancerId string                               `json:"LoadBalancerId" xml:"LoadBalancerId"`
	BackendServers BackendServersInRemoveBackendServers `json:"BackendServers" xml:"BackendServers"`
}

// CreateRemoveBackendServersRequest creates a request to invoke RemoveBackendServers API
func CreateRemoveBackendServersRequest() (request *RemoveBackendServersRequest) {
	request = &RemoveBackendServersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "RemoveBackendServers", "slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveBackendServersResponse creates a response to parse from RemoveBackendServers response
func CreateRemoveBackendServersResponse() (response *RemoveBackendServersResponse) {
	response = &RemoveBackendServersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
