package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExpandCacheDisk invokes the sgw.ExpandCacheDisk API synchronously
func (client *Client) ExpandCacheDisk(request *ExpandCacheDiskRequest) (response *ExpandCacheDiskResponse, err error) {
	response = CreateExpandCacheDiskResponse()
	err = client.DoAction(request, response)
	return
}

// ExpandCacheDiskWithChan invokes the sgw.ExpandCacheDisk API asynchronously
func (client *Client) ExpandCacheDiskWithChan(request *ExpandCacheDiskRequest) (<-chan *ExpandCacheDiskResponse, <-chan error) {
	responseChan := make(chan *ExpandCacheDiskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExpandCacheDisk(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExpandCacheDiskWithCallback invokes the sgw.ExpandCacheDisk API asynchronously
func (client *Client) ExpandCacheDiskWithCallback(request *ExpandCacheDiskRequest, callback func(response *ExpandCacheDiskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExpandCacheDiskResponse
		var err error
		defer close(result)
		response, err = client.ExpandCacheDisk(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExpandCacheDiskRequest is the request struct for api ExpandCacheDisk
type ExpandCacheDiskRequest struct {
	*requests.RpcRequest
	LocalFilePath string           `position:"Query" name:"LocalFilePath"`
	NewSizeInGB   requests.Integer `position:"Query" name:"NewSizeInGB"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	GatewayId     string           `position:"Query" name:"GatewayId"`
}

// ExpandCacheDiskResponse is the response struct for api ExpandCacheDisk
type ExpandCacheDiskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
	BuyURL    string `json:"BuyURL" xml:"BuyURL"`
}

// CreateExpandCacheDiskRequest creates a request to invoke ExpandCacheDisk API
func CreateExpandCacheDiskRequest() (request *ExpandCacheDiskRequest) {
	request = &ExpandCacheDiskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ExpandCacheDisk", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExpandCacheDiskResponse creates a response to parse from ExpandCacheDisk response
func CreateExpandCacheDiskResponse() (response *ExpandCacheDiskResponse) {
	response = &ExpandCacheDiskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
